//
// C++ Interface: ipackage
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __NAPT_IPACKAGE_H_2005_12_26
#define __NAPT_IPACKAGE_H_2005_12_26

#include <qstring.h>

using namespace std;

namespace NApt 
{

/**
@author Benjamin Mesing
*/
class IPackage
{
public:
	enum InstalledState
	{
		NOT_INSTALLED,
		UPGRADABLE,
		INSTALLED
	};
    IPackage() = default;
    virtual ~IPackage() = default;
	virtual QString name() const = 0;
	virtual QString architecture() const = 0;
    virtual QString availableVersion() const = 0;
    virtual QString installedVersion() const = 0;
	virtual InstalledState installedState() const = 0;
	
	/** This should be filled with the first line of the description. */
	virtual QString shortDescription() const = 0;
};



}

#endif	// __NAPT_IPACKAGE_H_2005_12_26
