/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.parser;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.web3d.util.HashSet;
import org.web3d.vrml.parser.FactoryConfigurationError;
import org.web3d.vrml.sav.SAVNotSupportedException;
import org.web3d.vrml.sav.VRMLReader;

public abstract class VRMLParserFactory {
    public static final String FACTORY_CLASS_PROP = "org.web3d.vrml.parser.file.factory";
    public static final String VRML_FEATURE = "VRML-utf8";
    public static final String X3D_FEATURE = "X3D-utf8";
    public static final String REQUIRE_VERSION_PROP = "Required-Version";
    public static final String REQUIRE_FORMAT_PROP = "Required-Format";
    private static HashSet validProperties;
    private static final String DEFAULT_FACTORY = "org.web3d.parser.DefaultVRMLParserFactory";
    protected Map propertyMap = new HashMap();

    protected VRMLParserFactory() {
        validProperties = new HashSet(2);
        validProperties.add(REQUIRE_VERSION_PROP);
        validProperties.add(REQUIRE_FORMAT_PROP);
    }

    public static VRMLParserFactory newVRMLParserFactory() throws FactoryConfigurationError {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(VRMLParserFactory.FACTORY_CLASS_PROP, VRMLParserFactory.DEFAULT_FACTORY);
            }
        });
        VRMLParserFactory vRMLParserFactory = null;
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            vRMLParserFactory = (VRMLParserFactory)obj;
        }
        catch (Exception exception) {
            throw new FactoryConfigurationError(exception, "Couldn't create factory class " + string);
        }
        return vRMLParserFactory;
    }

    public abstract VRMLReader newVRMLReader();

    public Object getProperty(String string) throws SAVNotSupportedException {
        if (!validProperties.contains(string)) {
            throw new SAVNotSupportedException("Unknown property: " + string);
        }
        return this.propertyMap.get(string);
    }

    public void setProperty(String string, Object object) throws SAVNotSupportedException {
        if (!validProperties.contains(string)) {
            throw new SAVNotSupportedException("Unknown property: " + string);
        }
        this.propertyMap.put(string, object);
    }

    public abstract boolean hasFeature(String var1, String var2);
}

