/* Copyright (c) 2000, 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA */

#include "mysys_priv.h"

const char *test_names[]=
{
  "/usr/my/include/srclib/myfunc/dbug/test",
  "test",
  "dbug/test",
  "/usr/my/srclib/myfunc/dbug/test",
  "/usr/monty/oldcopy/jazz/setupp.frm",
  "~/monty.tst",
  "~/dbug/monty.tst",
  "./hejsan",
  "./dbug/test",
  "../dbug/test",
  "../myfunc/test",
  "../../monty/rutedit",
  "/usr/monty//usr/monty/rutedit",
  "/usr/./monty/rutedit",
  "/usr/my/../monty/rutedit",
  "/usr/my/~/rutedit",
  "~/../my",
  "~/../my/srclib/myfunc/test",
  "~/../my/srclib/myfunc/./dbug/test",
  "/../usr/my/srclib/dbug",
  "c/../my",
  "/c/../my",
  NullS,
};

int main(int argc __attribute__((unused)), char **argv)
{
  const char **pos;
  char buff[FN_REFLEN],buff2[FN_REFLEN];
  DBUG_ENTER ("main");
  DBUG_PROCESS (argv[0]);
  MY_INIT(argv[0]);

  if (argv[1] && argv[1][1] == '#')
    DBUG_PUSH(argv[1]+2);

  for (pos=test_names; *pos ; pos++)
  {
    printf("org :   '%s'\n",*pos);
    printf("pack:   '%s'\n",fn_format(buff,*pos,"","",8));
    printf("unpack: '%s'\n",fn_format(buff2,*pos,"","",4));
    unpack_filename(buff,buff);
    if (strcmp(buff,buff2) != 0)
    {
      printf("error on cmp: '%s' != '%s'\n",buff,buff2);
    }
    puts("");
  }
  DBUG_RETURN(0);
}
