/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "denominationidee.h"

Resultat denominationidee_initialisation(TRAVAIL(DenominationIdee) denominationidee)
{
	/* Cre une dnomination d'ide vide.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
	 * mmoire.
	 */
	if((S_T(denominationidee)=(STOCKAGE(DenominationIdee))(malloc(SIZEOF(CONTENEUR(DenominationIdee)))))==NULL)
		return RESULTAT_ERREUR_MEMOIRE;
	CHAMP(denominationidee , type)=IDEE_VIDE;
	CHAMP(denominationidee , reference)=NULL;
	return RESULTAT_OK;
}

Resultat denominationidee_definition_ideepresente(TRAVAIL(DenominationIdee) denominationidee , TRAVAIL_SCALAIRE(IdIdee) ididee , TRAVAIL(Flux) reference)
{
	/* Dfinit une dnomination d'ide prsente.
	 * Renvoie RESULTAT_ERREUR si denominationidee est NULL.
	 * Renvoie RESULTAT_ERREUR_DOMAINE si la dnomination n'tait pas vide.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
	 * mmoire.
	 */
	DEBUTZONESECURISEE
	if(S_T(denominationidee)==NULL)
		return RESULTAT_ERREUR;
	if(CHAMP(denominationidee , type)!=IDEE_VIDE)
		return RESULTAT_ERREUR_DOMAINE;
	CHAMP(denominationidee , type)=IDEE_PRESENTE;
	CHAMP_STOCKAGE_(CHAMP(denominationidee , denomination) , idideepresente)=S_T_(ididee);
	SECURISE(flux_texte(reference,R_S_(CHAMP(denominationidee , reference))));
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat denominationidee_definition_ideemanquante(TRAVAIL(DenominationIdee) denominationidee , TRAVAIL_SCALAIRE(Indice) indice , TRAVAIL(Flux) reference)
{
	/* Dfinit une dnomination d'ide manquante.
	 * Renvoie RESULTAT_ERREUR si denominationidee est NULL.
	 * Renvoie RESULTAT_ERREUR_DOMAINE si la dnomination n'tait pas vide.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
	 * mmoire.
	 */
	DEBUTZONESECURISEE
	if(S_T(denominationidee)==NULL)
		return RESULTAT_ERREUR;
	if(CHAMP(denominationidee , type)!=IDEE_VIDE)
		return RESULTAT_ERREUR_DOMAINE;
	CHAMP(denominationidee , type)=IDEE_MANQUANTE;
	CHAMP_STOCKAGE_(CHAMP(denominationidee , denomination) , indicemanquante)=S_T_(indice);
	SECURISE(flux_reference_manquante(reference,indice,R_S_(CHAMP(denominationidee , reference))));
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat denominationidee_definition_ideegenerique(TRAVAIL(DenominationIdee) denominationidee , TRAVAIL_SCALAIRE(Chaine) referenceparente , TRAVAIL(Flux) reference)
{
	/* Dfinit une dnomination d'ide gnrique.
	 * Renvoie RESULTAT_ERREUR si denominationidee est NULL.
	 * Renvoie RESULTAT_ERREUR_DOMAINE si la dnomination n'tait pas vide.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
	 * mmoire.
	 */
	DEBUTZONESECURISEE
	if(S_T(denominationidee)==NULL)
		return RESULTAT_ERREUR;
	if(CHAMP(denominationidee , type)!=IDEE_VIDE)
		return RESULTAT_ERREUR_DOMAINE;
	CHAMP(denominationidee , type)=IDEE_GENERIQUE;
	if((CHAMP_STOCKAGE_(CHAMP(denominationidee , denomination) , referenceparentegenerique)=(STOCKAGE_SCALAIRE(Chaine))(strdup((char*)(referenceparente))))==NULL)
		return RESULTAT_ERREUR_MEMOIRE;
	SECURISE(flux_reference_generique(reference,referenceparente,R_S_(CHAMP(denominationidee , reference))));
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat denominationidee_definition_ideeracine(TRAVAIL(DenominationIdee) denominationidee)
{
	/* Dfinit une dnomination d'ide racine.
	 * Renvoie RESULTAT_ERREUR si denominationidee est NULL.
	 * Renvoie RESULTAT_ERREUR_DOMAINE si la dnomination n'tait pas vide.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
	 * mmoire.
	 */
	if(S_T(denominationidee)==NULL)
		return RESULTAT_ERREUR;
	if(CHAMP(denominationidee , type)!=IDEE_VIDE)
		return RESULTAT_ERREUR_DOMAINE;
	CHAMP(denominationidee , type)=IDEE_RACINE;
	CHAMP(denominationidee , reference)=NULL;
	return RESULTAT_OK;
}

Resultat denominationidee_vide(TRAVAIL(DenominationIdee) denominationidee , REFERENCE_SCALAIRE(Booleen) vide)
{
	/* Renvoie VRAI si la dnomination d'ide est vide, ou non.
	 * Renvoie RESULTAT_ERREUR si denominationidee est NULL.
	 */
	if(S_T(denominationidee)==NULL)
		return RESULTAT_ERREUR;
	T_R_(vide)=(T_S_(CHAMP(denominationidee , type))==T_S_(IDEE_VIDE));
	return RESULTAT_OK;
}

Resultat denominationidee_lecture(TRAVAIL(DenominationIdee) denominationidee , REFERENCE_SCALAIRE(TypeIdee) type , REFERENCE_SCALAIRE(IdIdee) ididee , REFERENCE_SCALAIRE(Indice) indice , REFERENCE_SCALAIRE(Chaine) referenceparente , REFERENCE_SCALAIRE(Chaine) reference)
{
	/* Lit une dnomination d'ide. Le type est renvoy, et les paramtres
	 * suivant donne la dnomination correspondant au type renvoy.
	 * Dans le cas o la chaine est renvoye, il n'y a pas besoin
	 * de la librer.
	 * Enfin, la fonction renvoie la rfrence exacte de l'ide
	 * ainsi dnome. Cette chaine n'a pas  tre libre.
	 * Renvoie RESULTAT_ERREUR si denominationidee est NULL.
	 * Renvoie RESULTAT_ERREUR_DOMAINE si la dnomination tait vide.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
	 * mmoire.
	 */
	if(S_T(denominationidee)==NULL)
		return RESULTAT_ERREUR;
	T_R_(type)=T_S_(CHAMP(denominationidee , type));
	T_R_(reference)=T_S_(CHAMP(denominationidee , reference));
	switch(T_S_(CHAMP(denominationidee , type)))
	{
		case T_S_(IDEE_PRESENTE):
			T_R_(ididee)=T_S_(CHAMP_STOCKAGE_(CHAMP(denominationidee , denomination) , idideepresente));
			break;
		case T_S_(IDEE_MANQUANTE):
			T_R_(indice)=T_S_(CHAMP_STOCKAGE_(CHAMP(denominationidee , denomination) , indicemanquante));
			break;
		case T_S_(IDEE_GENERIQUE):
			T_R_(referenceparente)=T_S_(CHAMP_STOCKAGE_(CHAMP(denominationidee , denomination) , referenceparentegenerique));
			break;
		case T_S_(IDEE_RACINE):
			break;
		case T_S_(IDEE_VIDE):
		default:
			return RESULTAT_ERREUR_DOMAINE;
			break;
	}
	return RESULTAT_OK;
}

Resultat denominationidee_lecture_reference(TRAVAIL(DenominationIdee) denominationidee , REFERENCE_SCALAIRE(Chaine) reference)
{
	/* Lit la rfrence d'une dnomination d'ide. Enfin, la fonction
	 * renvoie la rfrence exacte de l'ide ainsi dnome.
	 * Cette chaine n'a pas  tre libre.
	 * Renvoie RESULTAT_ERREUR si denominationidee est NULL.
	 * Renvoie RESULTAT_ERREUR_DOMAINE si la dnomination tait vide.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
	 * mmoire.
	 */
	if(S_T(denominationidee)==NULL)
		return RESULTAT_ERREUR;
	T_R_(reference)=T_S_(CHAMP(denominationidee , reference));
	return RESULTAT_OK;
}

Resultat denominationidee_copie(TRAVAIL(DenominationIdee) denominationidee , TRAVAIL(DenominationIdee) copie)
{
	/* Ralise une copie de la dnomination.
	 * Si la copie tait non vide, elle est dtruite
	 * avant la copie.
	 * Renvoie RESULTAT_ERREUR si denominationidee est NULL.
	 * Renvoie RESULTAT_ERREUR_DOMAINE si la dnomination tait vide.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
	 * mmoire.
	 */
	DEBUTZONESECURISEE
	if(S_T(denominationidee)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(denominationidee_destruction(copie));
	SECURISE(denominationidee_initialisation(copie));
	CHAMP(copie , type)=CHAMP(denominationidee , type);
	switch(T_S_(CHAMP(denominationidee , type)))
	{
		case T_S_(IDEE_PRESENTE):
			CHAMP_STOCKAGE_(CHAMP(copie , denomination) , idideepresente)=CHAMP_STOCKAGE_(CHAMP(denominationidee , denomination) , idideepresente);
			break;
		case T_S_(IDEE_MANQUANTE):
			CHAMP_STOCKAGE_(CHAMP(copie , denomination) , indicemanquante)=CHAMP_STOCKAGE_(CHAMP(denominationidee , denomination) , indicemanquante);
			break;
		case T_S_(IDEE_GENERIQUE):
			if(((CHAMP_STOCKAGE_(CHAMP(copie , denomination) , referenceparentegenerique))=(STOCKAGE_SCALAIRE(Chaine))(strdup((char*)(T_S_(CHAMP_STOCKAGE_(CHAMP(denominationidee , denomination) , referenceparentegenerique))))))==NULL)
				return RESULTAT_ERREUR_MEMOIRE;
			break;
		case T_S_(IDEE_RACINE):
			break;
		case T_S_(IDEE_VIDE):
		default:
			return RESULTAT_ERREUR_DOMAINE;
			break;
	}
	if(CHAMP(denominationidee , reference)==NULL)
	{
		CHAMP(copie , reference)=NULL;
	}
	else
	{
		if((CHAMP(copie , reference)=(STOCKAGE_SCALAIRE(Chaine))(strdup((char*)(T_S_(CHAMP(denominationidee , reference))))))==NULL)
			return RESULTAT_ERREUR_MEMOIRE;
	}
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat denominationidee_destruction(TRAVAIL(DenominationIdee) denominationidee)
{
	/* Dtruit une dnomination d'ide.
	 */
	if(S_T(denominationidee)==NULL)
		return RESULTAT_OK;
	switch(CHAMP(denominationidee , type))
	{
		case T_S_(IDEE_PRESENTE):
		case T_S_(IDEE_MANQUANTE):
			break;
		case T_S_(IDEE_GENERIQUE):
			free(CHAMP_STOCKAGE_(CHAMP(denominationidee , denomination) , referenceparentegenerique));
			break;
		case T_S_(IDEE_RACINE):
			break;
		case T_S_(IDEE_VIDE):
		default:
			return RESULTAT_ERREUR_DOMAINE;
			break;
	}
	if(CHAMP(denominationidee , reference)!=NULL)
		free(CHAMP(denominationidee , reference));
	free(S_T(denominationidee));
	S_T(denominationidee)=NULL;
	return RESULTAT_OK;
}

