------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--                 T E S T . C O N T R O L L E R . I M P L                  --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--           Copyright (C) 2008, Free Software Foundation, Inc.             --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 51 Franklin Street, Fifth    --
-- Floor, Boston, MA 02111-1301, USA.                                       --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

with CORBA;
with PortableServer;

package Test.Controller.Impl is

   type Object is new PortableServer.Servant_Base with private;

   function Get_Printer (Self : access Object) return Test.Printer.Ref;

   procedure Set_Printer (Self : access Object; Printer : Test.Printer.Ref);

   procedure Set_Group_Size (Self : access Object; Size : Natural);

   procedure StopServer (Self : access Object);

   function Test_OK (Self : access Object) return CORBA.Boolean;

private

   type Object is new PortableServer.Servant_Base with record
      Printer : Test.Printer.Ref;
      Group_Size : Natural := 0;
   end record;

end Test.Controller.Impl;
