------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--            R T C O R B A . P R I O R I T Y T R A N S F O R M             --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--         Copyright (C) 2003-2008, Free Software Foundation, Inc.          --
--                                                                          --
-- This specification is derived from the CORBA Specification, and adapted  --
-- for use with PolyORB. The copyright notice above, and the license        --
-- provisions that follow apply solely to the contents neither explicitly   --
-- nor implicitly specified by the CORBA Specification defined by the OMG.  --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 51 Franklin Street, Fifth    --
-- Floor, Boston, MA 02111-1301, USA.                                       --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

with PortableServer;

package RTCORBA.PriorityTransform is

   type Object is tagged private;

   --  Implementation Note: RT-CORBA specifications (formal/03-11-01)
   --  is unclear and does not state default behavior for this
   --  object. By default, these functions will always set Returns
   --  parameter to False.
   --
   --  Other implementations will provide a functionnal mapping.

   procedure Inbound
     (Self         : Object;
      The_Priority : in out RTCORBA.Priority;
      Oid          : PortableServer.ObjectId;
      Returns      :    out CORBA.Boolean);

   procedure Outbound
     (Self         : Object;
      The_Priority : in out RTCORBA.Priority;
      Oid          : PortableServer.ObjectId;
      Returns      :    out CORBA.Boolean);

private

   type Object is tagged null record;

end RTCORBA.PriorityTransform;
