# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

#### Public Classes

* [`firewall`](#firewall): Performs the basic setup tasks required for using the firewall resources.  At the moment this takes care of:  iptables-persistent package ins

#### Private Classes

* `firewall::linux`: Main linux class, includes all other classes
* `firewall::linux::archlinux`: Manages `iptables` and `ip6tables` services, and creates files used for persistence, on Arch Linux systems.
* `firewall::linux::debian`: Installs the `iptables-persistent` package for Debian-alike systems. This allows rules to be stored to file and restored on boot.
* `firewall::linux::gentoo`: Manages `iptables` and `ip6tables` services, and creates files used for persistence, on Gentoo Linux systems.
* `firewall::linux::redhat`: Manages the `iptables` service on RedHat-alike systems.
* `firewall::params`: Provides defaults for the Apt module parameters

### Resource types

* [`firewall`](#firewall): This type provides the capability to manage firewall rules within puppet via iptables.  **Autorequires:**  If Puppet is managing the iptables
* [`firewallchain`](#firewallchain): This type provides the capability to manage rule chains for firewalls.  Currently this supports only iptables, ip6tables and ebtables on Linu

## Classes

### <a name="firewall"></a>`firewall`

Performs the basic setup tasks required for using the firewall resources.

At the moment this takes care of:

iptables-persistent package installation
Include the firewall class for nodes that need to use the resources in this module:

#### Examples

##### 

```puppet
class { 'firewall': }
```

#### Parameters

The following parameters are available in the `firewall` class:

* [`ensure`](#-firewall--ensure)
* [`ensure_v6`](#-firewall--ensure_v6)
* [`pkg_ensure`](#-firewall--pkg_ensure)
* [`service_name`](#-firewall--service_name)
* [`service_name_v6`](#-firewall--service_name_v6)
* [`package_name`](#-firewall--package_name)
* [`ebtables_manage`](#-firewall--ebtables_manage)

##### <a name="-firewall--ensure"></a>`ensure`

Data type: `Enum[running, stopped, 'running', 'stopped']`

Controls the state of the ipv4 iptables service on your system. Valid options: 'running' or 'stopped'.

Default value: `running`

##### <a name="-firewall--ensure_v6"></a>`ensure_v6`

Data type: `Optional[Enum[running, stopped, 'running', 'stopped']]`

Controls the state of the ipv6 iptables service on your system. Valid options: 'running' or 'stopped'.

Default value: `undef`

##### <a name="-firewall--pkg_ensure"></a>`pkg_ensure`

Data type: `Enum[present, installed, latest, 'present', 'installed', 'latest']`

Controls the state of the iptables package on your system. Valid options: 'present', 'installed' or 'latest'.

Default value: `present`

##### <a name="-firewall--service_name"></a>`service_name`

Data type: `Variant[String[1], Array[String[1]]]`

Specify the name of the IPv4 iptables service.

Default value: `$firewall::params::service_name`

##### <a name="-firewall--service_name_v6"></a>`service_name_v6`

Data type: `Optional[String[1]]`

Specify the name of the IPv6 iptables service.

Default value: `$firewall::params::service_name_v6`

##### <a name="-firewall--package_name"></a>`package_name`

Data type: `Optional[Variant[String[1], Array[String[1]]]]`

Specify the platform-specific package(s) to install.

Default value: `$firewall::params::package_name`

##### <a name="-firewall--ebtables_manage"></a>`ebtables_manage`

Data type: `Boolean`

Controls whether puppet manages the ebtables package or not. If managed, the package will use the value of pkg_ensure.

Default value: `false`

## Resource types

### <a name="firewall"></a>`firewall`

This type provides the capability to manage firewall rules within puppet via iptables.

**Autorequires:**

If Puppet is managing the iptables chains specified in the
`chain` or `jump` parameters, the firewall resource will autorequire
those firewallchain resources.

If Puppet is managing the iptables, iptables-persistent, or iptables-services packages,
the firewall resource will autorequire those packages to ensure that any required binaries are
installed.

#### Providers
    * Required binaries: iptables-save, iptables.
    * Default for kernel == linux.
    * Supported features: address_type, clusterip, connection_limiting, conntrack, dnat, icmp_match,
    interface_match, iprange, ipsec_dir, ipsec_policy, ipset, iptables, isfragment, length,
    log_level, log_prefix, log_uid, log_tcp_sequence, log_tcp_options, log_ip_options,
    mark, mask, mss, netmap, nflog_group, nflog_prefix,
    nflog_range, nflog_threshold, owner, pkttype, queue_bypass, queue_num, rate_limiting,
    recent_limiting, reject_type, snat, socket, state_match, string_matching, tcp_flags, bpf.

#### Features
  * address_type: The ability to match on source or destination address type.

  * clusterip: Configure a simple cluster of nodes that share a certain IP and MAC address without an explicit load balancer in front of them.

  * condition: Match if a specific condition variable is (un)set (requires xtables-addons)

  * connection_limiting: Connection limiting features.

  * conntrack: Connection tracking features.

  * dnat: Destination NATing.

  * hop_limiting: Hop limiting features.

  * icmp_match: The ability to match ICMP types.

  * interface_match: Interface matching.

  * iprange: The ability to match on source or destination IP range.

  * ipsec_dir: The ability to match IPsec policy direction.

  * ipsec_policy: The ability to match IPsec policy.

  * iptables: The provider provides iptables features.

  * isfirstfrag: The ability to match the first fragment of a fragmented ipv6 packet.

  * isfragment: The ability to match fragments.

  * ishasmorefrags: The ability to match a non-last fragment of a fragmented ipv6 packet.

  * islastfrag: The ability to match the last fragment of an ipv6 packet.

  * length: The ability to match the length of the layer-3 payload.

  * log_level: The ability to control the log level.

  * log_prefix: The ability to add prefixes to log messages.

  * log_uid: The ability to log the userid of the process which generated the packet.

  * log_tcp_sequence: The ability to log TCP sequence numbers.

  * log_tcp_options: The ability to log TCP packet header.

  * log_ip_options: The ability to log IP/IPv6 packet header.

  * mark: The ability to match or set the netfilter mark value associated with the packet.

  * mask: The ability to match recent rules based on the ipv4 mask.

  * nflog_group: The ability to set the group number for NFLOG.

  * nflog_prefix: The ability to set a prefix for nflog messages.

  * nflog_size: Set the max size of a message to send to nflog.

  * nflog_threshold: The ability to set nflog_threshold.

  * owner: The ability to match owners.

  * pkttype: The ability to match a packet type.

  * rate_limiting: Rate limiting features.

  * recent_limiting: The netfilter recent module.

  * reject_type: The ability to control reject messages.

  * set_mss: Set the TCP MSS of a packet.

  * snat: Source NATing.

  * socket: The ability to match open sockets.

  * state_match: The ability to match stateful firewall states.

  * string_matching: The ability to match a given string by using some pattern matching strategy.

  * tcp_flags: The ability to match on particular TCP flag settings.

  * netmap: The ability to map entire subnets via source or destination nat rules.

  * hashlimit: The ability to use the hashlimit-module.

  * bpf: The ability to use Berkeley Paket Filter rules.

  * ipvs: The ability to match IP Virtual Server packets.

  * ct_target: The ability to set connection tracking parameters for a packet or its associated connection.

  * random_fully: The ability to use --random-fully flag.

#### Properties

The following properties are available in the `firewall` type.

##### `burst`

Data type: `Optional[Integer[1]]`

      Rate limiting burst value (per second) before limit checks apply.

##### `bytecode`

Data type: `Optional[String[1]]`

      Match using Linux Socket Filter. Expects a BPF program in decimal format.
      This is the format generated by the nfbpf_compile utility.

##### `cgroup`

Data type: `Optional[String[1]]`

      Matches against the net_cls cgroup ID of the packet.

      To negate add a space seperate `!` to the beginning of the string

##### `chain`

Data type: `String[1]`

      Name of the chain the rule will be a part of, ensure the chain you choose exists within your set table.
      Can be one of the built-in chains:

      * INPUT
      * FORWARD
      * OUTPUT
      * PREROUTING
      * POSTROUTING

      Or you can provide a user-based chain.
      Defaults to 'INPUT'

Default value: `INPUT`

##### `checksum_fill`

Data type: `Optional[Boolean]`

      Compute and fill missing packet checksums.

##### `clamp_mss_to_pmtu`

Data type: `Optional[Boolean]`

      Sets the clamp mss to pmtu flag.

##### `clusterip_clustermac`

Data type: `Optional[Pattern[/^([0-9a-fA-F]{2}[:]){5}([0-9a-fA-F]{2})$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Used with the CLUSTERIP jump target.
      Specify the ClusterIP MAC address. Has to be a link-layer multicast address.
      This is IPv4 specific.

##### `clusterip_hash_init`

Data type: `Optional[String[1]]`

      Used with the CLUSTERIP jump target.
      Specify the random seed used for hash initialization.
      This is IPv4 specific.

##### `clusterip_hashmode`

Data type: `Optional[Enum['sourceip', 'sourceip-sourceport', 'sourceip-sourceport-destport']]`

      Used with the CLUSTERIP jump target.
      Specify the hashing mode.
      This is IPv4 specific.

##### `clusterip_local_node`

Data type: `Optional[Integer[1]]`

      Used with the CLUSTERIP jump target.
      Specify the random seed used for hash initialization.
      This is IPv4 specific.

##### `clusterip_new`

Data type: `Optional[Boolean]`

      Used with the CLUSTERIP jump target.
      Create a new ClusterIP. You always have to set this on the first rule for a given ClusterIP.
      This is IPv4 specific.

##### `clusterip_total_nodes`

Data type: `Optional[Integer[1]]`

      Used with the CLUSTERIP jump target.
      Number of total nodes within this cluster.
      This is IPv4 specific.

##### `condition`

Data type: `Optional[String[1]]`

      Match on boolean value (0/1) stored in /proc/net/nf_condition/name.

##### `connlimit_above`

Data type: `Optional[Integer]`

      Connection limiting value for matched connections above n.

##### `connlimit_mask`

Data type: `Optional[Integer[0,128]]`

      Connection limiting by subnet mask for matched connections.
      IPv4: 0-32
      IPv6: 0-128

##### `connlimit_upto`

Data type: `Optional[Integer]`

      Connection limiting value for matched connections below or equal to n.

##### `connmark`

Data type: `Optional[Pattern[/^(?:!\s)?[a-fA-F0-9x]+$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Match the Netfilter mark value associated with the packet, accepts a mark.
      This value will be converted to hex if it is not already.
      This value can be negated by adding a space seperated `!` to the beginning.

##### `ctdir`

Data type: `Optional[Enum['REPLY', 'ORIGINAL']]`

      Matches a packet that is flowing in the specified direction using the
      conntrack module. If this flag is not specified at all, matches packets
      in both directions. Values can be:

      * REPLY
      * ORIGINAL

##### `ctexpire`

Data type: `Optional[Pattern[/^(?:!\s)?\d+(?:\:\d+)?$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Matches a packet based on lifetime remaining in seconds or range of seconds
      using the conntrack module. For example:

        ctexpire => '100'
        ctexpire => '100:150'

##### `ctorigdst`

Data type: `Optional[String[1]]`

      The original destination address using the conntrack module. For example:

          ctorigdst => '192.168.2.0/24'

      You can also negate a mask by putting ! in front. For example:

          ctorigdst => '! 192.168.2.0/24'

      The ctorigdst can also be an IPv6 address if your provider supports it.

##### `ctorigdstport`

Data type: `Optional[Pattern[/^(?:!\s)?\d+(?:\:\d+)?$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      The original destination port to match for this filter using the conntrack module.
      For example:

          ctorigdstport => '80'

      You can also specify a port range: For example:

          ctorigdstport => '80:81'

      You can also negate a port by putting ! in front. For example:

          ctorigdstport => '! 80'

##### `ctorigsrc`

Data type: `Optional[String[1]]`

      The original source address using the conntrack module. For example:

          ctorigsrc => '192.168.2.0/24'

      You can also negate a mask by putting ! in front. For example:

          ctorigsrc => '! 192.168.2.0/24'

      The ctorigsrc can also be an IPv6 address if your provider supports it.

##### `ctorigsrcport`

Data type: `Optional[Pattern[/^(?:!\s)?\d+(?:\:\d+)?$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      The original source port to match for this filter using the conntrack module.
      For example:

          ctorigsrcport => '80'

      You can also specify a port range: For example:

          ctorigsrcport => '80:81'

      You can also negate a port by putting ! in front. For example:

          ctorigsrcport => '! 80'

##### `ctproto`

Data type: `Optional[Variant[Pattern[/^(?:!\s)?\d+$/],Integer]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      The specific layer-4 protocol number to match for this rule using the
      conntrack module.

##### `ctrepldst`

Data type: `Optional[String[1]]`

      The reply destination address using the conntrack module. For example:

          ctrepldst => '192.168.2.0/24'

      You can also negate a mask by putting ! in front. For example:

          ctrepldst => '! 192.168.2.0/24'

      The ctrepldst can also be an IPv6 address if your provider supports it.

##### `ctrepldstport`

Data type: `Optional[Pattern[/^(?:!\s)?\d+(?:\:\d+)?$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      The reply destination port to match for this filter using the conntrack module.
      For example:

          ctrepldstport => '80'

      You can also specify a port range: For example:

          ctrepldstport => '80:81'

      You can also negate a port by putting ! in front. For example:

          ctrepldstport => '! 80'

##### `ctreplsrc`

Data type: `Optional[String[1]]`

      The reply source address using the conntrack module. For example:

          ctreplsrc => '192.168.2.0/24'

      You can also negate a mask by putting ! in front. For example:

          ctreplsrc => '! 192.168.2.0/24'

      The ctreplsrc can also be an IPv6 address if your provider supports it.

##### `ctreplsrcport`

Data type: `Optional[Pattern[/^(?:!\s)?\d+(?:\:\d+)?$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      The reply source port to match for this filter using the conntrack module.
      For example:

          ctreplsrcport => '80'

      You can also specify a port range: For example:

          ctreplsrcport => '80:81'

      You can also negate a port by putting ! in front. For example:

          ctreplsrcport => '! 80'

##### `ctstate`

Data type: `Optional[Variant[Pattern[/^(?:!\s)?(?:INVALID|ESTABLISHED|NEW|RELATED|UNTRACKED|SNAT|DNAT)$/], Array[Pattern[/^(?:!\s)?(?:INVALID|ESTABLISHED|NEW|RELATED|UNTRACKED|SNAT|DNAT)$/]]]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Matches a packet based on its state in the firewall stateful inspection
      table, using the conntrack module. Values can be:

      * INVALID
      * ESTABLISHED
      * NEW
      * RELATED
      * UNTRACKED
      * SNAT
      * DNAT

      Can be passed either as a single String or as an Array, if passed as an array values should be passed in order:

          ctstate => 'INVALID'
          ctstate => ['INVALID', 'ESTABLISHED']

      Values can be negated by adding a '!'.
      If you wish to negate multiple states at once, then place a ! at the start of the first array
      variable. For example:

      ctstate => ['! INVALID', 'ESTABLISHED']

      Note:
        This will negate all passed states, it is not possible to negate a single one of the array.
        In order to maintain compatibility it is also possible to negate all values given in the array to achieve the same behaviour.

##### `ctstatus`

Data type: `Optional[Variant[Pattern[/^(?:!\s)?(?:EXPECTED|SEEN_REPLY|ASSURED|CONFIRMED|NONE)$/], Array[Pattern[/^(?:!\s)?(?:EXPECTED|SEEN_REPLY|ASSURED|CONFIRMED|NONE)$/]]]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Matches a packet based on its status using the conntrack module. Values can be:

      * EXPECTED
      * SEEN_REPLY
      * ASSURED
      * CONFIRMED
      * NONE

      Can be passed either as a single String or as an Array:

        ctstatus => 'EXPECTED'
        ctstatus => ['EXPECTED', 'CONFIRMED']

      Values can be negated by adding a '!'.
      If you wish to negate multiple states at once, then place a ! at the start of the first array
      variable. For example:

        ctstatus => ['! EXPECTED', 'CONFIRMED']

      Note:#{' '}
        This will negate all passed states, it is not possible to negate a single one of the array.
        In order to maintain compatibility it is also possible to negate all values given in the array to achieve the same behaviour.

##### `date_start`

Data type: `Optional[Pattern[/^[0-9]{4}\-(?:0[0-9]|1[0-2])\-(?:[0-2][0-9]|3[0-1])T(?:[0-1][0-9]|2[0-3])\:[0-5][0-9]\:[0-5][0-9]$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Only match during the given time, which must be in ISO 8601 "T" notation.
      The possible time range is 1970-01-01T00:00:00 to 2038-01-19T04:17:07

##### `date_stop`

Data type: `Optional[Pattern[/^[0-9]{4}\-(?:0[0-9]|1[0-2])\-(?:[0-2][0-9]|3[0-1])T(?:[0-1][0-9]|2[0-3])\:[0-5][0-9]\:[0-5][0-9]$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Only match during the given time, which must be in ISO 8601 "T" notation.
      The possible time range is 1970-01-01T00:00:00 to 2038-01-19T04:17:07

##### `destination`

Data type: `Optional[String[1]]`

      The destination address to match. For example:

          destination => '192.168.1.0/24'

      You can also negate a mask by putting ! in front. For example:

          destination  => '! 192.168.2.0/24'

      The destination can also be an IPv6 address if your provider supports it.

##### `dport`

Data type: `Optional[Variant[Array[Variant[Pattern[/^(?:!\s)?\d+(?:(?:\:|-)\d+)?$/],Integer]],Pattern[/^(?:!\s)?\d+(?:(?:\:|-)\d+)?$/],Integer]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      The source port to match for this filter (if the protocol supports
      ports). Will accept a single element or an array.

      For some firewall providers you can pass a range of ports in the format:

          dport => '1:1024'

      This would cover ports 1 to 1024.

      You can also negate a port by putting ! in front. For example:

          dport => '! 54'

      If you wish to negate multiple ports at once, then place a ! at the start of the first array
      variable. For example:

          dport => ['! 54','23']

      Note:
        This will negate all passed ports, it is not possible to negate a single one of the array.
        In order to maintain compatibility it is also possible to negate all values given in the array to achieve the same behaviour.

##### `dst_cc`

Data type: `Optional[Pattern[/^[A-Z]{2}(,[A-Z]{2})*$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      dst attribute for the module geoip

##### `dst_range`

Data type: `Optional[String[1]]`

      The destination IP range. For example:

          dst_range => '192.168.1.1-192.168.1.10'

      You can also negate the range by putting ! in front. For example:

          dst_range => '! 192.168.1.1-192.168.1.10'

      The destination IP range must be in 'IP1-IP2' format.

##### `dst_type`

Data type: `Optional[Variant[
             Array[Pattern[/^(?:!\s)?(?:UNSPEC|UNICAST|LOCAL|BROADCAST|ANYCAST|MULTICAST|BLACKHOLE|UNREACHABLE|UNREACHABLE|PROHIBIT|THROW|NAT|XRESOLVE)(?:\s--limit-iface-(?:in|out))?$/]],
             Pattern[/^(?:!\s)?(?:UNSPEC|UNICAST|LOCAL|BROADCAST|ANYCAST|MULTICAST|BLACKHOLE|UNREACHABLE|UNREACHABLE|PROHIBIT|THROW|NAT|XRESOLVE)(?:\s--limit-iface-(?:in|out))?$/]]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      The destination address type. For example:

          dst_type => ['LOCAL']

      Can be one of:

      * UNSPEC - an unspecified address
      * UNICAST - a unicast address
      * LOCAL - a local address
      * BROADCAST - a broadcast address
      * ANYCAST - an anycast packet
      * MULTICAST - a multicast address
      * BLACKHOLE - a blackhole address
      * UNREACHABLE - an unreachable address
      * PROHIBIT - a prohibited address
      * THROW - undocumented
      * NAT - undocumented
      * XRESOLVE - undocumented

      In addition, it accepts '--limit-iface-in' and '--limit-iface-out' flags, specified as:

          dst_type => ['LOCAL --limit-iface-in']

      Each value can be negated seperately using '!':

          dst_type => ['! UNICAST', '! LOCAL']

      Will accept a single element or an array.

##### `ensure`

Data type: `Enum[present, absent, 'present', 'absent']`

      Whether this rule should be present or absent on the target system.

Default value: `present`

##### `gateway`

Data type: `Optional[Pattern[/^(\d+.\d+.\d+.\d+|\w+:\w+::\w+)$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      The TEE target will clone a packet and redirect this clone to another
      machine on the local network segment.
      Gateway is the target host's IP.

##### `gid`

Data type: `Optional[Variant[String[1], Integer]]`

      GID or Group owner matching rule.  Accepts a single argument
      only, as iptables does not accept multiple gid in a single
      statement.
      To negate add a space seperated '!' in front of the value.

##### `goto`

Data type: `Optional[String[1]]`

      The value for the iptables --goto parameter. Normal values are:

      * QUEUE
      * RETURN
      * DNAT
      * SNAT
      * LOG
      * MASQUERADE
      * REDIRECT
      * MARK

      But any valid chain name is allowed.

##### `hashlimit_above`

Data type: `Optional[Pattern[/^\d+(?:\/(?:sec|min|hour|day))?$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Match if the rate is above amount/quantum.
      This parameter or `hashlimit_upto` and `hashlimit_name` are required when setting any other hashlimit values.
      Allowed forms are '40','40/sec','40/min','40/hour','40/day'.

##### `hashlimit_burst`

Data type: `Optional[Integer[1]]`

      Maximum initial number of packets to match: this number gets recharged by one every time the limit specified above is not reached, up to this number; the default is 5.
      When byte-based rate matching is requested, this option specifies the amount of bytes that can exceed the given rate.
      This option should be used with caution -- if the entry expires, the burst value is reset too.

##### `hashlimit_dstmask`

Data type: `Optional[Integer[0,32]]`

      When --hashlimit-mode srcip is used, all destination addresses encountered will be grouped according to the given prefix length
      and the so-created subnet will be subject to hashlimit.
      Prefix must be between (inclusive) 0 and 32.
      Note that --hashlimit-dstmask 0 is basically doing the same thing as not specifying srcip for --hashlimit-mode, but is technically more expensive.

##### `hashlimit_htable_expire`

Data type: `Optional[Integer]`

      After how many milliseconds do hash entries expire.

##### `hashlimit_htable_gcinterval`

Data type: `Optional[Integer]`

      How many milliseconds between garbage collection intervals.

##### `hashlimit_htable_max`

Data type: `Optional[Integer]`

      Maximum entries in the hash.

##### `hashlimit_htable_size`

Data type: `Optional[Integer]`

      The number of buckets of the hash table

##### `hashlimit_mode`

Data type: `Optional[Pattern[/^(?:srcip|srcport|dstip|dstport)(?:\,(?:srcip|srcport|dstip|dstport))*$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      A comma-separated list of objects to take into consideration.
      If no --hashlimit-mode option is given, hashlimit acts like limit, but at the expensive of doing the hash housekeeping.
      Allowed values are: srcip, srcport, dstip, dstport

##### `hashlimit_name`

Data type: `Optional[String[1]]`

      The name for the /proc/net/ipt_hashlimit/foo entry.
      This parameter and either `hashlimit_upto` or `hashlimit_above` are required when setting any other hashlimit values.

##### `hashlimit_srcmask`

Data type: `Optional[Integer[0,32]]`

      When --hashlimit-mode srcip is used, all source addresses encountered will be grouped according to the given prefix length
      and the so-created subnet will be subject to hashlimit.
      Prefix must be between (inclusive) 0 and 32.
      Note that --hashlimit-srcmask 0 is basically doing the same thing as not specifying srcip for --hashlimit-mode, but is technically more expensive.

##### `hashlimit_upto`

Data type: `Optional[Pattern[/^\d+(?:\/(?:sec|min|hour|day))?$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Match if the rate is below or equal to amount/quantum. It is specified either as a number, with an optional time quantum suffix (the default is 3/hour), or as amountb/second (number of bytes per second).
      This parameter or `hashlimit_above` and `hashlimit_name` are required when setting any other hashlimit values.
      Allowed forms are '40','40/sec','40/min','40/hour','40/day'.

##### `helper`

Data type: `Optional[String[1]]`

      Invoke the nf_conntrack_xxx helper module for this packet.

##### `hop_limit`

Data type: `Optional[Variant[Pattern[/^(?:!\s)?\d+$/],Integer]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Hop limiting value for matched packets.
      To negate add a space seperated `!` the the beginning of the value
      This is IPv6 specific.

##### `icmp`

Data type: `Optional[Variant[String[1],Integer]]`

      When matching ICMP packets, this is the type of ICMP packet to match.

      A value of "any" is not supported. To achieve this behaviour the
      parameter should simply be omitted or undefined.
      An array of values is also not supported. To match against multiple ICMP
      types, please use separate rules for each ICMP type.

##### `iniface`

Data type: `Optional[Pattern[/^(?:!\s)?[a-zA-Z0-9\-\._\+\:@]+$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Input interface to filter on.  Supports interface alias like eth0:0.
      To negate the match try this:

            iniface => '! lo',

##### `ipsec_dir`

Data type: `Optional[Enum['in', 'out']]`

      Sets the ipsec policy direction

##### `ipsec_policy`

Data type: `Optional[Enum['none', 'ipsec']]`

      Sets the ipsec policy type. May take a combination of arguments for any flags that can be passed to `--pol ipsec` such as: `--strict`, `--reqid 100`, `--next`, `--proto esp`, etc.

##### `ipset`

Data type: `Optional[Variant[Pattern[/^(?:!\s)?\w+\s(?:src|dst)(?:,src|,dst)?$/], Array[Pattern[/^(?:!\s)?\w+\s(?:src|dst)(?:,src|,dst)?$/]]]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Matches against the specified ipset list.
      Requires ipset kernel module. Will accept a single element or an array.
      The value is the name of the denylist, followed by a space, and then
      'src' and/or 'dst' separated by a comma.
      For example: 'denylist src,dst'
      To negate simply place a space seperated `!` at the beginning of a value.
      Values can de negated independently.

##### `ipvs`

Data type: `Optional[Boolean]`

      Match using Linux Socket Filter. Expects a BPF program in decimal format.
      This is the format generated by the nfbpf_compile utility.

##### `isfirstfrag`

Data type: `Optional[Boolean]`

      Matches if the packet is the first fragment.
      Specific to IPv6.

##### `isfragment`

Data type: `Optional[Boolean]`

      Set to true to match tcp fragments (requires proto to be set to tcp)

##### `ishasmorefrags`

Data type: `Optional[Boolean]`

      Matches if the packet has it's 'more fragments' bit set.
      Specific to IPv6.

##### `islastfrag`

Data type: `Optional[Boolean]`

      Matches if the packet is the last fragment.
      Specific to IPv6.

##### `jump`

Data type: `Optional[String[1]]`

      This value for the iptables --jump parameter and the action to perform on a match. Common values are:

      * ACCEPT - the packet is accepted
      * REJECT - the packet is rejected with a suitable ICMP response
      * DROP - the packet is dropped

      But can also be on of the following:

      * QUEUE
      * RETURN
      * DNAT
      * SNAT
      * LOG
      * NFLOG
      * NETMAP
      * MASQUERADE
      * REDIRECT
      * MARK
      * CT

      And any valid chain name is also allowed.

      If you specify no value it will simply match the rule but perform no action.

##### `kernel_timezone`

Data type: `Optional[Boolean]`

      Use the kernel timezone instead of UTC to determine whether a packet meets the time regulations.

##### `length`

Data type: `Optional[Pattern[/^([0-9]+)(:)?([0-9]+)?$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Sets the length of layer-3 payload to match.

      Example values are: '500', '5:400'

##### `limit`

Data type: `Optional[Pattern[/^\d+\/(?:sec(?:ond)?|min(?:ute)?|hour|day)$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Rate limiting value for matched packets. The format is:
      rate/[/second/|/minute|/hour|/day]

      Example values are: '50/sec', '40/min', '30/hour', '10/day'."

##### `line`

Data type: `Optional[String[1]]`

      A read only attribute containing the full rule, used when deleting and when applying firewallchain purge attributes.

##### `log_ip_options`

Data type: `Optional[Boolean]`

      When combined with jump => "LOG" logging of the TCP IP/IPv6 packet header.

##### `log_level`

Data type: `Optional[Variant[Integer[0,7],String[1]]]`

      When combined with jump => "LOG" specifies the system log level to log to.

      Note: log level 4/warn is the default setting and as such it is not returned by iptables-save.
      As a result, explicitly setting `log_level` to this can result in idempotency errors.

##### `log_prefix`

Data type: `Optional[String[1]]`

      When combined with jump => "LOG" specifies the log prefix to use when logging.

##### `log_tcp_options`

Data type: `Optional[Boolean]`

      When combined with jump => "LOG" logging of the TCP packet header.

##### `log_tcp_sequence`

Data type: `Optional[Boolean]`

      When combined with jump => "LOG" enables logging of the TCP sequence numbers.

##### `log_uid`

Data type: `Optional[Boolean]`

      When combined with jump => "LOG" specifies the uid of the process making the connection.

##### `mac_source`

Data type: `Optional[Pattern[/^(?:!\s)?([0-9a-fA-F]{2}[:]){5}([0-9a-fA-F]{2})$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      MAC Source

##### `mask`

Data type: `Optional[Pattern[/^\d+\.\d+\.\d+\.\d+$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Recent module; sets the mask to use when `recent` is enabled.
      The recent module defaults this to `255.255.255.255` when recent is set

##### `match_mark`

Data type: `Optional[Pattern[/^(?:!\s)?[a-fA-F0-9x]+$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Match the Netfilter mark value associated with the packet, accepts a mark.
      This value will be converted to hex if it is not already.
      This value can be negated by adding a space seperated `!` to the beginning.

##### `month_days`

Data type: `Optional[Variant[Integer[0,31], Array[Integer[0,31]]]]`

      Only match on the given days of the month. Possible values are 1 to 31.
      Note that specifying 31 will of course not match on months which do not have a 31st day;
      the same goes for 28-day or 29-day February.

      Can be passed either as a single value or an array of values:
        month_days => 5,
        month_days => [5, 9, 23],

##### `mss`

Data type: `Optional[Pattern[/^(?:!\s)?\d+(?:\:\d+)?$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Match a given TCP MSS value or range.
      This value can be negated by adding a space seperated `!` to the beginning.

##### `nflog_group`

Data type: `Optional[Integer[1, 65535]]`

      Used with the jump target NFLOG.
      The netlink group (0 - 2^16-1) to which packets are (only applicable
      for nfnetlink_log). Defaults to 0.

##### `nflog_prefix`

Data type: `Optional[String]`

      Used with the jump target NFLOG.
      A prefix string to include in the log message, up to 64 characters long,
      useful for distinguishing messages in the logs.

##### `nflog_range`

Data type: `Optional[Integer[1]]`

      Used with the jump target NFLOG.
      This has never worked, use nflog_size instead.

##### `nflog_size`

Data type: `Optional[Integer[1]]`

      Used with the jump target NFLOG.
      The number of bytes to be copied to userspace (only applicable for nfnetlink_log).
      nfnetlink_log instances may specify their own size, this option overrides it.

##### `nflog_threshold`

Data type: `Optional[Integer[1]]`

      Used with the jump target NFLOG.
      Number of packets to queue inside the kernel before sending them to userspace
      (only applicable for nfnetlink_log). Higher values result in less overhead
      per packet, but increase delay until the packets reach userspace. Defaults to 1.

##### `notrack`

Data type: `Optional[Boolean]`

      Invoke the disable connection tracking for this packet.
      This parameter can be used with iptables version >= 1.8.3

##### `outiface`

Data type: `Optional[Pattern[/^(?:!\s)?[a-zA-Z0-9\-\._\+\:@]+$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Output interface to filter on.  Supports interface alias like eth0:0.
      To negate the match try this:

            outiface => '! lo',

##### `physdev_in`

Data type: `Optional[Pattern[/^(?:!\s)?[a-zA-Z0-9\-\._\+]+$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Match if the packet is entering a bridge from the given interface.
      To negate the match try this:

          physdev_in => '! lo',

##### `physdev_is_bridged`

Data type: `Optional[Boolean]`

      Match if the packet is transversing a bridge.

##### `physdev_is_in`

Data type: `Optional[Boolean]`

      Matches if the packet has entered through a bridge interface.

##### `physdev_is_out`

Data type: `Optional[Boolean]`

      Matches if the packet will leave through a bridge interface.

##### `physdev_out`

Data type: `Optional[Pattern[/^(?:!\s)?[a-zA-Z0-9\-\._\+]+$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Match if the packet is leaving a bridge via the given interface.
      To negate the match try this:

          physdev_out => '! lo',

##### `pkttype`

Data type: `Optional[Enum['unicast', 'broadcast', 'multicast']]`

      Sets the packet type to match.

##### `proto`

Data type: `Optional[Pattern[/^(?:!\s)?(?:ip(?:encap)?|tcp|udp|icmp|esp|ah|vrrp|carp|igmp|ipv4|ospf|gre|cbt|sctp|pim|all)/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      The specific protocol to match for this rule.

Default value: `tcp`

##### `protocol`

Data type: `Enum['iptables', 'ip6tables', 'IPv4', 'IPv6']`

      The protocol used to set the rule, it's allowed values have been expanded to bring it closer to its `firewallchain` counterpart.
      Defaults to `IPv4`

      Noted: this was previously defined as `provider`, however the resource_api does not allow this to be used as an attribute title.

Default value: `IPv4`

##### `queue_bypass`

Data type: `Optional[Boolean]`

      Allow packets to bypass :queue_num if userspace process is not listening

##### `queue_num`

Data type: `Optional[Integer[1]]`

      Used with NFQUEUE jump target.
      What queue number to send packets to

##### `random`

Data type: `Optional[Boolean]`

      When using a jump value of "MASQUERADE", "DNAT", "REDIRECT", or "SNAT" this boolean will enable randomized port mapping.

##### `random_fully`

Data type: `Optional[Boolean]`

      When using a jump value of "MASQUERADE", "DNAT", "REDIRECT", or "SNAT" this boolean will enable fully randomized port mapping.

##### `rdest`

Data type: `Optional[Boolean]`

      Recent module; add the destination IP address to the list.
      Mutually exclusive with `rsource`
      Must be boolean true.

##### `reap`

Data type: `Optional[Boolean]`

      Recent module; can only be used in conjunction with the `rseconds`
      attribute. When used, this will cause entries older than 'seconds' to be
      purged.  Must be boolean true.

##### `recent`

Data type: `Optional[Enum['set', 'update', 'rcheck', 'remove', '! set', '! update', '! rcheck', '! remove']]`

      Enable the recent module. Takes as an argument one of set, update,
      rcheck or remove. For example:

        ```
        # If anyone's appeared on the 'badguy' blacklist within
        #  the last 60 seconds, drop their traffic, and update the timestamp.
        firewall { '100 Drop badguy traffic':
          recent   => 'update',
          rseconds => 60,
          rsource  => true,
          rname    => 'badguy',
          jump     => 'DROP',
          chain    => 'FORWARD',
        }
        ```


        ```
        # No-one should be sending us traffic on eth0 from the
        #  localhost, Blacklist them
        firewall { '101 blacklist strange traffic':
          recent      => 'set',
          rsource     => true,
          rname       => 'badguy',
          destination => '127.0.0.0/8',
          iniface     => 'eth0',
          jump        => 'DROP',
          chain       => 'FORWARD',
        }
        ```

##### `reject`

Data type: `Optional[Enum['icmp-net-unreachable', 'icmp-host-unreachable', 'icmp-port-unreachable', 'icmp-proto-unreachable',
                              'icmp-net-prohibited', 'icmp-host-prohibited', 'icmp-admin-prohibited', 'icmp6-no-route', 'no-route',
                              'icmp6-adm-prohibited', 'adm-prohibited', 'icmp6-addr-unreachable', 'addr-unreach', 'icmp6-port-unreachable']]`

      When combined with jump => "REJECT" you can specify a different icmp response to be sent back to the packet sender.
      Valid values differ depending on if the protocol is `IPv4` or `IPv6`.
      IPv4 allows: icmp-net-unreachable, icmp-host-unreachable, icmp-port-unreachable, icmp-proto-unreachable, icmp-net-prohibited,
      icmp-host-prohibited, or icmp-admin-prohibited.
      IPv6 allows: icmp6-no-route, no-route, icmp6-adm-prohibited, adm-prohibited, icmp6-addr-unreachable, addr-unreach, or icmp6-port-unreachable.

##### `rhitcount`

Data type: `Optional[Integer[1]]`

      Recent module; used in conjunction with `recent => 'update'` or `recent
      => 'rcheck'. When used, this will narrow the match to only happen when
      the address is in the list and packets had been received greater than or
      equal to the given value.

##### `rname`

Data type: `Optional[String[1]]`

      Recent module; The name of the list.
      The recent module defaults this to `DEFAULT` when recent is set

##### `rpfilter`

Data type: `Optional[Variant[Enum['loose', 'validmark', 'accept-local', 'invert'], Array[Enum['loose', 'validmark', 'accept-local', 'invert']]]]`

      Enable the rpfilter module.

##### `rseconds`

Data type: `Optional[Integer[1]]`

      Recent module; used in conjunction with one of `recent => 'rcheck'` or
      `recent => 'update'`. When used, this will narrow the match to only
      happen when the address is in the list and was seen within the last given
      number of seconds.

##### `rsource`

Data type: `Optional[Boolean]`

      Recent module; add the source IP address to the list.
      Mutually exclusive with `rdest`
      The recent module defaults this behaviour to true when recent is set.

##### `rttl`

Data type: `Optional[Boolean]`

      Recent module; may only be used in conjunction with one of `recent =>
      'rcheck'` or `recent => 'update'`. When used, this will narrow the match
      to only happen when the address is in the list and the TTL of the current
      packet matches that of the packet which hit the `recent => 'set'` rule.
      This may be useful if you have problems with people faking their source
      address in order to DoS you via this module by disallowing others access
      to your site by sending bogus packets to you.  Must be boolean true.

##### `set_dscp`

Data type: `Optional[String[1]]`

      Set DSCP Markings.

##### `set_dscp_class`

Data type: `Optional[Enum['af11', 'af12', 'af13', 'af21', 'af22', 'af23', 'af31', 'af32', 'af33', 'af41', 'af42', 'af43', 'cs1', 'cs2', 'cs3', 'cs4', 'cs5', 'cs6', 'cs7', 'ef']]`

      This sets the DSCP field according to a predefined DiffServ class.

##### `set_mark`

Data type: `Optional[Pattern[/^[a-fA-F0-9x]+(?:\/[a-fA-F0-9x]+)?$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Set the Netfilter mark value associated with the packet.  Accepts either of mark/mask or mark.
      These will be converted to hex if they are not already.

##### `set_mss`

Data type: `Optional[Integer[1]]`

      Sets the TCP MSS value for packets.

##### `socket`

Data type: `Optional[Boolean]`

      If true, matches if an open socket can be found by doing a coket lookup
      on the packet.

##### `source`

Data type: `Optional[String[1]]`

      The source address. For example:

          source => '192.168.2.0/24'

      You can also negate a mask by putting ! in front. For example:

          source => '! 192.168.2.0/24'

      The source can also be an IPv6 address if your provider supports it.

##### `sport`

Data type: `Optional[Variant[Array[Variant[Pattern[/^(?:!\s)?\d+(?:(?:\:|-)\d+)?$/],Integer]],Pattern[/^(?:!\s)?\d+(?:(?:\:|-)\d+)?$/],Integer]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      The source port to match for this filter (if the protocol supports
      ports). Will accept a single element or an array.

      For some firewall providers you can pass a range of ports in the format:

          sport => '1:1024'

      This would cover ports 1 to 1024.

      You can also negate a port by putting ! in front. For example:

          sport => '! 54'

      If you wish to negate multiple ports at once, then place a ! at the start of the first array
      variable. For example:

          sport => ['! 54','23']

      Note:
        This will negate all passed ports, it is not possible to negate a single one of the array.
        In order to maintain compatibility it is also possible to negate all values given in the array to achieve the same behaviour.

##### `src_cc`

Data type: `Optional[Pattern[/^[A-Z]{2}(,[A-Z]{2})*$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      src attribute for the module geoip

##### `src_range`

Data type: `Optional[String[1]]`

      The source IP range. For example:

          src_range => '192.168.1.1-192.168.1.10'

      You can also negate the range by apending a `!`` to the front. For example:

          src_range => '! 192.168.1.1-192.168.1.10'

      The source IP range must be in 'IP1-IP2' format.

##### `src_type`

Data type: `Optional[Variant[
             Array[Pattern[/^(?:!\s)?(?:UNSPEC|UNICAST|LOCAL|BROADCAST|ANYCAST|MULTICAST|BLACKHOLE|UNREACHABLE|UNREACHABLE|PROHIBIT|THROW|NAT|XRESOLVE)(?:\s--limit-iface-(?:in|out))?$/]],
             Pattern[/^(?:!\s)?(?:UNSPEC|UNICAST|LOCAL|BROADCAST|ANYCAST|MULTICAST|BLACKHOLE|UNREACHABLE|UNREACHABLE|PROHIBIT|THROW|NAT|XRESOLVE)(?:\s--limit-iface-(?:in|out))?$/]]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      The source address type. For example:

          src_type => 'LOCAL'

      Can be one of:

      * UNSPEC - an unspecified address
      * UNICAST - a unicast address
      * LOCAL - a local address
      * BROADCAST - a broadcast address
      * ANYCAST - an anycast packet
      * MULTICAST - a multicast address
      * BLACKHOLE - a blackhole address
      * UNREACHABLE - an unreachable address
      * PROHIBIT - a prohibited address
      * THROW - undocumented
      * NAT - undocumented
      * XRESOLVE - undocumented

      In addition, it accepts '--limit-iface-in' and '--limit-iface-out' flags, specified as:

          src_type => ['LOCAL --limit-iface-in']

      It can also be negated using '!':

          src_type => ['! LOCAL']

      Will accept a single element or an array. Each element of the array should be negated seperately.

##### `stat_every`

Data type: `Optional[Integer[1]]`

      Match one packet every nth packet. Requires `stat_mode => 'nth'`

##### `stat_mode`

Data type: `Optional[Enum[nth, random]]`

      Set the matching mode for statistic matching.

##### `stat_packet`

Data type: `Optional[Integer]`

      Set the initial counter value for the nth mode. Must be between 0 and the value of `stat_every`.
      Defaults to 0. Requires `stat_mode => 'nth'`

##### `stat_probability`

Data type: `Optional[Variant[Integer[0,1], Float[0.0,1.0]]]`

      Set the probability from 0 to 1 for a packet to be randomly matched. It works only with `stat_mode => 'random'`.

##### `state`

Data type: `Optional[Variant[Pattern[/^(?:!\s)?(?:INVALID|ESTABLISHED|NEW|RELATED|UNTRACKED)$/], Array[Pattern[/^(?:!\s)?(?:INVALID|ESTABLISHED|NEW|RELATED|UNTRACKED)$/]]]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Matches a packet based on its state in the firewall stateful inspection
      table. Values can be:

      * INVALID
      * ESTABLISHED
      * NEW
      * RELATED
      * UNTRACKED
      * SNAT
      * DNAT

      Can be passed either as a single String or as an Array:

          state => 'INVALID'
          state => ['INVALID', 'ESTABLISHED']

      Values can be negated by adding a '!'.
      If you wish to negate multiple states at once, then place a ! at the start of the first array
      variable. For example:

          state => ['! INVALID', 'ESTABLISHED']

      Note:
        This will negate all passed states, it is not possible to negate a single one of the array.
        In order to maintain compatibility it is also possible to negate all values given in the array to achieve the same behaviour.

##### `string`

Data type: `Optional[String[1]]`

      String matching feature. Matches the packet against the pattern
      given as an argument.
      To negate, add a space seperated `!` to the beginning of the string.

##### `string_algo`

Data type: `Optional[Enum['bm', 'kmp']]`

      String matching feature, pattern matching strategy.

##### `string_from`

Data type: `Optional[Integer[1]]`

      String matching feature, offset from which we start looking for any matching.

##### `string_hex`

Data type: `Optional[Pattern[/^(?:!\s)?\|[a-zA-Z0-9\s]+\|$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      String matching feature. Matches the packet against the pattern
      given as an argument.
      To negate, add a space seperated `!` to the beginning of the string.

##### `string_to`

Data type: `Optional[Integer[1]]`

      String matching feature, offset up to which we should scan.

##### `table`

Data type: `Enum['nat', 'mangle', 'filter', 'raw', 'rawpost', 'broute', 'security']`

      The table the rule will exist in.
      Valid options are:

      * nat
      * mangle
      * filter
      * raw
      * rawpost

      Defaults to 'filter'

Default value: `filter`

##### `tcp_flags`

Data type: `Optional[Pattern[/^(?:!\s)?((FIN|SYN|RST|PSH|ACK|URG|ALL|NONE),?)+\s((FIN|SYN|RST|PSH|ACK|URG|ALL|NONE),?)+$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Match when the TCP flags are as specified.
      Is a string with a list of comma-separated flag names for the mask,
      then a space, then a comma-separated list of flags that should be set.
      The flags are: FIN SYN RST PSH ACK URG ALL NONE
      Note that you specify them in the order that iptables --list-rules
      would list them to avoid having puppet think you changed the flags.

      Example: FIN,SYN,RST,ACK SYN matches packets with the SYN bit set and the
      ACK,RST and FIN bits cleared. Such packets are used to request
      TCP  connection initiation.
      Can be negated by placing ! in front, i.e.
        ! FIN,SYN,RST,ACK SYN

##### `tcp_option`

Data type: `Optional[Variant[Pattern[/^(?:!\s)?(?:[0-1][0-9]{0,2}|2[0-4][0-9]|25[0-5])$/], Integer[0,255]]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Match when the TCP option is present or absent.
      Given as a single TCP option, optionally prefixed with '! ' to match
      on absence instead.  Only one TCP option can be matched in a given rule.
      TCP option numbers are an eight-bit field, so valid option numbers range
      from 0-255.

##### `time_contiguous`

Data type: `Optional[Boolean]`

      When time_stop is smaller than time_start value, match this as a single time period instead distinct intervals.

##### `time_start`

Data type: `Optional[Pattern[/^([0-9]|[0-1][0-9]|2[0-3])\:[0-5][0-9](?:\:[0-5][0-9])?/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Only match during the given daytime. The possible time range is 00:00:00 to 23:59:59.
      Leading zeroes are allowed (e.g. "06:03") and correctly interpreted as base-10.

##### `time_stop`

Data type: `Optional[Pattern[/^([0-9]|[0-1][0-9]|2[0-3])\:[0-5][0-9](?:\:[0-5][0-9])?/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Only match during the given daytime. The possible time range is 00:00:00 to 23:59:59.
      Leading zeroes are allowed (e.g. "06:03") and correctly interpreted as base-10.

##### `to`

Data type: `Optional[String[1]]`

      For NETMAP this will replace the destination IP

##### `todest`

Data type: `Optional[String[1]]`

      When using jump => "DNAT" you can specify the new destination address using this paramter.
      Can specify a single new destination IP address or an inclusive range of IP addresses.
      Optionally a port or a port range with a possible follow up baseport can be provided.
      Input structure: [ipaddr[-ipaddr]][:port[-port[/baseport]]]

##### `toports`

Data type: `Optional[Pattern[/^\d+(?:-\d+)?$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      For REDIRECT/MASQUERADE this is the port that will replace the destination/source port.
      Can specify a single new port or an inclusive range of ports.

##### `tosource`

Data type: `Optional[String[1]]`

      When using jump => "SNAT" you can specify the new source address using this paramter.
      Can specify a single new destination IP address or an inclusive range of IP addresses.
      Input structure: [ipaddr[-ipaddr]][:port[-port]]

##### `u32`

Data type: `Optional[Pattern[/^0x[0-9a-fA-F]+&0x[0-9a-fA-F]+=0x[0-9a-fA-F]+(?::0x[0-9a-fA-F]+)?(?:&&0x[0-9a-fA-F]+&0x[0-9a-fA-F]+=0x[0-9a-fA-F]+(?::0x[0-9a-fA-F]+)?)*$/]]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      Enable the u32 module. Takes as an argument one of set, update,
      rcheck or remove. For example:
        firewall { '032 u32 test':
          ensure   => present,
          table    => 'mangle',
          chain    => 'PREROUTING',
          u32      => '0x4&0x1fff=0x0&&0x0&0xf000000=0x5000000',
          jump     => 'DROP',
        }

##### `uid`

Data type: `Optional[Variant[String[1], Integer]]`

      UID or Username owner matching rule.  Accepts a single argument
      only, as iptables does not accept multiple uid in a single
      statement.
      To negate add a space seperated '!' in front of the value.

##### `week_days`

Data type: `Optional[Variant[Enum['Mon','Tue','Wed','Thu','Fri','Sat','Sun'], Array[Enum['Mon','Tue','Wed','Thu','Fri','Sat','Sun']]]]`

      Only match on the given weekdays.

      Can be passed either as a single value or an array of values:
        week_days => 'Mon',
        week_days => ['Mon', 'Tue', 'Wed'],

##### `zone`

Data type: `Optional[Integer]`

      Assign this packet to zone id and only have lookups done in that zone.

#### Parameters

The following parameters are available in the `firewall` type.

* [`name`](#-firewall--name)

##### <a name="-firewall--name"></a>`name`

namevar

Data type: `Pattern[/(^\d+(?:[ \t-]\S+)+$)/]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

      The canonical name of the rule. This name is also used for ordering
      so make sure you prefix the rule with a number:

          000 this runs first
          999 this runs last

      Depending on the provider, the name of the rule can be stored using
      the comment feature of the underlying firewall subsystem.

### <a name="firewallchain"></a>`firewallchain`

This type provides the capability to manage rule chains for firewalls.

Currently this supports only iptables, ip6tables and ebtables on Linux. And
provides support for setting the default policy on chains and tables that
allow it.

#### Providers
  * iptables_chain is the only provider that supports firewallchain.

#### Features
  * iptables_chain: The provider provides iptables chain features.
  * policy: Default policy (inbuilt chains only).

#### Properties

The following properties are available in the `firewallchain` type.

##### `ensure`

Data type: `Enum[present, absent]`

      Whether this chain should be present or absent on the target system.
      Setting this to absent will first remove all rules associated with this chain and then delete the chain itself.
      Inbuilt chains however will merely remove any added rules and, if it has been changed, return their policy to the default.

Default value: `present`

##### `ignore`

Data type: `Optional[Variant[String[1], Array[String[1]]]]`

      Regex to perform on firewall rules to exempt unmanaged rules from purging.
      This is matched against the output of `iptables-save`.

      This can be a single regex, or an array of them.
      To support flags, use the ruby inline flag mechanism.
      Meaning a regex such as
        /foo/i
      can be written as
        '(?i)foo' or '(?i:foo)'

      Full example:
      ```
      firewallchain { 'INPUT:filter:IPv4':
        purge => true,
        ignore => [
          '-j fail2ban-ssh', # ignore the fail2ban jump rule
          '--comment "[^"]*(?i:ignore)[^"]*"', # ignore any rules with "ignore" (case insensitive) in the comment in the rule
        ],
      }
      ```

##### `ignore_foreign`

Data type: `Boolean`

      Ignore rules that do not match the puppet title pattern "^\d+[[:graph:][:space:]]" when purging unmanaged firewall rules in this chain.
      This can be used to ignore rules that were not put in by puppet. Beware that nothing keeps other systems from configuring firewall rules with a comment that starts with digits, and is indistinguishable from puppet-configured rules.

##### `policy`

Data type: `Optional[Enum['accept', 'drop', 'queue', 'return']]`

      This action to take when the end of the chain is reached.
      This can only be set on inbuilt chains (i.e. INPUT, FORWARD, OUTPUT,
      PREROUTING, POSTROUTING) and can be one of:

      * accept - the packet is accepted
      * drop - the packet is dropped
      * queue - the packet is passed userspace
      * return - the packet is returned to calling (jump) queue
                 or the default of inbuilt chains

##### `purge`

Data type: `Boolean`

Whether or not to purge unmanaged rules in this chain

#### Parameters

The following parameters are available in the `firewallchain` type.

* [`name`](#-firewallchain--name)

##### <a name="-firewallchain--name"></a>`name`

namevar

Data type: `Pattern[/^(?:\S+):(?:nat|mangle|filter|raw|rawpost|broute|security):(?:IP(?:v[46])?|ethernet)$/]`
_*this data type contains a regex that may not be accurately reflected in generated documentation_

The canonical name of the chain with the required format being `{chain}:{table}:{protocol}`.

