#ifndef __PREREQ_USRMANAGER_H__
#define __PREREQ_USRMANAGER_H__

#include <gtk/gtk.h>

/* FIXME: Perhaps these don't need to be public */
typedef enum {
	CHANGES_ADD_USER  =			1 << 0,
	CHANGES_ADD_GROUP =			1 << 1,
	CHANGES_CREATE_HOMEDIR =	1 << 2,
	CHANGES_CREATE_PWFILE = 	1 << 3
} SystemChangesType;
	
typedef struct
{
	SystemChangesType changes;
	gchar *ftpuser, *ftpgroup;
	gchar *ftpdir;
	gchar *pwfile;
	guint usr_id, grp_id;
} SystemActions;

/* Shows the prereq window and returns TRUE if all neccessary changes was completed */
gboolean prereq_show_dialog (GtkWindow *parent);
/* Gets a value indicating whether all the prerequisities for running the user manager 
 * is fulfilled */
gboolean prereq_are_all_requirements_met (void);
/* Free's a SystemActions struct */
void system_actions_free (SystemActions *actions);

#endif
