# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools
from json import loads as _loads
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.core.polling.base_polling import LROBasePolling
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from msrest import Serializer

from .._vendor import _convert_request, _format_url_section

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, IO, List, Optional, TypeVar, Union

    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
# fmt: off

def build_entity_create_or_update_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_entity_list_by_guids_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    guids = kwargs.pop('guids')  # type: List[str]
    min_ext_info = kwargs.pop('min_ext_info', False)  # type: Optional[bool]
    ignore_relationships = kwargs.pop('ignore_relationships', False)  # type: Optional[bool]
    exclude_relationship_types = kwargs.pop('exclude_relationship_types', None)  # type: Optional[List[str]]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/bulk')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['guids'] = [_SERIALIZER.query("guids", q, 'str') if q is not None else '' for q in guids]
    if min_ext_info is not None:
        query_parameters['minExtInfo'] = _SERIALIZER.query("min_ext_info", min_ext_info, 'bool')
    if ignore_relationships is not None:
        query_parameters['ignoreRelationships'] = _SERIALIZER.query("ignore_relationships", ignore_relationships, 'bool')
    if exclude_relationship_types is not None:
        query_parameters['excludeRelationshipTypes'] = [_SERIALIZER.query("exclude_relationship_types", q, 'str') if q is not None else '' for q in exclude_relationship_types]

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_entity_create_or_update_entities_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/bulk')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_entity_delete_by_guids_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    guids = kwargs.pop('guids')  # type: List[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/bulk')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['guids'] = [_SERIALIZER.query("guids", q, 'str') if q is not None else '' for q in guids]

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_entity_add_classification_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/bulk/classification')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_entity_get_by_guid_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    min_ext_info = kwargs.pop('min_ext_info', False)  # type: Optional[bool]
    ignore_relationships = kwargs.pop('ignore_relationships', False)  # type: Optional[bool]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/guid/{guid}')
    path_format_arguments = {
        "guid": _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if min_ext_info is not None:
        query_parameters['minExtInfo'] = _SERIALIZER.query("min_ext_info", min_ext_info, 'bool')
    if ignore_relationships is not None:
        query_parameters['ignoreRelationships'] = _SERIALIZER.query("ignore_relationships", ignore_relationships, 'bool')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_entity_partial_update_entity_attribute_by_guid_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    name = kwargs.pop('name')  # type: str

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/guid/{guid}')
    path_format_arguments = {
        "guid": _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['name'] = _SERIALIZER.query("name", name, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_entity_delete_by_guid_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/guid/{guid}')
    path_format_arguments = {
        "guid": _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_entity_get_classification_request(
    guid,  # type: str
    classification_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/guid/{guid}/classification/{classificationName}')
    path_format_arguments = {
        "guid": _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
        "classificationName": _SERIALIZER.url("classification_name", classification_name, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_entity_delete_classification_request(
    guid,  # type: str
    classification_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/guid/{guid}/classification/{classificationName}')
    path_format_arguments = {
        "guid": _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
        "classificationName": _SERIALIZER.url("classification_name", classification_name, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_entity_get_classifications_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/guid/{guid}/classifications')
    path_format_arguments = {
        "guid": _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_entity_add_classifications_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/guid/{guid}/classifications')
    path_format_arguments = {
        "guid": _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_entity_update_classifications_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/guid/{guid}/classifications')
    path_format_arguments = {
        "guid": _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_entity_get_by_unique_attributes_request(
    type_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    min_ext_info = kwargs.pop('min_ext_info', False)  # type: Optional[bool]
    ignore_relationships = kwargs.pop('ignore_relationships', False)  # type: Optional[bool]
    attr_qualified_name = kwargs.pop('attr_qualified_name', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/uniqueAttribute/type/{typeName}')
    path_format_arguments = {
        "typeName": _SERIALIZER.url("type_name", type_name, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if min_ext_info is not None:
        query_parameters['minExtInfo'] = _SERIALIZER.query("min_ext_info", min_ext_info, 'bool')
    if ignore_relationships is not None:
        query_parameters['ignoreRelationships'] = _SERIALIZER.query("ignore_relationships", ignore_relationships, 'bool')
    if attr_qualified_name is not None:
        query_parameters['attr:qualifiedName'] = _SERIALIZER.query("attr_qualified_name", attr_qualified_name, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_entity_partial_update_entity_by_unique_attributes_request(
    type_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    attr_qualified_name = kwargs.pop('attr_qualified_name', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/uniqueAttribute/type/{typeName}')
    path_format_arguments = {
        "typeName": _SERIALIZER.url("type_name", type_name, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if attr_qualified_name is not None:
        query_parameters['attr:qualifiedName'] = _SERIALIZER.query("attr_qualified_name", attr_qualified_name, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_entity_delete_by_unique_attribute_request(
    type_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    attr_qualified_name = kwargs.pop('attr_qualified_name', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/uniqueAttribute/type/{typeName}')
    path_format_arguments = {
        "typeName": _SERIALIZER.url("type_name", type_name, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if attr_qualified_name is not None:
        query_parameters['attr:qualifiedName'] = _SERIALIZER.query("attr_qualified_name", attr_qualified_name, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_entity_delete_classification_by_unique_attribute_request(
    type_name,  # type: str
    classification_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    attr_qualified_name = kwargs.pop('attr_qualified_name', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/uniqueAttribute/type/{typeName}/classification/{classificationName}')
    path_format_arguments = {
        "typeName": _SERIALIZER.url("type_name", type_name, 'str', max_length=4096, min_length=1),
        "classificationName": _SERIALIZER.url("classification_name", classification_name, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if attr_qualified_name is not None:
        query_parameters['attr:qualifiedName'] = _SERIALIZER.query("attr_qualified_name", attr_qualified_name, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_entity_add_classifications_by_unique_attribute_request(
    type_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    attr_qualified_name = kwargs.pop('attr_qualified_name', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/uniqueAttribute/type/{typeName}/classifications')
    path_format_arguments = {
        "typeName": _SERIALIZER.url("type_name", type_name, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if attr_qualified_name is not None:
        query_parameters['attr:qualifiedName'] = _SERIALIZER.query("attr_qualified_name", attr_qualified_name, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_entity_update_classifications_by_unique_attribute_request(
    type_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    attr_qualified_name = kwargs.pop('attr_qualified_name', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/uniqueAttribute/type/{typeName}/classifications')
    path_format_arguments = {
        "typeName": _SERIALIZER.url("type_name", type_name, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if attr_qualified_name is not None:
        query_parameters['attr:qualifiedName'] = _SERIALIZER.query("attr_qualified_name", attr_qualified_name, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_entity_set_classifications_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/bulk/setClassifications')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_entity_get_entities_by_unique_attributes_request(
    type_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    min_ext_info = kwargs.pop('min_ext_info', False)  # type: Optional[bool]
    ignore_relationships = kwargs.pop('ignore_relationships', False)  # type: Optional[bool]
    attr_n_qualified_name = kwargs.pop('attr_n_qualified_name', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/bulk/uniqueAttribute/type/{typeName}')
    path_format_arguments = {
        "typeName": _SERIALIZER.url("type_name", type_name, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if min_ext_info is not None:
        query_parameters['minExtInfo'] = _SERIALIZER.query("min_ext_info", min_ext_info, 'bool')
    if ignore_relationships is not None:
        query_parameters['ignoreRelationships'] = _SERIALIZER.query("ignore_relationships", ignore_relationships, 'bool')
    if attr_n_qualified_name is not None:
        query_parameters['attr_N:qualifiedName'] = _SERIALIZER.query("attr_n_qualified_name", attr_n_qualified_name, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_entity_get_header_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/guid/{guid}/header')
    path_format_arguments = {
        "guid": _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_list_glossaries_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    limit = kwargs.pop('limit', None)  # type: Optional[int]
    offset = kwargs.pop('offset', None)  # type: Optional[int]
    sort = kwargs.pop('sort', "ASC")  # type: Optional[str]
    ignore_terms_and_categories = kwargs.pop('ignore_terms_and_categories', False)  # type: Optional[bool]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if sort is not None:
        query_parameters['sort'] = _SERIALIZER.query("sort", sort, 'str')
    if ignore_terms_and_categories is not None:
        query_parameters['ignoreTermsAndCategories'] = _SERIALIZER.query("ignore_terms_and_categories", ignore_terms_and_categories, 'bool')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_create_glossary_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_create_glossary_categories_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/categories')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_create_glossary_category_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/category')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_get_glossary_category_request(
    category_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/category/{categoryGuid}')
    path_format_arguments = {
        "categoryGuid": _SERIALIZER.url("category_guid", category_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_update_glossary_category_request(
    category_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/category/{categoryGuid}')
    path_format_arguments = {
        "categoryGuid": _SERIALIZER.url("category_guid", category_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_delete_glossary_category_request(
    category_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/category/{categoryGuid}')
    path_format_arguments = {
        "categoryGuid": _SERIALIZER.url("category_guid", category_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_partial_update_glossary_category_request(
    category_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/category/{categoryGuid}/partial')
    path_format_arguments = {
        "categoryGuid": _SERIALIZER.url("category_guid", category_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_list_related_categories_request(
    category_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    limit = kwargs.pop('limit', None)  # type: Optional[int]
    offset = kwargs.pop('offset', None)  # type: Optional[int]
    sort = kwargs.pop('sort', "ASC")  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/category/{categoryGuid}/related')
    path_format_arguments = {
        "categoryGuid": _SERIALIZER.url("category_guid", category_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if sort is not None:
        query_parameters['sort'] = _SERIALIZER.query("sort", sort, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_list_category_terms_request(
    category_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    limit = kwargs.pop('limit', None)  # type: Optional[int]
    offset = kwargs.pop('offset', None)  # type: Optional[int]
    sort = kwargs.pop('sort', "ASC")  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/category/{categoryGuid}/terms')
    path_format_arguments = {
        "categoryGuid": _SERIALIZER.url("category_guid", category_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if sort is not None:
        query_parameters['sort'] = _SERIALIZER.query("sort", sort, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_create_glossary_term_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/term')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_get_glossary_term_request(
    term_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/term/{termGuid}')
    path_format_arguments = {
        "termGuid": _SERIALIZER.url("term_guid", term_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_update_glossary_term_request(
    term_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/term/{termGuid}')
    path_format_arguments = {
        "termGuid": _SERIALIZER.url("term_guid", term_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_delete_glossary_term_request(
    term_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/term/{termGuid}')
    path_format_arguments = {
        "termGuid": _SERIALIZER.url("term_guid", term_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_partial_update_glossary_term_request(
    term_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/term/{termGuid}/partial')
    path_format_arguments = {
        "termGuid": _SERIALIZER.url("term_guid", term_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_create_glossary_terms_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/terms')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_get_entities_assigned_with_term_request(
    term_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    limit = kwargs.pop('limit', None)  # type: Optional[int]
    offset = kwargs.pop('offset', None)  # type: Optional[int]
    sort = kwargs.pop('sort', "ASC")  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/terms/{termGuid}/assignedEntities')
    path_format_arguments = {
        "termGuid": _SERIALIZER.url("term_guid", term_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if sort is not None:
        query_parameters['sort'] = _SERIALIZER.query("sort", sort, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_assign_term_to_entities_request(
    term_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/terms/{termGuid}/assignedEntities')
    path_format_arguments = {
        "termGuid": _SERIALIZER.url("term_guid", term_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_remove_term_assignment_from_entities_request(
    term_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/terms/{termGuid}/assignedEntities')
    path_format_arguments = {
        "termGuid": _SERIALIZER.url("term_guid", term_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_delete_term_assignment_from_entities_request(
    term_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/terms/{termGuid}/assignedEntities')
    path_format_arguments = {
        "termGuid": _SERIALIZER.url("term_guid", term_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_list_related_terms_request(
    term_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    limit = kwargs.pop('limit', None)  # type: Optional[int]
    offset = kwargs.pop('offset', None)  # type: Optional[int]
    sort = kwargs.pop('sort', "ASC")  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/terms/{termGuid}/related')
    path_format_arguments = {
        "termGuid": _SERIALIZER.url("term_guid", term_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if sort is not None:
        query_parameters['sort'] = _SERIALIZER.query("sort", sort, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_get_glossary_request(
    glossary_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/{glossaryGuid}')
    path_format_arguments = {
        "glossaryGuid": _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_update_glossary_request(
    glossary_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/{glossaryGuid}')
    path_format_arguments = {
        "glossaryGuid": _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_delete_glossary_request(
    glossary_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/{glossaryGuid}')
    path_format_arguments = {
        "glossaryGuid": _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_list_glossary_categories_request(
    glossary_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    limit = kwargs.pop('limit', None)  # type: Optional[int]
    offset = kwargs.pop('offset', None)  # type: Optional[int]
    sort = kwargs.pop('sort', "ASC")  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/{glossaryGuid}/categories')
    path_format_arguments = {
        "glossaryGuid": _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if sort is not None:
        query_parameters['sort'] = _SERIALIZER.query("sort", sort, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_list_glossary_categories_headers_request(
    glossary_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    limit = kwargs.pop('limit', None)  # type: Optional[int]
    offset = kwargs.pop('offset', None)  # type: Optional[int]
    sort = kwargs.pop('sort', "ASC")  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/{glossaryGuid}/categories/headers')
    path_format_arguments = {
        "glossaryGuid": _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if sort is not None:
        query_parameters['sort'] = _SERIALIZER.query("sort", sort, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_get_detailed_glossary_request(
    glossary_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/{glossaryGuid}/detailed')
    path_format_arguments = {
        "glossaryGuid": _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_partial_update_glossary_request(
    glossary_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/{glossaryGuid}/partial')
    path_format_arguments = {
        "glossaryGuid": _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_list_glossary_terms_request(
    glossary_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]
    limit = kwargs.pop('limit', None)  # type: Optional[int]
    offset = kwargs.pop('offset', None)  # type: Optional[int]
    sort = kwargs.pop('sort', "ASC")  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/{glossaryGuid}/terms')
    path_format_arguments = {
        "glossaryGuid": _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if sort is not None:
        query_parameters['sort'] = _SERIALIZER.query("sort", sort, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_list_glossary_term_headers_request(
    glossary_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    limit = kwargs.pop('limit', None)  # type: Optional[int]
    offset = kwargs.pop('offset', None)  # type: Optional[int]
    sort = kwargs.pop('sort', "ASC")  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/{glossaryGuid}/terms/headers')
    path_format_arguments = {
        "glossaryGuid": _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if sort is not None:
        query_parameters['sort'] = _SERIALIZER.query("sort", sort, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_import_glossary_terms_via_csv_request_initial(
    glossary_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]

    api_version = "2021-05-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/glossary/{glossaryGuid}/terms/import')
    path_format_arguments = {
        "glossaryGuid": _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_import_glossary_terms_via_csv_by_glossary_name_request_initial(
    glossary_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]

    api_version = "2021-05-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/glossary/name/{glossaryName}/terms/import')
    path_format_arguments = {
        "glossaryName": _SERIALIZER.url("glossary_name", glossary_name, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_get_import_csv_operation_status_request(
    operation_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = "2021-05-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/glossary/terms/import/{operationGuid}')
    path_format_arguments = {
        "operationGuid": _SERIALIZER.url("operation_guid", operation_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_export_glossary_terms_as_csv_request(
    glossary_guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]

    api_version = "2021-05-01-preview"
    accept = "text/csv"
    # Construct URL
    url = kwargs.pop("template_url", '/glossary/{glossaryGuid}/terms/export')
    path_format_arguments = {
        "glossaryGuid": _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_glossary_list_terms_by_glossary_name_request(
    glossary_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    limit = kwargs.pop('limit', None)  # type: Optional[int]
    offset = kwargs.pop('offset', None)  # type: Optional[int]
    include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]

    api_version = "2021-05-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/glossary/name/{glossaryName}/terms')
    path_format_arguments = {
        "glossaryName": _SERIALIZER.url("glossary_name", glossary_name, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_discovery_query_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    api_version = "2021-05-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/search/query')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_discovery_suggest_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    api_version = "2021-05-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/search/suggest')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_discovery_browse_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    api_version = "2021-05-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/browse')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_discovery_auto_complete_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    api_version = "2021-05-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/search/autocomplete')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_lineage_get_lineage_graph_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    direction = kwargs.pop('direction')  # type: str
    depth = kwargs.pop('depth', 3)  # type: Optional[int]
    width = kwargs.pop('width', 10)  # type: Optional[int]
    include_parent = kwargs.pop('include_parent', None)  # type: Optional[bool]
    get_derived_lineage = kwargs.pop('get_derived_lineage', None)  # type: Optional[bool]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/lineage/{guid}')
    path_format_arguments = {
        "guid": _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if depth is not None:
        query_parameters['depth'] = _SERIALIZER.query("depth", depth, 'int')
    if width is not None:
        query_parameters['width'] = _SERIALIZER.query("width", width, 'int')
    query_parameters['direction'] = _SERIALIZER.query("direction", direction, 'str')
    if include_parent is not None:
        query_parameters['includeParent'] = _SERIALIZER.query("include_parent", include_parent, 'bool')
    if get_derived_lineage is not None:
        query_parameters['getDerivedLineage'] = _SERIALIZER.query("get_derived_lineage", get_derived_lineage, 'bool')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_lineage_next_page_lineage_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    direction = kwargs.pop('direction')  # type: str
    get_derived_lineage = kwargs.pop('get_derived_lineage', None)  # type: Optional[bool]
    offset = kwargs.pop('offset', None)  # type: Optional[int]
    limit = kwargs.pop('limit', None)  # type: Optional[int]

    api_version = "2021-05-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/lineage/{guid}/next/')
    path_format_arguments = {
        "guid": _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['direction'] = _SERIALIZER.query("direction", direction, 'str')
    if get_derived_lineage is not None:
        query_parameters['getDerivedLineage'] = _SERIALIZER.query("get_derived_lineage", get_derived_lineage, 'bool')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_relationship_create_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/relationship')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_relationship_update_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/relationship')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_relationship_get_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    extended_info = kwargs.pop('extended_info', None)  # type: Optional[bool]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/relationship/guid/{guid}')
    path_format_arguments = {
        "guid": _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if extended_info is not None:
        query_parameters['extendedInfo'] = _SERIALIZER.query("extended_info", extended_info, 'bool')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_relationship_delete_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/relationship/guid/{guid}')
    path_format_arguments = {
        "guid": _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_types_get_classification_def_by_guid_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/classificationdef/guid/{guid}')
    path_format_arguments = {
        "guid": _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_types_get_classification_def_by_name_request(
    name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/classificationdef/name/{name}')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_types_get_entity_definition_by_guid_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/entitydef/guid/{guid}')
    path_format_arguments = {
        "guid": _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_types_get_entity_definition_by_name_request(
    name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/entitydef/name/{name}')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_types_get_enum_def_by_guid_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/enumdef/guid/{guid}')
    path_format_arguments = {
        "guid": _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_types_get_enum_def_by_name_request(
    name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/enumdef/name/{name}')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_types_get_relationship_def_by_guid_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/relationshipdef/guid/{guid}')
    path_format_arguments = {
        "guid": _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_types_get_relationship_def_by_name_request(
    name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/relationshipdef/name/{name}')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_types_get_struct_def_by_guid_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/structdef/guid/{guid}')
    path_format_arguments = {
        "guid": _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_types_get_struct_def_by_name_request(
    name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/structdef/name/{name}')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_types_get_type_definition_by_guid_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/typedef/guid/{guid}')
    path_format_arguments = {
        "guid": _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_types_get_type_definition_by_name_request(
    name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/typedef/name/{name}')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_types_delete_type_by_name_request(
    name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/typedef/name/{name}')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_types_get_all_type_definitions_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    include_term_template = kwargs.pop('include_term_template', False)  # type: Optional[bool]
    type = kwargs.pop('type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/typedefs')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_template is not None:
        query_parameters['includeTermTemplate'] = _SERIALIZER.query("include_term_template", include_term_template, 'bool')
    if type is not None:
        query_parameters['type'] = _SERIALIZER.query("type", type, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_types_create_type_definitions_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/typedefs')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_types_update_atlas_type_definitions_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/typedefs')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_types_delete_type_definitions_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/typedefs')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_types_list_type_definition_headers_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    include_term_template = kwargs.pop('include_term_template', False)  # type: Optional[bool]
    type = kwargs.pop('type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/typedefs/headers')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_template is not None:
        query_parameters['includeTermTemplate'] = _SERIALIZER.query("include_term_template", include_term_template, 'bool')
    if type is not None:
        query_parameters['type'] = _SERIALIZER.query("type", type, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_types_get_term_template_def_by_guid_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = "2021-05-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/types/termtemplatedef/guid/{guid}')
    path_format_arguments = {
        "guid": _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_types_get_term_template_def_by_name_request(
    name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = "2021-05-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/types/termtemplatedef/name/{name}')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str', max_length=4096, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_collection_create_or_update_request(
    collection,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    api_version = "2021-05-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/collections/{collection}/entity')
    path_format_arguments = {
        "collection": _SERIALIZER.url("collection", collection, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_collection_create_or_update_bulk_request(
    collection,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    api_version = "2021-05-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/collections/{collection}/entity/bulk')
    path_format_arguments = {
        "collection": _SERIALIZER.url("collection", collection, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_collection_move_entities_to_collection_request(
    collection,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    api_version = "2021-05-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/collections/{collection}/entity/moveHere')
    path_format_arguments = {
        "collection": _SERIALIZER.url("collection", collection, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )

# fmt: on
class EntityOperations(object):
    """EntityOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def create_or_update(
        self,
        entity,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Create or update an entity in Atlas.
        Existing entity is matched using its unique guid if supplied or by its unique attributes eg:
        qualifiedName.
        Map and array of collections are not well supported. E.g., array<array:code:`<int>`>,
        array<map<string, int>>.

        :param entity: Atlas entity with extended information.
        :type entity: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                entity = {
                    "entity": {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the entity.
                                "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                "source": "str",  # Optional. indicate the source who create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The end of the time boundary.
                                        "startTime": "str",  # Optional. The start of the time boundary.
                                        "timeZone": "str"  # Optional. The timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active Directory object Id.
                                    "info": "str"  # Optional. additional information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0.0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "guid": "str",  # Optional. The GUID of the entity.
                        "homeId": "str",  # Optional. The home ID of the entity.
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "meanings": [
                            {
                                "confidence": 0,  # Optional. The confidence of the term assignment.
                                "createdBy": "str",  # Optional. The user who created the record.
                                "description": "str",  # Optional. The description of the term assignment.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term assignment.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "provenanceType": 0.0,  # Optional. Used to record the provenance of an instance of an entity or relationship.
                        "proxy": bool,  # Optional. Determines if there's a proxy.
                        "relationshipAttributes": {
                            "str": {}  # Optional. The attributes of relationship.
                        },
                        "source": "str",  # Optional. indicate the source who create the classification detail.
                        "sourceDetails": {
                            "str": {}  # Optional. more detail on source information.
                        },
                        "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                        "typeName": "str",  # Optional. The name of the type.
                        "updateTime": 0.0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "version": 0.0  # Optional. The version of the entity.
                    },
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure Active Directory object Id.
                                        "info": "str"  # Optional. additional information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence of the term assignment.
                                    "createdBy": "str",  # Optional. The user who created the record.
                                    "description": "str",  # Optional. The description of the term assignment.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "provenanceType": 0.0,  # Optional. Used to record the provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of relationship.
                            },
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the entity.
                        }
                    }
                }

                # response body for status code(s): 200
                response.json() == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The GUID of the entity.
                                        "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                        "source": "str",  # Optional. indicate the source who create the classification detail.
                                        "sourceDetails": {
                                            "str": {}  # Optional. more detail on source information.
                                        },
                                        "typeName": "str",  # Optional. The name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  # Optional. The end of the time boundary.
                                                "startTime": "str",  # Optional. The start of the time boundary.
                                                "timeZone": "str"  # Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The user who created the record.
                                        "description": "str",  # Optional. The description of the term assignment.
                                        "displayText": "str",  # Optional. The display text.
                                        "expression": "str",  # Optional. The expression of the term assignment.
                                        "relationGuid": "str",  # Optional. The GUID of the relationship.
                                        "source": "str",  # Optional. The source of the term.
                                        "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                        "steward": "str",  # Optional. The steward of the term.
                                        "termGuid": "str"  # Optional. The GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence of the term assignment.
                                    "createdBy": "str",  # Optional. The user who created the record.
                                    "description": "str",  # Optional. The description of the term assignment.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = entity

        request = build_entity_create_or_update_request(
            content_type=content_type,
            json=json,
            template_url=self.create_or_update.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update.metadata = {'url': '/atlas/v2/entity'}  # type: ignore


    @distributed_trace
    def list_by_guids(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """List entities in bulk identified by its GUIDs.

        :keyword guids: An array of GUIDs of entities to create.
        :paramtype guids: list[str]
        :keyword min_ext_info: Whether to return minimal information for referred entities.
        :paramtype min_ext_info: bool
        :keyword ignore_relationships: Whether to ignore relationship attributes.
        :paramtype ignore_relationships: bool
        :keyword exclude_relationship_types: An array of the relationship types need to be excluded
         from the response.
        :paramtype exclude_relationship_types: list[str]
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "entities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure Active Directory object Id.
                                        "info": "str"  # Optional. additional information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence of the term assignment.
                                    "createdBy": "str",  # Optional. The user who created the record.
                                    "description": "str",  # Optional. The description of the term assignment.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "provenanceType": 0.0,  # Optional. Used to record the provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of relationship.
                            },
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the entity.
                        }
                    ],
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure Active Directory object Id.
                                        "info": "str"  # Optional. additional information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence of the term assignment.
                                    "createdBy": "str",  # Optional. The user who created the record.
                                    "description": "str",  # Optional. The description of the term assignment.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "provenanceType": 0.0,  # Optional. Used to record the provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of relationship.
                            },
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the entity.
                        }
                    }
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        guids = kwargs.pop('guids')  # type: List[str]
        min_ext_info = kwargs.pop('min_ext_info', False)  # type: Optional[bool]
        ignore_relationships = kwargs.pop('ignore_relationships', False)  # type: Optional[bool]
        exclude_relationship_types = kwargs.pop('exclude_relationship_types', None)  # type: Optional[List[str]]

        
        request = build_entity_list_by_guids_request(
            guids=guids,
            min_ext_info=min_ext_info,
            ignore_relationships=ignore_relationships,
            exclude_relationship_types=exclude_relationship_types,
            template_url=self.list_by_guids.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_by_guids.metadata = {'url': '/atlas/v2/entity/bulk'}  # type: ignore


    @distributed_trace
    def create_or_update_entities(
        self,
        entities,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Create or update entities in Atlas in bulk.
        Existing entity is matched using its unique guid if supplied or by its unique attributes eg:
        qualifiedName.
        Map and array of collections are not well supported. E.g., array<array:code:`<int>`>,
        array<map<string, int>>.

        :param entities: An array of entities to create or update.
        :type entities: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                entities = {
                    "entities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure Active Directory object Id.
                                        "info": "str"  # Optional. additional information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence of the term assignment.
                                    "createdBy": "str",  # Optional. The user who created the record.
                                    "description": "str",  # Optional. The description of the term assignment.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "provenanceType": 0.0,  # Optional. Used to record the provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of relationship.
                            },
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the entity.
                        }
                    ],
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure Active Directory object Id.
                                        "info": "str"  # Optional. additional information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence of the term assignment.
                                    "createdBy": "str",  # Optional. The user who created the record.
                                    "description": "str",  # Optional. The description of the term assignment.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "provenanceType": 0.0,  # Optional. Used to record the provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of relationship.
                            },
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the entity.
                        }
                    }
                }

                # response body for status code(s): 200
                response.json() == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The GUID of the entity.
                                        "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                        "source": "str",  # Optional. indicate the source who create the classification detail.
                                        "sourceDetails": {
                                            "str": {}  # Optional. more detail on source information.
                                        },
                                        "typeName": "str",  # Optional. The name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  # Optional. The end of the time boundary.
                                                "startTime": "str",  # Optional. The start of the time boundary.
                                                "timeZone": "str"  # Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The user who created the record.
                                        "description": "str",  # Optional. The description of the term assignment.
                                        "displayText": "str",  # Optional. The display text.
                                        "expression": "str",  # Optional. The expression of the term assignment.
                                        "relationGuid": "str",  # Optional. The GUID of the relationship.
                                        "source": "str",  # Optional. The source of the term.
                                        "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                        "steward": "str",  # Optional. The steward of the term.
                                        "termGuid": "str"  # Optional. The GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence of the term assignment.
                                    "createdBy": "str",  # Optional. The user who created the record.
                                    "description": "str",  # Optional. The description of the term assignment.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = entities

        request = build_entity_create_or_update_entities_request(
            content_type=content_type,
            json=json,
            template_url=self.create_or_update_entities.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update_entities.metadata = {'url': '/atlas/v2/entity/bulk'}  # type: ignore


    @distributed_trace
    def delete_by_guids(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Delete a list of entities in bulk identified by their GUIDs or unique attributes.

        :keyword guids: An array of GUIDs of entities to delete.
        :paramtype guids: list[str]
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The GUID of the entity.
                                        "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                        "source": "str",  # Optional. indicate the source who create the classification detail.
                                        "sourceDetails": {
                                            "str": {}  # Optional. more detail on source information.
                                        },
                                        "typeName": "str",  # Optional. The name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  # Optional. The end of the time boundary.
                                                "startTime": "str",  # Optional. The start of the time boundary.
                                                "timeZone": "str"  # Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The user who created the record.
                                        "description": "str",  # Optional. The description of the term assignment.
                                        "displayText": "str",  # Optional. The display text.
                                        "expression": "str",  # Optional. The expression of the term assignment.
                                        "relationGuid": "str",  # Optional. The GUID of the relationship.
                                        "source": "str",  # Optional. The source of the term.
                                        "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                        "steward": "str",  # Optional. The steward of the term.
                                        "termGuid": "str"  # Optional. The GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence of the term assignment.
                                    "createdBy": "str",  # Optional. The user who created the record.
                                    "description": "str",  # Optional. The description of the term assignment.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        guids = kwargs.pop('guids')  # type: List[str]

        
        request = build_entity_delete_by_guids_request(
            guids=guids,
            template_url=self.delete_by_guids.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_by_guids.metadata = {'url': '/atlas/v2/entity/bulk'}  # type: ignore


    @distributed_trace
    def add_classification(
        self,
        request,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Associate a classification to multiple entities in bulk.

        :param request: The request to associate a classification to multiple entities.
        :type request: Any
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                request = {
                    "classification": {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "entityGuid": "str",  # Optional. The GUID of the entity.
                        "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                        "source": "str",  # Optional. indicate the source who create the classification detail.
                        "sourceDetails": {
                            "str": {}  # Optional. more detail on source information.
                        },
                        "typeName": "str",  # Optional. The name of the type.
                        "validityPeriods": [
                            {
                                "endTime": "str",  # Optional. The end of the time boundary.
                                "startTime": "str",  # Optional. The start of the time boundary.
                                "timeZone": "str"  # Optional. The timezone of the time boundary.
                            }
                        ]
                    },
                    "entityGuids": [
                        "str"  # Optional. The GUID of the entity.
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = request

        request = build_entity_add_classification_request(
            content_type=content_type,
            json=json,
            template_url=self.add_classification.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    add_classification.metadata = {'url': '/atlas/v2/entity/bulk/classification'}  # type: ignore


    @distributed_trace
    def get_by_guid(
        self,
        guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get complete definition of an entity given its GUID.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :keyword min_ext_info: Whether to return minimal information for referred entities.
        :paramtype min_ext_info: bool
        :keyword ignore_relationships: Whether to ignore relationship attributes.
        :paramtype ignore_relationships: bool
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "entity": {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the entity.
                                "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                "source": "str",  # Optional. indicate the source who create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The end of the time boundary.
                                        "startTime": "str",  # Optional. The start of the time boundary.
                                        "timeZone": "str"  # Optional. The timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active Directory object Id.
                                    "info": "str"  # Optional. additional information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0.0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "guid": "str",  # Optional. The GUID of the entity.
                        "homeId": "str",  # Optional. The home ID of the entity.
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "meanings": [
                            {
                                "confidence": 0,  # Optional. The confidence of the term assignment.
                                "createdBy": "str",  # Optional. The user who created the record.
                                "description": "str",  # Optional. The description of the term assignment.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term assignment.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "provenanceType": 0.0,  # Optional. Used to record the provenance of an instance of an entity or relationship.
                        "proxy": bool,  # Optional. Determines if there's a proxy.
                        "relationshipAttributes": {
                            "str": {}  # Optional. The attributes of relationship.
                        },
                        "source": "str",  # Optional. indicate the source who create the classification detail.
                        "sourceDetails": {
                            "str": {}  # Optional. more detail on source information.
                        },
                        "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                        "typeName": "str",  # Optional. The name of the type.
                        "updateTime": 0.0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "version": 0.0  # Optional. The version of the entity.
                    },
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure Active Directory object Id.
                                        "info": "str"  # Optional. additional information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence of the term assignment.
                                    "createdBy": "str",  # Optional. The user who created the record.
                                    "description": "str",  # Optional. The description of the term assignment.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "provenanceType": 0.0,  # Optional. Used to record the provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of relationship.
                            },
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the entity.
                        }
                    }
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        min_ext_info = kwargs.pop('min_ext_info', False)  # type: Optional[bool]
        ignore_relationships = kwargs.pop('ignore_relationships', False)  # type: Optional[bool]

        
        request = build_entity_get_by_guid_request(
            guid=guid,
            min_ext_info=min_ext_info,
            ignore_relationships=ignore_relationships,
            template_url=self.get_by_guid.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_by_guid.metadata = {'url': '/atlas/v2/entity/guid/{guid}'}  # type: ignore


    @distributed_trace
    def partial_update_entity_attribute_by_guid(
        self,
        guid,  # type: str
        body,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Update entity partially - create or update entity attribute identified by its GUID.
        Supports only primitive attribute type and entity references.
        It does not support updating complex types like arrays, and maps.
        Null updates are not possible.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :param body: The value of the attribute.
        :type body: any
        :keyword name: The name of the attribute.
        :paramtype name: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        name = kwargs.pop('name')  # type: str

        json = body

        request = build_entity_partial_update_entity_attribute_by_guid_request(
            guid=guid,
            content_type=content_type,
            name=name,
            json=json,
            template_url=self.partial_update_entity_attribute_by_guid.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    partial_update_entity_attribute_by_guid.metadata = {'url': '/atlas/v2/entity/guid/{guid}'}  # type: ignore


    @distributed_trace
    def delete_by_guid(
        self,
        guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Delete an entity identified by its GUID.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The GUID of the entity.
                                        "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                        "source": "str",  # Optional. indicate the source who create the classification detail.
                                        "sourceDetails": {
                                            "str": {}  # Optional. more detail on source information.
                                        },
                                        "typeName": "str",  # Optional. The name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  # Optional. The end of the time boundary.
                                                "startTime": "str",  # Optional. The start of the time boundary.
                                                "timeZone": "str"  # Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The user who created the record.
                                        "description": "str",  # Optional. The description of the term assignment.
                                        "displayText": "str",  # Optional. The display text.
                                        "expression": "str",  # Optional. The expression of the term assignment.
                                        "relationGuid": "str",  # Optional. The GUID of the relationship.
                                        "source": "str",  # Optional. The source of the term.
                                        "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                        "steward": "str",  # Optional. The steward of the term.
                                        "termGuid": "str"  # Optional. The GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence of the term assignment.
                                    "createdBy": "str",  # Optional. The user who created the record.
                                    "description": "str",  # Optional. The description of the term assignment.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_entity_delete_by_guid_request(
            guid=guid,
            template_url=self.delete_by_guid.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_by_guid.metadata = {'url': '/atlas/v2/entity/guid/{guid}'}  # type: ignore


    @distributed_trace
    def get_classification(
        self,
        guid,  # type: str
        classification_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """List classifications for a given entity represented by a GUID.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :param classification_name: The name of the classification.
        :type classification_name: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributes": {
                        "str": {}  # Optional. The attributes of the struct.
                    },
                    "entityGuid": "str",  # Optional. The GUID of the entity.
                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                    "source": "str",  # Optional. indicate the source who create the classification detail.
                    "sourceDetails": {
                        "str": {}  # Optional. more detail on source information.
                    },
                    "typeName": "str",  # Optional. The name of the type.
                    "validityPeriods": [
                        {
                            "endTime": "str",  # Optional. The end of the time boundary.
                            "startTime": "str",  # Optional. The start of the time boundary.
                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_entity_get_classification_request(
            guid=guid,
            classification_name=classification_name,
            template_url=self.get_classification.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_classification.metadata = {'url': '/atlas/v2/entity/guid/{guid}/classification/{classificationName}'}  # type: ignore


    @distributed_trace
    def delete_classification(
        self,
        guid,  # type: str
        classification_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Delete a given classification from an existing entity represented by a GUID.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :param classification_name: The name of the classification.
        :type classification_name: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_entity_delete_classification_request(
            guid=guid,
            classification_name=classification_name,
            template_url=self.delete_classification.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    delete_classification.metadata = {'url': '/atlas/v2/entity/guid/{guid}/classification/{classificationName}'}  # type: ignore


    @distributed_trace
    def get_classifications(
        self,
        guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """List classifications for a given entity represented by a GUID.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "list": [
                        {}  # Optional. An array of objects.
                    ],
                    "pageSize": 0,  # Optional. The size of the page.
                    "sortBy": "str",  # Optional. The sorted by field.
                    "sortType": "str",  # Optional. to specify whether the result should be sorted? If yes, whether asc or desc. Possible values include: "NONE", "ASC", "DESC".
                    "startIndex": 0.0,  # Optional. The start index of the page.
                    "totalCount": 0.0  # Optional. The total count of items.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_entity_get_classifications_request(
            guid=guid,
            template_url=self.get_classifications.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_classifications.metadata = {'url': '/atlas/v2/entity/guid/{guid}/classifications'}  # type: ignore


    @distributed_trace
    def add_classifications(
        self,
        guid,  # type: str
        classifications,  # type: List[Any]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Add classifications to an existing entity represented by a GUID.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :param classifications: An array of classifications to be added.
        :type classifications: list[Any]
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                classifications = [
                    {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "entityGuid": "str",  # Optional. The GUID of the entity.
                        "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                        "source": "str",  # Optional. indicate the source who create the classification detail.
                        "sourceDetails": {
                            "str": {}  # Optional. more detail on source information.
                        },
                        "typeName": "str",  # Optional. The name of the type.
                        "validityPeriods": [
                            {
                                "endTime": "str",  # Optional. The end of the time boundary.
                                "startTime": "str",  # Optional. The start of the time boundary.
                                "timeZone": "str"  # Optional. The timezone of the time boundary.
                            }
                        ]
                    }
                ]
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = classifications

        request = build_entity_add_classifications_request(
            guid=guid,
            content_type=content_type,
            json=json,
            template_url=self.add_classifications.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    add_classifications.metadata = {'url': '/atlas/v2/entity/guid/{guid}/classifications'}  # type: ignore


    @distributed_trace
    def update_classifications(
        self,
        guid,  # type: str
        classifications,  # type: List[Any]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Update classifications to an existing entity represented by a guid.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :param classifications: An array of classifications to be updated.
        :type classifications: list[Any]
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                classifications = [
                    {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "entityGuid": "str",  # Optional. The GUID of the entity.
                        "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                        "source": "str",  # Optional. indicate the source who create the classification detail.
                        "sourceDetails": {
                            "str": {}  # Optional. more detail on source information.
                        },
                        "typeName": "str",  # Optional. The name of the type.
                        "validityPeriods": [
                            {
                                "endTime": "str",  # Optional. The end of the time boundary.
                                "startTime": "str",  # Optional. The start of the time boundary.
                                "timeZone": "str"  # Optional. The timezone of the time boundary.
                            }
                        ]
                    }
                ]
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = classifications

        request = build_entity_update_classifications_request(
            guid=guid,
            content_type=content_type,
            json=json,
            template_url=self.update_classifications.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    update_classifications.metadata = {'url': '/atlas/v2/entity/guid/{guid}/classifications'}  # type: ignore


    @distributed_trace
    def get_by_unique_attributes(
        self,
        type_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get complete definition of an entity given its type and unique attribute.
        In addition to the typeName path parameter, attribute key-value pair(s) can be provided in the
        following format:
        attr:\:code:`<attrName>`=:code:`<attrValue>`.
        NOTE: The attrName and attrValue should be unique across entities, eg. qualifiedName.
        The REST request would look something like this:
        GET /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type.
        :type type_name: str
        :keyword min_ext_info: Whether to return minimal information for referred entities.
        :paramtype min_ext_info: bool
        :keyword ignore_relationships: Whether to ignore relationship attributes.
        :paramtype ignore_relationships: bool
        :keyword attr_qualified_name: The qualified name of the entity.
        :paramtype attr_qualified_name: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "entity": {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the entity.
                                "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                "source": "str",  # Optional. indicate the source who create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The end of the time boundary.
                                        "startTime": "str",  # Optional. The start of the time boundary.
                                        "timeZone": "str"  # Optional. The timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active Directory object Id.
                                    "info": "str"  # Optional. additional information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0.0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "guid": "str",  # Optional. The GUID of the entity.
                        "homeId": "str",  # Optional. The home ID of the entity.
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "meanings": [
                            {
                                "confidence": 0,  # Optional. The confidence of the term assignment.
                                "createdBy": "str",  # Optional. The user who created the record.
                                "description": "str",  # Optional. The description of the term assignment.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term assignment.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "provenanceType": 0.0,  # Optional. Used to record the provenance of an instance of an entity or relationship.
                        "proxy": bool,  # Optional. Determines if there's a proxy.
                        "relationshipAttributes": {
                            "str": {}  # Optional. The attributes of relationship.
                        },
                        "source": "str",  # Optional. indicate the source who create the classification detail.
                        "sourceDetails": {
                            "str": {}  # Optional. more detail on source information.
                        },
                        "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                        "typeName": "str",  # Optional. The name of the type.
                        "updateTime": 0.0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "version": 0.0  # Optional. The version of the entity.
                    },
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure Active Directory object Id.
                                        "info": "str"  # Optional. additional information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence of the term assignment.
                                    "createdBy": "str",  # Optional. The user who created the record.
                                    "description": "str",  # Optional. The description of the term assignment.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "provenanceType": 0.0,  # Optional. Used to record the provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of relationship.
                            },
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the entity.
                        }
                    }
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        min_ext_info = kwargs.pop('min_ext_info', False)  # type: Optional[bool]
        ignore_relationships = kwargs.pop('ignore_relationships', False)  # type: Optional[bool]
        attr_qualified_name = kwargs.pop('attr_qualified_name', None)  # type: Optional[str]

        
        request = build_entity_get_by_unique_attributes_request(
            type_name=type_name,
            min_ext_info=min_ext_info,
            ignore_relationships=ignore_relationships,
            attr_qualified_name=attr_qualified_name,
            template_url=self.get_by_unique_attributes.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_by_unique_attributes.metadata = {'url': '/atlas/v2/entity/uniqueAttribute/type/{typeName}'}  # type: ignore


    @distributed_trace
    def partial_update_entity_by_unique_attributes(
        self,
        type_name,  # type: str
        atlas_entity_with_ext_info,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Update entity partially - Allow a subset of attributes to be updated on
        an entity which is identified by its type and unique attribute  eg:
        Referenceable.qualifiedName.
        Null updates are not possible.
        In addition to the typeName path parameter, attribute key-value pair(s) can be provided in the
        following format:
        attr::code:`<attrName>`=:code:`<attrValue>`.
        NOTE: The attrName and attrValue should be unique across entities, eg. qualifiedName.
        The REST request would look something like this:
        PUT /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type.
        :type type_name: str
        :param atlas_entity_with_ext_info: Atlas entity with extended information.
        :type atlas_entity_with_ext_info: Any
        :keyword attr_qualified_name: The qualified name of the entity.
        :paramtype attr_qualified_name: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                atlas_entity_with_ext_info = {
                    "entity": {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the entity.
                                "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                "source": "str",  # Optional. indicate the source who create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The end of the time boundary.
                                        "startTime": "str",  # Optional. The start of the time boundary.
                                        "timeZone": "str"  # Optional. The timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active Directory object Id.
                                    "info": "str"  # Optional. additional information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0.0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "guid": "str",  # Optional. The GUID of the entity.
                        "homeId": "str",  # Optional. The home ID of the entity.
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "meanings": [
                            {
                                "confidence": 0,  # Optional. The confidence of the term assignment.
                                "createdBy": "str",  # Optional. The user who created the record.
                                "description": "str",  # Optional. The description of the term assignment.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term assignment.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "provenanceType": 0.0,  # Optional. Used to record the provenance of an instance of an entity or relationship.
                        "proxy": bool,  # Optional. Determines if there's a proxy.
                        "relationshipAttributes": {
                            "str": {}  # Optional. The attributes of relationship.
                        },
                        "source": "str",  # Optional. indicate the source who create the classification detail.
                        "sourceDetails": {
                            "str": {}  # Optional. more detail on source information.
                        },
                        "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                        "typeName": "str",  # Optional. The name of the type.
                        "updateTime": 0.0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "version": 0.0  # Optional. The version of the entity.
                    },
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure Active Directory object Id.
                                        "info": "str"  # Optional. additional information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence of the term assignment.
                                    "createdBy": "str",  # Optional. The user who created the record.
                                    "description": "str",  # Optional. The description of the term assignment.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "provenanceType": 0.0,  # Optional. Used to record the provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of relationship.
                            },
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the entity.
                        }
                    }
                }

                # response body for status code(s): 200
                response.json() == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The GUID of the entity.
                                        "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                        "source": "str",  # Optional. indicate the source who create the classification detail.
                                        "sourceDetails": {
                                            "str": {}  # Optional. more detail on source information.
                                        },
                                        "typeName": "str",  # Optional. The name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  # Optional. The end of the time boundary.
                                                "startTime": "str",  # Optional. The start of the time boundary.
                                                "timeZone": "str"  # Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The user who created the record.
                                        "description": "str",  # Optional. The description of the term assignment.
                                        "displayText": "str",  # Optional. The display text.
                                        "expression": "str",  # Optional. The expression of the term assignment.
                                        "relationGuid": "str",  # Optional. The GUID of the relationship.
                                        "source": "str",  # Optional. The source of the term.
                                        "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                        "steward": "str",  # Optional. The steward of the term.
                                        "termGuid": "str"  # Optional. The GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence of the term assignment.
                                    "createdBy": "str",  # Optional. The user who created the record.
                                    "description": "str",  # Optional. The description of the term assignment.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        attr_qualified_name = kwargs.pop('attr_qualified_name', None)  # type: Optional[str]

        json = atlas_entity_with_ext_info

        request = build_entity_partial_update_entity_by_unique_attributes_request(
            type_name=type_name,
            content_type=content_type,
            attr_qualified_name=attr_qualified_name,
            json=json,
            template_url=self.partial_update_entity_by_unique_attributes.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    partial_update_entity_by_unique_attributes.metadata = {'url': '/atlas/v2/entity/uniqueAttribute/type/{typeName}'}  # type: ignore


    @distributed_trace
    def delete_by_unique_attribute(
        self,
        type_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Delete an entity identified by its type and unique attributes.
        In addition to the typeName path parameter, attribute key-value pair(s) can be provided in the
        following format:
        attr:\:code:`<attrName>`=\:code:`<attrValue>`.
        NOTE: The attrName and attrValue should be unique across entities, eg. qualifiedName.
        The REST request would look something like this:
        DELETE /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type.
        :type type_name: str
        :keyword attr_qualified_name: The qualified name of the entity.
        :paramtype attr_qualified_name: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The GUID of the entity.
                                        "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                        "source": "str",  # Optional. indicate the source who create the classification detail.
                                        "sourceDetails": {
                                            "str": {}  # Optional. more detail on source information.
                                        },
                                        "typeName": "str",  # Optional. The name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  # Optional. The end of the time boundary.
                                                "startTime": "str",  # Optional. The start of the time boundary.
                                                "timeZone": "str"  # Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The user who created the record.
                                        "description": "str",  # Optional. The description of the term assignment.
                                        "displayText": "str",  # Optional. The display text.
                                        "expression": "str",  # Optional. The expression of the term assignment.
                                        "relationGuid": "str",  # Optional. The GUID of the relationship.
                                        "source": "str",  # Optional. The source of the term.
                                        "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                        "steward": "str",  # Optional. The steward of the term.
                                        "termGuid": "str"  # Optional. The GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence of the term assignment.
                                    "createdBy": "str",  # Optional. The user who created the record.
                                    "description": "str",  # Optional. The description of the term assignment.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        attr_qualified_name = kwargs.pop('attr_qualified_name', None)  # type: Optional[str]

        
        request = build_entity_delete_by_unique_attribute_request(
            type_name=type_name,
            attr_qualified_name=attr_qualified_name,
            template_url=self.delete_by_unique_attribute.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_by_unique_attribute.metadata = {'url': '/atlas/v2/entity/uniqueAttribute/type/{typeName}'}  # type: ignore


    @distributed_trace
    def delete_classification_by_unique_attribute(
        self,
        type_name,  # type: str
        classification_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Delete a given classification from an entity identified by its type and unique attributes.

        :param type_name: The name of the type.
        :type type_name: str
        :param classification_name: The name of the classification.
        :type classification_name: str
        :keyword attr_qualified_name: The qualified name of the entity.
        :paramtype attr_qualified_name: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        attr_qualified_name = kwargs.pop('attr_qualified_name', None)  # type: Optional[str]

        
        request = build_entity_delete_classification_by_unique_attribute_request(
            type_name=type_name,
            classification_name=classification_name,
            attr_qualified_name=attr_qualified_name,
            template_url=self.delete_classification_by_unique_attribute.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    delete_classification_by_unique_attribute.metadata = {'url': '/atlas/v2/entity/uniqueAttribute/type/{typeName}/classification/{classificationName}'}  # type: ignore


    @distributed_trace
    def add_classifications_by_unique_attribute(
        self,
        type_name,  # type: str
        atlas_classification_array,  # type: List[Any]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Add classification to the entity identified by its type and unique attributes.

        :param type_name: The name of the type.
        :type type_name: str
        :param atlas_classification_array: An array of classification to be added.
        :type atlas_classification_array: list[Any]
        :keyword attr_qualified_name: The qualified name of the entity.
        :paramtype attr_qualified_name: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                atlas_classification_array = [
                    {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "entityGuid": "str",  # Optional. The GUID of the entity.
                        "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                        "source": "str",  # Optional. indicate the source who create the classification detail.
                        "sourceDetails": {
                            "str": {}  # Optional. more detail on source information.
                        },
                        "typeName": "str",  # Optional. The name of the type.
                        "validityPeriods": [
                            {
                                "endTime": "str",  # Optional. The end of the time boundary.
                                "startTime": "str",  # Optional. The start of the time boundary.
                                "timeZone": "str"  # Optional. The timezone of the time boundary.
                            }
                        ]
                    }
                ]
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        attr_qualified_name = kwargs.pop('attr_qualified_name', None)  # type: Optional[str]

        json = atlas_classification_array

        request = build_entity_add_classifications_by_unique_attribute_request(
            type_name=type_name,
            content_type=content_type,
            attr_qualified_name=attr_qualified_name,
            json=json,
            template_url=self.add_classifications_by_unique_attribute.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    add_classifications_by_unique_attribute.metadata = {'url': '/atlas/v2/entity/uniqueAttribute/type/{typeName}/classifications'}  # type: ignore


    @distributed_trace
    def update_classifications_by_unique_attribute(
        self,
        type_name,  # type: str
        atlas_classification_array,  # type: List[Any]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Update classification on an entity identified by its type and unique attributes.

        :param type_name: The name of the type.
        :type type_name: str
        :param atlas_classification_array: An array of classification to be updated.
        :type atlas_classification_array: list[Any]
        :keyword attr_qualified_name: The qualified name of the entity.
        :paramtype attr_qualified_name: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                atlas_classification_array = [
                    {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "entityGuid": "str",  # Optional. The GUID of the entity.
                        "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                        "source": "str",  # Optional. indicate the source who create the classification detail.
                        "sourceDetails": {
                            "str": {}  # Optional. more detail on source information.
                        },
                        "typeName": "str",  # Optional. The name of the type.
                        "validityPeriods": [
                            {
                                "endTime": "str",  # Optional. The end of the time boundary.
                                "startTime": "str",  # Optional. The start of the time boundary.
                                "timeZone": "str"  # Optional. The timezone of the time boundary.
                            }
                        ]
                    }
                ]
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        attr_qualified_name = kwargs.pop('attr_qualified_name', None)  # type: Optional[str]

        json = atlas_classification_array

        request = build_entity_update_classifications_by_unique_attribute_request(
            type_name=type_name,
            content_type=content_type,
            attr_qualified_name=attr_qualified_name,
            json=json,
            template_url=self.update_classifications_by_unique_attribute.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    update_classifications_by_unique_attribute.metadata = {'url': '/atlas/v2/entity/uniqueAttribute/type/{typeName}/classifications'}  # type: ignore


    @distributed_trace
    def set_classifications(
        self,
        entity_headers,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> List[str]
        """Set classifications on entities in bulk.

        :param entity_headers: Atlas entity headers.
        :type entity_headers: Any
        :return: list of str
        :rtype: list[str]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                entity_headers = {
                    "guidHeaderMap": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence of the term assignment.
                                    "createdBy": "str",  # Optional. The user who created the record.
                                    "description": "str",  # Optional. The description of the term assignment.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    }
                }

                # response body for status code(s): 200
                response.json() == [
                    "str"  # Optional.
                ]
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[List[str]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = entity_headers

        request = build_entity_set_classifications_request(
            content_type=content_type,
            json=json,
            template_url=self.set_classifications.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    set_classifications.metadata = {'url': '/atlas/v2/entity/bulk/setClassifications'}  # type: ignore


    @distributed_trace
    def get_entities_by_unique_attributes(
        self,
        type_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Bulk API to retrieve list of entities identified by its unique attributes.

        In addition to the typeName path parameter, attribute key-value pair(s) can be provided in the
        following format

        typeName=\:code:`<typeName>`&attr_1:\:code:`<attrName>`=\:code:`<attrValue>`&attr_2:\:code:`<attrName>`=\:code:`<attrValue>`&attr_3:\:code:`<attrName>`=\:code:`<attrValue>`

        NOTE: The attrName should be an unique attribute for the given entity-type

        The REST request would look something like this

        GET
        /v2/entity/bulk/uniqueAttribute/type/hive_db?attr_0:qualifiedName=db1@cl1&attr_2:qualifiedName=db2@cl1.

        :param type_name: The name of the type.
        :type type_name: str
        :keyword min_ext_info: Whether to return minimal information for referred entities.
        :paramtype min_ext_info: bool
        :keyword ignore_relationships: Whether to ignore relationship attributes.
        :paramtype ignore_relationships: bool
        :keyword attr_n_qualified_name: Qualified name of an entity. E.g. to find 2 entities you can
         set attrs_0:qualifiedName=db1@cl1&attrs_2:qualifiedName=db2@cl1.
        :paramtype attr_n_qualified_name: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "entities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure Active Directory object Id.
                                        "info": "str"  # Optional. additional information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence of the term assignment.
                                    "createdBy": "str",  # Optional. The user who created the record.
                                    "description": "str",  # Optional. The description of the term assignment.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "provenanceType": 0.0,  # Optional. Used to record the provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of relationship.
                            },
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the entity.
                        }
                    ],
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure Active Directory object Id.
                                        "info": "str"  # Optional. additional information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence of the term assignment.
                                    "createdBy": "str",  # Optional. The user who created the record.
                                    "description": "str",  # Optional. The description of the term assignment.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "provenanceType": 0.0,  # Optional. Used to record the provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of relationship.
                            },
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the entity.
                        }
                    }
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        min_ext_info = kwargs.pop('min_ext_info', False)  # type: Optional[bool]
        ignore_relationships = kwargs.pop('ignore_relationships', False)  # type: Optional[bool]
        attr_n_qualified_name = kwargs.pop('attr_n_qualified_name', None)  # type: Optional[str]

        
        request = build_entity_get_entities_by_unique_attributes_request(
            type_name=type_name,
            min_ext_info=min_ext_info,
            ignore_relationships=ignore_relationships,
            attr_n_qualified_name=attr_n_qualified_name,
            template_url=self.get_entities_by_unique_attributes.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_entities_by_unique_attributes.metadata = {'url': '/atlas/v2/entity/bulk/uniqueAttribute/type/{typeName}'}  # type: ignore


    @distributed_trace
    def get_header(
        self,
        guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get entity header given its GUID.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributes": {
                        "str": {}  # Optional. The attributes of the struct.
                    },
                    "classificationNames": [
                        "str"  # Optional. An array of classification names.
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the time boundary.
                                    "startTime": "str",  # Optional. The start of the time boundary.
                                    "timeZone": "str"  # Optional. The timezone of the time boundary.
                                }
                            ]
                        }
                    ],
                    "displayText": "str",  # Optional. The display text.
                    "guid": "str",  # Optional. The GUID of the record.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "meaningNames": [
                        "str"  # Optional. An array of meanings.
                    ],
                    "meanings": [
                        {
                            "confidence": 0,  # Optional. The confidence of the term assignment.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "description": "str",  # Optional. The description of the term assignment.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term assignment.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                    "typeName": "str"  # Optional. The name of the type.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_entity_get_header_request(
            guid=guid,
            template_url=self.get_header.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_header.metadata = {'url': '/atlas/v2/entity/guid/{guid}/header'}  # type: ignore

class GlossaryOperations(object):
    """GlossaryOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def list_glossaries(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> List[Any]
        """Get all glossaries registered with Atlas.

        :keyword limit: The page size - by default there is no paging.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC.
        :paramtype sort: str
        :keyword ignore_terms_and_categories: Whether ignore terms and categories.
        :paramtype ignore_terms_and_categories: bool
        :return: list of JSON object
        :rtype: list[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == [
                    {
                        "categories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the category.
                                "description": "str",  # Optional. The description of the category header.
                                "displayText": "str",  # Optional. The display text.
                                "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                                "relationGuid": "str"  # Optional. The GUID of the relationship.
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the entity.
                                "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                "source": "str",  # Optional. indicate the source who create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The end of the time boundary.
                                        "startTime": "str",  # Optional. The start of the time boundary.
                                        "timeZone": "str"  # Optional. The timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "guid": "str",  # Optional. The GUID of the object.
                        "language": "str",  # Optional. The language of the glossary.
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                        "shortDescription": "str",  # Optional. The short version of description.
                        "terms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "usage": "str"  # Optional. The usage of the glossary.
                    }
                ]
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[List[Any]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        limit = kwargs.pop('limit', None)  # type: Optional[int]
        offset = kwargs.pop('offset', None)  # type: Optional[int]
        sort = kwargs.pop('sort', "ASC")  # type: Optional[str]
        ignore_terms_and_categories = kwargs.pop('ignore_terms_and_categories', False)  # type: Optional[bool]

        
        request = build_glossary_list_glossaries_request(
            limit=limit,
            offset=offset,
            sort=sort,
            ignore_terms_and_categories=ignore_terms_and_categories,
            template_url=self.list_glossaries.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_glossaries.metadata = {'url': '/atlas/v2/glossary'}  # type: ignore


    @distributed_trace
    def create_glossary(
        self,
        atlas_glossary,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Create a glossary.

        :param atlas_glossary: Glossary definition, terms & categories can be anchored to a glossary.
         Using the anchor attribute when creating the Term/Category.
        :type atlas_glossary: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                atlas_glossary = {
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the time boundary.
                                    "startTime": "str",  # Optional. The start of the time boundary.
                                    "timeZone": "str"  # Optional. The timezone of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "language": "str",  # Optional. The language of the glossary.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "usage": "str"  # Optional. The usage of the glossary.
                }

                # response body for status code(s): 200
                response.json() == {
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the time boundary.
                                    "startTime": "str",  # Optional. The start of the time boundary.
                                    "timeZone": "str"  # Optional. The timezone of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "language": "str",  # Optional. The language of the glossary.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "usage": "str"  # Optional. The usage of the glossary.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = atlas_glossary

        request = build_glossary_create_glossary_request(
            content_type=content_type,
            json=json,
            template_url=self.create_glossary.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_glossary.metadata = {'url': '/atlas/v2/glossary'}  # type: ignore


    @distributed_trace
    def create_glossary_categories(
        self,
        glossary_category,  # type: List[Any]
        **kwargs  # type: Any
    ):
        # type: (...) -> List[Any]
        """Create glossary category in bulk.

        :param glossary_category: An array of glossary category definitions to be created.
        :type glossary_category: list[Any]
        :return: list of JSON object
        :rtype: list[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                glossary_category = [
                    {
                        "anchor": {
                            "displayText": "str",  # Optional. The display text.
                            "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        },
                        "childrenCategories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the category.
                                "description": "str",  # Optional. The description of the category header.
                                "displayText": "str",  # Optional. The display text.
                                "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                                "relationGuid": "str"  # Optional. The GUID of the relationship.
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the entity.
                                "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                "source": "str",  # Optional. indicate the source who create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The end of the time boundary.
                                        "startTime": "str",  # Optional. The start of the time boundary.
                                        "timeZone": "str"  # Optional. The timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "guid": "str",  # Optional. The GUID of the object.
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "parentCategory": {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        },
                        "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                        "shortDescription": "str",  # Optional. The short version of description.
                        "terms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ]
                    }
                ]

                # response body for status code(s): 200
                response.json() == [
                    {
                        "anchor": {
                            "displayText": "str",  # Optional. The display text.
                            "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        },
                        "childrenCategories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the category.
                                "description": "str",  # Optional. The description of the category header.
                                "displayText": "str",  # Optional. The display text.
                                "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                                "relationGuid": "str"  # Optional. The GUID of the relationship.
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the entity.
                                "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                "source": "str",  # Optional. indicate the source who create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The end of the time boundary.
                                        "startTime": "str",  # Optional. The start of the time boundary.
                                        "timeZone": "str"  # Optional. The timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "guid": "str",  # Optional. The GUID of the object.
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "parentCategory": {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        },
                        "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                        "shortDescription": "str",  # Optional. The short version of description.
                        "terms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ]
                    }
                ]
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[List[Any]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = glossary_category

        request = build_glossary_create_glossary_categories_request(
            content_type=content_type,
            json=json,
            template_url=self.create_glossary_categories.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_glossary_categories.metadata = {'url': '/atlas/v2/glossary/categories'}  # type: ignore


    @distributed_trace
    def create_glossary_category(
        self,
        glossary_category,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Create a glossary category.

        :param glossary_category: The glossary category definition. A category must be anchored to a
         Glossary when creating.
         Optionally, terms belonging to the category and the hierarchy can also be defined during
         creation.
        :type glossary_category: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                glossary_category = {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the time boundary.
                                    "startTime": "str",  # Optional. The start of the time boundary.
                                    "timeZone": "str"  # Optional. The timezone of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }

                # response body for status code(s): 200
                response.json() == {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the time boundary.
                                    "startTime": "str",  # Optional. The start of the time boundary.
                                    "timeZone": "str"  # Optional. The timezone of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = glossary_category

        request = build_glossary_create_glossary_category_request(
            content_type=content_type,
            json=json,
            template_url=self.create_glossary_category.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_glossary_category.metadata = {'url': '/atlas/v2/glossary/category'}  # type: ignore


    @distributed_trace
    def get_glossary_category(
        self,
        category_guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get specific glossary category by its GUID.

        :param category_guid: The globally unique identifier of the category.
        :type category_guid: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the time boundary.
                                    "startTime": "str",  # Optional. The start of the time boundary.
                                    "timeZone": "str"  # Optional. The timezone of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_glossary_get_glossary_category_request(
            category_guid=category_guid,
            template_url=self.get_glossary_category.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_glossary_category.metadata = {'url': '/atlas/v2/glossary/category/{categoryGuid}'}  # type: ignore


    @distributed_trace
    def update_glossary_category(
        self,
        category_guid,  # type: str
        glossary_category,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Update the given glossary category by its GUID.

        :param category_guid: The globally unique identifier of the category.
        :type category_guid: str
        :param glossary_category: The glossary category to be updated.
        :type glossary_category: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                glossary_category = {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the time boundary.
                                    "startTime": "str",  # Optional. The start of the time boundary.
                                    "timeZone": "str"  # Optional. The timezone of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }

                # response body for status code(s): 200
                response.json() == {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the time boundary.
                                    "startTime": "str",  # Optional. The start of the time boundary.
                                    "timeZone": "str"  # Optional. The timezone of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = glossary_category

        request = build_glossary_update_glossary_category_request(
            category_guid=category_guid,
            content_type=content_type,
            json=json,
            template_url=self.update_glossary_category.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_glossary_category.metadata = {'url': '/atlas/v2/glossary/category/{categoryGuid}'}  # type: ignore


    @distributed_trace
    def delete_glossary_category(
        self,
        category_guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Delete a glossary category.

        :param category_guid: The globally unique identifier of the category.
        :type category_guid: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_glossary_delete_glossary_category_request(
            category_guid=category_guid,
            template_url=self.delete_glossary_category.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    delete_glossary_category.metadata = {'url': '/atlas/v2/glossary/category/{categoryGuid}'}  # type: ignore


    @distributed_trace
    def partial_update_glossary_category(
        self,
        category_guid,  # type: str
        partial_updates,  # type: Dict[str, str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Update the glossary category partially.

        :param category_guid: The globally unique identifier of the category.
        :type category_guid: str
        :param partial_updates: A map containing keys as attribute names and values as corresponding
         attribute values for partial update.
        :type partial_updates: dict[str, str]
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                partial_updates = {
                    "str": "str"  # Optional.
                }

                # response body for status code(s): 200
                response.json() == {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the time boundary.
                                    "startTime": "str",  # Optional. The start of the time boundary.
                                    "timeZone": "str"  # Optional. The timezone of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = partial_updates

        request = build_glossary_partial_update_glossary_category_request(
            category_guid=category_guid,
            content_type=content_type,
            json=json,
            template_url=self.partial_update_glossary_category.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    partial_update_glossary_category.metadata = {'url': '/atlas/v2/glossary/category/{categoryGuid}/partial'}  # type: ignore


    @distributed_trace
    def list_related_categories(
        self,
        category_guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Dict[str, List[Any]]
        """Get all related categories (parent and children). Limit, offset, and sort parameters are
        currently not being enabled and won't work even they are passed.

        :param category_guid: The globally unique identifier of the category.
        :type category_guid: str
        :keyword limit: The page size - by default there is no paging.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC.
        :paramtype sort: str
        :return: dict mapping str to list of JSON object
        :rtype: dict[str, list[Any]]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "str": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Dict[str, List[Any]]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        limit = kwargs.pop('limit', None)  # type: Optional[int]
        offset = kwargs.pop('offset', None)  # type: Optional[int]
        sort = kwargs.pop('sort', "ASC")  # type: Optional[str]

        
        request = build_glossary_list_related_categories_request(
            category_guid=category_guid,
            limit=limit,
            offset=offset,
            sort=sort,
            template_url=self.list_related_categories.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_related_categories.metadata = {'url': '/atlas/v2/glossary/category/{categoryGuid}/related'}  # type: ignore


    @distributed_trace
    def list_category_terms(
        self,
        category_guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> List[Any]
        """Get all terms associated with the specific category.

        :param category_guid: The globally unique identifier of the category.
        :type category_guid: str
        :keyword limit: The page size - by default there is no paging.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC.
        :paramtype sort: str
        :return: list of JSON object
        :rtype: list[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == [
                    {
                        "description": "str",  # Optional. The description of the related term.
                        "displayText": "str",  # Optional. The display text.
                        "expression": "str",  # Optional. The expression of the term.
                        "relationGuid": "str",  # Optional. The GUID of the relationship.
                        "source": "str",  # Optional. The source of the term.
                        "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                        "steward": "str",  # Optional. The steward of the term.
                        "termGuid": "str"  # Optional. The GUID of the term.
                    }
                ]
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[List[Any]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        limit = kwargs.pop('limit', None)  # type: Optional[int]
        offset = kwargs.pop('offset', None)  # type: Optional[int]
        sort = kwargs.pop('sort', "ASC")  # type: Optional[str]

        
        request = build_glossary_list_category_terms_request(
            category_guid=category_guid,
            limit=limit,
            offset=offset,
            sort=sort,
            template_url=self.list_category_terms.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_category_terms.metadata = {'url': '/atlas/v2/glossary/category/{categoryGuid}/terms'}  # type: ignore


    @distributed_trace
    def create_glossary_term(
        self,
        glossary_term,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Create a glossary term.

        :param glossary_term: The glossary term definition. A term must be anchored to a Glossary at
         the time of creation.
         Optionally it can be categorized as well.
        :type glossary_term: Any
        :keyword include_term_hierarchy: Whether include term hierarchy.
        :paramtype include_term_hierarchy: bool
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                glossary_term = {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the relationship.
                            "relationshipStatus": "str",  # Optional. The enum of relationship status. Possible values include: "ACTIVE", "DELETED".
                            "relationshipType": "str",  # Optional. An array of related object IDs.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term, which is map<string,map<string,object>>."nThe key of the first layer map is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "status": "str"  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the time boundary.
                                    "startTime": "str",  # Optional. The start of the time boundary.
                                    "timeZone": "str"  # Optional. The timezone of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory object Id.
                                "info": "str"  # Optional. additional information to describe this contact.
                            }
                        ]
                    },
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Possible values include: "Draft", "Approved", "Alert", "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }

                # response body for status code(s): 200
                response.json() == {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the relationship.
                            "relationshipStatus": "str",  # Optional. The enum of relationship status. Possible values include: "ACTIVE", "DELETED".
                            "relationshipType": "str",  # Optional. An array of related object IDs.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term, which is map<string,map<string,object>>."nThe key of the first layer map is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "status": "str"  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the time boundary.
                                    "startTime": "str",  # Optional. The start of the time boundary.
                                    "timeZone": "str"  # Optional. The timezone of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory object Id.
                                "info": "str"  # Optional. additional information to describe this contact.
                            }
                        ]
                    },
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Possible values include: "Draft", "Approved", "Alert", "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]

        json = glossary_term

        request = build_glossary_create_glossary_term_request(
            content_type=content_type,
            include_term_hierarchy=include_term_hierarchy,
            json=json,
            template_url=self.create_glossary_term.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_glossary_term.metadata = {'url': '/atlas/v2/glossary/term'}  # type: ignore


    @distributed_trace
    def get_glossary_term(
        self,
        term_guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get a specific glossary term by its GUID.

        :param term_guid: The globally unique identifier for glossary term.
        :type term_guid: str
        :keyword include_term_hierarchy: Whether include term hierarchy.
        :paramtype include_term_hierarchy: bool
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the relationship.
                            "relationshipStatus": "str",  # Optional. The enum of relationship status. Possible values include: "ACTIVE", "DELETED".
                            "relationshipType": "str",  # Optional. An array of related object IDs.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term, which is map<string,map<string,object>>."nThe key of the first layer map is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "status": "str"  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the time boundary.
                                    "startTime": "str",  # Optional. The start of the time boundary.
                                    "timeZone": "str"  # Optional. The timezone of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory object Id.
                                "info": "str"  # Optional. additional information to describe this contact.
                            }
                        ]
                    },
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Possible values include: "Draft", "Approved", "Alert", "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]

        
        request = build_glossary_get_glossary_term_request(
            term_guid=term_guid,
            include_term_hierarchy=include_term_hierarchy,
            template_url=self.get_glossary_term.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_glossary_term.metadata = {'url': '/atlas/v2/glossary/term/{termGuid}'}  # type: ignore


    @distributed_trace
    def update_glossary_term(
        self,
        term_guid,  # type: str
        glossary_term,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Update the given glossary term by its GUID.

        :param term_guid: The globally unique identifier for glossary term.
        :type term_guid: str
        :param glossary_term: The glossary term to be updated.
        :type glossary_term: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                glossary_term = {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the relationship.
                            "relationshipStatus": "str",  # Optional. The enum of relationship status. Possible values include: "ACTIVE", "DELETED".
                            "relationshipType": "str",  # Optional. An array of related object IDs.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term, which is map<string,map<string,object>>."nThe key of the first layer map is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "status": "str"  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the time boundary.
                                    "startTime": "str",  # Optional. The start of the time boundary.
                                    "timeZone": "str"  # Optional. The timezone of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory object Id.
                                "info": "str"  # Optional. additional information to describe this contact.
                            }
                        ]
                    },
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Possible values include: "Draft", "Approved", "Alert", "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }

                # response body for status code(s): 200
                response.json() == {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the relationship.
                            "relationshipStatus": "str",  # Optional. The enum of relationship status. Possible values include: "ACTIVE", "DELETED".
                            "relationshipType": "str",  # Optional. An array of related object IDs.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term, which is map<string,map<string,object>>."nThe key of the first layer map is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "status": "str"  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the time boundary.
                                    "startTime": "str",  # Optional. The start of the time boundary.
                                    "timeZone": "str"  # Optional. The timezone of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory object Id.
                                "info": "str"  # Optional. additional information to describe this contact.
                            }
                        ]
                    },
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Possible values include: "Draft", "Approved", "Alert", "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = glossary_term

        request = build_glossary_update_glossary_term_request(
            term_guid=term_guid,
            content_type=content_type,
            json=json,
            template_url=self.update_glossary_term.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_glossary_term.metadata = {'url': '/atlas/v2/glossary/term/{termGuid}'}  # type: ignore


    @distributed_trace
    def delete_glossary_term(
        self,
        term_guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Delete a glossary term.

        :param term_guid: The globally unique identifier for glossary term.
        :type term_guid: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_glossary_delete_glossary_term_request(
            term_guid=term_guid,
            template_url=self.delete_glossary_term.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    delete_glossary_term.metadata = {'url': '/atlas/v2/glossary/term/{termGuid}'}  # type: ignore


    @distributed_trace
    def partial_update_glossary_term(
        self,
        term_guid,  # type: str
        partial_updates,  # type: Dict[str, str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Update the glossary term partially.

        :param term_guid: The globally unique identifier for glossary term.
        :type term_guid: str
        :param partial_updates: A map containing keys as attribute names and values as corresponding
         attribute values to be updated.
        :type partial_updates: dict[str, str]
        :keyword include_term_hierarchy: Whether include term hierarchy.
        :paramtype include_term_hierarchy: bool
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                partial_updates = {
                    "str": "str"  # Optional.
                }

                # response body for status code(s): 200
                response.json() == {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the relationship.
                            "relationshipStatus": "str",  # Optional. The enum of relationship status. Possible values include: "ACTIVE", "DELETED".
                            "relationshipType": "str",  # Optional. An array of related object IDs.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term, which is map<string,map<string,object>>."nThe key of the first layer map is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "status": "str"  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the time boundary.
                                    "startTime": "str",  # Optional. The start of the time boundary.
                                    "timeZone": "str"  # Optional. The timezone of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory object Id.
                                "info": "str"  # Optional. additional information to describe this contact.
                            }
                        ]
                    },
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Possible values include: "Draft", "Approved", "Alert", "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]

        json = partial_updates

        request = build_glossary_partial_update_glossary_term_request(
            term_guid=term_guid,
            content_type=content_type,
            include_term_hierarchy=include_term_hierarchy,
            json=json,
            template_url=self.partial_update_glossary_term.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    partial_update_glossary_term.metadata = {'url': '/atlas/v2/glossary/term/{termGuid}/partial'}  # type: ignore


    @distributed_trace
    def create_glossary_terms(
        self,
        glossary_term,  # type: List[Any]
        **kwargs  # type: Any
    ):
        # type: (...) -> List[Any]
        """Create glossary terms in bulk.

        :param glossary_term: An array of glossary term definitions to be created in bulk.
        :type glossary_term: list[Any]
        :keyword include_term_hierarchy: Whether include term hierarchy.
        :paramtype include_term_hierarchy: bool
        :return: list of JSON object
        :rtype: list[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                glossary_term = [
                    {
                        "abbreviation": "str",  # Optional. The abbreviation of the term.
                        "anchor": {
                            "displayText": "str",  # Optional. The display text.
                            "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        },
                        "antonyms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "assignedEntities": [
                            {
                                "displayText": "str",  # Optional. The display text.
                                "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "guid": "str",  # Optional. The GUID of the object.
                                "relationshipAttributes": {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "typeName": "str"  # Optional. The name of the type.
                                },
                                "relationshipGuid": "str",  # Optional. The GUID of the relationship.
                                "relationshipStatus": "str",  # Optional. The enum of relationship status. Possible values include: "ACTIVE", "DELETED".
                                "relationshipType": "str",  # Optional. An array of related object IDs.
                                "typeName": "str",  # Optional. The name of the type.
                                "uniqueAttributes": {
                                    "str": {}  # Optional. The unique attributes of the object.
                                }
                            }
                        ],
                        "attributes": {
                            "str": {
                                "str": {}  # Optional. The custom attributes of the term, which is map<string,map<string,object>>."nThe key of the first layer map is term template name.
                            }
                        },
                        "categories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the category.
                                "description": "str",  # Optional. The description of the record.
                                "displayText": "str",  # Optional. The display text.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "status": "str"  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the entity.
                                "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                "source": "str",  # Optional. indicate the source who create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The end of the time boundary.
                                        "startTime": "str",  # Optional. The start of the time boundary.
                                        "timeZone": "str"  # Optional. The timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "classifies": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active Directory object Id.
                                    "info": "str"  # Optional. additional information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0.0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "examples": [
                            "str"  # Optional. An array of examples.
                        ],
                        "guid": "str",  # Optional. The GUID of the object.
                        "isA": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "preferredTerms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "preferredToTerms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                        "replacedBy": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "replacementTerms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "resources": [
                            {
                                "displayName": "str",  # Optional. Display name for url.
                                "url": "str"  # Optional. web url. http or https.
                            }
                        ],
                        "seeAlso": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "shortDescription": "str",  # Optional. The short version of description.
                        "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Possible values include: "Draft", "Approved", "Alert", "Expired".
                        "synonyms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "templateName": [
                            {}  # Optional.
                        ],
                        "translatedTerms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "translationTerms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "updateTime": 0.0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "usage": "str",  # Optional. The usage of the term.
                        "validValues": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "validValuesFor": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ]
                    }
                ]

                # response body for status code(s): 200
                response.json() == [
                    {
                        "abbreviation": "str",  # Optional. The abbreviation of the term.
                        "anchor": {
                            "displayText": "str",  # Optional. The display text.
                            "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        },
                        "antonyms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "assignedEntities": [
                            {
                                "displayText": "str",  # Optional. The display text.
                                "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "guid": "str",  # Optional. The GUID of the object.
                                "relationshipAttributes": {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "typeName": "str"  # Optional. The name of the type.
                                },
                                "relationshipGuid": "str",  # Optional. The GUID of the relationship.
                                "relationshipStatus": "str",  # Optional. The enum of relationship status. Possible values include: "ACTIVE", "DELETED".
                                "relationshipType": "str",  # Optional. An array of related object IDs.
                                "typeName": "str",  # Optional. The name of the type.
                                "uniqueAttributes": {
                                    "str": {}  # Optional. The unique attributes of the object.
                                }
                            }
                        ],
                        "attributes": {
                            "str": {
                                "str": {}  # Optional. The custom attributes of the term, which is map<string,map<string,object>>."nThe key of the first layer map is term template name.
                            }
                        },
                        "categories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the category.
                                "description": "str",  # Optional. The description of the record.
                                "displayText": "str",  # Optional. The display text.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "status": "str"  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the entity.
                                "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                "source": "str",  # Optional. indicate the source who create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The end of the time boundary.
                                        "startTime": "str",  # Optional. The start of the time boundary.
                                        "timeZone": "str"  # Optional. The timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "classifies": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active Directory object Id.
                                    "info": "str"  # Optional. additional information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0.0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "examples": [
                            "str"  # Optional. An array of examples.
                        ],
                        "guid": "str",  # Optional. The GUID of the object.
                        "isA": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "preferredTerms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "preferredToTerms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                        "replacedBy": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "replacementTerms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "resources": [
                            {
                                "displayName": "str",  # Optional. Display name for url.
                                "url": "str"  # Optional. web url. http or https.
                            }
                        ],
                        "seeAlso": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "shortDescription": "str",  # Optional. The short version of description.
                        "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Possible values include: "Draft", "Approved", "Alert", "Expired".
                        "synonyms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "templateName": [
                            {}  # Optional.
                        ],
                        "translatedTerms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "translationTerms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "updateTime": 0.0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "usage": "str",  # Optional. The usage of the term.
                        "validValues": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "validValuesFor": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ]
                    }
                ]
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[List[Any]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]

        json = glossary_term

        request = build_glossary_create_glossary_terms_request(
            content_type=content_type,
            include_term_hierarchy=include_term_hierarchy,
            json=json,
            template_url=self.create_glossary_terms.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_glossary_terms.metadata = {'url': '/atlas/v2/glossary/terms'}  # type: ignore


    @distributed_trace
    def get_entities_assigned_with_term(
        self,
        term_guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> List[Any]
        """Get all related objects assigned with the specified term.

        :param term_guid: The globally unique identifier for glossary term.
        :type term_guid: str
        :keyword limit: The page size - by default there is no paging.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC.
        :paramtype sort: str
        :return: list of JSON object
        :rtype: list[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == [
                    {
                        "displayText": "str",  # Optional. The display text.
                        "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                        "guid": "str",  # Optional. The GUID of the object.
                        "relationshipAttributes": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "typeName": "str"  # Optional. The name of the type.
                        },
                        "relationshipGuid": "str",  # Optional. The GUID of the relationship.
                        "relationshipStatus": "str",  # Optional. The enum of relationship status. Possible values include: "ACTIVE", "DELETED".
                        "relationshipType": "str",  # Optional.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    }
                ]
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[List[Any]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        limit = kwargs.pop('limit', None)  # type: Optional[int]
        offset = kwargs.pop('offset', None)  # type: Optional[int]
        sort = kwargs.pop('sort', "ASC")  # type: Optional[str]

        
        request = build_glossary_get_entities_assigned_with_term_request(
            term_guid=term_guid,
            limit=limit,
            offset=offset,
            sort=sort,
            template_url=self.get_entities_assigned_with_term.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_entities_assigned_with_term.metadata = {'url': '/atlas/v2/glossary/terms/{termGuid}/assignedEntities'}  # type: ignore


    @distributed_trace
    def assign_term_to_entities(
        self,
        term_guid,  # type: str
        related_object_ids,  # type: List[Any]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Assign the given term to the provided list of related objects.

        :param term_guid: The globally unique identifier for glossary term.
        :type term_guid: str
        :param related_object_ids: An array of related object IDs to which the term has to be
         associated.
        :type related_object_ids: list[Any]
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                related_object_ids = [
                    {
                        "displayText": "str",  # Optional. The display text.
                        "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                        "guid": "str",  # Optional. The GUID of the object.
                        "relationshipAttributes": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "typeName": "str"  # Optional. The name of the type.
                        },
                        "relationshipGuid": "str",  # Optional. The GUID of the relationship.
                        "relationshipStatus": "str",  # Optional. The enum of relationship status. Possible values include: "ACTIVE", "DELETED".
                        "relationshipType": "str",  # Optional.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    }
                ]
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = related_object_ids

        request = build_glossary_assign_term_to_entities_request(
            term_guid=term_guid,
            content_type=content_type,
            json=json,
            template_url=self.assign_term_to_entities.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    assign_term_to_entities.metadata = {'url': '/atlas/v2/glossary/terms/{termGuid}/assignedEntities'}  # type: ignore


    @distributed_trace
    def remove_term_assignment_from_entities(
        self,
        term_guid,  # type: str
        related_object_ids,  # type: List[Any]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Delete the term assignment for the given list of related objects.

        :param term_guid: The globally unique identifier for glossary term.
        :type term_guid: str
        :param related_object_ids: An array of related object IDs from which the term has to be
         dissociated.
        :type related_object_ids: list[Any]
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                related_object_ids = [
                    {
                        "displayText": "str",  # Optional. The display text.
                        "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                        "guid": "str",  # Optional. The GUID of the object.
                        "relationshipAttributes": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "typeName": "str"  # Optional. The name of the type.
                        },
                        "relationshipGuid": "str",  # Optional. The GUID of the relationship.
                        "relationshipStatus": "str",  # Optional. The enum of relationship status. Possible values include: "ACTIVE", "DELETED".
                        "relationshipType": "str",  # Optional.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    }
                ]
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = related_object_ids

        request = build_glossary_remove_term_assignment_from_entities_request(
            term_guid=term_guid,
            content_type=content_type,
            json=json,
            template_url=self.remove_term_assignment_from_entities.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    remove_term_assignment_from_entities.metadata = {'url': '/atlas/v2/glossary/terms/{termGuid}/assignedEntities'}  # type: ignore


    @distributed_trace
    def delete_term_assignment_from_entities(
        self,
        term_guid,  # type: str
        related_object_ids,  # type: List[Any]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Delete the term assignment for the given list of related objects.

        :param term_guid: The globally unique identifier for glossary term.
        :type term_guid: str
        :param related_object_ids: An array of related object IDs from which the term has to be
         dissociated.
        :type related_object_ids: list[Any]
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                related_object_ids = [
                    {
                        "displayText": "str",  # Optional. The display text.
                        "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                        "guid": "str",  # Optional. The GUID of the object.
                        "relationshipAttributes": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "typeName": "str"  # Optional. The name of the type.
                        },
                        "relationshipGuid": "str",  # Optional. The GUID of the relationship.
                        "relationshipStatus": "str",  # Optional. The enum of relationship status. Possible values include: "ACTIVE", "DELETED".
                        "relationshipType": "str",  # Optional.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    }
                ]
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = related_object_ids

        request = build_glossary_delete_term_assignment_from_entities_request(
            term_guid=term_guid,
            content_type=content_type,
            json=json,
            template_url=self.delete_term_assignment_from_entities.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    delete_term_assignment_from_entities.metadata = {'url': '/atlas/v2/glossary/terms/{termGuid}/assignedEntities'}  # type: ignore


    @distributed_trace
    def list_related_terms(
        self,
        term_guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Dict[str, List[Any]]
        """Get all related terms for a specific term by its GUID. Limit, offset, and sort parameters are
        currently not being enabled and won't work even they are passed.

        :param term_guid: The globally unique identifier for glossary term.
        :type term_guid: str
        :keyword limit: The page size - by default there is no paging.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC.
        :paramtype sort: str
        :return: dict mapping str to list of JSON object
        :rtype: dict[str, list[Any]]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "str": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Dict[str, List[Any]]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        limit = kwargs.pop('limit', None)  # type: Optional[int]
        offset = kwargs.pop('offset', None)  # type: Optional[int]
        sort = kwargs.pop('sort', "ASC")  # type: Optional[str]

        
        request = build_glossary_list_related_terms_request(
            term_guid=term_guid,
            limit=limit,
            offset=offset,
            sort=sort,
            template_url=self.list_related_terms.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_related_terms.metadata = {'url': '/atlas/v2/glossary/terms/{termGuid}/related'}  # type: ignore


    @distributed_trace
    def get_glossary(
        self,
        glossary_guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get a specific Glossary by its GUID.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the time boundary.
                                    "startTime": "str",  # Optional. The start of the time boundary.
                                    "timeZone": "str"  # Optional. The timezone of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "language": "str",  # Optional. The language of the glossary.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "usage": "str"  # Optional. The usage of the glossary.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_glossary_get_glossary_request(
            glossary_guid=glossary_guid,
            template_url=self.get_glossary.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_glossary.metadata = {'url': '/atlas/v2/glossary/{glossaryGuid}'}  # type: ignore


    @distributed_trace
    def update_glossary(
        self,
        glossary_guid,  # type: str
        updated_glossary,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Update the given glossary.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :param updated_glossary: The glossary definition to be updated.
        :type updated_glossary: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                updated_glossary = {
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the time boundary.
                                    "startTime": "str",  # Optional. The start of the time boundary.
                                    "timeZone": "str"  # Optional. The timezone of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "language": "str",  # Optional. The language of the glossary.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "usage": "str"  # Optional. The usage of the glossary.
                }

                # response body for status code(s): 200
                response.json() == {
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the time boundary.
                                    "startTime": "str",  # Optional. The start of the time boundary.
                                    "timeZone": "str"  # Optional. The timezone of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "language": "str",  # Optional. The language of the glossary.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "usage": "str"  # Optional. The usage of the glossary.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = updated_glossary

        request = build_glossary_update_glossary_request(
            glossary_guid=glossary_guid,
            content_type=content_type,
            json=json,
            template_url=self.update_glossary.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_glossary.metadata = {'url': '/atlas/v2/glossary/{glossaryGuid}'}  # type: ignore


    @distributed_trace
    def delete_glossary(
        self,
        glossary_guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Delete a glossary.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_glossary_delete_glossary_request(
            glossary_guid=glossary_guid,
            template_url=self.delete_glossary.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    delete_glossary.metadata = {'url': '/atlas/v2/glossary/{glossaryGuid}'}  # type: ignore


    @distributed_trace
    def list_glossary_categories(
        self,
        glossary_guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> List[Any]
        """Get the categories belonging to a specific glossary.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :keyword limit: The page size - by default there is no paging.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC.
        :paramtype sort: str
        :return: list of JSON object
        :rtype: list[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == [
                    {
                        "anchor": {
                            "displayText": "str",  # Optional. The display text.
                            "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        },
                        "childrenCategories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the category.
                                "description": "str",  # Optional. The description of the category header.
                                "displayText": "str",  # Optional. The display text.
                                "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                                "relationGuid": "str"  # Optional. The GUID of the relationship.
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the entity.
                                "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                "source": "str",  # Optional. indicate the source who create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The end of the time boundary.
                                        "startTime": "str",  # Optional. The start of the time boundary.
                                        "timeZone": "str"  # Optional. The timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "guid": "str",  # Optional. The GUID of the object.
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "parentCategory": {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        },
                        "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                        "shortDescription": "str",  # Optional. The short version of description.
                        "terms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ]
                    }
                ]
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[List[Any]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        limit = kwargs.pop('limit', None)  # type: Optional[int]
        offset = kwargs.pop('offset', None)  # type: Optional[int]
        sort = kwargs.pop('sort', "ASC")  # type: Optional[str]

        
        request = build_glossary_list_glossary_categories_request(
            glossary_guid=glossary_guid,
            limit=limit,
            offset=offset,
            sort=sort,
            template_url=self.list_glossary_categories.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_glossary_categories.metadata = {'url': '/atlas/v2/glossary/{glossaryGuid}/categories'}  # type: ignore


    @distributed_trace
    def list_glossary_categories_headers(
        self,
        glossary_guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> List[Any]
        """Get the category headers belonging to a specific glossary.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :keyword limit: The page size - by default there is no paging.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC.
        :paramtype sort: str
        :return: list of JSON object
        :rtype: list[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == [
                    {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    }
                ]
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[List[Any]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        limit = kwargs.pop('limit', None)  # type: Optional[int]
        offset = kwargs.pop('offset', None)  # type: Optional[int]
        sort = kwargs.pop('sort', "ASC")  # type: Optional[str]

        
        request = build_glossary_list_glossary_categories_headers_request(
            glossary_guid=glossary_guid,
            limit=limit,
            offset=offset,
            sort=sort,
            template_url=self.list_glossary_categories_headers.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_glossary_categories_headers.metadata = {'url': '/atlas/v2/glossary/{glossaryGuid}/categories/headers'}  # type: ignore


    @distributed_trace
    def get_detailed_glossary(
        self,
        glossary_guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get a specific glossary with detailed information.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :keyword include_term_hierarchy: Whether include term hierarchy.
        :paramtype include_term_hierarchy: bool
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        }
                    ],
                    "categoryInfo": {
                        "str": {
                            "anchor": {
                                "displayText": "str",  # Optional. The display text.
                                "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                                "relationGuid": "str"  # Optional. The GUID of the relationship.
                            },
                            "childrenCategories": [
                                {
                                    "categoryGuid": "str",  # Optional. The GUID of the category.
                                    "description": "str",  # Optional. The description of the category header.
                                    "displayText": "str",  # Optional. The display text.
                                    "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                                    "relationGuid": "str"  # Optional. The GUID of the relationship.
                                }
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "guid": "str",  # Optional. The GUID of the object.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "longDescription": "str",  # Optional. The long version description.
                            "name": "str",  # Optional. The name of the glossary object.
                            "parentCategory": {
                                "categoryGuid": "str",  # Optional. The GUID of the category.
                                "description": "str",  # Optional. The description of the category header.
                                "displayText": "str",  # Optional. The display text.
                                "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                                "relationGuid": "str"  # Optional. The GUID of the relationship.
                            },
                            "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                            "shortDescription": "str",  # Optional. The short version of description.
                            "terms": [
                                {
                                    "description": "str",  # Optional. The description of the related term.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ]
                        }
                    },
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the time boundary.
                                    "startTime": "str",  # Optional. The start of the time boundary.
                                    "timeZone": "str"  # Optional. The timezone of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "language": "str",  # Optional. The language of the glossary.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "termInfo": {
                        "str": {
                            "abbreviation": "str",  # Optional. The abbreviation of the term.
                            "anchor": {
                                "displayText": "str",  # Optional. The display text.
                                "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                                "relationGuid": "str"  # Optional. The GUID of the relationship.
                            },
                            "antonyms": [
                                {
                                    "description": "str",  # Optional. The description of the related term.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "assignedEntities": [
                                {
                                    "displayText": "str",  # Optional. The display text.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "guid": "str",  # Optional. The GUID of the object.
                                    "relationshipAttributes": {
                                        "attributes": {
                                            "str": {}  # Optional. The attributes of the struct.
                                        },
                                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                        "typeName": "str"  # Optional. The name of the type.
                                    },
                                    "relationshipGuid": "str",  # Optional. The GUID of the relationship.
                                    "relationshipStatus": "str",  # Optional. The enum of relationship status. Possible values include: "ACTIVE", "DELETED".
                                    "relationshipType": "str",  # Optional. An array of related object IDs.
                                    "typeName": "str",  # Optional. The name of the type.
                                    "uniqueAttributes": {
                                        "str": {}  # Optional. The unique attributes of the object.
                                    }
                                }
                            ],
                            "attributes": {
                                "str": {
                                    "str": {}  # Optional. The custom attributes of the term, which is map<string,map<string,object>>."nThe key of the first layer map is term template name.
                                }
                            },
                            "categories": [
                                {
                                    "categoryGuid": "str",  # Optional. The GUID of the category.
                                    "description": "str",  # Optional. The description of the record.
                                    "displayText": "str",  # Optional. The display text.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "status": "str"  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                }
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "classifies": [
                                {
                                    "description": "str",  # Optional. The description of the related term.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure Active Directory object Id.
                                        "info": "str"  # Optional. additional information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "examples": [
                                "str"  # Optional. An array of examples.
                            ],
                            "guid": "str",  # Optional. The GUID of the object.
                            "isA": [
                                {
                                    "description": "str",  # Optional. The description of the related term.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "longDescription": "str",  # Optional. The long version description.
                            "name": "str",  # Optional. The name of the glossary object.
                            "preferredTerms": [
                                {
                                    "description": "str",  # Optional. The description of the related term.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "preferredToTerms": [
                                {
                                    "description": "str",  # Optional. The description of the related term.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                            "replacedBy": [
                                {
                                    "description": "str",  # Optional. The description of the related term.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "replacementTerms": [
                                {
                                    "description": "str",  # Optional. The description of the related term.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "resources": [
                                {
                                    "displayName": "str",  # Optional. Display name for url.
                                    "url": "str"  # Optional. web url. http or https.
                                }
                            ],
                            "seeAlso": [
                                {
                                    "description": "str",  # Optional. The description of the related term.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "shortDescription": "str",  # Optional. The short version of description.
                            "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Possible values include: "Draft", "Approved", "Alert", "Expired".
                            "synonyms": [
                                {
                                    "description": "str",  # Optional. The description of the related term.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "templateName": [
                                {}  # Optional. The glossary term information.
                            ],
                            "translatedTerms": [
                                {
                                    "description": "str",  # Optional. The description of the related term.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "translationTerms": [
                                {
                                    "description": "str",  # Optional. The description of the related term.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "usage": "str",  # Optional. The usage of the term.
                            "validValues": [
                                {
                                    "description": "str",  # Optional. The description of the related term.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "validValuesFor": [
                                {
                                    "description": "str",  # Optional. The description of the related term.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ]
                        }
                    },
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "usage": "str"  # Optional. The usage of the glossary.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]

        
        request = build_glossary_get_detailed_glossary_request(
            glossary_guid=glossary_guid,
            include_term_hierarchy=include_term_hierarchy,
            template_url=self.get_detailed_glossary.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_detailed_glossary.metadata = {'url': '/atlas/v2/glossary/{glossaryGuid}/detailed'}  # type: ignore


    @distributed_trace
    def partial_update_glossary(
        self,
        glossary_guid,  # type: str
        partial_updates,  # type: Dict[str, str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Update the glossary partially. Some properties such as qualifiedName are not allowed to be
        updated.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :param partial_updates: A map containing keys as attribute names and values as corresponding
         attribute values.
        :type partial_updates: dict[str, str]
        :keyword include_term_hierarchy: Whether include term hierarchy.
        :paramtype include_term_hierarchy: bool
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                partial_updates = {
                    "str": "str"  # Optional.
                }

                # response body for status code(s): 200
                response.json() == {
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the parent category.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the time boundary.
                                    "startTime": "str",  # Optional. The start of the time boundary.
                                    "timeZone": "str"  # Optional. The timezone of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "language": "str",  # Optional. The language of the glossary.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "usage": "str"  # Optional. The usage of the glossary.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]

        json = partial_updates

        request = build_glossary_partial_update_glossary_request(
            glossary_guid=glossary_guid,
            content_type=content_type,
            include_term_hierarchy=include_term_hierarchy,
            json=json,
            template_url=self.partial_update_glossary.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    partial_update_glossary.metadata = {'url': '/atlas/v2/glossary/{glossaryGuid}/partial'}  # type: ignore


    @distributed_trace
    def list_glossary_terms(
        self,
        glossary_guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> List[Any]
        """Get terms belonging to a specific glossary.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :keyword include_term_hierarchy: Whether include term hierarchy.
        :paramtype include_term_hierarchy: bool
        :keyword limit: The page size - by default there is no paging.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC.
        :paramtype sort: str
        :return: list of JSON object
        :rtype: list[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == [
                    {
                        "abbreviation": "str",  # Optional. The abbreviation of the term.
                        "anchor": {
                            "displayText": "str",  # Optional. The display text.
                            "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        },
                        "antonyms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "assignedEntities": [
                            {
                                "displayText": "str",  # Optional. The display text.
                                "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "guid": "str",  # Optional. The GUID of the object.
                                "relationshipAttributes": {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "typeName": "str"  # Optional. The name of the type.
                                },
                                "relationshipGuid": "str",  # Optional. The GUID of the relationship.
                                "relationshipStatus": "str",  # Optional. The enum of relationship status. Possible values include: "ACTIVE", "DELETED".
                                "relationshipType": "str",  # Optional. An array of related object IDs.
                                "typeName": "str",  # Optional. The name of the type.
                                "uniqueAttributes": {
                                    "str": {}  # Optional. The unique attributes of the object.
                                }
                            }
                        ],
                        "attributes": {
                            "str": {
                                "str": {}  # Optional. The custom attributes of the term, which is map<string,map<string,object>>."nThe key of the first layer map is term template name.
                            }
                        },
                        "categories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the category.
                                "description": "str",  # Optional. The description of the record.
                                "displayText": "str",  # Optional. The display text.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "status": "str"  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the entity.
                                "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                "source": "str",  # Optional. indicate the source who create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The end of the time boundary.
                                        "startTime": "str",  # Optional. The start of the time boundary.
                                        "timeZone": "str"  # Optional. The timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "classifies": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active Directory object Id.
                                    "info": "str"  # Optional. additional information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0.0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "examples": [
                            "str"  # Optional. An array of examples.
                        ],
                        "guid": "str",  # Optional. The GUID of the object.
                        "isA": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "preferredTerms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "preferredToTerms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                        "replacedBy": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "replacementTerms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "resources": [
                            {
                                "displayName": "str",  # Optional. Display name for url.
                                "url": "str"  # Optional. web url. http or https.
                            }
                        ],
                        "seeAlso": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "shortDescription": "str",  # Optional. The short version of description.
                        "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Possible values include: "Draft", "Approved", "Alert", "Expired".
                        "synonyms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "templateName": [
                            {}  # Optional.
                        ],
                        "translatedTerms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "translationTerms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "updateTime": 0.0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "usage": "str",  # Optional. The usage of the term.
                        "validValues": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "validValuesFor": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ]
                    }
                ]
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[List[Any]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]
        limit = kwargs.pop('limit', None)  # type: Optional[int]
        offset = kwargs.pop('offset', None)  # type: Optional[int]
        sort = kwargs.pop('sort', "ASC")  # type: Optional[str]

        
        request = build_glossary_list_glossary_terms_request(
            glossary_guid=glossary_guid,
            include_term_hierarchy=include_term_hierarchy,
            limit=limit,
            offset=offset,
            sort=sort,
            template_url=self.list_glossary_terms.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_glossary_terms.metadata = {'url': '/atlas/v2/glossary/{glossaryGuid}/terms'}  # type: ignore


    @distributed_trace
    def list_glossary_term_headers(
        self,
        glossary_guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> List[Any]
        """Get term headers belonging to a specific glossary.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :keyword limit: The page size - by default there is no paging.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC.
        :paramtype sort: str
        :return: list of JSON object
        :rtype: list[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == [
                    {
                        "description": "str",  # Optional. The description of the related term.
                        "displayText": "str",  # Optional. The display text.
                        "expression": "str",  # Optional. The expression of the term.
                        "relationGuid": "str",  # Optional. The GUID of the relationship.
                        "source": "str",  # Optional. The source of the term.
                        "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                        "steward": "str",  # Optional. The steward of the term.
                        "termGuid": "str"  # Optional. The GUID of the term.
                    }
                ]
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[List[Any]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        limit = kwargs.pop('limit', None)  # type: Optional[int]
        offset = kwargs.pop('offset', None)  # type: Optional[int]
        sort = kwargs.pop('sort', "ASC")  # type: Optional[str]

        
        request = build_glossary_list_glossary_term_headers_request(
            glossary_guid=glossary_guid,
            limit=limit,
            offset=offset,
            sort=sort,
            template_url=self.list_glossary_term_headers.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_glossary_term_headers.metadata = {'url': '/atlas/v2/glossary/{glossaryGuid}/terms/headers'}  # type: ignore


    def _import_glossary_terms_via_csv_initial(
        self,
        glossary_guid,  # type: str
        files,  # type: Dict[str, Any]
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', None)  # type: Optional[str]
        include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]

        data = None
        # Construct form data

        request = build_glossary_import_glossary_terms_via_csv_request_initial(
            glossary_guid=glossary_guid,
            content_type=content_type,
            include_term_hierarchy=include_term_hierarchy,
            files=files,
            data=data,
            template_url=self._import_glossary_terms_via_csv_initial.metadata['url'],
        )
        request = _convert_request(request, files)
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.body():
            deserialized = _loads(response.body())
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _import_glossary_terms_via_csv_initial.metadata = {'url': '/glossary/{glossaryGuid}/terms/import'}  # type: ignore


    @distributed_trace
    def begin_import_glossary_terms_via_csv(
        self,
        glossary_guid,  # type: str
        files,  # type: Dict[str, Any]
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller[Any]
        """Import Glossary Terms from local csv file.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :param files: Multipart input for files. See the template in our example to find the input
         shape.
        :type files: dict[str, any]
        :keyword include_term_hierarchy: Whether include term hierarchy.
        :paramtype include_term_hierarchy: bool
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # multipart input template you can fill out and use as your `files` input.
                files = {
                    file: b'bytes'  # The csv file to import glossary terms from.
                }

                # response body for status code(s): 202
                response.json() == {
                    "createTime": "str",  # Optional. The created time of the record.
                    "error": {
                        "errorCode": 0,  # Optional. Error code from async import job if fail.
                        "errorMessage": "str"  # Optional. Error message from async import job if fail.
                    },
                    "id": "str",  # Optional. guid string.
                    "lastUpdateTime": "str",  # Optional. The last updated time of the record.
                    "properties": {
                        "importedTerms": "str",  # Optional. Term numbers that already imported successfully.
                        "totalTermsDetected": "str"  # Optional. Total term numbers that detected in csv.
                    },
                    "status": "str"  # Optional. Enum of the status of import csv operation. Possible values include: "NotStarted", "Succeeded", "Failed", "Running".
                }
        """
        content_type = kwargs.pop('content_type', None)  # type: Optional[str]
        include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]
        polling = kwargs.pop('polling', True)  # type: Union[bool, azure.core.polling.PollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._import_glossary_terms_via_csv_initial(
                glossary_guid=glossary_guid,
                files=files,
                include_term_hierarchy=include_term_hierarchy,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.body():
                deserialized = _loads(response.body())
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }

        if polling is True: polling_method = LROBasePolling(lro_delay, lro_options={'final-state-via': 'azure-async-operation'}, path_format_arguments=path_format_arguments, **kwargs)
        elif polling is False: polling_method = NoPolling()
        else: polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_import_glossary_terms_via_csv.metadata = {'url': '/glossary/{glossaryGuid}/terms/import'}  # type: ignore

    def _import_glossary_terms_via_csv_by_glossary_name_initial(
        self,
        glossary_name,  # type: str
        files,  # type: Dict[str, Any]
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', None)  # type: Optional[str]
        include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]

        data = None
        # Construct form data

        request = build_glossary_import_glossary_terms_via_csv_by_glossary_name_request_initial(
            glossary_name=glossary_name,
            content_type=content_type,
            include_term_hierarchy=include_term_hierarchy,
            files=files,
            data=data,
            template_url=self._import_glossary_terms_via_csv_by_glossary_name_initial.metadata['url'],
        )
        request = _convert_request(request, files)
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.body():
            deserialized = _loads(response.body())
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _import_glossary_terms_via_csv_by_glossary_name_initial.metadata = {'url': '/glossary/name/{glossaryName}/terms/import'}  # type: ignore


    @distributed_trace
    def begin_import_glossary_terms_via_csv_by_glossary_name(
        self,
        glossary_name,  # type: str
        files,  # type: Dict[str, Any]
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller[Any]
        """Import Glossary Terms from local csv file by glossaryName.

        :param glossary_name: The name of the glossary.
        :type glossary_name: str
        :param files: Multipart input for files. See the template in our example to find the input
         shape.
        :type files: dict[str, any]
        :keyword include_term_hierarchy: Whether include term hierarchy.
        :paramtype include_term_hierarchy: bool
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # multipart input template you can fill out and use as your `files` input.
                files = {
                    file: b'bytes'  # The csv file to import glossary terms from.
                }

                # response body for status code(s): 202
                response.json() == {
                    "createTime": "str",  # Optional. The created time of the record.
                    "error": {
                        "errorCode": 0,  # Optional. Error code from async import job if fail.
                        "errorMessage": "str"  # Optional. Error message from async import job if fail.
                    },
                    "id": "str",  # Optional. guid string.
                    "lastUpdateTime": "str",  # Optional. The last updated time of the record.
                    "properties": {
                        "importedTerms": "str",  # Optional. Term numbers that already imported successfully.
                        "totalTermsDetected": "str"  # Optional. Total term numbers that detected in csv.
                    },
                    "status": "str"  # Optional. Enum of the status of import csv operation. Possible values include: "NotStarted", "Succeeded", "Failed", "Running".
                }
        """
        content_type = kwargs.pop('content_type', None)  # type: Optional[str]
        include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]
        polling = kwargs.pop('polling', True)  # type: Union[bool, azure.core.polling.PollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._import_glossary_terms_via_csv_by_glossary_name_initial(
                glossary_name=glossary_name,
                files=files,
                include_term_hierarchy=include_term_hierarchy,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.body():
                deserialized = _loads(response.body())
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }

        if polling is True: polling_method = LROBasePolling(lro_delay, lro_options={'final-state-via': 'azure-async-operation'}, path_format_arguments=path_format_arguments, **kwargs)
        elif polling is False: polling_method = NoPolling()
        else: polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_import_glossary_terms_via_csv_by_glossary_name.metadata = {'url': '/glossary/name/{glossaryName}/terms/import'}  # type: ignore

    @distributed_trace
    def get_import_csv_operation_status(
        self,
        operation_guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get the status of import csv operation.

        :param operation_guid: The globally unique identifier for async operation/job.
        :type operation_guid: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "createTime": "str",  # Optional. The created time of the record.
                    "error": {
                        "errorCode": 0,  # Optional. Error code from async import job if fail.
                        "errorMessage": "str"  # Optional. Error message from async import job if fail.
                    },
                    "id": "str",  # Optional. guid string.
                    "lastUpdateTime": "str",  # Optional. The last updated time of the record.
                    "properties": {
                        "importedTerms": "str",  # Optional. Term numbers that already imported successfully.
                        "totalTermsDetected": "str"  # Optional. Total term numbers that detected in csv.
                    },
                    "status": "str"  # Optional. Enum of the status of import csv operation. Possible values include: "NotStarted", "Succeeded", "Failed", "Running".
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_glossary_get_import_csv_operation_status_request(
            operation_guid=operation_guid,
            template_url=self.get_import_csv_operation_status.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_import_csv_operation_status.metadata = {'url': '/glossary/terms/import/{operationGuid}'}  # type: ignore


    @distributed_trace
    def export_glossary_terms_as_csv(
        self,
        glossary_guid,  # type: str
        term_guids,  # type: List[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> IO
        """Export Glossary Terms as csv file.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :param term_guids: An array of term guids.
        :type term_guids: list[str]
        :keyword include_term_hierarchy: Whether include term hierarchy.
        :paramtype include_term_hierarchy: bool
        :return: IO
        :rtype: IO
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                term_guids = [
                    "str"  # Optional.
                ]
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[IO]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]

        json = term_guids

        request = build_glossary_export_glossary_terms_as_csv_request(
            glossary_guid=glossary_guid,
            content_type=content_type,
            include_term_hierarchy=include_term_hierarchy,
            json=json,
            template_url=self.export_glossary_terms_as_csv.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    export_glossary_terms_as_csv.metadata = {'url': '/glossary/{glossaryGuid}/terms/export'}  # type: ignore


    @distributed_trace
    def list_terms_by_glossary_name(
        self,
        glossary_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> List[Any]
        """Get terms by glossary name.

        :param glossary_name: The name of the glossary.
        :type glossary_name: str
        :keyword limit: The page size - by default there is no paging.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose.
        :paramtype offset: int
        :keyword include_term_hierarchy: Whether include term hierarchy.
        :paramtype include_term_hierarchy: bool
        :return: list of JSON object
        :rtype: list[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == [
                    {
                        "abbreviation": "str",  # Optional. The abbreviation of the term.
                        "anchor": {
                            "displayText": "str",  # Optional. The display text.
                            "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                            "relationGuid": "str"  # Optional. The GUID of the relationship.
                        },
                        "antonyms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "assignedEntities": [
                            {
                                "displayText": "str",  # Optional. The display text.
                                "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "guid": "str",  # Optional. The GUID of the object.
                                "relationshipAttributes": {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "typeName": "str"  # Optional. The name of the type.
                                },
                                "relationshipGuid": "str",  # Optional. The GUID of the relationship.
                                "relationshipStatus": "str",  # Optional. The enum of relationship status. Possible values include: "ACTIVE", "DELETED".
                                "relationshipType": "str",  # Optional. An array of related object IDs.
                                "typeName": "str",  # Optional. The name of the type.
                                "uniqueAttributes": {
                                    "str": {}  # Optional. The unique attributes of the object.
                                }
                            }
                        ],
                        "attributes": {
                            "str": {
                                "str": {}  # Optional. The custom attributes of the term, which is map<string,map<string,object>>."nThe key of the first layer map is term template name.
                            }
                        },
                        "categories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the category.
                                "description": "str",  # Optional. The description of the record.
                                "displayText": "str",  # Optional. The display text.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "status": "str"  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the entity.
                                "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                "source": "str",  # Optional. indicate the source who create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The end of the time boundary.
                                        "startTime": "str",  # Optional. The start of the time boundary.
                                        "timeZone": "str"  # Optional. The timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "classifies": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active Directory object Id.
                                    "info": "str"  # Optional. additional information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0.0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "examples": [
                            "str"  # Optional. An array of examples.
                        ],
                        "guid": "str",  # Optional. The GUID of the object.
                        "isA": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "preferredTerms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "preferredToTerms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "qualifiedName": "str",  # Optional. The qualified name of the glossary object.
                        "replacedBy": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "replacementTerms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "resources": [
                            {
                                "displayName": "str",  # Optional. Display name for url.
                                "url": "str"  # Optional. web url. http or https.
                            }
                        ],
                        "seeAlso": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "shortDescription": "str",  # Optional. The short version of description.
                        "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Possible values include: "Draft", "Approved", "Alert", "Expired".
                        "synonyms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "templateName": [
                            {}  # Optional.
                        ],
                        "translatedTerms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "translationTerms": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "updateTime": 0.0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "usage": "str",  # Optional. The usage of the term.
                        "validValues": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "validValuesFor": [
                            {
                                "description": "str",  # Optional. The description of the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of the term.
                                "relationGuid": "str",  # Optional. The GUID of the relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term relationship. Possible values include: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ]
                    }
                ]
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[List[Any]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        limit = kwargs.pop('limit', None)  # type: Optional[int]
        offset = kwargs.pop('offset', None)  # type: Optional[int]
        include_term_hierarchy = kwargs.pop('include_term_hierarchy', False)  # type: Optional[bool]

        
        request = build_glossary_list_terms_by_glossary_name_request(
            glossary_name=glossary_name,
            limit=limit,
            offset=offset,
            include_term_hierarchy=include_term_hierarchy,
            template_url=self.list_terms_by_glossary_name.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_terms_by_glossary_name.metadata = {'url': '/glossary/name/{glossaryName}/terms'}  # type: ignore

class DiscoveryOperations(object):
    """DiscoveryOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def query(
        self,
        search_request,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Gets data using search.

        :param search_request: An object specifying the search criteria.
        :type search_request: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                search_request = {
                    "facets": [
                        {
                            "count": 0,  # Optional. The count of the facet item.
                            "facet": "str",  # Optional. The name of the facet item.
                            "sort": {}  # Optional. Any object.
                        }
                    ],
                    "filter": {},  # Optional. The filter for the search. See examples for the usage of supported filters.
                    "keywords": "str",  # Optional. The keywords applied to all searchable fields.
                    "limit": 0,  # Optional. The limit of the number of the search result. default value is 50; maximum value is 1000.
                    "offset": 0,  # Optional. The offset. The default value is 0.
                    "taxonomySetting": {
                        "assetTypes": [
                            "str"  # Optional.
                        ],
                        "facet": {
                            "count": 0,  # Optional. The count of the facet item.
                            "facet": "str",  # Optional. The name of the facet item.
                            "sort": {}  # Optional. Any object.
                        }
                    }
                }

                # response body for status code(s): 200
                response.json() == {
                    "@search.count": 0,  # Optional. The total number of search results (not the number of documents in a single page).
                    "@search.facets": {
                        "assetType": [
                            {
                                "count": 0,  # Optional. The count of the facet item.
                                "value": "str"  # Optional. The name of the facet item.
                            }
                        ],
                        "classification": [
                            {
                                "count": 0,  # Optional. The count of the facet item.
                                "value": "str"  # Optional. The name of the facet item.
                            }
                        ],
                        "classificationCategory": [
                            {
                                "count": 0,  # Optional. The count of the facet item.
                                "value": "str"  # Optional. The name of the facet item.
                            }
                        ],
                        "contactId": [
                            {
                                "count": 0,  # Optional. The count of the facet item.
                                "value": "str"  # Optional. The name of the facet item.
                            }
                        ],
                        "fileExtension": [
                            {
                                "count": 0,  # Optional. The count of the facet item.
                                "value": "str"  # Optional. The name of the facet item.
                            }
                        ],
                        "label": [
                            {
                                "count": 0,  # Optional. The count of the facet item.
                                "value": "str"  # Optional. The name of the facet item.
                            }
                        ],
                        "term": [
                            {
                                "count": 0,  # Optional. The count of the facet item.
                                "value": "str"  # Optional. The name of the facet item.
                            }
                        ]
                    },
                    "value": [
                        {
                            "@search.highlights": {
                                "description": [
                                    "str"  # Optional. A highlight list that consists of index fields id ,qualifiedName, name, description, entityType. When the keyword appears in those fields, the value of the field, attached with emphasis mark, is returned as an element of @search.highlights.
                                ],
                                "entityType": [
                                    "str"  # Optional. A highlight list that consists of index fields id ,qualifiedName, name, description, entityType. When the keyword appears in those fields, the value of the field, attached with emphasis mark, is returned as an element of @search.highlights.
                                ],
                                "id": [
                                    "str"  # Optional. A highlight list that consists of index fields id ,qualifiedName, name, description, entityType. When the keyword appears in those fields, the value of the field, attached with emphasis mark, is returned as an element of @search.highlights.
                                ],
                                "name": [
                                    "str"  # Optional. A highlight list that consists of index fields id ,qualifiedName, name, description, entityType. When the keyword appears in those fields, the value of the field, attached with emphasis mark, is returned as an element of @search.highlights.
                                ],
                                "qualifiedName": [
                                    "str"  # Optional. A highlight list that consists of index fields id ,qualifiedName, name, description, entityType. When the keyword appears in those fields, the value of the field, attached with emphasis mark, is returned as an element of @search.highlights.
                                ]
                            },
                            "@search.score": 0.0,  # Optional. The search score calculated by the search engine. The results are ordered by search score by default.
                            "@search.text": "str",  # Optional. The target text that contains the keyword as prefix. The keyword is wrapped with emphasis mark.
                            "assetType": [
                                "str"  # Optional. The asset types of the record.
                            ],
                            "classification": [
                                "str"  # Optional. The classifications of the record.
                            ],
                            "contact": [
                                {
                                    "contactType": "str",  # Optional. The type of the contact. It can be Expert or Owner for an entity. It can be Expert or Steward for a glossary term.
                                    "id": "str",  # Optional. The GUID of the contact.
                                    "info": "str"  # Optional. The description of the contact.
                                }
                            ],
                            "description": "str",  # Optional. The description of the record.
                            "entityType": "str",  # Optional. The type name of the record.
                            "id": "str",  # Optional. The GUID of the record.
                            "label": [
                                "str"  # Optional. The labels of the record.
                            ],
                            "name": "str",  # Optional. The name of the record.
                            "owner": "str",  # Optional. The owner of the record. This is an Atlas native attribute.
                            "qualifiedName": "str",  # Optional. The qualified name of the record.
                            "term": [
                                {
                                    "glossaryName": "str",  # Optional. The name of the glossary which contains the term.
                                    "guid": "str",  # Optional. The GUID of the term.
                                    "name": "str"  # Optional. The name of the term.
                                }
                            ]
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = search_request

        request = build_discovery_query_request(
            content_type=content_type,
            json=json,
            template_url=self.query.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    query.metadata = {'url': '/search/query'}  # type: ignore


    @distributed_trace
    def suggest(
        self,
        suggest_request,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get search suggestions by query criteria.

        :param suggest_request: An object specifying the suggest criteria.
        :type suggest_request: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                suggest_request = {
                    "filter": {},  # Optional. The filter for the search.
                    "keywords": "str",  # Optional. The keywords applied to all fields that support suggest operation. It must be at least 1 character, and no more than 100 characters. In the index schema we defined a default suggester which lists all the supported fields and specifies a search mode.
                    "limit": 0  # Optional. The number of suggestions we hope to return. The default value is 5. The value must be a number between 1 and 100.
                }

                # response body for status code(s): 200
                response.json() == {
                    "value": [
                        {
                            "@search.score": 0.0,  # Optional. The search score calculated by the search engine. The results are ordered by search score by default.
                            "@search.text": "str",  # Optional. The target text that contains the keyword as prefix. The keyword is wrapped with emphasis mark.
                            "assetType": [
                                "str"  # Optional. The asset types of the record.
                            ],
                            "classification": [
                                "str"  # Optional. The classifications of the record.
                            ],
                            "contact": [
                                {
                                    "contactType": "str",  # Optional. The type of the contact. It can be Expert or Owner for an entity. It can be Expert or Steward for a glossary term.
                                    "id": "str",  # Optional. The GUID of the contact.
                                    "info": "str"  # Optional. The description of the contact.
                                }
                            ],
                            "description": "str",  # Optional. The description of the record.
                            "entityType": "str",  # Optional. The type name of the record.
                            "id": "str",  # Optional. The GUID of the record.
                            "label": [
                                "str"  # Optional. The labels of the record.
                            ],
                            "name": "str",  # Optional. The name of the record.
                            "owner": "str",  # Optional. The owner of the record. This is an Atlas native attribute.
                            "qualifiedName": "str",  # Optional. The qualified name of the record.
                            "term": [
                                {
                                    "glossaryName": "str",  # Optional. The name of the glossary which contains the term.
                                    "guid": "str",  # Optional. The GUID of the term.
                                    "name": "str"  # Optional. The name of the term.
                                }
                            ]
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = suggest_request

        request = build_discovery_suggest_request(
            content_type=content_type,
            json=json,
            template_url=self.suggest.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    suggest.metadata = {'url': '/search/suggest'}  # type: ignore


    @distributed_trace
    def browse(
        self,
        browse_request,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Browse entities by path or entity type.

        :param browse_request: An object specifying the browse criteria.
        :type browse_request: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                browse_request = {
                    "entityType": "str",  # Optional. The entity type to browse as the root level entry point.
                    "limit": 0,  # Optional. The number of browse items we hope to return.
                    "offset": 0,  # Optional. The offset. The default value is 0.
                    "path": "str"  # Optional. The path to browse the next level child entities.
                }

                # response body for status code(s): 200
                response.json() == {
                    "@search.count": 0,  # Optional. The total number of browse results.
                    "value": [
                        {
                            "entityType": "str",  # Optional. The type name of the record.
                            "id": "str",  # Optional. The GUID of the record.
                            "isLeaf": bool,  # Optional. If the record is a leaf entity.
                            "name": "str",  # Optional. The name of the record.
                            "owner": [
                                {
                                    "contactType": "str",  # Optional. The contact type of the owner. The value will be Owner.
                                    "displayName": "str",  # Optional. The display name of the owner.
                                    "id": "str",  # Optional. The GUID of the owner.
                                    "mail": "str"  # Optional. The mail of the owner.
                                }
                            ],
                            "path": "str",  # Optional. The path of the record.
                            "qualifiedName": "str"  # Optional. The qualified name of the record.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = browse_request

        request = build_discovery_browse_request(
            content_type=content_type,
            json=json,
            template_url=self.browse.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    browse.metadata = {'url': '/browse'}  # type: ignore


    @distributed_trace
    def auto_complete(
        self,
        auto_complete_request,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get auto complete options.

        :param auto_complete_request: An object specifying the autocomplete criteria.
        :type auto_complete_request: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                auto_complete_request = {
                    "filter": {},  # Optional. The filter for the autocomplete request.
                    "keywords": "str",  # Optional. The keywords applied to all fields that support autocomplete operation. It must be at least 1 character, and no more than 100 characters.
                    "limit": 0  # Optional. The number of autocomplete results we hope to return. The default value is 50. The value must be a number between 1 and 100.
                }

                # response body for status code(s): 200
                response.json() == {
                    "value": [
                        {
                            "queryPlusText": "str",  # Optional. The completed search query text.
                            "text": "str"  # Optional. The completed term or phrase.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = auto_complete_request

        request = build_discovery_auto_complete_request(
            content_type=content_type,
            json=json,
            template_url=self.auto_complete.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    auto_complete.metadata = {'url': '/search/autocomplete'}  # type: ignore

class LineageOperations(object):
    """LineageOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def get_lineage_graph(
        self,
        guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get lineage info of the entity specified by GUID.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :keyword direction: The direction of the lineage, which could be INPUT, OUTPUT or BOTH.
         Possible values are: "BOTH", "INPUT", and "OUTPUT".
        :paramtype direction: str
        :keyword depth: The number of hops for lineage.
        :paramtype depth: int
        :keyword width: The number of max expanding width in lineage.
        :paramtype width: int
        :keyword include_parent: True to include the parent chain in the response.
        :paramtype include_parent: bool
        :keyword get_derived_lineage: True to include derived lineage in the response.
        :paramtype get_derived_lineage: bool
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "baseEntityGuid": "str",  # Optional. The GUID of the base entity.
                    "childrenCount": 0,  # Optional. The number of children node.
                    "guidEntityMap": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence of the term assignment.
                                    "createdBy": "str",  # Optional. The user who created the record.
                                    "description": "str",  # Optional. The description of the term assignment.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    },
                    "includeParent": bool,  # Optional. True to return the parent of the base entity.
                    "lineageDepth": 0,  # Optional. The depth of lineage.
                    "lineageDirection": "str",  # Optional. The enum of lineage direction. Possible values include: "INPUT", "OUTPUT", "BOTH".
                    "lineageWidth": 0,  # Optional. The width of lineage.
                    "parentRelations": [
                        {
                            "childEntityId": "str",  # Optional. The GUID of child entity.
                            "parentEntityId": "str",  # Optional. The GUID of parent entity.
                            "relationshipId": "str"  # Optional. The GUID of relationship.
                        }
                    ],
                    "relations": [
                        {
                            "fromEntityId": "str",  # Optional. The GUID of from-entity.
                            "relationshipId": "str",  # Optional. The GUID of relationship.
                            "toEntityId": "str"  # Optional. The GUID of to-entity.
                        }
                    ],
                    "widthCounts": {
                        "str": {
                            "str": {}  # Optional. The entity count in specific direction.
                        }
                    }
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        direction = kwargs.pop('direction')  # type: str
        depth = kwargs.pop('depth', 3)  # type: Optional[int]
        width = kwargs.pop('width', 10)  # type: Optional[int]
        include_parent = kwargs.pop('include_parent', None)  # type: Optional[bool]
        get_derived_lineage = kwargs.pop('get_derived_lineage', None)  # type: Optional[bool]

        
        request = build_lineage_get_lineage_graph_request(
            guid=guid,
            direction=direction,
            depth=depth,
            width=width,
            include_parent=include_parent,
            get_derived_lineage=get_derived_lineage,
            template_url=self.get_lineage_graph.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_lineage_graph.metadata = {'url': '/atlas/v2/lineage/{guid}'}  # type: ignore


    @distributed_trace
    def next_page_lineage(
        self,
        guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Return immediate next page lineage info about entity with pagination.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :keyword direction: The direction of the lineage, which could be INPUT, OUTPUT or BOTH.
         Possible values are: "BOTH", "INPUT", and "OUTPUT".
        :paramtype direction: str
        :keyword get_derived_lineage: True to include derived lineage in the response.
        :paramtype get_derived_lineage: bool
        :keyword offset: The offset for pagination purpose.
        :paramtype offset: int
        :keyword limit: The page size - by default there is no paging.
        :paramtype limit: int
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "baseEntityGuid": "str",  # Optional. The GUID of the base entity.
                    "childrenCount": 0,  # Optional. The number of children node.
                    "guidEntityMap": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence of the term assignment.
                                    "createdBy": "str",  # Optional. The user who created the record.
                                    "description": "str",  # Optional. The description of the term assignment.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    },
                    "includeParent": bool,  # Optional. True to return the parent of the base entity.
                    "lineageDepth": 0,  # Optional. The depth of lineage.
                    "lineageDirection": "str",  # Optional. The enum of lineage direction. Possible values include: "INPUT", "OUTPUT", "BOTH".
                    "lineageWidth": 0,  # Optional. The width of lineage.
                    "parentRelations": [
                        {
                            "childEntityId": "str",  # Optional. The GUID of child entity.
                            "parentEntityId": "str",  # Optional. The GUID of parent entity.
                            "relationshipId": "str"  # Optional. The GUID of relationship.
                        }
                    ],
                    "relations": [
                        {
                            "fromEntityId": "str",  # Optional. The GUID of from-entity.
                            "relationshipId": "str",  # Optional. The GUID of relationship.
                            "toEntityId": "str"  # Optional. The GUID of to-entity.
                        }
                    ],
                    "widthCounts": {
                        "str": {
                            "str": {}  # Optional. The entity count in specific direction.
                        }
                    }
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        direction = kwargs.pop('direction')  # type: str
        get_derived_lineage = kwargs.pop('get_derived_lineage', None)  # type: Optional[bool]
        offset = kwargs.pop('offset', None)  # type: Optional[int]
        limit = kwargs.pop('limit', None)  # type: Optional[int]

        
        request = build_lineage_next_page_lineage_request(
            guid=guid,
            direction=direction,
            get_derived_lineage=get_derived_lineage,
            offset=offset,
            limit=limit,
            template_url=self.next_page_lineage.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    next_page_lineage.metadata = {'url': '/lineage/{guid}/next/'}  # type: ignore

class RelationshipOperations(object):
    """RelationshipOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def create(
        self,
        relationship,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Create a new relationship between entities.

        :param relationship: The AtlasRelationship object containing the information for the
         relationship to be created.
        :type relationship: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                relationship = {
                    "attributes": {
                        "str": {}  # Optional. The attributes of the struct.
                    },
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "end1": {
                        "guid": "str",  # Optional. The GUID of the object.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    },
                    "end2": {
                        "guid": "str",  # Optional. The GUID of the object.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    },
                    "guid": "str",  # Optional. The GUID of the relationship.
                    "homeId": "str",  # Optional. The home ID of the relationship.
                    "label": "str",  # Optional. The label of the relationship.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "provenanceType": 0.0,  # Optional. Used to record the provenance of an instance of an entity or relationship.
                    "status": "str",  # Optional. The enum of relationship status. Possible values include: "ACTIVE", "DELETED".
                    "typeName": "str",  # Optional. The name of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the relationship.
                }

                # response body for status code(s): 200
                response.json() == {
                    "attributes": {
                        "str": {}  # Optional. The attributes of the struct.
                    },
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "end1": {
                        "guid": "str",  # Optional. The GUID of the object.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    },
                    "end2": {
                        "guid": "str",  # Optional. The GUID of the object.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    },
                    "guid": "str",  # Optional. The GUID of the relationship.
                    "homeId": "str",  # Optional. The home ID of the relationship.
                    "label": "str",  # Optional. The label of the relationship.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "provenanceType": 0.0,  # Optional. Used to record the provenance of an instance of an entity or relationship.
                    "status": "str",  # Optional. The enum of relationship status. Possible values include: "ACTIVE", "DELETED".
                    "typeName": "str",  # Optional. The name of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the relationship.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = relationship

        request = build_relationship_create_request(
            content_type=content_type,
            json=json,
            template_url=self.create.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create.metadata = {'url': '/atlas/v2/relationship'}  # type: ignore


    @distributed_trace
    def update(
        self,
        relationship,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Update an existing relationship between entities.

        :param relationship: The AtlasRelationship object containing the information for the
         relationship to be created.
        :type relationship: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                relationship = {
                    "attributes": {
                        "str": {}  # Optional. The attributes of the struct.
                    },
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "end1": {
                        "guid": "str",  # Optional. The GUID of the object.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    },
                    "end2": {
                        "guid": "str",  # Optional. The GUID of the object.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    },
                    "guid": "str",  # Optional. The GUID of the relationship.
                    "homeId": "str",  # Optional. The home ID of the relationship.
                    "label": "str",  # Optional. The label of the relationship.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "provenanceType": 0.0,  # Optional. Used to record the provenance of an instance of an entity or relationship.
                    "status": "str",  # Optional. The enum of relationship status. Possible values include: "ACTIVE", "DELETED".
                    "typeName": "str",  # Optional. The name of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the relationship.
                }

                # response body for status code(s): 200
                response.json() == {
                    "attributes": {
                        "str": {}  # Optional. The attributes of the struct.
                    },
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "end1": {
                        "guid": "str",  # Optional. The GUID of the object.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    },
                    "end2": {
                        "guid": "str",  # Optional. The GUID of the object.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    },
                    "guid": "str",  # Optional. The GUID of the relationship.
                    "homeId": "str",  # Optional. The home ID of the relationship.
                    "label": "str",  # Optional. The label of the relationship.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "provenanceType": 0.0,  # Optional. Used to record the provenance of an instance of an entity or relationship.
                    "status": "str",  # Optional. The enum of relationship status. Possible values include: "ACTIVE", "DELETED".
                    "typeName": "str",  # Optional. The name of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the relationship.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = relationship

        request = build_relationship_update_request(
            content_type=content_type,
            json=json,
            template_url=self.update.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update.metadata = {'url': '/atlas/v2/relationship'}  # type: ignore


    @distributed_trace
    def get(
        self,
        guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get relationship information between entities by its GUID.

        :param guid: The globally unique identifier of the relationship.
        :type guid: str
        :keyword extended_info: Limits whether includes extended information.
        :paramtype extended_info: bool
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of the entity.
                                    "entityStatus": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if propagations will be removed on entity deletion.
                                    "source": "str",  # Optional. indicate the source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on source information.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  # Optional. The end of the time boundary.
                                            "startTime": "str",  # Optional. The start of the time boundary.
                                            "timeZone": "str"  # Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence of the term assignment.
                                    "createdBy": "str",  # Optional. The user who created the record.
                                    "description": "str",  # Optional. The description of the term assignment.
                                    "displayText": "str",  # Optional. The display text.
                                    "expression": "str",  # Optional. The expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID of the relationship.
                                    "source": "str",  # Optional. The source of the term.
                                    "status": "str",  # Optional. The status of terms assignment. Possible values include: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of the term.
                                    "termGuid": "str"  # Optional. The GUID of the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be active or deleted. Deleted entities are not removed from Atlas store. Possible values include: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    },
                    "relationship": {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "createTime": 0.0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "end1": {
                            "guid": "str",  # Optional. The GUID of the object.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the object.
                            }
                        },
                        "end2": {
                            "guid": "str",  # Optional. The GUID of the object.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the object.
                            }
                        },
                        "guid": "str",  # Optional. The GUID of the relationship.
                        "homeId": "str",  # Optional. The home ID of the relationship.
                        "label": "str",  # Optional. The label of the relationship.
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "provenanceType": 0.0,  # Optional. Used to record the provenance of an instance of an entity or relationship.
                        "status": "str",  # Optional. The enum of relationship status. Possible values include: "ACTIVE", "DELETED".
                        "typeName": "str",  # Optional. The name of the type.
                        "updateTime": 0.0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "version": 0.0  # Optional. The version of the relationship.
                    }
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        extended_info = kwargs.pop('extended_info', None)  # type: Optional[bool]

        
        request = build_relationship_get_request(
            guid=guid,
            extended_info=extended_info,
            template_url=self.get.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {'url': '/atlas/v2/relationship/guid/{guid}'}  # type: ignore


    @distributed_trace
    def delete(
        self,
        guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Delete a relationship between entities by its GUID.

        :param guid: The globally unique identifier of the relationship.
        :type guid: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_relationship_delete_request(
            guid=guid,
            template_url=self.delete.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {'url': '/atlas/v2/relationship/guid/{guid}'}  # type: ignore

class TypesOperations(object):
    """TypesOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def get_classification_def_by_guid(
        self,
        guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get the classification definition for the given GUID.

        :param guid: The globally unique identifier of the classification.
        :type guid: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the attribute.
                            "description": "str",  # Optional. The description of the attribute.
                            "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is indexable.
                            "isOptional": bool,  # Optional. Determines if it is optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                            "valuesMinCount": 0  # Optional. The minimum count of the values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "description": "str",  # Optional. The description of the type definition.
                    "entityTypes": [
                        "str"  # Optional. Specifying a list of entityType names in the classificationDef, ensures that classifications can"nonly be applied to those entityTypes."n"n"n.. raw:: html"n"n   <ul>"n   <li>Any subtypes of the entity types inherit the restriction</li>"n   <li>Any classificationDef subtypes inherit the parents entityTypes restrictions</li>"n   <li>Any classificationDef subtypes can further restrict the parents entityTypes restrictions by specifying a subset of the entityTypes</li>"n   <li>An empty entityTypes list when there are no parent restrictions means there are no restrictions</li>"n   <li>An empty entityTypes list when there are parent restrictions means that the subtype picks up the parents restrictions</li>"n   <li>If a list of entityTypes are supplied, where one inherits from another, this will be rejected. This should encourage cleaner classificationsDefs</li>"n   </ul>.
                    ],
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "serviceType": "str",  # Optional. The service type.
                    "subTypes": [
                        "str"  # Optional. An array of sub types.
                    ],
                    "superTypes": [
                        "str"  # Optional. An array of super types.
                    ],
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_types_get_classification_def_by_guid_request(
            guid=guid,
            template_url=self.get_classification_def_by_guid.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_classification_def_by_guid.metadata = {'url': '/atlas/v2/types/classificationdef/guid/{guid}'}  # type: ignore


    @distributed_trace
    def get_classification_def_by_name(
        self,
        name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get the classification definition by its name (unique).

        :param name: The name of the classification.
        :type name: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the attribute.
                            "description": "str",  # Optional. The description of the attribute.
                            "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is indexable.
                            "isOptional": bool,  # Optional. Determines if it is optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                            "valuesMinCount": 0  # Optional. The minimum count of the values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "description": "str",  # Optional. The description of the type definition.
                    "entityTypes": [
                        "str"  # Optional. Specifying a list of entityType names in the classificationDef, ensures that classifications can"nonly be applied to those entityTypes."n"n"n.. raw:: html"n"n   <ul>"n   <li>Any subtypes of the entity types inherit the restriction</li>"n   <li>Any classificationDef subtypes inherit the parents entityTypes restrictions</li>"n   <li>Any classificationDef subtypes can further restrict the parents entityTypes restrictions by specifying a subset of the entityTypes</li>"n   <li>An empty entityTypes list when there are no parent restrictions means there are no restrictions</li>"n   <li>An empty entityTypes list when there are parent restrictions means that the subtype picks up the parents restrictions</li>"n   <li>If a list of entityTypes are supplied, where one inherits from another, this will be rejected. This should encourage cleaner classificationsDefs</li>"n   </ul>.
                    ],
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "serviceType": "str",  # Optional. The service type.
                    "subTypes": [
                        "str"  # Optional. An array of sub types.
                    ],
                    "superTypes": [
                        "str"  # Optional. An array of super types.
                    ],
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_types_get_classification_def_by_name_request(
            name=name,
            template_url=self.get_classification_def_by_name.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_classification_def_by_name.metadata = {'url': '/atlas/v2/types/classificationdef/name/{name}'}  # type: ignore


    @distributed_trace
    def get_entity_definition_by_guid(
        self,
        guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get the Entity definition for the given GUID.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the attribute.
                            "description": "str",  # Optional. The description of the attribute.
                            "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is indexable.
                            "isOptional": bool,  # Optional. Determines if it is optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                            "valuesMinCount": 0  # Optional. The minimum count of the values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "description": "str",  # Optional. The description of the type definition.
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "relationshipAttributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the attribute.
                            "description": "str",  # Optional. The description of the attribute.
                            "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is indexable.
                            "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                            "isOptional": bool,  # Optional. Determines if it is optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the attribute.
                            },
                            "relationshipTypeName": "str",  # Optional. The name of the relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                            "valuesMinCount": 0  # Optional. The minimum count of the values.
                        }
                    ],
                    "serviceType": "str",  # Optional. The service type.
                    "subTypes": [
                        "str"  # Optional. An array of sub types.
                    ],
                    "superTypes": [
                        "str"  # Optional. An array of super types.
                    ],
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_types_get_entity_definition_by_guid_request(
            guid=guid,
            template_url=self.get_entity_definition_by_guid.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_entity_definition_by_guid.metadata = {'url': '/atlas/v2/types/entitydef/guid/{guid}'}  # type: ignore


    @distributed_trace
    def get_entity_definition_by_name(
        self,
        name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get the entity definition by its name (unique).

        :param name: The name of the entity.
        :type name: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the attribute.
                            "description": "str",  # Optional. The description of the attribute.
                            "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is indexable.
                            "isOptional": bool,  # Optional. Determines if it is optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                            "valuesMinCount": 0  # Optional. The minimum count of the values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "description": "str",  # Optional. The description of the type definition.
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "relationshipAttributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the attribute.
                            "description": "str",  # Optional. The description of the attribute.
                            "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is indexable.
                            "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                            "isOptional": bool,  # Optional. Determines if it is optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the attribute.
                            },
                            "relationshipTypeName": "str",  # Optional. The name of the relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                            "valuesMinCount": 0  # Optional. The minimum count of the values.
                        }
                    ],
                    "serviceType": "str",  # Optional. The service type.
                    "subTypes": [
                        "str"  # Optional. An array of sub types.
                    ],
                    "superTypes": [
                        "str"  # Optional. An array of super types.
                    ],
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_types_get_entity_definition_by_name_request(
            name=name,
            template_url=self.get_entity_definition_by_name.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_entity_definition_by_name.metadata = {'url': '/atlas/v2/types/entitydef/name/{name}'}  # type: ignore


    @distributed_trace
    def get_enum_def_by_guid(
        self,
        guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get the enum definition for the given GUID.

        :param guid: The globally unique identifier of the enum.
        :type guid: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "defaultValue": "str",  # Optional. The default value.
                    "description": "str",  # Optional. The description of the type definition.
                    "elementDefs": [
                        {
                            "description": "str",  # Optional. The description of the enum element definition.
                            "ordinal": 0.0,  # Optional. The ordinal of the enum element definition.
                            "value": "str"  # Optional. The value of the enum element definition.
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "serviceType": "str",  # Optional. The service type.
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_types_get_enum_def_by_guid_request(
            guid=guid,
            template_url=self.get_enum_def_by_guid.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_enum_def_by_guid.metadata = {'url': '/atlas/v2/types/enumdef/guid/{guid}'}  # type: ignore


    @distributed_trace
    def get_enum_def_by_name(
        self,
        name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get the enum definition by its name (unique).

        :param name: The name of the enum.
        :type name: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "defaultValue": "str",  # Optional. The default value.
                    "description": "str",  # Optional. The description of the type definition.
                    "elementDefs": [
                        {
                            "description": "str",  # Optional. The description of the enum element definition.
                            "ordinal": 0.0,  # Optional. The ordinal of the enum element definition.
                            "value": "str"  # Optional. The value of the enum element definition.
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "serviceType": "str",  # Optional. The service type.
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_types_get_enum_def_by_name_request(
            name=name,
            template_url=self.get_enum_def_by_name.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_enum_def_by_name.metadata = {'url': '/atlas/v2/types/enumdef/name/{name}'}  # type: ignore


    @distributed_trace
    def get_relationship_def_by_guid(
        self,
        guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get the relationship definition for the given GUID.

        :param guid: The globally unique identifier of the relationship.
        :type guid: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the attribute.
                            "description": "str",  # Optional. The description of the attribute.
                            "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is indexable.
                            "isOptional": bool,  # Optional. Determines if it is optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                            "valuesMinCount": 0  # Optional. The minimum count of the values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "description": "str",  # Optional. The description of the type definition.
                    "endDef1": {
                        "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                        "description": "str",  # Optional. The description of the relationship end definition.
                        "isContainer": bool,  # Optional. Determines if it is container.
                        "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                        "name": "str",  # Optional. The name of the relationship end definition.
                        "type": "str"  # Optional. The type of the relationship end.
                    },
                    "endDef2": {
                        "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                        "description": "str",  # Optional. The description of the relationship end definition.
                        "isContainer": bool,  # Optional. Determines if it is container.
                        "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                        "name": "str",  # Optional. The name of the relationship end definition.
                        "type": "str"  # Optional. The type of the relationship end.
                    },
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "relationshipCategory": "str",  # Optional. The Relationship category determines the style of relationship around containment and lifecycle."nUML terminology is used for the values."n"n:code:`<p>`"nASSOCIATION is a relationship with no containment. :code:`<br>`"nCOMPOSITION and AGGREGATION are containment relationships."n"n:code:`<p>`"nThe difference being in the lifecycles of the container and its children. In the COMPOSITION case,"nthe children cannot exist without the container. For AGGREGATION, the life cycles"nof the container and children are totally independent. Possible values include: "ASSOCIATION", "AGGREGATION", "COMPOSITION".
                    "relationshipLabel": "str",  # Optional. The label of the relationship.
                    "serviceType": "str",  # Optional. The service type.
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_types_get_relationship_def_by_guid_request(
            guid=guid,
            template_url=self.get_relationship_def_by_guid.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_relationship_def_by_guid.metadata = {'url': '/atlas/v2/types/relationshipdef/guid/{guid}'}  # type: ignore


    @distributed_trace
    def get_relationship_def_by_name(
        self,
        name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get the relationship definition by its name (unique).

        :param name: The name of the relationship.
        :type name: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the attribute.
                            "description": "str",  # Optional. The description of the attribute.
                            "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is indexable.
                            "isOptional": bool,  # Optional. Determines if it is optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                            "valuesMinCount": 0  # Optional. The minimum count of the values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "description": "str",  # Optional. The description of the type definition.
                    "endDef1": {
                        "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                        "description": "str",  # Optional. The description of the relationship end definition.
                        "isContainer": bool,  # Optional. Determines if it is container.
                        "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                        "name": "str",  # Optional. The name of the relationship end definition.
                        "type": "str"  # Optional. The type of the relationship end.
                    },
                    "endDef2": {
                        "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                        "description": "str",  # Optional. The description of the relationship end definition.
                        "isContainer": bool,  # Optional. Determines if it is container.
                        "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                        "name": "str",  # Optional. The name of the relationship end definition.
                        "type": "str"  # Optional. The type of the relationship end.
                    },
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "relationshipCategory": "str",  # Optional. The Relationship category determines the style of relationship around containment and lifecycle."nUML terminology is used for the values."n"n:code:`<p>`"nASSOCIATION is a relationship with no containment. :code:`<br>`"nCOMPOSITION and AGGREGATION are containment relationships."n"n:code:`<p>`"nThe difference being in the lifecycles of the container and its children. In the COMPOSITION case,"nthe children cannot exist without the container. For AGGREGATION, the life cycles"nof the container and children are totally independent. Possible values include: "ASSOCIATION", "AGGREGATION", "COMPOSITION".
                    "relationshipLabel": "str",  # Optional. The label of the relationship.
                    "serviceType": "str",  # Optional. The service type.
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_types_get_relationship_def_by_name_request(
            name=name,
            template_url=self.get_relationship_def_by_name.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_relationship_def_by_name.metadata = {'url': '/atlas/v2/types/relationshipdef/name/{name}'}  # type: ignore


    @distributed_trace
    def get_struct_def_by_guid(
        self,
        guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get the struct definition for the given GUID.

        :param guid: The globally unique identifier of the struct.
        :type guid: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the attribute.
                            "description": "str",  # Optional. The description of the attribute.
                            "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is indexable.
                            "isOptional": bool,  # Optional. Determines if it is optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                            "valuesMinCount": 0  # Optional. The minimum count of the values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "description": "str",  # Optional. The description of the type definition.
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "serviceType": "str",  # Optional. The service type.
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_types_get_struct_def_by_guid_request(
            guid=guid,
            template_url=self.get_struct_def_by_guid.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_struct_def_by_guid.metadata = {'url': '/atlas/v2/types/structdef/guid/{guid}'}  # type: ignore


    @distributed_trace
    def get_struct_def_by_name(
        self,
        name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get the struct definition by its name (unique).

        :param name: The name of the struct.
        :type name: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the attribute.
                            "description": "str",  # Optional. The description of the attribute.
                            "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is indexable.
                            "isOptional": bool,  # Optional. Determines if it is optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                            "valuesMinCount": 0  # Optional. The minimum count of the values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "description": "str",  # Optional. The description of the type definition.
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "serviceType": "str",  # Optional. The service type.
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_types_get_struct_def_by_name_request(
            name=name,
            template_url=self.get_struct_def_by_name.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_struct_def_by_name.metadata = {'url': '/atlas/v2/types/structdef/name/{name}'}  # type: ignore


    @distributed_trace
    def get_type_definition_by_guid(
        self,
        guid,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get the type definition for the given GUID.

        :param guid: The globally unique identifier of the type.
        :type guid: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the attribute.
                            "description": "str",  # Optional. The description of the attribute.
                            "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is indexable.
                            "isOptional": bool,  # Optional. Determines if it is optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                            "valuesMinCount": 0  # Optional. The minimum count of the values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "defaultValue": "str",  # Optional. The default value.
                    "description": "str",  # Optional. The description of the type definition.
                    "elementDefs": [
                        {
                            "description": "str",  # Optional. The description of the enum element definition.
                            "ordinal": 0.0,  # Optional. The ordinal of the enum element definition.
                            "value": "str"  # Optional. The value of the enum element definition.
                        }
                    ],
                    "endDef1": {
                        "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                        "description": "str",  # Optional. The description of the relationship end definition.
                        "isContainer": bool,  # Optional. Determines if it is container.
                        "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                        "name": "str",  # Optional. The name of the relationship end definition.
                        "type": "str"  # Optional. The type of the relationship end.
                    },
                    "endDef2": {
                        "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                        "description": "str",  # Optional. The description of the relationship end definition.
                        "isContainer": bool,  # Optional. Determines if it is container.
                        "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                        "name": "str",  # Optional. The name of the relationship end definition.
                        "type": "str"  # Optional. The type of the relationship end.
                    },
                    "entityTypes": [
                        "str"  # Optional. Specifying a list of entityType names in the classificationDef, ensures that classifications can"nonly be applied to those entityTypes."n"n"n.. raw:: html"n"n   <ul>"n   <li>Any subtypes of the entity types inherit the restriction</li>"n   <li>Any classificationDef subtypes inherit the parents entityTypes restrictions</li>"n   <li>Any classificationDef subtypes can further restrict the parents entityTypes restrictions by specifying a subset of the entityTypes</li>"n   <li>An empty entityTypes list when there are no parent restrictions means there are no restrictions</li>"n   <li>An empty entityTypes list when there are parent restrictions means that the subtype picks up the parents restrictions</li>"n   <li>If a list of entityTypes are supplied, where one inherits from another, this will be rejected. This should encourage cleaner classificationsDefs</li>"n   </ul>.
                    ],
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "relationshipAttributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the attribute.
                            "description": "str",  # Optional. The description of the attribute.
                            "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is indexable.
                            "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                            "isOptional": bool,  # Optional. Determines if it is optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the attribute.
                            },
                            "relationshipTypeName": "str",  # Optional. The name of the relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                            "valuesMinCount": 0  # Optional. The minimum count of the values.
                        }
                    ],
                    "relationshipCategory": "str",  # Optional. The Relationship category determines the style of relationship around containment and lifecycle."nUML terminology is used for the values."n"n:code:`<p>`"nASSOCIATION is a relationship with no containment. :code:`<br>`"nCOMPOSITION and AGGREGATION are containment relationships."n"n:code:`<p>`"nThe difference being in the lifecycles of the container and its children. In the COMPOSITION case,"nthe children cannot exist without the container. For AGGREGATION, the life cycles"nof the container and children are totally independent. Possible values include: "ASSOCIATION", "AGGREGATION", "COMPOSITION".
                    "relationshipLabel": "str",  # Optional. The label of the relationship.
                    "serviceType": "str",  # Optional. The service type.
                    "subTypes": [
                        "str"  # Optional. An array of sub types.
                    ],
                    "superTypes": [
                        "str"  # Optional. An array of super types.
                    ],
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_types_get_type_definition_by_guid_request(
            guid=guid,
            template_url=self.get_type_definition_by_guid.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_type_definition_by_guid.metadata = {'url': '/atlas/v2/types/typedef/guid/{guid}'}  # type: ignore


    @distributed_trace
    def get_type_definition_by_name(
        self,
        name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get the type definition by its name (unique).

        :param name: The name of the type.
        :type name: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the attribute.
                            "description": "str",  # Optional. The description of the attribute.
                            "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is indexable.
                            "isOptional": bool,  # Optional. Determines if it is optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                            "valuesMinCount": 0  # Optional. The minimum count of the values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "defaultValue": "str",  # Optional. The default value.
                    "description": "str",  # Optional. The description of the type definition.
                    "elementDefs": [
                        {
                            "description": "str",  # Optional. The description of the enum element definition.
                            "ordinal": 0.0,  # Optional. The ordinal of the enum element definition.
                            "value": "str"  # Optional. The value of the enum element definition.
                        }
                    ],
                    "endDef1": {
                        "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                        "description": "str",  # Optional. The description of the relationship end definition.
                        "isContainer": bool,  # Optional. Determines if it is container.
                        "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                        "name": "str",  # Optional. The name of the relationship end definition.
                        "type": "str"  # Optional. The type of the relationship end.
                    },
                    "endDef2": {
                        "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                        "description": "str",  # Optional. The description of the relationship end definition.
                        "isContainer": bool,  # Optional. Determines if it is container.
                        "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                        "name": "str",  # Optional. The name of the relationship end definition.
                        "type": "str"  # Optional. The type of the relationship end.
                    },
                    "entityTypes": [
                        "str"  # Optional. Specifying a list of entityType names in the classificationDef, ensures that classifications can"nonly be applied to those entityTypes."n"n"n.. raw:: html"n"n   <ul>"n   <li>Any subtypes of the entity types inherit the restriction</li>"n   <li>Any classificationDef subtypes inherit the parents entityTypes restrictions</li>"n   <li>Any classificationDef subtypes can further restrict the parents entityTypes restrictions by specifying a subset of the entityTypes</li>"n   <li>An empty entityTypes list when there are no parent restrictions means there are no restrictions</li>"n   <li>An empty entityTypes list when there are parent restrictions means that the subtype picks up the parents restrictions</li>"n   <li>If a list of entityTypes are supplied, where one inherits from another, this will be rejected. This should encourage cleaner classificationsDefs</li>"n   </ul>.
                    ],
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "relationshipAttributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the attribute.
                            "description": "str",  # Optional. The description of the attribute.
                            "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is indexable.
                            "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                            "isOptional": bool,  # Optional. Determines if it is optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the attribute.
                            },
                            "relationshipTypeName": "str",  # Optional. The name of the relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                            "valuesMinCount": 0  # Optional. The minimum count of the values.
                        }
                    ],
                    "relationshipCategory": "str",  # Optional. The Relationship category determines the style of relationship around containment and lifecycle."nUML terminology is used for the values."n"n:code:`<p>`"nASSOCIATION is a relationship with no containment. :code:`<br>`"nCOMPOSITION and AGGREGATION are containment relationships."n"n:code:`<p>`"nThe difference being in the lifecycles of the container and its children. In the COMPOSITION case,"nthe children cannot exist without the container. For AGGREGATION, the life cycles"nof the container and children are totally independent. Possible values include: "ASSOCIATION", "AGGREGATION", "COMPOSITION".
                    "relationshipLabel": "str",  # Optional. The label of the relationship.
                    "serviceType": "str",  # Optional. The service type.
                    "subTypes": [
                        "str"  # Optional. An array of sub types.
                    ],
                    "superTypes": [
                        "str"  # Optional. An array of super types.
                    ],
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_types_get_type_definition_by_name_request(
            name=name,
            template_url=self.get_type_definition_by_name.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_type_definition_by_name.metadata = {'url': '/atlas/v2/types/typedef/name/{name}'}  # type: ignore


    @distributed_trace
    def delete_type_by_name(
        self,
        name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Delete API for type identified by its name.

        :param name: The name of the type.
        :type name: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_types_delete_type_by_name_request(
            name=name,
            template_url=self.delete_type_by_name.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    delete_type_by_name.metadata = {'url': '/atlas/v2/types/typedef/name/{name}'}  # type: ignore


    @distributed_trace
    def get_all_type_definitions(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get all type definitions in Atlas in bulk.

        :keyword include_term_template: Whether include termtemplatedef when return all typedefs.
         This is always true when search filter type=term_template.
        :paramtype include_term_template: bool
        :keyword type: Typedef name as search filter when get typedefs. Possible values are: "enum",
         "entity", "classification", "relationship", "struct", and "term_template".
        :paramtype type: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "classificationDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  # Optional. The parameters of the constraint definition.
                                            },
                                            "type": "str"  # Optional. The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The default value of the attribute.
                                    "description": "str",  # Optional. The description of the attribute.
                                    "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines if it is indexable.
                                    "isOptional": bool,  # Optional. Determines if it is optional.
                                    "isUnique": bool,  # Optional. Determines if it unique.
                                    "name": "str",  # Optional. The name of the attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of the daylight saving time.
                                    "id": "str",  # Optional. The ID of the timezone.
                                    "rawOffset": 0  # Optional. The raw offset of the timezone.
                                }
                            },
                            "description": "str",  # Optional. The description of the type definition.
                            "entityTypes": [
                                "str"  # Optional. Specifying a list of entityType names in the classificationDef, ensures that classifications can"nonly be applied to those entityTypes."n"n"n.. raw:: html"n"n   <ul>"n   <li>Any subtypes of the entity types inherit the restriction</li>"n   <li>Any classificationDef subtypes inherit the parents entityTypes restrictions</li>"n   <li>Any classificationDef subtypes can further restrict the parents entityTypes restrictions by specifying a subset of the entityTypes</li>"n   <li>An empty entityTypes list when there are no parent restrictions means there are no restrictions</li>"n   <li>An empty entityTypes list when there are parent restrictions means that the subtype picks up the parents restrictions</li>"n   <li>If a list of entityTypes are supplied, where one inherits from another, this will be rejected. This should encourage cleaner classificationsDefs</li>"n   </ul>.
                            ],
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type definition.
                            },
                            "serviceType": "str",  # Optional. The service type.
                            "subTypes": [
                                "str"  # Optional. An array of sub types.
                            ],
                            "superTypes": [
                                "str"  # Optional. An array of super types.
                            ],
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "entityDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  # Optional. The parameters of the constraint definition.
                                            },
                                            "type": "str"  # Optional. The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The default value of the attribute.
                                    "description": "str",  # Optional. The description of the attribute.
                                    "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines if it is indexable.
                                    "isOptional": bool,  # Optional. Determines if it is optional.
                                    "isUnique": bool,  # Optional. Determines if it unique.
                                    "name": "str",  # Optional. The name of the attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of the daylight saving time.
                                    "id": "str",  # Optional. The ID of the timezone.
                                    "rawOffset": 0  # Optional. The raw offset of the timezone.
                                }
                            },
                            "description": "str",  # Optional. The description of the type definition.
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type definition.
                            },
                            "relationshipAttributeDefs": [
                                {
                                    "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  # Optional. The parameters of the constraint definition.
                                            },
                                            "type": "str"  # Optional. The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The default value of the attribute.
                                    "description": "str",  # Optional. The description of the attribute.
                                    "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines if it is indexable.
                                    "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                                    "isOptional": bool,  # Optional. Determines if it is optional.
                                    "isUnique": bool,  # Optional. Determines if it unique.
                                    "name": "str",  # Optional. The name of the attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options for the attribute.
                                    },
                                    "relationshipTypeName": "str",  # Optional. The name of the relationship type.
                                    "typeName": "str",  # Optional. The name of the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum count of the values.
                                }
                            ],
                            "serviceType": "str",  # Optional. The service type.
                            "subTypes": [
                                "str"  # Optional. An array of sub types.
                            ],
                            "superTypes": [
                                "str"  # Optional. An array of super types.
                            ],
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "enumDefs": [
                        {
                            "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of the daylight saving time.
                                    "id": "str",  # Optional. The ID of the timezone.
                                    "rawOffset": 0  # Optional. The raw offset of the timezone.
                                }
                            },
                            "defaultValue": "str",  # Optional. The default value.
                            "description": "str",  # Optional. The description of the type definition.
                            "elementDefs": [
                                {
                                    "description": "str",  # Optional. The description of the enum element definition.
                                    "ordinal": 0.0,  # Optional. The ordinal of the enum element definition.
                                    "value": "str"  # Optional. The value of the enum element definition.
                                }
                            ],
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type definition.
                            },
                            "serviceType": "str",  # Optional. The service type.
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "relationshipDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  # Optional. The parameters of the constraint definition.
                                            },
                                            "type": "str"  # Optional. The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The default value of the attribute.
                                    "description": "str",  # Optional. The description of the attribute.
                                    "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines if it is indexable.
                                    "isOptional": bool,  # Optional. Determines if it is optional.
                                    "isUnique": bool,  # Optional. Determines if it unique.
                                    "name": "str",  # Optional. The name of the attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of the daylight saving time.
                                    "id": "str",  # Optional. The ID of the timezone.
                                    "rawOffset": 0  # Optional. The raw offset of the timezone.
                                }
                            },
                            "description": "str",  # Optional. The description of the type definition.
                            "endDef1": {
                                "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                "description": "str",  # Optional. The description of the relationship end definition.
                                "isContainer": bool,  # Optional. Determines if it is container.
                                "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                                "name": "str",  # Optional. The name of the relationship end definition.
                                "type": "str"  # Optional. The type of the relationship end.
                            },
                            "endDef2": {
                                "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                "description": "str",  # Optional. The description of the relationship end definition.
                                "isContainer": bool,  # Optional. Determines if it is container.
                                "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                                "name": "str",  # Optional. The name of the relationship end definition.
                                "type": "str"  # Optional. The type of the relationship end.
                            },
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type definition.
                            },
                            "relationshipCategory": "str",  # Optional. The Relationship category determines the style of relationship around containment and lifecycle."nUML terminology is used for the values."n"n:code:`<p>`"nASSOCIATION is a relationship with no containment. :code:`<br>`"nCOMPOSITION and AGGREGATION are containment relationships."n"n:code:`<p>`"nThe difference being in the lifecycles of the container and its children. In the COMPOSITION case,"nthe children cannot exist without the container. For AGGREGATION, the life cycles"nof the container and children are totally independent. Possible values include: "ASSOCIATION", "AGGREGATION", "COMPOSITION".
                            "relationshipLabel": "str",  # Optional. The label of the relationship.
                            "serviceType": "str",  # Optional. The service type.
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "structDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  # Optional. The parameters of the constraint definition.
                                            },
                                            "type": "str"  # Optional. The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The default value of the attribute.
                                    "description": "str",  # Optional. The description of the attribute.
                                    "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines if it is indexable.
                                    "isOptional": bool,  # Optional. Determines if it is optional.
                                    "isUnique": bool,  # Optional. Determines if it unique.
                                    "name": "str",  # Optional. The name of the attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of the daylight saving time.
                                    "id": "str",  # Optional. The ID of the timezone.
                                    "rawOffset": 0  # Optional. The raw offset of the timezone.
                                }
                            },
                            "description": "str",  # Optional. The description of the type definition.
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type definition.
                            },
                            "serviceType": "str",  # Optional. The service type.
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "termTemplateDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  # Optional. The parameters of the constraint definition.
                                            },
                                            "type": "str"  # Optional. The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The default value of the attribute.
                                    "description": "str",  # Optional. The description of the attribute.
                                    "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines if it is indexable.
                                    "isOptional": bool,  # Optional. Determines if it is optional.
                                    "isUnique": bool,  # Optional. Determines if it unique.
                                    "name": "str",  # Optional. The name of the attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of the daylight saving time.
                                    "id": "str",  # Optional. The ID of the timezone.
                                    "rawOffset": 0  # Optional. The raw offset of the timezone.
                                }
                            },
                            "description": "str",  # Optional. The description of the type definition.
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type definition.
                            },
                            "serviceType": "str",  # Optional. The service type.
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        include_term_template = kwargs.pop('include_term_template', False)  # type: Optional[bool]
        type = kwargs.pop('type', None)  # type: Optional[str]

        
        request = build_types_get_all_type_definitions_request(
            include_term_template=include_term_template,
            type=type,
            template_url=self.get_all_type_definitions.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_type_definitions.metadata = {'url': '/atlas/v2/types/typedefs'}  # type: ignore


    @distributed_trace
    def create_type_definitions(
        self,
        types_def,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Create all atlas type definitions in bulk, only new definitions will be created.
        Any changes to the existing definitions will be discarded.

        :param types_def: A composite wrapper object with corresponding lists of the type definition.
        :type types_def: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                types_def = {
                    "classificationDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  # Optional. The parameters of the constraint definition.
                                            },
                                            "type": "str"  # Optional. The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The default value of the attribute.
                                    "description": "str",  # Optional. The description of the attribute.
                                    "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines if it is indexable.
                                    "isOptional": bool,  # Optional. Determines if it is optional.
                                    "isUnique": bool,  # Optional. Determines if it unique.
                                    "name": "str",  # Optional. The name of the attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of the daylight saving time.
                                    "id": "str",  # Optional. The ID of the timezone.
                                    "rawOffset": 0  # Optional. The raw offset of the timezone.
                                }
                            },
                            "description": "str",  # Optional. The description of the type definition.
                            "entityTypes": [
                                "str"  # Optional. Specifying a list of entityType names in the classificationDef, ensures that classifications can"nonly be applied to those entityTypes."n"n"n.. raw:: html"n"n   <ul>"n   <li>Any subtypes of the entity types inherit the restriction</li>"n   <li>Any classificationDef subtypes inherit the parents entityTypes restrictions</li>"n   <li>Any classificationDef subtypes can further restrict the parents entityTypes restrictions by specifying a subset of the entityTypes</li>"n   <li>An empty entityTypes list when there are no parent restrictions means there are no restrictions</li>"n   <li>An empty entityTypes list when there are parent restrictions means that the subtype picks up the parents restrictions</li>"n   <li>If a list of entityTypes are supplied, where one inherits from another, this will be rejected. This should encourage cleaner classificationsDefs</li>"n   </ul>.
                            ],
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type definition.
                            },
                            "serviceType": "str",  # Optional. The service type.
                            "subTypes": [
                                "str"  # Optional. An array of sub types.
                            ],
                            "superTypes": [
                                "str"  # Optional. An array of super types.
                            ],
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "entityDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  # Optional. The parameters of the constraint definition.
                                            },
                                            "type": "str"  # Optional. The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The default value of the attribute.
                                    "description": "str",  # Optional. The description of the attribute.
                                    "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines if it is indexable.
                                    "isOptional": bool,  # Optional. Determines if it is optional.
                                    "isUnique": bool,  # Optional. Determines if it unique.
                                    "name": "str",  # Optional. The name of the attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of the daylight saving time.
                                    "id": "str",  # Optional. The ID of the timezone.
                                    "rawOffset": 0  # Optional. The raw offset of the timezone.
                                }
                            },
                            "description": "str",  # Optional. The description of the type definition.
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type definition.
                            },
                            "relationshipAttributeDefs": [
                                {
                                    "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  # Optional. The parameters of the constraint definition.
                                            },
                                            "type": "str"  # Optional. The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The default value of the attribute.
                                    "description": "str",  # Optional. The description of the attribute.
                                    "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines if it is indexable.
                                    "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                                    "isOptional": bool,  # Optional. Determines if it is optional.
                                    "isUnique": bool,  # Optional. Determines if it unique.
                                    "name": "str",  # Optional. The name of the attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options for the attribute.
                                    },
                                    "relationshipTypeName": "str",  # Optional. The name of the relationship type.
                                    "typeName": "str",  # Optional. The name of the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum count of the values.
                                }
                            ],
                            "serviceType": "str",  # Optional. The service type.
                            "subTypes": [
                                "str"  # Optional. An array of sub types.
                            ],
                            "superTypes": [
                                "str"  # Optional. An array of super types.
                            ],
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "enumDefs": [
                        {
                            "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of the daylight saving time.
                                    "id": "str",  # Optional. The ID of the timezone.
                                    "rawOffset": 0  # Optional. The raw offset of the timezone.
                                }
                            },
                            "defaultValue": "str",  # Optional. The default value.
                            "description": "str",  # Optional. The description of the type definition.
                            "elementDefs": [
                                {
                                    "description": "str",  # Optional. The description of the enum element definition.
                                    "ordinal": 0.0,  # Optional. The ordinal of the enum element definition.
                                    "value": "str"  # Optional. The value of the enum element definition.
                                }
                            ],
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type definition.
                            },
                            "serviceType": "str",  # Optional. The service type.
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "relationshipDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  # Optional. The parameters of the constraint definition.
                                            },
                                            "type": "str"  # Optional. The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The default value of the attribute.
                                    "description": "str",  # Optional. The description of the attribute.
                                    "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines if it is indexable.
                                    "isOptional": bool,  # Optional. Determines if it is optional.
                                    "isUnique": bool,  # Optional. Determines if it unique.
                                    "name": "str",  # Optional. The name of the attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of the daylight saving time.
                                    "id": "str",  # Optional. The ID of the timezone.
                                    "rawOffset": 0  # Optional. The raw offset of the timezone.
                                }
                            },
                            "description": "str",  # Optional. The description of the type definition.
                            "endDef1": {
                                "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                "description": "str",  # Optional. The description of the relationship end definition.
                                "isContainer": bool,  # Optional. Determines if it is container.
                                "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                                "name": "str",  # Optional. The name of the relationship end definition.
                                "type": "str"  # Optional. The type of the relationship end.
                            },
                            "endDef2": {
                                "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                "description": "str",  # Optional. The description of the relationship end definition.
                                "isContainer": bool,  # Optional. Determines if it is container.
                                "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                                "name": "str",  # Optional. The name of the relationship end definition.
                                "type": "str"  # Optional. The type of the relationship end.
                            },
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type definition.
                            },
                            "relationshipCategory": "str",  # Optional. The Relationship category determines the style of relationship around containment and lifecycle."nUML terminology is used for the values."n"n:code:`<p>`"nASSOCIATION is a relationship with no containment. :code:`<br>`"nCOMPOSITION and AGGREGATION are containment relationships."n"n:code:`<p>`"nThe difference being in the lifecycles of the container and its children. In the COMPOSITION case,"nthe children cannot exist without the container. For AGGREGATION, the life cycles"nof the container and children are totally independent. Possible values include: "ASSOCIATION", "AGGREGATION", "COMPOSITION".
                            "relationshipLabel": "str",  # Optional. The label of the relationship.
                            "serviceType": "str",  # Optional. The service type.
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "structDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  # Optional. The parameters of the constraint definition.
                                            },
                                            "type": "str"  # Optional. The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The default value of the attribute.
                                    "description": "str",  # Optional. The description of the attribute.
                                    "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines if it is indexable.
                                    "isOptional": bool,  # Optional. Determines if it is optional.
                                    "isUnique": bool,  # Optional. Determines if it unique.
                                    "name": "str",  # Optional. The name of the attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of the daylight saving time.
                                    "id": "str",  # Optional. The ID of the timezone.
                                    "rawOffset": 0  # Optional. The raw offset of the timezone.
                                }
                            },
                            "description": "str",  # Optional. The description of the type definition.
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type definition.
                            },
                            "serviceType": "str",  # Optional. The service type.
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "termTemplateDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  # Optional. The parameters of the constraint definition.
                                            },
                                            "type": "str"  # Optional. The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The default value of the attribute.
                                    "description": "str",  # Optional. The description of the attribute.
                                    "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines if it is indexable.
                                    "isOptional": bool,  # Optional. Determines if it is optional.
                                    "isUnique": bool,  # Optional. Determines if it unique.
                                    "name": "str",  # Optional. The name of the attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of the daylight saving time.
                                    "id": "str",  # Optional. The ID of the timezone.
                                    "rawOffset": 0  # Optional. The raw offset of the timezone.
                                }
                            },
                            "description": "str",  # Optional. The description of the type definition.
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type definition.
                            },
                            "serviceType": "str",  # Optional. The service type.
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ]
                }

                # response body for status code(s): 200
                response.json() == {
                    "classificationDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  # Optional. The parameters of the constraint definition.
                                            },
                                            "type": "str"  # Optional. The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The default value of the attribute.
                                    "description": "str",  # Optional. The description of the attribute.
                                    "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines if it is indexable.
                                    "isOptional": bool,  # Optional. Determines if it is optional.
                                    "isUnique": bool,  # Optional. Determines if it unique.
                                    "name": "str",  # Optional. The name of the attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of the daylight saving time.
                                    "id": "str",  # Optional. The ID of the timezone.
                                    "rawOffset": 0  # Optional. The raw offset of the timezone.
                                }
                            },
                            "description": "str",  # Optional. The description of the type definition.
                            "entityTypes": [
                                "str"  # Optional. Specifying a list of entityType names in the classificationDef, ensures that classifications can"nonly be applied to those entityTypes."n"n"n.. raw:: html"n"n   <ul>"n   <li>Any subtypes of the entity types inherit the restriction</li>"n   <li>Any classificationDef subtypes inherit the parents entityTypes restrictions</li>"n   <li>Any classificationDef subtypes can further restrict the parents entityTypes restrictions by specifying a subset of the entityTypes</li>"n   <li>An empty entityTypes list when there are no parent restrictions means there are no restrictions</li>"n   <li>An empty entityTypes list when there are parent restrictions means that the subtype picks up the parents restrictions</li>"n   <li>If a list of entityTypes are supplied, where one inherits from another, this will be rejected. This should encourage cleaner classificationsDefs</li>"n   </ul>.
                            ],
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type definition.
                            },
                            "serviceType": "str",  # Optional. The service type.
                            "subTypes": [
                                "str"  # Optional. An array of sub types.
                            ],
                            "superTypes": [
                                "str"  # Optional. An array of super types.
                            ],
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "entityDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  # Optional. The parameters of the constraint definition.
                                            },
                                            "type": "str"  # Optional. The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The default value of the attribute.
                                    "description": "str",  # Optional. The description of the attribute.
                                    "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines if it is indexable.
                                    "isOptional": bool,  # Optional. Determines if it is optional.
                                    "isUnique": bool,  # Optional. Determines if it unique.
                                    "name": "str",  # Optional. The name of the attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of the daylight saving time.
                                    "id": "str",  # Optional. The ID of the timezone.
                                    "rawOffset": 0  # Optional. The raw offset of the timezone.
                                }
                            },
                            "description": "str",  # Optional. The description of the type definition.
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type definition.
                            },
                            "relationshipAttributeDefs": [
                                {
                                    "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  # Optional. The parameters of the constraint definition.
                                            },
                                            "type": "str"  # Optional. The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The default value of the attribute.
                                    "description": "str",  # Optional. The description of the attribute.
                                    "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines if it is indexable.
                                    "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                                    "isOptional": bool,  # Optional. Determines if it is optional.
                                    "isUnique": bool,  # Optional. Determines if it unique.
                                    "name": "str",  # Optional. The name of the attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options for the attribute.
                                    },
                                    "relationshipTypeName": "str",  # Optional. The name of the relationship type.
                                    "typeName": "str",  # Optional. The name of the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum count of the values.
                                }
                            ],
                            "serviceType": "str",  # Optional. The service type.
                            "subTypes": [
                                "str"  # Optional. An array of sub types.
                            ],
                            "superTypes": [
                                "str"  # Optional. An array of super types.
                            ],
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "enumDefs": [
                        {
                            "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of the daylight saving time.
                                    "id": "str",  # Optional. The ID of the timezone.
                                    "rawOffset": 0  # Optional. The raw offset of the timezone.
                                }
                            },
                            "defaultValue": "str",  # Optional. The default value.
                            "description": "str",  # Optional. The description of the type definition.
                            "elementDefs": [
                                {
                                    "description": "str",  # Optional. The description of the enum element definition.
                                    "ordinal": 0.0,  # Optional. The ordinal of the enum element definition.
                                    "value": "str"  # Optional. The value of the enum element definition.
                                }
                            ],
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type definition.
                            },
                            "serviceType": "str",  # Optional. The service type.
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "relationshipDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  # Optional. The parameters of the constraint definition.
                                            },
                                            "type": "str"  # Optional. The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The default value of the attribute.
                                    "description": "str",  # Optional. The description of the attribute.
                                    "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines if it is indexable.
                                    "isOptional": bool,  # Optional. Determines if it is optional.
                                    "isUnique": bool,  # Optional. Determines if it unique.
                                    "name": "str",  # Optional. The name of the attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of the daylight saving time.
                                    "id": "str",  # Optional. The ID of the timezone.
                                    "rawOffset": 0  # Optional. The raw offset of the timezone.
                                }
                            },
                            "description": "str",  # Optional. The description of the type definition.
                            "endDef1": {
                                "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                "description": "str",  # Optional. The description of the relationship end definition.
                                "isContainer": bool,  # Optional. Determines if it is container.
                                "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                                "name": "str",  # Optional. The name of the relationship end definition.
                                "type": "str"  # Optional. The type of the relationship end.
                            },
                            "endDef2": {
                                "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                "description": "str",  # Optional. The description of the relationship end definition.
                                "isContainer": bool,  # Optional. Determines if it is container.
                                "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy attribute.
                                "name": "str",  # Optional. The name of the relationship end definition.
                                "type": "str"  # Optional. The type of the relationship end.
                            },
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type definition.
                            },
                            "relationshipCategory": "str",  # Optional. The Relationship category determines the style of relationship around containment and lifecycle."nUML terminology is used for the values."n"n:code:`<p>`"nASSOCIATION is a relationship with no containment. :code:`<br>`"nCOMPOSITION and AGGREGATION are containment relationships."n"n:code:`<p>`"nThe difference being in the lifecycles of the container and its children. In the COMPOSITION case,"nthe children cannot exist without the container. For AGGREGATION, the life cycles"nof the container and children are totally independent. Possible values include: "ASSOCIATION", "AGGREGATION", "COMPOSITION".
                            "relationshipLabel": "str",  # Optional. The label of the relationship.
                            "serviceType": "str",  # Optional. The service type.
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "structDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  # Optional. The parameters of the constraint definition.
                                            },
                                            "type": "str"  # Optional. The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The default value of the attribute.
                                    "description": "str",  # Optional. The description of the attribute.
                                    "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines if it is indexable.
                                    "isOptional": bool,  # Optional. Determines if it is optional.
                                    "isUnique": bool,  # Optional. Determines if it unique.
                                    "name": "str",  # Optional. The name of the attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of the daylight saving time.
                                    "id": "str",  # Optional. The ID of the timezone.
                                    "rawOffset": 0  # Optional. The raw offset of the timezone.
                                }
                            },
                            "description": "str",  # Optional. The description of the type definition.
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type definition.
                            },
                            "serviceType": "str",  # Optional. The service type.
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "termTemplateDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  # Optional. The parameters of the constraint definition.
                                            },
                                            "type": "str"  # Optional. The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The default value of the attribute.
                                    "description": "str",  # Optional. The description of the attribute.
                                    "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines if it is indexable.
                                    "isOptional": bool,  # Optional. Determines if it is optional.
                                    "isUnique": bool,  # Optional. Determines if it unique.
                                    "name": "str",  # Optional. The name of the attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of the daylight saving time.
                                    "id": "str",  # Optional. The ID of the timezone.
                                    "rawOffset": 0  # Optional. The raw offset of the timezone.
                                }
                            },
                            "description": "str",  # Optional. The description of the type definition.
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type definition.
                            },
                            "serviceType": "str",  # Optional. The service type.
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = types_def

        request = build_types_create_type_definitions_request(
            content_type=content_type,
            json=json,
            template_url=self.create_type_definitions.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_type_definitions.metadata = {'url': '/atlas/v2/types/typedefs'}  # type: ignore


    @distributed_trace
    def update_atlas_type_definitions(
        self,
        types_def,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Update all types in bulk, changes detected in the type definitions would be persisted.

        :param types_def: A composite object that captures all type definition changes.
        :type types_def: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                types_def = {
                    "classificationDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional. single-valued attribute or multi-valued attribute. Possible values include: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  # Optional. The parameters of the constraint definition.
                                            },
                                            "type": "str"  # Optional. The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The default value of the attribute.
                                    "description": "str",  # Optional. The description of the attribute.
                                    "includeInNotification": bool,  # Optional. Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines if it is indexable.
                                    "isOptional": bool,  # Optional. Determines if it is optional.
                                    "isUnique": bool,  # Optional. Determines if it unique.
                                    "name": "str",  # Optional. The name of the attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category. Possible values include: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional. Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum of rounding mode. Possible values include: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of the daylight saving time.
          