# FreeBSD kernel syscall list from FreeBSD 7.0RC1 for i386
#
# List extracted from:
#    /usr/include/sys/syscall.h
SYSCALL_NAMES = {
    0: "syscall",
    1: "exit",
    2: "fork",
    3: "read",
    4: "write",
    5: "open",
    6: "close",
    7: "wait4",
#   8: old creat
    9: "link",
    10: "unlink",
#   11: obsolete execv
    12: "chdir",
    13: "fchdir",
    14: "mknod",
    15: "chmod",
    16: "chown",
    17: "break",
    18: "freebsd4_getfsstat",
#   19: old lseek
    20: "getpid",
    21: "mount",
    22: "unmount",
    23: "setuid",
    24: "getuid",
    25: "geteuid",
    26: "ptrace",
    27: "recvmsg",
    28: "sendmsg",
    29: "recvfrom",
    30: "accept",
    31: "getpeername",
    32: "getsockname",
    33: "access",
    34: "chflags",
    35: "fchflags",
    36: "sync",
    37: "kill",
#   38: old stat
    39: "getppid",
#   40: old lstat
    41: "dup",
    42: "pipe",
    43: "getegid",
    44: "profil",
    45: "ktrace",
#   46: old sigaction
    47: "getgid",
#   48: old sigprocmask
    49: "getlogin",
    50: "setlogin",
    51: "acct",
#   52: old sigpending
    53: "sigaltstack",
    54: "ioctl",
    55: "reboot",
    56: "revoke",
    57: "symlink",
    58: "readlink",
    59: "execve",
    60: "umask",
    61: "chroot",
#   62: old fstat
#   63: old getkerninfo
#   64: old getpagesize
    65: "msync",
    66: "vfork",
#   67: obsolete vread
#   68: obsolete vwrite
    69: "sbrk",
    70: "sstk",
#   71: old mmap
    72: "vadvise",
    73: "munmap",
    74: "mprotect",
    75: "madvise",
#   76: obsolete vhangup
#   77: obsolete vlimit
    78: "mincore",
    79: "getgroups",
    80: "setgroups",
    81: "getpgrp",
    82: "setpgid",
    83: "setitimer",
#   84: old wait
    85: "swapon",
    86: "getitimer",
#   87: old gethostname
#   88: old sethostname
    89: "getdtablesize",
    90: "dup2",
    92: "fcntl",
    93: "select",
    95: "fsync",
    96: "setpriority",
    97: "socket",
    98: "connect",
#   99: old accept
    100: "getpriority",
#   101: old send
#   102: old recv
#   103: old sigreturn
    104: "bind",
    105: "setsockopt",
    106: "listen",
#   107: obsolete vtimes
#   108: old sigvec
#   109: old sigblock
#   110: old sigsetmask
#   111: old sigsuspend
#   112: old sigstack
#   113: old recvmsg
#   114: old sendmsg
#   115: obsolete vtrace
    116: "gettimeofday",
    117: "getrusage",
    118: "getsockopt",
    120: "readv",
    121: "writev",
    122: "settimeofday",
    123: "fchown",
    124: "fchmod",
#   125: old recvfrom
    126: "setreuid",
    127: "setregid",
    128: "rename",
#   129: old truncate
#   130: old ftruncate
    131: "flock",
    132: "mkfifo",
    133: "sendto",
    134: "shutdown",
    135: "socketpair",
    136: "mkdir",
    137: "rmdir",
    138: "utimes",
#   139: obsolete 4.2 sigreturn
    140: "adjtime",
#   141: old getpeername
#   142: old gethostid
#   143: old sethostid
#   144: old getrlimit
#   145: old setrlimit
#   146: old killpg
    147: "setsid",
    148: "quotactl",
#   149: old quota
#   150: old getsockname
    155: "nfssvc",
#   156: old getdirentries
    157: "freebsd4_statfs",
    158: "freebsd4_fstatfs",
    160: "lgetfh",
    161: "getfh",
    162: "getdomainname",
    163: "setdomainname",
    164: "uname",
    165: "sysarch",
    166: "rtprio",
    169: "semsys",
    170: "msgsys",
    171: "shmsys",
    173: "freebsd6_pread",
    174: "freebsd6_pwrite",
    176: "ntp_adjtime",
    181: "setgid",
    182: "setegid",
    183: "seteuid",
    188: "stat",
    189: "fstat",
    190: "lstat",
    191: "pathconf",
    192: "fpathconf",
    194: "getrlimit",
    195: "setrlimit",
    196: "getdirentries",
    197: "freebsd6_mmap",
    198: "__syscall",
    199: "freebsd6_lseek",
    200: "freebsd6_truncate",
    201: "freebsd6_ftruncate",
    202: "__sysctl",
    203: "mlock",
    204: "munlock",
    205: "undelete",
    206: "futimes",
    207: "getpgid",
    209: "poll",
    220: "__semctl",
    221: "semget",
    222: "semop",
    224: "msgctl",
    225: "msgget",
    226: "msgsnd",
    227: "msgrcv",
    228: "shmat",
    229: "shmctl",
    230: "shmdt",
    231: "shmget",
    232: "clock_gettime",
    233: "clock_settime",
    234: "clock_getres",
    235: "ktimer_create",
    236: "ktimer_delete",
    237: "ktimer_settime",
    238: "ktimer_gettime",
    239: "ktimer_getoverrun",
    240: "nanosleep",
    248: "ntp_gettime",
    250: "minherit",
    251: "rfork",
    252: "openbsd_poll",
    253: "issetugid",
    254: "lchown",
    255: "aio_read",
    256: "aio_write",
    257: "lio_listio",
    272: "getdents",
    274: "lchmod",
    275: "netbsd_lchown",
    276: "lutimes",
    277: "netbsd_msync",
    278: "nstat",
    279: "nfstat",
    280: "nlstat",
    289: "preadv",
    290: "pwritev",
    297: "freebsd4_fhstatfs",
    298: "fhopen",
    299: "fhstat",
    300: "modnext",
    301: "modstat",
    302: "modfnext",
    303: "modfind",
    304: "kldload",
    305: "kldunload",
    306: "kldfind",
    307: "kldnext",
    308: "kldstat",
    309: "kldfirstmod",
    310: "getsid",
    311: "setresuid",
    312: "setresgid",
#   313: obsolete signanosleep
    314: "aio_return",
    315: "aio_suspend",
    316: "aio_cancel",
    317: "aio_error",
    318: "oaio_read",
    319: "oaio_write",
    320: "olio_listio",
    321: "yield",
#   322: obsolete thr_sleep
#   323: obsolete thr_wakeup
    324: "mlockall",
    325: "munlockall",
    326: "__getcwd",
    327: "sched_setparam",
    328: "sched_getparam",
    329: "sched_setscheduler",
    330: "sched_getscheduler",
    331: "sched_yield",
    332: "sched_get_priority_max",
    333: "sched_get_priority_min",
    334: "sched_rr_get_interval",
    335: "utrace",
    336: "freebsd4_sendfile",
    337: "kldsym",
    338: "jail",
    340: "sigprocmask",
    341: "sigsuspend",
    342: "freebsd4_sigaction",
    343: "sigpending",
    344: "freebsd4_sigreturn",
    345: "sigtimedwait",
    346: "sigwaitinfo",
    347: "__acl_get_file",
    348: "__acl_set_file",
    349: "__acl_get_fd",
    350: "__acl_set_fd",
    351: "__acl_delete_file",
    352: "__acl_delete_fd",
    353: "__acl_aclcheck_file",
    354: "__acl_aclcheck_fd",
    355: "extattrctl",
    356: "extattr_set_file",
    357: "extattr_get_file",
    358: "extattr_delete_file",
    359: "aio_waitcomplete",
    360: "getresuid",
    361: "getresgid",
    362: "kqueue",
    363: "kevent",
    371: "extattr_set_fd",
    372: "extattr_get_fd",
    373: "extattr_delete_fd",
    374: "__setugid",
    375: "nfsclnt",
    376: "eaccess",
    378: "nmount",
    379: "kse_exit",
    380: "kse_wakeup",
    381: "kse_create",
    382: "kse_thr_interrupt",
    383: "kse_release",
    384: "__mac_get_proc",
    385: "__mac_set_proc",
    386: "__mac_get_fd",
    387: "__mac_get_file",
    388: "__mac_set_fd",
    389: "__mac_set_file",
    390: "kenv",
    391: "lchflags",
    392: "uuidgen",
    393: "sendfile",
    394: "mac_syscall",
    395: "getfsstat",
    396: "statfs",
    397: "fstatfs",
    398: "fhstatfs",
    400: "ksem_close",
    401: "ksem_post",
    402: "ksem_wait",
    403: "ksem_trywait",
    404: "ksem_init",
    405: "ksem_open",
    406: "ksem_unlink",
    407: "ksem_getvalue",
    408: "ksem_destroy",
    409: "__mac_get_pid",
    410: "__mac_get_link",
    411: "__mac_set_link",
    412: "extattr_set_link",
    413: "extattr_get_link",
    414: "extattr_delete_link",
    415: "__mac_execve",
    416: "sigaction",
    417: "sigreturn",
    421: "getcontext",
    422: "setcontext",
    423: "swapcontext",
    424: "swapoff",
    425: "__acl_get_link",
    426: "__acl_set_link",
    427: "__acl_delete_link",
    428: "__acl_aclcheck_link",
    429: "sigwait",
    430: "thr_create",
    431: "thr_exit",
    432: "thr_self",
    433: "thr_kill",
    434: "_umtx_lock",
    435: "_umtx_unlock",
    436: "jail_attach",
    437: "extattr_list_fd",
    438: "extattr_list_file",
    439: "extattr_list_link",
    440: "kse_switchin",
    441: "ksem_timedwait",
    442: "thr_suspend",
    443: "thr_wake",
    444: "kldunloadf",
    445: "audit",
    446: "auditon",
    447: "getauid",
    448: "setauid",
    449: "getaudit",
    450: "setaudit",
    451: "getaudit_addr",
    452: "setaudit_addr",
    453: "auditctl",
    454: "_umtx_op",
    455: "thr_new",
    456: "sigqueue",
    457: "kmq_open",
    458: "kmq_setattr",
    459: "kmq_timedreceive",
    460: "kmq_timedsend",
    461: "kmq_notify",
    462: "kmq_unlink",
    463: "abort2",
    464: "thr_set_name",
    465: "aio_fsync",
    466: "rtprio_thread",
    471: "sctp_peeloff",
    472: "sctp_generic_sendmsg",
    473: "sctp_generic_sendmsg_iov",
    474: "sctp_generic_recvmsg",
    475: "pread",
    476: "pwrite",
    477: "mmap",
    478: "lseek",
    479: "truncate",
    480: "ftruncate",
    481: "thr_kill2",
}

SOCKET_SYSCALL_NAMES = set((
    "socket", "socketpair", "connect",
    "sendto", "recvfrom", "sendmsg", "recvmsg",
    "bind", "listen", "accept",
    "getpeername", "getsockname", "getsockopt", "setsockopt",
    "shutdown",
))
