# PySNMP SMI module. Autogenerated from smidump -f python HPR-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:39:04 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( SnaControlPointName, ) = mibBuilder.importSymbols("APPN-MIB", "SnaControlPointName")
( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( snanauMIB, ) = mibBuilder.importSymbols("SNA-NAU-MIB", "snanauMIB")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, Unsigned32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "Unsigned32")
( DateAndTime, DisplayString, TextualConvention, TimeStamp, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "DisplayString", "TextualConvention", "TimeStamp")

# Types

class HprNceTypes(Bits):
    namedValues = NamedValues(("controlPoint", 0), ("logicalUnit", 1), ("boundaryFunction", 2), ("routeSetup", 3), )
    
class HprRtpCounter(Counter32):
    pass


# Objects

hprMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 34, 6)).setRevisions(("1997-05-14 00:00",))
if mibBuilder.loadTexts: hprMIB.setOrganization("AIW APPN / HPR MIB SIG")
if mibBuilder.loadTexts: hprMIB.setContactInfo("\n\nBob Clouston\nCisco Systems\n7025 Kit Creek Road\nP.O. Box 14987\nResearch Triangle Park, NC 27709, USA\nTel:    1 919 472 2333\nE-mail: clouston@cisco.com\n\nBob Moore\nIBM Corporation\n800 Park Offices Drive\nRHJA/664\nP.O. Box 12195\nResearch Triangle Park, NC 27709, USA\nTel:    1 919 254 4436\nE-mail: remoore@ralvm6.vnet.ibm.com")
if mibBuilder.loadTexts: hprMIB.setDescription("This is the MIB module for objects used to\nmanage network devices with HPR capabilities.")
hprObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 6, 1))
hprGlobal = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 6, 1, 1))
hprNodeCpName = MibScalar((1, 3, 6, 1, 2, 1, 34, 6, 1, 1, 1), SnaControlPointName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprNodeCpName.setDescription("Administratively assigned network name for the APPN node\nwhere this HPR implementation resides.  If this object has\nthe same value as the appnNodeCpName object in the APPN MIB,\nthen the two objects are referring to the same APPN node.")
hprOperatorPathSwitchSupport = MibScalar((1, 3, 6, 1, 2, 1, 34, 6, 1, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,)).subtype(namedValues=NamedValues(("notSupported", 1), ("switchTriggerSupported", 2), ("switchToPathSupported", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprOperatorPathSwitchSupport.setDescription("This object indicates an implementation's level of support\nfor an operator-requested path switch.\n\n  notSupported(1)           - the agent does not support\n                              operator-requested path switches\n  switchTriggerSupported(2) - the agent supports a 'switch\n                              path now' command from an\n                              operator, but not a command to\n                              switch to a specified path\n  switchToPathSupported(3)  - the agent supports both a\n                              'switch path now' command and a\n                              command to switch to a specified\n                              path.  Note that the latter\n                              command is not available via\n                              this MIB; a system that supports\n                              it must do so via other means,\n                              such as a local operator\n                              interface.")
hprAnrRouting = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 6, 1, 2))
hprAnrsAssigned = MibScalar((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 1), Counter32()).setMaxAccess("readonly").setUnits("ANR labels")
if mibBuilder.loadTexts: hprAnrsAssigned.setDescription("The count of ANR labels assigned by this node since it was\nlast re-initialized.  A Management Station can detect\ndiscontinuities in this counter by monitoring the\nappnNodeCounterDisconTime object in the APPN MIB.")
hprAnrCounterState = MibScalar((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("notActive", 1), ("active", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hprAnrCounterState.setDescription("This object is used for a network management station to turn\non/off the counting of ANR packets in the hprAnrRoutingTable.\nThe initial value of this object is an implementation choice.\n\n       notActive(1) - the counter hprAnrPacketsReceived\n                      returns no meaningful value\n       active(2)    - the counter hprAnrPacketsReceived is\n                      being incremented and is returning\n                      meaningful values")
hprAnrCounterStateTime = MibScalar((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 3), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprAnrCounterStateTime.setDescription("The time when the hprAnrCounterState object last changed its\nvalue.  The initial value returned by this object is the time\nat which the APPN node instrumented with this MIB was last\nbrought up.")
hprAnrRoutingTable = MibTable((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 4))
if mibBuilder.loadTexts: hprAnrRoutingTable.setDescription("The ANR Routing table provides a means of correlating an\nincoming ANR label (i.e., one assigned by this node) with the\nTG over which a packet containing the label will be forwarded.\nWhen the ANR label identifies a local NCE, the hprAnrOutTgDest\nand hprAnrOutTgNum objects have no meaning.  The table also\ncontains an object to count the number of packets received\nwith a given ANR label.")
hprAnrRoutingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 4, 1)).setIndexNames((0, "HPR-MIB", "hprAnrLabel"))
if mibBuilder.loadTexts: hprAnrRoutingEntry.setDescription("The ANR label is used to index this table.")
hprAnrLabel = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 4, 1, 1), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 8))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: hprAnrLabel.setDescription("The first ANR label in an incoming packet.")
hprAnrType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 4, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("nce", 1), ("tg", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprAnrType.setDescription("An object indicating whether an ANR label assigned by this\nnode identifies a local NCE or a TG on which outgoing packets\nare forwarded.\n\n    nce(1)  - the ANR label identifies a local NCE.  In this\n              case the hprAnrOutTgDest and hprAnrOutTgNum\n              objects have no meaning.\n    tg(2)   - the ANR label identifies a TG.")
hprAnrOutTgDest = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 4, 1, 3), DisplayString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(3,17),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprAnrOutTgDest.setDescription("Destination node for the TG over which packets with this ANR\nlabel are forwarded.  This is the fully qualified name of an\nAPPN network node or end node, formatted according to the\nSnaControlPointName textual convention.  If the ANR label\nidentifies a local NCE, then this object returns a zero-length\nstring.\n\nThis object corresponds to the appnLocalTgDest object in the\nAPPN MIB.")
hprAnrOutTgNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 4, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprAnrOutTgNum.setDescription("Number of the TG over which packets with this ANR label are\nforwarded.  If the ANR label identifies a local NCE, then this\nobject returns the value 0, since 0 is not a valid TG number\nfor a TG that supports HPR.\n\nThis object corresponds to the appnLocalTgNum object in the\nAPPN MIB.")
hprAnrPacketsReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 4, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprAnrPacketsReceived.setDescription("The count of packets received with this ANR label as their\nfirst label.\n\nA Management Station can detect discontinuities in this\ncounter by monitoring the hprAnrCounterDisconTime object in\nthe same row.")
hprAnrCounterDisconTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 4, 1, 6), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprAnrCounterDisconTime.setDescription("The value of the sysUpTime object when the\nhprAnrPacketsReceived counter for this ANR label last\nexperienced a discontinuity.  This will be the more recent of\ntwo times:  the time at which the ANR label was associated with\neither an outgoing TG or a local NCE, or the time at which the\nANR counters were last turned on or off.")
hprTransportUser = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 6, 1, 3))
hprNceTable = MibTable((1, 3, 6, 1, 2, 1, 34, 6, 1, 3, 1))
if mibBuilder.loadTexts: hprNceTable.setDescription("The Network Connection Endpoint (NCE) table.")
hprNceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 6, 1, 3, 1, 1)).setIndexNames((0, "HPR-MIB", "hprNceId"))
if mibBuilder.loadTexts: hprNceEntry.setDescription("The NCE ID is used to index this table.")
hprNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 3, 1, 1, 1), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 8))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: hprNceId.setDescription("The Network Connection Endpoint (NCE) ID.  NCEs identify\nControl Points (Cp), Logical Units (Lu), HPR Boundary\nFunctions (Bf) and Route Setup (Rs) Functions.  A value for\nthis object can be retrieved from any of the following\nobjects in the APPN MIB:\n\n     - appnLsCpCpNceId\n     - appnLsRouteNceId\n     - appnLsBfNceId\n     - appnIsInRtpNceId\n     - appnIsRtpNceId\n\nIn each case this value identifies a row in this table\ncontaining information related to that in the APPN MIB.")
hprNceType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 3, 1, 1, 2), HprNceTypes()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprNceType.setDescription("A bit string identifying the function types provided by this\nNetwork Connection Endpoint (NCE).")
hprNceDefault = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 3, 1, 1, 3), HprNceTypes()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprNceDefault.setDescription("A bit string identifying the function types for which this\nNetwork Connection Endpoint (NCE) is the default NCE.  While\ndefault NCEs are not explicitly defined in the architecture,\nsome implementations provide them; for such implementations,\nit is useful to make this information available to a\nManagement Station.")
hprNceInstanceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 3, 1, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4, 4)).setFixedLength(4)).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprNceInstanceId.setDescription("The NCE instance identifier (NCEII) identifying the current\ninstance of this NCE.  An NCEII is used to denote different\ninstances (IPLs) of an NCE component.  Each time an NCE is\nactivated (IPL'd), it acquires a different, unique NCEII.")
hprRtp = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 6, 1, 4))
hprRtpGlobe = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 1))
hprRtpGlobeConnSetups = MibScalar((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 1, 1), Counter32()).setMaxAccess("readonly").setUnits("RTP connection setups")
if mibBuilder.loadTexts: hprRtpGlobeConnSetups.setDescription("The count of RTP connection setups in which this node has\nparticipated, as either sender or receiver, since it was last\nre-initialized.  Retries of a setup attempt do not cause the\ncounter to be incremented.\n\nA Management Station can detect discontinuities in this\ncounter by monitoring the appnNodeCounterDisconTime object\nin the APPN MIB.")
hprRtpGlobeCtrState = MibScalar((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("notActive", 1), ("active", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hprRtpGlobeCtrState.setDescription("This object allows a network management station to turn the\ncounters in the hprRtpTable on and off.  The initial value of\nthis object is an implementation choice.\n\n       notActive(1) - the counters in the hprRtpTable are\n                      returning no meaningful values\n       active(2)    - the counters in the hprRtpTable are\n                      being incremented and are returning\n                      meaningful values")
hprRtpGlobeCtrStateTime = MibScalar((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 1, 3), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpGlobeCtrStateTime.setDescription("The time when the value of the hprRtpGlobeCtrState object\nlast changed.  The initial value returned by this object is\nthe time at which the APPN node instrumented with this MIB\nwas last brought up.")
hprRtpTable = MibTable((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2))
if mibBuilder.loadTexts: hprRtpTable.setDescription("The RTP Connection table")
hprRtpEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1)).setIndexNames((0, "HPR-MIB", "hprRtpLocNceId"), (0, "HPR-MIB", "hprRtpLocTcid"))
if mibBuilder.loadTexts: hprRtpEntry.setDescription("The local NCE ID and local TCID are used to index this\ntable.")
hprRtpLocNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 1), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 8))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: hprRtpLocNceId.setDescription("The local Network Connection Endpoint (NCE) ID of this RTP\nconnection.  NCEs identify CPs, LUs, Boundary Functions (BFs),\nand Route Setup (RS) components.  A value for this object can\nbe retrieved from any of the following objects in the APPN\nMIB:\n\n     - appnLsCpCpNceId\n     - appnLsRouteNceId\n     - appnLsBfNceId\n     - appnIsInRtpNceId\n     - appnIsRtpNceId\n\nIn each case this value identifies a row in this table\ncontaining information related to that in the APPN MIB.")
hprRtpLocTcid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 2), OctetString().subtype(subtypeSpec=ValueSizeConstraint(8, 8)).setFixedLength(8)).setMaxAccess("noaccess")
if mibBuilder.loadTexts: hprRtpLocTcid.setDescription("The local TCID of this RTP connection.  A value for this\nobject can be retrieved from either the appnIsInRtpTcid object\nor the appnIsRtpTcid object the APPN MIB; in each case this\nvalue identifies a row in this table containing information\nrelated to that in the APPN MIB.")
hprRtpRemCpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 3), SnaControlPointName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpRemCpName.setDescription("Administratively assigned network name for the remote node of\nthis RTP connection.")
hprRtpRemNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpRemNceId.setDescription("The remote Network Connection Endpoint (NCE) of this RTP\nconnection.  NCEs identify CPs, LUs, Boundary Functions (BFs),\nand Route Setup (RS) components.")
hprRtpRemTcid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 5), OctetString().subtype(subtypeSpec=ValueSizeConstraint(8, 8)).setFixedLength(8)).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpRemTcid.setDescription("The remote TCID of this RTP connection.")
hprRtpPathSwitchTrigger = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("ready", 1), ("switchPathNow", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hprRtpPathSwitchTrigger.setDescription("Object by which a Management Station can trigger an operator-\nrequested path switch, by setting the value to\nswitchPathNow(2).  Setting this object to switchPathNow(2)\ntriggers a path switch even if its previous value was already\nswitchPathNow(2).\nThe value ready(1) is returned on GET operations until a SET\nhas been processed; after that the value received on the most\nrecent SET is returned.\n\nThis MIB module provides no support for an operator-requested\nswitch to a specified path.")
hprRtpRscv = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 7), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpRscv.setDescription("The forward Route Selection Control Vector for this RTP\nconnection.  The format of this vector is described in SNA\nFormats.\n\nThe value returned in this object during a path switch is\nimplementation-dependent:  it may be the old path, the new\npath, a zero-length string, or some other valid RSCV string.")
hprRtpTopic = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 8), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(8, 8)).setFixedLength(8)).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpTopic.setDescription("The topic for this RTP connection.  This is used to indicate\nthe Class of Service.")
hprRtpState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 9), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,4,99,2,5,)).subtype(namedValues=NamedValues(("rtpListening", 1), ("rtpCalling", 2), ("rtpConnected", 3), ("rtpPathSwitching", 4), ("rtpDisconnecting", 5), ("other", 99), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpState.setDescription("The state of the RTP connection, from the perspective of the\nlocal RTP protocol machine:\n    rtpListening      - connection open; waiting for other end\n                        to call in\n    rtpCalling        - connection opened, attempting to call\n                        out, have not yet received any data\n                        from other end\n    rtpConnected      - connection is active; responded to a\n                        call-in or received other end's TCID\n                        from a call-out attempt\n    rtpPathSwitching  - the path switch timer is running;\n                        attempting to find a new path for this\n                        connection.\n    rtpDisconnecting  - no sessions are using this connection;\n                        in process of bringing it down\n    other             - the connection is not in any of the\n                        states listed above.")
hprRtpUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 10), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpUpTime.setDescription("The length of time the RTP connection has been up, measured\nin 1/100ths of a second.")
hprRtpLivenessTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 11), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpLivenessTimer.setDescription("The value of the liveness (ALIVE) timer of this RTP\nconnection, in units of 1/100th of a second.  When this timer\nexpires and no packet has arrived from the partner since it\nwas last set, packets with Status Request indicators will be\nsent to see if the RTP connection is still alive.")
hprRtpShortReqTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 12), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpShortReqTimer.setDescription("The value of the RTP SHORT_REQ timer, in units of 1/100 of a\nsecond.  This timer represents the maximum time that a sender\nwaits for a reply from a receiver.")
hprRtpPathSwTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 13), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpPathSwTimer.setDescription("The length of time that RTP should attempt a path switch\nfor a connection, in units of 1/100th of a second.")
hprRtpLivenessTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 14), HprRtpCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpLivenessTimeouts.setDescription("The count of liveness timeouts for this RTP connection.")
hprRtpShortReqTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 15), HprRtpCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpShortReqTimeouts.setDescription("The count of short request timeouts for this RTP connection.")
hprRtpMaxSendRate = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 16), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpMaxSendRate.setDescription("The high-water mark for this RTP connection's send rate, in\nunits of bytes per second.  This is the high-water mark for\nthe entire life of the connection, not just the high-water\nmark for the connection's current path.\nFor more details on this and other parameters related to HPR,\nsee the High Performance Routing Architecture Reference.")
hprRtpMinSendRate = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 17), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpMinSendRate.setDescription("The low-water mark for this RTP connection's send rate, in\nunits of bytes per second.  This is the low-water mark for the\nentire life of the connection, not just the low-water mark for\nthe connection's current path.\n\nFor more details on this and other parameters related to HPR,\nsee the High Performance Routing Architecture Reference.")
hprRtpCurSendRate = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 18), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpCurSendRate.setDescription("The current send rate for this RTP connection, in units of\nbytes per second.\n\nFor more details on this and other parameters related to HPR,\nsee the High Performance Routing Architecture Reference.")
hprRtpSmRdTripDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 19), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpSmRdTripDelay.setDescription("The smoothed round trip delay for this RTP connection, in\nunits of 1/1000th of a second (ms).\n\nFor more details on this and other parameters related to HPR,\nsee the High Performance Routing Architecture Reference.")
hprRtpSendPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 20), HprRtpCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpSendPackets.setDescription("The count of packets successfully sent on this RTP\nconnection.")
hprRtpRecvPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 21), HprRtpCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpRecvPackets.setDescription("The count of packets received on this RTP connection.  The\ncounter is incremented only once if duplicate copies of a\npacket are received.")
hprRtpSendBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 22), HprRtpCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpSendBytes.setDescription("The count of bytes sent on this RTP connection.  Both RTP\nTransport Header (THDR) bytes and data bytes are included in\nthis count.")
hprRtpRecvBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 23), HprRtpCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpRecvBytes.setDescription("The count of bytes received on this RTP connection.  Both RTP\nTransport Header (THDR) bytes and data bytes are included in\nthis count.")
hprRtpRetrPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 24), HprRtpCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpRetrPackets.setDescription("The count of packets retransmitted on this RTP connection.")
hprRtpPacketsDiscarded = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 25), HprRtpCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpPacketsDiscarded.setDescription("The count of packets received on this RTP connection and then\ndiscarded.  A packet may be discarded because it is determined\nto be a duplicate, or for other reasons.")
hprRtpDetectGaps = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 26), HprRtpCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpDetectGaps.setDescription("The count of gaps detected on this RTP connection.")
hprRtpRateReqSends = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 27), HprRtpCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpRateReqSends.setDescription("The count of Rate Requests sent on this RTP connection.")
hprRtpOkErrPathSws = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 28), HprRtpCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpOkErrPathSws.setDescription("The count of successful path switch attempts for this RTP\nconnection due to errors.")
hprRtpBadErrPathSws = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 29), HprRtpCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpBadErrPathSws.setDescription("The count of unsuccessful path switches for this RTP\nconnection due to errors.")
hprRtpOkOpPathSws = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 30), HprRtpCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpOkOpPathSws.setDescription("The count of successful path switches for this RTP connection\ndue to operator requests.")
hprRtpBadOpPathSws = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 31), HprRtpCounter()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpBadOpPathSws.setDescription("The count of unsuccessful path switches for this RTP\nconnection due to operator requests.  This counter is not\nincremented by an implementation that does not support\noperator-requested path switches, even if a Management Station\nrequests such a path switch by setting the\nhprRtpPathSwitchTrigger object.")
hprRtpCounterDisconTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 32), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpCounterDisconTime.setDescription("The value of the sysUpTime object when the counters for this\nRTP connection last experienced a discontinuity.  This will be\nthe more recent of two times:  the time at which the\nconnection was established or the time at which the HPR\ncounters were last turned on or off.")
hprRtpStatusTable = MibTable((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3))
if mibBuilder.loadTexts: hprRtpStatusTable.setDescription("RTP Connection Status Table:  This table contains historical\ninformation on RTP connections.  An entry is created in this\ntable when a path switch is completed, either successfully or\nunsuccessfully.")
hprRtpStatusEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1)).setIndexNames((0, "HPR-MIB", "hprRtpStatusLocNceId"), (0, "HPR-MIB", "hprRtpStatusLocTcid"), (0, "HPR-MIB", "hprRtpStatusIndex"))
if mibBuilder.loadTexts: hprRtpStatusEntry.setDescription("This table is indexed by local NCE ID, local TCID, and an\ninteger hprRtpStatusIndex.  Thus the primary grouping of table\nrows is by RTP connection, with the multiple entries for a\ngiven RTP connection ordered by time.")
hprRtpStatusLocNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 1), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 8))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: hprRtpStatusLocNceId.setDescription("The local Network Connection Endpoint (NCE) of this RTP\nconnection.  NCEs identify CPs, LUs, Boundary Functions (BFs),\nand Route Setup (RS) components.")
hprRtpStatusLocTcid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 2), OctetString().subtype(subtypeSpec=ValueSizeConstraint(8, 8)).setFixedLength(8)).setMaxAccess("noaccess")
if mibBuilder.loadTexts: hprRtpStatusLocTcid.setDescription("The local TCID of this RTP connection.")
hprRtpStatusIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: hprRtpStatusIndex.setDescription("Table index.  This value begins at one and is incremented\nwhen a new entry is added to the table.  It is an\nimplementation choice whether to run a single counter for\nall entries in the table, or to run a separate counter for\nthe entries for each RTP connection.  In the unlikely event\nof a wrap, it is assumed that Management Stations will have\nthe ability to order table entries correctly.")
hprRtpStatusStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpStatusStartTime.setDescription("The time when the path switch began.")
hprRtpStatusEndTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 5), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpStatusEndTime.setDescription("The time when the path switch was ended, either successfully\nor unsuccessfully.")
hprRtpStatusRemCpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 6), SnaControlPointName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpStatusRemCpName.setDescription("Administratively assigned network name for the remote node of\nthis RTP connection.")
hprRtpStatusRemNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 7), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpStatusRemNceId.setDescription("The remote Network Connection Endpoint (NCE) of this RTP\nconnection.  NCEs identify CPs, LUs, Boundary Functions (BFs),\nand Route Setup (RS) components.")
hprRtpStatusRemTcid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 8), OctetString().subtype(subtypeSpec=ValueSizeConstraint(8, 8)).setFixedLength(8)).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpStatusRemTcid.setDescription("The remote TCID of this RTP connection.")
hprRtpStatusNewRscv = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpStatusNewRscv.setDescription("The new Route Selection Control Vector for this RTP\nconnection.  A zero-length string indicates that no value is\navailable, perhaps because the implementation does not save\nRSCVs.")
hprRtpStatusOldRscv = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 10), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpStatusOldRscv.setDescription("The old Route Selection Control Vector for this RTP\nconnection.  A zero-length string indicates that no value is\navailable, perhaps because the implementation does not save\nRSCVs.")
hprRtpStatusCause = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 11), Integer().subtype(subtypeSpec=SingleValueConstraint(2,5,3,1,4,)).subtype(namedValues=NamedValues(("other", 1), ("rtpConnFail", 2), ("locLinkFail", 3), ("remLinkFail", 4), ("operRequest", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpStatusCause.setDescription("The reason for the path switch:\n\nother(1)       - Reason other than those listed below,\nrtpConnFail(2) - RTP connection failure detected,\nlocLinkFail(3) - Local link failure,\nremLinkFail(4) - Remote link failure (learned from TDUs),\noperRequest(5) - Operator requested path switch. ")
hprRtpStatusLastAttemptResult = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 12), Integer().subtype(subtypeSpec=SingleValueConstraint(4,8,2,1,7,3,5,6,)).subtype(namedValues=NamedValues(("successful", 1), ("initiatorMoving", 2), ("directorySearchFailed", 3), ("rscvCalculationFailed", 4), ("negativeRouteSetupReply", 5), ("backoutRouteSetupReply", 6), ("timeoutDuringFirstAttempt", 7), ("otherUnsuccessful", 8), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpStatusLastAttemptResult.setDescription("The result of the last completed path switch attempt.  If the\npath switch is aborted in the middle of a path switch attempt\nbecause the path switch timer expires, the result of the\nprevious path switch attempt is reported.\n\nThe values are defined as follows:\n\n   successful(1)                - The final path switch\n                                  attempt was successful.\n   initiatorMoving(2)           - The final path switch\n                                  attempt failed because the\n                                  initiator is mobile, and\n                                  there was no active link\n                                  out of this node.\n   directorySearchFailed(3)     - The final path switch\n                                  attempt failed because a\n                                  directory search for the\n                                  destination node's CP name\n                                  failed.\n   rscvCalculationFailed(4)     - The final path switch\n                                  attempt failed because an\n                                  RSCV to the node containing\n                                  the remote RTP endpoint\n                                  could not be calculated.\n   negativeRouteSetupReply(5)   - The final path switch\n                                  attempt failed because route\n                                  setup failed for the new\n                                  path.\n   backoutRouteSetupReply(6)    - The final path switch\n                                  attempt failed because the\n                                  remote RTP endpoint refused\n                                  to continue the RTP\n                                  connection.\n   timeoutDuringFirstAttempt(7) - The path switch timer\n                                  expired during the first\n                                  path switch attempt.\n   otherUnsuccessful(8)         - The final path switch\n                                  attempt failed for a reason\n                                  other than those listed\n                                  above.")
hprConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 6, 2))
hprCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 6, 2, 1))
hprGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 6, 2, 2))

# Augmentions

# Groups

hprGlobalConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 6, 2, 2, 1)).setObjects(*(("HPR-MIB", "hprOperatorPathSwitchSupport"), ("HPR-MIB", "hprNodeCpName"), ) )
if mibBuilder.loadTexts: hprGlobalConfGroup.setDescription("A collection of objects providing the instrumentation of HPR\ngeneral information and capabilities.")
hprAnrRoutingConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 6, 2, 2, 2)).setObjects(*(("HPR-MIB", "hprAnrCounterState"), ("HPR-MIB", "hprAnrsAssigned"), ("HPR-MIB", "hprAnrType"), ("HPR-MIB", "hprAnrCounterDisconTime"), ("HPR-MIB", "hprAnrOutTgNum"), ("HPR-MIB", "hprAnrOutTgDest"), ("HPR-MIB", "hprAnrPacketsReceived"), ("HPR-MIB", "hprAnrCounterStateTime"), ) )
if mibBuilder.loadTexts: hprAnrRoutingConfGroup.setDescription("A collection of objects providing instrumentation for the\nnode's ANR routing.")
hprTransportUserConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 6, 2, 2, 3)).setObjects(*(("HPR-MIB", "hprNceInstanceId"), ("HPR-MIB", "hprNceDefault"), ("HPR-MIB", "hprNceType"), ) )
if mibBuilder.loadTexts: hprTransportUserConfGroup.setDescription("A collection of objects providing information on the users of\nthe HPR transport known to the node.")
hprRtpConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 6, 2, 2, 4)).setObjects(*(("HPR-MIB", "hprRtpStatusRemTcid"), ("HPR-MIB", "hprRtpStatusEndTime"), ("HPR-MIB", "hprRtpLivenessTimer"), ("HPR-MIB", "hprRtpUpTime"), ("HPR-MIB", "hprRtpRateReqSends"), ("HPR-MIB", "hprRtpSmRdTripDelay"), ("HPR-MIB", "hprRtpStatusStartTime"), ("HPR-MIB", "hprRtpStatusNewRscv"), ("HPR-MIB", "hprRtpRecvBytes"), ("HPR-MIB", "hprRtpStatusOldRscv"), ("HPR-MIB", "hprRtpRecvPackets"), ("HPR-MIB", "hprRtpGlobeCtrStateTime"), ("HPR-MIB", "hprRtpCounterDisconTime"), ("HPR-MIB", "hprRtpStatusLastAttemptResult"), ("HPR-MIB", "hprRtpCurSendRate"), ("HPR-MIB", "hprRtpRscv"), ("HPR-MIB", "hprRtpRetrPackets"), ("HPR-MIB", "hprRtpShortReqTimer"), ("HPR-MIB", "hprRtpStatusCause"), ("HPR-MIB", "hprRtpGlobeConnSetups"), ("HPR-MIB", "hprRtpRemTcid"), ("HPR-MIB", "hprRtpRemCpName"), ("HPR-MIB", "hprRtpPathSwitchTrigger"), ("HPR-MIB", "hprRtpMinSendRate"), ("HPR-MIB", "hprRtpShortReqTimeouts"), ("HPR-MIB", "hprRtpState"), ("HPR-MIB", "hprRtpOkOpPathSws"), ("HPR-MIB", "hprRtpPathSwTimer"), ("HPR-MIB", "hprRtpBadOpPathSws"), ("HPR-MIB", "hprRtpDetectGaps"), ("HPR-MIB", "hprRtpStatusRemNceId"), ("HPR-MIB", "hprRtpLivenessTimeouts"), ("HPR-MIB", "hprRtpPacketsDiscarded"), ("HPR-MIB", "hprRtpMaxSendRate"), ("HPR-MIB", "hprRtpSendPackets"), ("HPR-MIB", "hprRtpTopic"), ("HPR-MIB", "hprRtpBadErrPathSws"), ("HPR-MIB", "hprRtpOkErrPathSws"), ("HPR-MIB", "hprRtpSendBytes"), ("HPR-MIB", "hprRtpStatusRemCpName"), ("HPR-MIB", "hprRtpGlobeCtrState"), ("HPR-MIB", "hprRtpRemNceId"), ) )
if mibBuilder.loadTexts: hprRtpConfGroup.setDescription("A collection of objects providing the instrumentation for RTP\nconnection end points.")

# Compliances

hprCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 34, 6, 2, 1, 1)).setObjects(*(("HPR-MIB", "hprRtpConfGroup"), ("HPR-MIB", "hprAnrRoutingConfGroup"), ("HPR-MIB", "hprTransportUserConfGroup"), ("HPR-MIB", "hprGlobalConfGroup"), ) )
if mibBuilder.loadTexts: hprCompliance.setDescription("The compliance statement for the SNMPv2 entities that\nimplement the HPR MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("HPR-MIB", PYSNMP_MODULE_ID=hprMIB)

# Types
mibBuilder.exportSymbols("HPR-MIB", HprNceTypes=HprNceTypes, HprRtpCounter=HprRtpCounter)

# Objects
mibBuilder.exportSymbols("HPR-MIB", hprMIB=hprMIB, hprObjects=hprObjects, hprGlobal=hprGlobal, hprNodeCpName=hprNodeCpName, hprOperatorPathSwitchSupport=hprOperatorPathSwitchSupport, hprAnrRouting=hprAnrRouting, hprAnrsAssigned=hprAnrsAssigned, hprAnrCounterState=hprAnrCounterState, hprAnrCounterStateTime=hprAnrCounterStateTime, hprAnrRoutingTable=hprAnrRoutingTable, hprAnrRoutingEntry=hprAnrRoutingEntry, hprAnrLabel=hprAnrLabel, hprAnrType=hprAnrType, hprAnrOutTgDest=hprAnrOutTgDest, hprAnrOutTgNum=hprAnrOutTgNum, hprAnrPacketsReceived=hprAnrPacketsReceived, hprAnrCounterDisconTime=hprAnrCounterDisconTime, hprTransportUser=hprTransportUser, hprNceTable=hprNceTable, hprNceEntry=hprNceEntry, hprNceId=hprNceId, hprNceType=hprNceType, hprNceDefault=hprNceDefault, hprNceInstanceId=hprNceInstanceId, hprRtp=hprRtp, hprRtpGlobe=hprRtpGlobe, hprRtpGlobeConnSetups=hprRtpGlobeConnSetups, hprRtpGlobeCtrState=hprRtpGlobeCtrState, hprRtpGlobeCtrStateTime=hprRtpGlobeCtrStateTime, hprRtpTable=hprRtpTable, hprRtpEntry=hprRtpEntry, hprRtpLocNceId=hprRtpLocNceId, hprRtpLocTcid=hprRtpLocTcid, hprRtpRemCpName=hprRtpRemCpName, hprRtpRemNceId=hprRtpRemNceId, hprRtpRemTcid=hprRtpRemTcid, hprRtpPathSwitchTrigger=hprRtpPathSwitchTrigger, hprRtpRscv=hprRtpRscv, hprRtpTopic=hprRtpTopic, hprRtpState=hprRtpState, hprRtpUpTime=hprRtpUpTime, hprRtpLivenessTimer=hprRtpLivenessTimer, hprRtpShortReqTimer=hprRtpShortReqTimer, hprRtpPathSwTimer=hprRtpPathSwTimer, hprRtpLivenessTimeouts=hprRtpLivenessTimeouts, hprRtpShortReqTimeouts=hprRtpShortReqTimeouts, hprRtpMaxSendRate=hprRtpMaxSendRate, hprRtpMinSendRate=hprRtpMinSendRate, hprRtpCurSendRate=hprRtpCurSendRate, hprRtpSmRdTripDelay=hprRtpSmRdTripDelay, hprRtpSendPackets=hprRtpSendPackets, hprRtpRecvPackets=hprRtpRecvPackets, hprRtpSendBytes=hprRtpSendBytes, hprRtpRecvBytes=hprRtpRecvBytes, hprRtpRetrPackets=hprRtpRetrPackets, hprRtpPacketsDiscarded=hprRtpPacketsDiscarded, hprRtpDetectGaps=hprRtpDetectGaps, hprRtpRateReqSends=hprRtpRateReqSends, hprRtpOkErrPathSws=hprRtpOkErrPathSws, hprRtpBadErrPathSws=hprRtpBadErrPathSws, hprRtpOkOpPathSws=hprRtpOkOpPathSws, hprRtpBadOpPathSws=hprRtpBadOpPathSws, hprRtpCounterDisconTime=hprRtpCounterDisconTime, hprRtpStatusTable=hprRtpStatusTable, hprRtpStatusEntry=hprRtpStatusEntry, hprRtpStatusLocNceId=hprRtpStatusLocNceId, hprRtpStatusLocTcid=hprRtpStatusLocTcid, hprRtpStatusIndex=hprRtpStatusIndex, hprRtpStatusStartTime=hprRtpStatusStartTime, hprRtpStatusEndTime=hprRtpStatusEndTime, hprRtpStatusRemCpName=hprRtpStatusRemCpName, hprRtpStatusRemNceId=hprRtpStatusRemNceId, hprRtpStatusRemTcid=hprRtpStatusRemTcid, hprRtpStatusNewRscv=hprRtpStatusNewRscv, hprRtpStatusOldRscv=hprRtpStatusOldRscv, hprRtpStatusCause=hprRtpStatusCause, hprRtpStatusLastAttemptResult=hprRtpStatusLastAttemptResult, hprConformance=hprConformance, hprCompliances=hprCompliances, hprGroups=hprGroups)

# Groups
mibBuilder.exportSymbols("HPR-MIB", hprGlobalConfGroup=hprGlobalConfGroup, hprAnrRoutingConfGroup=hprAnrRoutingConfGroup, hprTransportUserConfGroup=hprTransportUserConfGroup, hprRtpConfGroup=hprRtpConfGroup)

# Compliances
mibBuilder.exportSymbols("HPR-MIB", hprCompliance=hprCompliance)
