//
// C++ Interface: qcsound
//
// Description: 
//
//
// Author: Krippel Harald <harald@the-develop.net>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef QCSOUND_H
#define QCSOUND_H

/**
Basisclass for sound implementation

	@author Krippel Harald <harald@the-develop.net>
*/

#include <QObject>
#include <plib/ssg.h>

class qcSound: public QObject
{
Q_OBJECT
public:
    qcSound(QObject *parent=0);
    virtual int  Play();
    virtual int  Stop();
    virtual void  Update(void);
    virtual void  setPosition (float x, float y, float z);
    virtual void  Loop(int flag);
    virtual void  setFullScreen(bool flag);
    virtual void  adjustVolume(float gain);
    virtual void   Relative(int flag);
    virtual int  loadFile(const QString &);
    ~qcSound();

public slots:
    void slot_update(const QString &);
    void slot_play(void);
    void slot_stop(void);

protected:
  int on;
  int enable;

public:
   ssgTransform *boxobjtrans;
};

#endif
