% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unitRoot.R
\name{ocsb.test}
\alias{ocsb.test}
\alias{print.OCSBtest}
\title{Osborn, Chui, Smith, and Birchenhall Test for Seasonal Unit Roots}
\usage{
ocsb.test(x, lag.method = c("fixed", "AIC", "BIC", "AICc"), maxlag = 0)
}
\arguments{
\item{x}{a univariate seasonal time series.}

\item{lag.method}{a character specifying the lag order selection method.}

\item{maxlag}{the maximum lag order to be considered by \code{lag.method}.}
}
\value{
ocsb.test returns a list of class "OCSBtest" with the following components:
* statistics the value of the test statistics.
* pvalues the p-values for each test statistics.
* method a character string describing the type of test.
* data.name a character string giving the name of the data.
* fitted.model	the fitted regression model.
}
\description{
An implementation of the Osborn, Chui, Smith, and Birchenhall (OCSB) test.
}
\details{
The regression equation may include lags of the dependent variable. When lag.method = "fixed", the lag order is fixed to maxlag; otherwise, maxlag is the maximum number of lags considered in a lag selection procedure that minimises the lag.method criterion, which can be AIC or BIC or corrected AIC, AICc, obtained as AIC + (2k(k+1))/(n-k-1), where k is the number of parameters and n is the number of available observations in the model.

Critical values for the test are based on simulations, which has been smoothed over to produce critical values for all seasonal periods.
}
\examples{
ocsb.test(AirPassengers)

}
\references{
Osborn DR, Chui APL, Smith J, and Birchenhall CR (1988) "Seasonality and the
order of integration for consumption", \emph{Oxford Bulletin of Economics
and Statistics} \bold{50}(4):361-377.
}
\seealso{
\code{\link{nsdiffs}}
}
