% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-density2d.r, R/stat-density-2d.r
\name{geom_density_2d}
\alias{geom_density2d}
\alias{geom_density_2d}
\alias{stat_density2d}
\alias{stat_density_2d}
\title{Contours from a 2d density estimate.}
\usage{
geom_density_2d(mapping = NULL, data = NULL, stat = "density2d",
  position = "identity", lineend = "butt", linejoin = "round",
  linemitre = 1, na.rm = FALSE, show.legend = NA, inherit.aes = TRUE,
  ...)

stat_density_2d(mapping = NULL, data = NULL, geom = "density_2d",
  position = "identity", contour = TRUE, n = 100, h = NULL,
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{lineend}{Line end style (round, butt, square)}

\item{linejoin}{Line join style (round, mitre, bevel)}

\item{linemitre}{Line mitre limit (number greater than 1)}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{...}{other arguments passed on to \code{\link{layer}}. There are
  three types of arguments you can use here:

  \itemize{
  \item Aesthetics: to set an aesthetic to a fixed value, like
     \code{color = "red"} or \code{size = 3}.
  \item Other arguments to the layer, for example you override the
    default \code{stat} associated with the layer.
  \item Other arguments passed on to the stat.
  }}

\item{geom, stat}{Use to override the default connection between
\code{geom_density_2d} and \code{stat_density_2d}.}

\item{contour}{If \code{TRUE}, contour the results of the 2d density
estimation}

\item{n}{number of grid points in each direction}

\item{h}{Bandwidth (vector of length two). If \code{NULL}, estimated
using \code{\link[MASS]{bandwidth.nrd}}.}
}
\description{
Perform a 2D kernel density estimation using kde2d and display the
results with contours. This can be useful for dealing with overplotting.
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggplot2:::rd_aesthetics("geom", "density_2d")}
}

\section{Computed variables}{

Same as \code{\link{stat_contour}}
}
\examples{
m <- ggplot(faithful, aes(x = eruptions, y = waiting)) +
 geom_point() +
 xlim(0.5, 6) +
 ylim(40, 110)
m + geom_density_2d()
\donttest{
m + stat_density_2d(aes(fill = ..level..), geom = "polygon")

set.seed(4393)
dsmall <- diamonds[sample(nrow(diamonds), 1000), ]
d <- ggplot(dsmall, aes(x, y))
# If you map an aesthetic to a categorical variable, you will get a
# set of contours for each value of that variable
d + geom_density_2d(aes(colour = cut))

# If we turn contouring off, we can use use geoms like tiles:
d + stat_density_2d(geom = "raster", aes(fill = ..density..), contour = FALSE)
# Or points:
d + stat_density_2d(geom = "point", aes(size = ..density..), n = 20, contour = FALSE)
}
}
\seealso{
\code{\link{geom_contour}} for contour drawing geom,
 \code{\link{stat_sum}} for another way of dealing with overplotting
}

