% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-summary.r
\name{hmisc}
\alias{hmisc}
\alias{mean_cl_boot}
\alias{mean_cl_normal}
\alias{mean_sdl}
\alias{median_hilow}
\title{A selection of summary functions from Hmisc}
\usage{
mean_cl_boot(x, ...)

mean_cl_normal(x, ...)

mean_sdl(x, ...)

median_hilow(x, ...)
}
\arguments{
\item{x}{a numeric vector}

\item{...}{other arguments passed on to the respective Hmisc function.}
}
\value{
A data frame with columns \code{y}, \code{ymin}, and \code{ymax}.
}
\description{
These are wrappers around functions from \pkg{Hmisc} designed to make them
easier to use with \code{\link[=stat_summary]{stat_summary()}}. See the Hmisc documentation
for more details:
\itemize{
\item \code{\link[Hmisc:smean.cl.boot]{Hmisc::smean.cl.boot()}}
\item \code{\link[Hmisc:smean.cl.normal]{Hmisc::smean.cl.normal()}}
\item \code{\link[Hmisc:smean.sdl]{Hmisc::smean.sdl()}}
\item \code{\link[Hmisc:smedian.hilow]{Hmisc::smedian.hilow()}}
}
}
\examples{
x <- rnorm(100)
mean_cl_boot(x)
mean_cl_normal(x)
mean_sdl(x)
median_hilow(x)
}
