% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extension-vctrs.R
\name{na_vctrs}
\alias{na_vctrs}
\title{Vctrs extension type}
\usage{
na_vctrs(ptype, storage_type = NULL)
}
\arguments{
\item{ptype}{A vctrs prototype as returned by \code{\link[vctrs:vec_ptype]{vctrs::vec_ptype()}}.
The prototype can be of arbitrary size, but a zero-size vector
is sufficient here.}

\item{storage_type}{For \code{\link[=na_extension]{na_extension()}}, the underlying value type.}
}
\value{
A \link[=as_nanoarrow_schema]{nanoarrow_schema}.
}
\description{
The Arrow format provides a rich type system that can handle most R
vector types; however, many R vector types do not roundtrip perfectly
through Arrow memory. The vctrs extension type uses \code{\link[vctrs:vec_data]{vctrs::vec_data()}},
\code{\link[vctrs:vec_proxy]{vctrs::vec_restore()}}, and \code{\link[vctrs:vec_ptype]{vctrs::vec_ptype()}} in calls to
\code{\link[=as_nanoarrow_array]{as_nanoarrow_array()}} and \code{\link[=convert_array]{convert_array()}} to ensure roundtrip fidelity.
}
\examples{
\dontshow{if (requireNamespace("jsonlite", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
vctr <- as.POSIXlt("2000-01-02 03:45", tz = "UTC")
array <- as_nanoarrow_array(vctr, schema = na_vctrs(vctr))
infer_nanoarrow_ptype(array)
convert_array(array)
\dontshow{\}) # examplesIf}
}
