% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_data.R
\name{plotly_data}
\alias{plotly_data}
\alias{groups.plotly}
\alias{ungroup.plotly}
\alias{group_by_.plotly}
\alias{summarise_.plotly}
\alias{mutate_.plotly}
\alias{do_.plotly}
\alias{arrange_.plotly}
\alias{select_.plotly}
\alias{filter_.plotly}
\alias{distinct_.plotly}
\alias{slice_.plotly}
\alias{rename_.plotly}
\alias{transmute_.plotly}
\title{Obtain data associated with a plotly graph}
\usage{
plotly_data(p, id = p$x$cur_data)

\method{groups}{plotly}(x)

\method{ungroup}{plotly}(x, ...)

\method{group_by_}{plotly}(.data, ..., .dots, add = FALSE)

\method{summarise_}{plotly}(.data, ..., .dots)

\method{mutate_}{plotly}(.data, ..., .dots)

\method{do_}{plotly}(.data, ..., .dots)

\method{arrange_}{plotly}(.data, ..., .dots)

\method{select_}{plotly}(.data, ..., .dots)

\method{filter_}{plotly}(.data, ..., .dots)

\method{distinct_}{plotly}(.data, ..., .dots)

\method{slice_}{plotly}(.data, ..., .dots)

\method{rename_}{plotly}(.data, ..., .dots)

\method{transmute_}{plotly}(.data, ..., .dots)
}
\arguments{
\item{p}{a plotly visualization}

\item{id}{a character string or number referencing an "attribute layer".}

\item{x}{a plotly visualization}

\item{...}{stuff passed onto the relevant method}

\item{.data}{a plotly visualization}

\item{.dots}{Used to work around non-standard evaluation. See vignette("nse") for details}

\item{add}{By default, when add = FALSE, group_by will override existing groups.
To instead add to the existing groups, use add = TRUE}
}
\description{
\code{plotly_data()} returns data associated with
a plotly visualization (if there are multiple data frames, by default,
it returns the most recent one).
}
\examples{

# use group_by() to define groups of visual markings
p <- txhousing \%>\%
  group_by(city) \%>\%
  plot_ly(x = ~date, y = ~sales)
p

# plotly objects preserve data groupings 
groups(p)
plotly_data(p)

# dplyr verbs operate on plotly objects as if they were data frames
p <- economics \%>\%
  plot_ly(x = ~date, y = ~unemploy / pop) \%>\%
  add_lines() \%>\%
  mutate(rate = unemploy / pop) \%>\% 
  filter(rate == max(rate))
plotly_data(p)
add_markers(p)
layout(p, annotations = list(x = ~date, y = ~rate, text = "peak"))

# use group_by() + do() + subplot() for trellis displays 
d <- group_by(mpg, drv)
plots <- do(d, p = plot_ly(., x = ~cty, name = ~drv))
subplot(plots[["p"]], nrows = 3, shareX = TRUE)

# arrange displays by their mean
means <- summarise(d, mn = mean(cty, na.rm = TRUE))
means \%>\%
  dplyr::left_join(plots) \%>\%
  arrange(mn) \%>\%
  subplot(nrows = NROW(.), shareX = TRUE)
  
# more dplyr verbs applied to plotly objects
p <- mtcars \%>\%
  plot_ly(x = ~wt, y = ~mpg, name = "scatter trace") \%>\%
  add_markers()
p \%>\% slice(1) \%>\% plotly_data()
p \%>\% slice(1) \%>\% add_markers(name = "first observation")
p \%>\% filter(cyl == 4) \%>\% plotly_data()
p \%>\% filter(cyl == 4) \%>\% add_markers(name = "four cylinders")


}
