% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/python.R
\name{py_run}
\alias{py_run}
\alias{py_run_string}
\alias{py_run_file}
\title{Run Python code}
\usage{
py_run_string(code, local = FALSE, convert = TRUE)

py_run_file(file, local = FALSE, convert = TRUE, prepend_path = TRUE)
}
\arguments{
\item{code}{The Python code to be executed.}

\item{local}{Boolean; should Python objects be created as part of
a local / private dictionary? If \code{FALSE}, objects will be created within
the scope of the Python main module.}

\item{convert}{Boolean; should Python objects be automatically converted
to their \R equivalent? If set to \code{FALSE}, you can still manually convert
Python objects to \R via the \code{\link[=py_to_r]{py_to_r()}} function.}

\item{file}{The Python script to be executed.}

\item{prepend_path}{Boolean; should the script directory be added to the
Python module search path? The default, \code{TRUE}, matches the behavior of
\verb{python <path/to/script.py>} at the command line.}
}
\value{
A Python dictionary of objects. When \code{local} is \code{FALSE}, this
dictionary captures the state of the Python main module after running
the provided code. Otherwise, only the variables defined and used are
captured.
}
\description{
Execute code within the scope of the \code{__main__} Python module.
}
