% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.order.R
\name{list.order}
\alias{list.order}
\title{Give the order of each list element by expression}
\usage{
list.order(.data, ..., keep.names = FALSE, na.last = TRUE)
}
\arguments{
\item{.data}{A \code{list} or \code{vector}}

\item{...}{A group of lambda expressions}

\item{keep.names}{Whether to keep the names of \code{x} in the result}

\item{na.last}{The way to deal with \code{NA}s.}
}
\value{
an \code{integer} vector.
}
\description{
Give the order of each list element by expression
}
\examples{
x <- list(p1 = list(type='A',score=list(c1=10,c2=8)),
       p2 = list(type='B',score=list(c1=9,c2=9)),
       p3 = list(type='B',score=list(c1=9,c2=7)))
list.order(x, type, (score$c2)) # order by type (ascending) and score$c2 (descending)
list.order(x, min(score$c1,score$c2))
list.order(x, min(score$c1,score$c2), keep.names=TRUE)
}
\seealso{
\code{\link{list.sort}}
}
