% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_analysis_stage_results.R
\docType{class}
\name{StageResultsSurvival}
\alias{StageResultsSurvival}
\title{Stage Results of Survival Data}
\description{
Class for stage results survival data.
}
\details{
This object cannot be created directly; use \code{getStageResults}
with suitable arguments to create the stage results of a dataset of survival data.
}
\section{Fields}{

\describe{
\item{\code{stages}}{The stage numbers of the trial. Is a numeric vector of length \code{kMax} containing whole numbers.}

\item{\code{testStatistics}}{The stage-wise test statistics. Is a numeric vector of length \code{kMax}.}

\item{\code{overallTestStatistics}}{The overall, i.e., cumulated test statistics. Is a numeric vector of length \code{kMax}.}

\item{\code{separatePValues}}{The p-values from the separate stages. Is a numeric matrix.}

\item{\code{singleStepAdjustedPValues}}{The adjusted p-value for testing multiple hypotheses per stage of the trial.}

\item{\code{overallPValues}}{The overall, i.e., cumulated p-values. Is a numeric vector of length \code{kMax} containing values between 0 and 1.}

\item{\code{direction}}{Specifies the direction of the alternative, is either "upper" or "lower". Only applicable for one-sided testing.}

\item{\code{directionUpper}}{Specifies the direction of the alternative, only applicable for one-sided testing. Default is \code{TRUE} which means that larger values of the test statistics yield smaller p-values. Is a logical vector of length 1.}

\item{\code{intersectionTest}}{The multiple test used for intersection hypotheses in closed systems of hypotheses. Is a character vector of length 1.}

\item{\code{combInverseNormal}}{The test statistics over stages for the inverse normal test. Is a numeric vector of length \code{kMax}.}

\item{\code{combFisher}}{The test statistics over stages for Fisher's combination test. Is a numeric vector of length \code{kMax} containing values between 0 and 1.}

\item{\code{effectSizes}}{The stage-wise effect sizes. Is a numeric vector of length \code{kMax}.}

\item{\code{testActions}}{The test decisions at each stage of the trial. Is a character vector of length \code{kMax}.}

\item{\code{thetaH0}}{The difference or assumed effect under H0. Is a numeric vector of length 1.}

\item{\code{weightsFisher}}{The weights for Fisher's combination test. Is a numeric vector of length \code{kMax}.}

\item{\code{weightsInverseNormal}}{The weights for the inverse normal statistic. Is a numeric vector of length \code{kMax}.}

\item{\code{normalApproximation}}{Describes if a normal approximation was used when calculating p-values. Default for means is \code{FALSE} and \code{TRUE} for rates and hazard ratio. Is a logical vector of length 1.}

\item{\code{...}}{Names of \code{dataInput}.}
}}


\keyword{internal}
