% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova_stats.R, R/epsilon_sq.R, R/eta_sq.R,
%   R/omega_sq.R
\name{anova_stats}
\alias{anova_stats}
\alias{epsilon_sq}
\alias{eta_sq}
\alias{omega_sq}
\title{Effect size statistics for anova}
\usage{
anova_stats(model, digits = 3)

epsilon_sq(model, ci.lvl = NULL, n = 1000, method = c("dist", "quantile"))

eta_sq(
  model,
  partial = FALSE,
  ci.lvl = NULL,
  n = 1000,
  method = c("dist", "quantile")
)

omega_sq(
  model,
  partial = FALSE,
  ci.lvl = NULL,
  n = 1000,
  method = c("dist", "quantile")
)
}
\arguments{
\item{model}{A fitted anova-model of class \code{aov} or \code{anova}. Other
models are coerced to \code{\link[stats]{anova}}.}

\item{digits}{Number of decimal points in the returned data frame.}

\item{ci.lvl}{Scalar between 0 and 1. If not \code{NULL}, returns a data
frame with effect sizes including lower and upper confidence intervals.}

\item{n}{Number of bootstraps to be generated.}

\item{method}{Character vector, indicating if confidence intervals should be
based on bootstrap standard error, multiplied by the value of the
quantile function of the t-distribution (default), or on sample
quantiles of the bootstrapped values. See 'Details' in \code{boot_ci()}.
May be abbreviated.}

\item{partial}{Logical, if \code{TRUE}, the partial eta-squared is returned.}
}
\value{
A data frame with the term name(s) and effect size statistics; if
  \code{ci.lvl} is not \code{NULL}, a data frame including lower and
  upper confidence intervals is returned. For \code{anova_stats()}, a tidy
  data frame with all statistics is returned (excluding confidence intervals).
}
\description{
Returns the (partial) eta-squared, (partial) omega-squared,
  epsilon-squared statistic or Cohen's F for all terms in an anovas.
  \code{anova_stats()} returns a tidy summary, including all these statistics
  and power for each term.
}
\details{
For \code{eta_sq()} (with \code{partial = FALSE}), due to
  non-symmetry, confidence intervals are based on bootstrap-methods. In this
  case, \code{n} indicates the number of bootstrap samples to be drawn to
  compute the confidence intervals. Confidence intervals for partial
  omega-squared and epsilon-squared is also based on bootstrapping.
  \cr \cr
  Since bootstrapped confidence intervals are based on the bootstrap standard error
  (i.e. \code{mean(x) +/- qt(.975, df = length(x) - 1) * sd(x))}, bounds of
  the confidence interval may be negative. Use \code{method = "quantile"} to
  make sure that the confidence intervals are always positive.
}
\examples{
# load sample data
data(efc)

# fit linear model
fit <- aov(
  c12hour ~ as.factor(e42dep) + as.factor(c172code) + c160age,
  data = efc
)

eta_sq(fit)
omega_sq(fit)
eta_sq(fit, partial = TRUE)
eta_sq(fit, partial = TRUE, ci.lvl = .8)

anova_stats(car::Anova(fit, type = 2))

}
\references{
Levine TR, Hullett CR (2002): Eta Squared, Partial Eta Squared, and Misreporting of Effect Size in Communication Research (\href{https://www.msu.edu/~levinet/eta\%20squared\%20hcr.pdf}{pdf})
  \cr \cr
  Tippey K, Longnecker MT (2016): An Ad Hoc Method for Computing Pseudo-Effect Size for Mixed Model. (\href{http://www.scsug.org/wp-content/uploads/2016/11/Ad-Hoc-Method-for-Computing-Effect-Size-for-Mixed-Models_PROCEEDINGS-UPDATE-1.pdf}{pdf})
}
