#! /bin/sh

# Test upload of a CSV file.

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

BASENAME=$(basename $0 .pl)
TMP_TEST_DB=$(echo tmp${BASENAME}$$ | sed 's/[^-0-9a-zA-Z]//g')

DB_DIR=db
TMP_DB_FILE=${DB_DIR}/${TMP_TEST_DB}.db
# TMP_DB_META=${DB_DIR}/restful.db
# TMP_DB_FILE_ABS=$(cd $(dirname ${TMP_DB_FILE}); pwd)/${TMP_TEST_DB}

sqlite3 ${TMP_DB_FILE} < tests/inputs/samples-r92.sql
sqlite3 ${TMP_DB_FILE} "alter table revision add column revision_id integer"

# sqlite3 ${TMP_DB_META} < tests/inputs/samples-metadata-r92.sql
# sqlite3 ${TMP_DB_META} "update description set dbname = '${TMP_DB_FILE_ABS}'"

export REQUEST_URI="/~saulius/restful/website/${TMP_TEST_DB}.db/sample"
export HTTP_HOST=restfuldb.domain.net
export REQUEST_METHOD=POST
export CONTENT_TYPE="multipart/form-data; boundary=------------------------b989696a28305e74"
export REMOTE_USER=writer

echo "==="

perl -lne 'print "$_\r"' <<EOF |
--------------------------b989696a28305e74
Content-Disposition: form-data; name="jsonfile"; filename="fill.csv"
Content-Type: text/plain

{
   "data" : [
      {
         "type" : "sample",
         "attributes" : {
            "SolsaID" : "VU-TEST-0001",
            "revision_id" : {
                "type" : "revision",
                "id" : 1,
                "attributes" : {
                    "db_user" : "the original depositor"
                }
            }
         }
      }
   ]
}

--------------------------b989696a28305e74--
EOF
${INPUT_SCRIPT}

echo select id, revision_id, SolsaID from sample:
sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select id, revision_id, SolsaID from sample order by id';
echo select id, revision_id, db_user from revision:
sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select id, revision_id, db_user from revision order by id';

rm -f ${TMP_DB_FILE}
