#!/bin/bash
#
# A shell script to load some pre generated data file to a DB using ldb tool
# ./ldb needs to be avaible to be executed.
#
# Usage: <SCRIPT> [checkout]
# `checkout` can be a tag, commit or branch name. Will build using it and check DBs generated by all previous tags can be opened by it.
# Return value 0 means all regression tests pass. 1 if not pass.

scriptpath=`dirname $BASH_SOURCE`
test_dir=${TEST_TMPDIR:-"/tmp"}"/format_compatible_check"
script_copy_dir=$test_dir"/script_copy"
input_data_path=$test_dir"/test_data_input/"

mkdir $test_dir || true
mkdir $input_data_path || true
rm -rf $script_copy_dir
cp $scriptpath $script_copy_dir -rf

# Generate four random files.
for i in {1..6}
do
  input_data[$i]=$input_data_path/data$i
  echo == Generating random input file ${input_data[$i]}
  python - <<EOF
import random
random.seed($i)
symbols=['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9']
with open('${input_data[$i]}', 'w') as f:
  for i in range(1,1024):
    k = ""
    for j in range(1, random.randint(1,32)):
      k=k + symbols[random.randint(0, len(symbols) - 1)]
    vb = ""
    for j in range(1, random.randint(0,128)):
      vb = vb + symbols[random.randint(0, len(symbols) - 1)]
    v = ""
    for j in range(1, random.randint(1, 5)):
      v = v + vb
    print >> f, k + " ==> " + v
EOF
done

# v2.1 or older doesn't pass the debug build but OK with release build
declare -a need_release_tags=("v1.5.7" "v2.1")
declare -a tags=("v2.5" "v2.4" "v2.3" "v2.2" "v2.8" "v3.0" "v3.1" "v3.2" "v3.3" "v3.4" "rocksdb-3.5.1" "rocksdb-3.6.2" "rocksdb-3.7" "rocksdb-3.8" "rocksdb-3.9" "v3.10")
declare -a forward_compatible_tags=("rocksdb-3.8" "rocksdb-3.9" "v3.10")

generate_db()
{
    set +e
    $script_copy_dir/generate_random_db.sh $1 $2
    if [ $? -ne 0 ]; then
        echo ==== Error loading data from $2 to $1 ====
        exit 1
    fi
    set -e
}

compare_db()
{
    set +e
    $script_copy_dir/verify_random_db.sh $1 $2 $3
    if [ $? -ne 0 ]; then
        echo ==== Read different content from $1 and $2 or error happened. ====
        exit 1
    fi
    set -e
}

set -e
for tag in "${tags[@]}" "${need_release_tags[@]}"
do
   echo == Generating DB from "$tag" ...
   git checkout $tag
   make clean
   make ldb -j32
   generate_db $input_data_path $test_dir/$tag
done

checkout_flag=${1:-"master"}

echo == Building $checkout_flag debug
git checkout $checkout_flag
make clean
make ldb -j32
compare_base_db_dir=$test_dir"/base_db_dir"
echo == Generate compare base DB to $compare_base_db_dir
generate_db $input_data_path $compare_base_db_dir

for tag in "${tags[@]}"
do
   echo == Opening DB from "$tag" using debug build of $checkout_flag ...
   compare_db $test_dir/$tag $compare_base_db_dir db_dump.txt
done

echo == Building $checkout_flag release
git checkout $checkout_flag
make release
for tag in "${need_release_tags[@]}"
do
   echo == Opening DB generated by "$tag" using release build of $checkout_flag ...
   compare_db $test_dir/$tag $compare_base_db_dir db_dump.txt
done

for tag in "${forward_compatible_tags[@]}"
do
   echo == Build "$tag" and try to open DB generated using $checkout_flag...
   git checkout $tag
   make clean
   make ldb -j32
   compare_db $test_dir/$tag $compare_base_db_dir forward_${tag}_dump.txt
done

echo ==== Compatibility Test PASSED ====
