/*
*  file: rfilter.h
*  
*
*  Copyright (C) 2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_FILTER_H
#define _R_FILTER_H

#include <glib.h>
#include <glib-object.h>

#include "types.h"

#define R_FILTER_TYPE            (r_filter_get_type())

#define R_FILTER(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),  \
				  R_FILTER_TYPE, RFilter))

#define R_FILTER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),   \
                                  R_FILTER_TYPE, RFilterClass))

#define R_IS_FILTER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),  \
                                  R_FILTER_TYPE))

#define R_IS_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),   \
                                  R_FILTER_TYPE))

#define R_FILTER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),   \
                                  R_FILTER_TYPE, RFilterClass))


typedef struct _RFilter          RFilter;
typedef struct _RFilterClass     RFilterClass;
typedef struct _RFilterPrivate   RFilterPrivate;


struct _RFilter 
{
  GObject parent;

  RFilterPrivate* priv; 
};


struct _RFilterClass
{
  GObjectClass parent;
};


GType    r_filter_get_type         (void);


RFilter* r_filter_new              (void);
void     r_filter_free             (RFilter* filter);

RFilter* r_filter_copy             (RFilter* filter);
void     r_filter_add_pattern      (RFilter* filter, gchar* pattern);
gboolean r_filter_delete_pattern   (RFilter* filter, gchar* pattern);

void     r_filter_reset            (RFilter* filter);
gchar*   r_filter_get_pattern      (RFilter* filter);
gchar*   r_filter_get_next_pattern (RFilter* filter);

#endif
