# Chef Contributor Covenant Code of Conduct

**Note**: If you are in a physical space (e.g. ChefConf, Meetup, etc), please
see the [Physical Spaces Code of Conduct](physical-spaces-code-of-conduct.md)

## Our Pledge

Diversity is one of the greatest strengths that a community can have, and many times
that strength is born from the friction that can only come through sharing of
differing perspectives.

In the interest of fostering an open, welcoming, and encouraging environment, we
as contributors, maintainers, and community members pledge to making
participation in our projects and our community a harassment-free experience for
everyone, regardless of age, body size, disability, ethnicity, gender identity
and expression, level of experience, nationality, personal appearance, race,
religion, veteran status, or sexual identity and orientation.

## Our Standards

The Chef community contains a diverse group of professionals and volunteers
who come from all over the world to make Chef better. Community members may
fulfill many roles including mentoring, teaching, and connecting with other
members of the community.

Be careful in the words that you choose. Be kind to others. Practice empathy.
Don't insult or put down others. Remember that sexist, racist, ableist, ageist, and other
exclusionary jokes can be offensive to those around you. If you think your
conversation is making another community member uncomfortable _or_ if they tell
you so, stop immediately, make amends, and move forward.

As you are working with other members of the community, please keep in mind that the
following guidelines apply equally to founders, mentors, those who submit
new features/pull requests, and anyone who is seeking help and guidance.

The following list isn’t exhaustive, but these few examples can help all of us
communicate well, so that the community can work better together:
  - Use welcoming and inclusive language
  - Exercise patience and friendliness
  - Be respectful of differing viewpoints and experiences
  - Gracefully accept constructive criticism
  - Focus on what is best for the community
  - Show empathy towards other community members

The previous list applies to all forms of communication: Slack (or any web
chat), Discourse, the issue tracker, and any other forum that is used by the
community.

Please keep in mind that:
  - Your work will be used by other people, and you, in turn, will depend on the
    work of others
  - Decisions that you make often will affect others in the community
  - Disagreements happen, but should not be an excuse for poor behavior and bad
    manners. When disagreements do happen, let’s work together to solve them
    effectively and in a way that ensures that everyone understands what the
    disagreements were
  - Our community spans languages, cultures, perspectives (and continents!), and
    as such people may not understand jokes, sarcasm, and oblique references in
    the same way that you do. Remember that and be kind to the other members
    of the community
  - Be cautious about making assumptions about what someone does or does not know 
    about something - assuming that someone does not understand an issue and over 
    explaining can be condescending (even when not intended to be so)
  - Sexist, racist, ableist, ageist, and other prejudicial or exclusionary comments are
    not welcome in the community

## Unacceptable Behavior

Harassment comes in many forms, including but not limited to:
  - Offensive comments related to gender, sexual orientation, age, disability,
    physical appearance, body size, race, veteran status, or religion
  - Posting/Exposing sexually explicit or violent images
  - Deliberate (or implied) intimidation
  - Trolling, insulting/derogatory comments, and personal or political attacks
    particularly those related to gender, sexual orientation, age, race, religion or
    disability
  - Publishing others' private
    information, such as a physical or electronic address, without explicit
    permission ("doxing")

As a community that meets in physical public spaces, harassment also includes:
  - Stalking or persistent following
  - Intrusive or otherwise unwanted photography or recording
  - Sustained disruption of talks or other events
  - Inappropriate physical contact or unwelcome sexual attention

**NOTE**: If you are in a physical space -- e.g. Chef Conf, Meetup, etc. -- please
see the [Physical Spaces Code of Conduct](physical-spaces-code-of-conduct.md).

If you have any lack of clarity about behaviors we include in the definition of
"harassment", please read the [Citizen Code of
Conduct](http://citizencodeofconduct.org/). In particular, we do not tolerate
behavior that excludes people in socially marginalized groups.

## Enforcement/Getting Help

Instances of abusive, harassing, or otherwise unacceptable behavior should be
reported by contacting any of the Community Advocates directly. Each person's
contact information and role is listed in the repo that links to this document.
If you were not linked here, then contact the [individuals listed below](#roles). All
complaints will be reviewed, investigated, and will result in a response that
is deemed necessary and appropriate to the circumstances. The project team is
obligated to maintain confidentiality with regard to the reporter of an
incident. Further details of specific enforcement policies may be posted
separately.

Community Organizers who do not follow or enforce the Code of Conduct in good
faith may face temporary or permanent repercussions as determined by other
members of the project's leadership.

## Roles

The following are the various roles of our **Community Organizers** and the
person(s) assigned to each role:
  - The **Deciders** have final say on community guidelines and final authority on correct actions and appeals
  - The **Community Advocates** may be assigned for each area where the
    community convenes online (Slack, email list, GitHub, etc.). Community
    Advocates are volunteers who have the best interests of our community in
    mind. They act in good faith to help enforce our community guidelines and
    respond to incidents when they occur
  - The **Project Maintainers** are expected to conduct their
    behavior in line with the Code of Conduct and are individually responsible
    for both escalating to a **Community Advocate** in case of witnessing an
    incident, and helping to foster the community
  - A **Community Member** is anyone who participates with the community
    whether in-person or via online channels. Community members are responsible
    for following the community guidelines, suggesting updates to the guidelines
    when warranted, and helping enforce community guidelines

| Role                | Name                     | Contact Info           |
| ------------------- | ------------------------ | ---------------------- |
| Decider             | Jenny Armstrong-Own      | jowen@chef.io           |
| Community Advocate  | Mandi Walls              | mandi@chef.io          |
| Community Advocate  | Nell Shamrell-Harrington | nshamrell@chef.io      |
| Community Advocate  | Robb Kidd                | rkidd@chef.io          |

## Consequences of Unacceptable Behavior

Unacceptable behavior from any community member, including sponsors and those
with decision-making authority, will *not* be tolerated.

Anyone who is asked to stop unacceptable behavior is expected to comply immediately.

If a community member engages in unacceptable behavior, the community organizers
may take action that they deem appropriate -- up to and including a temporary ban or
permanent expulsion from the community _without warning_ (and without refund, in
the case of a paid event). If you have been involved in unacceptable behavior
with current Chef community members outside the boundaries of the Chef
Community, the Community Organizers retain the right to treat those external
incidents in the same manner as internal incidents.

Any physical violence _or_ intimidation, threatened or acted on, is a serious
offense and will result in immediate exclusion from the community and
appropriate follow up with law enforcement. No, we are not kidding.

## Procedure for Handling Disagreements and Incidents

Disagreements are inherent to a group of impassioned people. When they occur, we
seek to resolve disagreements and differing views constructively and with the
help of the community and community processes. When disagreements escalate, we
ask our Community Advocates to step in to moderate, mediate, and help resolve
tense situations.

The Chef Community Advocates are well informed on how to deal with incidents.
Report the incident (preferably in writing) to one of the Community Advocates
listed in the [Roles](#roles) section.

### Handling Incidents

**NOTE**: If you are in a physical space -- e.g. Chef Conf, Meetup, etc. -- please
see the [Physical Spaces Code of Conduct](physical-spaces-code-of-conduct.md).

When a Community Organizer or Project Maintainer notices someone behaving in a
way that is outside of our guidelines (a violator), the Community Advocate should
make every reasonable attempt to help curtail that behavior. The Community
Advocate may:

  - Remind the violator about our Community Code of Conduct and provide a link
    to this document
  - Ask the violator to stop the unacceptable behavior
  - Raise the issue with a maintainer, the community manager, or any member of
    the core project team
  - Allow time for the violator to correct the behavior

The Community Advocate should take the following steps if the behavior is not
brought in-line with our guidelines or the incident is not resolved:

  - Consult with another Community Organizer to make a judgment call about what
    reasonable corrective actions are warranted
  - In the case that no conclusion can be made, escalate to include the next
    level of Community Organizers
  - If still no conclusion can be made, report the incident to the **Deciders** listed above
  - Apply the corrective action
  - Document the incident as described below

#### Documenting Incidents

All incident reports will be kept in a private repository that is shared with
the aforementioned Community Advocates and Deciders under the [Roles]((#roles)
section. No other individuals or project contributors will be given access to
these incident reports. **This repo will hold no personal information on the
victim of an incident.** On the displacement of any Community Organizer in the
[Roles](#roles) list above, that individual will immediately lose access to this
repository and will terminate any local copies of the repository.

The important information to report consists of:

  - Identifying information (name, email address, Slack username, etc.) of the
    person doing the harassing
  - The behavior that was in violation
  - The approximate time and date of the behavior
  - The circumstances surrounding the incident
  - Where applicable, contextual information/proof (email body, chat log, GitHub
    Issue, etc.)
  - Contact information for witnesses to the incident

If you feel your safety is in jeopardy, please do not hesitate to contact local
law enforcement.

**Note:** Incidents that violate the Community Code of Conduct are extremely
damaging to the community. The silver lining is that, in many cases, these
incidents present a chance for the community as a whole to grow, learn, and
become better.

## Our Responsibilities

Community Organizers are responsible for clarifying the standards of acceptable
behavior and are expected to take appropriate and fair corrective action in
response to any instances of unacceptable behavior.

Community Organizers have the right and responsibility to remove, edit, or
reject comments, commits, code, wiki edits, issues, messages, tweets, and other
contributions that are not aligned with this Code of Conduct, or to ban
temporarily or permanently any contributor for other behaviors that they deem
inappropriate, threatening, offensive, or harmful.

## Scope

Our community will convene in both physical and virtual spaces. This Code of
Conduct applies within project spaces and in public spaces when an individual is
representing the project or its community. Examples of representing a project or
community include using an official project e-mail address, posting via an
official social media account, or acting as an appointed representative at an
online or offline event. Representation of a project may be further defined and
clarified by project maintainers and community organizers.

## Attribution

This Code of Conduct is adapted from the following:
  - [Contributor Covenant](http://contributor-covenant.org), version 1.4, available [here](http://contributor-covenant.org/version/1/4/)
  - [Rust Code of Conduct](https://www.rust-lang.org/en-US/conduct.html)
  - [Citizen Code of Conduct](http://citizencodeofconduct.org/)

## Community Members in Crisis

If a community member is in or appears to be in crisis, please refer to the [Community Members in Crisis Guide](./communication/community-members-in-crisis.md).