// Copyright 2015 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// DO NOT EDIT: autogenerated by etc/platform-intrinsics/generator.py
// ignore-tidy-linelength

#![allow(unused_imports)]

use {Intrinsic, Type};
use IntrinsicDef::Named;

// The default inlining settings trigger a pathological behaviour in
// LLVM, which causes makes compilation very slow. See #28273.
#[inline(never)]
pub fn find(name: &str) -> Option<Intrinsic> {
    if !name.starts_with("aarch64_v") { return None }
    Some(match &name["aarch64_v".len()..] {
        "hadd_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.shadd.v8i8")
        },
        "hadd_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.uhadd.v8i8")
        },
        "hadd_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.shadd.v4i16")
        },
        "hadd_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.uhadd.v4i16")
        },
        "hadd_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.shadd.v2i32")
        },
        "hadd_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.uhadd.v2i32")
        },
        "haddq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.shadd.v16i8")
        },
        "haddq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.uhadd.v16i8")
        },
        "haddq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.shadd.v8i16")
        },
        "haddq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.uhadd.v8i16")
        },
        "haddq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.shadd.v4i32")
        },
        "haddq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.uhadd.v4i32")
        },
        "rhadd_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.srhadd.v8i8")
        },
        "rhadd_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.urhadd.v8i8")
        },
        "rhadd_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.srhadd.v4i16")
        },
        "rhadd_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.urhadd.v4i16")
        },
        "rhadd_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.srhadd.v2i32")
        },
        "rhadd_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.urhadd.v2i32")
        },
        "rhaddq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.srhadd.v16i8")
        },
        "rhaddq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.urhadd.v16i8")
        },
        "rhaddq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.srhadd.v8i16")
        },
        "rhaddq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.urhadd.v8i16")
        },
        "rhaddq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.srhadd.v4i32")
        },
        "rhaddq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.urhadd.v4i32")
        },
        "qadd_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.sqadd.v8i8")
        },
        "qadd_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.uqadd.v8i8")
        },
        "qadd_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.sqadd.v4i16")
        },
        "qadd_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.uqadd.v4i16")
        },
        "qadd_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.sqadd.v2i32")
        },
        "qadd_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.uqadd.v2i32")
        },
        "qadd_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x1, &::I64x1]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.aarch64.neon.sqadd.v1i64")
        },
        "qadd_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x1, &::U64x1]; &INPUTS },
            output: &::U64x1,
            definition: Named("llvm.aarch64.neon.uqadd.v1i64")
        },
        "qaddq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.sqadd.v16i8")
        },
        "qaddq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.uqadd.v16i8")
        },
        "qaddq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.sqadd.v8i16")
        },
        "qaddq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.uqadd.v8i16")
        },
        "qaddq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.sqadd.v4i32")
        },
        "qaddq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.uqadd.v4i32")
        },
        "qaddq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.aarch64.neon.sqadd.v2i64")
        },
        "qaddq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.aarch64.neon.uqadd.v2i64")
        },
        "uqadd_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::U8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.suqadd.v16i8")
        },
        "uqadd_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::U16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.suqadd.v8i16")
        },
        "uqadd_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::U32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.suqadd.v4i32")
        },
        "uqadd_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::U64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.aarch64.neon.suqadd.v2i64")
        },
        "sqadd_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::I8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.usqadd.v16i8")
        },
        "sqadd_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::I16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.usqadd.v8i16")
        },
        "sqadd_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::I32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.usqadd.v4i32")
        },
        "sqadd_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::I64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.aarch64.neon.usqadd.v2i64")
        },
        "raddhn_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.raddhn.v8i8")
        },
        "raddhn_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.raddhn.v8i8")
        },
        "raddhn_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.raddhn.v4i16")
        },
        "raddhn_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.raddhn.v4i16")
        },
        "raddhn_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.raddhn.v2i32")
        },
        "raddhn_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U64x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.raddhn.v2i32")
        },
        "fmulx_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.aarch64.neon.fmulx.v2f32")
        },
        "fmulx_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x1, &::F64x1]; &INPUTS },
            output: &::F64x1,
            definition: Named("llvm.aarch64.neon.fmulx.v1f64")
        },
        "fmulxq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.aarch64.neon.fmulx.v4f32")
        },
        "fmulxq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x2, &::F64x2]; &INPUTS },
            output: &::F64x2,
            definition: Named("llvm.aarch64.neon.fmulx.v2f64")
        },
        "fma_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.fma.v2f32")
        },
        "fma_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x1, &::F64x1]; &INPUTS },
            output: &::F64x1,
            definition: Named("llvm.fma.v1f64")
        },
        "fmaq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.fma.v4f32")
        },
        "fmaq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x2, &::F64x2]; &INPUTS },
            output: &::F64x2,
            definition: Named("llvm.fma.v2f64")
        },
        "qdmulh_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.sqdmulh.v4i16")
        },
        "qdmulh_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.sqdmulh.v2i32")
        },
        "qdmulhq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.sqdmulh.v8i16")
        },
        "qdmulhq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.sqdmulh.v4i32")
        },
        "qrdmulh_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.sqrdmulh.v4i16")
        },
        "qrdmulh_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.sqrdmulh.v2i32")
        },
        "qrdmulhq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.sqrdmulh.v8i16")
        },
        "qrdmulhq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.sqrdmulh.v4i32")
        },
        "mull_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.smull.v8i16")
        },
        "mull_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.umull.v8i16")
        },
        "mull_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.smull.v4i32")
        },
        "mull_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.umull.v4i32")
        },
        "mull_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.aarch64.neon.smull.v2i64")
        },
        "mull_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.aarch64.neon.umull.v2i64")
        },
        "qdmullq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.sqdmull.v8i16")
        },
        "qdmullq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.sqdmull.v4i32")
        },
        "hsub_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.shsub.v8i8")
        },
        "hsub_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.uhsub.v8i8")
        },
        "hsub_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.shsub.v4i16")
        },
        "hsub_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.uhsub.v4i16")
        },
        "hsub_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.shsub.v2i32")
        },
        "hsub_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.uhsub.v2i32")
        },
        "hsubq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.shsub.v16i8")
        },
        "hsubq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.uhsub.v16i8")
        },
        "hsubq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.shsub.v8i16")
        },
        "hsubq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.uhsub.v8i16")
        },
        "hsubq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.shsub.v4i32")
        },
        "hsubq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.uhsub.v4i32")
        },
        "qsub_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.sqsub.v8i8")
        },
        "qsub_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.uqsub.v8i8")
        },
        "qsub_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.sqsub.v4i16")
        },
        "qsub_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.uqsub.v4i16")
        },
        "qsub_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.sqsub.v2i32")
        },
        "qsub_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.uqsub.v2i32")
        },
        "qsub_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x1, &::I64x1]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.aarch64.neon.sqsub.v1i64")
        },
        "qsub_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x1, &::U64x1]; &INPUTS },
            output: &::U64x1,
            definition: Named("llvm.aarch64.neon.uqsub.v1i64")
        },
        "qsubq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.sqsub.v16i8")
        },
        "qsubq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.uqsub.v16i8")
        },
        "qsubq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.sqsub.v8i16")
        },
        "qsubq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.uqsub.v8i16")
        },
        "qsubq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.sqsub.v4i32")
        },
        "qsubq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.uqsub.v4i32")
        },
        "qsubq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.aarch64.neon.sqsub.v2i64")
        },
        "qsubq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.aarch64.neon.uqsub.v2i64")
        },
        "rsubhn_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.rsubhn.v8i8")
        },
        "rsubhn_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.rsubhn.v8i8")
        },
        "rsubhn_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.rsubhn.v4i16")
        },
        "rsubhn_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.rsubhn.v4i16")
        },
        "rsubhn_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.rsubhn.v2i32")
        },
        "rsubhn_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U64x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.rsubhn.v2i32")
        },
        "abd_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.sabd.v8i8")
        },
        "abd_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.uabd.v8i8")
        },
        "abd_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.sabd.v4i16")
        },
        "abd_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.uabd.v4i16")
        },
        "abd_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.sabd.v2i32")
        },
        "abd_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.uabd.v2i32")
        },
        "abd_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.aarch64.neon.fabd.v2f32")
        },
        "abd_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x1, &::F64x1]; &INPUTS },
            output: &::F64x1,
            definition: Named("llvm.aarch64.neon.fabd.v1f64")
        },
        "abdq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.sabd.v16i8")
        },
        "abdq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.uabd.v16i8")
        },
        "abdq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.sabd.v8i16")
        },
        "abdq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.uabd.v8i16")
        },
        "abdq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.sabd.v4i32")
        },
        "abdq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.uabd.v4i32")
        },
        "abdq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.aarch64.neon.fabd.v4f32")
        },
        "abdq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x2, &::F64x2]; &INPUTS },
            output: &::F64x2,
            definition: Named("llvm.aarch64.neon.fabd.v2f64")
        },
        "max_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.smax.v8i8")
        },
        "max_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.umax.v8i8")
        },
        "max_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.smax.v4i16")
        },
        "max_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.umax.v4i16")
        },
        "max_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.smax.v2i32")
        },
        "max_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.umax.v2i32")
        },
        "max_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.aarch64.neon.fmax.v2f32")
        },
        "max_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x1, &::F64x1]; &INPUTS },
            output: &::F64x1,
            definition: Named("llvm.aarch64.neon.fmax.v1f64")
        },
        "maxq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.smax.v16i8")
        },
        "maxq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.umax.v16i8")
        },
        "maxq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.smax.v8i16")
        },
        "maxq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.umax.v8i16")
        },
        "maxq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.smax.v4i32")
        },
        "maxq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.umax.v4i32")
        },
        "maxq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.aarch64.neon.fmax.v4f32")
        },
        "maxq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x2, &::F64x2]; &INPUTS },
            output: &::F64x2,
            definition: Named("llvm.aarch64.neon.fmax.v2f64")
        },
        "min_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.smin.v8i8")
        },
        "min_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.umin.v8i8")
        },
        "min_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.smin.v4i16")
        },
        "min_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.umin.v4i16")
        },
        "min_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.smin.v2i32")
        },
        "min_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.umin.v2i32")
        },
        "min_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.aarch64.neon.fmin.v2f32")
        },
        "min_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x1, &::F64x1]; &INPUTS },
            output: &::F64x1,
            definition: Named("llvm.aarch64.neon.fmin.v1f64")
        },
        "minq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.smin.v16i8")
        },
        "minq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.umin.v16i8")
        },
        "minq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.smin.v8i16")
        },
        "minq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.umin.v8i16")
        },
        "minq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.smin.v4i32")
        },
        "minq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.umin.v4i32")
        },
        "minq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.aarch64.neon.fmin.v4f32")
        },
        "minq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x2, &::F64x2]; &INPUTS },
            output: &::F64x2,
            definition: Named("llvm.aarch64.neon.fmin.v2f64")
        },
        "maxnm_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.aarch64.neon.fmaxnm.v2f32")
        },
        "maxnm_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x1, &::F64x1]; &INPUTS },
            output: &::F64x1,
            definition: Named("llvm.aarch64.neon.fmaxnm.v1f64")
        },
        "maxnmq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.aarch64.neon.fmaxnm.v4f32")
        },
        "maxnmq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x2, &::F64x2]; &INPUTS },
            output: &::F64x2,
            definition: Named("llvm.aarch64.neon.fmaxnm.v2f64")
        },
        "minnm_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.aarch64.neon.fminnm.v2f32")
        },
        "minnm_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x1, &::F64x1]; &INPUTS },
            output: &::F64x1,
            definition: Named("llvm.aarch64.neon.fminnm.v1f64")
        },
        "minnmq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.aarch64.neon.fminnm.v4f32")
        },
        "minnmq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x2, &::F64x2]; &INPUTS },
            output: &::F64x2,
            definition: Named("llvm.aarch64.neon.fminnm.v2f64")
        },
        "shl_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.sshl.v8i8")
        },
        "shl_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::I8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.ushl.v8i8")
        },
        "shl_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.sshl.v4i16")
        },
        "shl_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::I16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.ushl.v4i16")
        },
        "shl_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.sshl.v2i32")
        },
        "shl_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::I32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.ushl.v2i32")
        },
        "shl_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x1, &::I64x1]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.aarch64.neon.sshl.v1i64")
        },
        "shl_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x1, &::I64x1]; &INPUTS },
            output: &::U64x1,
            definition: Named("llvm.aarch64.neon.ushl.v1i64")
        },
        "shlq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.sshl.v16i8")
        },
        "shlq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::I8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.ushl.v16i8")
        },
        "shlq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.sshl.v8i16")
        },
        "shlq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::I16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.ushl.v8i16")
        },
        "shlq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.sshl.v4i32")
        },
        "shlq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::I32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.ushl.v4i32")
        },
        "shlq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.aarch64.neon.sshl.v2i64")
        },
        "shlq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::I64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.aarch64.neon.ushl.v2i64")
        },
        "qshl_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.sqshl.v8i8")
        },
        "qshl_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::I8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.uqshl.v8i8")
        },
        "qshl_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.sqshl.v4i16")
        },
        "qshl_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::I16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.uqshl.v4i16")
        },
        "qshl_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.sqshl.v2i32")
        },
        "qshl_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::I32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.uqshl.v2i32")
        },
        "qshl_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x1, &::I64x1]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.aarch64.neon.sqshl.v1i64")
        },
        "qshl_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x1, &::I64x1]; &INPUTS },
            output: &::U64x1,
            definition: Named("llvm.aarch64.neon.uqshl.v1i64")
        },
        "qshlq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.sqshl.v16i8")
        },
        "qshlq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::I8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.uqshl.v16i8")
        },
        "qshlq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.sqshl.v8i16")
        },
        "qshlq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::I16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.uqshl.v8i16")
        },
        "qshlq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.sqshl.v4i32")
        },
        "qshlq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::I32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.uqshl.v4i32")
        },
        "qshlq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.aarch64.neon.sqshl.v2i64")
        },
        "qshlq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::I64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.aarch64.neon.uqshl.v2i64")
        },
        "rshl_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.srshl.v8i8")
        },
        "rshl_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::I8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.urshl.v8i8")
        },
        "rshl_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.srshl.v4i16")
        },
        "rshl_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::I16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.urshl.v4i16")
        },
        "rshl_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.srshl.v2i32")
        },
        "rshl_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::I32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.urshl.v2i32")
        },
        "rshl_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x1, &::I64x1]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.aarch64.neon.srshl.v1i64")
        },
        "rshl_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x1, &::I64x1]; &INPUTS },
            output: &::U64x1,
            definition: Named("llvm.aarch64.neon.urshl.v1i64")
        },
        "rshlq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.srshl.v16i8")
        },
        "rshlq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::I8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.urshl.v16i8")
        },
        "rshlq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.srshl.v8i16")
        },
        "rshlq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::I16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.urshl.v8i16")
        },
        "rshlq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.srshl.v4i32")
        },
        "rshlq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::I32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.urshl.v4i32")
        },
        "rshlq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.aarch64.neon.srshl.v2i64")
        },
        "rshlq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::I64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.aarch64.neon.urshl.v2i64")
        },
        "qrshl_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.sqrshl.v8i8")
        },
        "qrshl_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::I8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.uqrshl.v8i8")
        },
        "qrshl_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.sqrshl.v4i16")
        },
        "qrshl_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::I16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.uqrshl.v4i16")
        },
        "qrshl_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.sqrshl.v2i32")
        },
        "qrshl_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::I32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.uqrshl.v2i32")
        },
        "qrshl_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x1, &::I64x1]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.aarch64.neon.sqrshl.v1i64")
        },
        "qrshl_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x1, &::I64x1]; &INPUTS },
            output: &::U64x1,
            definition: Named("llvm.aarch64.neon.uqrshl.v1i64")
        },
        "qrshlq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.sqrshl.v16i8")
        },
        "qrshlq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::I8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.uqrshl.v16i8")
        },
        "qrshlq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.sqrshl.v8i16")
        },
        "qrshlq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::I16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.uqrshl.v8i16")
        },
        "qrshlq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.sqrshl.v4i32")
        },
        "qrshlq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::I32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.uqrshl.v4i32")
        },
        "qrshlq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.aarch64.neon.sqrshl.v2i64")
        },
        "qrshlq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::I64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.aarch64.neon.uqrshl.v2i64")
        },
        "qshrun_n_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::U32]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.sqshrun.v8i8")
        },
        "qshrun_n_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::U32]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.sqshrun.v4i16")
        },
        "qshrun_n_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::U32]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.sqshrun.v2i32")
        },
        "qrshrun_n_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::U32]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.sqrshrun.v8i8")
        },
        "qrshrun_n_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::U32]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.sqrshrun.v4i16")
        },
        "qrshrun_n_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::U32]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.sqrshrun.v2i32")
        },
        "qshrn_n_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::U32]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.sqshrn.v8i8")
        },
        "qshrn_n_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U32]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.uqshrn.v8i8")
        },
        "qshrn_n_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::U32]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.sqshrn.v4i16")
        },
        "qshrn_n_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.uqshrn.v4i16")
        },
        "qshrn_n_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::U32]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.sqshrn.v2i32")
        },
        "qshrn_n_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U32]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.uqshrn.v2i32")
        },
        "rshrn_n_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::U32]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.rshrn.v8i8")
        },
        "rshrn_n_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U32]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.rshrn.v8i8")
        },
        "rshrn_n_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::U32]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.rshrn.v4i16")
        },
        "rshrn_n_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.rshrn.v4i16")
        },
        "rshrn_n_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::U32]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.rshrn.v2i32")
        },
        "rshrn_n_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U32]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.rshrn.v2i32")
        },
        "qrshrn_n_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::U32]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.sqrshrn.v8i8")
        },
        "qrshrn_n_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U32]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.uqrshrn.v8i8")
        },
        "qrshrn_n_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::U32]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.sqrshrn.v4i16")
        },
        "qrshrn_n_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.uqrshrn.v4i16")
        },
        "qrshrn_n_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::U32]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.sqrshrn.v2i32")
        },
        "qrshrn_n_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U32]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.uqrshrn.v2i32")
        },
        "sri_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.vsri.v8i8")
        },
        "sri_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.vsri.v8i8")
        },
        "sri_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.vsri.v4i16")
        },
        "sri_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.vsri.v4i16")
        },
        "sri_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.vsri.v2i32")
        },
        "sri_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.vsri.v2i32")
        },
        "sri_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x1, &::I64x1]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.aarch64.neon.vsri.v1i64")
        },
        "sri_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x1, &::U64x1]; &INPUTS },
            output: &::U64x1,
            definition: Named("llvm.aarch64.neon.vsri.v1i64")
        },
        "sriq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.vsri.v16i8")
        },
        "sriq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.vsri.v16i8")
        },
        "sriq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.vsri.v8i16")
        },
        "sriq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.vsri.v8i16")
        },
        "sriq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.vsri.v4i32")
        },
        "sriq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.vsri.v4i32")
        },
        "sriq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.aarch64.neon.vsri.v2i64")
        },
        "sriq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.aarch64.neon.vsri.v2i64")
        },
        "sli_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.vsli.v8i8")
        },
        "sli_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.vsli.v8i8")
        },
        "sli_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.vsli.v4i16")
        },
        "sli_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.vsli.v4i16")
        },
        "sli_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.vsli.v2i32")
        },
        "sli_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.vsli.v2i32")
        },
        "sli_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x1, &::I64x1]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.aarch64.neon.vsli.v1i64")
        },
        "sli_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x1, &::U64x1]; &INPUTS },
            output: &::U64x1,
            definition: Named("llvm.aarch64.neon.vsli.v1i64")
        },
        "sliq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.vsli.v16i8")
        },
        "sliq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.vsli.v16i8")
        },
        "sliq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.vsli.v8i16")
        },
        "sliq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.vsli.v8i16")
        },
        "sliq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.vsli.v4i32")
        },
        "sliq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.vsli.v4i32")
        },
        "sliq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.aarch64.neon.vsli.v2i64")
        },
        "sliq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.aarch64.neon.vsli.v2i64")
        },
        "vqmovn_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.sqxtn.v8i8")
        },
        "vqmovn_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.uqxtn.v8i8")
        },
        "vqmovn_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.sqxtn.v4i16")
        },
        "vqmovn_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.uqxtn.v4i16")
        },
        "vqmovn_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I64x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.sqxtn.v2i32")
        },
        "vqmovn_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U64x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.uqxtn.v2i32")
        },
        "abs_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.abs.v8i8")
        },
        "abs_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.abs.v4i16")
        },
        "abs_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.abs.v2i32")
        },
        "abs_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I64x1]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.aarch64.neon.abs.v1i64")
        },
        "absq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.abs.v16i8")
        },
        "absq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.abs.v8i16")
        },
        "absq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.abs.v4i32")
        },
        "absq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.aarch64.neon.abs.v2i64")
        },
        "abs_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.fabs.v2f32")
        },
        "abs_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F64x1]; &INPUTS },
            output: &::F64x1,
            definition: Named("llvm.fabs.v1f64")
        },
        "absq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.fabs.v4f32")
        },
        "absq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F64x2]; &INPUTS },
            output: &::F64x2,
            definition: Named("llvm.fabs.v2f64")
        },
        "qabs_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.sqabs.v8i8")
        },
        "qabs_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.sqabs.v4i16")
        },
        "qabs_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.sqabs.v2i32")
        },
        "qabs_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I64x1]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.aarch64.neon.sqabs.v1i64")
        },
        "qabsq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.sqabs.v16i8")
        },
        "qabsq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.sqabs.v8i16")
        },
        "qabsq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.sqabs.v4i32")
        },
        "qabsq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.aarch64.neon.sqabs.v2i64")
        },
        "qneg_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.sqneg.v8i8")
        },
        "qneg_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.sqneg.v4i16")
        },
        "qneg_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.sqneg.v2i32")
        },
        "qneg_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I64x1]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.aarch64.neon.sqneg.v1i64")
        },
        "qnegq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.sqneg.v16i8")
        },
        "qnegq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.sqneg.v8i16")
        },
        "qnegq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.sqneg.v4i32")
        },
        "qnegq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.aarch64.neon.sqneg.v2i64")
        },
        "clz_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.ctlz.v8i8")
        },
        "clz_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.ctlz.v8i8")
        },
        "clz_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.ctlz.v4i16")
        },
        "clz_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.ctlz.v4i16")
        },
        "clz_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.ctlz.v2i32")
        },
        "clz_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.ctlz.v2i32")
        },
        "clzq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.ctlz.v16i8")
        },
        "clzq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.ctlz.v16i8")
        },
        "clzq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.ctlz.v8i16")
        },
        "clzq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.ctlz.v8i16")
        },
        "clzq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.ctlz.v4i32")
        },
        "clzq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.ctlz.v4i32")
        },
        "cls_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.cls.v8i8")
        },
        "cls_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.cls.v8i8")
        },
        "cls_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.cls.v4i16")
        },
        "cls_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.cls.v4i16")
        },
        "cls_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.cls.v2i32")
        },
        "cls_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.cls.v2i32")
        },
        "clsq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.cls.v16i8")
        },
        "clsq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.cls.v16i8")
        },
        "clsq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.cls.v8i16")
        },
        "clsq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.cls.v8i16")
        },
        "clsq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.cls.v4i32")
        },
        "clsq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.cls.v4i32")
        },
        "cnt_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.ctpop.v8i8")
        },
        "cnt_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.ctpop.v8i8")
        },
        "cntq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.ctpop.v16i8")
        },
        "cntq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.ctpop.v16i8")
        },
        "recpe_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.urecpe.v2i32")
        },
        "recpe_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.aarch64.neon.frecpe.v2f32")
        },
        "recpe_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F64x1]; &INPUTS },
            output: &::F64x1,
            definition: Named("llvm.aarch64.neon.frecpe.v1f64")
        },
        "recpeq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.urecpe.v4i32")
        },
        "recpeq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.aarch64.neon.frecpe.v4f32")
        },
        "recpeq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F64x2]; &INPUTS },
            output: &::F64x2,
            definition: Named("llvm.aarch64.neon.frecpe.v2f64")
        },
        "recps_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.aarch64.neon.frecps.v2f32")
        },
        "recps_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x1, &::F64x1]; &INPUTS },
            output: &::F64x1,
            definition: Named("llvm.aarch64.neon.frecps.v1f64")
        },
        "recpsq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.aarch64.neon.frecps.v4f32")
        },
        "recpsq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x2, &::F64x2]; &INPUTS },
            output: &::F64x2,
            definition: Named("llvm.aarch64.neon.frecps.v2f64")
        },
        "sqrt_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.sqrt.v2f32")
        },
        "sqrt_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F64x1]; &INPUTS },
            output: &::F64x1,
            definition: Named("llvm.sqrt.v1f64")
        },
        "sqrtq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.sqrt.v4f32")
        },
        "sqrtq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F64x2]; &INPUTS },
            output: &::F64x2,
            definition: Named("llvm.sqrt.v2f64")
        },
        "rsqrte_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.ursqrte.v2i32")
        },
        "rsqrte_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.aarch64.neon.frsqrte.v2f32")
        },
        "rsqrte_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F64x1]; &INPUTS },
            output: &::F64x1,
            definition: Named("llvm.aarch64.neon.frsqrte.v1f64")
        },
        "rsqrteq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.ursqrte.v4i32")
        },
        "rsqrteq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.aarch64.neon.frsqrte.v4f32")
        },
        "rsqrteq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F64x2]; &INPUTS },
            output: &::F64x2,
            definition: Named("llvm.aarch64.neon.frsqrte.v2f64")
        },
        "rsqrts_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.aarch64.neon.frsqrts.v2f32")
        },
        "rsqrts_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x1, &::F64x1]; &INPUTS },
            output: &::F64x1,
            definition: Named("llvm.aarch64.neon.frsqrts.v1f64")
        },
        "rsqrtsq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.aarch64.neon.frsqrts.v4f32")
        },
        "rsqrtsq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x2, &::F64x2]; &INPUTS },
            output: &::F64x2,
            definition: Named("llvm.aarch64.neon.frsqrts.v2f64")
        },
        "rbit_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.rbit.v8i8")
        },
        "rbit_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.rbit.v8i8")
        },
        "rbitq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.rbit.v16i8")
        },
        "rbitq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.rbit.v16i8")
        },
        "ld2_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I8, Some(&::I8x8), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v8i8.p0v8i8")
        },
        "ld2_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U8, Some(&::U8x8), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v8i8.p0v8i8")
        },
        "ld2_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I16, Some(&::I16x4), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v4i16.p0v4i16")
        },
        "ld2_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U16, Some(&::U16x4), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v4i16.p0v4i16")
        },
        "ld2_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I32, Some(&::I32x2), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v2i32.p0v2i32")
        },
        "ld2_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U32, Some(&::U32x2), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v2i32.p0v2i32")
        },
        "ld2_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I64, Some(&::I64x1), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::I64x1, &::I64x1]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v1i64.p0v1i64")
        },
        "ld2_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U64, Some(&::U64x1), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::U64x1, &::U64x1]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v1i64.p0v1i64")
        },
        "ld2_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F32, Some(&::F32x2), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v2f32.p0v2f32")
        },
        "ld2_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F64, Some(&::F64x1), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::F64x1, &::F64x1]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v1f64.p0v1f64")
        },
        "ld2q_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I8, Some(&::I8x16), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v16i8.p0v16i8")
        },
        "ld2q_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U8, Some(&::U8x16), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v16i8.p0v16i8")
        },
        "ld2q_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I16, Some(&::I16x8), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v8i16.p0v8i16")
        },
        "ld2q_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U16, Some(&::U16x8), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v8i16.p0v8i16")
        },
        "ld2q_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I32, Some(&::I32x4), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v4i32.p0v4i32")
        },
        "ld2q_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U32, Some(&::U32x4), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v4i32.p0v4i32")
        },
        "ld2q_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I64, Some(&::I64x2), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v2i64.p0v2i64")
        },
        "ld2q_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U64, Some(&::U64x2), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::U64x2, &::U64x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v2i64.p0v2i64")
        },
        "ld2q_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F32, Some(&::F32x4), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v4f32.p0v4f32")
        },
        "ld2q_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F64, Some(&::F64x2), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::F64x2, &::F64x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v2f64.p0v2f64")
        },
        "ld3_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I8, Some(&::I8x8), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::I8x8, &::I8x8, &::I8x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v8i8.p0v8i8")
        },
        "ld3_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U8, Some(&::U8x8), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::U8x8, &::U8x8, &::U8x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v8i8.p0v8i8")
        },
        "ld3_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I16, Some(&::I16x4), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::I16x4, &::I16x4, &::I16x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v4i16.p0v4i16")
        },
        "ld3_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U16, Some(&::U16x4), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::U16x4, &::U16x4, &::U16x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v4i16.p0v4i16")
        },
        "ld3_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I32, Some(&::I32x2), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::I32x2, &::I32x2, &::I32x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v2i32.p0v2i32")
        },
        "ld3_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U32, Some(&::U32x2), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::U32x2, &::U32x2, &::U32x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v2i32.p0v2i32")
        },
        "ld3_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I64, Some(&::I64x1), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::I64x1, &::I64x1, &::I64x1]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v1i64.p0v1i64")
        },
        "ld3_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U64, Some(&::U64x1), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::U64x1, &::U64x1, &::U64x1]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v1i64.p0v1i64")
        },
        "ld3_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F32, Some(&::F32x2), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::F32x2, &::F32x2, &::F32x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v2f32.p0v2f32")
        },
        "ld3_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F64, Some(&::F64x1), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::F64x1, &::F64x1, &::F64x1]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v1f64.p0v1f64")
        },
        "ld3q_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I8, Some(&::I8x16), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::I8x16, &::I8x16, &::I8x16]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v16i8.p0v16i8")
        },
        "ld3q_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U8, Some(&::U8x16), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::U8x16, &::U8x16, &::U8x16]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v16i8.p0v16i8")
        },
        "ld3q_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I16, Some(&::I16x8), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::I16x8, &::I16x8, &::I16x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v8i16.p0v8i16")
        },
        "ld3q_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U16, Some(&::U16x8), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::U16x8, &::U16x8, &::U16x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v8i16.p0v8i16")
        },
        "ld3q_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I32, Some(&::I32x4), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::I32x4, &::I32x4, &::I32x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v4i32.p0v4i32")
        },
        "ld3q_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U32, Some(&::U32x4), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::U32x4, &::U32x4, &::U32x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v4i32.p0v4i32")
        },
        "ld3q_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I64, Some(&::I64x2), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::I64x2, &::I64x2, &::I64x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v2i64.p0v2i64")
        },
        "ld3q_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U64, Some(&::U64x2), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::U64x2, &::U64x2, &::U64x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v2i64.p0v2i64")
        },
        "ld3q_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F32, Some(&::F32x4), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::F32x4, &::F32x4, &::F32x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v4f32.p0v4f32")
        },
        "ld3q_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F64, Some(&::F64x2), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::F64x2, &::F64x2, &::F64x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v2f64.p0v2f64")
        },
        "ld4_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I8, Some(&::I8x8), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::I8x8, &::I8x8, &::I8x8, &::I8x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v8i8.p0v8i8")
        },
        "ld4_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U8, Some(&::U8x8), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::U8x8, &::U8x8, &::U8x8, &::U8x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v8i8.p0v8i8")
        },
        "ld4_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I16, Some(&::I16x4), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::I16x4, &::I16x4, &::I16x4, &::I16x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v4i16.p0v4i16")
        },
        "ld4_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U16, Some(&::U16x4), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::U16x4, &::U16x4, &::U16x4, &::U16x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v4i16.p0v4i16")
        },
        "ld4_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I32, Some(&::I32x2), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::I32x2, &::I32x2, &::I32x2, &::I32x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v2i32.p0v2i32")
        },
        "ld4_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U32, Some(&::U32x2), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::U32x2, &::U32x2, &::U32x2, &::U32x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v2i32.p0v2i32")
        },
        "ld4_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I64, Some(&::I64x1), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::I64x1, &::I64x1, &::I64x1, &::I64x1]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v1i64.p0v1i64")
        },
        "ld4_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U64, Some(&::U64x1), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::U64x1, &::U64x1, &::U64x1, &::U64x1]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v1i64.p0v1i64")
        },
        "ld4_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F32, Some(&::F32x2), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::F32x2, &::F32x2, &::F32x2, &::F32x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v2f32.p0v2f32")
        },
        "ld4_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F64, Some(&::F64x1), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::F64x1, &::F64x1, &::F64x1, &::F64x1]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v1f64.p0v1f64")
        },
        "ld4q_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I8, Some(&::I8x16), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::I8x16, &::I8x16, &::I8x16, &::I8x16]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v16i8.p0v16i8")
        },
        "ld4q_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U8, Some(&::U8x16), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::U8x16, &::U8x16, &::U8x16, &::U8x16]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v16i8.p0v16i8")
        },
        "ld4q_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I16, Some(&::I16x8), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::I16x8, &::I16x8, &::I16x8, &::I16x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v8i16.p0v8i16")
        },
        "ld4q_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U16, Some(&::U16x8), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::U16x8, &::U16x8, &::U16x8, &::U16x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v8i16.p0v8i16")
        },
        "ld4q_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I32, Some(&::I32x4), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::I32x4, &::I32x4, &::I32x4, &::I32x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v4i32.p0v4i32")
        },
        "ld4q_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U32, Some(&::U32x4), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::U32x4, &::U32x4, &::U32x4, &::U32x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v4i32.p0v4i32")
        },
        "ld4q_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I64, Some(&::I64x2), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::I64x2, &::I64x2, &::I64x2, &::I64x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v2i64.p0v2i64")
        },
        "ld4q_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U64, Some(&::U64x2), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::U64x2, &::U64x2, &::U64x2, &::U64x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v2i64.p0v2i64")
        },
        "ld4q_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F32, Some(&::F32x4), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::F32x4, &::F32x4, &::F32x4, &::F32x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v4f32.p0v4f32")
        },
        "ld4q_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F64, Some(&::F64x2), true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::F64x2, &::F64x2, &::F64x2, &::F64x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v2f64.p0v2f64")
        },
        "ld2_dup_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I8, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v8i8.p0i8")
        },
        "ld2_dup_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U8, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v8i8.p0i8")
        },
        "ld2_dup_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I16, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v4i16.p0i16")
        },
        "ld2_dup_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U16, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v4i16.p0i16")
        },
        "ld2_dup_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I32, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v2i32.p0i32")
        },
        "ld2_dup_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U32, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v2i32.p0i32")
        },
        "ld2_dup_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I64, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::I64x1, &::I64x1]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v1i64.p0i64")
        },
        "ld2_dup_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U64, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::U64x1, &::U64x1]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v1i64.p0i64")
        },
        "ld2_dup_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F32, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v2f32.p0f32")
        },
        "ld2_dup_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F64, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::F64x1, &::F64x1]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v1f64.p0f64")
        },
        "ld2q_dup_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I8, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v16i8.p0i8")
        },
        "ld2q_dup_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U8, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v16i8.p0i8")
        },
        "ld2q_dup_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I16, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v8i16.p0i16")
        },
        "ld2q_dup_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U16, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v8i16.p0i16")
        },
        "ld2q_dup_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I32, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v4i32.p0i32")
        },
        "ld2q_dup_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U32, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v4i32.p0i32")
        },
        "ld2q_dup_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I64, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v2i64.p0i64")
        },
        "ld2q_dup_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U64, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::U64x2, &::U64x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v2i64.p0i64")
        },
        "ld2q_dup_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F32, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v4f32.p0f32")
        },
        "ld2q_dup_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F64, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 2] = [&::F64x2, &::F64x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld2.v2f64.p0f64")
        },
        "ld3_dup_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I8, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::I8x8, &::I8x8, &::I8x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v8i8.p0i8")
        },
        "ld3_dup_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U8, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::U8x8, &::U8x8, &::U8x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v8i8.p0i8")
        },
        "ld3_dup_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I16, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::I16x4, &::I16x4, &::I16x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v4i16.p0i16")
        },
        "ld3_dup_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U16, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::U16x4, &::U16x4, &::U16x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v4i16.p0i16")
        },
        "ld3_dup_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I32, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::I32x2, &::I32x2, &::I32x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v2i32.p0i32")
        },
        "ld3_dup_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U32, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::U32x2, &::U32x2, &::U32x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v2i32.p0i32")
        },
        "ld3_dup_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I64, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::I64x1, &::I64x1, &::I64x1]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v1i64.p0i64")
        },
        "ld3_dup_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U64, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::U64x1, &::U64x1, &::U64x1]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v1i64.p0i64")
        },
        "ld3_dup_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F32, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::F32x2, &::F32x2, &::F32x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v2f32.p0f32")
        },
        "ld3_dup_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F64, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::F64x1, &::F64x1, &::F64x1]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v1f64.p0f64")
        },
        "ld3q_dup_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I8, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::I8x16, &::I8x16, &::I8x16]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v16i8.p0i8")
        },
        "ld3q_dup_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U8, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::U8x16, &::U8x16, &::U8x16]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v16i8.p0i8")
        },
        "ld3q_dup_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I16, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::I16x8, &::I16x8, &::I16x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v8i16.p0i16")
        },
        "ld3q_dup_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U16, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::U16x8, &::U16x8, &::U16x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v8i16.p0i16")
        },
        "ld3q_dup_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I32, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::I32x4, &::I32x4, &::I32x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v4i32.p0i32")
        },
        "ld3q_dup_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U32, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::U32x4, &::U32x4, &::U32x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v4i32.p0i32")
        },
        "ld3q_dup_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I64, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::I64x2, &::I64x2, &::I64x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v2i64.p0i64")
        },
        "ld3q_dup_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U64, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::U64x2, &::U64x2, &::U64x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v2i64.p0i64")
        },
        "ld3q_dup_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F32, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::F32x4, &::F32x4, &::F32x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v4f32.p0f32")
        },
        "ld3q_dup_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F64, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 3] = [&::F64x2, &::F64x2, &::F64x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld3.v2f64.p0f64")
        },
        "ld4_dup_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I8, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::I8x8, &::I8x8, &::I8x8, &::I8x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v8i8.p0i8")
        },
        "ld4_dup_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U8, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::U8x8, &::U8x8, &::U8x8, &::U8x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v8i8.p0i8")
        },
        "ld4_dup_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I16, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::I16x4, &::I16x4, &::I16x4, &::I16x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v4i16.p0i16")
        },
        "ld4_dup_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U16, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::U16x4, &::U16x4, &::U16x4, &::U16x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v4i16.p0i16")
        },
        "ld4_dup_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I32, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::I32x2, &::I32x2, &::I32x2, &::I32x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v2i32.p0i32")
        },
        "ld4_dup_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U32, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::U32x2, &::U32x2, &::U32x2, &::U32x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v2i32.p0i32")
        },
        "ld4_dup_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I64, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::I64x1, &::I64x1, &::I64x1, &::I64x1]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v1i64.p0i64")
        },
        "ld4_dup_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U64, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::U64x1, &::U64x1, &::U64x1, &::U64x1]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v1i64.p0i64")
        },
        "ld4_dup_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F32, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::F32x2, &::F32x2, &::F32x2, &::F32x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v2f32.p0f32")
        },
        "ld4_dup_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F64, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::F64x1, &::F64x1, &::F64x1, &::F64x1]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v1f64.p0f64")
        },
        "ld4q_dup_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I8, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::I8x16, &::I8x16, &::I8x16, &::I8x16]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v16i8.p0i8")
        },
        "ld4q_dup_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U8, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::U8x16, &::U8x16, &::U8x16, &::U8x16]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v16i8.p0i8")
        },
        "ld4q_dup_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I16, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::I16x8, &::I16x8, &::I16x8, &::I16x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v8i16.p0i16")
        },
        "ld4q_dup_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U16, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::U16x8, &::U16x8, &::U16x8, &::U16x8]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v8i16.p0i16")
        },
        "ld4q_dup_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I32, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::I32x4, &::I32x4, &::I32x4, &::I32x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v4i32.p0i32")
        },
        "ld4q_dup_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U32, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::U32x4, &::U32x4, &::U32x4, &::U32x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v4i32.p0i32")
        },
        "ld4q_dup_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::I64, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::I64x2, &::I64x2, &::I64x2, &::I64x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v2i64.p0i64")
        },
        "ld4q_dup_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::U64, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::U64x2, &::U64x2, &::U64x2, &::U64x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v2i64.p0i64")
        },
        "ld4q_dup_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F32, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::F32x4, &::F32x4, &::F32x4, &::F32x4]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v4f32.p0f32")
        },
        "ld4q_dup_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [{ static PTR: Type = Type::Pointer(&::F64, None, true); &PTR }]; &INPUTS },
            output: { static AGG: Type = Type::Aggregate(false, { static PARTS: [&'static Type; 4] = [&::F64x2, &::F64x2, &::F64x2, &::F64x2]; &PARTS }); &AGG },
            definition: Named("llvm.aarch64.neon.ld4.v2f64.p0f64")
        },
        "padd_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.addp.v8i8")
        },
        "padd_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.addp.v8i8")
        },
        "padd_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.addp.v4i16")
        },
        "padd_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.addp.v4i16")
        },
        "padd_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.addp.v2i32")
        },
        "padd_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.addp.v2i32")
        },
        "padd_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.aarch64.neon.addp.v2f32")
        },
        "paddq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.addp.v16i8")
        },
        "paddq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.addp.v16i8")
        },
        "paddq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.addp.v8i16")
        },
        "paddq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.addp.v8i16")
        },
        "paddq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.addp.v4i32")
        },
        "paddq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.addp.v4i32")
        },
        "paddq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.aarch64.neon.addp.v4f32")
        },
        "paddq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.aarch64.neon.addp.v2i64")
        },
        "paddq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.aarch64.neon.addp.v2i64")
        },
        "paddq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x2, &::F64x2]; &INPUTS },
            output: &::F64x2,
            definition: Named("llvm.aarch64.neon.addp.v2f64")
        },
        "paddl_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x8]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.saddlp.v4i16.v8i8")
        },
        "paddl_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x8]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.uaddlp.v4i16.v8i8")
        },
        "paddl_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x4]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.saddlp.v2i32.v4i16")
        },
        "paddl_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x4]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.uaddlp.v2i32.v4i16")
        },
        "paddl_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x2]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.aarch64.neon.saddlp.v1i64.v2i32")
        },
        "paddl_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x2]; &INPUTS },
            output: &::U64x1,
            definition: Named("llvm.aarch64.neon.uaddlp.v1i64.v2i32")
        },
        "paddlq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x16]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.saddlp.v8i16.v16i8")
        },
        "paddlq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x16]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.uaddlp.v8i16.v16i8")
        },
        "paddlq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x8]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.saddlp.v4i32.v8i16")
        },
        "paddlq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x8]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.uaddlp.v4i32.v8i16")
        },
        "paddlq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x4]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.aarch64.neon.saddlp.v2i64.v4i32")
        },
        "paddlq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x4]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.aarch64.neon.uaddlp.v2i64.v4i32")
        },
        "pmax_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.smaxp.v8i8")
        },
        "pmax_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.umaxp.v8i8")
        },
        "pmax_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.smaxp.v4i16")
        },
        "pmax_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.umaxp.v4i16")
        },
        "pmax_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.smaxp.v2i32")
        },
        "pmax_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.umaxp.v2i32")
        },
        "pmax_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.aarch64.neon.fmaxp.v2f32")
        },
        "pmaxq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.smaxp.v16i8")
        },
        "pmaxq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.umaxp.v16i8")
        },
        "pmaxq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.smaxp.v8i16")
        },
        "pmaxq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.umaxp.v8i16")
        },
        "pmaxq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.smaxp.v4i32")
        },
        "pmaxq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.umaxp.v4i32")
        },
        "pmaxq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.aarch64.neon.fmaxp.v4f32")
        },
        "pmaxq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.aarch64.neon.smaxp.v2i64")
        },
        "pmaxq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.aarch64.neon.umaxp.v2i64")
        },
        "pmaxq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x2, &::F64x2]; &INPUTS },
            output: &::F64x2,
            definition: Named("llvm.aarch64.neon.fmaxp.v2f64")
        },
        "pmin_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.sminp.v8i8")
        },
        "pmin_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.uminp.v8i8")
        },
        "pmin_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.sminp.v4i16")
        },
        "pmin_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.uminp.v4i16")
        },
        "pmin_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.sminp.v2i32")
        },
        "pmin_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.uminp.v2i32")
        },
        "pmin_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.aarch64.neon.fminp.v2f32")
        },
        "pminq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.sminp.v16i8")
        },
        "pminq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.uminp.v16i8")
        },
        "pminq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.sminp.v8i16")
        },
        "pminq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.uminp.v8i16")
        },
        "pminq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.sminp.v4i32")
        },
        "pminq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.uminp.v4i32")
        },
        "pminq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.aarch64.neon.fminp.v4f32")
        },
        "pminq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.aarch64.neon.sminp.v2i64")
        },
        "pminq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.aarch64.neon.uminp.v2i64")
        },
        "pminq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x2, &::F64x2]; &INPUTS },
            output: &::F64x2,
            definition: Named("llvm.aarch64.neon.fminp.v2f64")
        },
        "pmaxnm_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.smaxnmp.v8i8")
        },
        "pmaxnm_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.umaxnmp.v8i8")
        },
        "pmaxnm_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.aarch64.neon.smaxnmp.v4i16")
        },
        "pmaxnm_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.aarch64.neon.umaxnmp.v4i16")
        },
        "pmaxnm_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.aarch64.neon.smaxnmp.v2i32")
        },
        "pmaxnm_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.aarch64.neon.umaxnmp.v2i32")
        },
        "pmaxnm_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.aarch64.neon.fmaxnmp.v2f32")
        },
        "pmaxnmq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.smaxnmp.v16i8")
        },
        "pmaxnmq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.umaxnmp.v16i8")
        },
        "pmaxnmq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.aarch64.neon.smaxnmp.v8i16")
        },
        "pmaxnmq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.aarch64.neon.umaxnmp.v8i16")
        },
        "pmaxnmq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.aarch64.neon.smaxnmp.v4i32")
        },
        "pmaxnmq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.aarch64.neon.umaxnmp.v4i32")
        },
        "pmaxnmq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.aarch64.neon.fmaxnmp.v4f32")
        },
        "pmaxnmq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.aarch64.neon.smaxnmp.v2i64")
        },
        "pmaxnmq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.aarch64.neon.umaxnmp.v2i64")
        },
        "pmaxnmq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x2, &::F64x2]; &INPUTS },
            output: &::F64x2,
            definition: Named("llvm.aarch64.neon.fmaxnmp.v2f64")
        },
        "pminnm_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.aarch64.neon.fminnmp.v2f32")
        },
        "pminnmq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.aarch64.neon.fminnmp.v4f32")
        },
        "pminnmq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F64x2, &::F64x2]; &INPUTS },
            output: &::F64x2,
            definition: Named("llvm.aarch64.neon.fminnmp.v2f64")
        },
        "addv_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x8]; &INPUTS },
            output: &::I8,
            definition: Named("llvm.aarch64.neon.saddv.i8.v8i8")
        },
        "addv_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x8]; &INPUTS },
            output: &::U8,
            definition: Named("llvm.aarch64.neon.uaddv.i8.v8i8")
        },
        "addv_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x4]; &INPUTS },
            output: &::I16,
            definition: Named("llvm.aarch64.neon.saddv.i16.v4i16")
        },
        "addv_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x4]; &INPUTS },
            output: &::U16,
            definition: Named("llvm.aarch64.neon.uaddv.i16.v4i16")
        },
        "addv_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x2]; &INPUTS },
            output: &::I32,
            definition: Named("llvm.aarch64.neon.saddv.i32.v2i32")
        },
        "addv_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x2]; &INPUTS },
            output: &::U32,
            definition: Named("llvm.aarch64.neon.uaddv.i32.v2i32")
        },
        "addv_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x2]; &INPUTS },
            output: &::F32,
            definition: Named("llvm.aarch64.neon.faddv.f32.v2f32")
        },
        "addvq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x16]; &INPUTS },
            output: &::I8,
            definition: Named("llvm.aarch64.neon.saddv.i8.v16i8")
        },
        "addvq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x16]; &INPUTS },
            output: &::U8,
            definition: Named("llvm.aarch64.neon.uaddv.i8.v16i8")
        },
        "addvq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x8]; &INPUTS },
            output: &::I16,
            definition: Named("llvm.aarch64.neon.saddv.i16.v8i16")
        },
        "addvq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x8]; &INPUTS },
            output: &::U16,
            definition: Named("llvm.aarch64.neon.uaddv.i16.v8i16")
        },
        "addvq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x4]; &INPUTS },
            output: &::I32,
            definition: Named("llvm.aarch64.neon.saddv.i32.v4i32")
        },
        "addvq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x4]; &INPUTS },
            output: &::U32,
            definition: Named("llvm.aarch64.neon.uaddv.i32.v4i32")
        },
        "addvq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x4]; &INPUTS },
            output: &::F32,
            definition: Named("llvm.aarch64.neon.faddv.f32.v4f32")
        },
        "addvq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I64x2]; &INPUTS },
            output: &::I64,
            definition: Named("llvm.aarch64.neon.saddv.i64.v2i64")
        },
        "addvq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U64x2]; &INPUTS },
            output: &::U64,
            definition: Named("llvm.aarch64.neon.uaddv.i64.v2i64")
        },
        "addvq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F64x2]; &INPUTS },
            output: &::F64,
            definition: Named("llvm.aarch64.neon.faddv.f64.v2f64")
        },
        "addlv_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x8]; &INPUTS },
            output: &::I16,
            definition: Named("llvm.aarch64.neon.saddlv.i16.v8i8")
        },
        "addlv_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x8]; &INPUTS },
            output: &::U16,
            definition: Named("llvm.aarch64.neon.uaddlv.i16.v8i8")
        },
        "addlv_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x4]; &INPUTS },
            output: &::I32,
            definition: Named("llvm.aarch64.neon.saddlv.i32.v4i16")
        },
        "addlv_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x4]; &INPUTS },
            output: &::U32,
            definition: Named("llvm.aarch64.neon.uaddlv.i32.v4i16")
        },
        "addlv_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x2]; &INPUTS },
            output: &::I64,
            definition: Named("llvm.aarch64.neon.saddlv.i64.v2i32")
        },
        "addlv_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x2]; &INPUTS },
            output: &::U64,
            definition: Named("llvm.aarch64.neon.uaddlv.i64.v2i32")
        },
        "addlvq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x16]; &INPUTS },
            output: &::I16,
            definition: Named("llvm.aarch64.neon.saddlv.i16.v16i8")
        },
        "addlvq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x16]; &INPUTS },
            output: &::U16,
            definition: Named("llvm.aarch64.neon.uaddlv.i16.v16i8")
        },
        "addlvq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x8]; &INPUTS },
            output: &::I32,
            definition: Named("llvm.aarch64.neon.saddlv.i32.v8i16")
        },
        "addlvq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x8]; &INPUTS },
            output: &::U32,
            definition: Named("llvm.aarch64.neon.uaddlv.i32.v8i16")
        },
        "addlvq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x4]; &INPUTS },
            output: &::I64,
            definition: Named("llvm.aarch64.neon.saddlv.i64.v4i32")
        },
        "addlvq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x4]; &INPUTS },
            output: &::U64,
            definition: Named("llvm.aarch64.neon.uaddlv.i64.v4i32")
        },
        "maxv_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x8]; &INPUTS },
            output: &::I8,
            definition: Named("llvm.aarch64.neon.smaxv.i8.v8i8")
        },
        "maxv_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x8]; &INPUTS },
            output: &::U8,
            definition: Named("llvm.aarch64.neon.umaxv.i8.v8i8")
        },
        "maxv_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x4]; &INPUTS },
            output: &::I16,
            definition: Named("llvm.aarch64.neon.smaxv.i16.v4i16")
        },
        "maxv_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x4]; &INPUTS },
            output: &::U16,
            definition: Named("llvm.aarch64.neon.umaxv.i16.v4i16")
        },
        "maxv_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x2]; &INPUTS },
            output: &::I32,
            definition: Named("llvm.aarch64.neon.smaxv.i32.v2i32")
        },
        "maxv_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x2]; &INPUTS },
            output: &::U32,
            definition: Named("llvm.aarch64.neon.umaxv.i32.v2i32")
        },
        "maxv_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x2]; &INPUTS },
            output: &::F32,
            definition: Named("llvm.aarch64.neon.fmaxv.f32.v2f32")
        },
        "maxvq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x16]; &INPUTS },
            output: &::I8,
            definition: Named("llvm.aarch64.neon.smaxv.i8.v16i8")
        },
        "maxvq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x16]; &INPUTS },
            output: &::U8,
            definition: Named("llvm.aarch64.neon.umaxv.i8.v16i8")
        },
        "maxvq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x8]; &INPUTS },
            output: &::I16,
            definition: Named("llvm.aarch64.neon.smaxv.i16.v8i16")
        },
        "maxvq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x8]; &INPUTS },
            output: &::U16,
            definition: Named("llvm.aarch64.neon.umaxv.i16.v8i16")
        },
        "maxvq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x4]; &INPUTS },
            output: &::I32,
            definition: Named("llvm.aarch64.neon.smaxv.i32.v4i32")
        },
        "maxvq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x4]; &INPUTS },
            output: &::U32,
            definition: Named("llvm.aarch64.neon.umaxv.i32.v4i32")
        },
        "maxvq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x4]; &INPUTS },
            output: &::F32,
            definition: Named("llvm.aarch64.neon.fmaxv.f32.v4f32")
        },
        "maxvq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F64x2]; &INPUTS },
            output: &::F64,
            definition: Named("llvm.aarch64.neon.fmaxv.f64.v2f64")
        },
        "minv_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x8]; &INPUTS },
            output: &::I8,
            definition: Named("llvm.aarch64.neon.sminv.i8.v8i8")
        },
        "minv_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x8]; &INPUTS },
            output: &::U8,
            definition: Named("llvm.aarch64.neon.uminv.i8.v8i8")
        },
        "minv_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x4]; &INPUTS },
            output: &::I16,
            definition: Named("llvm.aarch64.neon.sminv.i16.v4i16")
        },
        "minv_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x4]; &INPUTS },
            output: &::U16,
            definition: Named("llvm.aarch64.neon.uminv.i16.v4i16")
        },
        "minv_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x2]; &INPUTS },
            output: &::I32,
            definition: Named("llvm.aarch64.neon.sminv.i32.v2i32")
        },
        "minv_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x2]; &INPUTS },
            output: &::U32,
            definition: Named("llvm.aarch64.neon.uminv.i32.v2i32")
        },
        "minv_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x2]; &INPUTS },
            output: &::F32,
            definition: Named("llvm.aarch64.neon.fminv.f32.v2f32")
        },
        "minvq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x16]; &INPUTS },
            output: &::I8,
            definition: Named("llvm.aarch64.neon.sminv.i8.v16i8")
        },
        "minvq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x16]; &INPUTS },
            output: &::U8,
            definition: Named("llvm.aarch64.neon.uminv.i8.v16i8")
        },
        "minvq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x8]; &INPUTS },
            output: &::I16,
            definition: Named("llvm.aarch64.neon.sminv.i16.v8i16")
        },
        "minvq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x8]; &INPUTS },
            output: &::U16,
            definition: Named("llvm.aarch64.neon.uminv.i16.v8i16")
        },
        "minvq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x4]; &INPUTS },
            output: &::I32,
            definition: Named("llvm.aarch64.neon.sminv.i32.v4i32")
        },
        "minvq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x4]; &INPUTS },
            output: &::U32,
            definition: Named("llvm.aarch64.neon.uminv.i32.v4i32")
        },
        "minvq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x4]; &INPUTS },
            output: &::F32,
            definition: Named("llvm.aarch64.neon.fminv.f32.v4f32")
        },
        "minvq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F64x2]; &INPUTS },
            output: &::F64,
            definition: Named("llvm.aarch64.neon.fminv.f64.v2f64")
        },
        "maxnmv_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x2]; &INPUTS },
            output: &::F32,
            definition: Named("llvm.aarch64.neon.fmaxnmv.f32.v2f32")
        },
        "maxnmvq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x4]; &INPUTS },
            output: &::F32,
            definition: Named("llvm.aarch64.neon.fmaxnmv.f32.v4f32")
        },
        "maxnmvq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F64x2]; &INPUTS },
            output: &::F64,
            definition: Named("llvm.aarch64.neon.fmaxnmv.f64.v2f64")
        },
        "minnmv_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x2]; &INPUTS },
            output: &::F32,
            definition: Named("llvm.aarch64.neon.fminnmv.f32.v2f32")
        },
        "minnmvq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x4]; &INPUTS },
            output: &::F32,
            definition: Named("llvm.aarch64.neon.fminnmv.f32.v4f32")
        },
        "minnmvq_f64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F64x2]; &INPUTS },
            output: &::F64,
            definition: Named("llvm.aarch64.neon.fminnmv.f64.v2f64")
        },
        "qtbl1_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::U8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.tbl1.v8i8")
        },
        "qtbl1_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.tbl1.v8i8")
        },
        "qtbl1q_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::U8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.tbl1.v16i8")
        },
        "qtbl1q_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.tbl1.v16i8")
        },
        "qtbx1_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I8x8, &::I8x16, &::U8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.tbx1.v8i8")
        },
        "qtbx1_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x8, &::U8x16, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.tbx1.v8i8")
        },
        "qtbx1q_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I8x16, &::I8x16, &::U8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.tbx1.v16i8")
        },
        "qtbx1q_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x16, &::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.tbx1.v16i8")
        },
        "qtbl2_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.tbl2.v8i8")
        },
        "qtbl2_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.tbl2.v8i8")
        },
        "qtbl2q_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &PARTS }); &AGG }, &::U8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.tbl2.v16i8")
        },
        "qtbl2q_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &PARTS }); &AGG }, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.tbl2.v16i8")
        },
        "qtbx2_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.tbx2.v8i8")
        },
        "qtbx2_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.tbx2.v8i8")
        },
        "qtbx2q_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &PARTS }); &AGG }, &::U8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.tbx2.v16i8")
        },
        "qtbx2q_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &PARTS }); &AGG }, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.tbx2.v16i8")
        },
        "qtbl3_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 3] = [&::I8x16, &::I8x16, &::I8x16]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.tbl3.v8i8")
        },
        "qtbl3_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 3] = [&::U8x16, &::U8x16, &::U8x16]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.tbl3.v8i8")
        },
        "qtbl3q_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 3] = [&::I8x16, &::I8x16, &::I8x16]; &PARTS }); &AGG }, &::U8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.tbl3.v16i8")
        },
        "qtbl3q_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 3] = [&::U8x16, &::U8x16, &::U8x16]; &PARTS }); &AGG }, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.tbl3.v16i8")
        },
        "qtbx3_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I8x8, { static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 3] = [&::I8x16, &::I8x16, &::I8x16]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.tbx3.v8i8")
        },
        "qtbx3_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x8, { static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 3] = [&::U8x16, &::U8x16, &::U8x16]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.tbx3.v8i8")
        },
        "qtbx3q_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I8x16, { static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 3] = [&::I8x16, &::I8x16, &::I8x16]; &PARTS }); &AGG }, &::U8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.tbx3.v16i8")
        },
        "qtbx3q_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x16, { static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 3] = [&::U8x16, &::U8x16, &::U8x16]; &PARTS }); &AGG }, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.tbx3.v16i8")
        },
        "qtbl4_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 4] = [&::I8x16, &::I8x16, &::I8x16, &::I8x16]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.tbl4.v8i8")
        },
        "qtbl4_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 4] = [&::U8x16, &::U8x16, &::U8x16, &::U8x16]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.tbl4.v8i8")
        },
        "qtbl4q_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 4] = [&::I8x16, &::I8x16, &::I8x16, &::I8x16]; &PARTS }); &AGG }, &::U8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.tbl4.v16i8")
        },
        "qtbl4q_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 4] = [&::U8x16, &::U8x16, &::U8x16, &::U8x16]; &PARTS }); &AGG }, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.tbl4.v16i8")
        },
        "qtbx4_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I8x8, { static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 4] = [&::I8x16, &::I8x16, &::I8x16, &::I8x16]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.aarch64.neon.tbx4.v8i8")
        },
        "qtbx4_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x8, { static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 4] = [&::U8x16, &::U8x16, &::U8x16, &::U8x16]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.aarch64.neon.tbx4.v8i8")
        },
        "qtbx4q_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I8x16, { static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 4] = [&::I8x16, &::I8x16, &::I8x16, &::I8x16]; &PARTS }); &AGG }, &::U8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.aarch64.neon.tbx4.v16i8")
        },
        "qtbx4q_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x16, { static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 4] = [&::U8x16, &::U8x16, &::U8x16, &::U8x16]; &PARTS }); &AGG }, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.aarch64.neon.tbx4.v16i8")
        },
        _ => return None,
    })
}
