/*
* Test case inputs for: __uint128_t __fixunstfti (long double)
* Conversion from long double (IBM double-double) to 128 bit integer.
*/

#define INFINITY __builtin_inf()
#define QNAN __builtin_nan("")
#define INIT_U128(HI, LO) (((__uint128_t) (HI) << 64) | (LO))

struct testCase {
  double hiInput;
  double loInput;
  __uint128_t result128;
};

struct testCase testList[] = {
  { 0x0p+0, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000000000 ) },
  { -0x0p+0, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000000000 ) },
  { -0x0p+0, -0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000000000 ) },
  { 0x0p+0, -0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000000000 ) },
  { -0x1p+0, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000000000 ) },
  { 0x1p+0, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000000001 ) },
  { -INFINITY, 0x0p+0, ((__uint128_t)0x0000000000000000 << 64) | 0x0000000000000000 },
  { INFINITY, 0x0p+0, ((__uint128_t)0xffffffffffffffff << 64) | 0xffffffffffffffff },
  { QNAN, 0x0p+0, ((__uint128_t)0x7ff8000000000000 << 64) | 0x0000000000000000 },
  { -QNAN, 0x0p+0, ((__uint128_t)0x7ff8000000000000 << 64) | 0x0000000000000000 },
  { -0x1p+127, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000000000 ) },
  { 0x1p+127, -0x1p+0, INIT_U128( 0x7fffffffffffffff, 0xffffffffffffffff ) },
  { 0x1p+0, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000000001 ) },
  { 0x1p+60, 0x0p+0, INIT_U128( 0x0000000000000000, 0x1000000000000000 ) },
  { 0x1p+64, -0x1p+0, INIT_U128( 0x0000000000000000, 0xffffffffffffffff ) },
  { 0x1p+63, -0x1p+0, INIT_U128( 0x0000000000000000, 0x7fffffffffffffff ) },
  { 0x1p+64, 0x0p+0, INIT_U128( 0x0000000000000001, 0x0000000000000000 ) },
  { 0x1p+64, 0x1p+0, INIT_U128( 0x0000000000000001, 0x0000000000000001 ) },
  { 0x1.8p+64, -0x1p+0, INIT_U128( 0x0000000000000001, 0x7fffffffffffffff ) },
  { 0x1.1p+64, 0x0p+0, INIT_U128( 0x0000000000000001, 0x1000000000000000 ) },
  { 0x1p+65, -0x1p+0, INIT_U128( 0x0000000000000001, 0xffffffffffffffff ) },
  { 0x1p+127, -0x1p+64, INIT_U128( 0x7fffffffffffffff, 0x0000000000000000 ) },
  { 0x1p+127, -0x1.ep+64, INIT_U128( 0x7ffffffffffffffe, 0x2000000000000000 ) },
  { 0x1p+127, -0x1p+63, INIT_U128( 0x7fffffffffffffff, 0x8000000000000000 ) },
  { 0x1p+124, 0x0p+0, INIT_U128( 0x1000000000000000, 0x0000000000000000 ) },
  { 0x1p+124, 0x1p+0, INIT_U128( 0x1000000000000000, 0x0000000000000001 ) },
  { 0x1p+124, 0x1p+63, INIT_U128( 0x1000000000000000, 0x8000000000000000 ) },
  { 0x1p+124, 0x1p+64, INIT_U128( 0x1000000000000001, 0x0000000000000000 ) },
  { -0x1p+64, 0x0p+0, INIT_U128( 0x00000000000000000, 0x0000000000000000 ) },
  { 0x1.84p+70, 0x1.84p+6, INIT_U128( 0x0000000000000061, 0x0000000000000061 ) },
  { 0x1.5cp+6, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000000057 ) },
  { 0x1p+64, -0x1.88p+6, INIT_U128( 0x0000000000000000, 0xffffffffffffff9e ) },
  { 0x1.88p+6, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000000062 ) },
  { 0x1.00cp+10, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000000403 ) },
  { 0x1.fffffffffffffp+63, 0x1.fep+9, INIT_U128( 0x0000000000000000, 0xfffffffffffffbfc ) },
  { 0x1.028p+10, 0x0p+0, INIT_U128( 0x0000000000000000, 0x000000000000040a ) },
  { 0x1.44p+10, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000000510 ) },
  { 0x1.fffffffffffffp+63, 0x1.738p+9, INIT_U128( 0x0000000000000000, 0xfffffffffffffae7 ) },
  { 0x1.808p+10, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000000602 ) },
  { 0x1.fffffffffffffp+63, 0x1.fdp+8, INIT_U128( 0x0000000000000000, 0xfffffffffffff9fd ) },
  { 0x1.048p+13, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000002090 ) },
  { 0x1.ffffffffffffbp+63, 0x1.ed8p+9, INIT_U128( 0x0000000000000000, 0xffffffffffffdbdb ) },
  { 0x1.0101p+17, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000020202 ) },
  { 0x1.fffffffffffbep+63, -0x1.09p+8, INIT_U128( 0x0000000000000000, 0xfffffffffffdeef7 ) },
  { 0x1.9002p+17, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000032004 ) },
  { 0x1.fffffffffff9cp+63, -0x1.4p+2, INIT_U128( 0x0000000000000000, 0xfffffffffffcdffb ) },
  { 0x1.902p+17, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000032040 ) },
  { 0x1.ffffffffff7fcp+63, -0x1.14p+6, INIT_U128( 0x0000000000000000, 0xffffffffffbfdfbb ) },
  { 0x1.00822p+22, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000402088 ) },
  { 0x1.0010011p+31, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000080080088 ) },
  { 0x1.0a000001p+35, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000850000008 ) },
  { 0x1.000000224p+37, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000002000000448 ) },
  { 0x1.ffffffbffefb8p+63, -0x1p+0, INIT_U128( 0x0000000000000000, 0xffffffdfff7dbfff ) },
  { 0x1.00080044p+102, 0x1.00080044p+38, INIT_U128( 0x0000004002001100, 0x0000004002001100 ) },
  { 0x1.00400000018p+107, 0x1.00400000018p+43, INIT_U128( 0x000008020000000c, 0x000008020000000c ) },
  { 0x1.ffffeffcp+63, -0x1.ap+3, INIT_U128( 0x0000000000000000, 0xfffff7fdfffffff3 ) },
  { 0x1.000000001048p+47, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000800000000824 ) },
  { 0x1.fffbffffffp+63, -0x1.808p+9, INIT_U128( 0x0000000000000000, 0xfffdffffff7ffcff ) },
  { 0x1.000810004p+62, 0x0p+0, INIT_U128( 0x0000000000000000, 0x4002040010000000 ) },
  { 0x1.7ffbf7ffep+63, -0x1p+0, INIT_U128( 0x0000000000000000, 0xbffdfbffefffffff ) },
  { 0x1p+63, 0x0p+0, INIT_U128( 0x0000000000000000, 0x8000000000000000 ) },
  { 0x1.ffffffffe8319p+63, -0x1.1f8p+9, INIT_U128( 0x0000000000000000, 0xfffffffff418c5c1 ) },
  { 0x1p+68, -0x1p+0, INIT_U128( 0x000000000000000f, 0xffffffffffffffff ) },
  { 0x1p+72, -0x1p+0, INIT_U128( 0x00000000000000ff, 0xffffffffffffffff ) },
  { 0x1p+76, -0x1p+0, INIT_U128( 0x0000000000000fff, 0xffffffffffffffff ) },
  { 0x1p+80, -0x1p+0, INIT_U128( 0x000000000000ffff, 0xffffffffffffffff ) },
  { 0x1p+84, -0x1p+0, INIT_U128( 0x00000000000fffff, 0xffffffffffffffff ) },
  { 0x1p+88, -0x1p+0, INIT_U128( 0x0000000000ffffff, 0xffffffffffffffff ) },
  { 0x1p+92, -0x1p+0, INIT_U128( 0x000000000fffffff, 0xffffffffffffffff ) },
  { 0x1p+96, -0x1p+0, INIT_U128( 0x00000000ffffffff, 0xffffffffffffffff ) },
  { 0x1p+100, -0x1p+0, INIT_U128( 0x0000000fffffffff, 0xffffffffffffffff ) },
  { 0x1p+104, -0x1p+0, INIT_U128( 0x000000ffffffffff, 0xffffffffffffffff ) },
  { 0x1p+108, -0x1p+0, INIT_U128( 0x00000fffffffffff, 0xffffffffffffffff ) },
  { 0x1p+112, -0x1p+0, INIT_U128( 0x0000ffffffffffff, 0xffffffffffffffff ) },
  { 0x1p+116, -0x1p+0, INIT_U128( 0x000fffffffffffff, 0xffffffffffffffff ) },
  { 0x1p+120, -0x1p+0, INIT_U128( 0x00ffffffffffffff, 0xffffffffffffffff ) },
  { 0x1p+124, -0x1p+0, INIT_U128( 0x0fffffffffffffff, 0xffffffffffffffff ) },
  { 0x1p+124, 0x0p+0, INIT_U128( 0x1000000000000000, 0x0000000000000000 ) },
  { 0x1p+124, 0x1.1p+4, INIT_U128( 0x1000000000000000, 0x0000000000000011 ) },
  { 0x1p+124, 0x1.11p+8, INIT_U128( 0x1000000000000000, 0x0000000000000111 ) },
  { 0x1p+124, 0x1.111p+12, INIT_U128( 0x1000000000000000, 0x0000000000001111 ) },
  { 0x1p+124, 0x1.1111p+16, INIT_U128( 0x1000000000000000, 0x0000000000011111 ) },
  { 0x1p+124, 0x1.11111p+20, INIT_U128( 0x1000000000000000, 0x0000000000111111 ) },
  { 0x1p+124, 0x1.111111p+24, INIT_U128( 0x1000000000000000, 0x0000000001111111 ) },
  { 0x1p+124, 0x1.1111111p+28, INIT_U128( 0x1000000000000000, 0x0000000011111111 ) },
  { 0x1p+124, 0x1.11111111p+32, INIT_U128( 0x1000000000000000, 0x0000000111111111 ) },
  { 0x1p+124, 0x1.111111111p+36, INIT_U128( 0x1000000000000000, 0x0000001111111111 ) },
  { 0x1p+124, 0x1.1111111111p+40, INIT_U128( 0x1000000000000000, 0x0000011111111111 ) },
  { 0x1p+124, 0x1.11111111111p+44, INIT_U128( 0x1000000000000000, 0x0000111111111111 ) },
  { 0x1p+124, 0x1.111111111111p+48, INIT_U128( 0x1000000000000000, 0x0001111111111111 ) },
  { 0x1p+124, 0x1.1111111111111p+52, INIT_U128( 0x1000000000000000, 0x0011111111111111 ) },
  { 0x1p+124, 0x1.11111111111111p+56, INIT_U128( 0x1000000000000000, 0x0111111111111110 ) },
  { 0x1p+124, 0x1.111111111111111p+60, INIT_U128( 0x1000000000000000, 0x1111111111111100 ) },
  { 0x1.6ffffffefp+63, -0x1p+0, INIT_U128( 0x0000000000000000, 0xb7ffffff77ffffff ) },
  { 0x1p+106, 0x0p+0, INIT_U128( 0x0000040000000000, 0x0000000000000000 ) },
  { 0x1.ff8p+29, 0x0p+0, INIT_U128( 0x0000000000000000, 0x000000003ff00000 ) },
  { 0x1.6ff7ffffffffcp+63, -0x1p+0, INIT_U128( 0x0000000000000000, 0xb7fbffffffffdfff ) },
  { 0x1.2400000000004p+62, 0x0p+0, INIT_U128( 0x0000000000000000, 0x4900000000001000 ) },
  { 0x1.24000000001p+126, 0x1.24000000001p+62, INIT_U128( 0x4900000000040000, 0x4900000000040000 ) },
  { 0x1.2400001p+126, 0x1.2400001p+62, INIT_U128( 0x4900000400000000, 0x4900000400000000 ) },
  { 0x1.240001p+126, 0x1.240001p+62, INIT_U128( 0x4900004000000000, 0x4900004000000000 ) },
  { 0x1.24001p+126, 0x1.24001p+62, INIT_U128( 0x4900040000000000, 0x4900040000000000 ) },
  { 0x1.24008p+126, 0x1.24008p+62, INIT_U128( 0x4900200000000000, 0x4900200000000000 ) },
  { 0x1.2404p+126, 0x1.2404p+62, INIT_U128( 0x4901000000000000, 0x4901000000000000 ) },
  { 0x1.244p+126, 0x1.244p+62, INIT_U128( 0x4910000000000000, 0x4910000000000000 ) },
  { 0x1.26p+126, 0x1.26p+62, INIT_U128( 0x4980000000000000, 0x4980000000000000 ) },
  { 0x1.3p+126, 0x1.3p+62, INIT_U128( 0x4c00000000000000, 0x4c00000000000000 ) },
  { 0x1.800000000001p+126, 0x1.6000000000004p+64, INIT_U128( 0x6000000000004001, 0x6000000000004000 ) },
  { 0x1.cp+126, 0x1.00ep+71, INIT_U128( 0x7000000000000080, 0x7000000000000000 ) },
  { 0x1.c000000000008p+126, 0x1.c000000000008p+62, INIT_U128( 0x7000000000002000, 0x7000000000002000 ) },
  { 0x1.c00000000004p+126, 0x1.c00000000004p+62, INIT_U128( 0x7000000000010000, 0x7000000000010000 ) },
  { 0x1.c0000000002p+126, 0x1.c0000000002p+62, INIT_U128( 0x7000000000080000, 0x7000000000080000 ) },
  { 0x1.c000000002p+126, 0x1.c000000002p+62, INIT_U128( 0x7000000000800000, 0x7000000000800000 ) },
  { 0x1.c00000002p+126, 0x1.c00000002p+62, INIT_U128( 0x7000000008000000, 0x7000000008000000 ) },
  { 0x1.c0000008p+126, 0x1.c0000008p+62, INIT_U128( 0x7000000200000000, 0x7000000200000000 ) },
  { 0x1.c000002p+126, 0x1.c000002p+62, INIT_U128( 0x7000000800000000, 0x7000000800000000 ) },
  { 0x1.c00004p+126, 0x1.c00004p+62, INIT_U128( 0x7000010000000000, 0x7000010000000000 ) },
  { 0x1.c0002p+126, 0x1.c0002p+62, INIT_U128( 0x7000080000000000, 0x7000080000000000 ) },
  { 0x1.c008p+126, 0x1.c008p+62, INIT_U128( 0x7002000000000000, 0x7002000000000000 ) },
  { 0x1.c02p+126, 0x1.c02p+62, INIT_U128( 0x7008000000000000, 0x7008000000000000 ) },
  { 0x1.c2p+126, 0x1.c2p+62, INIT_U128( 0x7080000000000000, 0x7080000000000000 ) },
  { 0x1.dp+126, 0x1.dp+62, INIT_U128( 0x7400000000000000, 0x7400000000000000 ) },
  { 0x1.80be0cccccccdp+63, 0x1.80bc266666666p+63, INIT_U128( 0x0000000000000001, 0x80bd199999999800 ) },
  { 0x1.017c19999999ap+62, 0x1.01784cccccccdp+62, INIT_U128( 0x0000000000000000, 0x80bd199999999c00 ) },
  { 0x1.80be0cccccccdp+63, 0x1.01784cccccccdp+62, INIT_U128( 0x0000000000000001, 0x00bd199999999c00 ) },
  { 0x1.88a1831790ce8p+63, 0x1.1143062f219d8p+62, INIT_U128( 0x0000000000000001, 0x08a1831790cea000 ) },
  { 0x1.1143062f219dp+62, 0x1.88a1831790cecp+63, INIT_U128( 0x0000000000000001, 0x08a1831790cea000 ) },
  { 0x1.88a1831790ce8p+63, 0x1.88a1831790cecp+63, INIT_U128( 0x0000000000000001, 0x88a1831790cea000 ) },
  { 0x1.00014f3089001p+64, 0x1.e133333333333p+6, INIT_U128( 0x0000000000000001, 0x00014f3089001078 ) },
  { 0x1.fffffffffffffp+127, 0x1p+75, INIT_U128( 0x0000000000000000, 0x0000000000000000 ) },
  { 0x1.fffffffffffffp+127, 0x1.fffffffffffffp+74, INIT_U128( 0xFFFFFFFFFFFFFFFF, 0xFFFFFFFFFFC00000 ) },
  { 0x1.f066666666666p+6, -0x1.f066666666667p-768, INIT_U128( 0x0000000000000000, 0x000000000000007C ) },
  { 0x1.f066666666666p+6, 0x1.f066666666667p-768, INIT_U128( 0x0000000000000000, 0x000000000000007C ) },
  { 0x1.1111111111111p+124, 0x1.1p+68, INIT_U128( 0x1111111111111111, 0x0000000000000000 ) },
  { 0x0.0000000000001p-1022, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000000000 ) },
  { 0x0.0000001160e9fp-1022, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000000000 ) },
  { 0x0.0000001a26f3cp-1022, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000000000 ) },
  { -0x0.0000001134f35p-1022, -0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000000000 ) },
  { 0x0.00003f9eec3ep-1022, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000000000 ) },
  { 0x0.0a40bec0e4818p-1022, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000000000 ) },
  { 0x0.0d4e1fcc5a9c4p-1022, 0x0p+0, INIT_U128( 0x0000000000000000, 0x0000000000000000 ) },
  { 0x1.acf5f5ef59ebfp-1007, 0x0.00000000000a8p-1022, INIT_U128( 0x0000000000000000, 0x0000000000000000 ) },
  { 0x1.1f45384e3e8a7p-1007, 0x0.00000000000b4p-1022, INIT_U128( 0x0000000000000000, 0x0000000000000000 ) },
  { 0x1.8474983f08e93p-1007, 0x0.00000000000d9p-1022, INIT_U128( 0x0000000000000000, 0x0000000000000000 ) },
  { 0x1.47ad6cf88f5aep-1007, 0x0.00000000000bcp-1022, INIT_U128( 0x0000000000000000, 0x0000000000000000 ) },
  { 0x1.2da4480a5b489p-1, 0x1.9e20ea6f3c41dp-618, INIT_U128( 0x0000000000000000, 0x0000000000000000 ) },
  { 0x1.438fba0a871f8p+0, 0x1.086e1f6e10dc4p-992, INIT_U128( 0x0000000000000000, 0x0000000000000001 ) },
  { 0x1.51c874cca390ep+0, 0x1.5dd30576bba6p-992, INIT_U128( 0x0000000000000000, 0x0000000000000001 ) },
  { 0x1.3691a8086d235p+1, 0x1.3670ebb66ce1ep-281, INIT_U128( 0x0000000000000000, 0x0000000000000002 ) },
  { 0x1.b800c73570019p+1, 0x1.1bf9094c37f21p-281, INIT_U128( 0x0000000000000000, 0x0000000000000003 ) },
  { 0x1.c1e89f3783d14p+1, 0x1.69999266d3332p-281, INIT_U128( 0x0000000000000000, 0x0000000000000003 ) },
  { 0x1.390b19fa72163p+1, 0x1.25bf7f6c4b7fp-281, INIT_U128( 0x0000000000000000, 0x0000000000000002 ) },
  { 0x1.4beee12897ddcp+2, 0x1.549d853aa93bp-815, INIT_U128( 0x0000000000000000, 0x0000000000000005 ) },
  { 0x1.e37742bfc6ee9p+2, 0x1.081a6dda1034ep-815, INIT_U128( 0x0000000000000000, 0x0000000000000007 ) },
  { 0x1.e6c0b50fcd816p+2, 0x1.c3d7967b87af3p-815, INIT_U128( 0x0000000000000000, 0x0000000000000007 ) },
  { 0x1.590290feb2052p+2, 0x1.07756f600eeaep-815, INIT_U128( 0x0000000000000000, 0x0000000000000005 ) },
  { 0x1.66154348cc2a8p+3, 0x1.bb93d1a97727ap-619, INIT_U128( 0x0000000000000000, 0x000000000000000b ) },
  { 0x1.69cf9e9ed39f4p+3, 0x1.ce842e739d086p-619, INIT_U128( 0x0000000000000000, 0x000000000000000b ) },
  { 0x1.e884574bd108bp+3, 0x1.9c6561f338cacp-619, INIT_U128( 0x0000000000000000, 0x000000000000000f ) },
  { 0x1.6263a430c4c74p+4, 0x1.6b327792d664fp-117, INIT_U128( 0x0000000000000000, 0x0000000000000016 ) },
  { 0x1.43637d1286c7p+4, 0x1.546df60aa8dbfp-117, INIT_U128( 0x0000000000000000, 0x0000000000000014 ) },
  { 0x1.faa21259f5443p+4, 0x1.b6708ecf6ce12p-117, INIT_U128( 0x0000000000000000, 0x000000000000001f ) },
  { 0x1.fd3105d1fa62p+4, 0x1.370912046e122p-117, INIT_U128( 0x0000000000000000, 0x000000000000001f ) },
  { 0x1.cf952d399f2a5p+5, 0x1.0d283ebe1a508p-735, INIT_U128( 0x0000000000000000, 0x0000000000000039 ) },
  { 0x1.6ac8f880d591fp+5, 0x1.ec284da5d8509p-735, INIT_U128( 0x0000000000000000, 0x000000000000002d ) },
  { 0x1.919c82bf2339p+5, 0x1.a58971fd4b12ep-735, INIT_U128( 0x0000000000000000, 0x0000000000000032 ) },
  { 0x1.789a89ccf1351p+5, 0x1.ebd48283d7a91p-735, INIT_U128( 0x0000000000000000, 0x000000000000002f ) },
  { 0x1.8db2068d1b641p+6, 0x1.056174ca0ac2ep-802, INIT_U128( 0x0000000000000000, 0x0000000000000063 ) },
  { 0x1.8d618e6f1ac32p+6, 0x1.0643da660c87cp-802, INIT_U128( 0x0000000000000000, 0x0000000000000063 ) },
  { 0x1.f10fc45fe21f8p+6, 0x1.d71f2d6bae3e5p-802, INIT_U128( 0x0000000000000000, 0x000000000000007c ) },
  { 0x1.1cafcb76395fap+8, 0x1.026dfe9a04dcp-78, INIT_U128( 0x0000000000000000, 0x000000000000011c ) },
  { 0x1.8b9a3b5917348p+8, 0x1.f64ef081ec9dep-78, INIT_U128( 0x0000000000000000, 0x000000000000018b ) },
  { 0x1.347ea22c68fd4p+8, 0x1.a86c77e750d8fp-78, INIT_U128( 0x0000000000000000, 0x0000000000000134 ) },
  { 0x1.c498c82389319p+8, 0x1.0d4d96061a9b3p-78, INIT_U128( 0x0000000000000000, 0x00000000000001c4 ) },
  { 0x1.3e4fa8b47c9f5p+9, 0x1.d0718139a0e3p-293, INIT_U128( 0x0000000000000000, 0x000000000000027c ) },
  { 0x1.5ffd3878bffa7p+9, 0x1.1828a29c30514p-293, INIT_U128( 0x0000000000000000, 0x00000000000002bf ) },
  { 0x1.bbbb3b8577768p+9, 0x1.ba79b21b74f36p-293, INIT_U128( 0x0000000000000000, 0x0000000000000377 ) },
  { 0x1.8777cb810eefap+9, 0x1.bb3afdc57676p-293, INIT_U128( 0x0000000000000000, 0x000000000000030e ) },
  { 0x1.8e7992a11cf32p+10, 0x1.a18e4033431c8p-789, INIT_U128( 0x0000000000000000, 0x0000000000000639 ) },
  { 0x1.7684faeced0ap+10, 0x1.5f11706abe22ep-789, INIT_U128( 0x0000000000000000, 0x00000000000005da ) },
  { 0x1.7d7ac11afaf58p+10, 0x1.64553beec8aa8p-789, INIT_U128( 0x0000000000000000, 0x00000000000005f5 ) },
  { 0x1.a540fa454a81fp+10, 0x1.329efbd6653ep-789, INIT_U128( 0x0000000000000000, 0x0000000000000695 ) },
  { 0x1.92ed812325dbp+11, 0x0.000012eafc716p-1022, INIT_U128( 0x0000000000000000, 0x0000000000000c97 ) },
  { 0x1.b10abb4562158p+11, 0x0.00001e4765564p-1022, INIT_U128( 0x0000000000000000, 0x0000000000000d88 ) },
  { 0x1.f6751879ecea3p+11, 0x0.000014435b4b9p-1022, INIT_U128( 0x0000000000000000, 0x0000000000000fb3 ) },
  { 0x1.32e6b0a465cd6p+11, 0x0.00001729d5c09p-1022, INIT_U128( 0x0000000000000000, 0x0000000000000997 ) },
  { 0x1.11f336c623e67p+12, 0x1.9d9af61f3b35fp-489, INIT_U128( 0x0000000000000000, 0x000000000000111f ) },
  { 0x1.18ebab5631d76p+12, 0x1.47d8de9e8fb1cp-489, INIT_U128( 0x0000000000000000, 0x000000000000118e ) },
  { 0x1.c25a29f984b45p+12, 0x1.c65b51e78cb6ap-489, INIT_U128( 0x0000000000000000, 0x0000000000001c25 ) },
  { 0x1.cf37f3299e6ffp+12, 0x1.38601ed270c04p-489, INIT_U128( 0x0000000000000000, 0x0000000000001cf3 ) },
  { 0x1.00db141c01b62p+13, 0x1.a4ea801149d5p-963, INIT_U128( 0x0000000000000000, 0x000000000000201b ) },
  { 0x1.b81f3643703e7p+13, 0x1.849a11a509342p-963, INIT_U128( 0x0000000000000000, 0x0000000000003703 ) },
  { 0x1.6dbbb6a4db777p+13, 0x1.362f46546c5e9p-963, INIT_U128( 0x0000000000000000, 0x0000000000002db7 ) },
  { 0x1.eeb645abdd6c8p+13, 0x1.1edee6683dbddp-963, INIT_U128( 0x0000000000000000, 0x0000000000003dd6 ) },
  { 0x1.dc7ac6d3b8f59p+14, 0x1.3a4d2846749a5p-96, INIT_U128( 0x0000000000000000, 0x000000000000771e ) },
  { 0x1.51b38df4a3672p+14, 0x1.ef5f5533debeap-96, INIT_U128( 0x0000000000000000, 0x000000000000546c ) },
  { 0x1.5cdcee10b9b9ep+14, 0x1.dd44c049ba898p-96, INIT_U128( 0x0000000000000000, 0x0000000000005737 ) },
  { 0x1.f5266d45ea4cdp+14, 0x1.3970615e72e0cp-96, INIT_U128( 0x0000000000000000, 0x0000000000007d49 ) },
  { 0x1.2ab9252a55724p+15, 0x1.a85ba3d950b74p-690, INIT_U128( 0x0000000000000000, 0x000000000000955c ) },
  { 0x1.707a4edee0f4ap+15, 0x1.00541f2800a84p-690, INIT_U128( 0x0000000000000000, 0x000000000000b83d ) },
  { 0x1.594c6252b298cp+15, 0x1.837b6c0706f6ep-690, INIT_U128( 0x0000000000000000, 0x000000000000aca6 ) },
  { 0x1.41fad8e683f5bp+15, 0x1.7cb3a2bef9674p-690, INIT_U128( 0x0000000000000000, 0x000000000000a0fd ) },
  { 0x1.f150e9b3e2a1dp+16, 0x1.155a86a62ab51p-762, INIT_U128( 0x0000000000000000, 0x000000000001f150 ) },
  { 0x1.0a3ca44214794p+16, 0x1.5c85e07eb90bcp-762, INIT_U128( 0x0000000000000000, 0x0000000000010a3c ) },
  { 0x1.0ef4814e1de9p+16, 0x1.2cd0510659a0ap-762, INIT_U128( 0x0000000000000000, 0x0000000000010ef4 ) },
  { 0x1.99373a97326e7p+16, 0x1.98d239d731a47p-762, INIT_U128( 0x0000000000000000, 0x0000000000019937 ) },
  { 0x1.0062da5400c5cp+17, 0x1.12b3124825662p-940, INIT_U128( 0x0000000000000000, 0x00000000000200c5 ) },
  { 0x1.8ac0f0251581ep+17, 0x1.60b254d0c164ap-940, INIT_U128( 0x0000000000000000, 0x0000000000031581 ) },
  { 0x1.51c0eb94a381ep+17, 0x1.ce1da4059c3b4p-940, INIT_U128( 0x0000000000000000, 0x000000000002a381 ) },
  { 0x1.5e83e6a4bd07dp+17, 0x1.adcff7815b9ffp-940, INIT_U128( 0x0000000000000000, 0x000000000002bd07 ) },
  { 0x1.242e55bc485cap+18, 0x0.000000000001fp-1022, INIT_U128( 0x0000000000000000, 0x00000000000490b9 ) },
  { 0x1.7d59ac2cfab36p+18, 0x0.000000000001p-1022, INIT_U128( 0x0000000000000000, 0x000000000005f566 ) },
  { 0x1.d19e6101a33ccp+18, 0x0.0000000000014p-1022, INIT_U128( 0x0000000000000000, 0x0000000000074679 ) },
  { 0x1.34c9981869933p+18, 0x0.0000000000011p-1022, INIT_U128( 0x0000000000000000, 0x000000000004d326 ) },
  { 0x1.c066e34f80cddp+19, 0x1.e3f363b5c7e6dp-881, INIT_U128( 0x0000000000000000, 0x00000000000e0337 ) },
  { 0x1.df32bc2fbe658p+19, 0x1.df947163bf28ep-881, INIT_U128( 0x0000000000000000, 0x00000000000ef995 ) },
  { 0x1.3bbc859e7779p+19, 0x1.0773506c0ee6ap-881, INIT_U128( 0x0000000000000000, 0x000000000009dde4 ) },
  { 0x1.3b65fdae76ccp+19, 0x1.36924fde6d24ap-881, INIT_U128( 0x0000000000000000, 0x000000000009db2f ) },
  { 0x1.52c7a810a58f5p+20, 0x1.a11a939f42352p-561, INIT_U128( 0x0000000000000000, 0x0000000000152c7a ) },
  { 0x1.9546ee252a8dep+20, 0x1.eeb4a28ddd695p-561, INIT_U128( 0x0000000000000000, 0x000000000019546e ) },
  { 0x1.f50465bdea08cp+20, 0x1.7288f4c2e511ep-561, INIT_U128( 0x0000000000000000, 0x00000000001f5046 ) },
  { 0x1.b8199d2770334p+20, 0x1.a2d4ddfb45a9cp-561, INIT_U128( 0x0000000000000000, 0x00000000001b8199 ) },
  { 0x1.efe67d0fdfccfp+21, 0x1.05ac37920b587p-121, INIT_U128( 0x0000000000000000, 0x00000000003dfccf ) },
  { 0x1.a1c8a86343915p+21, 0x1.ff7f144bfefe2p-121, INIT_U128( 0x0000000000000000, 0x0000000000343915 ) },
  { 0x1.0b3b76001676fp+21, 0x1.742fba58e85f8p-121, INIT_U128( 0x0000000000000000, 0x000000000021676e ) },
  { 0x1.cb12f6579625fp+21, 0x1.5e77e020bcefcp-121, INIT_U128( 0x0000000000000000, 0x000000000039625e ) },
  { 0x1.bd380f437a702p+22, 0x1.491fe5e8923fcp-995, INIT_U128( 0x0000000000000000, 0x00000000006f4e03 ) },
  { 0x1.46fbb89c8df77p+22, 0x1.a09fc8f7413f9p-995, INIT_U128( 0x0000000000000000, 0x000000000051beee ) },
  { 0x1.17e871f42fd0ep+22, 0x1.a11fc1a7423f8p-995, INIT_U128( 0x0000000000000000, 0x000000000045fa1c ) },
  { 0x1.277e999a4efd3p+22, 0x1.4bd3e11097a7cp-995, INIT_U128( 0x0000000000000000, 0x000000000049dfa6 ) },
  { 0x1.6e4d3250dc9a6p+23, 0x1.edf09145dbe12p-447, INIT_U128( 0x0000000000000000, 0x0000000000b72699 ) },
  { 0x1.eb0413bfd6083p+23, 0x1.29c840b053908p-447, INIT_U128( 0x0000000000000000, 0x0000000000f58209 ) },
  { 0x1.283f1d32507e4p+23, 0x1.06daa0fe0db54p-447, INIT_U128( 0x0000000000000000, 0x0000000000941f8e ) },
  { 0x1.cf7790bd9eef2p+23, 0x1.22ebe99845d7dp-447, INIT_U128( 0x0000000000000000, 0x0000000000e7bbc8 ) },
  { 0x1.39fb1e1473f64p+24, 0x1.baafa729755f5p-263, INIT_U128( 0x0000000000000000, 0x000000000139fb1e ) },
  { 0x1.553510f0aa6a2p+24, 0x1.806a3d5d00d48p-263, INIT_U128( 0x0000000000000000, 0x0000000001553510 ) },
  { 0x1.876715390ece3p+24, 0x1.cdf668119becdp-263, INIT_U128( 0x0000000000000000, 0x0000000001876715 ) },
  { 0x1.11816ac62302ep+24, 0x1.5e8451ecbd08ap-263, INIT_U128( 0x0000000000000000, 0x000000000111816a ) },
  { 0x1.3e7e811e7cfdp+25, 0x1.2dc6a5685b8d4p-155, INIT_U128( 0x0000000000000000, 0x00000000027cfd02 ) },
  { 0x1.6ebc2c8cdd786p+25, 0x1.22f38cd645e72p-155, INIT_U128( 0x0000000000000000, 0x0000000002dd7859 ) },
  { 0x1.421ccf068439ap+25, 0x1.bef8b6f57df17p-155, INIT_U128( 0x0000000000000000, 0x000000000284399e ) },
  { 0x1.e10ee555c21dcp+25, 0x1.033cdd7a0679cp-155, INIT_U128( 0x0000000000000000, 0x0000000003c21dca ) },
  { 0x1.f0b6e7ede16ddp+26, 0x1.bc0a81517815p-634, INIT_U128( 0x0000000000000000, 0x0000000007c2db9f ) },
  { 0x1.f7b66dc5ef6cdp+26, 0x1.2bd3184a57a63p-634, INIT_U128( 0x0000000000000000, 0x0000000007ded9b7 ) },
  { 0x1.259706244b2e1p+26, 0x1.8b7dd07716fbap-634, INIT_U128( 0x0000000000000000, 0x0000000004965c18 ) },
  { 0x1.fdf5519ffbeaap+26, 0x1.19d4925433a92p-634, INIT_U128( 0x0000000000000000, 0x0000000007f7d546 ) },
  { 0x1.bb13b1d776276p+27, 0x1.e509cb23ca13ap-395, INIT_U128( 0x0000000000000000, 0x000000000dd89d8e ) },
  { 0x1.20754b2a40eaap+27, 0x1.bcc8cd6b7991ap-395, INIT_U128( 0x0000000000000000, 0x000000000903aa59 ) },
  { 0x1.dc036999b806dp+27, 0x1.62b438eec5687p-395, INIT_U128( 0x0000000000000000, 0x000000000ee01b4c ) },
  { 0x1.92b76e3d256eep+27, 0x1.33f6413067ec8p-395, INIT_U128( 0x0000000000000000, 0x000000000c95bb71 ) },
  { 0x1.7a6c4408f4d88p+28, 0x1.0f6d05b41edap-716, INIT_U128( 0x0000000000000000, 0x0000000017a6c440 ) },
  { 0x1.25d2c9ae4ba59p+28, 0x1.005f5a6a00becp-716, INIT_U128( 0x0000000000000000, 0x00000000125d2c9a ) },
  { 0x1.c8949d0b91293p+28, 0x1.6e7ca504dcf94p-716, INIT_U128( 0x0000000000000000, 0x000000001c8949d0 ) },
  { 0x1.21af1f7a435e4p+28, 0x1.98e05ef731c0cp-716, INIT_U128( 0x0000000000000000, 0x00000000121af1f7 ) },
  { 0x1.307b63f060f6cp+29, 0x1.17d4949a2fa92p-112, INIT_U128( 0x0000000000000000, 0x00000000260f6c7e ) },
  { 0x1.053d62740a7acp+29, 0x1.a8881e6551104p-112, INIT_U128( 0x0000000000000000, 0x0000000020a7ac4e ) },
  { 0x1.9b60d35b36c1ap+29, 0x1.005bb09600b76p-112, INIT_U128( 0x0000000000000000, 0x00000000336c1a6b ) },
  { 0x1.3ba73afe774e8p+29, 0x1.0efca74e1df95p-112, INIT_U128( 0x0000000000000000, 0x000000002774e75f ) },
  { 0x1.dd796675baf2dp+30, 0x1.aaba00775574p-990, INIT_U128( 0x0000000000000000, 0x00000000775e599d ) },
  { 0x1.8b282c8d16506p+30, 0x1.4e04f8449c09fp-990, INIT_U128( 0x0000000000000000, 0x0000000062ca0b23 ) },
  { 0x1.7d6ab930fad57p+30, 0x1.764a6e3cec94ep-990, INIT_U128( 0x0000000000000000, 0x000000005f5aae4c ) },
  { 0x1.6906027cd20cp+30, 0x1.d5b4ef4dab69ep-990, INIT_U128( 0x0000000000000000, 0x000000005a41809f ) },
  { 0x1.04a9da360953cp+31, 0x1.6c11a2e4d8234p-857, INIT_U128( 0x0000000000000000, 0x000000008254ed1b ) },
  { 0x1.fbba6e93f774ep+31, 0x1.0e9a6e5c1d34ep-857, INIT_U128( 0x0000000000000000, 0x00000000fddd3749 ) },
  { 0x1.380b108470162p+31, 0x1.65c0e5f6cb81cp-857, INIT_U128( 0x0000000000000000, 0x000000009c058842 ) },
  { 0x1.050dfc000a1cp+31, 0x1.1df2fc803be6p-857, INIT_U128( 0x0000000000000000, 0x000000008286fe00 ) },
  { 0x1.88bf9e1d117f4p+32, 0x1.8dd4aa1b1ba95p-126, INIT_U128( 0x0000000000000000, 0x0000000188bf9e1d ) },
  { 0x1.8b35d7ff166bbp+32, 0x1.91ca210923944p-126, INIT_U128( 0x0000000000000000, 0x000000018b35d7ff ) },
  { 0x1.286a366250d47p+32, 0x1.012c86ac02591p-126, INIT_U128( 0x0000000000000000, 0x00000001286a3662 ) },
  { 0x1.ef233cd5de467p+32, 0x1.2292a62645255p-126, INIT_U128( 0x0000000000000000, 0x00000001ef233cd5 ) },
  { 0x1.917a959722f53p+33, 0x1.85a7d93f0b4fbp-478, INIT_U128( 0x0000000000000000, 0x0000000322f52b2e ) },
  { 0x1.f630053bec6p+33, 0x1.f79a5227ef34bp-478, INIT_U128( 0x0000000000000000, 0x00000003ec600a77 ) },
  { 0x1.1a062b14340c6p+33, 0x1.21179acc422f4p-478, INIT_U128( 0x0000000000000000, 0x00000002340c5628 ) },
  { 0x1.d62acf15ac55ap+33, 0x1.bf1cd2697e39ap-478, INIT_U128( 0x0000000000000000, 0x00000003ac559e2b ) },
  { 0x1.823ddfaf047bcp+34, 0x1.e2d35df1c5a6cp-649, INIT_U128( 0x0000000000000000, 0x0000000608f77ebc ) },
  { 0x1.996ef6e332ddfp+34, 0x1.7af28278f5e5p-649, INIT_U128( 0x0000000000000000, 0x0000000665bbdb8c ) },
  { 0x1.81a2bfc703458p+34, 0x1.acc15cd15982cp-649, INIT_U128( 0x0000000000000000, 0x00000006068aff1c ) },
  { 0x1.4517e98e8a2fdp+34, 0x1.a3233fc546468p-649, INIT_U128( 0x0000000000000000, 0x00000005145fa63a ) },
  { 0x1.09f551a013eaap+35, 0x0.0000000000006p-1022, INIT_U128( 0x0000000000000000, 0x000000084faa8d00 ) },
  { 0x1.a2911b3d45224p+35, 0x0.0000000000005p-1022, INIT_U128( 0x0000000000000000, 0x0000000d1488d9ea ) },
  { 0x1.77a301deef46p+35, 0x0.0000000000008p-1022, INIT_U128( 0x0000000000000000, 0x0000000bbd180ef7 ) },
  { 0x1.f60ea85fec1d5p+35, 0x0.0000000000006p-1022, INIT_U128( 0x0000000000000000, 0x0000000fb07542ff ) },
  { 0x1.75c28ed8eb852p+36, 0x1.64300234c86p-938, INIT_U128( 0x0000000000000000, 0x000000175c28ed8e ) },
  { 0x1.394f8bae729f2p+36, 0x1.2119204042324p-938, INIT_U128( 0x0000000000000000, 0x0000001394f8bae7 ) },
  { 0x1.94d6bc7929ad8p+36, 0x1.4a8aa2aa95154p-938, INIT_U128( 0x0000000000000000, 0x000000194d6bc792 ) },
  { 0x1.1f519dcc3ea34p+36, 0x1.b4fbc9c969f79p-938, INIT_U128( 0x0000000000000000, 0x00000011f519dcc3 ) },
  { 0x1.bb2fb46f765f6p+37, 0x1.cd4047139a809p-718, INIT_U128( 0x0000000000000000, 0x0000003765f68dee ) },
  { 0x1.f80989d1f0131p+37, 0x1.c0546f4180a8ep-718, INIT_U128( 0x0000000000000000, 0x0000003f01313a3e ) },
  { 0x1.90be9171217d2p+37, 0x1.bcc6089d798c1p-718, INIT_U128( 0x0000000000000000, 0x0000003217d22e24 ) },
  { 0x1.37469d226e8d4p+37, 0x1.06aff8000d5ffp-718, INIT_U128( 0x0000000000000000, 0x00000026e8d3a44d ) },
  { 0x1.2e0114905c022p+38, 0x1.298bde145317cp-115, INIT_U128( 0x0000000000000000, 0x0000004b80452417 ) },
  { 0x1.77354c42ee6aap+38, 0x1.d9a75513b34eap-115, INIT_U128( 0x0000000000000000, 0x0000005dcd5310bb ) },
  { 0x1.0881a80c11035p+38, 0x1.44e5e01889cbcp-115, INIT_U128( 0x0000000000000000, 0x00000042206a0304 ) },
  { 0x1.a32b590f4656bp+38, 0x1.760fbd2eec1f8p-115, INIT_U128( 0x0000000000000000, 0x00000068cad643d1 ) },
  { 0x1.e7bc6861cf78dp+39, 0x1.72addca8e55bcp-767, INIT_U128( 0x0000000000000000, 0x000000f3de3430e7 ) },
  { 0x1.e1e11b1bc3c24p+39, 0x1.713729dae26e5p-767, INIT_U128( 0x0000000000000000, 0x000000f0f08d8de1 ) },
  { 0x1.8bbb377f17767p+39, 0x1.c296d213852dap-767, INIT_U128( 0x0000000000000000, 0x000000c5dd9bbf8b ) },
  { 0x1.7cb13d18f9628p+39, 0x1.8dcf87351b9f1p-767, INIT_U128( 0x0000000000000000, 0x000000be589e8c7c ) },
  { 0x1.1ddbaf383bb76p+40, 0x1.20c8d9d04191bp-497, INIT_U128( 0x0000000000000000, 0x0000011ddbaf383b ) },
  { 0x1.fde474e3fbc8ep+40, 0x1.7e6de35afcdbcp-497, INIT_U128( 0x0000000000000000, 0x000001fde474e3fb ) },
  { 0x1.02a202b00544p+40, 0x1.311b40f462368p-497, INIT_U128( 0x0000000000000000, 0x00000102a202b005 ) },
  { 0x1.ec0b6577d816cp+40, 0x1.8e49e85d1c93dp-497, INIT_U128( 0x0000000000000000, 0x000001ec0b6577d8 ) },
  { 0x1.95fa4b912bf4ap+41, 0x1.295d953652bb2p-872, INIT_U128( 0x0000000000000000, 0x0000032bf4972257 ) },
  { 0x1.fd243093fa486p+41, 0x1.91e0a45723c14p-872, INIT_U128( 0x0000000000000000, 0x000003fa486127f4 ) },
  { 0x1.d0beeb21a17dep+41, 0x1.97f98e272ff32p-872, INIT_U128( 0x0000000000000000, 0x000003a17dd64342 ) },
  { 0x1.750735faea0e6p+41, 0x1.97a4c8c92f499p-872, INIT_U128( 0x0000000000000000, 0x000002ea0e6bf5d4 ) },
  { 0x1.ab409c8f56814p+42, 0x1.1e820fc23d042p-84, INIT_U128( 0x0000000000000000, 0x000006ad02723d5a ) },
  { 0x1.85e79a910bcf3p+42, 0x1.75d44930eba89p-84, INIT_U128( 0x0000000000000000, 0x000006179e6a442f ) },
  { 0x1.e2fa47dfc5f49p+42, 0x1.f91c1067f2382p-84, INIT_U128( 0x0000000000000000, 0x0000078be91f7f17 ) },
  { 0x1.ecaf7567d95eep+42, 0x1.dd787be3baf1p-84, INIT_U128( 0x0000000000000000, 0x000007b2bdd59f65 ) },
  { 0x1.4fd770a89faeep+43, 0x1.883956a11072bp-669, INIT_U128( 0x0000000000000000, 0x00000a7ebb8544fd ) },
  { 0x1.b2b2aa2d65655p+43, 0x1.0c2516f2184a3p-669, INIT_U128( 0x0000000000000000, 0x00000d9595516b2b ) },
  { 0x1.5848b5b4b0916p+43, 0x1.d9a0d8cfb341bp-669, INIT_U128( 0x0000000000000000, 0x00000ac245ada584 ) },
  { 0x1.be7daa1f7cfb5p+43, 0x1.f0c9d223e193bp-669, INIT_U128( 0x0000000000000000, 0x00000df3ed50fbe7 ) },
  { 0x1.3f6d46f07eda9p+44, 0x1.3d2fa1b27a5f4p-539, INIT_U128( 0x0000000000000000, 0x000013f6d46f07ed ) },
  { 0x1.5eb8dcaebd71cp+44, 0x1.8e170e7b1c2e2p-539, INIT_U128( 0x0000000000000000, 0x000015eb8dcaebd7 ) },
  { 0x1.893b63631276cp+44, 0x1.9447ca53288f9p-539, INIT_U128( 0x0000000000000000, 0x00001893b6363127 ) },
  { 0x1.4e089b389c114p+44, 0x1.d191b053a3236p-539, INIT_U128( 0x0000000000000000, 0x000014e089b389c1 ) },
  { 0x1.2e36d90e5c6dbp+45, 0x1.314d394c629a7p-889, INIT_U128( 0x0000000000000000, 0x000025c6db21cb8d ) },
  { 0x1.7f784de4fef0ap+45, 0x1.5413e986a827dp-889, INIT_U128( 0x0000000000000000, 0x00002fef09bc9fde ) },
  { 0x1.74448388e889p+45, 0x1.752c3c2cea588p-889, INIT_U128( 0x0000000000000000, 0x00002e8890711d11 ) },
  { 0x1.ebb20c51d7641p+45, 0x1.50a52f7ca14a6p-889, INIT_U128( 0x0000000000000000, 0x00003d76418a3aec ) },
  { 0x1.4b51066896a21p+46, 0x1.d43cc973a8799p-550, INIT_U128( 0x0000000000000000, 0x000052d4419a25a8 ) },
  { 0x1.070f0d280e1e2p+46, 0x1.c25aa6dd84b55p-550, INIT_U128( 0x0000000000000000, 0x000041c3c34a0387 ) },
  { 0x1.7f735ca4fee6cp+46, 0x1.a92889d752511p-550, INIT_U128( 0x0000000000000000, 0x00005fdcd7293fb9 ) },
  { 0x1.72ed987ae5db3p+46, 0x1.fae14a03f5c29p-550, INIT_U128( 0x0000000000000000, 0x00005cbb661eb976 ) },
  { 0x1.7352fdf0e6a6p+47, 0x1.1a64275034c85p-857, INIT_U128( 0x0000000000000000, 0x0000b9a97ef87353 ) },
  { 0x1.9f4b98f33e973p+47, 0x1.657b10c0caf62p-857, INIT_U128( 0x0000000000000000, 0x0000cfa5cc799f4b ) },
  { 0x1.b12eb79b625d7p+47, 0x1.4826ca96904dap-857, INIT_U128( 0x0000000000000000, 0x0000d8975bcdb12e ) },
  { 0x1.6148cbcac291ap+47, 0x1.8672a1ad0ce54p-857, INIT_U128( 0x0000000000000000, 0x0000b0a465e56148 ) },
  { 0x1.1df8159e3bf02p+48, 0x1.7c6dbd68f8db8p-407, INIT_U128( 0x0000000000000000, 0x00011df8159e3bf0 ) },
  { 0x1.d8e17545b1c2ep+48, 0x1.959fcc5f2b3fap-407, INIT_U128( 0x0000000000000000, 0x0001d8e17545b1c2 ) },
  { 0x1.ea57e075d4afcp+48, 0x1.56705400ace0ap-407, INIT_U128( 0x0000000000000000, 0x0001ea57e075d4af ) },
  { 0x1.d2aa9e99a5554p+48, 0x1.9ebcab993d796p-407, INIT_U128( 0x0000000000000000, 0x0001d2aa9e99a555 ) },
  { 0x1.4fe075a49fc0ep+49, 0x1.e950f533d2a1ep-694, INIT_U128( 0x0000000000000000, 0x00029fc0eb493f81 ) },
  { 0x1.a936db51526dcp+49, 0x1.8a1397df14273p-694, INIT_U128( 0x0000000000000000, 0x0003526db6a2a4db ) },
  { 0x1.138ce7682719dp+49, 0x1.7f879c76ff0f4p-694, INIT_U128( 0x0000000000000000, 0x00022719ced04e33 ) },
  { 0x1.21e981b043d3p+49, 0x1.eaefe1f3d5dfcp-694, INIT_U128( 0x0000000000000000, 0x000243d3036087a6 ) },
  { 0x1.793e9a3cf27d4p+50, 0x1.40169b90802d4p-934, INIT_U128( 0x0000000000000000, 0x0005e4fa68f3c9f5 ) },
  { 0x1.7e1caadcfc396p+50, 0x1.371020466e204p-934, INIT_U128( 0x0000000000000000, 0x0005f872ab73f0e5 ) },
  { 0x1.33a019d667403p+50, 0x1.9c77f7cb38effp-934, INIT_U128( 0x0000000000000000, 0x0004ce8067599d00 ) },
  { 0x1.b4966ecb692cep+50, 0x1.c4dd0f8989ba2p-934, INIT_U128( 0x0000000000000000, 0x0006d259bb2da4b3 ) },
  { 0x1.822ad9630455bp+51, 0x1.3fade6a07f5bdp-561, INIT_U128( 0x0000000000000000, 0x000c1156cb1822ad ) },
  { 0x1.3a77dd3c74efcp+51, 0x1.55dd3018abba6p-561, INIT_U128( 0x0000000000000000, 0x0009d3bee9e3a77e ) },
  { 0x1.d375773da6eafp+51, 0x1.ad40b9955a817p-561, INIT_U128( 0x0000000000000000, 0x000e9babb9ed3757 ) },
  { 0x1.16059bfe2c0b4p+51, 0x1.ff801c63ff003p-561, INIT_U128( 0x0000000000000000, 0x0008b02cdff1605a ) },
  { 0x1.af8f1e955f1e4p+52, 0x1.2c4cc4fa58998p-237, INIT_U128( 0x0000000000000000, 0x001af8f1e955f1e4 ) },
  { 0x1.579e5322af3cap+52, 0x1.e9974457d32e8p-237, INIT_U128( 0x0000000000000000, 0x001579e5322af3ca ) },
  { 0x1.2b9d921a573b2p+52, 0x1.d8798265b0f3p-237, INIT_U128( 0x0000000000000000, 0x0012b9d921a573b2 ) },
  { 0x1.b746d5596e8dbp+52, 0x1.a75bfc954eb8p-237, INIT_U128( 0x0000000000000000, 0x001b746d5596e8db ) },
  { 0x1.497ec4f092fd8p+53, 0x1.5c597ab2b8b3p-364, INIT_U128( 0x0000000000000000, 0x00292fd89e125fb0 ) },
  { 0x1.8a65536914caap+53, 0x1.958565492b0adp-364, INIT_U128( 0x0000000000000000, 0x00314caa6d229954 ) },
  { 0x1.11b7146c236e2p+53, 0x1.3154f5b662a9ep-364, INIT_U128( 0x0000000000000000, 0x002236e28d846dc4 ) },
  { 0x1.f71b5e7bee36cp+53, 0x1.efc7aa5ddf8f6p-364, INIT_U128( 0x0000000000000000, 0x003ee36bcf7dc6d8 ) },
  { 0x1.5a71157ab4e22p+54, 0x1.b4fd1c6b69fa4p-39, INIT_U128( 0x0000000000000000, 0x00569c455ead3888 ) },
  { 0x1.4ab52e26956a6p+54, 0x1.204833ee40906p-39, INIT_U128( 0x0000000000000000, 0x0052ad4b89a55a98 ) },
  { 0x1.7b9298b4f7253p+54, 0x1.084ca6f410995p-39, INIT_U128( 0x0000000000000000, 0x005ee4a62d3dc94c ) },
  { 0x1.8be06c0317c0ep+54, 0x1.9677f6df2ceffp-39, INIT_U128( 0x0000000000000000, 0x0062f81b00c5f038 ) },
  { 0x1.53534daca6a6ap+55, 0x1.af26be6f5e4d8p-905, INIT_U128( 0x0000000000000000, 0x00a9a9a6d6535350 ) },
  { 0x1.ee7424c1dce84p+55, 0x1.38a375387146ep-905, INIT_U128( 0x0000000000000000, 0x00f73a1260ee7420 ) },
  { 0x1.4275718484eaep+55, 0x1.693f342ed27e6p-905, INIT_U128( 0x0000000000000000, 0x00a13ab8c2427570 ) },
  { 0x1.4e48bc049c918p+55, 0x1.30d3b39661a76p-905, INIT_U128( 0x0000000000000000, 0x00a7245e024e48c0 ) },
  { 0x1.6fcb01f0df96p+56, 0x1.f3322f93e6646p-339, INIT_U128( 0x0000000000000000, 0x016fcb01f0df9600 ) },
  { 0x1.6f16f2e4de2dep+56, 0x1.b50cb2d16a196p-339, INIT_U128( 0x0000000000000000, 0x016f16f2e4de2de0 ) },
  { 0x1.6fcb3cb2df968p+56, 0x1.f7623e45eec48p-339, INIT_U128( 0x0000000000000000, 0x016fcb3cb2df9680 ) },
  { 0x1.a41a78314834fp+56, 0x1.ee812a93dd026p-339, INIT_U128( 0x0000000000000000, 0x01a41a78314834f0 ) },
  { 0x1.73544f7ce6a8ap+57, 0x1.fbf6a069f7ed4p-786, INIT_U128( 0x0000000000000000, 0x02e6a89ef9cd5140 ) },
  { 0x1.8d4beb3f1a97ep+57, 0x1.6f6e15a0dedc2p-786, INIT_U128( 0x0000000000000000, 0x031a97d67e352fc0 ) },
  { 0x1.70dfc328e1bf8p+57, 0x1.56963a34ad2c8p-786, INIT_U128( 0x0000000000000000, 0x02e1bf8651c37f00 ) },
  { 0x1.6e5e39acdcbc7p+57, 0x1.62dfb7d4c5bf7p-786, INIT_U128( 0x0000000000000000, 0x02dcbc7359b978e0 ) },
  { 0x1.10a375142146ep+58, 0x1.dde963f1bbd2cp-687, INIT_U128( 0x0000000000000000, 0x04428dd450851b80 ) },
  { 0x1.7eacb1acfd596p+58, 0x1.e59952a9cb32bp-687, INIT_U128( 0x0000000000000000, 0x05fab2c6b3f56580 ) },
  { 0x1.3f2bac4a7e576p+58, 0x1.d21ee367a43ddp-687, INIT_U128( 0x0000000000000000, 0x04fcaeb129f95d80 ) },
  { 0x1.be738acb7ce71p+58, 0x1.d4b6334fa96c7p-687, INIT_U128( 0x0000000000000000, 0x06f9ce2b2df39c40 ) },
  { 0x1.b322eff56645ep+59, 0x0.00000014b8158p-1022, INIT_U128( 0x0000000000000000, 0x0d99177fab322f00 ) },
  { 0x1.b8dfbdbd71bf8p+59, 0x0.00000010ac2d6p-1022, INIT_U128( 0x0000000000000000, 0x0dc6fdedeb8dfc00 ) },
  { 0x1.e45f6d33c8bedp+59, 0x0.0000001c79003p-1022, INIT_U128( 0x0000000000000000, 0x0f22fb699e45f680 ) },
  { 0x1.10c7106e218e2p+59, 0x0.0000001ea2457p-1022, INIT_U128( 0x0000000000000000, 0x08863883710c7100 ) },
  { 0x1.c48c230989185p+60, 0x1.a60d3fb34c1a8p-116, INIT_U128( 0x0000000000000000, 0x1c48c23098918500 ) },
  { 0x1.5e9345fabd268p+60, 0x1.4898e6d49131dp-116, INIT_U128( 0x0000000000000000, 0x15e9345fabd26800 ) },
  { 0x1.b56942576ad28p+60, 0x1.aff4a0655fe94p-116, INIT_U128( 0x0000000000000000, 0x1b56942576ad2800 ) },
  { 0x1.7f865930ff0cbp+60, 0x1.13a0876e27411p-116, INIT_U128( 0x0000000000000000, 0x17f865930ff0cb00 ) },
  { 0x1.ef482c31de906p+61, 0x1.43e655d887ccap-501, INIT_U128( 0x0000000000000000, 0x3de905863bd20c00 ) },
  { 0x1.9fa15a7d3f42bp+61, 0x1.b00fcc55601fap-501, INIT_U128( 0x0000000000000000, 0x33f42b4fa7e85600 ) },
  { 0x1.d2c465fda588dp+61, 0x1.98c2f6e73185fp-501, INIT_U128( 0x0000000000000000, 0x3a588cbfb4b11a00 ) },
  { 0x1.f038608de070cp+61, 0x1.7b4fa8a0f69f5p-501, INIT_U128( 0x0000000000000000, 0x3e070c11bc0e1800 ) },
  { 0x1.adfb2db35bf66p+62, 0x1.38efaf6271df6p+8, INIT_U128( 0x0000000000000000, 0x6b7ecb6cd6fd9938 ) },
  { 0x1.1679474c2cf29p+62, 0x1.ae04d7f95c09bp+8, INIT_U128( 0x0000000000000000, 0x459e51d30b3ca5ae ) },
  { 0x1.890c63b91218cp+62, 0x1.133030ac26606p+8, INIT_U128( 0x0000000000000000, 0x624318ee44863113 ) },
  { 0x1.08fc576811f8bp+62, 0x1.521d194ea43a3p+8, INIT_U128( 0x0000000000000000, 0x423f15da047e2d52 ) },
  { 0x1.5c2e1ea2b85c4p+63, 0x1.bbf1e79d77e3dp-836, INIT_U128( 0x0000000000000000, 0xae170f515c2e2000 ) },
  { 0x1.3a1d0742743a1p+63, 0x1.849ecbad093dap-836, INIT_U128( 0x0000000000000000, 0x9d0e83a13a1d0800 ) },
  { 0x1.ac698c2758d32p+63, 0x1.7a316edaf462ep-836, INIT_U128( 0x0000000000000000, 0xd634c613ac699000 ) },
  { 0x1.8542412f0a848p+63, 0x1.a53fa9cd4a7f5p-836, INIT_U128( 0x0000000000000000, 0xc2a1209785424000 ) },
  { 0x1.f526fb77ea4ep+64, 0x1.170327882e065p-848, INIT_U128( 0x0000000000000001, 0xf526fb77ea4e0000 ) },
  { 0x1.acca54155994ap+64, 0x1.4c44fdb4988ap-848, INIT_U128( 0x0000000000000001, 0xacca54155994a000 ) },
  { 0x1.b47ed77768fdbp+64, 0x1.e6883245cd107p-848, INIT_U128( 0x0000000000000001, 0xb47ed77768fdb000 ) },
  { 0x1.bf32165b7e643p+64, 0x1.7da93100fb526p-848, INIT_U128( 0x0000000000000001, 0xbf32165b7e643000 ) },
  { 0x1.c6aa72a58d54fp+65, 0x1.700d04ece01ap-810, INIT_U128( 0x0000000000000003, 0x8d54e54b1aa9e000 ) },
  { 0x1.651ffffcca4p+65, 0x1.b6e3b8e56dc77p-810, INIT_U128( 0x0000000000000002, 0xca3ffff994800000 ) },
  { 0x1.f59076c9eb20fp+65, 0x1.41622b1082c46p-810, INIT_U128( 0x0000000000000003, 0xeb20ed93d641e000 ) },
  { 0x1.2362224a46c44p+65, 0x1.0fe4f0321fc9ep-810, INIT_U128( 0x0000000000000002, 0x46c444948d888000 ) },
  { 0x1.96643d852cc88p+66, 0x1.5aadaff0b55b6p-820, INIT_U128( 0x0000000000000006, 0x5990f614b3220000 ) },
  { 0x1.38a95f0e7152cp+66, 0x1.8432d89b0865bp-820, INIT_U128( 0x0000000000000004, 0xe2a57c39c54b0000 ) },
  { 0x1.b674a85b6ce95p+66, 0x1.3adbee1a75b7ep-820, INIT_U128( 0x0000000000000006, 0xd9d2a16db3a54000 ) },
  { 0x1.81b2bc3303658p+66, 0x1.0e771c4e1cee4p-820, INIT_U128( 0x0000000000000006, 0x06caf0cc0d960000 ) },
  { 0x1.017e066002fc1p+67, 0x1.69eb9d80d3d74p-860, INIT_U128( 0x0000000000000008, 0x0bf0330017e08000 ) },
  { 0x1.b75b9b136eb74p+67, 0x1.ddf2ec69bbe5ep-860, INIT_U128( 0x000000000000000d, 0xbadcd89b75ba0000 ) },
  { 0x1.71432fe4e2866p+67, 0x1.cbea0a3797d41p-860, INIT_U128( 0x000000000000000b, 0x8a197f2714330000 ) },
  { 0x1.65e3ce88cbc7ap+67, 0x1.dd466e4dba8cep-860, INIT_U128( 0x000000000000000b, 0x2f1e74465e3d0000 ) },
  { 0x1.d76842dfaed09p+68, 0x1.d4739f6ba8e74p-740, INIT_U128( 0x000000000000001d, 0x76842dfaed090000 ) },
  { 0x1.9180cb312301ap+68, 0x1.5961b442b2c36p-740, INIT_U128( 0x0000000000000019, 0x180cb312301a0000 ) },
  { 0x1.5ea7abd8bd4f6p+68, 0x1.0afd825415fbp-740, INIT_U128( 0x0000000000000015, 0xea7abd8bd4f60000 ) },
  { 0x1.bcf6493f79ec9p+68, 0x1.39f6643a73eccp-740, INIT_U128( 0x000000000000001b, 0xcf6493f79ec90000 ) },
  { 0x1.6c264bbad84cap+69, 0x1.3d2b92de7a572p-358, INIT_U128( 0x000000000000002d, 0x84c9775b09940000 ) },
  { 0x1.13b3e09a2767cp+69, 0x1.a3ead92f47d5bp-358, INIT_U128( 0x0000000000000022, 0x767c1344ecf80000 ) },
  { 0x1.8518219d0a304p+69, 0x1.c9a99edf93534p-358, INIT_U128( 0x0000000000000030, 0xa30433a146080000 ) },
  { 0x1.afa032e75f406p+69, 0x1.76f3e70cede7dp-358, INIT_U128( 0x0000000000000035, 0xf4065cebe80c0000 ) },
  { 0x1.1aa2f5343545ep+70, 0x1.cd612ccd9ac25p-491, INIT_U128( 0x0000000000000046, 0xa8bd4d0d51780000 ) },
  { 0x1.2c8c2e1a59186p+70, 0x1.53ac1260a7582p-491, INIT_U128( 0x000000000000004b, 0x230b869646180000 ) },
  { 0x1.b92d16ef725a3p+70, 0x1.05faddde0bf5cp-491, INIT_U128( 0x000000000000006e, 0x4b45bbdc968c0000 ) },
  { 0x1.9fc802a33f9p+70, 0x1.203a627a4074cp-491, INIT_U128( 0x0000000000000067, 0xf200a8cfe4000000 ) },
  { 0x1.240746b6480e9p+71, 0x1.78c39518f1872p-676, INIT_U128( 0x0000000000000092, 0x03a35b2407480000 ) },
  { 0x1.863a24750c744p+71, 0x1.96d2b31d2da56p-676, INIT_U128( 0x00000000000000c3, 0x1d123a863a200000 ) },
  { 0x1.597fbe8ab2ff8p+71, 0x1.93afb023275f6p-676, INIT_U128( 0x00000000000000ac, 0xbfdf45597fc00000 ) },
  { 0x1.e1080a67c2102p+71, 0x1.b5c9f2a36b93ep-676, INIT_U128( 0x00000000000000f0, 0x840533e108100000 ) },
  { 0x1.5c1897a6b8313p+72, 0x1.e08b1a6fc1164p-272, INIT_U128( 0x000000000000015c, 0x1897a6b831300000 ) },
  { 0x1.9ba232cf37446p+72, 0x1.5f66bf90becd8p-272, INIT_U128( 0x000000000000019b, 0xa232cf3744600000 ) },
  { 0x1.595f744cb2beep+72, 0x1.f7a95a67ef52cp-272, INIT_U128( 0x0000000000000159, 0x5f744cb2bee00000 ) },
  { 0x1.a763ae594ec76p+72, 0x1.c295524f852aap-272, INIT_U128( 0x00000000000001a7, 0x63ae594ec7600000 ) },
  { 0x1.06eca6c40dd95p+73, 0x1.f918431ff2309p-572, INIT_U128( 0x000000000000020d, 0xd94d881bb2a00000 ) },
  { 0x1.4f9fc82a9f3f9p+73, 0x1.257089f24ae11p-572, INIT_U128( 0x000000000000029f, 0x3f90553e7f200000 ) },
  { 0x1.0fa3bdc41f478p+73, 0x1.1ca9162039523p-572, INIT_U128( 0x000000000000021f, 0x477b883e8f000000 ) },
  { 0x1.be3be7ef7c77dp+73, 0x1.ae73d50d5ce7bp-572, INIT_U128( 0x000000000000037c, 0x77cfdef8efa00000 ) },
  { 0x1.da6d4389b4da8p+74, 0x1.1806570a300cbp-230, INIT_U128( 0x0000000000000769, 0xb50e26d36a000000 ) },
  { 0x1.55276624aa4edp+74, 0x1.004fb390009f6p-230, INIT_U128( 0x0000000000000554, 0x9d9892a93b400000 ) },
  { 0x1.aeab3c995d568p+74, 0x1.08d9156011b22p-230, INIT_U128( 0x00000000000006ba, 0xacf265755a000000 ) },
  { 0x1.a281549f4502ap+74, 0x1.cb98cbdf9731ap-230, INIT_U128( 0x000000000000068a, 0x05527d140a800000 ) },
  { 0x1.35dae4746bb5cp+75, 0x1.492edd3c925dcp-684, INIT_U128( 0x00000000000009ae, 0xd723a35dae000000 ) },
  { 0x1.e6b8db83cd71cp+75, 0x1.e8282f8fd0506p-684, INIT_U128( 0x0000000000000f35, 0xc6dc1e6b8e000000 ) },
  { 0x1.17587f082eb1p+75, 0x1.45ebb9f28bd77p-684, INIT_U128( 0x00000000000008ba, 0xc3f8417588000000 ) },
  { 0x1.957ac7292af59p+75, 0x1.35b408566b681p-684, INIT_U128( 0x0000000000000cab, 0xd6394957ac800000 ) },
  { 0x1.6e0e0850dc1c1p+76, 0x1.9e623e393cc48p-1002, INIT_U128( 0x00000000000016e0, 0xe0850dc1c1000000 ) },
  { 0x1.90fee6ff21fddp+76, 0x1.7ceca2caf9d94p-1002, INIT_U128( 0x000000000000190f, 0xee6ff21fdd000000 ) },
  { 0x1.5798708eaf30ep+76, 0x1.d3322f4fa6646p-1002, INIT_U128( 0x0000000000001579, 0x8708eaf30e000000 ) },
  { 0x1.c2ef5f4185decp+76, 0x1.96ad4d692d5aap-1002, INIT_U128( 0x0000000000001c2e, 0xf5f4185dec000000 ) },
  { 0x1.ae14b81f5c297p+77, 0x1.062f208c0c5e4p-169, INIT_U128( 0x00000000000035c2, 0x9703eb852e000000 ) },
  { 0x1.1f2ef58a3e5dep+77, 0x1.97a029192f405p-169, INIT_U128( 0x00000000000023e5, 0xdeb147cbbc000000 ) },
  { 0x1.74861d64e90c4p+77, 0x1.fb289c69f6513p-169, INIT_U128( 0x0000000000002e90, 0xc3ac9d2188000000 ) },
  { 0x1.11782bc422f06p+77, 0x1.fe294db5fc529p-169, INIT_U128( 0x000000000000222f, 0x0578845e0c000000 ) },
  { 0x1.3af34bd275e6ap+78, 0x1.ba66054574cc1p-910, INIT_U128( 0x0000000000004ebc, 0xd2f49d79a8000000 ) },
  { 0x1.0708e3fc0e11cp+78, 0x1.09ae142c135c2p-910, INIT_U128( 0x00000000000041c2, 0x38ff038470000000 ) },
  { 0x1.c313a69786275p+78, 0x1.fc165a27f82ccp-910, INIT_U128( 0x00000000000070c4, 0xe9a5e189d4000000 ) },
  { 0x1.990c9ad532193p+78, 0x1.072499060e493p-910, INIT_U128( 0x0000000000006643, 0x26b54c864c000000 ) },
  { 0x1.dd2363c1ba46cp+79, 0x1.d163c99ba2c79p-815, INIT_U128( 0x000000000000ee91, 0xb1e0dd2360000000 ) },
  { 0x1.b0ae4ad1615c9p+79, 0x1.8f2f90f91e5f2p-815, INIT_U128( 0x000000000000d857, 0x2568b0ae48000000 ) },
  { 0x1.9a26bbb7344d8p+79, 0x1.ed90d6d9db21bp-815, INIT_U128( 0x000000000000cd13, 0x5ddb9a26c0000000 ) },
  { 0x1.71ec17ace3d83p+79, 0x1.ec2b79cfd856fp-815, INIT_U128( 0x000000000000b8f6, 0x0bd671ec18000000 ) },
  { 0x1.689f9cb2d13f4p+80, 0x1.adfbd9175bf7bp-935, INIT_U128( 0x000000000001689f, 0x9cb2d13f40000000 ) },
  { 0x1.cde2888d9bc51p+80, 0x1.0d3598f01a6b3p-935, INIT_U128( 0x000000000001cde2, 0x888d9bc510000000 ) },
  { 0x1.6866c948d0cd9p+80, 0x1.0d9da3cc1b3b4p-935, INIT_U128( 0x0000000000016866, 0xc948d0cd90000000 ) },
  { 0x1.eee79cbdddcf3p+80, 0x1.a60bf9374c17fp-935, INIT_U128( 0x000000000001eee7, 0x9cbdddcf30000000 ) },
  { 0x1.3a27b29c744f6p+81, 0x1.1270039224ep-231, INIT_U128( 0x000000000002744f, 0x6538e89ec0000000 ) },
  { 0x1.608a6c38c114ep+81, 0x1.a6ff1b154dfe4p-231, INIT_U128( 0x000000000002c114, 0xd8718229c0000000 ) },
  { 0x1.b8ddf2c971bbep+81, 0x1.7a6c452cf4d88p-231, INIT_U128( 0x00000000000371bb, 0xe592e377c0000000 ) },
  { 0x1.34056f04680aep+81, 0x1.3aa39ba075474p-231, INIT_U128( 0x000000000002680a, 0xde08d015c0000000 ) },
  { 0x1.df36567dbe6cbp+82, 0x1.948aa54b29155p-104, INIT_U128( 0x0000000000077cd9, 0x59f6f9b2c0000000 ) },
  { 0x1.00c5bf20018b8p+82, 0x1.0354f44e06a9ep-104, INIT_U128( 0x0000000000040316, 0xfc80062e00000000 ) },
  { 0x1.5a6d471ab4da9p+82, 0x1.ea755ca5d4eabp-104, INIT_U128( 0x00000000000569b5, 0x1c6ad36a40000000 ) },
  { 0x1.58acff6eb15ap+82, 0x1.f6c3b1b9ed876p-104, INIT_U128( 0x00000000000562b3, 0xfdbac56800000000 ) },
  { 0x1.9288c20b25118p+83, 0x1.477be5208ef7cp-445, INIT_U128( 0x00000000000c9446, 0x1059288c00000000 ) },
  { 0x1.3556fa5c6aaep+83, 0x1.f200a591e4014p-445, INIT_U128( 0x000000000009aab7, 0xd2e3557000000000 ) },
  { 0x1.88dec0dd11bd8p+83, 0x1.a1ceac19439d6p-445, INIT_U128( 0x00000000000c46f6, 0x06e88dec00000000 ) },
  { 0x1.603498e4c0693p+83, 0x1.94ccf0d52999ep-445, INIT_U128( 0x00000000000b01a4, 0xc726034980000000 ) },
  { 0x1.1dfbb7a43bf77p+84, 0x1.d7dd8bdbafbb2p-926, INIT_U128( 0x000000000011dfbb, 0x7a43bf7700000000 ) },
  { 0x1.5f5d18b8beba3p+84, 0x1.ac1b923558372p-926, INIT_U128( 0x000000000015f5d1, 0x8b8beba300000000 ) },
  { 0x1.8b32b85d16657p+84, 0x1.37ae11cc6f5c2p-926, INIT_U128( 0x000000000018b32b, 0x85d1665700000000 ) },
  { 0x1.506f56eca0debp+84, 0x1.185445da30a88p-926, INIT_U128( 0x00000000001506f5, 0x6eca0deb00000000 ) },
  { 0x1.506cf3dea0d9ep+85, 0x1.2e68e2945cd1cp-635, INIT_U128( 0x00000000002a0d9e, 0x7bd41b3c00000000 ) },
  { 0x1.99ef268733de5p+85, 0x1.2ce0960e59c13p-635, INIT_U128( 0x0000000000333de4, 0xd0e67bca00000000 ) },
  { 0x1.d46cd273a8d9ap+85, 0x1.fb0bae61f6176p-635, INIT_U128( 0x00000000003a8d9a, 0x4e751b3400000000 ) },
  { 0x1.31deaa8263bd6p+85, 0x1.8a752b4514ea6p-635, INIT_U128( 0x0000000000263bd5, 0x504c77ac00000000 ) },
  { 0x1.95956f032b2aep+86, 0x1.ddd18753bba31p-535, INIT_U128( 0x000000000065655b, 0xc0cacab800000000 ) },
  { 0x1.db4b6705b696dp+86, 0x1.fc438061f887p-535, INIT_U128( 0x000000000076d2d9, 0xc16da5b400000000 ) },
  { 0x1.42c9320885926p+86, 0x1.9258f3ab24b1ep-535, INIT_U128( 0x000000000050b24c, 0x8221649800000000 ) },
  { 0x1.08ca2a0e11946p+86, 0x1.1c860974390c1p-535, INIT_U128( 0x000000000042328a, 0x8384651800000000 ) },
  { 0x1.ddf27f51bbe5p+87, 0x1.a776e8c94eeddp-479, INIT_U128( 0x0000000000eef93f, 0xa8ddf28000000000 ) },
  { 0x1.3f5b6af47eb6ep+87, 0x1.cf47dd9d9e8fcp-479, INIT_U128( 0x00000000009fadb5, 0x7a3f5b7000000000 ) },
  { 0x1.4b9d6480973acp+87, 0x1.c249100d84922p-479, INIT_U128( 0x0000000000a5ceb2, 0x404b9d6000000000 ) },
  { 0x1.eea053a5dd40bp+87, 0x1.26e6f8d24dcdfp-479, INIT_U128( 0x0000000000f75029, 0xd2eea05800000000 ) },
  { 0x1.4e0a84329c15p+88, 0x1.b969043772d2p-931, INIT_U128( 0x00000000014e0a84, 0x329c150000000000 ) },
  { 0x1.20fcf75c41f9fp+88, 0x1.a487f5bf490ffp-931, INIT_U128( 0x000000000120fcf7, 0x5c41f9f000000000 ) },
  { 0x1.0937a468126f4p+88, 0x1.dd15685bba2adp-931, INIT_U128( 0x00000000010937a4, 0x68126f4000000000 ) },
  { 0x1.3a1b94d674372p+88, 0x1.0e98a7441d315p-931, INIT_U128( 0x00000000013a1b94, 0xd674372000000000 ) },
  { 0x1.b9b702f1736ep+89, 0x1.afdf8f8b5fbf2p-758, INIT_U128( 0x0000000003736e05, 0xe2e6dc0000000000 ) },
  { 0x1.f93973b7f272fp+89, 0x1.77696130eed2cp-758, INIT_U128( 0x0000000003f272e7, 0x6fe4e5e000000000 ) },
  { 0x1.85595b3b0ab2cp+89, 0x1.4c1c459298388p-758, INIT_U128( 0x00000000030ab2b6, 0x7615658000000000 ) },
  { 0x1.89e4ed0b13c9ep+89, 0x1.4c88ddd89911cp-758, INIT_U128( 0x000000000313c9da, 0x162793c000000000 ) },
  { 0x1.6d0dfe6ada1cp+90, 0x1.0873b16610e76p+20, INIT_U128( 0x0000000005b437f9, 0xab6870000010873b ) },
  { 0x1.403e37e4807c7p+90, 0x1.630feeecc61fep+20, INIT_U128( 0x000000000500f8df, 0x9201f1c0001630fe ) },
  { 0x1.1d3cdade3a79cp+90, 0x1.ecceb30bd99d7p+20, INIT_U128( 0x000000000474f36b, 0x78e9e700001ecceb ) },
  { 0x1.f50698adea0d3p+90, 0x1.4ed5f3749dabep+20, INIT_U128( 0x0000000007d41a62, 0xb7a834c00014ed5f ) },
  { 0x1.d869b87fb0d37p+91, 0x1.53d108a0a7a21p-525, INIT_U128( 0x000000000ec34dc3, 0xfd869b8000000000 ) },
  { 0x1.cd078fb39a0f2p+91, 0x1.228b56084516bp-525, INIT_U128( 0x000000000e683c7d, 0x9cd0790000000000 ) },
  { 0x1.c67dbd798cfb7p+91, 0x1.65e1ed28cbc3ep-525, INIT_U128( 0x000000000e33edeb, 0xcc67db8000000000 ) },
  { 0x1.c41a2ed388346p+91, 0x1.4799717a8f32ep-525, INIT_U128( 0x000000000e20d176, 0x9c41a30000000000 ) },
  { 0x1.db416739b682dp+92, 0x1.fea650affd4cap-706, INIT_U128( 0x000000001db41673, 0x9b682d0000000000 ) },
  { 0x1.872189f10e431p+92, 0x1.e1de445fc3bc8p-706, INIT_U128( 0x000000001872189f, 0x10e4310000000000 ) },
  { 0x1.d2ad0fd1a55a2p+92, 0x1.0a06ac7e140d6p-706, INIT_U128( 0x000000001d2ad0fd, 0x1a55a20000000000 ) },
  { 0x1.2535c3a84a6b8p+92, 0x1.65205312ca40ap-706, INIT_U128( 0x0000000012535c3a, 0x84a6b80000000000 ) },
  { 0x1.dd518ce9baa31p+93, 0x1.b123211362464p-663, INIT_U128( 0x000000003baa319d, 0x3754620000000000 ) },
  { 0x1.9a89da733513bp+93, 0x1.8c0a0b2b18142p-663, INIT_U128( 0x0000000033513b4e, 0x66a2760000000000 ) },
  { 0x1.01fc693203f8dp+93, 0x1.81040a6d02081p-663, INIT_U128( 0x00000000203f8d26, 0x407f1a0000000000 ) },
  { 0x1.1d9ae72e3b35dp+93, 0x1.fb816ce9f702dp-663, INIT_U128( 0x0000000023b35ce5, 0xc766ba0000000000 ) },
  { 0x1.1b8311c037062p+94, 0x1.3b413a6c76828p-946, INIT_U128( 0x0000000046e0c470, 0x0dc1880000000000 ) },
  { 0x1.e7c1239fcf825p+94, 0x1.e89cbe61d1398p-946, INIT_U128( 0x0000000079f048e7, 0xf3e0940000000000 ) },
  { 0x1.3ba2c92677459p+94, 0x1.4c19bb4098338p-946, INIT_U128( 0x000000004ee8b249, 0x9dd1640000000000 ) },
  { 0x1.e81787a3d02f1p+94, 0x1.21981a6a43304p-946, INIT_U128( 0x000000007a05e1e8, 0xf40bc40000000000 ) },
  { 0x1.e18ca9a3c3195p+95, 0x1.d2ce473ba59c9p-353, INIT_U128( 0x00000000f0c654d1, 0xe18ca80000000000 ) },
  { 0x1.ec1a5457d834ap+95, 0x1.673af5f4ce75ep-353, INIT_U128( 0x00000000f60d2a2b, 0xec1a500000000000 ) },
  { 0x1.3d4fcc727a9fap+95, 0x1.d577142daaee2p-353, INIT_U128( 0x000000009ea7e639, 0x3d4fd00000000000 ) },
  { 0x1.6b318358d663p+95, 0x1.d96b9445b2d72p-353, INIT_U128( 0x00000000b598c1ac, 0x6b31800000000000 ) },
  { 0x1.f8fedfa1f1fdcp+96, 0x1.6e54dd28dca9cp-828, INIT_U128( 0x00000001f8fedfa1, 0xf1fdc00000000000 ) },
  { 0x1.4b5ec85896bd9p+96, 0x1.e4251105c84a2p-828, INIT_U128( 0x000000014b5ec858, 0x96bd900000000000 ) },
  { 0x1.bc8f0397791ep+96, 0x1.b514998d6a293p-828, INIT_U128( 0x00000001bc8f0397, 0x791e000000000000 ) },
  { 0x1.056a2dfe0ad46p+96, 0x1.c98d1a15931a3p-828, INIT_U128( 0x00000001056a2dfe, 0x0ad4600000000000 ) },
  { 0x1.21192da842326p+97, 0x1.64dbdea4c9b7cp-314, INIT_U128( 0x0000000242325b50, 0x8464c00000000000 ) },
  { 0x1.95c269f12b84dp+97, 0x1.31bfb62e637f7p-314, INIT_U128( 0x000000032b84d3e2, 0x5709a00000000000 ) },
  { 0x1.f4a37e69e947p+97, 0x1.2c5cc8d658b99p-314, INIT_U128( 0x00000003e946fcd3, 0xd28e000000000000 ) },
  { 0x1.73c765e6e78ecp+97, 0x1.34b3a3f469674p-314, INIT_U128( 0x00000002e78ecbcd, 0xcf1d800000000000 ) },
  { 0x1.cafa773f95f4fp+98, 0x1.28d3338851a66p-207, INIT_U128( 0x000000072be9dcfe, 0x57d3c00000000000 ) },
  { 0x1.7b7b6aa4f6f6ep+98, 0x1.2c99252259324p-207, INIT_U128( 0x00000005ededaa93, 0xdbdb800000000000 ) },
  { 0x1.8c39a15918734p+98, 0x1.cdcd60b79b9acp-207, INIT_U128( 0x0000000630e68564, 0x61cd000000000000 ) },
  { 0x1.da220eb5b4442p+98, 0x1.cd0b52b19a16bp-207, INIT_U128( 0x0000000768883ad6, 0xd110800000000000 ) },
  { 0x1.0f34e6fa1e69dp+99, 0x1.596be5d4b2d7cp-575, INIT_U128( 0x0000000879a737d0, 0xf34e800000000000 ) },
  { 0x1.5318af1aa6316p+99, 0x1.b2d7a70f65af5p-575, INIT_U128( 0x0000000a98c578d5, 0x318b000000000000 ) },
  { 0x1.2f3f14005e7e2p+99, 0x1.bf1a11977e342p-575, INIT_U128( 0x0000000979f8a002, 0xf3f1000000000000 ) },
  { 0x1.c95da71792bb5p+99, 0x1.b673d5896ce7bp-575, INIT_U128( 0x0000000e4aed38bc, 0x95da800000000000 ) },
  { 0x1.fdead1dffbd5ap+100, 0x1.5a750c74b4ea2p-189, INIT_U128( 0x0000001fdead1dff, 0xbd5a000000000000 ) },
  { 0x1.fe8116bbfd023p+100, 0x1.c0314d4580629p-189, INIT_U128( 0x0000001fe8116bbf, 0xd023000000000000 ) },
  { 0x1.9177917922ef2p+100, 0x1.b5d94c0f6bb2ap-189, INIT_U128( 0x0000001917791792, 0x2ef2000000000000 ) },
  { 0x1.39ab1bf273564p+100, 0x1.4de96f889bd2ep-189, INIT_U128( 0x000000139ab1bf27, 0x3564000000000000 ) },
  { 0x1.52e21a8aa5c44p+101, 0x0.0000075bfbb25p-1022, INIT_U128( 0x0000002a5c435154, 0xb888000000000000 ) },
  { 0x1.c362c16186c58p+101, 0x0.00000417370ap-1022, INIT_U128( 0x000000386c582c30, 0xd8b0000000000000 ) },
  { 0x1.dcbb50a5b976ap+101, 0x0.000005dcb4b01p-1022, INIT_U128( 0x0000003b976a14b7, 0x2ed4000000000000 ) },
  { 0x1.fae77febf5cfp+101, 0x0.00000567e1492p-1022, INIT_U128( 0x0000003f5ceffd7e, 0xb9e0000000000000 ) },
  { 0x1.b94feaf3729fdp+102, 0x1.eb191b6bd6324p-32, INIT_U128( 0x0000006e53fabcdc, 0xa7f4000000000000 ) },
  { 0x1.ffcd483fff9a9p+102, 0x1.f6c951e5ed92ap-32, INIT_U128( 0x0000007ff3520fff, 0xe6a4000000000000 ) },
  { 0x1.f4a75991e94ebp+102, 0x1.5d81e52ebb03cp-32, INIT_U128( 0x0000007d29d6647a, 0x53ac000000000000 ) },
  { 0x1.d9014a81b202ap+102, 0x1.1d1a5c4c3a34cp-32, INIT_U128( 0x000000764052a06c, 0x80a8000000000000 ) },
  { 0x1.d33430cda6686p+103, 0x1.58855d10b10acp-383, INIT_U128( 0x000000e99a1866d3, 0x3430000000000000 ) },
  { 0x1.5e801048bd002p+103, 0x1.54a52a72a94a6p-383, INIT_U128( 0x000000af4008245e, 0x8010000000000000 ) },
  { 0x1.590a254ab2144p+103, 0x1.0307881c060f1p-383, INIT_U128( 0x000000ac8512a559, 0x0a20000000000000 ) },
  { 0x1.6dfaecf0dbf5ep+103, 0x1.54a4b130a9496p-383, INIT_U128( 0x000000b6fd76786d, 0xfaf0000000000000 ) },
  { 0x1.011eb1b0023d6p+104, 0x1.39df71da73beep-20, INIT_U128( 0x000001011eb1b002, 0x3d60000000000000 ) },
  { 0x1.5ee2142ebdc42p+104, 0x1.43553d9086aa8p-20, INIT_U128( 0x0000015ee2142ebd, 0xc420000000000000 ) },
  { 0x1.100502e4200ap+104, 0x1.534d9720a69b3p-20, INIT_U128( 0x000001100502e420, 0x0a00000000000000 ) },
  { 0x1.2aefc5ac55df8p+104, 0x1.f553d14beaa7ap-20, INIT_U128( 0x0000012aefc5ac55, 0xdf80000000000000 ) },
  { 0x1.d0559891a0ab3p+105, 0x1.87b2239d0f644p-316, INIT_U128( 0x000003a0ab312341, 0x5660000000000000 ) },
  { 0x1.0929084e12521p+105, 0x1.e345fe55c68cp-316, INIT_U128( 0x0000021252109c24, 0xa420000000000000 ) },
  { 0x1.70c26be4e184ep+105, 0x1.7a6011c6f4c02p-316, INIT_U128( 0x000002e184d7c9c3, 0x09c0000000000000 ) },
  { 0x1.8c345d471868cp+105, 0x1.b4a5d903694bbp-316, INIT_U128( 0x0000031868ba8e30, 0xd180000000000000 ) },
  { 0x1.66bf48cecd7e9p+106, 0x1.d926e3a9b24dcp-461, INIT_U128( 0x0000059afd233b35, 0xfa40000000000000 ) },
  { 0x1.caf9648595f2cp+106, 0x1.3edd8e587dbb2p-461, INIT_U128( 0x0000072be5921657, 0xcb00000000000000 ) },
  { 0x1.0ff9c5341ff38p+106, 0x1.5ecf4954bd9e9p-461, INIT_U128( 0x0000043fe714d07f, 0xce00000000000000 ) },
  { 0x1.010bbf3602178p+106, 0x1.90183dfb20308p-461, INIT_U128( 0x000004042efcd808, 0x5e00000000000000 ) },
  { 0x1.90f1198321e23p+107, 0x1.18ec849e31d9p-508, INIT_U128( 0x00000c8788cc190f, 0x1180000000000000 ) },
  { 0x1.88876447110ecp+107, 0x1.3dbc4a967b78ap-508, INIT_U128( 0x00000c443b223888, 0x7600000000000000 ) },
  { 0x1.e955d221d2abap+107, 0x1.1f1f0f983e3e2p-508, INIT_U128( 0x00000f4aae910e95, 0x5d00000000000000 ) },
  { 0x1.79931aacf3264p+107, 0x1.5c6d47c2b8da9p-508, INIT_U128( 0x00000bcc98d56799, 0x3200000000000000 ) },
  { 0x1.49a28e4c93452p+108, 0x1.0819b1c610336p-949, INIT_U128( 0x0000149a28e4c934, 0x5200000000000000 ) },
  { 0x1.b61387f56c271p+108, 0x1.fda021a7fb404p-949, INIT_U128( 0x00001b61387f56c2, 0x7100000000000000 ) },
  { 0x1.8364b71506c97p+108, 0x1.972f04852e5ep-949, INIT_U128( 0x000018364b71506c, 0x9700000000000000 ) },
  { 0x1.a902b10952056p+108, 0x1.aee9cfcf5dd3ap-949, INIT_U128( 0x00001a902b109520, 0x5600000000000000 ) },
  { 0x1.d96f1c29b2de4p+109, 0x1.8415bcdf082b8p-695, INIT_U128( 0x00003b2de385365b, 0xc800000000000000 ) },
  { 0x1.e8dfe3f9d1bfcp+109, 0x1.c31bb2ed86377p-695, INIT_U128( 0x00003d1bfc7f3a37, 0xf800000000000000 ) },
  { 0x1.3a0cc61474199p+109, 0x1.06f2795a0de4fp-695, INIT_U128( 0x0000274198c28e83, 0x3200000000000000 ) },
  { 0x1.1f3e5f4a3e7ccp+109, 0x1.d7cc8b85af992p-695, INIT_U128( 0x000023e7cbe947cf, 0x9800000000000000 ) },
  { 0x1.dc6af865b8d5fp+110, 0x1.b5d225136ba45p-22, INIT_U128( 0x0000771abe196e35, 0x7c00000000000000 ) },
  { 0x1.4ca9fcc69954p+110, 0x1.eaa024f7d5404p-22, INIT_U128( 0x0000532a7f31a655, 0x0000000000000000 ) },
  { 0x1.414c72988298ep+110, 0x1.a488753b4910fp-22, INIT_U128( 0x000050531ca620a6, 0x3800000000000000 ) },
  { 0x1.dc6b39dbb8d67p+110, 0x1.068d04580d1ap-22, INIT_U128( 0x0000771ace76ee35, 0x9c00000000000000 ) },
  { 0x1.74e50e90e9ca2p+111, 0x1.3f289f007e514p-487, INIT_U128( 0x0000ba72874874e5, 0x1000000000000000 ) },
  { 0x1.5f0a2632be145p+111, 0x1.f790c8d9ef219p-487, INIT_U128( 0x0000af8513195f0a, 0x2800000000000000 ) },
  { 0x1.d422bf03a8458p+111, 0x1.fbacd695f759bp-487, INIT_U128( 0x0000ea115f81d422, 0xc000000000000000 ) },
  { 0x1.d9b5cefdb36bap+111, 0x1.c968397b92d07p-487, INIT_U128( 0x0000ecdae77ed9b5, 0xd000000000000000 ) },
  { 0x1.f3e78001e7cfp+112, 0x1.4b4970649692ep-744, INIT_U128( 0x0001f3e78001e7cf, 0x0000000000000000 ) },
  { 0x1.17c200042f84p+112, 0x1.8d8e8a711b1d1p-744, INIT_U128( 0x000117c200042f84, 0x0000000000000000 ) },
  { 0x1.0fe4fde81fcap+112, 0x1.256616f84acc3p-744, INIT_U128( 0x00010fe4fde81fca, 0x0000000000000000 ) },
  { 0x1.f2773487e4ee6p+112, 0x1.075dd87a0ebbbp-744, INIT_U128( 0x0001f2773487e4ee, 0x6000000000000000 ) },
  { 0x1.7f2646f4fe4c9p+113, 0x1.bde0f7d57bc1fp-552, INIT_U128( 0x0002fe4c8de9fc99, 0x2000000000000000 ) },
  { 0x1.552a71c4aa54ep+113, 0x1.5f75cb84beebap-552, INIT_U128( 0x0002aa54e38954a9, 0xc000000000000000 ) },
  { 0x1.016211fe02c42p+113, 0x1.755a3ebeeab48p-552, INIT_U128( 0x000202c423fc0588, 0x4000000000000000 ) },
  { 0x1.2da4a1405b494p+113, 0x1.c7b5a5b78f6b5p-552, INIT_U128( 0x00025b494280b692, 0x8000000000000000 ) },
  { 0x1.454dcac88a9bap+114, 0x1.39e2f64073c5fp-541, INIT_U128( 0x000515372b222a6e, 0x8000000000000000 ) },
  { 0x1.f5769ad1eaed4p+114, 0x1.273e2b1a4e7c6p-541, INIT_U128( 0x0007d5da6b47abb5, 0x0000000000000000 ) },
  { 0x1.52bf04cca57ep+114, 0x1.2d92613e5b24cp-541, INIT_U128( 0x00054afc133295f8, 0x0000000000000000 ) },
  { 0x1.1b84a7fc37095p+114, 0x1.8b3360311666cp-541, INIT_U128( 0x00046e129ff0dc25, 0x4000000000000000 ) },
  { 0x1.82ef082b05de1p+115, 0x1.5205f44aa40bep-62, INIT_U128( 0x000c177841582ef0, 0x8000000000000000 ) },
  { 0x1.bafcbdf175f98p+115, 0x1.a9ea203153d44p-62, INIT_U128( 0x000dd7e5ef8bafcc, 0x0000000000000000 ) },
  { 0x1.64b56bd8c96aep+115, 0x1.42c3a3da85874p-62, INIT_U128( 0x000b25ab5ec64b57, 0x0000000000000000 ) },
  { 0x1.55c9b3b6ab936p+115, 0x1.48f9d11a91f3ap-62, INIT_U128( 0x000aae4d9db55c9b, 0x0000000000000000 ) },
  { 0x1.5321473ca6429p+116, 0x1.181db1c6303b6p-92, INIT_U128( 0x0015321473ca6429, 0x0000000000000000 ) },
  { 0x1.cdc20a3f9b841p+116, 0x1.50077ebca00fp-92, INIT_U128( 0x001cdc20a3f9b841, 0x0000000000000000 ) },
  { 0x1.92fee4f925fdcp+116, 0x1.028f8f16051f2p-92, INIT_U128( 0x00192fee4f925fdc, 0x0000000000000000 ) },
  { 0x1.1bab55e43756ap+116, 0x1.40855e9c810acp-92, INIT_U128( 0x0011bab55e43756a, 0x0000000000000000 ) },
  { 0x1.db43e365b687dp+117, 0x1.41baf8828375fp-732, INIT_U128( 0x003b687c6cb6d0fa, 0x0000000000000000 ) },
  { 0x1.a552a1674aa54p+117, 0x1.baa689f9754d1p-732, INIT_U128( 0x0034aa542ce954a8, 0x0000000000000000 ) },
  { 0x1.fe56ea4dfcadep+117, 0x1.5684197ead083p-732, INIT_U128( 0x003fcadd49bf95bc, 0x0000000000000000 ) },
  { 0x1.6c9b7a08d937p+117, 0x1.2337f65a466ffp-732, INIT_U128( 0x002d936f411b26e0, 0x0000000000000000 ) },
  { 0x1.076705de0ecep+118, 0x1.98bce7cb3179dp-844, INIT_U128( 0x0041d9c17783b380, 0x0000000000000000 ) },
  { 0x1.9b22f3533645ep+118, 0x1.74f31c32e9e64p-844, INIT_U128( 0x0066c8bcd4cd9178, 0x0000000000000000 ) },
  { 0x1.c1d136e583a27p+118, 0x1.767b76ceecf6fp-844, INIT_U128( 0x0070744db960e89c, 0x0000000000000000 ) },
  { 0x1.c885934b910b3p+118, 0x1.cd65a24d9acb4p-844, INIT_U128( 0x00722164d2e442cc, 0x0000000000000000 ) },
  { 0x1.fb2c8085f659p+119, 0x1.4485cbfc890bap-269, INIT_U128( 0x00fd964042fb2c80, 0x0000000000000000 ) },
  { 0x1.78eebbd0f1dd8p+119, 0x1.373c5ea66e78cp-269, INIT_U128( 0x00bc775de878eec0, 0x0000000000000000 ) },
  { 0x1.1cbf9dfc397f4p+119, 0x1.3a787bfa74f1p-269, INIT_U128( 0x008e5fcefe1cbfa0, 0x0000000000000000 ) },
  { 0x1.0b37d4fc166fap+119, 0x1.3ec2f1ca7d85ep-269, INIT_U128( 0x00859bea7e0b37d0, 0x0000000000000000 ) },
  { 0x1.f7d41d9befa83p+119, 0x1.737e360ee6fc7p+45, INIT_U128( 0x00fbea0ecdf7d418, 0x00002e6fc6c1dcdf ) },
  { 0x1.5f9adea4bf35cp+119, 0x1.f2a34d73e5469p+45, INIT_U128( 0x00afcd6f525f9ae0, 0x00003e5469ae7ca8 ) },
  { 0x1.1625a2842c4b4p+119, 0x1.dffa968fbff53p+45, INIT_U128( 0x008b12d1421625a0, 0x00003bff52d1f7fe ) },
  { 0x1.77b9ea5cef73ep+119, 0x1.03d8c57207b18p+45, INIT_U128( 0x00bbdcf52e77b9f0, 0x0000207b18ae40f6 ) },
  { 0x1.80c91d3d01924p+119, 0x1.dc2e84abb85dp+45, INIT_U128( 0x00c0648e9e80c920, 0x00003b85d095770b ) },
  { 0x1.a13e2abb427c5p+119, 0x1.be5baad37cb75p+45, INIT_U128( 0x00d09f155da13e28, 0x000037cb755a6f96 ) },
  { 0x1.3d0a39607a147p+119, 0x1.5d047beeba09p+45, INIT_U128( 0x009e851cb03d0a38, 0x00002ba08f7dd741 ) },
  { 0x1.e914f2edd229fp+119, 0x1.a87d6b5150faep+45, INIT_U128( 0x00f48a7976e914f8, 0x0000350fad6a2a1f ) },
  { 0x1.1bfba16037f74p+119, 0x1.f1667f23e2cdp+45, INIT_U128( 0x008dfdd0b01bfba0, 0x00003e2ccfe47c59 ) },
  { 0x1.e409cc97c8139p+119, 0x1.760ec180ec1d8p+45, INIT_U128( 0x00f204e64be409c8, 0x00002ec1d8301d83 ) },
  { 0x1.56095810ac12bp+119, 0x1.fd72c88bfae59p+45, INIT_U128( 0x00ab04ac08560958, 0x00003fae59117f5c ) },
  { 0x1.014b8dfe02972p+119, 0x1.5051ec7ca0a3ep+45, INIT_U128( 0x0080a5c6ff014b90, 0x00002a0a3d8f9414 ) },
  { 0x1.2c8071285900ep+119, 0x1.2df331a65be66p+45, INIT_U128( 0x00964038942c8070, 0x000025be6634cb7c ) },
  { 0x1.ec4edc7bd89dbp+119, 0x1.5689910cad132p+45, INIT_U128( 0x00f6276e3dec4ed8, 0x00002ad1322195a2 ) },
  { 0x1.acab22af59564p+120, 0x1.4302395486047p-789, INIT_U128( 0x01acab22af595640, 0x0000000000000000 ) },
  { 0x1.6d777264daeeep+120, 0x1.a94793a7528f2p-789, INIT_U128( 0x016d777264daeee0, 0x0000000000000000 ) },
  { 0x1.179807f22f301p+120, 0x1.f73f61cbee7ecp-789, INIT_U128( 0x01179807f22f3010, 0x0000000000000000 ) },
  { 0x1.2306ea1a460dep+120, 0x1.7f322c14fe646p-789, INIT_U128( 0x012306ea1a460de0, 0x0000000000000000 ) },
  { 0x1.4b89313897126p+121, 0x1.24f0cf5649e1ap-97, INIT_U128( 0x02971262712e24c0, 0x0000000000000000 ) },
  { 0x1.977d3ba32efa8p+121, 0x1.8d5ae3291ab5cp-97, INIT_U128( 0x032efa77465df500, 0x0000000000000000 ) },
  { 0x1.4951cf1a92a3ap+121, 0x1.ff3e4eaffe7cap-97, INIT_U128( 0x0292a39e35254740, 0x0000000000000000 ) },
  { 0x1.6487918ac90f2p+121, 0x1.8e5a3b671cb48p-97, INIT_U128( 0x02c90f2315921e40, 0x0000000000000000 ) },
  { 0x1.a71b395f4e367p+122, 0x1.4851ea7e90a3ep-824, INIT_U128( 0x069c6ce57d38d9c0, 0x0000000000000000 ) },
  { 0x1.58097738b012fp+122, 0x1.a4e92d4749d26p-824, INIT_U128( 0x056025dce2c04bc0, 0x0000000000000000 ) },
  { 0x1.431d2f4a863a6p+122, 0x1.ff84386fff087p-824, INIT_U128( 0x050c74bd2a18e980, 0x0000000000000000 ) },
  { 0x1.9f1393ad3e272p+122, 0x1.d7c0a6ddaf815p-824, INIT_U128( 0x067c4e4eb4f89c80, 0x0000000000000000 ) },
  { 0x1.8983ab7913076p+123, 0x1.fa01bdc9f4037p-825, INIT_U128( 0x0c4c1d5bc8983b00, 0x0000000000000000 ) },
  { 0x1.f3551e67e6aa4p+123, 0x1.029c51f00538ap-825, INIT_U128( 0x0f9aa8f33f355200, 0x0000000000000000 ) },
  { 0x1.a9da0d1d53b42p+123, 0x1.b5c718d36b8e3p-825, INIT_U128( 0x0d4ed068ea9da100, 0x0000000000000000 ) },
  { 0x1.95c79e2b2b8f4p+123, 0x1.384e4c32709cap-825, INIT_U128( 0x0cae3cf1595c7a00, 0x0000000000000000 ) },
  { 0x1.73af4650e75e9p+124, 0x1.ec4b7265d896fp-92, INIT_U128( 0x173af4650e75e900, 0x0000000000000000 ) },
  { 0x1.5e15a3a0bc2b4p+124, 0x1.2ff859825ff0bp-92, INIT_U128( 0x15e15a3a0bc2b400, 0x0000000000000000 ) },
  { 0x1.4dbe24a69b7c4p+124, 0x1.f5b685e5eb6d1p-92, INIT_U128( 0x14dbe24a69b7c400, 0x0000000000000000 ) },
  { 0x1.cd65ac439acb6p+124, 0x1.164d910a2c9b2p-92, INIT_U128( 0x1cd65ac439acb600, 0x0000000000000000 ) },
  { 0x1.f5bbadd5eb775p+125, 0x1.b16aeddb62d5ep-83, INIT_U128( 0x3eb775babd6eea00, 0x0000000000000000 ) },
  { 0x1.b66841396cd08p+125, 0x1.f9957d69f32afp-83, INIT_U128( 0x36cd08272d9a1000, 0x0000000000000000 ) },
  { 0x1.05be50760b7cap+125, 0x1.f9ebf8ddf3d7fp-83, INIT_U128( 0x20b7ca0ec16f9400, 0x0000000000000000 ) },
  { 0x1.51312262a2624p+125, 0x1.11c69084238d2p-83, INIT_U128( 0x2a26244c544c4800, 0x0000000000000000 ) },
  { 0x1.30eab12c61d56p+126, 0x1.f1e0e851e3c1dp-773, INIT_U128( 0x4c3aac4b18755800, 0x0000000000000000 ) },
  { 0x1.ac34bcf158698p+126, 0x1.a55b126f4ab62p-773, INIT_U128( 0x6b0d2f3c561a6000, 0x0000000000000000 ) },
  { 0x1.02246a040448ep+126, 0x1.61a83652c3507p-773, INIT_U128( 0x40891a8101123800, 0x0000000000000000 ) },
  { 0x1.ae881f955d104p+126, 0x1.c694aaa18d296p-773, INIT_U128( 0x6ba207e557441000, 0x0000000000000000 ) },
  { 0x1.08016b641002ep+127, 0x1.23a890d047512p-406, INIT_U128( 0x8400b5b208017000, 0x0000000000000000 ) },
  { 0x1.3d90e7327b21dp+127, 0x1.0aa664c0154ccp-406, INIT_U128( 0x9ec873993d90e800, 0x0000000000000000 ) },
  { 0x1.ff931617ff263p+127, 0x1.47d5e2a08fabcp-406, INIT_U128( 0xffc98b0bff931800, 0x0000000000000000 ) },
  { 0x1.f565d1dfeacbap+127, 0x1.827bc0c304f78p-406, INIT_U128( 0xfab2e8eff565d000, 0x0000000000000000 ) },
  { 0x1.fe1985fbfc33p+128, 0x1.a6e724cd4dce4p-1021, INIT_U128( 0xffffffffffffffff, 0xffffffffffffffff ) },
  { 0x1.54709ed6a8e14p+128, 0x1.74a32d1ce9466p-1021, INIT_U128( 0xffffffffffffffff, 0xffffffffffffffff ) },
  { 0x1.a8407dcf5081p+128, 0x1.ffb065f3ff60cp-1021, INIT_U128( 0xffffffffffffffff, 0xffffffffffffffff ) },
  { 0x1.7a1cfcf2f43ap+130, 0x1.84bb5ea30976cp-548, INIT_U128( 0xffffffffffffffff, 0xffffffffffffffff ) },
  { 0x1.6bddaae8d7bb6p+194, 0x1.de64c609bcc99p-754, INIT_U128( 0xffffffffffffffff, 0xffffffffffffffff ) },
  { 0x1.5c6c29d4b8d85p+146, 0x1.0644f6d60c89fp-345, INIT_U128( 0xffffffffffffffff, 0xffffffffffffffff ) },
  { 0x1.c6ce8bcf8d9d2p+158, 0x1.443b2e7088766p-26, INIT_U128( 0xffffffffffffffff, 0xffffffffffffffff ) },
  { 0x1.747f6aa0e8feep+168, 0x1.fe663ae9fccc8p-143, INIT_U128( 0xffffffffffffffff, 0xffffffffffffffff ) },
  { 0x1.26ee550a4ddcap+173, 0x1.951f708f2a3eep-45, INIT_U128( 0xffffffffffffffff, 0xffffffffffffffff ) },
  { 0x1.3ecfe0ea7d9fcp+189, 0x1.9cb53593396a7p-619, INIT_U128( 0xffffffffffffffff, 0xffffffffffffffff ) },
  { 0x1.9d394a313a729p+190, 0x1.9ecfff853dap-150, INIT_U128( 0xffffffffffffffff, 0xffffffffffffffff ) },
  { 0x1.244a568a4894bp+241, 0x1.e23f42d7c47e9p-956, INIT_U128( 0xffffffffffffffff, 0xffffffffffffffff ) },
  { 0x1.b564bb276ac98p+398, 0x1.7af8d1ccf5f1ap+215, INIT_U128( 0xffffffffffffffff, 0xffffffffffffffff ) },
  { 0x1.ee06b389dc0d7p+468, 0x1.b54fa74f6a9f5p+322, INIT_U128( 0xffffffffffffffff, 0xffffffffffffffff ) },
  { 0x1.ac0045bd58009p+588, 0x1.ba99775b7532fp-365, INIT_U128( 0xffffffffffffffff, 0xffffffffffffffff ) },
  { 0x1.692078cad240fp+661, 0x1.bc4a88a978951p+356, INIT_U128( 0xffffffffffffffff, 0xffffffffffffffff ) },
  { 0x1.be1e09dd7c3c1p+765, 0x1.428bc5dc85178p-848, INIT_U128( 0xffffffffffffffff, 0xffffffffffffffff ) },
  { 0x1.5f5554c4beaaap+853, 0x1.a9e23bdd53c48p-807, INIT_U128( 0xffffffffffffffff, 0xffffffffffffffff ) },
  { 0x1.748e96ace91d3p+993, 0x1.ab54ab4b56a96p-22, INIT_U128( 0xffffffffffffffff, 0xffffffffffffffff ) },
  { 0x1.0629e7380c53dp+1023, 0x1.c0b4b15581696p+323, INIT_U128( 0xffffffffffffffff, 0xffffffffffffffff ) },
  { INFINITY, 0x1.21bff4bc437fep-333, ((__uint128_t) 0xffffffffffffffff << 64) | 0xffffffffffffffff },
  { INFINITY, 0x1.47e9a0228fd34p-333, ((__uint128_t) 0xffffffffffffffff << 64) | 0xffffffffffffffff }
};

static const int numTests = sizeof(testList) / sizeof(struct testCase);

