/*
 * Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2006 - INRIA - Allan CORNET
 *
 * Copyright (C) 2012 - 2016 - Scilab Enterprises
 *
 * This file is hereby licensed under the terms of the GNU GPL v2.0,
 * pursuant to article 5.3.4 of the CeCILL v.2.1.
 * This file was originally licensed under the terms of the CeCILL v2.1,
 * and continues to be available under such terms.
 * For more information, see the COPYING file which you should have received
 * along with this program.
 *
 */
#include <list>
#include <string>
#include "configvariable.hxx"

extern "C"
{
#include <string.h>
#include "with_module.h"
#include "getmodules.h"
}
/*--------------------------------------------------------------------------*/
BOOL with_module(wchar_t* _pwstModule)
{
    if (_pwstModule)
    {
        std::list<std::wstring> sModuleList = ConfigVariable::getModuleList();
        std::list<std::wstring>::const_iterator it;
        for (it = sModuleList.begin() ; it != sModuleList.end() ; it++)
        {
            if (wcscmp((*it).c_str(), _pwstModule) == 0)
            {
                return TRUE;
            }
        }
    }
    return FALSE;

}
/*--------------------------------------------------------------------------*/
