/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.rng;

import com.thaiopensource.relaxng.edit.AbstractVisitor;
import com.thaiopensource.relaxng.edit.Annotated;
import com.thaiopensource.relaxng.edit.AnnotationChild;
import com.thaiopensource.relaxng.edit.AnyNameNameClass;
import com.thaiopensource.relaxng.edit.AttributeAnnotation;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoiceNameClass;
import com.thaiopensource.relaxng.edit.Component;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.Container;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementAnnotation;
import com.thaiopensource.relaxng.edit.ExternalRefPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.NameClass;
import com.thaiopensource.relaxng.edit.NameClassedPattern;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.NamespaceContext;
import com.thaiopensource.relaxng.edit.NsNameNameClass;
import com.thaiopensource.relaxng.edit.Param;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.UnaryPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.util.VoidValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Analyzer
extends AbstractVisitor {
    private String datatypeLibrary = null;
    private final Map<String, String> prefixMap = new HashMap<String, String>();
    private boolean haveInherit = false;
    private NamespaceContext lastContext = null;
    private String noPrefixNs = null;

    Analyzer() {
    }

    private VoidValue visitAnnotated(Annotated annotated) {
        if (annotated.getAttributeAnnotations().size() > 0 || annotated.getChildElementAnnotations().size() > 0 || annotated.getFollowingElementAnnotations().size() > 0) {
            this.noteContext(annotated.getContext());
        }
        this.visitAnnotationAttributes(annotated.getAttributeAnnotations());
        this.visitAnnotationChildren(annotated.getChildElementAnnotations());
        this.visitAnnotationChildren(annotated.getFollowingElementAnnotations());
        return VoidValue.VOID;
    }

    private void visitAnnotationAttributes(List<AttributeAnnotation> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AttributeAnnotation attributeAnnotation = list.get(i);
            if (attributeAnnotation.getNamespaceUri().length() == 0) continue;
            this.noteNs(attributeAnnotation.getPrefix(), attributeAnnotation.getNamespaceUri());
        }
    }

    private void visitAnnotationChildren(List<AnnotationChild> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AnnotationChild annotationChild = list.get(i);
            if (!(annotationChild instanceof ElementAnnotation)) continue;
            ElementAnnotation elementAnnotation = (ElementAnnotation)annotationChild;
            if (elementAnnotation.getPrefix() != null) {
                this.noteNs(elementAnnotation.getPrefix(), elementAnnotation.getNamespaceUri());
            }
            this.visitAnnotationAttributes(elementAnnotation.getAttributes());
            this.visitAnnotationChildren(elementAnnotation.getChildren());
        }
    }

    @Override
    public VoidValue visitPattern(Pattern pattern) {
        return this.visitAnnotated(pattern);
    }

    @Override
    public VoidValue visitDefine(DefineComponent defineComponent) {
        this.visitAnnotated(defineComponent);
        return defineComponent.getBody().accept(this);
    }

    @Override
    public VoidValue visitDiv(DivComponent divComponent) {
        this.visitAnnotated(divComponent);
        return this.visitContainer(divComponent);
    }

    @Override
    public VoidValue visitInclude(IncludeComponent includeComponent) {
        this.visitAnnotated(includeComponent);
        this.noteInheritNs(includeComponent.getNs());
        return this.visitContainer(includeComponent);
    }

    @Override
    public VoidValue visitGrammar(GrammarPattern grammarPattern) {
        this.visitAnnotated(grammarPattern);
        return this.visitContainer(grammarPattern);
    }

    private VoidValue visitContainer(Container container) {
        List<Component> list = container.getComponents();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.get(i).accept(this);
        }
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitUnary(UnaryPattern unaryPattern) {
        this.visitAnnotated(unaryPattern);
        return unaryPattern.getChild().accept(this);
    }

    @Override
    public VoidValue visitComposite(CompositePattern compositePattern) {
        this.visitAnnotated(compositePattern);
        List<Pattern> list = compositePattern.getChildren();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.get(i).accept(this);
        }
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitNameClassed(NameClassedPattern nameClassedPattern) {
        nameClassedPattern.getNameClass().accept(this);
        return this.visitUnary(nameClassedPattern);
    }

    @Override
    public VoidValue visitAttribute(AttributePattern attributePattern) {
        NameClass nameClass = attributePattern.getNameClass();
        if (nameClass instanceof NameNameClass && ((NameNameClass)nameClass).getNamespaceUri().equals("")) {
            return this.visitUnary(attributePattern);
        }
        return this.visitNameClassed(attributePattern);
    }

    @Override
    public VoidValue visitChoice(ChoiceNameClass choiceNameClass) {
        this.visitAnnotated(choiceNameClass);
        List<NameClass> list = choiceNameClass.getChildren();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.get(i).accept(this);
        }
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitValue(ValuePattern valuePattern) {
        this.visitAnnotated(valuePattern);
        if (!valuePattern.getType().equals("token") || !valuePattern.getDatatypeLibrary().equals("")) {
            this.noteDatatypeLibrary(valuePattern.getDatatypeLibrary());
        }
        for (Map.Entry<String, String> entry : valuePattern.getPrefixMap().entrySet()) {
            this.noteNs(entry.getKey(), entry.getValue());
        }
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitData(DataPattern dataPattern) {
        this.visitAnnotated(dataPattern);
        this.noteDatatypeLibrary(dataPattern.getDatatypeLibrary());
        Pattern pattern = dataPattern.getExcept();
        if (pattern != null) {
            pattern.accept(this);
        }
        for (Param param : dataPattern.getParams()) {
            this.visitAnnotated(param);
        }
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitExternalRef(ExternalRefPattern externalRefPattern) {
        this.visitAnnotated(externalRefPattern);
        this.noteInheritNs(externalRefPattern.getNs());
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitName(NameNameClass nameNameClass) {
        this.visitAnnotated(nameNameClass);
        this.noteNs(nameNameClass.getPrefix(), nameNameClass.getNamespaceUri());
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitAnyName(AnyNameNameClass anyNameNameClass) {
        this.visitAnnotated(anyNameNameClass);
        NameClass nameClass = anyNameNameClass.getExcept();
        if (nameClass != null) {
            nameClass.accept(this);
        }
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitNsName(NsNameNameClass nsNameNameClass) {
        this.visitAnnotated(nsNameNameClass);
        this.noteInheritNs(nsNameNameClass.getNs());
        NameClass nameClass = nsNameNameClass.getExcept();
        if (nameClass != null) {
            nameClass.accept(this);
        }
        return VoidValue.VOID;
    }

    private void noteDatatypeLibrary(String string) {
        if (this.datatypeLibrary == null || this.datatypeLibrary.length() == 0) {
            this.datatypeLibrary = string;
        }
    }

    private void noteInheritNs(String string) {
        if (string == NameClass.INHERIT_NS) {
            this.haveInherit = true;
        } else {
            this.noPrefixNs = string;
        }
    }

    private void noteNs(String string, String string2) {
        if (string2 == NameClass.INHERIT_NS) {
            this.haveInherit = true;
            return;
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null || string2.length() == 0 && string.length() != 0 || this.prefixMap.containsKey(string)) {
            return;
        }
        this.prefixMap.put(string, string2);
    }

    private void noteContext(NamespaceContext namespaceContext) {
        if (namespaceContext == null || namespaceContext == this.lastContext) {
            return;
        }
        this.lastContext = namespaceContext;
        for (String string : namespaceContext.getPrefixes()) {
            this.noteNs(string, namespaceContext.getNamespace(string));
        }
    }

    Map<String, String> getPrefixMap() {
        if (this.haveInherit) {
            this.prefixMap.remove("");
        } else if (this.noPrefixNs != null && !this.prefixMap.containsKey("")) {
            this.prefixMap.put("", this.noPrefixNs);
        }
        this.prefixMap.put("xml", "http://www.w3.org/XML/1998/namespace");
        return this.prefixMap;
    }

    String getDatatypeLibrary() {
        return this.datatypeLibrary;
    }
}

