#!/bin/awk -f

BEGIN {
	print "# ==== playback file for sockperf - generated by gen1.awk ===="

	PPS = 200*1000
	NUM_RECORDS = PPS # 30*1000

	runtime = NUM_RECORDS/PPS
	interval = 1/PPS
	baseTime = 1	
	
	printf "#baseTime=%f; PPS=%d; runtime=%f; interval=%lf; NUM_RECORDS=%d\n", baseTime, PPS, runtime, interval, NUM_RECORDS
	
	deltaSize = 0
	minSize = 12
	maxSize = 50000 - minSize
	
	t = baseTime
	s = 0
	
	printf "# file contains %d records\n", NUM_RECORDS
	
	for (i = 0; i < NUM_RECORDS; i++) {
		t += interval
		s += deltaSize
		printf("%.9lf, %d\n", t, minSize+s%maxSize)
	}

	printf "#%d records were written successfuly\n", NUM_RECORDS
}
