/******************************************************************************
 * Copyright © 2012-2014 Institut für Nachrichtentechnik, Universität Rostock *
 * Copyright © 2006-2012 Quality & Usability Lab,                             *
 *                       Telekom Innovation Laboratories, TU Berlin           *
 *                                                                            *
 * This file is part of the SoundScape Renderer (SSR).                        *
 *                                                                            *
 * The SSR is free software:  you can redistribute it and/or modify it  under *
 * the terms of the  GNU  General  Public  License  as published by the  Free *
 * Software Foundation, either version 3 of the License,  or (at your option) *
 * any later version.                                                         *
 *                                                                            *
 * The SSR is distributed in the hope that it will be useful, but WITHOUT ANY *
 * WARRANTY;  without even the implied warranty of MERCHANTABILITY or FITNESS *
 * FOR A PARTICULAR PURPOSE.                                                  *
 * See the GNU General Public License for more details.                       *
 *                                                                            *
 * You should  have received a copy  of the GNU General Public License  along *
 * with this program.  If not, see <http://www.gnu.org/licenses/>.            *
 *                                                                            *
 * The SSR is a tool  for  real-time  spatial audio reproduction  providing a *
 * variety of rendering algorithms.                                           *
 *                                                                            *
 * http://spatialaudio.net/ssr                           ssr@spatialaudio.net *
 ******************************************************************************/

/// @file
/// QTimeLine

#ifndef SSR_QTIMELINE_H
#define SSR_QTIMELINE_H

#include <QtCore/QPoint>
#include <QtGui/QMouseEvent>
#include <QtGui/QPaintEvent>
#include <QtWidgets/QLabel>
#include <QtWidgets/QLineEdit>

#include "qtimeedit.h"

/// Qtimeline 
class QSSRTimeLine : public QLabel
{
  Q_OBJECT

  public:
    QSSRTimeLine( QWidget* parent = 0, unsigned int update_interval = 500u);

    void set_progress(float progress);
    void show_time_edit();
    void hide_time_edit();

  private:
    float _progress;
    unsigned int _lower_time_boundary;
    int          _mouse_pos_at_click;
    float        _progress_at_mouse_click;
    QString      _previous_time;

    QSSRTimeEdit*   _time_edit;

  protected:
    virtual void mousePressEvent(QMouseEvent *event);
    virtual void mouseMoveEvent(QMouseEvent *event);
    virtual void mouseDoubleClickEvent(QMouseEvent *event);
    virtual void mouseReleaseEvent(QMouseEvent *event);
    virtual void paintEvent( QPaintEvent * event);

  signals:
    void signal_transport_locate(float);

  private slots:
    void _interpret_time_edit();
};

#endif

// Settings for Vim (http://www.vim.org/), please do not remove:
// vim:softtabstop=2:shiftwidth=2:expandtab:textwidth=80:cindent
