use ui;
use graphics;
use core:geometry;

/**
 * Defaults for the visualizations.
 */

// Font for captions.
Font captionFont on Render = defaultFont();

// Default font when drawing data.
Font dataFont on Render = defaultFont();

// Font for variable names.
Font variableFont on Render = Font("Consolas", 12);

// Font for code.
Font codeFont on Render = Font("Consolas", 11, 20);

// Background color when drawing data.
Brush dataBg on Render = SolidBrush(white);

Brush dataReadBg on Render = SolidBrush(Color(0.7, 1, 0.7));
Brush dataWriteBg on Render = SolidBrush(Color(1, 0.7, 0.7));
Brush dataError on Render = SolidBrush(red);

// Text color when drawing text.
Brush dataFg on Render = SolidBrush(black);

// Text color when highlighting errors.
Brush errorFg on Render = SolidBrush(red);

// Regular link.
Brush activeLink on Render = SolidBrush(black);
Brush inactiveLink on Render = SolidBrush(Color(0, 0, 0, 0.4));

// Background color when drawing captions.
Brush captionBg on Render = SolidBrush(white * 0.8);
Brush captionActiveBg on Render = SolidBrush(white * 0.6 + blue);

// Text color when drawing captions.
Brush captionFg on Render = SolidBrush(black);

// Inner margin for data elements.
Size dataMargin on Render = Size(4, 2);

// Border for data elements.
Size dataBorder on Render = Size(4, 4);

// Border for composite data elements.
Size compositeBorder on Render = Size(4, 4);

// Offset for each stack frame.
Float stackOffset on Render = 4;

// Default code view size.
Size sourceSize on Render = Size(350, 200);

// Highlight color for source code.
Brush sourceHighlight on Render = SolidBrush(yellow);
Brush sourceSleepingHighlight on Render = SolidBrush(Color(0.8, 0.8, 1));
Brush sourceTerminatedHighlight on Render = SolidBrush(Color(1, 0.8, 0.8));
Brush sourceReturnedHighlight on Render = SolidBrush(Color(0.8, 1, 0.8));

// Button size in the thread controls.
Size buttonSize on Render = Size(30, 30);

// Marked color of a button.
Brush buttonBg on Render = SolidBrush(white);
Brush buttonMarked on Render = SolidBrush(white * 0.8 + blue);

// Layout spacing of objects.
Size layoutSpace on Render = Size(35, 20);

// Background and foreground of the problem panel.
Font panelCaption on Render = defaultFont;
Font panelButton on Render = { var x = defaultFont.clone; x.height = x.height * 0.9; x; };
Brush panelBg on Render = SolidBrush(Color(0, 0.9, 0, 0.8));
Brush panelFg on Render = SolidBrush(black);
