use core:debug;
use core:geometry;
// Make sure operators are properly defined.

/**
 * A value that only defines 'less than'. All operators should be present as well.
 */
value LessOp {
	init(Int v) {
		init() { v = v; }
	}

	Bool <(LessOp o) {
		return v < o.v;
	}

	private Int v;
}


Bool opLT(Int a, Int b) {
	LessOp(a) < LessOp(b);
}

Bool opGT(Int a, Int b) {
	LessOp(a) > LessOp(b);
}

Bool opLTE(Int a, Int b) {
	LessOp(a) <= LessOp(b);
}

Bool opGTE(Int a, Int b) {
	LessOp(a) >= LessOp(b);
}

Bool opEQ(Int a, Int b) {
	LessOp(a) == LessOp(b);
}

Bool opNEQ(Int a, Int b) {
	LessOp(a) != LessOp(b);
}

Bool opActorEQ(DbgActor a, DbgActor b) {
	a is b;
}

Bool opActorNEQ(DbgActor a, DbgActor b) {
	a !is b;
}


/**
 * Class that provides a value 'val' that is accessed through getters and setters (called properties
 * in some languages).
 */
class Property {
	init() {
		init() { v = 10; }
	}

	Int plain() {
		v;
	}

	void plain(Int to) {
		v = to;
	}

	Int val() {
		v;
	}

	assign val(Int to) {
		v = to;
	}

	assign set(Int to) {
		v = to;
	}

	private Int v;
}

Int testSetter() {
	Property p;
	p.set = 20;
	p.val;
}

Int testSetterPair() {
	Property p;
	p.val = 20;
	p.val;
}

Int testNoSetter() {
	Property p;
	// Should *not* work.
	p.plain = 20;
	p.plain;
}

Float testSetterCpp() {
	// Setters declared inside C++.
	Rect x(0, 0, 100, 100);
	x.size = Size(50, 50);
	x.p1.x;
}
