/*
 * Copyright (c) 2013, 2014 BalaBit IT Ltd, Budapest, Hungary
 * Copyright (c) 2013, 2014 Viktor Tusa <tusa@balabit.hu>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * As an additional exemption you are allowed to compile & link against the
 * OpenSSL libraries as published by the OpenSSL project. See the file
 * COPYING for details.
 *
 */

#include <lua.h>
#include <syslog-ng.h>

#ifndef _LUA_UTILS_H
#define  _LUA_UTILS_H

void *lua_check_and_convert_userdata(lua_State *state, int index, const char *type);
int lua_create_userdata_from_pointer(lua_State *state, void *data, const char *type);
gboolean lua_check_existence_of_global_variable(lua_State *state, const char *variable_name);
GlobalConfig *lua_get_config_from_current_state(lua_State *state);
void lua_register_utility_functions(lua_State *state);

#endif
