from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


_function_magic_marker = _Mock()

_method_magic_marker = _Mock()

arg_split = _Mock()

cell_magic = _Mock()

compress_dhist = _Mock()

decorator = _Mock()

dedent = _Mock()

error = _Mock()

getopt = _Mock()

iteritems = _Mock()

line_cell_magic = _Mock()

line_magic = _Mock()

magic_escapes = _Mock()

magic_kinds = _Mock()

magic_spec = _Mock()

magics = _Mock()

magics_class = _Mock()

needs_local_scope = _Mock()

oinspect = _Mock()

on_off = _Mock()

os = _Mock()

print_function = _Mock()

re = _Mock()

record_magic = _Mock()

register_cell_magic = _Mock()

register_line_cell_magic = _Mock()

register_line_magic = _Mock()

string_types = _Mock()

sys = _Mock()

types = _Mock()

validate_type = _Mock()

ESC_MAGIC = '%'

ESC_MAGIC2 = '%%'

_docstring_template = "Decorate the given {0} as {1} magic.\n\nThe decorator can be used with or without arguments, as follows.\n\ni) without arguments: it will create a {1} magic named as the {0} being\ndecorated::\n\n    @deco\n    def foo(...)\n\nwill create a {1} magic named `foo`.\n\nii) with one string argument: which will be used as the actual name of the\nresulting magic::\n\n    @deco('bar')\n    def foo(...)\n\nwill create a {1} magic named `bar`.\n"

class Bool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class Bunch(_Mock):
  pass


class Configurable(_Mock):
  pass


class Dict(_Mock):
  pass
  info_text = 'any value'

class GetoptError(_Mock):
  pass
  msg = ''
  opt = ''

class Instance(_Mock):
  pass
  info_text = 'any value'

class MagicAlias(_Mock):
  pass


class Magics(_Mock):
  pass
  registered = False

class MagicsManager(_Mock):
  pass


class MetaHasTraits(_Mock):
  pass


class Struct(_Mock):
  pass
  _allownew = True

class UsageError(_Mock):
  pass


