from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       






class QAbstractMessageHandler(_Mock):
  pass


class QAbstractUriResolver(_Mock):
  pass


class QAbstractXmlNodeModel(_Mock):
  pass
  FirstChild = 1
  NextSibling = 3
  Parent = 0
  PreviousSibling = 2

class QAbstractXmlReceiver(_Mock):
  pass


class QSimpleXmlNodeModel(_Mock):
  pass
  FirstChild = 1
  NextSibling = 3
  Parent = 0
  PreviousSibling = 2

class QSourceLocation(_Mock):
  pass


class QXmlFormatter(_Mock):
  pass


class QXmlItem(_Mock):
  pass


class QXmlName(_Mock):
  pass


class QXmlNamePool(_Mock):
  pass


class QXmlNodeModelIndex(_Mock):
  pass
  Attribute = 1
  Comment = 2
  Document = 4
  Element = 8
  Follows = 1
  Is = 0
  Namespace = 16
  Precedes = -1
  ProcessingInstruction = 32
  Text = 64

class QXmlQuery(_Mock):
  pass
  XQuery10 = 1
  XSLT20 = 2

class QXmlResultItems(_Mock):
  pass


class QXmlSchema(_Mock):
  pass


class QXmlSchemaValidator(_Mock):
  pass


class QXmlSerializer(_Mock):
  pass


