## TFSA-2022-038: Integer overflow in `OpLevelCostEstimator::CalculateTensorSize`

### CVE Number
CVE-2022-23575

### Impact
The [implementation of `OpLevelCostEstimator::CalculateTensorSize`](https://github.com/tensorflow/tensorflow/blob/a1320ec1eac186da1d03f033109191f715b2b130/tensorflow/core/grappler/costs/op_level_cost_estimator.cc#L1552-L1558) is vulnerable to an integer overflow if an attacker can create an operation which would involve a tensor with large enough number of elements:

```cc
int64_t OpLevelCostEstimator::CalculateTensorSize(
    const OpInfo::TensorProperties& tensor, bool* found_unknown_shapes) {
  int64_t count = CalculateTensorElementCount(tensor, found_unknown_shapes);
  int size = DataTypeSize(BaseType(tensor.dtype()));
  VLOG(2) << "Count: " << count << " DataTypeSize: " << size;
  return count * size;
}
```

Here, `count` and `size` can be large enough to cause `count * size` to overflow.

### Patches
We have patched the issue in GitHub commit [fcd18ce3101f245b083b30655c27b239dc72221e](https://github.com/tensorflow/tensorflow/commit/fcd18ce3101f245b083b30655c27b239dc72221e).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
