// swift-tools-version:5.3
import PackageDescription

let package = Package(
    name: "TreeSitterAsm",
    products: [
        .library(name: "TreeSitterAsm", targets: ["TreeSitterAsm"]),
    ],
    dependencies: [
        .package(url: "https://github.com/ChimeHQ/SwiftTreeSitter", from: "0.8.0"),
    ],
    targets: [
        .target(
            name: "TreeSitterAsm",
            dependencies: [],
            path: ".",
            sources: [
                "src/parser.c",
                // NOTE: if your language has an external scanner, add it here.
            ],
            resources: [
                .copy("queries")
            ],
            publicHeadersPath: "bindings/swift",
            cSettings: [.headerSearchPath("src")]
        ),
        .testTarget(
            name: "TreeSitterAsmTests",
            dependencies: [
                "SwiftTreeSitter",
                "TreeSitterAsm",
            ],
            path: "bindings/swift/TreeSitterAsmTests"
        )
    ],
    cLanguageStandard: .c11
)
