/* This file has been generated by the Perl script `afblue.pl', */
/* using data from file `./tablue.dat'.                         */

/* tablue.h */

/*
 * Copyright (C) 2013-2017 by Werner Lemberg.
 *
 * This file is part of the ttfautohint library, and may only be used,
 * modified, and distributed under the terms given in `COPYING'.  By
 * continuing to use, modify, or distribute this file you indicate that you
 * have read `COPYING' and understand and accept it fully.
 *
 * The file `COPYING' mentioned in the previous paragraph is distributed
 * with the ttfautohint library.
 */


/* originally file `afblue.h' (2013-Sep-11) from FreeType */


#ifndef TABLUE_H_
#define TABLUE_H_


  /* an auxiliary macro to decode a UTF-8 character -- since we only use */
  /* hard-coded, self-converted data, no error checking is performed */
#define GET_UTF8_CHAR(ch, p) \
  do \
  { \
    ch = (unsigned char)*p++; \
    if (ch >= 0x80) \
    { \
      FT_UInt len_; \
\
\
      if (ch < 0xE0) \
      { \
        len_ = 1; \
        ch &= 0x1F; \
      } \
      else if (ch < 0xF0) \
      { \
        len_ = 2; \
        ch &= 0x0F; \
      } \
      else \
      { \
        len_ = 3;\
        ch &= 0x07; \
      } \
\
      for (; len_ > 0; len_--) \
        ch = (ch << 6) | (*p++ & 0x3F); \
    } \
  } while (0)


/****************************************************************
 *
 *                        BLUE STRINGS
 *
 ****************************************************************/

/* At the bottommost level, we define strings for finding blue zones. */


#define TA_BLUE_STRING_MAX_LEN 27

/* The TA_Blue_String enumeration values are offsets into the */
/* `ta_blue_strings' array. */

typedef enum TA_Blue_String_
{
    TA_BLUE_STRING_ADLAM_CAPITAL_TOP = 0,
    TA_BLUE_STRING_ADLAM_CAPITAL_BOTTOM = 30,
    TA_BLUE_STRING_ADLAM_SMALL_TOP = 40,
    TA_BLUE_STRING_ADLAM_SMALL_BOTTOM = 65,
    TA_BLUE_STRING_ARABIC_TOP = 105,
    TA_BLUE_STRING_ARABIC_BOTTOM = 123,
    TA_BLUE_STRING_ARABIC_JOIN = 138,
    TA_BLUE_STRING_ARMENIAN_CAPITAL_TOP = 141,
    TA_BLUE_STRING_ARMENIAN_CAPITAL_BOTTOM = 165,
    TA_BLUE_STRING_ARMENIAN_SMALL_ASCENDER = 189,
    TA_BLUE_STRING_ARMENIAN_SMALL_TOP = 210,
    TA_BLUE_STRING_ARMENIAN_SMALL_BOTTOM = 234,
    TA_BLUE_STRING_ARMENIAN_SMALL_DESCENDER = 258,
    TA_BLUE_STRING_AVESTAN_TOP = 282,
    TA_BLUE_STRING_AVESTAN_BOTTOM = 302,
    TA_BLUE_STRING_BAMUM_TOP = 312,
    TA_BLUE_STRING_BAMUM_BOTTOM = 344,
    TA_BLUE_STRING_BENGALI_BASE = 376,
    TA_BLUE_STRING_BENGALI_TOP = 408,
    TA_BLUE_STRING_BENGALI_HEAD = 436,
    TA_BLUE_STRING_BUHID_TOP = 468,
    TA_BLUE_STRING_BUHID_LARGE = 476,
    TA_BLUE_STRING_BUHID_SMALL = 488,
    TA_BLUE_STRING_BUHID_BOTTOM = 504,
    TA_BLUE_STRING_CANADIAN_SYLLABICS_TOP = 532,
    TA_BLUE_STRING_CANADIAN_SYLLABICS_BOTTOM = 564,
    TA_BLUE_STRING_CANADIAN_SYLLABICS_SMALL_TOP = 596,
    TA_BLUE_STRING_CANADIAN_SYLLABICS_SMALL_BOTTOM = 628,
    TA_BLUE_STRING_CANADIAN_SYLLABICS_SUPS_TOP = 660,
    TA_BLUE_STRING_CANADIAN_SYLLABICS_SUPS_BOTTOM = 688,
    TA_BLUE_STRING_CARIAN_TOP = 720,
    TA_BLUE_STRING_CARIAN_BOTTOM = 760,
    TA_BLUE_STRING_CHAKMA_TOP = 795,
    TA_BLUE_STRING_CHAKMA_BOTTOM = 820,
    TA_BLUE_STRING_CHAKMA_DESCENDER = 845,
    TA_BLUE_STRING_CHEROKEE_CAPITAL = 910,
    TA_BLUE_STRING_CHEROKEE_SMALL_ASCENDER = 942,
    TA_BLUE_STRING_CHEROKEE_SMALL = 974,
    TA_BLUE_STRING_CHEROKEE_SMALL_DESCENDER = 1006,
    TA_BLUE_STRING_COPTIC_CAPITAL_TOP = 1022,
    TA_BLUE_STRING_COPTIC_CAPITAL_BOTTOM = 1054,
    TA_BLUE_STRING_COPTIC_SMALL_TOP = 1086,
    TA_BLUE_STRING_COPTIC_SMALL_BOTTOM = 1118,
    TA_BLUE_STRING_CYPRIOT_TOP = 1150,
    TA_BLUE_STRING_CYPRIOT_BOTTOM = 1190,
    TA_BLUE_STRING_CYPRIOT_SMALL = 1225,
    TA_BLUE_STRING_CYRILLIC_CAPITAL_TOP = 1240,
    TA_BLUE_STRING_CYRILLIC_CAPITAL_BOTTOM = 1264,
    TA_BLUE_STRING_CYRILLIC_SMALL = 1288,
    TA_BLUE_STRING_CYRILLIC_SMALL_DESCENDER = 1312,
    TA_BLUE_STRING_DESERET_CAPITAL_TOP = 1321,
    TA_BLUE_STRING_DESERET_CAPITAL_BOTTOM = 1346,
    TA_BLUE_STRING_DESERET_SMALL_TOP = 1371,
    TA_BLUE_STRING_DESERET_SMALL_BOTTOM = 1396,
    TA_BLUE_STRING_DEVANAGARI_BASE = 1421,
    TA_BLUE_STRING_DEVANAGARI_TOP = 1453,
    TA_BLUE_STRING_DEVANAGARI_HEAD = 1485,
    TA_BLUE_STRING_DEVANAGARI_BOTTOM = 1517,
    TA_BLUE_STRING_ETHIOPIC_TOP = 1525,
    TA_BLUE_STRING_ETHIOPIC_BOTTOM = 1557,
    TA_BLUE_STRING_GEORGIAN_MKHEDRULI_TOP = 1589,
    TA_BLUE_STRING_GEORGIAN_MKHEDRULI_BOTTOM = 1621,
    TA_BLUE_STRING_GEORGIAN_MKHEDRULI_ASCENDER = 1653,
    TA_BLUE_STRING_GEORGIAN_MKHEDRULI_DESCENDER = 1685,
    TA_BLUE_STRING_GEORGIAN_ASOMTAVRULI_TOP = 1717,
    TA_BLUE_STRING_GEORGIAN_ASOMTAVRULI_BOTTOM = 1749,
    TA_BLUE_STRING_GEORGIAN_NUSKHURI_TOP = 1781,
    TA_BLUE_STRING_GEORGIAN_NUSKHURI_BOTTOM = 1813,
    TA_BLUE_STRING_GEORGIAN_NUSKHURI_ASCENDER = 1845,
    TA_BLUE_STRING_GEORGIAN_NUSKHURI_DESCENDER = 1877,
    TA_BLUE_STRING_GLAGOLITIC_CAPITAL_TOP = 1909,
    TA_BLUE_STRING_GLAGOLITIC_CAPITAL_BOTTOM = 1941,
    TA_BLUE_STRING_GLAGOLITIC_SMALL_TOP = 1973,
    TA_BLUE_STRING_GLAGOLITIC_SMALL_BOTTOM = 2005,
    TA_BLUE_STRING_GOTHIC_TOP = 2037,
    TA_BLUE_STRING_GOTHIC_BOTTOM = 2077,
    TA_BLUE_STRING_GREEK_CAPITAL_TOP = 2097,
    TA_BLUE_STRING_GREEK_CAPITAL_BOTTOM = 2118,
    TA_BLUE_STRING_GREEK_SMALL_BETA_TOP = 2136,
    TA_BLUE_STRING_GREEK_SMALL = 2154,
    TA_BLUE_STRING_GREEK_SMALL_DESCENDER = 2178,
    TA_BLUE_STRING_GUJARATI_TOP = 2202,
    TA_BLUE_STRING_GUJARATI_BOTTOM = 2234,
    TA_BLUE_STRING_GUJARATI_ASCENDER = 2266,
    TA_BLUE_STRING_GUJARATI_DESCENDER = 2316,
    TA_BLUE_STRING_GUJARATI_DIGIT_TOP = 2349,
    TA_BLUE_STRING_GURMUKHI_BASE = 2369,
    TA_BLUE_STRING_GURMUKHI_HEAD = 2401,
    TA_BLUE_STRING_GURMUKHI_TOP = 2433,
    TA_BLUE_STRING_GURMUKHI_BOTTOM = 2465,
    TA_BLUE_STRING_GURMUKHI_DIGIT_TOP = 2497,
    TA_BLUE_STRING_HEBREW_TOP = 2517,
    TA_BLUE_STRING_HEBREW_BOTTOM = 2541,
    TA_BLUE_STRING_HEBREW_DESCENDER = 2559,
    TA_BLUE_STRING_KANNADA_TOP = 2574,
    TA_BLUE_STRING_KANNADA_BOTTOM = 2618,
    TA_BLUE_STRING_KAYAH_LI_TOP = 2650,
    TA_BLUE_STRING_KAYAH_LI_BOTTOM = 2674,
    TA_BLUE_STRING_KAYAH_LI_ASCENDER = 2694,
    TA_BLUE_STRING_KAYAH_LI_DESCENDER = 2702,
    TA_BLUE_STRING_KAYAH_LI_LARGE_DESCENDER = 2714,
    TA_BLUE_STRING_KHMER_TOP = 2735,
    TA_BLUE_STRING_KHMER_SUBSCRIPT_TOP = 2759,
    TA_BLUE_STRING_KHMER_BOTTOM = 2799,
    TA_BLUE_STRING_KHMER_DESCENDER = 2831,
    TA_BLUE_STRING_KHMER_LARGE_DESCENDER = 2865,
    TA_BLUE_STRING_KHMER_SYMBOLS_WAXING_TOP = 2952,
    TA_BLUE_STRING_KHMER_SYMBOLS_WANING_BOTTOM = 2960,
    TA_BLUE_STRING_LAO_TOP = 2968,
    TA_BLUE_STRING_LAO_BOTTOM = 3000,
    TA_BLUE_STRING_LAO_ASCENDER = 3032,
    TA_BLUE_STRING_LAO_LARGE_ASCENDER = 3048,
    TA_BLUE_STRING_LAO_DESCENDER = 3060,
    TA_BLUE_STRING_LATIN_CAPITAL_TOP = 3084,
    TA_BLUE_STRING_LATIN_CAPITAL_BOTTOM = 3100,
    TA_BLUE_STRING_LATIN_SMALL_F_TOP = 3116,
    TA_BLUE_STRING_LATIN_SMALL_TOP = 3130,
    TA_BLUE_STRING_LATIN_SMALL_BOTTOM = 3146,
    TA_BLUE_STRING_LATIN_SMALL_DESCENDER = 3162,
    TA_BLUE_STRING_LATIN_SUBS_CAPITAL_TOP = 3172,
    TA_BLUE_STRING_LATIN_SUBS_CAPITAL_BOTTOM = 3192,
    TA_BLUE_STRING_LATIN_SUBS_SMALL_F_TOP = 3212,
    TA_BLUE_STRING_LATIN_SUBS_SMALL = 3232,
    TA_BLUE_STRING_LATIN_SUBS_SMALL_DESCENDER = 3268,
    TA_BLUE_STRING_LATIN_SUPS_CAPITAL_TOP = 3288,
    TA_BLUE_STRING_LATIN_SUPS_CAPITAL_BOTTOM = 3319,
    TA_BLUE_STRING_LATIN_SUPS_SMALL_F_TOP = 3348,
    TA_BLUE_STRING_LATIN_SUPS_SMALL = 3374,
    TA_BLUE_STRING_LATIN_SUPS_SMALL_DESCENDER = 3399,
    TA_BLUE_STRING_LISU_TOP = 3410,
    TA_BLUE_STRING_LISU_BOTTOM = 3442,
    TA_BLUE_STRING_MALAYALAM_TOP = 3474,
    TA_BLUE_STRING_MALAYALAM_BOTTOM = 3518,
    TA_BLUE_STRING_MYANMAR_TOP = 3550,
    TA_BLUE_STRING_MYANMAR_BOTTOM = 3582,
    TA_BLUE_STRING_MYANMAR_ASCENDER = 3614,
    TA_BLUE_STRING_MYANMAR_DESCENDER = 3642,
    TA_BLUE_STRING_NKO_TOP = 3674,
    TA_BLUE_STRING_NKO_BOTTOM = 3698,
    TA_BLUE_STRING_NKO_SMALL_TOP = 3713,
    TA_BLUE_STRING_NKO_SMALL_BOTTOM = 3722,
    TA_BLUE_STRING_OL_CHIKI = 3734,
    TA_BLUE_STRING_OLD_TURKIC_TOP = 3758,
    TA_BLUE_STRING_OLD_TURKIC_BOTTOM = 3773,
    TA_BLUE_STRING_OSAGE_CAPITAL_TOP = 3793,
    TA_BLUE_STRING_OSAGE_CAPITAL_BOTTOM = 3833,
    TA_BLUE_STRING_OSAGE_CAPITAL_DESCENDER = 3863,
    TA_BLUE_STRING_OSAGE_SMALL_TOP = 3878,
    TA_BLUE_STRING_OSAGE_SMALL_BOTTOM = 3918,
    TA_BLUE_STRING_OSAGE_SMALL_ASCENDER = 3958,
    TA_BLUE_STRING_OSAGE_SMALL_DESCENDER = 3983,
    TA_BLUE_STRING_OSMANYA_TOP = 3998,
    TA_BLUE_STRING_OSMANYA_BOTTOM = 4038,
    TA_BLUE_STRING_SAURASHTRA_TOP = 4078,
    TA_BLUE_STRING_SAURASHTRA_BOTTOM = 4110,
    TA_BLUE_STRING_SHAVIAN_TOP = 4130,
    TA_BLUE_STRING_SHAVIAN_BOTTOM = 4140,
    TA_BLUE_STRING_SHAVIAN_DESCENDER = 4165,
    TA_BLUE_STRING_SHAVIAN_SMALL_TOP = 4175,
    TA_BLUE_STRING_SHAVIAN_SMALL_BOTTOM = 4210,
    TA_BLUE_STRING_SINHALA_TOP = 4225,
    TA_BLUE_STRING_SINHALA_BOTTOM = 4257,
    TA_BLUE_STRING_SINHALA_DESCENDER = 4289,
    TA_BLUE_STRING_SUNDANESE_TOP = 4333,
    TA_BLUE_STRING_SUNDANESE_BOTTOM = 4357,
    TA_BLUE_STRING_SUNDANESE_DESCENDER = 4389,
    TA_BLUE_STRING_TAI_VIET_TOP = 4397,
    TA_BLUE_STRING_TAI_VIET_BOTTOM = 4417,
    TA_BLUE_STRING_TAMIL_TOP = 4429,
    TA_BLUE_STRING_TAMIL_BOTTOM = 4461,
    TA_BLUE_STRING_TELUGU_TOP = 4493,
    TA_BLUE_STRING_TELUGU_BOTTOM = 4521,
    TA_BLUE_STRING_THAI_TOP = 4549,
    TA_BLUE_STRING_THAI_BOTTOM = 4573,
    TA_BLUE_STRING_THAI_ASCENDER = 4601,
    TA_BLUE_STRING_THAI_LARGE_ASCENDER = 4613,
    TA_BLUE_STRING_THAI_DESCENDER = 4625,
    TA_BLUE_STRING_THAI_LARGE_DESCENDER = 4641,
    TA_BLUE_STRING_THAI_DIGIT_TOP = 4649,
    TA_BLUE_STRING_TIFINAGH = 4661,
    TA_BLUE_STRING_VAI_TOP = 4693,
    TA_BLUE_STRING_VAI_BOTTOM = 4725,


  TA_BLUE_STRING_MAX   /* do not remove */
} TA_Blue_String;


extern const char ta_blue_strings[];


/****************************************************************
 *
 *                      BLUE STRINGSETS
 *
 ****************************************************************/

/* The next level is to group blue strings into style-specific sets. */


/* Properties are specific to a writing system.  We assume that a given */
/* blue string can't be used in more than a single writing system, which */
/* is a safe bet. */
#define TA_BLUE_PROPERTY_LATIN_TOP (1U << 0) /* must have value 1 */
#define TA_BLUE_PROPERTY_LATIN_SUB_TOP (1U << 1)
#define TA_BLUE_PROPERTY_LATIN_NEUTRAL (1U << 2)
#define TA_BLUE_PROPERTY_LATIN_X_HEIGHT (1U << 3)
#define TA_BLUE_PROPERTY_LATIN_LONG (1U << 4)


#define TA_BLUE_STRINGSET_MAX_LEN 8

/* The TA_Blue_Stringset enumeration values are offsets into the */
/* `ta_blue_stringsets' array. */

typedef enum TA_Blue_Stringset_
{
    TA_BLUE_STRINGSET_ADLM = 0,
    TA_BLUE_STRINGSET_ARAB = 5,
    TA_BLUE_STRINGSET_ARMN = 9,
    TA_BLUE_STRINGSET_AVST = 16,
    TA_BLUE_STRINGSET_BAMU = 19,
    TA_BLUE_STRINGSET_BENG = 22,
    TA_BLUE_STRINGSET_BUHD = 27,
    TA_BLUE_STRINGSET_CAKM = 32,
    TA_BLUE_STRINGSET_CANS = 36,
    TA_BLUE_STRINGSET_CARI = 43,
    TA_BLUE_STRINGSET_CHER = 46,
    TA_BLUE_STRINGSET_COPT = 53,
    TA_BLUE_STRINGSET_CPRT = 58,
    TA_BLUE_STRINGSET_CYRL = 63,
    TA_BLUE_STRINGSET_DEVA = 69,
    TA_BLUE_STRINGSET_DSRT = 75,
    TA_BLUE_STRINGSET_ETHI = 80,
    TA_BLUE_STRINGSET_GEOR = 83,
    TA_BLUE_STRINGSET_GEOK = 88,
    TA_BLUE_STRINGSET_GLAG = 95,
    TA_BLUE_STRINGSET_GOTH = 100,
    TA_BLUE_STRINGSET_GREK = 103,
    TA_BLUE_STRINGSET_GUJR = 110,
    TA_BLUE_STRINGSET_GURU = 116,
    TA_BLUE_STRINGSET_HEBR = 122,
    TA_BLUE_STRINGSET_KALI = 126,
    TA_BLUE_STRINGSET_KNDA = 132,
    TA_BLUE_STRINGSET_KHMR = 135,
    TA_BLUE_STRINGSET_KHMS = 141,
    TA_BLUE_STRINGSET_LAO = 144,
    TA_BLUE_STRINGSET_LATN = 150,
    TA_BLUE_STRINGSET_LATB = 157,
    TA_BLUE_STRINGSET_LATP = 164,
    TA_BLUE_STRINGSET_LISU = 171,
    TA_BLUE_STRINGSET_MLYM = 174,
    TA_BLUE_STRINGSET_MYMR = 177,
    TA_BLUE_STRINGSET_NKOO = 182,
    TA_BLUE_STRINGSET_NONE = 187,
    TA_BLUE_STRINGSET_OLCK = 188,
    TA_BLUE_STRINGSET_ORKH = 191,
    TA_BLUE_STRINGSET_OSGE = 194,
    TA_BLUE_STRINGSET_OSMA = 202,
    TA_BLUE_STRINGSET_SAUR = 205,
    TA_BLUE_STRINGSET_SHAW = 208,
    TA_BLUE_STRINGSET_SINH = 214,
    TA_BLUE_STRINGSET_SUND = 218,
    TA_BLUE_STRINGSET_TAML = 222,
    TA_BLUE_STRINGSET_TAVT = 225,
    TA_BLUE_STRINGSET_TELU = 228,
    TA_BLUE_STRINGSET_THAI = 231,
    TA_BLUE_STRINGSET_TFNG = 239,
    TA_BLUE_STRINGSET_VAII = 242,


  TA_BLUE_STRINGSET_MAX   /* do not remove */
} TA_Blue_Stringset;


typedef struct TA_Blue_StringRec_
{
  TA_Blue_String string;
  FT_UShort properties;
} TA_Blue_StringRec;


extern const TA_Blue_StringRec ta_blue_stringsets[];

#endif /* TABLUE_H_ */

/* end of tablue.h */
