/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef CLICKFIXLABEL_H
#define CLICKFIXLABEL_H
#include <QLabel>
class ClickFixLabel : public QLabel
{
    Q_OBJECT
public:
    ClickFixLabel(QWidget *parent = nullptr);
    ~ClickFixLabel();
    void setText(const QString & text, bool saveTextFlag = true);
protected:
    void mouseDoubleClickEvent(QMouseEvent *event);
    void paintEvent(QPaintEvent *event);
Q_SIGNALS:
    void doubleClicked();
private:
    QString mStr;
};



#endif // CLICKFIXLABEL_H
