
class SocketState:
    Initial = ...       # type: SocketState
    Connecting = ...    # type: SocketState
    Connected = ...     # type: SocketState
    Opening = ...       # type: SocketState
    Listening = ...     # type: SocketState
    Closing = ...       # type: SocketState
    Closed = ...        # type: SocketState
    Error = ...         # type: SocketState

class MessagePtr: ...

class SocketListener:
    def __init__(self) -> None: ...
    def __del__ (self) -> None: ...

    def getSocket(self) -> Socket: ...
    def stateChanged(self, newState: SocketState) -> None: ...
    def messageReceived(self) -> None: ...
    def error(self, error: Error) -> None: ...

class Socket:
    def __init__(self) -> None: ...
    def __del__ (self) -> None: ...

    def getState(self) -> SocketState: ...

    def getLastError(self) -> Error: ...
    def clearError(self) -> None: ...

    def addListener(self, listener: SocketListener) -> None: ...
    def removeListener(self, listener: SocketListener) -> None: ...

    def connect(self, address: str, port: int) -> None: ...
    def listen(self, address: str, port: int) -> None: ...
    def close(self) -> None: ...
    def reset(self) -> None: ...

    def sendMessage(self, message: MessagePtr) -> None: ...
    def takeNextMessage(self) -> MessagePtr: ...
    def createMessage(self, type_name: str) -> MessagePtr: ...

    def registerAllMessageTypes(self, file_name: str) -> bool: ...

class ErrorCode:
    UnknownError = ...                      # type: ErrorCode
    CreationError = ...                     # type: ErrorCode
    ConnectFailedError = ...                # type: ErrorCode
    BindFailedError = ...                   # type: ErrorCode
    AcceptFailedError = ...                 # type: ErrorCode
    SendFailedError = ...                   # type: ErrorCode
    ReceiveFailedError = ...                # type: ErrorCode
    UnknownMessageTypeError = ...           # type: ErrorCode
    ParseFailedError = ...                  # type: ErrorCode
    ConnectionResetError = ...              # type: ErrorCode
    MessageRegistrationFailedError = ...    # type: ErrorCode
    InvalidStateError = ...                 # type: ErrorCode
    InvalidMessageError = ...               # type: ErrorCode
    Debug = ...                             # type: ErrorCode

class Error:
    def __init__(self) -> None: ...
    # Error(ErrorCode::ErrorCode error_code, const std::string& error_message);
    # Error(const Error& error);

    def getErrorCode(self) -> ErrorCode: ...
    def getErrorMessage(self) -> str: ...
    def isFatalError(self) -> bool: ...
    def isValid(self) -> bool: ...
    def setFatalError(self, fatal: bool) -> None: ...

    def  __repr__(self) -> str: ...
