/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp9_ = _type_arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp10_;
			_tmp11_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp16_;
	gboolean _tmp566_ = FALSE;
	gboolean _tmp567_ = FALSE;
	gboolean _tmp568_ = FALSE;
	ValaExpression* _tmp569_;
	ValaExpression* _tmp570_;
	ValaSymbol* _tmp596_;
	ValaSymbol* _tmp597_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp651_;
	ValaSymbol* _tmp652_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp653_;
	ValaSymbol* _tmp654_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1041_;
	ValaSymbol* _tmp1042_;
	ValaSymbol* _tmp1044_;
	ValaVersionAttribute* _tmp1045_;
	ValaVersionAttribute* _tmp1046_;
	ValaSourceReference* _tmp1047_;
	ValaSourceReference* _tmp1048_;
	gboolean _tmp1049_ = FALSE;
	ValaSymbolAccessibility _tmp1050_;
	gboolean _tmp1106_ = FALSE;
	gboolean _tmp1133_ = FALSE;
	gboolean _tmp1134_ = FALSE;
	ValaDataType* _tmp1386_;
	ValaDataType* _tmp1387_;
	gboolean _tmp1390_;
	gboolean _tmp1391_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp13_ = _type_arg_list;
			_tmp14_ = vala_list_get (_tmp13_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp15_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp16_ = self->priv->_qualified;
	if (_tmp16_) {
		ValaNamespace* _tmp17_;
		ValaNamespace* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaScope* _tmp20_;
		ValaScope* _tmp21_;
		const gchar* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		_tmp17_ = vala_code_context_get_root (context);
		_tmp18_ = _tmp17_;
		base_symbol = (ValaSymbol*) _tmp18_;
		_tmp19_ = base_symbol;
		_tmp20_ = vala_symbol_get_scope (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->_member_name;
		_tmp23_ = vala_scope_lookup (_tmp21_, _tmp22_);
		_tmp24_ = _tmp23_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp24_);
		_vala_code_node_unref0 (_tmp24_);
	} else {
		ValaExpression* _tmp25_;
		ValaExpression* _tmp26_;
		_tmp25_ = vala_member_access_get_inner (self);
		_tmp26_ = _tmp25_;
		if (_tmp26_ == NULL) {
			const gchar* _tmp27_;
			ValaSemanticAnalyzer* _tmp32_;
			ValaSemanticAnalyzer* _tmp33_;
			ValaSymbol* _tmp34_;
			ValaSymbol* _tmp35_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp36_;
			ValaSemanticAnalyzer* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaSymbol* _tmp39_;
			gboolean _tmp138_ = FALSE;
			ValaSymbol* _tmp139_;
			ValaSymbol* _tmp140_;
			_tmp27_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp27_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp28_;
				ValaSemanticAnalyzer* _tmp29_;
				_tmp28_ = vala_code_context_get_analyzer (context);
				_tmp29_ = _tmp28_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp29_)) {
					ValaSourceReference* _tmp30_;
					ValaSourceReference* _tmp31_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp31_ = _tmp30_;
					vala_report_error (_tmp31_, "This access invalid outside of instance methods");
					result = FALSE;
					return result;
				}
			}
			_tmp32_ = vala_code_context_get_analyzer (context);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_semantic_analyzer_get_current_symbol (_tmp33_);
			_tmp35_ = _tmp34_;
			base_symbol = _tmp35_;
			method_found = FALSE;
			_tmp36_ = vala_code_context_get_analyzer (context);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_semantic_analyzer_get_current_symbol (_tmp37_);
			_tmp39_ = _tmp38_;
			sym = _tmp39_;
			while (TRUE) {
				gboolean _tmp40_ = FALSE;
				ValaSymbol* _tmp41_;
				ValaSymbol* _tmp87_;
				const gchar* _tmp88_;
				ValaSymbol* _tmp89_;
				ValaSymbol* _tmp90_;
				gboolean _tmp91_ = FALSE;
				gboolean _tmp92_ = FALSE;
				ValaSymbol* _tmp93_;
				ValaSymbol* _tmp94_;
				ValaSymbol* _tmp132_;
				ValaSymbol* _tmp133_;
				ValaSymbol* _tmp135_;
				ValaSymbol* _tmp136_;
				ValaSymbol* _tmp137_;
				_tmp41_ = sym;
				if (_tmp41_ != NULL) {
					ValaSymbol* _tmp42_;
					ValaSymbol* _tmp43_;
					_tmp42_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp43_ = _tmp42_;
					_tmp40_ = _tmp43_ == NULL;
				} else {
					_tmp40_ = FALSE;
				}
				if (!_tmp40_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp44_;
					_tmp44_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp44_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp45_;
						ValaCreationMethod* _tmp46_;
						ValaParameter* _tmp47_;
						ValaParameter* _tmp48_;
						_tmp45_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp46_ = cm;
						_tmp47_ = vala_method_get_this_parameter ((ValaMethod*) _tmp46_);
						_tmp48_ = _tmp47_;
						this_parameter = _tmp48_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp49_;
						_tmp49_ = sym;
						if (VALA_IS_PROPERTY (_tmp49_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp50_;
							ValaProperty* _tmp51_;
							ValaParameter* _tmp52_;
							ValaParameter* _tmp53_;
							ValaProperty* _tmp54_;
							ValaMemberBinding _tmp55_;
							ValaMemberBinding _tmp56_;
							ValaProperty* _tmp57_;
							ValaMemberBinding _tmp58_;
							ValaMemberBinding _tmp59_;
							_tmp50_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp51_ = prop;
							_tmp52_ = vala_property_get_this_parameter (_tmp51_);
							_tmp53_ = _tmp52_;
							this_parameter = _tmp53_;
							_tmp54_ = prop;
							_tmp55_ = vala_property_get_binding (_tmp54_);
							_tmp56_ = _tmp55_;
							may_access_instance_members = _tmp56_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_binding (_tmp57_);
							_tmp59_ = _tmp58_;
							may_access_klass_members = _tmp59_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp60_;
							_tmp60_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp60_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp61_;
								ValaConstructor* _tmp62_;
								ValaParameter* _tmp63_;
								ValaParameter* _tmp64_;
								ValaConstructor* _tmp65_;
								ValaMemberBinding _tmp66_;
								ValaMemberBinding _tmp67_;
								_tmp61_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp62_ = c;
								_tmp63_ = vala_constructor_get_this_parameter (_tmp62_);
								_tmp64_ = _tmp63_;
								this_parameter = _tmp64_;
								_tmp65_ = c;
								_tmp66_ = vala_constructor_get_binding (_tmp65_);
								_tmp67_ = _tmp66_;
								may_access_instance_members = _tmp67_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp68_;
								_tmp68_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp68_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp69_;
									ValaDestructor* _tmp70_;
									ValaParameter* _tmp71_;
									ValaParameter* _tmp72_;
									ValaDestructor* _tmp73_;
									ValaMemberBinding _tmp74_;
									ValaMemberBinding _tmp75_;
									_tmp69_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp70_ = d;
									_tmp71_ = vala_destructor_get_this_parameter (_tmp70_);
									_tmp72_ = _tmp71_;
									this_parameter = _tmp72_;
									_tmp73_ = d;
									_tmp74_ = vala_destructor_get_binding (_tmp73_);
									_tmp75_ = _tmp74_;
									may_access_instance_members = _tmp75_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp76_;
									_tmp76_ = sym;
									if (VALA_IS_METHOD (_tmp76_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp77_;
										ValaMethod* _tmp78_;
										ValaParameter* _tmp79_;
										ValaParameter* _tmp80_;
										ValaMethod* _tmp81_;
										ValaMemberBinding _tmp82_;
										ValaMemberBinding _tmp83_;
										ValaMethod* _tmp84_;
										ValaMemberBinding _tmp85_;
										ValaMemberBinding _tmp86_;
										_tmp77_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, VALA_TYPE_METHOD, ValaMethod);
										_tmp78_ = m;
										_tmp79_ = vala_method_get_this_parameter (_tmp78_);
										_tmp80_ = _tmp79_;
										this_parameter = _tmp80_;
										_tmp81_ = m;
										_tmp82_ = vala_method_get_binding (_tmp81_);
										_tmp83_ = _tmp82_;
										may_access_instance_members = _tmp83_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp84_ = m;
										_tmp85_ = vala_method_get_binding (_tmp84_);
										_tmp86_ = _tmp85_;
										may_access_klass_members = _tmp86_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp87_ = sym;
				_tmp88_ = self->priv->_member_name;
				_tmp89_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp87_, _tmp88_);
				_tmp90_ = _tmp89_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp90_);
				_vala_code_node_unref0 (_tmp90_);
				_tmp93_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp94_ = _tmp93_;
				if (_tmp94_ == NULL) {
					ValaSymbol* _tmp95_;
					_tmp95_ = sym;
					_tmp92_ = VALA_IS_TYPESYMBOL (_tmp95_);
				} else {
					_tmp92_ = FALSE;
				}
				if (_tmp92_) {
					_tmp91_ = may_access_instance_members;
				} else {
					_tmp91_ = FALSE;
				}
				if (_tmp91_) {
					ValaParameter* _tmp96_;
					ValaDataType* _tmp97_;
					ValaDataType* _tmp98_;
					const gchar* _tmp99_;
					ValaSymbol* _tmp100_;
					ValaSymbol* _tmp101_;
					gboolean _tmp102_ = FALSE;
					ValaSymbol* _tmp103_;
					ValaSymbol* _tmp104_;
					_tmp96_ = this_parameter;
					_tmp97_ = vala_variable_get_variable_type ((ValaVariable*) _tmp96_);
					_tmp98_ = _tmp97_;
					_tmp99_ = self->priv->_member_name;
					_tmp100_ = vala_data_type_get_member (_tmp98_, _tmp99_);
					_tmp101_ = _tmp100_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp101_);
					_vala_code_node_unref0 (_tmp101_);
					_tmp103_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp104_ = _tmp103_;
					if (_tmp104_ != NULL) {
						ValaSymbol* _tmp105_;
						ValaSymbol* _tmp106_;
						_tmp105_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp106_ = _tmp105_;
						_tmp102_ = vala_member_access_is_instance_symbol (_tmp106_);
					} else {
						_tmp102_ = FALSE;
					}
					if (_tmp102_) {
						ValaSourceReference* _tmp107_;
						ValaSourceReference* _tmp108_;
						ValaMemberAccess* _tmp109_;
						ValaMemberAccess* _tmp110_;
						ValaExpression* _tmp111_;
						ValaExpression* _tmp112_;
						ValaParameter* _tmp113_;
						ValaDataType* _tmp114_;
						ValaDataType* _tmp115_;
						ValaDataType* _tmp116_;
						ValaDataType* _tmp117_;
						ValaExpression* _tmp118_;
						ValaExpression* _tmp119_;
						ValaDataType* _tmp120_;
						ValaDataType* _tmp121_;
						ValaExpression* _tmp122_;
						ValaExpression* _tmp123_;
						ValaParameter* _tmp124_;
						ValaExpression* _tmp125_;
						ValaExpression* _tmp126_;
						ValaDataType* _tmp127_;
						ValaDataType* _tmp128_;
						const gchar* _tmp129_;
						ValaSymbol* _tmp130_;
						ValaSymbol* _tmp131_;
						_tmp107_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp108_ = _tmp107_;
						_tmp109_ = vala_member_access_new (NULL, "this", _tmp108_);
						_tmp110_ = _tmp109_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp110_);
						_vala_code_node_unref0 (_tmp110_);
						_tmp111_ = vala_member_access_get_inner (self);
						_tmp112_ = _tmp111_;
						_tmp113_ = this_parameter;
						_tmp114_ = vala_variable_get_variable_type ((ValaVariable*) _tmp113_);
						_tmp115_ = _tmp114_;
						_tmp116_ = vala_data_type_copy (_tmp115_);
						_tmp117_ = _tmp116_;
						vala_expression_set_value_type (_tmp112_, _tmp117_);
						_vala_code_node_unref0 (_tmp117_);
						_tmp118_ = vala_member_access_get_inner (self);
						_tmp119_ = _tmp118_;
						_tmp120_ = vala_expression_get_value_type (_tmp119_);
						_tmp121_ = _tmp120_;
						vala_data_type_set_value_owned (_tmp121_, FALSE);
						_tmp122_ = vala_member_access_get_inner (self);
						_tmp123_ = _tmp122_;
						_tmp124_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp123_, (ValaSymbol*) _tmp124_);
						_tmp125_ = vala_member_access_get_inner (self);
						_tmp126_ = _tmp125_;
						_tmp127_ = vala_expression_get_value_type (_tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = self->priv->_member_name;
						_tmp130_ = vala_data_type_get_member (_tmp128_, _tmp129_);
						_tmp131_ = _tmp130_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp131_);
						_vala_code_node_unref0 (_tmp131_);
					}
				}
				_tmp132_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp133_ = _tmp132_;
				if (_tmp133_ == NULL) {
					ValaSymbol* _tmp134_;
					_tmp134_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp134_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp135_ = sym;
				_tmp136_ = vala_symbol_get_parent_symbol (_tmp135_);
				_tmp137_ = _tmp136_;
				sym = _tmp137_;
			}
			_tmp139_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp140_ = _tmp139_;
			if (_tmp140_ == NULL) {
				ValaSourceReference* _tmp141_;
				ValaSourceReference* _tmp142_;
				_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp142_ = _tmp141_;
				_tmp138_ = _tmp142_ != NULL;
			} else {
				_tmp138_ = FALSE;
			}
			if (_tmp138_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp143_;
					ValaSourceReference* _tmp144_;
					ValaList* _tmp145_;
					ValaList* _tmp146_;
					ValaList* _tmp147_;
					gint _ns_size = 0;
					ValaList* _tmp148_;
					gint _tmp149_;
					gint _tmp150_;
					gint _ns_index = 0;
					_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp144_ = _tmp143_;
					_tmp145_ = vala_source_reference_get_using_directives (_tmp144_);
					_tmp146_ = _tmp145_;
					_tmp147_ = _vala_iterable_ref0 (_tmp146_);
					_ns_list = _tmp147_;
					_tmp148_ = _ns_list;
					_tmp149_ = vala_collection_get_size ((ValaCollection*) _tmp148_);
					_tmp150_ = _tmp149_;
					_ns_size = _tmp150_;
					_ns_index = -1;
					while (TRUE) {
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp151_;
						gpointer _tmp152_;
						ValaUsingDirective* _tmp153_;
						gboolean _tmp154_;
						gboolean _tmp155_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp156_;
						ValaSymbol* _tmp157_;
						ValaSymbol* _tmp158_;
						ValaScope* _tmp159_;
						ValaScope* _tmp160_;
						const gchar* _tmp161_;
						ValaSymbol* _tmp162_;
						ValaSymbol* _tmp163_;
						_ns_index = _ns_index + 1;
						if (!(_ns_index < _ns_size)) {
							break;
						}
						_tmp151_ = _ns_list;
						_tmp152_ = vala_list_get (_tmp151_, _ns_index);
						ns = (ValaUsingDirective*) _tmp152_;
						_tmp153_ = ns;
						_tmp154_ = vala_code_node_get_error ((ValaCodeNode*) _tmp153_);
						_tmp155_ = _tmp154_;
						if (_tmp155_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp156_ = ns;
						_tmp157_ = vala_using_directive_get_namespace_symbol (_tmp156_);
						_tmp158_ = _tmp157_;
						_tmp159_ = vala_symbol_get_scope (_tmp158_);
						_tmp160_ = _tmp159_;
						_tmp161_ = self->priv->_member_name;
						_tmp162_ = vala_scope_lookup (_tmp160_, _tmp161_);
						local_sym = _tmp162_;
						_tmp163_ = local_sym;
						if (_tmp163_ != NULL) {
							gboolean _tmp164_ = FALSE;
							ValaSymbol* _tmp165_;
							ValaSymbol* _tmp166_;
							ValaSymbol* _tmp182_;
							_tmp165_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp166_ = _tmp165_;
							if (_tmp166_ != NULL) {
								ValaSymbol* _tmp167_;
								ValaSymbol* _tmp168_;
								ValaSymbol* _tmp169_;
								_tmp167_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp168_ = _tmp167_;
								_tmp169_ = local_sym;
								_tmp164_ = _tmp168_ != _tmp169_;
							} else {
								_tmp164_ = FALSE;
							}
							if (_tmp164_) {
								ValaSourceReference* _tmp170_;
								ValaSourceReference* _tmp171_;
								const gchar* _tmp172_;
								ValaSymbol* _tmp173_;
								ValaSymbol* _tmp174_;
								gchar* _tmp175_;
								gchar* _tmp176_;
								ValaSymbol* _tmp177_;
								gchar* _tmp178_;
								gchar* _tmp179_;
								gchar* _tmp180_;
								gchar* _tmp181_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp170_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp171_ = _tmp170_;
								_tmp172_ = self->priv->_member_name;
								_tmp173_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp174_ = _tmp173_;
								_tmp175_ = vala_symbol_get_full_name (_tmp174_);
								_tmp176_ = _tmp175_;
								_tmp177_ = local_sym;
								_tmp178_ = vala_symbol_get_full_name (_tmp177_);
								_tmp179_ = _tmp178_;
								_tmp180_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp172_, _tmp176_, _tmp179_);
								_tmp181_ = _tmp180_;
								vala_report_error (_tmp171_, _tmp181_);
								_g_free0 (_tmp181_);
								_g_free0 (_tmp179_);
								_g_free0 (_tmp176_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								return result;
							}
							_tmp182_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp182_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
		} else {
			ValaExpression* _tmp183_;
			ValaExpression* _tmp184_;
			gboolean _tmp185_;
			gboolean _tmp186_;
			ValaExpression* _tmp187_;
			ValaExpression* _tmp188_;
			ValaDataType* _tmp189_;
			ValaDataType* _tmp190_;
			ValaExpression* _tmp208_;
			ValaExpression* _tmp209_;
			gboolean _tmp224_ = FALSE;
			ValaExpression* _tmp225_;
			ValaExpression* _tmp226_;
			gboolean _tmp233_ = FALSE;
			ValaExpression* _tmp234_;
			ValaExpression* _tmp235_;
			gboolean _tmp256_ = FALSE;
			ValaExpression* _tmp257_;
			ValaExpression* _tmp258_;
			gboolean _tmp277_ = FALSE;
			ValaSymbol* _tmp278_;
			ValaSymbol* _tmp279_;
			gboolean _tmp313_ = FALSE;
			gboolean _tmp314_ = FALSE;
			ValaSymbol* _tmp315_;
			ValaSymbol* _tmp316_;
			gboolean _tmp548_ = FALSE;
			ValaSymbol* _tmp549_;
			ValaSymbol* _tmp550_;
			_tmp183_ = vala_member_access_get_inner (self);
			_tmp184_ = _tmp183_;
			_tmp185_ = vala_code_node_get_error ((ValaCodeNode*) _tmp184_);
			_tmp186_ = _tmp185_;
			if (_tmp186_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				return result;
			}
			_tmp187_ = vala_member_access_get_inner (self);
			_tmp188_ = _tmp187_;
			_tmp189_ = vala_expression_get_value_type (_tmp188_);
			_tmp190_ = _tmp189_;
			if (VALA_IS_POINTER_TYPE (_tmp190_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp191_;
				ValaExpression* _tmp192_;
				ValaDataType* _tmp193_;
				ValaDataType* _tmp194_;
				gboolean _tmp195_ = FALSE;
				ValaPointerType* _tmp196_;
				_tmp191_ = vala_member_access_get_inner (self);
				_tmp192_ = _tmp191_;
				_tmp193_ = vala_expression_get_value_type (_tmp192_);
				_tmp194_ = _tmp193_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp194_) ? ((ValaPointerType*) _tmp194_) : NULL;
				_tmp196_ = pointer_type;
				if (_tmp196_ != NULL) {
					ValaPointerType* _tmp197_;
					ValaDataType* _tmp198_;
					ValaDataType* _tmp199_;
					_tmp197_ = pointer_type;
					_tmp198_ = vala_pointer_type_get_base_type (_tmp197_);
					_tmp199_ = _tmp198_;
					_tmp195_ = VALA_IS_VALUE_TYPE (_tmp199_);
				} else {
					_tmp195_ = FALSE;
				}
				if (_tmp195_) {
					ValaExpression* _tmp200_;
					ValaExpression* _tmp201_;
					ValaSourceReference* _tmp202_;
					ValaSourceReference* _tmp203_;
					ValaPointerIndirection* _tmp204_;
					ValaPointerIndirection* _tmp205_;
					ValaExpression* _tmp206_;
					ValaExpression* _tmp207_;
					_tmp200_ = vala_member_access_get_inner (self);
					_tmp201_ = _tmp200_;
					_tmp202_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp203_ = _tmp202_;
					_tmp204_ = vala_pointer_indirection_new (_tmp201_, _tmp203_);
					_tmp205_ = _tmp204_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp205_);
					_vala_code_node_unref0 (_tmp205_);
					_tmp206_ = vala_member_access_get_inner (self);
					_tmp207_ = _tmp206_;
					vala_code_node_check ((ValaCodeNode*) _tmp207_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp208_ = vala_member_access_get_inner (self);
			_tmp209_ = _tmp208_;
			if (VALA_IS_MEMBER_ACCESS (_tmp209_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp210_;
				ValaExpression* _tmp211_;
				ValaMemberAccess* _tmp212_;
				gboolean _tmp213_;
				_tmp210_ = vala_member_access_get_inner (self);
				_tmp211_ = _tmp210_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp211_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp212_ = ma;
				_tmp213_ = _tmp212_->priv->_prototype_access;
				if (_tmp213_) {
					ValaSourceReference* _tmp214_;
					ValaSourceReference* _tmp215_;
					ValaExpression* _tmp216_;
					ValaExpression* _tmp217_;
					ValaSymbol* _tmp218_;
					ValaSymbol* _tmp219_;
					gchar* _tmp220_;
					gchar* _tmp221_;
					gchar* _tmp222_;
					gchar* _tmp223_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp215_ = _tmp214_;
					_tmp216_ = vala_member_access_get_inner (self);
					_tmp217_ = _tmp216_;
					_tmp218_ = vala_expression_get_symbol_reference (_tmp217_);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_symbol_get_full_name (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp221_);
					_tmp223_ = _tmp222_;
					vala_report_error (_tmp215_, _tmp223_);
					_g_free0 (_tmp223_);
					_g_free0 (_tmp221_);
					result = FALSE;
					return result;
				}
			}
			_tmp225_ = vala_member_access_get_inner (self);
			_tmp226_ = _tmp225_;
			if (VALA_IS_CAST_EXPRESSION (_tmp226_)) {
				ValaExpression* _tmp227_;
				ValaExpression* _tmp228_;
				gboolean _tmp229_;
				gboolean _tmp230_;
				_tmp227_ = vala_member_access_get_inner (self);
				_tmp228_ = _tmp227_;
				_tmp229_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp228_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp230_ = _tmp229_;
				_tmp224_ = _tmp230_;
			} else {
				_tmp224_ = FALSE;
			}
			if (_tmp224_) {
				ValaSourceReference* _tmp231_;
				ValaSourceReference* _tmp232_;
				_tmp231_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp232_ = _tmp231_;
				vala_report_warning (_tmp232_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp234_ = vala_member_access_get_inner (self);
			_tmp235_ = _tmp234_;
			if (VALA_IS_MEMBER_ACCESS (_tmp235_)) {
				_tmp233_ = TRUE;
			} else {
				ValaExpression* _tmp236_;
				ValaExpression* _tmp237_;
				_tmp236_ = vala_member_access_get_inner (self);
				_tmp237_ = _tmp236_;
				_tmp233_ = VALA_IS_BASE_ACCESS (_tmp237_);
			}
			if (_tmp233_) {
				ValaExpression* _tmp238_;
				ValaExpression* _tmp239_;
				ValaSymbol* _tmp240_;
				ValaSymbol* _tmp241_;
				gboolean _tmp242_ = FALSE;
				ValaSymbol* _tmp243_;
				ValaSymbol* _tmp244_;
				_tmp238_ = vala_member_access_get_inner (self);
				_tmp239_ = _tmp238_;
				_tmp240_ = vala_expression_get_symbol_reference (_tmp239_);
				_tmp241_ = _tmp240_;
				base_symbol = _tmp241_;
				_tmp243_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp244_ = _tmp243_;
				if (_tmp244_ == NULL) {
					gboolean _tmp245_ = FALSE;
					ValaSymbol* _tmp246_;
					_tmp246_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp246_)) {
						_tmp245_ = TRUE;
					} else {
						ValaSymbol* _tmp247_;
						_tmp247_ = base_symbol;
						_tmp245_ = VALA_IS_TYPESYMBOL (_tmp247_);
					}
					_tmp242_ = _tmp245_;
				} else {
					_tmp242_ = FALSE;
				}
				if (_tmp242_) {
					ValaSymbol* _tmp248_;
					ValaScope* _tmp249_;
					ValaScope* _tmp250_;
					const gchar* _tmp251_;
					ValaSymbol* _tmp252_;
					ValaSymbol* _tmp253_;
					ValaExpression* _tmp254_;
					ValaExpression* _tmp255_;
					_tmp248_ = base_symbol;
					_tmp249_ = vala_symbol_get_scope (_tmp248_);
					_tmp250_ = _tmp249_;
					_tmp251_ = self->priv->_member_name;
					_tmp252_ = vala_scope_lookup (_tmp250_, _tmp251_);
					_tmp253_ = _tmp252_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp253_);
					_vala_code_node_unref0 (_tmp253_);
					_tmp254_ = vala_member_access_get_inner (self);
					_tmp255_ = _tmp254_;
					if (VALA_IS_BASE_ACCESS (_tmp255_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp257_ = vala_member_access_get_inner (self);
			_tmp258_ = _tmp257_;
			if (VALA_IS_MEMBER_ACCESS (_tmp258_)) {
				ValaExpression* _tmp259_;
				ValaExpression* _tmp260_;
				ValaSymbol* _tmp261_;
				ValaSymbol* _tmp262_;
				_tmp259_ = vala_member_access_get_inner (self);
				_tmp260_ = _tmp259_;
				_tmp261_ = vala_expression_get_symbol_reference (_tmp260_);
				_tmp262_ = _tmp261_;
				_tmp256_ = VALA_IS_TYPEPARAMETER (_tmp262_);
			} else {
				_tmp256_ = FALSE;
			}
			if (_tmp256_) {
				ValaExpression* _tmp263_;
				ValaExpression* _tmp264_;
				ValaExpression* _tmp265_;
				ValaExpression* _tmp266_;
				ValaSymbol* _tmp267_;
				ValaSymbol* _tmp268_;
				ValaGenericType* _tmp269_;
				ValaGenericType* _tmp270_;
				ValaExpression* _tmp271_;
				ValaExpression* _tmp272_;
				ValaDataType* _tmp273_;
				ValaDataType* _tmp274_;
				ValaSourceReference* _tmp275_;
				ValaSourceReference* _tmp276_;
				_tmp263_ = vala_member_access_get_inner (self);
				_tmp264_ = _tmp263_;
				_tmp265_ = vala_member_access_get_inner (self);
				_tmp266_ = _tmp265_;
				_tmp267_ = vala_expression_get_symbol_reference (_tmp266_);
				_tmp268_ = _tmp267_;
				_tmp269_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp268_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp270_ = _tmp269_;
				vala_expression_set_value_type (_tmp264_, (ValaDataType*) _tmp270_);
				_vala_code_node_unref0 (_tmp270_);
				_tmp271_ = vala_member_access_get_inner (self);
				_tmp272_ = _tmp271_;
				_tmp273_ = vala_expression_get_value_type (_tmp272_);
				_tmp274_ = _tmp273_;
				_tmp275_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp276_ = _tmp275_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp274_, _tmp276_);
			}
			_tmp278_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp279_ = _tmp278_;
			if (_tmp279_ == NULL) {
				ValaExpression* _tmp280_;
				ValaExpression* _tmp281_;
				ValaDataType* _tmp282_;
				ValaDataType* _tmp283_;
				_tmp280_ = vala_member_access_get_inner (self);
				_tmp281_ = _tmp280_;
				_tmp282_ = vala_expression_get_value_type (_tmp281_);
				_tmp283_ = _tmp282_;
				_tmp277_ = _tmp283_ != NULL;
			} else {
				_tmp277_ = FALSE;
			}
			if (_tmp277_) {
				gboolean _tmp284_;
				ValaSymbol* _tmp311_;
				ValaSymbol* _tmp312_;
				_tmp284_ = self->priv->_pointer_member_access;
				if (_tmp284_) {
					ValaExpression* _tmp285_;
					ValaExpression* _tmp286_;
					ValaDataType* _tmp287_;
					ValaDataType* _tmp288_;
					const gchar* _tmp289_;
					ValaSymbol* _tmp290_;
					ValaSymbol* _tmp291_;
					_tmp285_ = vala_member_access_get_inner (self);
					_tmp286_ = _tmp285_;
					_tmp287_ = vala_expression_get_value_type (_tmp286_);
					_tmp288_ = _tmp287_;
					_tmp289_ = self->priv->_member_name;
					_tmp290_ = vala_data_type_get_pointer_member (_tmp288_, _tmp289_);
					_tmp291_ = _tmp290_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp291_);
					_vala_code_node_unref0 (_tmp291_);
				} else {
					ValaExpression* _tmp292_;
					ValaExpression* _tmp293_;
					ValaDataType* _tmp294_;
					ValaDataType* _tmp295_;
					ValaTypeSymbol* _tmp296_;
					ValaTypeSymbol* _tmp297_;
					ValaExpression* _tmp304_;
					ValaExpression* _tmp305_;
					ValaDataType* _tmp306_;
					ValaDataType* _tmp307_;
					const gchar* _tmp308_;
					ValaSymbol* _tmp309_;
					ValaSymbol* _tmp310_;
					_tmp292_ = vala_member_access_get_inner (self);
					_tmp293_ = _tmp292_;
					_tmp294_ = vala_expression_get_value_type (_tmp293_);
					_tmp295_ = _tmp294_;
					_tmp296_ = vala_data_type_get_type_symbol (_tmp295_);
					_tmp297_ = _tmp296_;
					if (_tmp297_ != NULL) {
						ValaExpression* _tmp298_;
						ValaExpression* _tmp299_;
						ValaDataType* _tmp300_;
						ValaDataType* _tmp301_;
						ValaTypeSymbol* _tmp302_;
						ValaTypeSymbol* _tmp303_;
						_tmp298_ = vala_member_access_get_inner (self);
						_tmp299_ = _tmp298_;
						_tmp300_ = vala_expression_get_value_type (_tmp299_);
						_tmp301_ = _tmp300_;
						_tmp302_ = vala_data_type_get_type_symbol (_tmp301_);
						_tmp303_ = _tmp302_;
						base_symbol = (ValaSymbol*) _tmp303_;
					}
					_tmp304_ = vala_member_access_get_inner (self);
					_tmp305_ = _tmp304_;
					_tmp306_ = vala_expression_get_value_type (_tmp305_);
					_tmp307_ = _tmp306_;
					_tmp308_ = self->priv->_member_name;
					_tmp309_ = vala_data_type_get_member (_tmp307_, _tmp308_);
					_tmp310_ = _tmp309_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp310_);
					_vala_code_node_unref0 (_tmp310_);
				}
				_tmp311_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp312_ = _tmp311_;
				if (_tmp312_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp315_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp316_ = _tmp315_;
			if (_tmp316_ == NULL) {
				ValaExpression* _tmp317_;
				ValaExpression* _tmp318_;
				ValaDataType* _tmp319_;
				ValaDataType* _tmp320_;
				_tmp317_ = vala_member_access_get_inner (self);
				_tmp318_ = _tmp317_;
				_tmp319_ = vala_expression_get_value_type (_tmp318_);
				_tmp320_ = _tmp319_;
				_tmp314_ = _tmp320_ != NULL;
			} else {
				_tmp314_ = FALSE;
			}
			if (_tmp314_) {
				ValaExpression* _tmp321_;
				ValaExpression* _tmp322_;
				ValaDataType* _tmp323_;
				ValaDataType* _tmp324_;
				gboolean _tmp325_;
				gboolean _tmp326_;
				_tmp321_ = vala_member_access_get_inner (self);
				_tmp322_ = _tmp321_;
				_tmp323_ = vala_expression_get_value_type (_tmp322_);
				_tmp324_ = _tmp323_;
				_tmp325_ = vala_data_type_get_is_dynamic (_tmp324_);
				_tmp326_ = _tmp325_;
				_tmp313_ = _tmp326_;
			} else {
				_tmp313_ = FALSE;
			}
			if (_tmp313_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp327_;
				ValaExpression* _tmp328_;
				ValaDataType* _tmp329_;
				ValaDataType* _tmp330_;
				ValaObjectType* _tmp331_;
				ValaCodeNode* _tmp332_;
				ValaCodeNode* _tmp333_;
				ValaSymbol* _tmp496_;
				ValaSymbol* _tmp497_;
				ValaSymbol* _tmp546_;
				ValaSymbol* _tmp547_;
				_tmp327_ = vala_member_access_get_inner (self);
				_tmp328_ = _tmp327_;
				_tmp329_ = vala_expression_get_value_type (_tmp328_);
				_tmp330_ = _tmp329_;
				_tmp331_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp330_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp331_;
				_tmp332_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp333_ = _tmp332_;
				if (VALA_IS_METHOD_CALL (_tmp333_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp334_;
					ValaCodeNode* _tmp335_;
					ValaMethodCall* _tmp336_;
					ValaExpression* _tmp337_;
					ValaExpression* _tmp338_;
					_tmp334_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp335_ = _tmp334_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp335_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp336_ = invoc;
					_tmp337_ = vala_method_call_get_call (_tmp336_);
					_tmp338_ = _tmp337_;
					if (_tmp338_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp339_;
						ValaDataType* _tmp340_;
						ValaDataType* _tmp341_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp356_;
						ValaExpression* _tmp357_;
						ValaDataType* _tmp358_;
						ValaDataType* _tmp359_;
						const gchar* _tmp360_;
						ValaDataType* _tmp361_;
						ValaSourceReference* _tmp362_;
						ValaSourceReference* _tmp363_;
						ValaDynamicMethod* _tmp364_;
						ValaDynamicMethod* _tmp365_;
						ValaMethodCall* _tmp366_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp367_;
						ValaErrorType* _tmp368_;
						ValaDynamicMethod* _tmp369_;
						ValaErrorType* _tmp370_;
						ValaDynamicMethod* _tmp371_;
						ValaDynamicMethod* _tmp372_;
						ValaParameter* _tmp373_;
						ValaParameter* _tmp374_;
						ValaDynamicMethod* _tmp375_;
						ValaObjectType* _tmp376_;
						ValaDataType* _tmp377_;
						ValaDataType* _tmp378_;
						ValaParameter* _tmp379_;
						ValaParameter* _tmp380_;
						ValaObjectType* _tmp381_;
						ValaTypeSymbol* _tmp382_;
						ValaTypeSymbol* _tmp383_;
						ValaScope* _tmp384_;
						ValaScope* _tmp385_;
						ValaDynamicMethod* _tmp386_;
						ValaDynamicMethod* _tmp387_;
						_tmp339_ = invoc;
						_tmp340_ = vala_expression_get_target_type ((ValaExpression*) _tmp339_);
						_tmp341_ = _tmp340_;
						if (_tmp341_ != NULL) {
							ValaMethodCall* _tmp342_;
							ValaDataType* _tmp343_;
							ValaDataType* _tmp344_;
							ValaDataType* _tmp345_;
							ValaDataType* _tmp346_;
							_tmp342_ = invoc;
							_tmp343_ = vala_expression_get_target_type ((ValaExpression*) _tmp342_);
							_tmp344_ = _tmp343_;
							_tmp345_ = vala_data_type_copy (_tmp344_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp345_;
							_tmp346_ = ret_type;
							vala_data_type_set_value_owned (_tmp346_, TRUE);
						} else {
							ValaMethodCall* _tmp347_;
							ValaCodeNode* _tmp348_;
							ValaCodeNode* _tmp349_;
							_tmp347_ = invoc;
							_tmp348_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp347_);
							_tmp349_ = _tmp348_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp349_)) {
								ValaVoidType* _tmp350_;
								_tmp350_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp350_;
							} else {
								ValaExpression* _tmp351_;
								ValaExpression* _tmp352_;
								ValaDataType* _tmp353_;
								ValaDataType* _tmp354_;
								ValaDataType* _tmp355_;
								_tmp351_ = vala_member_access_get_inner (self);
								_tmp352_ = _tmp351_;
								_tmp353_ = vala_expression_get_value_type (_tmp352_);
								_tmp354_ = _tmp353_;
								_tmp355_ = vala_data_type_copy (_tmp354_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp355_;
							}
						}
						_tmp356_ = vala_member_access_get_inner (self);
						_tmp357_ = _tmp356_;
						_tmp358_ = vala_expression_get_value_type (_tmp357_);
						_tmp359_ = _tmp358_;
						_tmp360_ = self->priv->_member_name;
						_tmp361_ = ret_type;
						_tmp362_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp363_ = _tmp362_;
						_tmp364_ = vala_dynamic_method_new (_tmp359_, _tmp360_, _tmp361_, _tmp363_, NULL);
						m = _tmp364_;
						_tmp365_ = m;
						_tmp366_ = invoc;
						vala_dynamic_method_set_invocation (_tmp365_, _tmp366_);
						_tmp367_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp367_;
						_tmp368_ = err;
						vala_error_type_set_dynamic_error (_tmp368_, TRUE);
						_tmp369_ = m;
						_tmp370_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp369_, (ValaDataType*) _tmp370_);
						_tmp371_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp371_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp372_ = m;
						_tmp373_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp374_ = _tmp373_;
						vala_callable_add_parameter ((ValaCallable*) _tmp372_, _tmp374_);
						_vala_code_node_unref0 (_tmp374_);
						_tmp375_ = m;
						_tmp376_ = dynamic_object_type;
						_tmp377_ = vala_data_type_copy ((ValaDataType*) _tmp376_);
						_tmp378_ = _tmp377_;
						_tmp379_ = vala_parameter_new ("this", _tmp378_, NULL);
						_tmp380_ = _tmp379_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp375_, _tmp380_);
						_vala_code_node_unref0 (_tmp380_);
						_vala_code_node_unref0 (_tmp378_);
						_tmp381_ = dynamic_object_type;
						_tmp382_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp381_);
						_tmp383_ = _tmp382_;
						_tmp384_ = vala_symbol_get_scope ((ValaSymbol*) _tmp383_);
						_tmp385_ = _tmp384_;
						_tmp386_ = m;
						vala_scope_add (_tmp385_, NULL, (ValaSymbol*) _tmp386_);
						_tmp387_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp387_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp388_;
					ValaCodeNode* _tmp389_;
					_tmp388_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp389_ = _tmp388_;
					if (VALA_IS_ASSIGNMENT (_tmp389_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp390_;
						ValaCodeNode* _tmp391_;
						ValaAssignment* _tmp392_;
						ValaExpression* _tmp393_;
						ValaExpression* _tmp394_;
						_tmp390_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp391_ = _tmp390_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp391_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp392_ = a;
						_tmp393_ = vala_assignment_get_left (_tmp392_);
						_tmp394_ = _tmp393_;
						if (_tmp394_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp395_;
							ValaExpression* _tmp396_;
							ValaDataType* _tmp397_;
							ValaDataType* _tmp398_;
							const gchar* _tmp399_;
							ValaSourceReference* _tmp400_;
							ValaSourceReference* _tmp401_;
							ValaDynamicProperty* _tmp402_;
							ValaDynamicProperty* _tmp403_;
							ValaDynamicProperty* _tmp404_;
							ValaDynamicProperty* _tmp405_;
							ValaSourceReference* _tmp406_;
							ValaSourceReference* _tmp407_;
							ValaPropertyAccessor* _tmp408_;
							ValaPropertyAccessor* _tmp409_;
							ValaDynamicProperty* _tmp410_;
							ValaExpression* _tmp411_;
							ValaExpression* _tmp412_;
							ValaDataType* _tmp413_;
							ValaDataType* _tmp414_;
							ValaTypeSymbol* _tmp415_;
							ValaTypeSymbol* _tmp416_;
							ValaScope* _tmp417_;
							ValaScope* _tmp418_;
							ValaObjectType* _tmp419_;
							ValaTypeSymbol* _tmp420_;
							ValaTypeSymbol* _tmp421_;
							ValaScope* _tmp422_;
							ValaScope* _tmp423_;
							ValaDynamicProperty* _tmp424_;
							ValaDynamicProperty* _tmp425_;
							_tmp395_ = vala_member_access_get_inner (self);
							_tmp396_ = _tmp395_;
							_tmp397_ = vala_expression_get_value_type (_tmp396_);
							_tmp398_ = _tmp397_;
							_tmp399_ = self->priv->_member_name;
							_tmp400_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp401_ = _tmp400_;
							_tmp402_ = vala_dynamic_property_new (_tmp398_, _tmp399_, _tmp401_, NULL);
							prop = _tmp402_;
							_tmp403_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp403_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp404_ = prop;
							_tmp405_ = prop;
							_tmp406_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp405_);
							_tmp407_ = _tmp406_;
							_tmp408_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp407_, NULL);
							_tmp409_ = _tmp408_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp404_, _tmp409_);
							_vala_code_node_unref0 (_tmp409_);
							_tmp410_ = prop;
							_tmp411_ = vala_member_access_get_inner (self);
							_tmp412_ = _tmp411_;
							_tmp413_ = vala_expression_get_value_type (_tmp412_);
							_tmp414_ = _tmp413_;
							_tmp415_ = vala_data_type_get_type_symbol (_tmp414_);
							_tmp416_ = _tmp415_;
							_tmp417_ = vala_symbol_get_scope ((ValaSymbol*) _tmp416_);
							_tmp418_ = _tmp417_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp410_, _tmp418_);
							_tmp419_ = dynamic_object_type;
							_tmp420_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp419_);
							_tmp421_ = _tmp420_;
							_tmp422_ = vala_symbol_get_scope ((ValaSymbol*) _tmp421_);
							_tmp423_ = _tmp422_;
							_tmp424_ = prop;
							vala_scope_add (_tmp423_, NULL, (ValaSymbol*) _tmp424_);
							_tmp425_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp425_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp426_ = FALSE;
						gboolean _tmp427_ = FALSE;
						ValaCodeNode* _tmp428_;
						ValaCodeNode* _tmp429_;
						_tmp428_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp429_ = _tmp428_;
						if (VALA_IS_MEMBER_ACCESS (_tmp429_)) {
							ValaExpression* _tmp430_;
							ValaExpression* _tmp431_;
							_tmp430_ = vala_member_access_get_inner (self);
							_tmp431_ = _tmp430_;
							_tmp427_ = VALA_IS_MEMBER_ACCESS (_tmp431_);
						} else {
							_tmp427_ = FALSE;
						}
						if (_tmp427_) {
							ValaCodeNode* _tmp432_;
							ValaCodeNode* _tmp433_;
							ValaCodeNode* _tmp434_;
							ValaCodeNode* _tmp435_;
							_tmp432_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp433_ = _tmp432_;
							_tmp434_ = vala_code_node_get_parent_node (_tmp433_);
							_tmp435_ = _tmp434_;
							_tmp426_ = VALA_IS_METHOD_CALL (_tmp435_);
						} else {
							_tmp426_ = FALSE;
						}
						if (_tmp426_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp436_;
							ValaCodeNode* _tmp437_;
							gboolean _tmp438_ = FALSE;
							ValaMemberAccess* _tmp439_;
							const gchar* _tmp440_;
							_tmp436_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp437_ = _tmp436_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp437_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp439_ = ma;
							_tmp440_ = _tmp439_->priv->_member_name;
							if (g_strcmp0 (_tmp440_, "connect") == 0) {
								_tmp438_ = TRUE;
							} else {
								ValaMemberAccess* _tmp441_;
								const gchar* _tmp442_;
								_tmp441_ = ma;
								_tmp442_ = _tmp441_->priv->_member_name;
								_tmp438_ = g_strcmp0 (_tmp442_, "connect_after") == 0;
							}
							if (_tmp438_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp443_;
								ValaExpression* _tmp444_;
								ValaDataType* _tmp445_;
								ValaDataType* _tmp446_;
								const gchar* _tmp447_;
								ValaVoidType* _tmp448_;
								ValaVoidType* _tmp449_;
								ValaSourceReference* _tmp450_;
								ValaSourceReference* _tmp451_;
								ValaDynamicSignal* _tmp452_;
								ValaDynamicSignal* _tmp453_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp454_;
								ValaCodeNode* _tmp455_;
								ValaCodeNode* _tmp456_;
								ValaCodeNode* _tmp457_;
								ValaMethodCall* _tmp458_;
								ValaMethodCall* _tmp459_;
								ValaList* _tmp460_;
								gint _tmp461_;
								gint _tmp462_;
								ValaDynamicSignal* _tmp488_;
								ValaObjectType* _tmp489_;
								ValaTypeSymbol* _tmp490_;
								ValaTypeSymbol* _tmp491_;
								ValaScope* _tmp492_;
								ValaScope* _tmp493_;
								ValaDynamicSignal* _tmp494_;
								ValaDynamicSignal* _tmp495_;
								_tmp443_ = vala_member_access_get_inner (self);
								_tmp444_ = _tmp443_;
								_tmp445_ = vala_expression_get_value_type (_tmp444_);
								_tmp446_ = _tmp445_;
								_tmp447_ = self->priv->_member_name;
								_tmp448_ = vala_void_type_new (NULL);
								_tmp449_ = _tmp448_;
								_tmp450_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp451_ = _tmp450_;
								_tmp452_ = vala_dynamic_signal_new (_tmp446_, _tmp447_, (ValaDataType*) _tmp449_, _tmp451_, NULL);
								_tmp453_ = _tmp452_;
								_vala_code_node_unref0 (_tmp449_);
								s = _tmp453_;
								_tmp454_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp455_ = _tmp454_;
								_tmp456_ = vala_code_node_get_parent_node (_tmp455_);
								_tmp457_ = _tmp456_;
								_tmp458_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp457_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp458_;
								_tmp459_ = mcall;
								_tmp460_ = vala_method_call_get_argument_list (_tmp459_);
								_tmp461_ = vala_collection_get_size ((ValaCollection*) _tmp460_);
								_tmp462_ = _tmp461_;
								if (_tmp462_ > 0) {
									ValaDynamicSignal* _tmp463_;
									ValaMethodCall* _tmp464_;
									ValaList* _tmp465_;
									gpointer _tmp466_;
									ValaExpression* _tmp467_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp468_;
									ValaExpression* _tmp469_;
									ValaExpression* _tmp470_;
									gboolean _tmp471_ = FALSE;
									gboolean _tmp472_ = FALSE;
									ValaMemberAccess* _tmp473_;
									_tmp463_ = s;
									_tmp464_ = mcall;
									_tmp465_ = vala_method_call_get_argument_list (_tmp464_);
									_tmp466_ = vala_list_get (_tmp465_, 0);
									_tmp467_ = (ValaExpression*) _tmp466_;
									vala_dynamic_signal_set_handler (_tmp463_, _tmp467_);
									_vala_code_node_unref0 (_tmp467_);
									_tmp468_ = s;
									_tmp469_ = vala_dynamic_signal_get_handler (_tmp468_);
									_tmp470_ = _tmp469_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp470_) ? ((ValaMemberAccess*) _tmp470_) : NULL;
									_tmp473_ = arg;
									if (_tmp473_ == NULL) {
										_tmp472_ = TRUE;
									} else {
										ValaMemberAccess* _tmp474_;
										_tmp474_ = arg;
										_tmp472_ = !vala_code_node_check ((ValaCodeNode*) _tmp474_, context);
									}
									if (_tmp472_) {
										_tmp471_ = TRUE;
									} else {
										ValaMemberAccess* _tmp475_;
										ValaSymbol* _tmp476_;
										ValaSymbol* _tmp477_;
										_tmp475_ = arg;
										_tmp476_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp475_);
										_tmp477_ = _tmp476_;
										_tmp471_ = !VALA_IS_METHOD (_tmp477_);
									}
									if (_tmp471_) {
										ValaDynamicSignal* _tmp478_;
										ValaExpression* _tmp479_;
										ValaExpression* _tmp480_;
										ValaSourceReference* _tmp481_;
										ValaSourceReference* _tmp482_;
										ValaDynamicSignal* _tmp483_;
										gchar* _tmp484_;
										gchar* _tmp485_;
										gchar* _tmp486_;
										gchar* _tmp487_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp478_ = s;
										_tmp479_ = vala_dynamic_signal_get_handler (_tmp478_);
										_tmp480_ = _tmp479_;
										_tmp481_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp480_);
										_tmp482_ = _tmp481_;
										_tmp483_ = s;
										_tmp484_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp483_);
										_tmp485_ = _tmp484_;
										_tmp486_ = g_strdup_printf ("Invalid handler for `%s'", _tmp485_);
										_tmp487_ = _tmp486_;
										vala_report_error (_tmp482_, _tmp487_);
										_g_free0 (_tmp487_);
										_g_free0 (_tmp485_);
									}
								}
								_tmp488_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp488_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp489_ = dynamic_object_type;
								_tmp490_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp489_);
								_tmp491_ = _tmp490_;
								_tmp492_ = vala_symbol_get_scope ((ValaSymbol*) _tmp491_);
								_tmp493_ = _tmp492_;
								_tmp494_ = s;
								vala_scope_add (_tmp493_, NULL, (ValaSymbol*) _tmp494_);
								_tmp495_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp495_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
						}
					}
				}
				_tmp496_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp497_ = _tmp496_;
				if (_tmp497_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp498_;
					ValaExpression* _tmp499_;
					ValaDataType* _tmp500_;
					ValaDataType* _tmp501_;
					const gchar* _tmp502_;
					ValaSourceReference* _tmp503_;
					ValaSourceReference* _tmp504_;
					ValaDynamicProperty* _tmp505_;
					ValaDataType* _tmp506_;
					ValaDataType* _tmp507_;
					ValaDynamicProperty* _tmp518_;
					ValaDynamicProperty* _tmp519_;
					ValaDynamicProperty* _tmp520_;
					ValaDataType* _tmp521_;
					ValaDataType* _tmp522_;
					ValaDataType* _tmp523_;
					ValaDataType* _tmp524_;
					ValaDynamicProperty* _tmp525_;
					ValaSourceReference* _tmp526_;
					ValaSourceReference* _tmp527_;
					ValaPropertyAccessor* _tmp528_;
					ValaPropertyAccessor* _tmp529_;
					ValaDynamicProperty* _tmp530_;
					ValaExpression* _tmp531_;
					ValaExpression* _tmp532_;
					ValaDataType* _tmp533_;
					ValaDataType* _tmp534_;
					ValaTypeSymbol* _tmp535_;
					ValaTypeSymbol* _tmp536_;
					ValaScope* _tmp537_;
					ValaScope* _tmp538_;
					ValaObjectType* _tmp539_;
					ValaTypeSymbol* _tmp540_;
					ValaTypeSymbol* _tmp541_;
					ValaScope* _tmp542_;
					ValaScope* _tmp543_;
					ValaDynamicProperty* _tmp544_;
					ValaDynamicProperty* _tmp545_;
					_tmp498_ = vala_member_access_get_inner (self);
					_tmp499_ = _tmp498_;
					_tmp500_ = vala_expression_get_value_type (_tmp499_);
					_tmp501_ = _tmp500_;
					_tmp502_ = self->priv->_member_name;
					_tmp503_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp504_ = _tmp503_;
					_tmp505_ = vala_dynamic_property_new (_tmp501_, _tmp502_, _tmp504_, NULL);
					prop = _tmp505_;
					_tmp506_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp507_ = _tmp506_;
					if (_tmp507_ != NULL) {
						ValaDynamicProperty* _tmp508_;
						ValaDataType* _tmp509_;
						ValaDataType* _tmp510_;
						_tmp508_ = prop;
						_tmp509_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp510_ = _tmp509_;
						vala_property_set_property_type ((ValaProperty*) _tmp508_, _tmp510_);
					} else {
						ValaDynamicProperty* _tmp511_;
						ValaExpression* _tmp512_;
						ValaExpression* _tmp513_;
						ValaDataType* _tmp514_;
						ValaDataType* _tmp515_;
						ValaDataType* _tmp516_;
						ValaDataType* _tmp517_;
						_tmp511_ = prop;
						_tmp512_ = vala_member_access_get_inner (self);
						_tmp513_ = _tmp512_;
						_tmp514_ = vala_expression_get_value_type (_tmp513_);
						_tmp515_ = _tmp514_;
						_tmp516_ = vala_data_type_copy (_tmp515_);
						_tmp517_ = _tmp516_;
						vala_property_set_property_type ((ValaProperty*) _tmp511_, _tmp517_);
						_vala_code_node_unref0 (_tmp517_);
					}
					_tmp518_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp518_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp519_ = prop;
					_tmp520_ = prop;
					_tmp521_ = vala_property_get_property_type ((ValaProperty*) _tmp520_);
					_tmp522_ = _tmp521_;
					_tmp523_ = vala_data_type_copy (_tmp522_);
					_tmp524_ = _tmp523_;
					_tmp525_ = prop;
					_tmp526_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp525_);
					_tmp527_ = _tmp526_;
					_tmp528_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp524_, NULL, _tmp527_, NULL);
					_tmp529_ = _tmp528_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp519_, _tmp529_);
					_vala_code_node_unref0 (_tmp529_);
					_vala_code_node_unref0 (_tmp524_);
					_tmp530_ = prop;
					_tmp531_ = vala_member_access_get_inner (self);
					_tmp532_ = _tmp531_;
					_tmp533_ = vala_expression_get_value_type (_tmp532_);
					_tmp534_ = _tmp533_;
					_tmp535_ = vala_data_type_get_type_symbol (_tmp534_);
					_tmp536_ = _tmp535_;
					_tmp537_ = vala_symbol_get_scope ((ValaSymbol*) _tmp536_);
					_tmp538_ = _tmp537_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp530_, _tmp538_);
					_tmp539_ = dynamic_object_type;
					_tmp540_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp539_);
					_tmp541_ = _tmp540_;
					_tmp542_ = vala_symbol_get_scope ((ValaSymbol*) _tmp541_);
					_tmp543_ = _tmp542_;
					_tmp544_ = prop;
					vala_scope_add (_tmp543_, NULL, (ValaSymbol*) _tmp544_);
					_tmp545_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp545_);
					_vala_code_node_unref0 (prop);
				}
				_tmp546_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp547_ = _tmp546_;
				if (_tmp547_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp549_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp550_ = _tmp549_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp550_)) {
				ValaExpression* _tmp551_;
				ValaExpression* _tmp552_;
				ValaDataType* _tmp553_;
				ValaDataType* _tmp554_;
				_tmp551_ = vala_member_access_get_inner (self);
				_tmp552_ = _tmp551_;
				_tmp553_ = vala_expression_get_value_type (_tmp552_);
				_tmp554_ = _tmp553_;
				_tmp548_ = VALA_IS_ARRAY_TYPE (_tmp554_);
			} else {
				_tmp548_ = FALSE;
			}
			if (_tmp548_) {
				ValaArrayType* value_array_type = NULL;
				ValaExpression* _tmp555_;
				ValaExpression* _tmp556_;
				ValaDataType* _tmp557_;
				ValaDataType* _tmp558_;
				gboolean _tmp559_ = FALSE;
				ValaArrayType* _tmp560_;
				_tmp555_ = vala_member_access_get_inner (self);
				_tmp556_ = _tmp555_;
				_tmp557_ = vala_expression_get_value_type (_tmp556_);
				_tmp558_ = _tmp557_;
				value_array_type = VALA_IS_ARRAY_TYPE (_tmp558_) ? ((ValaArrayType*) _tmp558_) : NULL;
				_tmp560_ = value_array_type;
				if (_tmp560_ != NULL) {
					ValaArrayType* _tmp561_;
					gboolean _tmp562_;
					gboolean _tmp563_;
					_tmp561_ = value_array_type;
					_tmp562_ = vala_array_type_get_inline_allocated (_tmp561_);
					_tmp563_ = _tmp562_;
					_tmp559_ = _tmp563_;
				} else {
					_tmp559_ = FALSE;
				}
				if (_tmp559_) {
					ValaSourceReference* _tmp564_;
					ValaSourceReference* _tmp565_;
					_tmp564_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp565_ = _tmp564_;
					vala_report_error (_tmp565_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
		}
	}
	_tmp569_ = vala_member_access_get_inner (self);
	_tmp570_ = _tmp569_;
	if (_tmp570_ == NULL) {
		ValaSymbol* _tmp571_;
		ValaSymbol* _tmp572_;
		_tmp571_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp572_ = _tmp571_;
		_tmp568_ = _tmp572_ == NULL;
	} else {
		_tmp568_ = FALSE;
	}
	if (_tmp568_) {
		ValaDataType* _tmp573_;
		ValaDataType* _tmp574_;
		_tmp573_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp574_ = _tmp573_;
		_tmp567_ = _tmp574_ != NULL;
	} else {
		_tmp567_ = FALSE;
	}
	if (_tmp567_) {
		ValaDataType* _tmp575_;
		ValaDataType* _tmp576_;
		ValaTypeSymbol* _tmp577_;
		ValaTypeSymbol* _tmp578_;
		_tmp575_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp576_ = _tmp575_;
		_tmp577_ = vala_data_type_get_type_symbol (_tmp576_);
		_tmp578_ = _tmp577_;
		_tmp566_ = VALA_IS_ENUM (_tmp578_);
	} else {
		_tmp566_ = FALSE;
	}
	if (_tmp566_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp579_;
		ValaDataType* _tmp580_;
		ValaTypeSymbol* _tmp581_;
		ValaTypeSymbol* _tmp582_;
		_tmp579_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp580_ = _tmp579_;
		_tmp581_ = vala_data_type_get_type_symbol (_tmp580_);
		_tmp582_ = _tmp581_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp582_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp583_;
			ValaList* _tmp584_;
			ValaList* _tmp585_;
			gint _val_size = 0;
			ValaList* _tmp586_;
			gint _tmp587_;
			gint _tmp588_;
			gint _val_index = 0;
			_tmp583_ = enum_type;
			_tmp584_ = vala_enum_get_values (_tmp583_);
			_tmp585_ = _vala_iterable_ref0 (_tmp584_);
			_val_list = _tmp585_;
			_tmp586_ = _val_list;
			_tmp587_ = vala_collection_get_size ((ValaCollection*) _tmp586_);
			_tmp588_ = _tmp587_;
			_val_size = _tmp588_;
			_val_index = -1;
			while (TRUE) {
				ValaEnumValue* val = NULL;
				ValaList* _tmp589_;
				gpointer _tmp590_;
				const gchar* _tmp591_;
				ValaEnumValue* _tmp592_;
				const gchar* _tmp593_;
				const gchar* _tmp594_;
				_val_index = _val_index + 1;
				if (!(_val_index < _val_size)) {
					break;
				}
				_tmp589_ = _val_list;
				_tmp590_ = vala_list_get (_tmp589_, _val_index);
				val = (ValaEnumValue*) _tmp590_;
				_tmp591_ = self->priv->_member_name;
				_tmp592_ = val;
				_tmp593_ = vala_symbol_get_name ((ValaSymbol*) _tmp592_);
				_tmp594_ = _tmp593_;
				if (g_strcmp0 (_tmp591_, _tmp594_) == 0) {
					ValaEnumValue* _tmp595_;
					_tmp595_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp595_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
	}
	_tmp596_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp597_ = _tmp596_;
	if (_tmp597_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp598_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp599_ = FALSE;
		ValaExpression* _tmp600_;
		ValaExpression* _tmp601_;
		gchar* base_type_package = NULL;
		gchar* _tmp621_;
		gboolean _tmp622_ = FALSE;
		ValaSymbol* _tmp623_;
		ValaSourceReference* _tmp638_;
		ValaSourceReference* _tmp639_;
		const gchar* _tmp640_;
		const gchar* _tmp641_;
		const gchar* _tmp642_;
		gchar* _tmp643_;
		gchar* _tmp644_;
		ValaInvalidType* _tmp645_;
		ValaInvalidType* _tmp646_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp598_ = g_strdup ("(null)");
		base_type_name = _tmp598_;
		base_type = NULL;
		_tmp600_ = vala_member_access_get_inner (self);
		_tmp601_ = _tmp600_;
		if (_tmp601_ != NULL) {
			ValaExpression* _tmp602_;
			ValaExpression* _tmp603_;
			ValaDataType* _tmp604_;
			ValaDataType* _tmp605_;
			_tmp602_ = vala_member_access_get_inner (self);
			_tmp603_ = _tmp602_;
			_tmp604_ = vala_expression_get_value_type (_tmp603_);
			_tmp605_ = _tmp604_;
			_tmp599_ = _tmp605_ != NULL;
		} else {
			_tmp599_ = FALSE;
		}
		if (_tmp599_) {
			ValaExpression* _tmp606_;
			ValaExpression* _tmp607_;
			ValaDataType* _tmp608_;
			ValaDataType* _tmp609_;
			gchar* _tmp610_;
			ValaExpression* _tmp611_;
			ValaExpression* _tmp612_;
			ValaDataType* _tmp613_;
			ValaDataType* _tmp614_;
			ValaTypeSymbol* _tmp615_;
			ValaTypeSymbol* _tmp616_;
			_tmp606_ = vala_member_access_get_inner (self);
			_tmp607_ = _tmp606_;
			_tmp608_ = vala_expression_get_value_type (_tmp607_);
			_tmp609_ = _tmp608_;
			_tmp610_ = vala_code_node_to_string ((ValaCodeNode*) _tmp609_);
			_g_free0 (base_type_name);
			base_type_name = _tmp610_;
			_tmp611_ = vala_member_access_get_inner (self);
			_tmp612_ = _tmp611_;
			_tmp613_ = vala_expression_get_value_type (_tmp612_);
			_tmp614_ = _tmp613_;
			_tmp615_ = vala_data_type_get_type_symbol (_tmp614_);
			_tmp616_ = _tmp615_;
			base_type = (ValaSymbol*) _tmp616_;
		} else {
			ValaSymbol* _tmp617_;
			_tmp617_ = base_symbol;
			if (_tmp617_ != NULL) {
				ValaSymbol* _tmp618_;
				gchar* _tmp619_;
				ValaSymbol* _tmp620_;
				_tmp618_ = base_symbol;
				_tmp619_ = vala_symbol_get_full_name (_tmp618_);
				_g_free0 (base_type_name);
				base_type_name = _tmp619_;
				_tmp620_ = base_symbol;
				base_type = _tmp620_;
			}
		}
		_tmp621_ = g_strdup ("");
		base_type_package = _tmp621_;
		_tmp623_ = base_type;
		if (_tmp623_ != NULL) {
			ValaSymbol* _tmp624_;
			gboolean _tmp625_;
			gboolean _tmp626_;
			_tmp624_ = base_type;
			_tmp625_ = vala_symbol_get_external_package (_tmp624_);
			_tmp626_ = _tmp625_;
			_tmp622_ = _tmp626_;
		} else {
			_tmp622_ = FALSE;
		}
		if (_tmp622_) {
			ValaSymbol* _tmp627_;
			ValaSourceReference* _tmp628_;
			ValaSourceReference* _tmp629_;
			ValaSourceFile* _tmp630_;
			ValaSourceFile* _tmp631_;
			const gchar* _tmp632_;
			const gchar* _tmp633_;
			gchar* _tmp634_;
			const gchar* _tmp635_;
			_tmp627_ = base_symbol;
			_tmp628_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp627_);
			_tmp629_ = _tmp628_;
			_tmp630_ = vala_source_reference_get_file (_tmp629_);
			_tmp631_ = _tmp630_;
			_tmp632_ = vala_source_file_get_package_name (_tmp631_);
			_tmp633_ = _tmp632_;
			_tmp634_ = g_strdup (_tmp633_);
			_g_free0 (base_type_package);
			base_type_package = _tmp634_;
			_tmp635_ = base_type_package;
			if (_tmp635_ != NULL) {
				const gchar* _tmp636_;
				gchar* _tmp637_;
				_tmp636_ = base_type_package;
				_tmp637_ = g_strdup_printf (" (%s)", _tmp636_);
				_g_free0 (base_type_package);
				base_type_package = _tmp637_;
			}
		}
		_tmp638_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp639_ = _tmp638_;
		_tmp640_ = self->priv->_member_name;
		_tmp641_ = base_type_name;
		_tmp642_ = base_type_package;
		_tmp643_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'%s", _tmp640_, _tmp641_, _tmp642_);
		_tmp644_ = _tmp643_;
		vala_report_error (_tmp639_, _tmp644_);
		_g_free0 (_tmp644_);
		_tmp645_ = vala_invalid_type_new ();
		_tmp646_ = _tmp645_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp646_);
		_vala_code_node_unref0 (_tmp646_);
		result = FALSE;
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		return result;
	} else {
		ValaSymbol* _tmp647_;
		ValaSymbol* _tmp648_;
		gboolean _tmp649_;
		gboolean _tmp650_;
		_tmp647_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp648_ = _tmp647_;
		_tmp649_ = vala_code_node_get_error ((ValaCodeNode*) _tmp648_);
		_tmp650_ = _tmp649_;
		if (_tmp650_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp651_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp652_ = _tmp651_;
	member = _tmp652_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp653_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp653_, context)) {
		result = FALSE;
		return result;
	}
	_tmp654_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp654_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp655_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp656_;
		ValaSymbol* _tmp657_;
		ValaSymbol* _tmp658_;
		gboolean _tmp659_ = FALSE;
		ValaBlock* _tmp660_;
		_tmp655_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp655_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp656_ = local;
		_tmp657_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp656_);
		_tmp658_ = _tmp657_;
		block = VALA_IS_BLOCK (_tmp658_) ? ((ValaBlock*) _tmp658_) : NULL;
		_tmp660_ = block;
		if (_tmp660_ != NULL) {
			ValaBlock* _tmp661_;
			ValaSymbol* _tmp662_;
			ValaSemanticAnalyzer* _tmp663_;
			ValaSemanticAnalyzer* _tmp664_;
			ValaSymbol* _tmp665_;
			ValaSymbol* _tmp666_;
			_tmp661_ = block;
			_tmp662_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp661_);
			_tmp663_ = vala_code_context_get_analyzer (context);
			_tmp664_ = _tmp663_;
			_tmp665_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp664_);
			_tmp666_ = _tmp665_;
			_tmp659_ = _tmp662_ != _tmp666_;
		} else {
			_tmp659_ = FALSE;
		}
		if (_tmp659_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp667_;
			ValaSemanticAnalyzer* _tmp668_;
			ValaSymbol* _tmp669_;
			ValaSymbol* _tmp670_;
			ValaLocalVariable* _tmp681_;
			ValaBlock* _tmp682_;
			_tmp667_ = vala_code_context_get_analyzer (context);
			_tmp668_ = _tmp667_;
			_tmp669_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp668_);
			_tmp670_ = _tmp669_;
			sym = _tmp670_;
			while (TRUE) {
				ValaSymbol* _tmp671_;
				ValaBlock* _tmp672_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp673_;
				ValaMethod* _tmp674_;
				ValaSymbol* _tmp678_;
				ValaSymbol* _tmp679_;
				ValaSymbol* _tmp680_;
				_tmp671_ = sym;
				_tmp672_ = block;
				if (!(_tmp671_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp672_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp673_ = sym;
				method = VALA_IS_METHOD (_tmp673_) ? ((ValaMethod*) _tmp673_) : NULL;
				_tmp674_ = method;
				if (_tmp674_ != NULL) {
					ValaMethod* _tmp675_;
					ValaMethod* _tmp676_;
					ValaLocalVariable* _tmp677_;
					_tmp675_ = method;
					vala_method_set_closure (_tmp675_, TRUE);
					_tmp676_ = method;
					_tmp677_ = local;
					vala_method_add_captured_variable (_tmp676_, _tmp677_);
				}
				_tmp678_ = sym;
				_tmp679_ = vala_symbol_get_parent_symbol (_tmp678_);
				_tmp680_ = _tmp679_;
				sym = _tmp680_;
			}
			_tmp681_ = local;
			vala_local_variable_set_captured (_tmp681_, TRUE);
			_tmp682_ = block;
			vala_block_set_captured (_tmp682_, TRUE);
		}
	} else {
		ValaSymbol* _tmp683_;
		_tmp683_ = member;
		if (VALA_IS_PARAMETER (_tmp683_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp684_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp685_;
			ValaSymbol* _tmp686_;
			ValaSymbol* _tmp687_;
			gboolean _tmp688_ = FALSE;
			gboolean _tmp689_ = FALSE;
			ValaMethod* _tmp690_;
			_tmp684_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp684_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp685_ = param;
			_tmp686_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp685_);
			_tmp687_ = _tmp686_;
			m = VALA_IS_METHOD (_tmp687_) ? ((ValaMethod*) _tmp687_) : NULL;
			_tmp690_ = m;
			if (_tmp690_ != NULL) {
				ValaMethod* _tmp691_;
				ValaSemanticAnalyzer* _tmp692_;
				ValaSemanticAnalyzer* _tmp693_;
				ValaSymbol* _tmp694_;
				ValaSymbol* _tmp695_;
				_tmp691_ = m;
				_tmp692_ = vala_code_context_get_analyzer (context);
				_tmp693_ = _tmp692_;
				_tmp694_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp693_);
				_tmp695_ = _tmp694_;
				_tmp689_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp691_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp695_;
			} else {
				_tmp689_ = FALSE;
			}
			if (_tmp689_) {
				ValaParameter* _tmp696_;
				ValaMethod* _tmp697_;
				ValaParameter* _tmp698_;
				ValaParameter* _tmp699_;
				_tmp696_ = param;
				_tmp697_ = m;
				_tmp698_ = vala_method_get_this_parameter (_tmp697_);
				_tmp699_ = _tmp698_;
				_tmp688_ = _tmp696_ != _tmp699_;
			} else {
				_tmp688_ = FALSE;
			}
			if (_tmp688_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp700_;
				ValaSemanticAnalyzer* _tmp701_;
				ValaSymbol* _tmp702_;
				ValaSymbol* _tmp703_;
				ValaParameter* _tmp712_;
				ValaMethod* _tmp713_;
				ValaBlock* _tmp714_;
				ValaBlock* _tmp715_;
				ValaParameter* _tmp716_;
				ValaParameterDirection _tmp717_;
				ValaParameterDirection _tmp718_;
				_tmp700_ = vala_code_context_get_analyzer (context);
				_tmp701_ = _tmp700_;
				_tmp702_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp701_);
				_tmp703_ = _tmp702_;
				sym = _tmp703_;
				while (TRUE) {
					ValaSymbol* _tmp704_;
					ValaMethod* _tmp705_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp706_;
					ValaMethod* _tmp707_;
					ValaSymbol* _tmp709_;
					ValaSymbol* _tmp710_;
					ValaSymbol* _tmp711_;
					_tmp704_ = sym;
					_tmp705_ = m;
					if (!(_tmp704_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp705_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp706_ = sym;
					method = VALA_IS_METHOD (_tmp706_) ? ((ValaMethod*) _tmp706_) : NULL;
					_tmp707_ = method;
					if (_tmp707_ != NULL) {
						ValaMethod* _tmp708_;
						_tmp708_ = method;
						vala_method_set_closure (_tmp708_, TRUE);
					}
					_tmp709_ = sym;
					_tmp710_ = vala_symbol_get_parent_symbol (_tmp709_);
					_tmp711_ = _tmp710_;
					sym = _tmp711_;
				}
				_tmp712_ = param;
				vala_parameter_set_captured (_tmp712_, TRUE);
				_tmp713_ = m;
				_tmp714_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp713_);
				_tmp715_ = _tmp714_;
				vala_block_set_captured (_tmp715_, TRUE);
				_tmp716_ = param;
				_tmp717_ = vala_parameter_get_direction (_tmp716_);
				_tmp718_ = _tmp717_;
				if (_tmp718_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp719_;
					ValaSourceReference* _tmp720_;
					ValaParameter* _tmp721_;
					gchar* _tmp722_;
					gchar* _tmp723_;
					gchar* _tmp724_;
					gchar* _tmp725_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp719_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp720_ = _tmp719_;
					_tmp721_ = param;
					_tmp722_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp721_);
					_tmp723_ = _tmp722_;
					_tmp724_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp723_);
					_tmp725_ = _tmp724_;
					vala_report_error (_tmp720_, _tmp725_);
					_g_free0 (_tmp725_);
					_g_free0 (_tmp723_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp726_;
				ValaSymbol* _tmp727_;
				ValaSymbol* _tmp728_;
				ValaSymbol* _tmp729_;
				ValaSymbol* _tmp730_;
				gboolean _tmp731_ = FALSE;
				gboolean _tmp732_ = FALSE;
				ValaPropertyAccessor* _tmp733_;
				_tmp726_ = param;
				_tmp727_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp726_);
				_tmp728_ = _tmp727_;
				_tmp729_ = vala_symbol_get_parent_symbol (_tmp728_);
				_tmp730_ = _tmp729_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp730_) ? ((ValaPropertyAccessor*) _tmp730_) : NULL;
				_tmp733_ = acc;
				if (_tmp733_ != NULL) {
					ValaPropertyAccessor* _tmp734_;
					ValaSemanticAnalyzer* _tmp735_;
					ValaSemanticAnalyzer* _tmp736_;
					ValaSymbol* _tmp737_;
					ValaSymbol* _tmp738_;
					_tmp734_ = acc;
					_tmp735_ = vala_code_context_get_analyzer (context);
					_tmp736_ = _tmp735_;
					_tmp737_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp736_);
					_tmp738_ = _tmp737_;
					_tmp732_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp734_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp738_;
				} else {
					_tmp732_ = FALSE;
				}
				if (_tmp732_) {
					ValaParameter* _tmp739_;
					ValaPropertyAccessor* _tmp740_;
					ValaProperty* _tmp741_;
					ValaProperty* _tmp742_;
					ValaParameter* _tmp743_;
					ValaParameter* _tmp744_;
					_tmp739_ = param;
					_tmp740_ = acc;
					_tmp741_ = vala_property_accessor_get_prop (_tmp740_);
					_tmp742_ = _tmp741_;
					_tmp743_ = vala_property_get_this_parameter (_tmp742_);
					_tmp744_ = _tmp743_;
					_tmp731_ = _tmp739_ != _tmp744_;
				} else {
					_tmp731_ = FALSE;
				}
				if (_tmp731_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp745_;
					ValaSemanticAnalyzer* _tmp746_;
					ValaSymbol* _tmp747_;
					ValaSymbol* _tmp748_;
					ValaParameter* _tmp757_;
					ValaPropertyAccessor* _tmp758_;
					ValaBlock* _tmp759_;
					ValaBlock* _tmp760_;
					_tmp745_ = vala_code_context_get_analyzer (context);
					_tmp746_ = _tmp745_;
					_tmp747_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp746_);
					_tmp748_ = _tmp747_;
					sym = _tmp748_;
					while (TRUE) {
						ValaSymbol* _tmp749_;
						ValaMethod* _tmp750_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp751_;
						ValaMethod* _tmp752_;
						ValaSymbol* _tmp754_;
						ValaSymbol* _tmp755_;
						ValaSymbol* _tmp756_;
						_tmp749_ = sym;
						_tmp750_ = m;
						if (!(_tmp749_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp750_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp751_ = sym;
						method = VALA_IS_METHOD (_tmp751_) ? ((ValaMethod*) _tmp751_) : NULL;
						_tmp752_ = method;
						if (_tmp752_ != NULL) {
							ValaMethod* _tmp753_;
							_tmp753_ = method;
							vala_method_set_closure (_tmp753_, TRUE);
						}
						_tmp754_ = sym;
						_tmp755_ = vala_symbol_get_parent_symbol (_tmp754_);
						_tmp756_ = _tmp755_;
						sym = _tmp756_;
					}
					_tmp757_ = param;
					vala_parameter_set_captured (_tmp757_, TRUE);
					_tmp758_ = acc;
					_tmp759_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp758_);
					_tmp760_ = _tmp759_;
					vala_block_set_captured (_tmp760_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp761_;
			_tmp761_ = member;
			if (VALA_IS_FIELD (_tmp761_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp762_;
				ValaField* _tmp763_;
				ValaSymbolAccessibility _tmp764_;
				ValaSymbolAccessibility _tmp765_;
				ValaField* _tmp766_;
				ValaMemberBinding _tmp767_;
				ValaMemberBinding _tmp768_;
				ValaField* _tmp769_;
				ValaMemberBinding _tmp770_;
				ValaMemberBinding _tmp771_;
				ValaField* _tmp772_;
				ValaDataType* _tmp773_;
				ValaDataType* _tmp774_;
				_tmp762_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp762_, VALA_TYPE_FIELD, ValaField);
				_tmp763_ = f;
				_tmp764_ = vala_symbol_get_access ((ValaSymbol*) _tmp763_);
				_tmp765_ = _tmp764_;
				access = _tmp765_;
				_tmp766_ = f;
				_tmp767_ = vala_field_get_binding (_tmp766_);
				_tmp768_ = _tmp767_;
				instance = _tmp768_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp769_ = f;
				_tmp770_ = vala_field_get_binding (_tmp769_);
				_tmp771_ = _tmp770_;
				klass = _tmp771_ == VALA_MEMBER_BINDING_CLASS;
				_tmp772_ = f;
				_tmp773_ = vala_variable_get_variable_type ((ValaVariable*) _tmp772_);
				_tmp774_ = _tmp773_;
				if (VALA_IS_GENERIC_TYPE (_tmp774_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp775_;
				_tmp775_ = member;
				if (VALA_IS_CONSTANT (_tmp775_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp776_;
					ValaConstant* _tmp777_;
					ValaSymbolAccessibility _tmp778_;
					ValaSymbolAccessibility _tmp779_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp780_;
					ValaSymbol* _tmp781_;
					ValaSymbol* _tmp782_;
					gboolean _tmp783_ = FALSE;
					ValaBlock* _tmp784_;
					_tmp776_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp776_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp777_ = c;
					_tmp778_ = vala_symbol_get_access ((ValaSymbol*) _tmp777_);
					_tmp779_ = _tmp778_;
					access = _tmp779_;
					_tmp780_ = c;
					_tmp781_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp780_);
					_tmp782_ = _tmp781_;
					block = VALA_IS_BLOCK (_tmp782_) ? ((ValaBlock*) _tmp782_) : NULL;
					_tmp784_ = block;
					if (_tmp784_ != NULL) {
						ValaBlock* _tmp785_;
						ValaSymbol* _tmp786_;
						ValaSemanticAnalyzer* _tmp787_;
						ValaSemanticAnalyzer* _tmp788_;
						ValaSymbol* _tmp789_;
						ValaSymbol* _tmp790_;
						_tmp785_ = block;
						_tmp786_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp785_);
						_tmp787_ = vala_code_context_get_analyzer (context);
						_tmp788_ = _tmp787_;
						_tmp789_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp788_);
						_tmp790_ = _tmp789_;
						_tmp783_ = _tmp786_ != _tmp790_;
					} else {
						_tmp783_ = FALSE;
					}
					if (_tmp783_) {
						ValaSourceReference* _tmp791_;
						ValaSourceReference* _tmp792_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp791_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp792_ = _tmp791_;
						vala_report_error (_tmp792_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						return result;
					}
				} else {
					ValaSymbol* _tmp793_;
					_tmp793_ = member;
					if (VALA_IS_METHOD (_tmp793_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp794_;
						ValaMethod* _tmp795_;
						gboolean _tmp796_;
						gboolean _tmp797_;
						ValaMethod* _tmp886_;
						ValaSymbolAccessibility _tmp887_;
						ValaSymbolAccessibility _tmp888_;
						ValaMethod* _tmp889_;
						ValaMethod* _tmp893_;
						ValaMemberBinding _tmp894_;
						ValaMemberBinding _tmp895_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp914_;
						ValaDataType* _tmp915_;
						ValaDataType* _tmp916_;
						gboolean _tmp917_ = FALSE;
						ValaGenericType* _tmp918_;
						_tmp794_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp794_, VALA_TYPE_METHOD, ValaMethod);
						_tmp795_ = m;
						_tmp796_ = vala_method_get_is_async_callback (_tmp795_);
						_tmp797_ = _tmp796_;
						if (_tmp797_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp798_;
							ValaSemanticAnalyzer* _tmp799_;
							ValaMethod* _tmp800_;
							ValaMethod* _tmp801_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp802_;
							ValaMethod* _tmp831_;
							ValaSemanticAnalyzer* _tmp832_;
							ValaSemanticAnalyzer* _tmp833_;
							ValaMethod* _tmp834_;
							ValaMethod* _tmp835_;
							ValaMethod* _tmp851_;
							ValaMethod* _tmp852_;
							ValaMethod* _tmp853_;
							ValaSymbol* _tmp854_;
							ValaSymbol* _tmp855_;
							_tmp798_ = vala_code_context_get_analyzer (context);
							_tmp799_ = _tmp798_;
							_tmp800_ = vala_semantic_analyzer_get_current_async_method (_tmp799_);
							_tmp801_ = _tmp800_;
							async_method = _tmp801_;
							is_valid_access = FALSE;
							_tmp802_ = async_method;
							if (_tmp802_ != NULL) {
								ValaMethod* _tmp803_;
								ValaMethod* _tmp804_;
								ValaMethod* _tmp805_;
								_tmp803_ = m;
								_tmp804_ = async_method;
								_tmp805_ = vala_method_get_callback_method (_tmp804_);
								if (_tmp803_ == _tmp805_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp806_ = FALSE;
									ValaMethod* _tmp807_;
									ValaMethod* _tmp808_;
									ValaMethod* _tmp809_;
									_tmp807_ = async_method;
									_tmp808_ = vala_method_get_base_method (_tmp807_);
									_tmp809_ = _tmp808_;
									if (_tmp809_ != NULL) {
										ValaMethod* _tmp810_;
										ValaMethod* _tmp811_;
										ValaMethod* _tmp812_;
										ValaMethod* _tmp813_;
										ValaMethod* _tmp814_;
										_tmp810_ = m;
										_tmp811_ = async_method;
										_tmp812_ = vala_method_get_base_method (_tmp811_);
										_tmp813_ = _tmp812_;
										_tmp814_ = vala_method_get_callback_method (_tmp813_);
										_tmp806_ = _tmp810_ == _tmp814_;
									} else {
										_tmp806_ = FALSE;
									}
									if (_tmp806_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp815_ = FALSE;
										ValaMethod* _tmp816_;
										ValaMethod* _tmp817_;
										ValaMethod* _tmp818_;
										_tmp816_ = async_method;
										_tmp817_ = vala_method_get_base_interface_method (_tmp816_);
										_tmp818_ = _tmp817_;
										if (_tmp818_ != NULL) {
											ValaMethod* _tmp819_;
											ValaMethod* _tmp820_;
											ValaMethod* _tmp821_;
											ValaMethod* _tmp822_;
											ValaMethod* _tmp823_;
											_tmp819_ = m;
											_tmp820_ = async_method;
											_tmp821_ = vala_method_get_base_interface_method (_tmp820_);
											_tmp822_ = _tmp821_;
											_tmp823_ = vala_method_get_callback_method (_tmp822_);
											_tmp815_ = _tmp819_ == _tmp823_;
										} else {
											_tmp815_ = FALSE;
										}
										if (_tmp815_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp824_;
								ValaSourceReference* _tmp825_;
								ValaMethod* _tmp826_;
								gchar* _tmp827_;
								gchar* _tmp828_;
								gchar* _tmp829_;
								gchar* _tmp830_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp824_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp825_ = _tmp824_;
								_tmp826_ = m;
								_tmp827_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp826_);
								_tmp828_ = _tmp827_;
								_tmp829_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp828_);
								_tmp830_ = _tmp829_;
								vala_report_error (_tmp825_, _tmp830_);
								_g_free0 (_tmp830_);
								_g_free0 (_tmp828_);
								result = FALSE;
								return result;
							}
							_tmp831_ = async_method;
							_tmp832_ = vala_code_context_get_analyzer (context);
							_tmp833_ = _tmp832_;
							_tmp834_ = vala_semantic_analyzer_get_current_method (_tmp833_);
							_tmp835_ = _tmp834_;
							if (_tmp831_ != _tmp835_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp836_;
								ValaSemanticAnalyzer* _tmp837_;
								ValaMethod* _tmp838_;
								ValaMethod* _tmp839_;
								ValaMethod* _tmp848_;
								ValaBlock* _tmp849_;
								ValaBlock* _tmp850_;
								_tmp836_ = vala_code_context_get_analyzer (context);
								_tmp837_ = _tmp836_;
								_tmp838_ = vala_semantic_analyzer_get_current_method (_tmp837_);
								_tmp839_ = _tmp838_;
								sym = (ValaSymbol*) _tmp839_;
								while (TRUE) {
									ValaSymbol* _tmp840_;
									ValaMethod* _tmp841_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp842_;
									ValaMethod* _tmp843_;
									ValaSymbol* _tmp845_;
									ValaSymbol* _tmp846_;
									ValaSymbol* _tmp847_;
									_tmp840_ = sym;
									_tmp841_ = async_method;
									if (!(_tmp840_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp841_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp842_ = sym;
									method = VALA_IS_METHOD (_tmp842_) ? ((ValaMethod*) _tmp842_) : NULL;
									_tmp843_ = method;
									if (_tmp843_ != NULL) {
										ValaMethod* _tmp844_;
										_tmp844_ = method;
										vala_method_set_closure (_tmp844_, TRUE);
									}
									_tmp845_ = sym;
									_tmp846_ = vala_symbol_get_parent_symbol (_tmp845_);
									_tmp847_ = _tmp846_;
									sym = _tmp847_;
								}
								_tmp848_ = async_method;
								_tmp849_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp848_);
								_tmp850_ = _tmp849_;
								vala_block_set_captured (_tmp850_, TRUE);
							}
							_tmp851_ = async_method;
							_tmp852_ = vala_method_get_callback_method (_tmp851_);
							m = _tmp852_;
							_tmp853_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp853_);
							_tmp854_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp855_ = _tmp854_;
							member = _tmp855_;
						} else {
							ValaMethod* _tmp856_;
							ValaMethod* _tmp857_;
							ValaMethod* _tmp858_;
							_tmp856_ = m;
							_tmp857_ = vala_method_get_base_method (_tmp856_);
							_tmp858_ = _tmp857_;
							if (_tmp858_ != NULL) {
								ValaMethod* _tmp859_;
								ValaMethod* _tmp860_;
								ValaMethod* _tmp861_;
								ValaMethod* _tmp862_;
								ValaSignal* _tmp863_;
								ValaSignal* _tmp864_;
								ValaSymbol* _tmp869_;
								ValaSymbol* _tmp870_;
								_tmp859_ = m;
								_tmp860_ = vala_method_get_base_method (_tmp859_);
								_tmp861_ = _tmp860_;
								m = _tmp861_;
								_tmp862_ = m;
								_tmp863_ = vala_method_get_signal_reference (_tmp862_);
								_tmp864_ = _tmp863_;
								if (_tmp864_ != NULL) {
									ValaMethod* _tmp865_;
									ValaSignal* _tmp866_;
									ValaSignal* _tmp867_;
									_tmp865_ = m;
									_tmp866_ = vala_method_get_signal_reference (_tmp865_);
									_tmp867_ = _tmp866_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp867_);
								} else {
									ValaMethod* _tmp868_;
									_tmp868_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp868_);
								}
								_tmp869_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp870_ = _tmp869_;
								member = _tmp870_;
							} else {
								ValaMethod* _tmp871_;
								ValaMethod* _tmp872_;
								ValaMethod* _tmp873_;
								_tmp871_ = m;
								_tmp872_ = vala_method_get_base_interface_method (_tmp871_);
								_tmp873_ = _tmp872_;
								if (_tmp873_ != NULL) {
									ValaMethod* _tmp874_;
									ValaMethod* _tmp875_;
									ValaMethod* _tmp876_;
									ValaMethod* _tmp877_;
									ValaSignal* _tmp878_;
									ValaSignal* _tmp879_;
									ValaSymbol* _tmp884_;
									ValaSymbol* _tmp885_;
									_tmp874_ = m;
									_tmp875_ = vala_method_get_base_interface_method (_tmp874_);
									_tmp876_ = _tmp875_;
									m = _tmp876_;
									_tmp877_ = m;
									_tmp878_ = vala_method_get_signal_reference (_tmp877_);
									_tmp879_ = _tmp878_;
									if (_tmp879_ != NULL) {
										ValaMethod* _tmp880_;
										ValaSignal* _tmp881_;
										ValaSignal* _tmp882_;
										_tmp880_ = m;
										_tmp881_ = vala_method_get_signal_reference (_tmp880_);
										_tmp882_ = _tmp881_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp882_);
									} else {
										ValaMethod* _tmp883_;
										_tmp883_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp883_);
									}
									_tmp884_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp885_ = _tmp884_;
									member = _tmp885_;
								}
							}
						}
						_tmp886_ = m;
						_tmp887_ = vala_symbol_get_access ((ValaSymbol*) _tmp886_);
						_tmp888_ = _tmp887_;
						access = _tmp888_;
						_tmp889_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp889_)) {
							ValaMethod* _tmp890_;
							ValaMemberBinding _tmp891_;
							ValaMemberBinding _tmp892_;
							_tmp890_ = m;
							_tmp891_ = vala_method_get_binding (_tmp890_);
							_tmp892_ = _tmp891_;
							instance = _tmp892_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp893_ = m;
						_tmp894_ = vala_method_get_binding (_tmp893_);
						_tmp895_ = _tmp894_;
						klass = _tmp895_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp896_;
							ValaList* _tmp897_;
							ValaList* _tmp898_;
							gint _param_size = 0;
							ValaList* _tmp899_;
							gint _tmp900_;
							gint _tmp901_;
							gint _param_index = 0;
							_tmp896_ = m;
							_tmp897_ = vala_callable_get_parameters ((ValaCallable*) _tmp896_);
							_tmp898_ = _vala_iterable_ref0 (_tmp897_);
							_param_list = _tmp898_;
							_tmp899_ = _param_list;
							_tmp900_ = vala_collection_get_size ((ValaCollection*) _tmp899_);
							_tmp901_ = _tmp900_;
							_param_size = _tmp901_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp902_;
								gpointer _tmp903_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp904_;
								ValaDataType* _tmp905_;
								ValaDataType* _tmp906_;
								gboolean _tmp907_ = FALSE;
								ValaGenericType* _tmp908_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp902_ = _param_list;
								_tmp903_ = vala_list_get (_tmp902_, _param_index);
								param = (ValaParameter*) _tmp903_;
								_tmp904_ = param;
								_tmp905_ = vala_variable_get_variable_type ((ValaVariable*) _tmp904_);
								_tmp906_ = _tmp905_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp906_) ? ((ValaGenericType*) _tmp906_) : NULL;
								_tmp908_ = generic_type;
								if (_tmp908_ != NULL) {
									ValaGenericType* _tmp909_;
									ValaTypeParameter* _tmp910_;
									ValaTypeParameter* _tmp911_;
									ValaSymbol* _tmp912_;
									ValaSymbol* _tmp913_;
									_tmp909_ = generic_type;
									_tmp910_ = vala_generic_type_get_type_parameter (_tmp909_);
									_tmp911_ = _tmp910_;
									_tmp912_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp911_);
									_tmp913_ = _tmp912_;
									_tmp907_ = VALA_IS_TYPESYMBOL (_tmp913_);
								} else {
									_tmp907_ = FALSE;
								}
								if (_tmp907_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp914_ = m;
						_tmp915_ = vala_callable_get_return_type ((ValaCallable*) _tmp914_);
						_tmp916_ = _tmp915_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp916_) ? ((ValaGenericType*) _tmp916_) : NULL;
						_tmp918_ = generic_type;
						if (_tmp918_ != NULL) {
							ValaGenericType* _tmp919_;
							ValaTypeParameter* _tmp920_;
							ValaTypeParameter* _tmp921_;
							ValaSymbol* _tmp922_;
							ValaSymbol* _tmp923_;
							_tmp919_ = generic_type;
							_tmp920_ = vala_generic_type_get_type_parameter (_tmp919_);
							_tmp921_ = _tmp920_;
							_tmp922_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp921_);
							_tmp923_ = _tmp922_;
							_tmp917_ = VALA_IS_TYPESYMBOL (_tmp923_);
						} else {
							_tmp917_ = FALSE;
						}
						if (_tmp917_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp924_;
						_tmp924_ = member;
						if (VALA_IS_PROPERTY (_tmp924_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp925_;
							ValaProperty* _tmp926_;
							ValaProperty* _tmp927_;
							ValaProperty* _tmp928_;
							ValaProperty* _tmp929_;
							ValaProperty* _tmp945_;
							ValaSymbolAccessibility _tmp946_;
							ValaSymbolAccessibility _tmp947_;
							gboolean _tmp948_;
							gboolean _tmp949_;
							ValaProperty* _tmp1014_;
							ValaMemberBinding _tmp1015_;
							ValaMemberBinding _tmp1016_;
							ValaProperty* _tmp1017_;
							ValaDataType* _tmp1018_;
							ValaDataType* _tmp1019_;
							_tmp925_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp925_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp926_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp926_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								return result;
							}
							_tmp927_ = prop;
							_tmp928_ = vala_property_get_base_property (_tmp927_);
							_tmp929_ = _tmp928_;
							if (_tmp929_ != NULL) {
								ValaProperty* _tmp930_;
								ValaProperty* _tmp931_;
								ValaProperty* _tmp932_;
								ValaProperty* _tmp933_;
								ValaSymbol* _tmp934_;
								ValaSymbol* _tmp935_;
								_tmp930_ = prop;
								_tmp931_ = vala_property_get_base_property (_tmp930_);
								_tmp932_ = _tmp931_;
								prop = _tmp932_;
								_tmp933_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp933_);
								_tmp934_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp935_ = _tmp934_;
								member = _tmp935_;
							} else {
								ValaProperty* _tmp936_;
								ValaProperty* _tmp937_;
								ValaProperty* _tmp938_;
								_tmp936_ = prop;
								_tmp937_ = vala_property_get_base_interface_property (_tmp936_);
								_tmp938_ = _tmp937_;
								if (_tmp938_ != NULL) {
									ValaProperty* _tmp939_;
									ValaProperty* _tmp940_;
									ValaProperty* _tmp941_;
									ValaProperty* _tmp942_;
									ValaSymbol* _tmp943_;
									ValaSymbol* _tmp944_;
									_tmp939_ = prop;
									_tmp940_ = vala_property_get_base_interface_property (_tmp939_);
									_tmp941_ = _tmp940_;
									prop = _tmp941_;
									_tmp942_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp942_);
									_tmp943_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp944_ = _tmp943_;
									member = _tmp944_;
								}
							}
							_tmp945_ = prop;
							_tmp946_ = vala_symbol_get_access ((ValaSymbol*) _tmp945_);
							_tmp947_ = _tmp946_;
							access = _tmp947_;
							_tmp948_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp949_ = _tmp948_;
							if (_tmp949_) {
								ValaProperty* _tmp950_;
								ValaPropertyAccessor* _tmp951_;
								ValaPropertyAccessor* _tmp952_;
								ValaProperty* _tmp960_;
								ValaSymbolAccessibility _tmp961_;
								ValaSymbolAccessibility _tmp962_;
								_tmp950_ = prop;
								_tmp951_ = vala_property_get_set_accessor (_tmp950_);
								_tmp952_ = _tmp951_;
								if (_tmp952_ == NULL) {
									ValaSourceReference* _tmp953_;
									ValaSourceReference* _tmp954_;
									ValaProperty* _tmp955_;
									gchar* _tmp956_;
									gchar* _tmp957_;
									gchar* _tmp958_;
									gchar* _tmp959_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp953_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp954_ = _tmp953_;
									_tmp955_ = prop;
									_tmp956_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp955_);
									_tmp957_ = _tmp956_;
									_tmp958_ = g_strdup_printf ("Property `%s' is read-only", _tmp957_);
									_tmp959_ = _tmp958_;
									vala_report_error (_tmp954_, _tmp959_);
									_g_free0 (_tmp959_);
									_g_free0 (_tmp957_);
									result = FALSE;
									return result;
								}
								_tmp960_ = prop;
								_tmp961_ = vala_symbol_get_access ((ValaSymbol*) _tmp960_);
								_tmp962_ = _tmp961_;
								if (_tmp962_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp963_;
									ValaPropertyAccessor* _tmp964_;
									ValaPropertyAccessor* _tmp965_;
									ValaSymbolAccessibility _tmp966_;
									ValaSymbolAccessibility _tmp967_;
									_tmp963_ = prop;
									_tmp964_ = vala_property_get_set_accessor (_tmp963_);
									_tmp965_ = _tmp964_;
									_tmp966_ = vala_symbol_get_access ((ValaSymbol*) _tmp965_);
									_tmp967_ = _tmp966_;
									access = _tmp967_;
								} else {
									gboolean _tmp968_ = FALSE;
									ValaProperty* _tmp969_;
									ValaSymbolAccessibility _tmp970_;
									ValaSymbolAccessibility _tmp971_;
									_tmp969_ = prop;
									_tmp970_ = vala_symbol_get_access ((ValaSymbol*) _tmp969_);
									_tmp971_ = _tmp970_;
									if (_tmp971_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp972_;
										ValaPropertyAccessor* _tmp973_;
										ValaPropertyAccessor* _tmp974_;
										ValaSymbolAccessibility _tmp975_;
										ValaSymbolAccessibility _tmp976_;
										_tmp972_ = prop;
										_tmp973_ = vala_property_get_set_accessor (_tmp972_);
										_tmp974_ = _tmp973_;
										_tmp975_ = vala_symbol_get_access ((ValaSymbol*) _tmp974_);
										_tmp976_ = _tmp975_;
										_tmp968_ = _tmp976_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp968_ = FALSE;
									}
									if (_tmp968_) {
										ValaProperty* _tmp977_;
										ValaPropertyAccessor* _tmp978_;
										ValaPropertyAccessor* _tmp979_;
										ValaSymbolAccessibility _tmp980_;
										ValaSymbolAccessibility _tmp981_;
										_tmp977_ = prop;
										_tmp978_ = vala_property_get_set_accessor (_tmp977_);
										_tmp979_ = _tmp978_;
										_tmp980_ = vala_symbol_get_access ((ValaSymbol*) _tmp979_);
										_tmp981_ = _tmp980_;
										access = _tmp981_;
									}
								}
							} else {
								ValaProperty* _tmp982_;
								ValaPropertyAccessor* _tmp983_;
								ValaPropertyAccessor* _tmp984_;
								ValaProperty* _tmp992_;
								ValaSymbolAccessibility _tmp993_;
								ValaSymbolAccessibility _tmp994_;
								_tmp982_ = prop;
								_tmp983_ = vala_property_get_get_accessor (_tmp982_);
								_tmp984_ = _tmp983_;
								if (_tmp984_ == NULL) {
									ValaSourceReference* _tmp985_;
									ValaSourceReference* _tmp986_;
									ValaProperty* _tmp987_;
									gchar* _tmp988_;
									gchar* _tmp989_;
									gchar* _tmp990_;
									gchar* _tmp991_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp985_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp986_ = _tmp985_;
									_tmp987_ = prop;
									_tmp988_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp987_);
									_tmp989_ = _tmp988_;
									_tmp990_ = g_strdup_printf ("Property `%s' is write-only", _tmp989_);
									_tmp991_ = _tmp990_;
									vala_report_error (_tmp986_, _tmp991_);
									_g_free0 (_tmp991_);
									_g_free0 (_tmp989_);
									result = FALSE;
									return result;
								}
								_tmp992_ = prop;
								_tmp993_ = vala_symbol_get_access ((ValaSymbol*) _tmp992_);
								_tmp994_ = _tmp993_;
								if (_tmp994_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp995_;
									ValaPropertyAccessor* _tmp996_;
									ValaPropertyAccessor* _tmp997_;
									ValaSymbolAccessibility _tmp998_;
									ValaSymbolAccessibility _tmp999_;
									_tmp995_ = prop;
									_tmp996_ = vala_property_get_get_accessor (_tmp995_);
									_tmp997_ = _tmp996_;
									_tmp998_ = vala_symbol_get_access ((ValaSymbol*) _tmp997_);
									_tmp999_ = _tmp998_;
									access = _tmp999_;
								} else {
									gboolean _tmp1000_ = FALSE;
									ValaProperty* _tmp1001_;
									ValaSymbolAccessibility _tmp1002_;
									ValaSymbolAccessibility _tmp1003_;
									_tmp1001_ = prop;
									_tmp1002_ = vala_symbol_get_access ((ValaSymbol*) _tmp1001_);
									_tmp1003_ = _tmp1002_;
									if (_tmp1003_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1004_;
										ValaPropertyAccessor* _tmp1005_;
										ValaPropertyAccessor* _tmp1006_;
										ValaSymbolAccessibility _tmp1007_;
										ValaSymbolAccessibility _tmp1008_;
										_tmp1004_ = prop;
										_tmp1005_ = vala_property_get_get_accessor (_tmp1004_);
										_tmp1006_ = _tmp1005_;
										_tmp1007_ = vala_symbol_get_access ((ValaSymbol*) _tmp1006_);
										_tmp1008_ = _tmp1007_;
										_tmp1000_ = _tmp1008_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1000_ = FALSE;
									}
									if (_tmp1000_) {
										ValaProperty* _tmp1009_;
										ValaPropertyAccessor* _tmp1010_;
										ValaPropertyAccessor* _tmp1011_;
										ValaSymbolAccessibility _tmp1012_;
										ValaSymbolAccessibility _tmp1013_;
										_tmp1009_ = prop;
										_tmp1010_ = vala_property_get_get_accessor (_tmp1009_);
										_tmp1011_ = _tmp1010_;
										_tmp1012_ = vala_symbol_get_access ((ValaSymbol*) _tmp1011_);
										_tmp1013_ = _tmp1012_;
										access = _tmp1013_;
									}
								}
							}
							_tmp1014_ = prop;
							_tmp1015_ = vala_property_get_binding (_tmp1014_);
							_tmp1016_ = _tmp1015_;
							instance = _tmp1016_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1017_ = prop;
							_tmp1018_ = vala_property_get_property_type (_tmp1017_);
							_tmp1019_ = _tmp1018_;
							if (VALA_IS_GENERIC_TYPE (_tmp1019_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1020_;
							_tmp1020_ = member;
							if (VALA_IS_SIGNAL (_tmp1020_)) {
								ValaSymbol* _tmp1021_;
								ValaSymbolAccessibility _tmp1022_;
								ValaSymbolAccessibility _tmp1023_;
								instance = TRUE;
								_tmp1021_ = member;
								_tmp1022_ = vala_symbol_get_access (_tmp1021_);
								_tmp1023_ = _tmp1022_;
								access = _tmp1023_;
							} else {
								gboolean _tmp1024_ = FALSE;
								gboolean _tmp1025_;
								_tmp1025_ = self->priv->_creation_member;
								if (!_tmp1025_) {
									ValaSymbol* _tmp1026_;
									_tmp1026_ = member;
									_tmp1024_ = VALA_IS_ERROR_CODE (_tmp1026_);
								} else {
									_tmp1024_ = FALSE;
								}
								if (_tmp1024_) {
									ValaSymbol* _tmp1027_;
									ValaConstant* _tmp1028_;
									ValaConstant* _tmp1029_;
									ValaSymbol* _tmp1030_;
									ValaSymbol* _tmp1031_;
									_tmp1027_ = member;
									_tmp1028_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1027_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1029_ = _tmp1028_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1029_);
									_tmp1030_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1031_ = _tmp1030_;
									member = _tmp1031_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1032_;
		ValaSymbol* _tmp1033_;
		ValaCodeNode* _tmp1034_;
		ValaCodeNode* _tmp1035_;
		ValaCodeNode* _tmp1036_;
		gboolean _tmp1037_ = FALSE;
		ValaCodeNode* _tmp1038_;
		_tmp1032_ = parent;
		_tmp1033_ = member;
		if (!(_tmp1032_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1033_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1034_ = parent;
		_tmp1035_ = vala_code_node_get_parent_node (_tmp1034_);
		_tmp1036_ = _tmp1035_;
		parent = _tmp1036_;
		_tmp1038_ = parent;
		if (_tmp1038_ == NULL) {
			_tmp1037_ = TRUE;
		} else {
			ValaCodeNode* _tmp1039_;
			ValaSymbol* _tmp1040_;
			_tmp1039_ = parent;
			_tmp1040_ = member;
			_tmp1037_ = _tmp1039_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1040_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1037_) {
			break;
		}
	}
	_tmp1041_ = parent;
	_tmp1042_ = member;
	if (_tmp1041_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1042_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1043_;
		_tmp1043_ = member;
		vala_symbol_set_used (_tmp1043_, TRUE);
	}
	_tmp1044_ = member;
	_tmp1045_ = vala_symbol_get_version (_tmp1044_);
	_tmp1046_ = _tmp1045_;
	_tmp1047_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1048_ = _tmp1047_;
	vala_version_attribute_check (_tmp1046_, _tmp1048_);
	_tmp1050_ = access;
	if (_tmp1050_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1051_;
		ValaSymbol* _tmp1052_;
		ValaSymbol* _tmp1053_;
		_tmp1051_ = member;
		_tmp1052_ = vala_symbol_get_parent_symbol (_tmp1051_);
		_tmp1053_ = _tmp1052_;
		_tmp1049_ = VALA_IS_TYPESYMBOL (_tmp1053_);
	} else {
		_tmp1049_ = FALSE;
	}
	if (_tmp1049_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1054_;
		ValaSymbol* _tmp1055_;
		ValaSymbol* _tmp1056_;
		gboolean in_subtype = FALSE;
		_tmp1054_ = member;
		_tmp1055_ = vala_symbol_get_parent_symbol (_tmp1054_);
		_tmp1056_ = _tmp1055_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1056_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1057_;
			ValaSemanticAnalyzer* _tmp1058_;
			ValaSymbol* _tmp1059_;
			ValaSymbol* _tmp1060_;
			ValaSymbol* _tmp1061_;
			_tmp1057_ = vala_code_context_get_analyzer (context);
			_tmp1058_ = _tmp1057_;
			_tmp1059_ = vala_semantic_analyzer_get_current_symbol (_tmp1058_);
			_tmp1060_ = _tmp1059_;
			_tmp1061_ = _vala_code_node_ref0 (_tmp1060_);
			this_symbol = _tmp1061_;
			{
				gboolean _tmp1062_ = FALSE;
				_tmp1062_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1067_;
					ValaSymbol* _tmp1068_;
					ValaTypeSymbol* _tmp1069_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1070_;
					gboolean _tmp1071_ = FALSE;
					ValaClass* _tmp1072_;
					if (!_tmp1062_) {
						ValaSymbol* _tmp1063_;
						ValaSymbol* _tmp1064_;
						ValaSymbol* _tmp1065_;
						ValaSymbol* _tmp1066_;
						_tmp1063_ = this_symbol;
						_tmp1064_ = vala_symbol_get_parent_symbol (_tmp1063_);
						_tmp1065_ = _tmp1064_;
						_tmp1066_ = _vala_code_node_ref0 (_tmp1065_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1066_;
					}
					_tmp1062_ = FALSE;
					_tmp1067_ = this_symbol;
					if (!(_tmp1067_ != NULL)) {
						break;
					}
					_tmp1068_ = this_symbol;
					_tmp1069_ = target_type;
					if (_tmp1068_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1069_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1070_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1070_) ? ((ValaClass*) _tmp1070_) : NULL;
					_tmp1072_ = cl;
					if (_tmp1072_ != NULL) {
						ValaClass* _tmp1073_;
						ValaTypeSymbol* _tmp1074_;
						_tmp1073_ = cl;
						_tmp1074_ = target_type;
						_tmp1071_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1073_, _tmp1074_);
					} else {
						_tmp1071_ = FALSE;
					}
					if (_tmp1071_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1075_;
			ValaSourceReference* _tmp1076_;
			ValaSymbol* _tmp1077_;
			gchar* _tmp1078_;
			gchar* _tmp1079_;
			gchar* _tmp1080_;
			gchar* _tmp1081_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1075_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1076_ = _tmp1075_;
			_tmp1077_ = member;
			_tmp1078_ = vala_symbol_get_full_name (_tmp1077_);
			_tmp1079_ = _tmp1078_;
			_tmp1080_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1079_);
			_tmp1081_ = _tmp1080_;
			vala_report_error (_tmp1076_, _tmp1081_);
			_g_free0 (_tmp1081_);
			_g_free0 (_tmp1079_);
			result = FALSE;
			return result;
		}
	} else {
		ValaSymbolAccessibility _tmp1082_;
		_tmp1082_ = access;
		if (_tmp1082_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1083_;
			ValaSymbol* _tmp1084_;
			ValaSymbol* _tmp1085_;
			gboolean in_target_type = FALSE;
			_tmp1083_ = member;
			_tmp1084_ = vala_symbol_get_parent_symbol (_tmp1083_);
			_tmp1085_ = _tmp1084_;
			target_type = _tmp1085_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1086_;
				ValaSemanticAnalyzer* _tmp1087_;
				ValaSymbol* _tmp1088_;
				ValaSymbol* _tmp1089_;
				ValaSymbol* _tmp1090_;
				_tmp1086_ = vala_code_context_get_analyzer (context);
				_tmp1087_ = _tmp1086_;
				_tmp1088_ = vala_semantic_analyzer_get_current_symbol (_tmp1087_);
				_tmp1089_ = _tmp1088_;
				_tmp1090_ = _vala_code_node_ref0 (_tmp1089_);
				this_symbol = _tmp1090_;
				{
					gboolean _tmp1091_ = FALSE;
					_tmp1091_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1096_;
						ValaSymbol* _tmp1097_;
						ValaSymbol* _tmp1098_;
						if (!_tmp1091_) {
							ValaSymbol* _tmp1092_;
							ValaSymbol* _tmp1093_;
							ValaSymbol* _tmp1094_;
							ValaSymbol* _tmp1095_;
							_tmp1092_ = this_symbol;
							_tmp1093_ = vala_symbol_get_parent_symbol (_tmp1092_);
							_tmp1094_ = _tmp1093_;
							_tmp1095_ = _vala_code_node_ref0 (_tmp1094_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1095_;
						}
						_tmp1091_ = FALSE;
						_tmp1096_ = this_symbol;
						if (!(_tmp1096_ != NULL)) {
							break;
						}
						_tmp1097_ = target_type;
						_tmp1098_ = this_symbol;
						if (_tmp1097_ == _tmp1098_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1099_;
				ValaSourceReference* _tmp1100_;
				ValaSymbol* _tmp1101_;
				gchar* _tmp1102_;
				gchar* _tmp1103_;
				gchar* _tmp1104_;
				gchar* _tmp1105_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1099_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1100_ = _tmp1099_;
				_tmp1101_ = member;
				_tmp1102_ = vala_symbol_get_full_name (_tmp1101_);
				_tmp1103_ = _tmp1102_;
				_tmp1104_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1103_);
				_tmp1105_ = _tmp1104_;
				vala_report_error (_tmp1100_, _tmp1105_);
				_g_free0 (_tmp1105_);
				_g_free0 (_tmp1103_);
				result = FALSE;
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1107_;
		ValaExpression* _tmp1108_;
		_tmp1107_ = vala_member_access_get_inner (self);
		_tmp1108_ = _tmp1107_;
		_tmp1106_ = _tmp1108_ != NULL;
	} else {
		_tmp1106_ = FALSE;
	}
	if (_tmp1106_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1109_;
		ValaExpression* _tmp1110_;
		ValaDataType* _tmp1111_;
		ValaDataType* _tmp1112_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1113_;
		ValaExpression* _tmp1114_;
		ValaDataType* _tmp1115_;
		ValaDataType* _tmp1116_;
		ValaPointerType* _tmp1117_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1121_;
		gboolean _tmp1122_ = FALSE;
		gboolean _tmp1123_ = FALSE;
		ValaObjectType* _tmp1124_;
		_tmp1109_ = vala_member_access_get_inner (self);
		_tmp1110_ = _tmp1109_;
		_tmp1111_ = vala_expression_get_value_type (_tmp1110_);
		_tmp1112_ = _tmp1111_;
		instance_type = _tmp1112_;
		_tmp1113_ = vala_member_access_get_inner (self);
		_tmp1114_ = _tmp1113_;
		_tmp1115_ = vala_expression_get_value_type (_tmp1114_);
		_tmp1116_ = _tmp1115_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1116_) ? ((ValaPointerType*) _tmp1116_) : NULL;
		_tmp1117_ = pointer_type;
		if (_tmp1117_ != NULL) {
			ValaPointerType* _tmp1118_;
			ValaDataType* _tmp1119_;
			ValaDataType* _tmp1120_;
			_tmp1118_ = pointer_type;
			_tmp1119_ = vala_pointer_type_get_base_type (_tmp1118_);
			_tmp1120_ = _tmp1119_;
			instance_type = _tmp1120_;
		}
		_tmp1121_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1121_) ? ((ValaObjectType*) _tmp1121_) : NULL;
		_tmp1124_ = object_type;
		if (_tmp1124_ != NULL) {
			ValaObjectType* _tmp1125_;
			ValaObjectTypeSymbol* _tmp1126_;
			ValaObjectTypeSymbol* _tmp1127_;
			_tmp1125_ = object_type;
			_tmp1126_ = vala_object_type_get_object_type_symbol (_tmp1125_);
			_tmp1127_ = _tmp1126_;
			_tmp1123_ = vala_object_type_symbol_has_type_parameters (_tmp1127_);
		} else {
			_tmp1123_ = FALSE;
		}
		if (_tmp1123_) {
			ValaDataType* _tmp1128_;
			_tmp1128_ = instance_type;
			_tmp1122_ = !vala_data_type_has_type_arguments (_tmp1128_);
		} else {
			_tmp1122_ = FALSE;
		}
		if (_tmp1122_) {
			ValaExpression* _tmp1129_;
			ValaExpression* _tmp1130_;
			ValaSourceReference* _tmp1131_;
			ValaSourceReference* _tmp1132_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1129_ = vala_member_access_get_inner (self);
			_tmp1130_ = _tmp1129_;
			_tmp1131_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1130_);
			_tmp1132_ = _tmp1131_;
			vala_report_error (_tmp1132_, "missing generic type arguments");
			result = FALSE;
			return result;
		}
	}
	if (instance) {
		_tmp1134_ = !may_access_instance_members;
	} else {
		_tmp1134_ = FALSE;
	}
	if (_tmp1134_) {
		_tmp1133_ = TRUE;
	} else {
		gboolean _tmp1135_ = FALSE;
		if (klass) {
			_tmp1135_ = !may_access_klass_members;
		} else {
			_tmp1135_ = FALSE;
		}
		_tmp1133_ = _tmp1135_;
	}
	if (_tmp1133_) {
		ValaSymbol* _tmp1136_;
		ValaSymbol* _tmp1137_;
		ValaDataType* _tmp1160_;
		ValaDataType* _tmp1161_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1136_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1137_ = _tmp1136_;
		if (VALA_IS_METHOD (_tmp1137_)) {
			ValaSemanticAnalyzer* _tmp1138_;
			ValaSemanticAnalyzer* _tmp1139_;
			ValaSymbol* _tmp1140_;
			ValaSymbol* _tmp1141_;
			gboolean _tmp1142_;
			gboolean _tmp1143_;
			ValaDataType* _tmp1144_;
			ValaDataType* _tmp1145_;
			_tmp1138_ = vala_code_context_get_analyzer (context);
			_tmp1139_ = _tmp1138_;
			_tmp1140_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1141_ = _tmp1140_;
			_tmp1142_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1143_ = _tmp1142_;
			_tmp1144_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1139_, _tmp1141_, _tmp1143_);
			_tmp1145_ = _tmp1144_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1145_);
			_vala_code_node_unref0 (_tmp1145_);
		} else {
			ValaSymbol* _tmp1146_;
			ValaSymbol* _tmp1147_;
			_tmp1146_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1147_ = _tmp1146_;
			if (VALA_IS_FIELD (_tmp1147_)) {
				ValaSymbol* _tmp1148_;
				ValaSymbol* _tmp1149_;
				ValaFieldPrototype* _tmp1150_;
				ValaFieldPrototype* _tmp1151_;
				_tmp1148_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1149_ = _tmp1148_;
				_tmp1150_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1149_, VALA_TYPE_FIELD, ValaField));
				_tmp1151_ = _tmp1150_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1151_);
				_vala_code_node_unref0 (_tmp1151_);
			} else {
				ValaSymbol* _tmp1152_;
				ValaSymbol* _tmp1153_;
				_tmp1152_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1153_ = _tmp1152_;
				if (VALA_IS_PROPERTY (_tmp1153_)) {
					ValaSymbol* _tmp1154_;
					ValaSymbol* _tmp1155_;
					ValaPropertyPrototype* _tmp1156_;
					ValaPropertyPrototype* _tmp1157_;
					_tmp1154_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1155_ = _tmp1154_;
					_tmp1156_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1155_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1157_ = _tmp1156_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1157_);
					_vala_code_node_unref0 (_tmp1157_);
				} else {
					ValaInvalidType* _tmp1158_;
					ValaInvalidType* _tmp1159_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1158_ = vala_invalid_type_new ();
					_tmp1159_ = _tmp1158_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1159_);
					_vala_code_node_unref0 (_tmp1159_);
				}
			}
		}
		_tmp1160_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1161_ = _tmp1160_;
		if (_tmp1161_ != NULL) {
			ValaDataType* _tmp1162_;
			ValaDataType* _tmp1163_;
			ValaDataType* _tmp1164_;
			ValaDataType* _tmp1165_;
			gboolean _tmp1166_;
			gboolean _tmp1167_;
			_tmp1162_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1163_ = _tmp1162_;
			_tmp1164_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1165_ = _tmp1164_;
			_tmp1166_ = vala_data_type_get_value_owned (_tmp1165_);
			_tmp1167_ = _tmp1166_;
			vala_data_type_set_value_owned (_tmp1163_, _tmp1167_);
		}
	} else {
		gboolean _tmp1168_ = FALSE;
		gboolean _tmp1189_ = FALSE;
		gboolean _tmp1190_ = FALSE;
		gboolean _tmp1191_ = FALSE;
		gboolean _tmp1192_ = FALSE;
		gboolean _tmp1209_ = FALSE;
		gboolean _tmp1210_ = FALSE;
		gboolean _tmp1211_ = FALSE;
		gboolean _tmp1212_ = FALSE;
		gboolean _tmp1213_ = FALSE;
		gboolean _tmp1214_;
		gboolean _tmp1215_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1242_;
		ValaSymbol* _tmp1243_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1244_;
		ValaExpression* _tmp1245_;
		gboolean _tmp1246_ = FALSE;
		gboolean _tmp1247_ = FALSE;
		gboolean _tmp1248_ = FALSE;
		gboolean _tmp1249_ = FALSE;
		gboolean _tmp1250_ = FALSE;
		ValaMethod* _tmp1251_;
		ValaSemanticAnalyzer* _tmp1288_;
		ValaSemanticAnalyzer* _tmp1289_;
		ValaSymbol* _tmp1290_;
		ValaSymbol* _tmp1291_;
		gboolean _tmp1292_;
		gboolean _tmp1293_;
		ValaDataType* _tmp1294_;
		ValaDataType* _tmp1295_;
		gboolean _tmp1296_ = FALSE;
		ValaExpression* _tmp1297_;
		ValaExpression* _tmp1298_;
		ValaSymbol* _tmp1311_;
		ValaSymbol* _tmp1312_;
		if (instance) {
			ValaExpression* _tmp1169_;
			ValaExpression* _tmp1170_;
			_tmp1169_ = vala_member_access_get_inner (self);
			_tmp1170_ = _tmp1169_;
			_tmp1168_ = _tmp1170_ == NULL;
		} else {
			_tmp1168_ = FALSE;
		}
		if (_tmp1168_) {
			ValaSourceReference* _tmp1171_;
			ValaSourceReference* _tmp1172_;
			ValaMemberAccess* _tmp1173_;
			ValaMemberAccess* _tmp1174_;
			ValaExpression* _tmp1175_;
			ValaExpression* _tmp1176_;
			ValaParameter* _tmp1177_;
			ValaDataType* _tmp1178_;
			ValaDataType* _tmp1179_;
			ValaDataType* _tmp1180_;
			ValaDataType* _tmp1181_;
			ValaExpression* _tmp1182_;
			ValaExpression* _tmp1183_;
			ValaDataType* _tmp1184_;
			ValaDataType* _tmp1185_;
			ValaExpression* _tmp1186_;
			ValaExpression* _tmp1187_;
			ValaParameter* _tmp1188_;
			_tmp1171_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1172_ = _tmp1171_;
			_tmp1173_ = vala_member_access_new (NULL, "this", _tmp1172_);
			_tmp1174_ = _tmp1173_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1174_);
			_vala_code_node_unref0 (_tmp1174_);
			_tmp1175_ = vala_member_access_get_inner (self);
			_tmp1176_ = _tmp1175_;
			_tmp1177_ = this_parameter;
			_tmp1178_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1177_);
			_tmp1179_ = _tmp1178_;
			_tmp1180_ = vala_data_type_copy (_tmp1179_);
			_tmp1181_ = _tmp1180_;
			vala_expression_set_value_type (_tmp1176_, _tmp1181_);
			_vala_code_node_unref0 (_tmp1181_);
			_tmp1182_ = vala_member_access_get_inner (self);
			_tmp1183_ = _tmp1182_;
			_tmp1184_ = vala_expression_get_value_type (_tmp1183_);
			_tmp1185_ = _tmp1184_;
			vala_data_type_set_value_owned (_tmp1185_, FALSE);
			_tmp1186_ = vala_member_access_get_inner (self);
			_tmp1187_ = _tmp1186_;
			_tmp1188_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1187_, (ValaSymbol*) _tmp1188_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1192_ = !klass;
		} else {
			_tmp1192_ = FALSE;
		}
		if (_tmp1192_) {
			ValaSymbol* _tmp1193_;
			ValaSymbol* _tmp1194_;
			_tmp1193_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1194_ = _tmp1193_;
			_tmp1191_ = !VALA_IS_CREATION_METHOD (_tmp1194_);
		} else {
			_tmp1191_ = FALSE;
		}
		if (_tmp1191_) {
			_tmp1190_ = may_access_instance_members;
		} else {
			_tmp1190_ = FALSE;
		}
		if (_tmp1190_) {
			ValaExpression* _tmp1195_;
			ValaExpression* _tmp1196_;
			_tmp1195_ = vala_member_access_get_inner (self);
			_tmp1196_ = _tmp1195_;
			_tmp1189_ = _tmp1196_ != NULL;
		} else {
			_tmp1189_ = FALSE;
		}
		if (_tmp1189_) {
			ValaExpression* _tmp1197_;
			ValaExpression* _tmp1198_;
			ValaSymbol* _tmp1199_;
			ValaSymbol* _tmp1200_;
			_tmp1197_ = vala_member_access_get_inner (self);
			_tmp1198_ = _tmp1197_;
			_tmp1199_ = vala_expression_get_symbol_reference (_tmp1198_);
			_tmp1200_ = _tmp1199_;
			if (VALA_IS_METHOD (_tmp1200_)) {
			} else {
				ValaSourceReference* _tmp1201_;
				ValaSourceReference* _tmp1202_;
				ValaSymbol* _tmp1203_;
				ValaSymbol* _tmp1204_;
				gchar* _tmp1205_;
				gchar* _tmp1206_;
				gchar* _tmp1207_;
				gchar* _tmp1208_;
				_tmp1201_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1202_ = _tmp1201_;
				_tmp1203_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1204_ = _tmp1203_;
				_tmp1205_ = vala_symbol_get_full_name (_tmp1204_);
				_tmp1206_ = _tmp1205_;
				_tmp1207_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1206_);
				_tmp1208_ = _tmp1207_;
				vala_report_warning (_tmp1202_, _tmp1208_);
				_g_free0 (_tmp1208_);
				_g_free0 (_tmp1206_);
			}
		}
		_tmp1214_ = vala_code_context_get_experimental_non_null (context);
		_tmp1215_ = _tmp1214_;
		if (_tmp1215_) {
			_tmp1213_ = instance;
		} else {
			_tmp1213_ = FALSE;
		}
		if (_tmp1213_) {
			ValaExpression* _tmp1216_;
			ValaExpression* _tmp1217_;
			ValaDataType* _tmp1218_;
			ValaDataType* _tmp1219_;
			gboolean _tmp1220_;
			gboolean _tmp1221_;
			_tmp1216_ = vala_member_access_get_inner (self);
			_tmp1217_ = _tmp1216_;
			_tmp1218_ = vala_expression_get_value_type (_tmp1217_);
			_tmp1219_ = _tmp1218_;
			_tmp1220_ = vala_data_type_get_nullable (_tmp1219_);
			_tmp1221_ = _tmp1220_;
			_tmp1212_ = _tmp1221_;
		} else {
			_tmp1212_ = FALSE;
		}
		if (_tmp1212_) {
			ValaExpression* _tmp1222_;
			ValaExpression* _tmp1223_;
			ValaDataType* _tmp1224_;
			ValaDataType* _tmp1225_;
			_tmp1222_ = vala_member_access_get_inner (self);
			_tmp1223_ = _tmp1222_;
			_tmp1224_ = vala_expression_get_value_type (_tmp1223_);
			_tmp1225_ = _tmp1224_;
			_tmp1211_ = !VALA_IS_POINTER_TYPE (_tmp1225_);
		} else {
			_tmp1211_ = FALSE;
		}
		if (_tmp1211_) {
			ValaExpression* _tmp1226_;
			ValaExpression* _tmp1227_;
			ValaDataType* _tmp1228_;
			ValaDataType* _tmp1229_;
			_tmp1226_ = vala_member_access_get_inner (self);
			_tmp1227_ = _tmp1226_;
			_tmp1228_ = vala_expression_get_value_type (_tmp1227_);
			_tmp1229_ = _tmp1228_;
			_tmp1210_ = !VALA_IS_GENERIC_TYPE (_tmp1229_);
		} else {
			_tmp1210_ = FALSE;
		}
		if (_tmp1210_) {
			ValaExpression* _tmp1230_;
			ValaExpression* _tmp1231_;
			ValaDataType* _tmp1232_;
			ValaDataType* _tmp1233_;
			_tmp1230_ = vala_member_access_get_inner (self);
			_tmp1231_ = _tmp1230_;
			_tmp1232_ = vala_expression_get_value_type (_tmp1231_);
			_tmp1233_ = _tmp1232_;
			_tmp1209_ = !VALA_IS_ARRAY_TYPE (_tmp1233_);
		} else {
			_tmp1209_ = FALSE;
		}
		if (_tmp1209_) {
			ValaSourceReference* _tmp1234_;
			ValaSourceReference* _tmp1235_;
			ValaSymbol* _tmp1236_;
			ValaSymbol* _tmp1237_;
			gchar* _tmp1238_;
			gchar* _tmp1239_;
			gchar* _tmp1240_;
			gchar* _tmp1241_;
			_tmp1234_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1235_ = _tmp1234_;
			_tmp1236_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1237_ = _tmp1236_;
			_tmp1238_ = vala_symbol_get_full_name (_tmp1237_);
			_tmp1239_ = _tmp1238_;
			_tmp1240_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1239_);
			_tmp1241_ = _tmp1240_;
			vala_report_error (_tmp1235_, _tmp1241_);
			_g_free0 (_tmp1241_);
			_g_free0 (_tmp1239_);
		}
		_tmp1242_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1243_ = _tmp1242_;
		m = VALA_IS_METHOD (_tmp1243_) ? ((ValaMethod*) _tmp1243_) : NULL;
		_tmp1244_ = vala_member_access_get_inner (self);
		_tmp1245_ = _tmp1244_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1245_) ? ((ValaMemberAccess*) _tmp1245_) : NULL;
		_tmp1251_ = m;
		if (_tmp1251_ != NULL) {
			ValaMethod* _tmp1252_;
			ValaMemberBinding _tmp1253_;
			ValaMemberBinding _tmp1254_;
			_tmp1252_ = m;
			_tmp1253_ = vala_method_get_binding (_tmp1252_);
			_tmp1254_ = _tmp1253_;
			_tmp1250_ = _tmp1254_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1250_ = FALSE;
		}
		if (_tmp1250_) {
			ValaMethod* _tmp1255_;
			ValaSymbol* _tmp1256_;
			ValaSymbol* _tmp1257_;
			_tmp1255_ = m;
			_tmp1256_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1255_);
			_tmp1257_ = _tmp1256_;
			_tmp1249_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1257_);
		} else {
			_tmp1249_ = FALSE;
		}
		if (_tmp1249_) {
			ValaExpression* _tmp1258_;
			ValaExpression* _tmp1259_;
			_tmp1258_ = vala_member_access_get_inner (self);
			_tmp1259_ = _tmp1258_;
			_tmp1248_ = _tmp1259_ != NULL;
		} else {
			_tmp1248_ = FALSE;
		}
		if (_tmp1248_) {
			ValaExpression* _tmp1260_;
			ValaExpression* _tmp1261_;
			ValaDataType* _tmp1262_;
			ValaDataType* _tmp1263_;
			_tmp1260_ = vala_member_access_get_inner (self);
			_tmp1261_ = _tmp1260_;
			_tmp1262_ = vala_expression_get_value_type (_tmp1261_);
			_tmp1263_ = _tmp1262_;
			_tmp1247_ = _tmp1263_ == NULL;
		} else {
			_tmp1247_ = FALSE;
		}
		if (_tmp1247_) {
			ValaMemberAccess* _tmp1264_;
			ValaList* _tmp1265_;
			gint _tmp1266_;
			gint _tmp1267_;
			_tmp1264_ = inner_ma;
			_tmp1265_ = _tmp1264_->priv->type_argument_list;
			_tmp1266_ = vala_collection_get_size ((ValaCollection*) _tmp1265_);
			_tmp1267_ = _tmp1266_;
			_tmp1246_ = _tmp1267_ > 0;
		} else {
			_tmp1246_ = FALSE;
		}
		if (_tmp1246_) {
			ValaExpression* _tmp1268_;
			ValaExpression* _tmp1269_;
			ValaMethod* _tmp1270_;
			ValaSymbol* _tmp1271_;
			ValaSymbol* _tmp1272_;
			ValaObjectType* _tmp1273_;
			ValaObjectType* _tmp1274_;
			_tmp1268_ = vala_member_access_get_inner (self);
			_tmp1269_ = _tmp1268_;
			_tmp1270_ = m;
			_tmp1271_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1270_);
			_tmp1272_ = _tmp1271_;
			_tmp1273_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1272_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1274_ = _tmp1273_;
			vala_expression_set_value_type (_tmp1269_, (ValaDataType*) _tmp1274_);
			_vala_code_node_unref0 (_tmp1274_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1275_;
				ValaList* _tmp1276_;
				ValaList* _tmp1277_;
				gint _type_argument_size = 0;
				ValaList* _tmp1278_;
				gint _tmp1279_;
				gint _tmp1280_;
				gint _type_argument_index = 0;
				_tmp1275_ = inner_ma;
				_tmp1276_ = _tmp1275_->priv->type_argument_list;
				_tmp1277_ = _vala_iterable_ref0 (_tmp1276_);
				_type_argument_list = _tmp1277_;
				_tmp1278_ = _type_argument_list;
				_tmp1279_ = vala_collection_get_size ((ValaCollection*) _tmp1278_);
				_tmp1280_ = _tmp1279_;
				_type_argument_size = _tmp1280_;
				_type_argument_index = -1;
				while (TRUE) {
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1281_;
					gpointer _tmp1282_;
					ValaExpression* _tmp1283_;
					ValaExpression* _tmp1284_;
					ValaDataType* _tmp1285_;
					ValaDataType* _tmp1286_;
					ValaDataType* _tmp1287_;
					_type_argument_index = _type_argument_index + 1;
					if (!(_type_argument_index < _type_argument_size)) {
						break;
					}
					_tmp1281_ = _type_argument_list;
					_tmp1282_ = vala_list_get (_tmp1281_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1282_;
					_tmp1283_ = vala_member_access_get_inner (self);
					_tmp1284_ = _tmp1283_;
					_tmp1285_ = vala_expression_get_value_type (_tmp1284_);
					_tmp1286_ = _tmp1285_;
					_tmp1287_ = type_argument;
					vala_data_type_add_type_argument (_tmp1286_, _tmp1287_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1288_ = vala_code_context_get_analyzer (context);
		_tmp1289_ = _tmp1288_;
		_tmp1290_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1291_ = _tmp1290_;
		_tmp1292_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1293_ = _tmp1292_;
		_tmp1294_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1289_, _tmp1291_, _tmp1293_);
		_tmp1295_ = _tmp1294_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1295_);
		_vala_code_node_unref0 (_tmp1295_);
		_tmp1297_ = vala_member_access_get_inner (self);
		_tmp1298_ = _tmp1297_;
		if (_tmp1298_ != NULL) {
			ValaDataType* _tmp1299_;
			ValaDataType* _tmp1300_;
			_tmp1299_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1300_ = _tmp1299_;
			_tmp1296_ = _tmp1300_ != NULL;
		} else {
			_tmp1296_ = FALSE;
		}
		if (_tmp1296_) {
			ValaDataType* _tmp1301_;
			ValaDataType* _tmp1302_;
			ValaExpression* _tmp1303_;
			ValaExpression* _tmp1304_;
			ValaDataType* _tmp1305_;
			ValaDataType* _tmp1306_;
			ValaDataType* _tmp1307_;
			ValaDataType* _tmp1308_;
			_tmp1301_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1302_ = _tmp1301_;
			_tmp1303_ = vala_member_access_get_inner (self);
			_tmp1304_ = _tmp1303_;
			_tmp1305_ = vala_expression_get_value_type (_tmp1304_);
			_tmp1306_ = _tmp1305_;
			_tmp1307_ = vala_data_type_get_actual_type (_tmp1302_, _tmp1306_, NULL, (ValaCodeNode*) self);
			_tmp1308_ = _tmp1307_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1308_);
			_vala_code_node_unref0 (_tmp1308_);
		} else {
			ValaDataType* _tmp1309_;
			ValaDataType* _tmp1310_;
			_tmp1309_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1310_ = _tmp1309_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1310_);
		}
		_tmp1311_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1312_ = _tmp1311_;
		if (VALA_IS_METHOD (_tmp1312_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1313_;
			ValaSymbol* _tmp1314_;
			ValaDataType* _tmp1315_;
			ValaDataType* _tmp1316_;
			gboolean _tmp1323_ = FALSE;
			_tmp1313_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1314_ = _tmp1313_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1314_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1315_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1316_ = _tmp1315_;
			if (_tmp1316_ != NULL) {
				ValaDataType* _tmp1317_;
				ValaDataType* _tmp1318_;
				ValaDataType* _tmp1319_;
				ValaDataType* _tmp1320_;
				gboolean _tmp1321_;
				gboolean _tmp1322_;
				_tmp1317_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1318_ = _tmp1317_;
				_tmp1319_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1320_ = _tmp1319_;
				_tmp1321_ = vala_data_type_get_value_owned (_tmp1320_);
				_tmp1322_ = _tmp1321_;
				vala_data_type_set_value_owned (_tmp1318_, _tmp1322_);
			}
			if (instance) {
				ValaMethod* _tmp1324_;
				ValaSymbol* _tmp1325_;
				ValaSymbol* _tmp1326_;
				_tmp1324_ = method;
				_tmp1325_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1324_);
				_tmp1326_ = _tmp1325_;
				_tmp1323_ = VALA_IS_TYPESYMBOL (_tmp1326_);
			} else {
				_tmp1323_ = FALSE;
			}
			if (_tmp1323_) {
				ValaExpression* _tmp1327_;
				ValaExpression* _tmp1328_;
				ValaMethod* _tmp1329_;
				ValaSymbol* _tmp1330_;
				ValaSymbol* _tmp1331_;
				ValaDataType* _tmp1332_;
				ValaDataType* _tmp1333_;
				ValaExpression* _tmp1334_;
				ValaExpression* _tmp1335_;
				ValaDataType* _tmp1336_;
				ValaDataType* _tmp1337_;
				ValaMethod* _tmp1338_;
				ValaParameter* _tmp1339_;
				ValaParameter* _tmp1340_;
				ValaDataType* _tmp1341_;
				ValaDataType* _tmp1342_;
				gboolean _tmp1343_;
				gboolean _tmp1344_;
				_tmp1327_ = vala_member_access_get_inner (self);
				_tmp1328_ = _tmp1327_;
				_tmp1329_ = method;
				_tmp1330_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1329_);
				_tmp1331_ = _tmp1330_;
				_tmp1332_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1331_);
				_tmp1333_ = _tmp1332_;
				vala_expression_set_target_type (_tmp1328_, _tmp1333_);
				_vala_code_node_unref0 (_tmp1333_);
				_tmp1334_ = vala_member_access_get_inner (self);
				_tmp1335_ = _tmp1334_;
				_tmp1336_ = vala_expression_get_target_type (_tmp1335_);
				_tmp1337_ = _tmp1336_;
				_tmp1338_ = method;
				_tmp1339_ = vala_method_get_this_parameter (_tmp1338_);
				_tmp1340_ = _tmp1339_;
				_tmp1341_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1340_);
				_tmp1342_ = _tmp1341_;
				_tmp1343_ = vala_data_type_get_value_owned (_tmp1342_);
				_tmp1344_ = _tmp1343_;
				vala_data_type_set_value_owned (_tmp1337_, _tmp1344_);
			}
		} else {
			gboolean _tmp1345_ = FALSE;
			gboolean _tmp1346_ = FALSE;
			ValaSymbol* _tmp1347_;
			ValaSymbol* _tmp1348_;
			_tmp1347_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1348_ = _tmp1347_;
			if (VALA_IS_PROPERTY (_tmp1348_)) {
				_tmp1346_ = instance;
			} else {
				_tmp1346_ = FALSE;
			}
			if (_tmp1346_) {
				ValaSymbol* _tmp1349_;
				ValaSymbol* _tmp1350_;
				ValaSymbol* _tmp1351_;
				ValaSymbol* _tmp1352_;
				_tmp1349_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1350_ = _tmp1349_;
				_tmp1351_ = vala_symbol_get_parent_symbol (_tmp1350_);
				_tmp1352_ = _tmp1351_;
				_tmp1345_ = _tmp1352_ != NULL;
			} else {
				_tmp1345_ = FALSE;
			}
			if (_tmp1345_) {
				ValaExpression* _tmp1353_;
				ValaExpression* _tmp1354_;
				ValaSymbol* _tmp1355_;
				ValaSymbol* _tmp1356_;
				ValaSymbol* _tmp1357_;
				ValaSymbol* _tmp1358_;
				ValaDataType* _tmp1359_;
				ValaDataType* _tmp1360_;
				_tmp1353_ = vala_member_access_get_inner (self);
				_tmp1354_ = _tmp1353_;
				_tmp1355_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1356_ = _tmp1355_;
				_tmp1357_ = vala_symbol_get_parent_symbol (_tmp1356_);
				_tmp1358_ = _tmp1357_;
				_tmp1359_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1358_);
				_tmp1360_ = _tmp1359_;
				vala_expression_set_target_type (_tmp1354_, _tmp1360_);
				_vala_code_node_unref0 (_tmp1360_);
			} else {
				gboolean _tmp1361_ = FALSE;
				gboolean _tmp1362_ = FALSE;
				gboolean _tmp1363_ = FALSE;
				ValaSymbol* _tmp1364_;
				ValaSymbol* _tmp1365_;
				_tmp1364_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1365_ = _tmp1364_;
				if (VALA_IS_FIELD (_tmp1365_)) {
					_tmp1363_ = TRUE;
				} else {
					ValaSymbol* _tmp1366_;
					ValaSymbol* _tmp1367_;
					_tmp1366_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1367_ = _tmp1366_;
					_tmp1363_ = VALA_IS_SIGNAL (_tmp1367_);
				}
				if (_tmp1363_) {
					_tmp1362_ = instance;
				} else {
					_tmp1362_ = FALSE;
				}
				if (_tmp1362_) {
					ValaSymbol* _tmp1368_;
					ValaSymbol* _tmp1369_;
					ValaSymbol* _tmp1370_;
					ValaSymbol* _tmp1371_;
					_tmp1368_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1369_ = _tmp1368_;
					_tmp1370_ = vala_symbol_get_parent_symbol (_tmp1369_);
					_tmp1371_ = _tmp1370_;
					_tmp1361_ = _tmp1371_ != NULL;
				} else {
					_tmp1361_ = FALSE;
				}
				if (_tmp1361_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1372_;
					ValaSymbol* _tmp1373_;
					ValaSymbol* _tmp1374_;
					ValaSymbol* _tmp1375_;
					ValaDataType* _tmp1376_;
					ValaExpression* _tmp1377_;
					ValaExpression* _tmp1378_;
					ValaDataType* _tmp1379_;
					ValaExpression* _tmp1380_;
					ValaExpression* _tmp1381_;
					ValaDataType* _tmp1382_;
					ValaDataType* _tmp1383_;
					ValaDataType* _tmp1384_;
					ValaDataType* _tmp1385_;
					_tmp1372_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1373_ = _tmp1372_;
					_tmp1374_ = vala_symbol_get_parent_symbol (_tmp1373_);
					_tmp1375_ = _tmp1374_;
					_tmp1376_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1375_);
					parent_type = _tmp1376_;
					_tmp1377_ = vala_member_access_get_inner (self);
					_tmp1378_ = _tmp1377_;
					_tmp1379_ = parent_type;
					_tmp1380_ = vala_member_access_get_inner (self);
					_tmp1381_ = _tmp1380_;
					_tmp1382_ = vala_expression_get_value_type (_tmp1381_);
					_tmp1383_ = _tmp1382_;
					_tmp1384_ = vala_data_type_get_actual_type (_tmp1379_, _tmp1383_, NULL, (ValaCodeNode*) self);
					_tmp1385_ = _tmp1384_;
					vala_expression_set_target_type (_tmp1378_, _tmp1385_);
					_vala_code_node_unref0 (_tmp1385_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
	}
	_tmp1386_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1387_ = _tmp1386_;
	if (_tmp1387_ != NULL) {
		ValaDataType* _tmp1388_;
		ValaDataType* _tmp1389_;
		_tmp1388_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1389_ = _tmp1388_;
		vala_code_node_check ((ValaCodeNode*) _tmp1389_, context);
	}
	_tmp1390_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1391_ = _tmp1390_;
	result = !_tmp1391_;
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

