# -*-perl-*-

# Makefile.PL for vcheck

use ExtUtils::MakeMaker;

# check Perl version

print "Checking for Perl 5.005 or later...";
if ($] < 5.005) {
 print " failed -- found only v$].\n";
 exit -1
}
print " OK.\n";

# check for required modules...

$| = 1;
my $missing_modules = 0;

# libwww-perl
print "Checking for libwww 5.0 or later...";
eval "require LWP";
if (!defined $LWP::VERSION) {
  print " missing.\n";
  $missing_modules++
} elsif ($LWP::VERSION < 5.0) {
  print " failed -- found only v$LWP::VERSION.\n";
  $missing_modules++;
} else {  
  print " OK.\n";
}

# some modules of mine
#%mods = qw(Gomar::Config 0 Gomar::Misc 0);
#for (keys %mods) {
#  print "Checking for $_" . ($mods{$_} ? "$mods{$_} or later" : "") . "...";
#  my $ver = eval "require $_; $mods{$_} ? \$${_}::VERSION : 0";
#  if (!defined $ver) {
#    print " missing.\n";
#    $missing_modules++
#  } elsif ($mods{$_} && $ver < $mods{$_}) {
#    print " failed -- found only v$ver.\n";
#    $missing_modules++;
#  } else {
#    print " OK.\n";
#  }
#}

if ($missing_modules) {
  print<<EOT;

One or more required modules are missing or too old.  Please install
sufficiently recent versions thereof and try again.

EOT
  exit -1
}

WriteMakefile(
  NAME         => 'vcheck',
  VERSION_FROM => 'vcheck',
  EXE_FILES    => [ 'vcheck' ],
  PREREQ_PM    => { LWP => '5.0' },
  dist         => { COMPRESS => 'gzip -f9', SUFFIX => 'gz' }
);

print<<'EOT';

Hint of the day:

  If you use Vim to edit vcheck's data file, remember to update the
  corresponding Vim syntax file by running

    $ vcheck --create-vim-syntax-file

  after installing a new version and copying the resulting file ("vcheck.vim")
  to your Vim syntax directory.

EOT

