/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */
/*
================================
symbolic constants to templatize
a bit
================================
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb2/vdkb_parser.h>
#include <vdkb2/vdkb_entry.h>
#include <vdkb2/vdkb_evbox.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_form.h>
#include <vdkb2/vdkb_objinspect.h>
#include <vdkb2/vdkb_prjman.h>
#include <stdlib.h>
#include <vdkb2/vdkb_fixed.h>

// for methods and other stuff
#define CLASS VDKBEntry
// put here vdk class name string
#define VDK_CLASS "VDKEntry"
// put here vdk class name
#define VDK_ANCESTOR  VDKEntry
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "entry"

static char buff[128];
extern char* wi_widget_prompts[];

// used to autogenerate default
// labelbutton  names and captions

int CLASS::Counter = 0;
/*
 label properties names
 */
char* vdkentry_props[] =
{
TEXT,EDITABLE,HIDDEN,MAXCHARS,0
};
/*
entry widget signal names && nicknames
Default response method name will be made by:
On<object name><nickname>.
For instance if object name = <Abutton> and nickname = <Click>
default response method name will be: <OnAbuttonClick>
*/
char* vdkentry_signals[] =
{
SIGNAL_ACTIVATE,SIGNAL_CHANGED,
SIGNAL_FOCUS_IN,SIGNAL_FOCUS_OUT,0
};
char* vdkentry_nicknames[] =
{
NICK_ACTIVATE,NICK_CHANGED ,
NICK_FOCUS_IN,NICK_FOCUS_OUT,0
};
//////////////////////////////////////////////////
// dynamic tables
DEFINE_SIGNAL_LIST(CLASS,VDK_ANCESTOR);
DEFINE_EVENT_LIST(CLASS,VDK_ANCESTOR);
//////////////////////////////////////////////////
/*
overridden ButtonPressed
used in substitution of
VDKBObject::ButtonPress
*/
bool
VDKBEntry::OverriddenButtonPressed(VDKObject* sender, GdkEvent* ev)
{
  VDKBEventContainer* container;
  gtk_signal_emit_stop_by_name(GTK_OBJECT(sender->WrappedWidget()),
  		       "button_press_event");
  container = dynamic_cast<VDKBEventContainer*>(sender->Parent());
  if(container)
    // we pass <this> instead <sender>
    // otherwise entry widget selection
    // is lost (don'y ask me why !)
    container->OnButtonPressed(this,ev);
  return true;
}

//////////////////////////////////////////////////////////////
/*
  - constructor
 */
CLASS::CLASS(char* name, VDKForm* owner, char* def):
  VDK_ANCESTOR(owner, 0, def),VDKBObject(name)
{
  int t;
  // newly constructed widget counter is incremented
  // each time
  Counter++;
  // assign this to VDKBObject <object> member.
  object = this;
  // add to VDKBObject properties list label button properties
  // names. (Others props are prepended  by VDKBObject constructor)
  for(t=0; vdkentry_props[t]; t++)
    proplist.add(VDKBProperty(vdkentry_props[t]));
  // add to VDKBObject signal list  signals
  for(t=0; vdkentry_signals[t]; t++)
    siglist.add(VDKBSignal(vdkentry_signals[t],
			   this,
			   vdkentry_nicknames[t]));
  //SetPropValue(TEXT,name);
  SetPropValue(MAXCHARS,"0");
  SetPropValue(EDITABLE,"true");
  // connects events.
  // an exception here
  EventConnect("button_press_event",&VDKBEntry::OverriddenButtonPressed);
  // others kept from ancestor
  EventConnect("button_release_event",&VDKBObject::ButtonReleased);
  EventConnect("enter_notify_event",&VDKBObject::OnEnter);
  EventConnect("leave_notify_event",&VDKBObject::OnLeave);
  // makes a pop menu common to all widgets (in vdkb_widpopmenu.cc/h)
  // this pop menu will be popped at righ button press event.
  popmenu = new VDKBWidgetPopMenu(this);
}
////////////////////////////////////////////////////////////////
//
//               WRITER TO .FRM FILE
//
///////////////////////////////////////////////////////////////
/*
Writes a .frm format representation of label button widget
This virtual function is called by VDKBForm::WriteBoxesOnFrm()
a recursive algorithm that scans VDKBForm widget tree.
*/
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
    char* text = (char*) GetProp(TEXT);
  // first of all call ancestor to write common properties
  VDKBObject::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\t%s%s;",
	  PROP_EDITABLE,
	  (char*) GetProp(EDITABLE));
  fprintf(fp,"\n\t%s%s;",
	  PROP_HIDDEN,
	  (char*) GetProp(HIDDEN));
  if(strcmp(text,NIHIL_PROP))
      fprintf(fp,"\n\t%s\"%s\";", PROP_TEXT, text);
  else
      fprintf(fp,"\n\t%s%s;", PROP_TEXT, text);	
  fprintf(fp,"\n\t%s%s;",
	  PROP_MAXCHARS,
	  (char*) GetProp(MAXCHARS));
}
//////////////////////////////////////////////////////////////////
//
//               PREPARE GUI WIDGETS
//
//////////////////////////////////////////////////////////////////
/*
This method is called by global MakeWidget() in vdkb_design.cc
MakeWidget() scans a table that maps class id's with each
static MakeWidget() for each class. Class id's are generated
during clicks on widget palette.
On return:
0 - successfull
1 - unsupported widget
2 - target is not a container
 */
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  CLASS* text;
  // widget name generation failed
  if(!owner->GenerateWidgetName(buff,VDK_WIDGET,&CLASS::Counter))
    // unauthorized operation
    return 2;
  else
    // actually makes widget
    text = new CLASS(buff,owner);
  // add widget to form
  return owner->AddToSelf(text,ev);
}
/*
This is called by a global CreateSource() in vdkb_parser.cc.
CreateSource() scans a table that maps class names with
each static CreateSource() in widget class.
 */
char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char obj_editable[16];
  char obj_text[256];
  char obj_maxchars[16];
  char arg[64];
  char tmp[256];
// gets widget name and parent name
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
    return NULL;
  source = new char[4096];
  bool nls_support = parser.CheckNLSSupport(); 
  // widget specifics
  if(parser.GetParam(obj_maxchars,buffer,PROP_MAXCHARS) &&
     strcmp(obj_maxchars,NIHIL_PROP))
    ;
  else
    strcpy(obj_maxchars,"0");
    //
  if(parser.GetParam(obj_text,buffer,PROP_TEXT) &&
     strcmp(obj_text,NIHIL_PROP))
    ;
  else
    *obj_text = '\0';
  if(*obj_text)
    {
      if(nls_support)
	sprintf(tmp,"\n%s = new %s(this,%s,_(\"%s\"));",
	    obj_name,
	    VDK_CLASS,
	    obj_maxchars,
	    obj_text);
      else
	sprintf(tmp,"\n%s = new %s(this,%s,\"%s\");",
	    obj_name,
	    VDK_CLASS,
	    obj_maxchars,
	    obj_text);
    }
  else
    sprintf(tmp,"\n%s = new %s(this,%s);",
	    obj_name,
	    VDK_CLASS,
	    obj_maxchars);
  strcpy(source,tmp);
  // call ancestor to set common properties
  char* props = VDKBObject::CreateSource(buffer,parser,obj_name);
  if(props)
    {
      strcat(source,props);
      delete[] props;
    }
  //
  if(parser.GetParam(obj_editable,buffer,PROP_EDITABLE) &&
     strcmp(obj_editable,NIHIL_PROP))
    {
      sprintf(tmp,"\n%s->%s = %s;",
	      obj_name,EDITABLE,obj_editable);
      strcat(source,tmp);
    }

  // get label button  props
  if(parser.GetParam(arg,buffer,PROP_HIDDEN) &&
     strcmp(arg,NIHIL_PROP))
   {
     sprintf(tmp,"\n%s->%s = %s;",obj_name,HIDDEN,arg);
     strcat(source,tmp);
   }
// get code that adds widget to container
  parser.WriteCodeToPack(obj_parent,obj_name,source,buffer,tmp);
  /*
    visible property must be wrote after adding it to a parent
    container. That's the reason why is written here and not
    in vdkb_object class as should be. Written only if == false
  */
  parser.WriteVisible( obj_name, arg, source,buffer,  tmp);
  return source;
}

/*
Invoked by VDKBGuiForm::MakeGuiObjects() during gui creation
reading .frm file.
MakeGuiObjects() scans .frm file and call a global CreateWidget()
that scans a table that maps class names with
each static CreateWidget() in widget class.
*/
bool
CLASS::CreateWidget(VDKBGuiForm* owner,
			      char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  char arg[256];
  char obj_text[256];
  CLASS* text;
  // get widget name and parent
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return false;
  if(parser.GetParam(obj_text,buffer,PROP_TEXT) &&
     strcmp(obj_text,NIHIL_PROP))
      ;
  else
      *obj_text = '\0';
  VDKObject* p = owner->ChildWithName(obj_parent);
  VDKBEventContainer* container = p ?
    dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
  if(container)
    {
      text = new CLASS(obj_name,owner, *obj_text ? obj_text : NULL);
      if(parser.GetParam(arg,buffer,PROP_EDITABLE) && strcmp(arg,NIHIL_PROP))
	text->SetPropValue(EDITABLE,arg);
      if(parser.GetParam(arg,buffer,PROP_HIDDEN) && strcmp(arg,NIHIL_PROP))
	text->SetPropValue(HIDDEN,arg);
      if(parser.GetParam(arg,buffer,PROP_MAXCHARS) && strcmp(arg,NIHIL_PROP))
	text->SetPropValue(MAXCHARS,arg);
      if(parser.GetParam(arg,buffer,PROP_TEXT) && strcmp(arg,NIHIL_PROP))
	text->SetPropValue(TEXT,arg);
      // pack widget to container
      return owner->PackToSelf(text, container, buffer, parser);
    }
  else
    return false;
return true;
}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
/*
 */
/*
 */
VDKObjectContainer*
CLASS::ExtraWidget(VDKBObjectInspector* isp)
{
  VDKString True = CHECK_TRUE;
  inspector = isp;
  VDKFrame* bframe = new VDKFrame(inspector,NULL,v_box,shadow_etched_in);
  VDKTable *table = new VDKTable(inspector,3,2);
  // table->SetSize(219,-1);

  hidden = new VDKCheckButton(inspector,_(wi_widget_prompts[16]));
  table->AddToCell(hidden,0,0);
  hidden->Checked = GetProp(HIDDEN) == True;
  // this after (so no signal hang)
  hidden->Parent(this);
  SignalConnect(hidden,"toggled",&CLASS::OnSetHidden);

  editable = new VDKCheckButton(inspector,_(wi_widget_prompts[2]));
  table->AddToCell(editable,0,1);
  editable->Checked = GetProp(EDITABLE) == True;
  // this after (so no signal hang)
  editable->Parent(this);
  SignalConnect(editable,"toggled",&CLASS::OnSetEditable);

  table->AddToCell(new VDKLabel(inspector,_(wi_widget_prompts[17])),1,0);
  text = new VDKEntry(inspector,0,GetProp("Text"));
  text->SetSize(100,-1);
  table->AddToCell(text,1,1);
  text->Parent(this);
  SignalConnect(text,"activate",&CLASS::OnSetEntryText);

  table->AddToCell(new VDKLabel(inspector,_(wi_widget_prompts[18])),2,0);
  int mc = atoi(GetProp(MAXCHARS));
  maxchars = new VDKSpinButton(inspector,mc , 0, 255 , 1 ,0 );
  maxchars->SetSize(100,-1);
  table->AddToCell(maxchars,2,1);
  maxchars->Parent(this);
  // note last arg as <false>
  // is necessary since gtk+ "value_changed"
  // isn't treated by gtk+
  SignalConnect(maxchars,"value_changed",&CLASS::OnSetMaxChars,false);
  bframe->Add(table,l_justify,false,false,false);
  return bframe;
}
//////////////////////////////////////////////////////
// These response methods actually change both
// properties on widget and gui widget properties
//////////////////////////////////////////////////////
/*
 */
bool
CLASS::OnSetHidden(VDKObject*)
{
  SetPropValue(HIDDEN, hidden->Checked ? CHECK_TRUE : CHECK_FALSE);
  Hidden = hidden->Checked ? true : false;
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetEditable(VDKObject*)
{
  SetPropValue(EDITABLE, editable->Checked ? CHECK_TRUE : CHECK_FALSE);
  Editable = editable->Checked ? true : false;
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetEntryText(VDKObject*)
{
    sprintf(buff,"%s",
	    strlen(text->Text) > 0 ? 
	    (char*) text->Text:
	    NIHIL_PROP
	    );
    SetPropValue(TEXT,buff);
    Text = buff;
    inspector->FormNeedToBeChanged();
    return true;
}
/*
 */
bool
CLASS::OnSetMaxChars(VDKObject*)
{
  sprintf(buff,"%d",(int) maxchars->ValueAsInt);
  SetPropValue(MAXCHARS,buff);
  inspector->FormNeedToBeChanged();
  return true;
}









