### 0.14.1 (2024-09-16)

Features:

* Supported LLVM 17.0.6.
* Bumpped `spdlog` to `v1.13.0`.
* Bumpped `fmt` to `11.0.2`.
* Bumpped `simdjson` to `v3.10.0`.
* Bumpped `googletest` to `1.15.2`.
* [WASI-NN] ggml backend:
  * Bump llama.cpp to b3651.
  * Static link `libggml` and `libllama`.
  * Refined the CMake to support multiple backends of WASI-NN with ggml backend.
  * Supported compute single in RPC mode.
* [WASI-NN] Added support for whisper.cpp backend.
* [WASI-NN] Added support for piper backend.
* [WASI-NN] Added support for ChatTTS backend.
* [WASI-NN] Added support for Burn.rs backend.
  * Supported `squeezenet` and `whisper` models.
* [Plugin] Supported `wasmedge_stablediffusion` plug-in.
  * Enabled CUBLAS.
  * Enabled metal support on MacOS.
* [Plugin] Moved `wasi_logging` into built-in plug-in.
  * Instead of installing `wasi_logging` plug-in shared library, developers can find and get this plug-in after calling `WasmEdge_PluginLoadWithDefaultPaths()` API.
  * In the WasmEdge CLI tools, the built-in plug-ins will automatically be loaded.
* [Proposal] Initial support for instantiation phase of component model.
  * Due to the breaking change of API, bump the plug-in `API_VERSION` to `3`.
* [Proposal] Supported WASM Relaxed-SIMD proposal.
  * Added the `WasmEdge_Proposal_RelaxSIMD` for the configuration in WasmEdge C API.
  * Users can use the `--enable-relaxed-simd` to enable the proposal in `wasmedge` and `wasmedgec` tools.

Fixed issues:

* Fixed warnings on GCC-14.
* Fixed the `fmt` related header inclusion for error logging.
* Fixed WASI test error in Windows.
* Fixed version checking in source tarball.
* Fixed version detection issue when building from source.
* Fixed the visibility of internal symbols.
* [Loader] Fixed alignment checking in loading immediates for memory instructions.
* [Runtime] Fixed allocation issue when configured the limited memory page size.
* Used `fmt::format` instead of string stream in error logging.

Tests:

* Added WASI test suites on Windows.

Known issues:

* Universal WASM format failed on macOS platforms.
  * In the current status, the universal WASM format output of the AOT compiler with the `O1` or upper optimizations on MacOS platforms will cause a bus error during execution.
  * We are trying to fix this issue. For a working around, please use the `--optimize=0` to set the compiler optimization level to `O0` in `wasmedgec` CLI.

Thank all the contributors who made this release possible!

Biswapriyo Nath, Elmira, Faidon Liambotis, Fusaaaann, Han-Wen Tsao, Jun Zhang, Kefu Chai, Lîm Tsú-thuàn, Michael Morris, PeterD1524, Shen-Ta Hsieh, Shreyas Atre, Sylveon, Yi Huang, Yi-Ying He, alabulei1, dm4, grorge, hydai, junxiangMu, vincent

If you want to build from source, please use WasmEdge-0.14.1-src.tar.gz instead of the zip or tarball provided by GitHub directly.
