/*
 * Decompiled with CFR 0.152.
 */
package fr.ove.openmath.jome.ctrlview.bidim.images;

import fr.ove.openmath.jome.ctrlview.bidim.images.ImagesResourcesManager;
import fr.ove.utils.ByteVector;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Hashtable;

public class ImageLoader
implements Serializable {
    private static Hashtable allImages;
    private static MediaTracker tracker;
    private static Toolkit toolkit;
    private static Class theClass;
    private static ImagesResourcesManager imagesResourcesManager;

    public ImageLoader(Component component) {
        theClass = this.getClass();
        tracker = new MediaTracker(component);
        allImages = new Hashtable(10);
        toolkit = Toolkit.getDefaultToolkit();
        ImageLoader.getImage("LeftTopPar");
        ImageLoader.getImage("LeftMiddlePar");
        ImageLoader.getImage("LeftBottomPar");
        ImageLoader.getImage("RightTopPar");
        ImageLoader.getImage("RightMiddlePar");
        ImageLoader.getImage("RightBottomPar");
    }

    public static Image getImage(String string) {
        Image image = (Image)allImages.get(string);
        if (image == null) {
            image = ImageLoader.setImage(string);
        }
        return image;
    }

    public static float getHeightFactor(String string) {
        float f = 1.0f;
        try {
            String string2 = imagesResourcesManager.getHeightFactor(string);
            if (string2 != null) {
                f = Float.valueOf(string2).floatValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("height factor is not a valid number.");
        }
        catch (Exception exception) {
            System.out.println("height factor is not a valid number.");
        }
        return f;
    }

    public static float getBaseline(String string) {
        float f = -1.0f;
        try {
            String string2 = imagesResourcesManager.getBaseline(string);
            if (string2 != null) {
                f = Float.valueOf(string2).floatValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("baseline has not a valid number.");
        }
        catch (Exception exception) {
            System.out.println("baseline has not a valid number.");
        }
        return f;
    }

    public static float getTopInset(String string) {
        float f = 0.0f;
        try {
            String string2 = imagesResourcesManager.getTopInset(string);
            if (string2 != null) {
                f = Float.valueOf(string2).floatValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("top inset has not a valid number.");
        }
        catch (Exception exception) {
            System.out.println("top inset has not a valid number.");
        }
        return f;
    }

    public static float getBottomInset(String string) {
        float f = 0.0f;
        try {
            String string2 = imagesResourcesManager.getBottomInset(string);
            if (string2 != null) {
                f = Float.valueOf(string2).floatValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("bottom inset has not a valid number.");
        }
        catch (Exception exception) {
            System.out.println("bottom inset has not a valid number.");
        }
        return f;
    }

    public static float getLeftInset(String string) {
        float f = 0.0f;
        try {
            String string2 = imagesResourcesManager.getLeftInset(string);
            if (string2 != null) {
                f = Float.valueOf(string2).floatValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("left inset has not a valid number.");
        }
        catch (Exception exception) {
            System.out.println("left inset has not a valid number.");
        }
        return f;
    }

    public static float getRightInset(String string) {
        float f = 0.0f;
        try {
            String string2 = imagesResourcesManager.getRightInset(string);
            if (string2 != null) {
                f = Float.valueOf(string2).floatValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("right inset has not a valid number.");
        }
        catch (Exception exception) {
            System.out.println("right inset has not a valid number.");
        }
        return f;
    }

    public static boolean exists(String string) {
        return imagesResourcesManager.getImageName(string) == null;
    }

    private static Image loadImage(String string, String string2) throws Exception {
        Image image = null;
        InputStream inputStream = theClass.getResourceAsStream(string);
        try {
            int n;
            ByteVector byteVector = new ByteVector();
            while ((n = inputStream.read()) != -1) {
                byteVector.addElement((byte)n);
                if (inputStream.available() != 0) continue;
            }
            image = toolkit.createImage(byteVector.getBytes());
            inputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Impossible to read image : IO problems");
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("Impossible to create image");
            exception.printStackTrace();
        }
        if (image != null) {
            allImages.put(string2, image);
            tracker.addImage(image, 0);
            try {
                tracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                System.out.print(interruptedException.toString());
            }
            if (tracker.isErrorAny()) {
                throw new Exception("Impossible to load image");
            }
        }
        return image;
    }

    private static Image setImage(String string) {
        Image image = null;
        try {
            String string2 = imagesResourcesManager.getImageName(string);
            image = string2 == null ? ImageLoader.getImage("undef") : ImageLoader.loadImage(string2, string);
            return image;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return image;
        }
    }

    static {
        imagesResourcesManager = new ImagesResourcesManager("fr.ove.openmath.jome.ctrlview.bidim.images.ImagesResources");
    }
}

