/*
 * We don't use input, so don't generate code for it.
 */
%option noinput

/*
 * We don't use unput, so don't generate code for it.
 */
%option nounput

/*
 * We don't read from the terminal.
 */
%option never-interactive

/*
 * Prefix scanner routines with "uat_load_" rather than "yy", so this scanner
 * can coexist with other scanners.
 */
%option prefix="uat_load_"

%{
	/*
	 * uat_load.l
	 *
	 * $Id$
	 *
	 *  User Accessible Tables
	 *  Mantain an array of user accessible data strucures
	 *  One parser to fit them all
	 *
	 * (c) 2007, Luis E. Garcia Ontanon <luis@ontanon.org>
	 *
	 * Wireshark - Network traffic analyzer
	 * By Gerald Combs <gerald@wireshark.org>
	 * Copyright 2001 Gerald Combs
	 *
	 * This program is free software; you can redistribute it and/or
	 * modify it under the terms of the GNU General Public License
	 * as published by the Free Software Foundation; either version 2
	 * of the License, or (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program; if not, write to the Free Software
	 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	 */
#include "config.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>

#include <glib.h>

#include <epan/emem.h>
#include "uat-int.h"
#include "uat_load_lex.h"
#include <wsutil/file_util.h>

#ifdef _WIN32
/* disable Windows VC compiler warning "signed/unsigned mismatch" associated  */
/* with YY_INPUT code generated by flex versions such as 2.5.35.              */
#pragma warning (disable:4018)
#endif

static uat_t* uat;
static gboolean valid_record;
static guint colnum;
static gchar* ptrx;
static guint len;
static gchar* error;
static void* record;
static guint linenum;
static gchar *parse_str;
static guint parse_str_pos;

#define ERROR(fmtd) do { error = ep_strdup_printf("%s:%d: %s",uat->filename,linenum,ep_strdup_printf fmtd); yyterminate(); } while(0)

#define SET_FIELD() \
	{ const gchar* errx; \
	if (uat->fields[colnum].cb.chk) { \
		if ( ! uat->fields[colnum].cb.chk(record, ptrx, len, uat->fields[colnum].cbdata.chk, uat->fields[colnum].fld_data, &errx) ) { \
			error = ep_strdup_printf("%s:%d: %s",uat->filename,linenum,ep_strdup_printf("%s",errx)); \
			valid_record = FALSE; \
		}\
	}\
	uat->fields[colnum].cb.set(record, ptrx, len, uat->fields[colnum].cbdata.chk, uat->fields[colnum].fld_data);\
	g_free(ptrx);\
	colnum++; \
	} while(0)

#ifdef DEBUG_UAT_LOAD
#define DUMP_FIELD(str) \
		{ guint i; printf("%s: %s='",str,uat->fields[colnum].name); for(i=0;i<len;i++) if (uat->fields[colnum].mode == PT_TXTMOD_HEXBYTES) { printf("%.2x ",((guint8*)ptrx)[i]); } else putc(ptrx[i],stdout); printf("'[%d]\n",len); }

#define DUMP(str) printf("%s\n",str)
#else
#define DUMP_FIELD(s)
#define DUMP(s)
#endif

/* Modified version of YY_INPUT generated by Flex 2.91 */
#define YY_INPUT(buf,result,max_size) \
	if ( parse_str ) \
		{ \
		int n = 0; \
		guint pslen = strlen(parse_str); \
		if (parse_str_pos < pslen) \
			{ \
			n = pslen - parse_str_pos; \
			if (n > max_size) n = max_size; \
			memcpy(buf, parse_str + parse_str_pos, n); \
			parse_str_pos += n; \
			} \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}

		/*
		 * XXX
		 * quoted_string below fails badly on "...\\"
		 * workarround in uat_save(), using /x5c and /x22
		 */
%}

quoted_string \042([^\042]|\134\042)*\042
binstring ([0-9a-zA-Z][0-9a-zA-Z])*
separator [ \t]*,
newline [ \t]*[\r]?\n
ws [ \t]+
comment #[^\n]*\n

%x START_OF_LINE NEXT_FIELD SEPARATOR END_OF_RECORD ERRORED
%%
<START_OF_LINE,NEXT_FIELD>{ws} ;
<START_OF_LINE>{newline} linenum++;
<START_OF_LINE>{comment} linenum++;

<START_OF_LINE,NEXT_FIELD>{separator} {
	ptrx = g_strdup("");
	len = 0;

	DUMP_FIELD("empty->next");

	SET_FIELD();

	if ( colnum >= uat->ncols ) {
		ERROR(("more fields than required"));
	}

	BEGIN NEXT_FIELD;
}

<START_OF_LINE,NEXT_FIELD>{newline}   {
	ptrx = g_strdup("");
	len = 0;

	BEGIN END_OF_RECORD;

	yyless(yyleng);
}

<START_OF_LINE,NEXT_FIELD>{quoted_string} {
	ptrx = uat_undquote(yytext,yyleng,&len);


	if (colnum < uat->ncols - 1) {
		DUMP("quoted_str->s");
		BEGIN SEPARATOR;
	} else {
		DUMP("quoted_str->eor");
		BEGIN END_OF_RECORD;
	}
}

<START_OF_LINE,NEXT_FIELD>{binstring} {
	ptrx = uat_unbinstring(yytext,yyleng,&len);

	if (!ptrx) {
		ERROR(("uneven hexstring for field %s",uat->fields[colnum].name));
	}

	if ( colnum < uat->ncols - 1 ) {
		DUMP("binstring->s");
		BEGIN SEPARATOR;
	} else {
		DUMP("binstring->eor");
		BEGIN END_OF_RECORD;
	}
}

<SEPARATOR>{separator} {

	DUMP_FIELD("separator->next");

	SET_FIELD();

	if ( colnum >= uat->ncols ) {
		ERROR(("more fields than required"));
	}

	BEGIN NEXT_FIELD;
}

<SEPARATOR>{newline} {
	linenum++;
	ERROR(("expecting field %s in previous line",uat->fields[colnum].name));
}

<SEPARATOR>. {
	ERROR(("unexpected char '%s' while looking for field %s",yytext,uat->fields[colnum].name));
}

<END_OF_RECORD>{separator} {
	ERROR(("more fields than required"));
}

<END_OF_RECORD>{newline} {
	void* rec;
	const gchar* err = NULL;

	linenum++;

	DUMP_FIELD("newline->start");

	SET_FIELD();

	rec = uat_add_record(uat, record, valid_record);

	if ((uat->update_cb) && (rec != NULL))
		uat->update_cb(rec,&err);

	if (err) {
		ERROR(("%s",err));
	}

	valid_record = TRUE;
	colnum = 0;
	ptrx = NULL;
	len = 0;

	/* XXX is this necessary since we free it before reusing anyway? */
	memset(record,0,uat->record_size);

	BEGIN START_OF_LINE;
 }

<END_OF_RECORD>. {
	ERROR(("unexpected char while looking for end of line"));
}

<ERRORED>{newline} { linenum++; BEGIN START_OF_LINE; }
<ERRORED>. ;

{newline} { linenum++; ERROR(("incomplete record")); BEGIN START_OF_LINE; }
. { ERROR(("unexpected input")); }

%%




gboolean
uat_load(uat_t *uat_in, const char **errx)
{
	gchar *fname = uat_get_actual_filename(uat_in, FALSE);

	uat = uat_in;
	parse_str = NULL;

	if (!fname) {
		UAT_UPDATE(uat);

		if (uat->post_update_cb)
			uat->post_update_cb();

		return TRUE;
	}


	if (!(yyin = ws_fopen(fname,"r"))) {
		*errx = g_strerror(errno);
		g_free(fname);
		return FALSE;
	}

	error = NULL;
	valid_record = TRUE;
	colnum = 0;
	g_free(record);
	record = g_malloc0(uat->record_size);
	linenum = 1;

	BEGIN START_OF_LINE;
	DUMP(fname);
	g_free(fname);	/* we're done with the file name now */

	yylex();
	fclose(yyin);
	yyrestart(NULL);

	uat->changed = FALSE;
	uat->loaded = TRUE;
	UAT_UPDATE(uat);

	if (error) {
		*errx = ep_strdup(error);
		return FALSE;
	}

	if (uat->post_update_cb)
		uat->post_update_cb();

	*errx = NULL;
	return TRUE;
}

gboolean
uat_load_str(uat_t *uat_in, char *entry, char **err)
{
	uat = uat_in;
	parse_str = g_strdup_printf("%s\n", entry); /* Records must end with a newline */
	parse_str_pos = 0;
	yyin = NULL;

	error = NULL;
	valid_record = TRUE;
	colnum = 0;
	g_free(record);
	record = g_malloc0(uat->record_size);
	linenum = 1;

	BEGIN START_OF_LINE;
	DUMP(entry);

	yylex();
	yyrestart(NULL);
	g_free(parse_str);
	parse_str = NULL;

	uat->changed = TRUE;
	uat->loaded = TRUE;
	UAT_UPDATE(uat);

	if (error) {
		*err = ep_strdup(error);
		return FALSE;
	}

	if (uat->post_update_cb)
		uat->post_update_cb();

	*err = NULL;
	return TRUE;
}

/*
 * We want to stop processing when we get to the end of the input.
 * (%option noyywrap is not used because if used then
 * some flex versions (eg: 2.5.35) generate code which causes
 * warnings by the Windows VC compiler).
 */

int
yywrap(void)
{
    return 1;
}
