/* msm-blits.h
 *
 * Copyright (c) 2009, Code Aurora Forum. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Code Aurora nor
 *       the names of its contributors may be used to endorse or promote
 *       products derived from this software without specific prior written
 *       permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NON-INFRINGEMENT ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _MSM_BLITS_H_
#define _MSM_BLITS_H_

/* Interface to MSM driver. */
#include "xf86.h"
#include "msm.h"

/* Use this include to get access to integer definitions for specific integral data types optimized for speed or size. */
#include <stdint.h>
#include <stdlib.h>

/* Neon intrinsics are part of the ARM or GCC compiler used.                                                              */
/* Tested with: /pkg/asw/compilers/gnu/codesourcery/arm-2008q3-72/lib/gcc/arm-none-linux-gnueabi/4.3.2/include/arm_neon.h */
#include <arm_neon.h>

/* These are NEON-optimized functions linked to by various tests.  */
extern void * neon_memcpy (void * dest, const void * source, unsigned int numBytes);
extern void * neon_memmove (void * dest, const void * source, unsigned int numBytes);
extern void memset16(uint16_t *dst, uint16_t value, int count);
extern void memset32(uint32_t *dst, uint32_t value, int count);

/* Make definitions to clarify memory-related sizes to enable avoidance of magic numbers. */
#define BITS_PER_BYTE (8)
#define BYTES_PER_16BPP_PIXEL (2)
#define BYTES_PER_24BPP_PIXEL (3)
#define BYTES_PER_32BPP_PIXEL (4)
#define BYTES_PER_UINT16X8_T (16)
#define BYTES_PER_UINT32X4_T (16)
#define BYTES_PER_UINT64_T (8)
#define BYTES_PER_UINT32_T (4)
#define BYTES_PER_UINT16_T (2)
#define BYTES_PER_UINT8_T  (1)
#define BYTE_ALIGNMENT_BYTE_SIZE        (1)
#define HALF_WORD_ALIGNMENT_BYTE_SIZE   (2)
#define WORD_ALIGNMENT_BYTE_SIZE        (4)
#define DOUBLE_WORD_ALIGNMENT_BYTE_SIZE (8)
#define QUAD_WORD_ALIGNMENT_BYTE_SIZE  (16)

/* Function declarations from msm-swaligned.c. */
void swCopy1ByteWideRectangle_UnAligned(uint8_t *dst, uint8_t *src, int h, int dpitch, int spitch);
void swCopy2ByteWideRectangle_HalfWordAligned(uint8_t *dst, uint8_t *src, int h, int dpitch, int spitch);
void swCopy4ByteWideRectangle_WordAligned(uint8_t *dst, uint8_t *src, int h, int dpitch, int spitch);
void swCopy8ByteWideRectangle_DoubleWordAligned(uint8_t *dst, uint8_t *src, int h, int dpitch, int spitch);
void swFill1ByteWideRectangle_UnAligned(uint8_t *dst, uint8_t src, int h, int dpitch);
void swFill2ByteWideRectangle_HalfWordAligned(uint8_t *dst, uint16_t src, int h, int dpitch);
void swFill4ByteWideRectangle_WordAligned(uint8_t *dst, uint32_t src, int h, int dpitch);

// Should only be needed for working around a kernel issue that fails to save/restore Neon registers for userspace signal handlers.
#define MASK_SIGNALS (TRUE)
#if (MASK_SIGNALS)
#include "signal.h"  // Needed only for masking signals.
#endif // (MASK_SIGNALS)


/* USAGE NOTES FOR SIGNAL BLOCKING MACROS:                                                     */
/* (1) The block and unblock macros must surround all Neon/FP code                             */
/*     and need to be called from the same scope because the macros share state (oldMaskSet).  */
/* (2) Blocking signals stops the mouse cursor from being updated, so don't                    */
/*     bracket sections of code that take a noticeable amount of time to execute.              */

/* Block signals from being handled before any operations that use VFP/Neon registers. */
#if (MASK_SIGNALS)
#define BLOCK_SIGNALS_BEFORE_VFP_OPERATIONS() \
   /* This is temporary code to disable signals that are corrupting Neon registers because of a kernel issue.        */ \
   /* The kernel issue causes Neon/VFP registers to not be saved or restored correctly in userspace signal handlers. */ \
   sigset_t oldMaskSet; \
   if (blockSignalsForVFP) { \
      sigset_t allSignalsMaskSet; \
      sigfillset(&allSignalsMaskSet); \
      sigprocmask(SIG_BLOCK, &allSignalsMaskSet, &oldMaskSet); \
   }
#else
#define BLOCK_SIGNALS_BEFORE_VFP_OPERATIONS()
#endif // (MASK_SIGNALS)

/* Unblock signals from being handled after any operations that use VFP/Neon registers. */
#if (MASK_SIGNALS)
#define UNBLOCK_SIGNALS_AFTER_VFP_OPERATIONS() \
   if (blockSignalsForVFP) { \
      /* Re-enable signals that are corrupting Neon registers. */ \
      sigprocmask(SIG_SETMASK, &oldMaskSet, NULL); \
   }
#else
#define UNBLOCK_SIGNALS_AFTER_VFP_OPERATIONS()
#endif // (MASK_SIGNALS)

/* Do no signal blocking. */
#define SIGNAL_BLOCK_NOOP()


#endif // _MSM_BLITS_H_


