
# Big-IP SNMP

## Overview

For Zabbix version: 5.0 and higher  
https://www.f5.com/products/big-ip-services

## Setup

> See [Zabbix template operation](https://www.zabbix.com/documentation/5.0/manual/config/templates_out_of_the_box/network_devices) for basic instructions.

Refer to the vendor documentation.

## Zabbix configuration

No specific Zabbix configuration is required.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$BIGIP.CERT.MIN} |<p>Minimum number of days before certificate expiration.</p> |`7` |
|{$BIGIP.CPU.UTIL.WARN.MAX} |<p>The warning threshold of the CPU utilization in %.</p> |`85` |
|{$BIGIP.CPU.UTIL.WARN.MIN} |<p>The recovery threshold of the CPU utilization in %.</p> |`65` |
|{$BIGIP.FS.FREE.WARN.MAX} |<p>The recovery threshold of the file system utilization in %.</p> |`20` |
|{$BIGIP.FS.FREE.WARN.MIN} |<p>The warning threshold of the file system utilization in %.</p> |`10` |
|{$BIGIP.LLD.FILTER.PART.NAME.MATCHES} |<p>Filter of discoverable mount point names.</p> |`.*` |
|{$BIGIP.LLD.FILTER.PART.NAME.NOT_MATCHES} |<p>Filter to exclude discovered by mount point names.</p> |`CHANGE_IF_NEEDED` |
|{$BIGIP.MEMORY.UTIL.WARN.MAX} |<p>The warning threshold of the memory utilization in %.</p> |`85` |
|{$BIGIP.MEMORY.UTIL.WARN.MIN} |<p>The recovery threshold of the memory utilization in %.</p> |`65` |
|{$BIGIP.SWAP.UTIL.WARN.MAX} |<p>The warning threshold of the swap utilization in %.</p> |`85` |
|{$BIGIP.SWAP.UTIL.WARN.MIN} |<p>The recovery threshold of the swap utilization in %.</p> |`65` |
|{$SNMP.TIMEOUT} |<p>The time interval for SNMP agent availability trigger expression.</p> |`5m` |

## Template links

There are no template links in this template.

## Discovery rules

|Name|Description|Type|Key and additional info|
|----|-----------|----|----|
|File system discovery |<p>A table containing entries of system disk usage information.</p> |SNMP |bigip.disktable.discovery<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p><p>**Filter**:</p>AND <p>- A: {#PART.NAME} MATCHES_REGEX `{$BIGIP.LLD.FILTER.PART.NAME.MATCHES}`</p><p>- B: {#PART.NAME} NOT_MATCHES_REGEX `{$BIGIP.LLD.FILTER.PART.NAME.NOT_MATCHES}`</p> |
|Memory discovery |<p>Containing system statistics information of the memory usage</p> |SNMP |bigip.memory.discovery<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|CPU discovery |<p>A table containing entries of system CPU usage information for a system.</p> |SNMP |bigip.cpu.discovery<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network interface discovery |<p>A table containing statistic information of the interfaces on the device.</p> |SNMP |bigip.net.discovery<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Chassis fan discovery |<p>A table containing information of chassis fan status of the system</p> |SNMP |bigip.chassis.fan.discovery<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Chassis power supply discovery |<p>A table containing information of chassis power supply status of the system.</p> |SNMP |bigip.chassis.power.discovery<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Chassis temperature discovery |<p>A table containing information of chassis temperature of the system</p> |SNMP |bigip.chassis.temp.discovery<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Blade temperature discovery |<p>Containing information of blade temperature of the system</p> |SNMP |bigip.blade.temp.discovery<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Blade voltage discovery |<p>A table containing information of blade voltage of the system.</p> |SNMP |bigip.blade.voltage.discovery<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|CPU sensor discovery |<p>A table containing information of CPU sensor status on the system.</p> |SNMP |bigip.cpu.sensor.discovery<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Module discovery |<p>Resource allocation information about modules on the system</p> |SNMP |bigip.module.discovery<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Certificate discovery |<p>A table containing certificate configuration.</p> |SNMP |bigip.cert.discovery<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Virtual server discovery |<p>A table containing information of virtual servers.</p> |SNMP |bigip.virtual_server.discovery<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Node discovery |<p>A table containing statistic information of node addresses.</p> |SNMP |bigip.node.discovery<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Pool discovery |<p>A table containing statistic information of pools.</p> |SNMP |bigip.pool.discovery<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |

## Items collected

|Group|Name|Description|Type|Key and additional info|
|-----|----|-----------|----|---------------------|
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: User, avg 5s |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor in user context for the associated host in the last five seconds.</p> |SNMP |bigip.cpu.user.5s[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: Nice, avg 5s |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor running niced processes for the associated host in the last five seconds.</p> |SNMP |bigip.cpu.nice.5s[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: System, avg 5s |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor servicing system calls for the associated host in the last five seconds.</p> |SNMP |bigip.cpu.system.5s[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: Idle, avg 5s |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor doing nothing for the associated host in the last five seconds.</p> |SNMP |bigip.cpu.idle.5s[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: IRQ, avg 5s |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor servicing hardware interrupts for the associated host in the last five seconds.</p> |SNMP |bigip.cpu.irq.5s[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: Soft IRQ, avg 5s |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor servicing soft interrupts for the associated host in the last five seconds.</p> |SNMP |bigip.cpu.spftirq.5s[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: IO wait, avg 5s |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor waiting for external I/O to complete for the associated host in the last five seconds.</p> |SNMP |bigip.cpu.iowait.5s[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: Usage ratio, avg 5s |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>This is  average usage ratio of CPU for the associated host in the last five seconds. It is calculated by</p><p>(sum of deltas for user, niced, system)/(sum of deltas of user, niced, system, idle, irq, softirq, and iowait),</p><p>where each delta is the difference for each stat over the last 5-second interval;</p><p>user:sysMultiHostCpuUser5s;</p><p>niced:sysMultiHostCpuNiced5s;</p><p>stolen:sysMultiHostCpuStolen5s;</p><p>system:sysMultiHostCpuSystem5s;</p><p>idle:sysMultiHostCpuIdle5s;</p><p>irq:sysMultiHostCpuIrq5s;</p><p>iowait:sysMultiHostCpuIowait5s</p> |SNMP |bigip.cpu.usageratio.5s[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: User, avg 1m |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor in user context for the associated host in the last one minute.</p> |SNMP |bigip.cpu.user.1m[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: Nice, avg 1m |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor running niced processes for the associated host in the last one minute.</p> |SNMP |bigip.cpu.nice.1m[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: System, avg 1m |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor servicing system calls for the associated host in the last one minute.</p> |SNMP |bigip.cpu.system.1m[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: Idle, avg 1m |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor doing nothing for the associated host in the last one minute.</p> |SNMP |bigip.cpu.idle.1m[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: IRQ, avg 1m |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor servicing hardware interrupts for the associated host in the last one minute.</p> |SNMP |bigip.cpu.irq.1m[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: Soft IRQ, avg 1m |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor servicing soft interrupts for the associated host in the last one minute.</p> |SNMP |bigip.cpu.spftirq.1m[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: IO wait, avg 1m |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor waiting for external I/O to complete for the associated host in the last one minute.</p> |SNMP |bigip.cpu.iowait.1m[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: Usage ratio, avg 1m |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>This is  average usage ratio of CPU for the associated host in the last one minute. It is calculated by</p><p>(sum of deltas for user, niced, system)/(sum of deltas of user, niced, system, idle, irq, softirq, and iowait),</p><p>where each delta is the difference for each stat over the last 5-second interval;</p><p>user:sysMultiHostCpuUser1m;</p><p>niced:sysMultiHostCpuNiced1m;</p><p>stolen:sysMultiHostCpuStolen1m;</p><p>system:sysMultiHostCpuSystem1m;</p><p>idle:sysMultiHostCpuIdle1m;</p><p>irq:sysMultiHostCpuIrq1m;</p><p>iowait:sysMultiHostCpuIowait1m</p> |SNMP |bigip.cpu.usageratio.1m[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: User, avg 5m |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor in user context for the associated host in the last five minutes.</p> |SNMP |bigip.cpu.user.5m[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: Nice, avg 5m |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor running niced processes for the associated host in the last five minutes.</p> |SNMP |bigip.cpu.nice.5m[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: System, avg 5m |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor servicing system calls for the associated host in the last five minutes.</p> |SNMP |bigip.cpu.system.5m[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: Idle, avg 5m |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor doing nothing for the associated host in the last five minutes.</p> |SNMP |bigip.cpu.idle.5m[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: IRQ, avg 5m |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor servicing hardware interrupts for the associated host in the last five minutes.</p> |SNMP |bigip.cpu.irq.5m[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: Soft IRQ, avg 5m |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor servicing soft interrupts for the associated host in the last five minutes.</p> |SNMP |bigip.cpu.spftirq.5m[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: IO wait, avg 5m |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time spent by the specified processor waiting for external I/O to complete for the associated host in the last five minutes.</p> |SNMP |bigip.cpu.iowait.5m[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: Usage ratio, avg 5m |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>This is  average usage ratio of CPU for the associated host in the last five minutes. It is calculated by</p><p>(sum of deltas for user, niced, system)/(sum of deltas of user, niced, system, idle, irq, softirq, and iowait),</p><p>where each delta is the difference for each stat over the last 5-second interval;</p><p>user:sysMultiHostCpuUser5m;</p><p>niced:sysMultiHostCpuNiced5m;</p><p>stolen:sysMultiHostCpuStolen5m;</p><p>system:sysMultiHostCpuSystem5m;</p><p>idle:sysMultiHostCpuIdle5m;</p><p>irq:sysMultiHostCpuIrq5m;</p><p>iowait:sysMultiHostCpuIowait5m</p> |SNMP |bigip.cpu.usageratio.5m[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: Stolen, avg 1s) |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time 'stolen' from the specified processor for the associated host in the last five seconds.</p> |SNMP |bigip.cpu.stolen.1s[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: Stolen, avg 1m |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time 'stolen' from the specified processor for the associated host in the last one minute.</p> |SNMP |bigip.cpu.stolen.1m[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Host [{#HOST.ID}] CPU{#CPU.ID}: Stolen, avg 5m |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The average time 'stolen' from the specified processor for the associated host in the last five minutes.</p> |SNMP |bigip.cpu.stolen.5m[{#HOST.ID},{#CPU.ID}] |
|CPU |F5 BIG-IP: Sensor [{#CPU.SENSOR.SLOT}:{#CPU.SENSOR.INDEX}]: Temperature |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>CPU: {#CPU.SENSOR.NAME}</p><p>The temperature of the indexed CPU on the system.</p><p>This is only supported for the platform where</p><p>the sensor data is available.</p> |SNMP |bigip.cpu.sensor.temperature[{#CPU.SENSOR.SLOT},{#CPU.SENSOR.INDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|CPU |F5 BIG-IP: Sensor [{#CPU.SENSOR.SLOT}:{#CPU.SENSOR.INDEX}]: FAN speed |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>CPU: {#CPU.SENSOR.NAME}</p><p>The fan speed (in RPM) of the indexed CPU on the system.,</p><p>This is only supported for the platform where</p><p>the sensor data is available.</p> |SNMP |bigip.cpu.sensor.fan[{#CPU.SENSOR.SLOT},{#CPU.SENSOR.INDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|CPU |F5 BIG-IP: Sensor [{#CPU.SENSOR.SLOT}:{#CPU.SENSOR.INDEX}]: Name |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>Identifier for the CPU.</p> |SNMP |bigip.cpu.sensor.name[{#CPU.SENSOR.SLOT},{#CPU.SENSOR.INDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Fans |F5 BIG-IP: FAN [{#FAN.INDEX}]: Status |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The status of the indexed chassis fan on the system.,</p><p>This is only supported for the platform where</p><p>the sensor data is available.</p><p>Possible values: 0 - bad, 1 - good, 2 - notpresent.</p> |SNMP |bigip.chassis.fan.status[{#FAN.INDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Fans |F5 BIG-IP: FAN [{#FAN.INDEX}]: Speed |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The actual speed of the indexed chassis fan on the system.</p><p>This is only supported for the platform where the actual</p><p>fan speed data is available.</p><p>'0' means fan speed is unavailable while the associated chassis status is good.</p> |SNMP |bigip.chassis.fan.speed[{#FAN.INDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Filesystems |F5 BIG-IP: Mount point [{#PART.NAME}]: Block size |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The number of bytes in the specified partition.</p> |SNMP |bigip.disktable.blocksize[{#PART.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Filesystems |F5 BIG-IP: Mount point [{#PART.NAME}]: Total blocks |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The number of total blocks in the specified partition.</p> |SNMP |bigip.disktable.totalblocks[{#PART.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Filesystems |F5 BIG-IP: Mount point [{#PART.NAME}]: Free blocks |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The number of free blocks in the specified partition.</p> |SNMP |bigip.disktable.freeblocks[{#PART.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Filesystems |F5 BIG-IP: Mount point [{#PART.NAME}]: Total nodes |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The number of total file nodes in the specified partition.</p> |SNMP |bigip.disktable.totalnodes[{#PART.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Filesystems |F5 BIG-IP: Mount point [{#PART.NAME}]: Free nodes |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The number of free file nodes in the specified partition.</p> |SNMP |bigip.disktable.freenodes[{#PART.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Inventory |F5 BIG-IP: Chassis serial number |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>Serial number</p> |SNMP |bigip.serialnumber<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Inventory |F5 BIG-IP: Hardware model name |<p>MIB: RFC1213-MIB</p><p>A textual description of the entity.  This value</p><p>should include the full name and version</p><p>identification of the system's hardware type,</p><p>software operating-system, and networking</p><p>software.  It is mandatory that this only contain</p><p>printable ASCII characters.</p> |SNMP |bigip.model<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Inventory |F5 BIG-IP: Contact |<p>MIB: RFC1213-MIB</p><p>The textual identification of the contact person</p><p>for this managed node, together with information</p><p>on how to contact this person.</p> |SNMP |bigip.contact<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Inventory |F5 BIG-IP: Host name |<p>MIB: RFC1213-MIB</p><p>An administratively-assigned name for this</p><p>managed node.  By convention, this is the node's</p><p>fully-qualified domain name.</p> |SNMP |bigip.name<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Inventory |F5 BIG-IP: Location |<p>MIB: RFC1213-MIB</p><p>The physical location of this node (e.g.,</p><p>`telephone closet, 3rd floor').</p> |SNMP |bigip.location<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Inventory |F5 BIG-IP: Product name |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The product name.</p> |SNMP |bigip.product.name<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Inventory |F5 BIG-IP: Product version |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The product version.</p> |SNMP |bigip.product.version<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Inventory |F5 BIG-IP: Product build |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The product build number.</p> |SNMP |bigip.product.build<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Inventory |F5 BIG-IP: Product edition |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The product edition.</p> |SNMP |bigip.product.edition<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Inventory |F5 BIG-IP: Product build date |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The product build date.</p> |SNMP |bigip.product.date<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Memory |F5 BIG-IP: Host [{#HOST.ID}]: Total memory |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The total host memory in bytes for the specified host.</p> |SNMP |bigip.memory.total[{#HOST.ID}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Memory |F5 BIG-IP: Host [{#HOST.ID}]: Used memory |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The host memory in bytes currently in use for the specified host.</p> |SNMP |bigip.memory.used[{#HOST.ID}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Memory |F5 BIG-IP: Host [{#HOST.ID}]: Total other non-TMM memory |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The total other non-TMM memory in bytes for the specified host.</p> |SNMP |bigip.memory.total.other[{#HOST.ID}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Memory |F5 BIG-IP: Host [{#HOST.ID}]: Used other non-TMM memory |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The other non-TMM memory in bytes currently in use for the specified host.</p> |SNMP |bigip.memory.used.other[{#HOST.ID}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Memory |F5 BIG-IP: Host [{#HOST.ID}]: Total swap |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The total swap in bytes for the specified host.</p> |SNMP |bigip.memory.total.swap[{#HOST.ID}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Memory |F5 BIG-IP: Host [{#HOST.ID}]: Used swap |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The swap in bytes currently in use for the specified host.</p> |SNMP |bigip.memory.used.swap[{#HOST.ID}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Modules |F5 BIG-IP: Module [{#MODULE.NAME}]: Provision level |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The provisioning level indicates how the systems resources</p><p>are distributed amongst the modules</p><p>Possible values: 1 - none, 2 - minimum, 3 - nominal, 4 - dedicated, 5 - custom.</p> |SNMP |bigip.module.provision.level[{#MODULE.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Modules |F5 BIG-IP: Module [{#MODULE.NAME}]: Memory ratio |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The ratio of available memory to allocate. Only valid if level is 'custom'</p> |SNMP |bigip.module.memory.ratio[{#MODULE.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Modules |F5 BIG-IP: Module [{#MODULE.NAME}]: CPU ratio |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The ratio of CPU to allocate to this module. Only valid if level is 'custom'</p> |SNMP |bigip.module.cpu.ratio[{#MODULE.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Modules |F5 BIG-IP: Module [{#MODULE.NAME}]: Disk ratio |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The ratio of available disk space to allocate to this module. Only valid if level is 'custom'</p> |SNMP |bigip.module.disk.ratio[{#MODULE.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Interface [{#IF.NAME}]: Incoming packet, rate |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The rate of packets received on this interface.</p> |SNMP |bigip.net.in.pkts.rate[{#IF.NAME}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Interface [{#IF.NAME}]: Incoming traffic, rate |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The rate of bytes received on this interface.</p> |SNMP |bigip.net.in.bytes.rate[{#IF.NAME}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Interface [{#IF.NAME}]: Outgoing packet, rate |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The rate of packets transmitted out of the specified interface.</p> |SNMP |bigip.net.out.pkts.rate[{#IF.NAME}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Interface [{#IF.NAME}]: Outgoing traffic, rate |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The rate of bytes transmitted out of the specified interface.</p> |SNMP |bigip.net.out.bytes.rate[{#IF.NAME}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Interface [{#IF.NAME}]: Incoming multicast packet, rate |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The rate of multicast packets received on this interface.</p> |SNMP |bigip.net.in.multicast.rate[{#IF.NAME}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Interface [{#IF.NAME}]: Outgoing multicast packet, rate |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The rate of multicast packets transmitted out of the specified interface.</p> |SNMP |bigip.net.out.multicast.rate[{#IF.NAME}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Interface [{#IF.NAME}]: Incoming packet error |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The number of received packets that are either undersized,</p><p>oversized, or have FCS errors by the specified interface.</p> |SNMP |bigip.net.in.error[{#IF.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Interface [{#IF.NAME}]: Outgoing packet error |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The number of excessive collisions, incremented for each</p><p>frame that experienced 16 collisions during transmission and</p><p>was aborted on the specified interface.</p> |SNMP |bigip.net.out.error[{#IF.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Interface [{#IF.NAME}]: Incoming packet drops |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The number of packets dropped on ingress for various reasons on the specified interface.</p> |SNMP |bigip.net.in.drops[{#IF.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Interface [{#IF.NAME}]: Outgoing packet drops |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The number of packets aged out or with excessive transmission</p><p>delays due to multiple deferrals on the specified interface.</p> |SNMP |bigip.net.out.drops[{#IF.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Interface [{#IF.NAME}]: Collisions |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The number of collisions on the specified interface, incremented by the</p><p>number of collisions experienced during transmissions of a frame</p> |SNMP |bigip.net.collisions[{#IF.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Interface [{#IF.NAME}]: Incoming QnQ packet, rate |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The rate of double tagged packets received on the specified interface.</p> |SNMP |bigip.net.in.qq.rate[{#IF.NAME}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Interface [{#IF.NAME}]: Outgoing QnQ packet, rate |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The rate of double tagged packets transmitted out of the specified interface.</p> |SNMP |bigip.net.out.qq.rate[{#IF.NAME}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Interface [{#IF.NAME}]: Pause state |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The pause state of the specified interface.</p><p>none - no pause;</p><p>txrx - pause all data flow;</p><p>tx - pause out going data flow;</p><p>rx - pause in coming data flow.</p> |SNMP |bigip.net.pause[{#IF.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Virtual server [{#VSERVER.NAME}]: Incoming packet, rate |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The rate of packets received by the specified virtual server from client-side.</p> |SNMP |bigip.vserver.net.in.pkts.rate[{#VSERVER.NAME}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Virtual server [{#VSERVER.NAME}]: Incoming traffic, rate |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The rate of bytes received by the specified virtual server from client-side.</p> |SNMP |bigip.vserver.net.in.bytes.rate[{#VSERVER.NAME}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Virtual server [{#VSERVER.NAME}]: Outgoing packet, rate |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The rate of packets sent to client-side from the specified virtual server.</p> |SNMP |bigip.vserver.net.out.pkts.rate[{#VSERVER.NAME}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Virtual server [{#VSERVER.NAME}]: Outgoing traffic, rate |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The rate of bytes sent to client-side from the specified virtual server.</p> |SNMP |bigip.vserver.net.out.bytes.rate[{#VSERVER.NAME}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Virtual server [{#VSERVER.NAME}]: Current connections |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The current connections from client-side to the specified virtual server.</p> |SNMP |bigip.vserver.net.conn[{#VSERVER.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Virtual server [{#VSERVER.NAME}]: Usage ratio, avg 5s |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The percentage of time Virtual Server was busy over the last 5 seconds.</p> |SNMP |bigip.vserver.usage.5s[{#VSERVER.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Virtual server [{#VSERVER.NAME}]: Usage ratio, avg 1m |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The percentage of time Virtual Server was busy over the last 1 minute.</p> |SNMP |bigip.vserver.usage.1m[{#VSERVER.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Virtual server [{#VSERVER.NAME}]: Usage ratio, avg 5m |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The percentage of time Virtual Server was busy over the last 5 minutes.</p> |SNMP |bigip.vserver.usage.5m[{#VSERVER.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Virtual server [{#VSERVER.NAME}]: Connections hit a rate limit |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The last recorded value for the number of connections to the virtual server when connections hit a rate limit;</p><p>this calculation is only maintained if rate limiting is configured for the service.</p> |SNMP |bigip.vserver.overlimit[{#VSERVER.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Virtual server [{#VSERVER.NAME}]: Duration of exceeding rate limit |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>Duration of time in seconds the specified virtual server has exceeded the configured connection rate limit.</p> |SNMP |bigip.vserver.overtime[{#VSERVER.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Node [{#NODE.NAME}]: Incoming packet, rate |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The rate of packets received by the specified node address from server-side.</p> |SNMP |bigip.node.net.in.pkts.rate[{#NODE.NAME}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Node [{#NODE.NAME}]: Incoming traffic, rate |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The rate of bytes received by the specified node address from server-side.</p> |SNMP |bigip.node.net.in.bytes.rate[{#NODE.NAME}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Node [{#NODE.NAME}]: Outgoing packet, rate |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The rate of packets sent to server-side from the specified node address.</p> |SNMP |bigip.node.net.out.pkts.rate[{#NODE.NAME}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Node [{#NODE.NAME}]: Outgoing traffic, rate |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The rate of bytes sent to server-side from the specified node address.</p> |SNMP |bigip.node.net.out.bytes.rate[{#NODE.NAME}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Node [{#NODE.NAME}]: Current connections |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The current connections from server-side to the specified node address.</p> |SNMP |bigip.node.net.conn[{#NODE.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Node [{#NODE.NAME}]: Current sessions |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The number of current sessions going through the specified node address.</p> |SNMP |bigip.node.net.sessions[{#NODE.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Node [{#NODE.NAME}]: Connections hit a rate limit |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The last recorded value for the number of connections to the node address when connections hit a rate limit;</p><p>this calculation is only maintained if rate limiting is configured for the node.</p> |SNMP |bigip.node.overlimit[{#NODE.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Node [{#NODE.NAME}]: Duration of exceeding rate limit |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>Duration of time in seconds the specified node address has exceeded the</p><p>configured connection rate limit.</p> |SNMP |bigip.node.overtime[{#NODE.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Pool [{#POOL.NAME}]: Incoming packet, rate |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The rate of packets received by the specified pool from server-side.</p> |SNMP |bigip.pool.net.in.pkts.rate[{#POOL.NAME}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Pool [{#POOL.NAME}]: Incoming traffic, rate |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The rate of bytes received by the specified pool from server-side.</p> |SNMP |bigip.pool.net.in.bytes.rate[{#POOL.NAME}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Pool [{#POOL.NAME}]: Outgoing packet, rate |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The rate of packets sent to server-side from the specified pool.</p> |SNMP |bigip.pool.net.out.pkts.rate[{#POOL.NAME}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Pool [{#POOL.NAME}]: Outgoing traffic, rate |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The rate of bytes sent to server-side from the specified pool.</p> |SNMP |bigip.pool.net.out.bytes.rate[{#POOL.NAME}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND<p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Pool [{#POOL.NAME}]: Current connections |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The current connections from server-side to the specified pool.</p> |SNMP |bigip.pool.net.conn[{#POOL.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Pool [{#POOL.NAME}]: Current sessions |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>The number of current sessions going through the specified pool.</p> |SNMP |bigip.pool.net.sessions[{#POOL.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Pool [{#POOL.NAME}]: Queue |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>Number of connections currently in queue, sum.</p> |SNMP |bigip.pool.queue[{#POOL.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |F5 BIG-IP: Pool [{#POOL.NAME}]: Age of the oldest queue entry |<p>MIB: F5-BIGIP-LOCAL-MIB</p><p>Age of the oldest queue entry, max.</p> |SNMP |bigip.pool.queue.age[{#POOL.NAME}]<p>**Preprocessing**:</p><p>- MULTIPLIER: `0.001`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Power_supply |F5 BIG-IP: Power supply [{#POWER.INDEX}]: Status |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The status of the indexed power supply on the system.,</p><p>This is only supported for the platform where</p><p>the sensor data is available.</p><p>Possible values: 0 - bad, 1 - good, 2 - notpresent.</p> |SNMP |bigip.chassis.power.status[{#POWER.INDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Security |F5 BIG-IP: Certificate [{#CERT.NAME}]: Expiration date |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The expiration date of the certificate in unix time.</p> |SNMP |bigip.cert.expiration.date[{#CERT.NAME}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Status |F5 BIG-IP: SNMP agent availability |<p>-</p> |INTERNAL |zabbix[host,snmp,available]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Status |F5 BIG-IP: Uptime |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The system up time in 1/100 seconds since boot.</p> |SNMP |bigip.uptime<p>**Preprocessing**:</p><p>- MULTIPLIER: `0.01`</p> |
|TCP/UDP stat |F5 BIG-IP: Open TCP connections |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The number of current open TCP connections.</p> |SNMP |bigip.tcp.open |
|TCP/UDP stat |F5 BIG-IP: Open UDP connections |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The number of current open UDP connections.</p> |SNMP |bigip.udp.open |
|TCP/UDP stat |F5 BIG-IP: TCP connections, CLOSE-WAIT/LAST-ACK |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The number of current TCP connections in CLOSE-WAIT/LAST-ACK.</p> |SNMP |bigip.tcp.close_wait |
|TCP/UDP stat |F5 BIG-IP: TCP connections, FIN-WAIT-1/CLOSING |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The number of current TCP connections in FIN-WAIT-1/CLOSING.</p> |SNMP |bigip.tcp.fin1_wait |
|TCP/UDP stat |F5 BIG-IP: TCP connections, FIN-WAIT-2 |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The number of current TCP connections in FIN-WAIT-2.</p> |SNMP |bigip.tcp.fin2_wait |
|TCP/UDP stat |F5 BIG-IP: TCP connections, TIME-WAIT |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The number of current TCP connections in TIME-WAIT.</p> |SNMP |bigip.tcp.time_wait |
|Temperature |F5 BIG-IP: Sensor [{#TEMP.INDEX}]: Temperature |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The chassis temperature (in Celsius) of the indexed sensor on the system.,</p><p>This is only supported for the platform where</p><p>the sensor data is available.</p> |SNMP |bigip.chassis.temp.value[{#TEMP.INDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Temperature |F5 BIG-IP: Sensor [{#SLOT.INDEX}:{#TEMP.INDEX}]: Temperature |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>Location: {#TEMP.LOCATION}</p><p>The blade temperature (in Celsius) of the indexed sensor on the system.,</p><p>This is only supported for the platform where</p><p>the sensor data is available.</p> |SNMP |bigip.blade.temp.value[{#SLOT.INDEX},{#TEMP.INDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Voltage |F5 BIG-IP: Voltage [{#VOLT.INDEX}]: Value |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The blade voltage (in V) of the indexed sensor on the system.,</p><p>This is only supported for the platform where</p><p>the sensor data is available.</p> |SNMP |bigip.blade.voltage.value[{#VOLT.INDEX}]<p>**Preprocessing**:</p><p>- MULTIPLIER: `0.001`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Voltage |F5 BIG-IP: Voltage [{#VOLT.INDEX}]: Slot |<p>MIB: F5-BIGIP-SYSTEM-MIB</p><p>The chassis slot number, if applicable.</p> |SNMP |bigip.blade.voltage.slot[{#VOLT.INDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |

## Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----|----|----|
|F5 BIG-IP: High CPU utilization (over {$BIGIP.CPU.UTIL.WARN.MAX}% for 5m) |<p>CPU utilization is too high. The system might be slow to respond.</p> |`{TEMPLATE_NAME:bigip.cpu.usageratio.5m[{#HOST.ID},{#CPU.ID}].last()}>{$BIGIP.CPU.UTIL.WARN.MAX}`<p>Recovery expression:</p>`{TEMPLATE_NAME:bigip.cpu.usageratio.5m[{#HOST.ID},{#CPU.ID}].last()}<{$BIGIP.CPU.UTIL.WARN.MIN}` |WARNING | |
|F5 BIG-IP: Fan[{#FAN.INDEX}] is in critical state |<p>Please check the fan unit</p> |`{TEMPLATE_NAME:bigip.chassis.fan.status[{#FAN.INDEX}].last()}=0` |AVERAGE | |
|F5 BIG-IP: Low free space in file system [{#PART.NAME}] (less than {$BIGIP.FS.FREE.WARN.MIN}% for 5m) |<p>The system is running out of free space.</p> |`{TEMPLATE_NAME:bigip.disktable.freeblocks[{#PART.NAME}].max(5m)}/{Big-IP SNMP:bigip.disktable.totalblocks[{#PART.NAME}].min(5m)}*100<{$BIGIP.FS.FREE.WARN.MIN}`<p>Recovery expression:</p>`{TEMPLATE_NAME:bigip.disktable.freeblocks[{#PART.NAME}].max(5m)}/{Big-IP SNMP:bigip.disktable.totalblocks[{#PART.NAME}].min(5m)}*100>{$BIGIP.FS.FREE.WARN.MAX}` |WARNING | |
|F5 BIG-IP: Chassis has been replaced (new serial number received) |<p>Chassis serial number has changed. Ack to close</p> |`{TEMPLATE_NAME:bigip.serialnumber.diff()}=1 and {TEMPLATE_NAME:bigip.serialnumber.strlen()}>0` |INFO |<p>Manual close: YES</p> |
|F5 BIG-IP: High memory utilization in host [{#HOST.ID}] (over {$BIGIP.MEMORY.UTIL.WARN.MAX}% for 5m) |<p>The system is running out of free memory.</p> |`{TEMPLATE_NAME:bigip.memory.used[{#HOST.ID}].max(5m)}/{Big-IP SNMP:bigip.memory.total[{#HOST.ID}].min(5m)}*100>{$BIGIP.MEMORY.UTIL.WARN.MAX}`<p>Recovery expression:</p>`{TEMPLATE_NAME:bigip.memory.used[{#HOST.ID}].max(5m)}/{Big-IP SNMP:bigip.memory.total[{#HOST.ID}].min(5m)}*100<{$BIGIP.MEMORY.UTIL.WARN.MIN}` |WARNING | |
|F5 BIG-IP: High swap utilization in host [{#HOST.ID}] (over {$BIGIP.SWAP.UTIL.WARN.MAX}% for 5m) |<p>The system is running out of free swap memory.</p> |`{TEMPLATE_NAME:bigip.memory.used.swap[{#HOST.ID}].max(5m)}/{Big-IP SNMP:bigip.memory.total.swap[{#HOST.ID}].min(5m)}*100>{$BIGIP.SWAP.UTIL.WARN.MAX}`<p>Recovery expression:</p>`{TEMPLATE_NAME:bigip.memory.used.swap[{#HOST.ID}].max(5m)}/{Big-IP SNMP:bigip.memory.total.swap[{#HOST.ID}].min(5m)}*100>{$BIGIP.SWAP.UTIL.WARN.MIN}` |WARNING | |
|F5 BIG-IP: There are errors on the network interface ({#IF.NAME}) |<p>-</p> |`{TEMPLATE_NAME:bigip.net.in.error[{#IF.NAME}].last()}>{TEMPLATE_NAME:bigip.net.in.error[{#IF.NAME}].prev()} or {Big-IP SNMP:bigip.net.out.error[{#IF.NAME}].last()}>{Big-IP SNMP:bigip.net.out.error[{#IF.NAME}].prev()}` |AVERAGE | |
|F5 BIG-IP: Power supply [{#POWER.INDEX}] is in critical state |<p>Please check the power supply unit</p> |`{TEMPLATE_NAME:bigip.chassis.power.status[{#POWER.INDEX}].last()}=0` |AVERAGE | |
|F5 BIG-IP: Less than {$BIGIP.CERT.MIN} days left until the certificate expires ({#CERT.NAME}) |<p>Please check certificate</p> |`{TEMPLATE_NAME:bigip.cert.expiration.date[{#CERT.NAME}].last()} + 86400 * {$BIGIP.CERT.MIN} < {TEMPLATE_NAME:bigip.cert.expiration.date[{#CERT.NAME}].now()}` |INFO | |
|F5 BIG-IP: No SNMP data collection |<p>SNMP is not available for polling. Please check device connectivity and SNMP settings.</p> |`{TEMPLATE_NAME:zabbix[host,snmp,available].max({$SNMP.TIMEOUT})}=0` |WARNING | |
|F5 BIG-IP: has been restarted (uptime < 10m) |<p>Uptime is less than 10 minutes</p> |`{TEMPLATE_NAME:bigip.uptime.last()}<10m` |INFO |<p>Manual close: YES</p> |

## Feedback

Please report any issues with the template at https://support.zabbix.com

