/* equation-lexer.c generated by valac 0.40.6, the Vala compiler
 * generated from equation-lexer.vala, do not modify */

/*
 * Copyright (C) 2012 Arth Patel
 * Copyright (C) 2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* Enum for tokens generated by pre-lexer and lexer. */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_LEXER_TOKEN_TYPE (lexer_token_type_get_type ())

#define TYPE_PRE_LEXER (pre_lexer_get_type ())
#define PRE_LEXER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRE_LEXER, PreLexer))
#define PRE_LEXER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRE_LEXER, PreLexerClass))
#define IS_PRE_LEXER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRE_LEXER))
#define IS_PRE_LEXER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRE_LEXER))
#define PRE_LEXER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRE_LEXER, PreLexerClass))

typedef struct _PreLexer PreLexer;
typedef struct _PreLexerClass PreLexerClass;
typedef struct _PreLexerPrivate PreLexerPrivate;
enum  {
	PRE_LEXER_0_PROPERTY,
	PRE_LEXER_NUM_PROPERTIES
};
static GParamSpec* pre_lexer_properties[PRE_LEXER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_LEXER_TOKEN (lexer_token_get_type ())
#define LEXER_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LEXER_TOKEN, LexerToken))
#define LEXER_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LEXER_TOKEN, LexerTokenClass))
#define IS_LEXER_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LEXER_TOKEN))
#define IS_LEXER_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LEXER_TOKEN))
#define LEXER_TOKEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LEXER_TOKEN, LexerTokenClass))

typedef struct _LexerToken LexerToken;
typedef struct _LexerTokenClass LexerTokenClass;
typedef struct _LexerTokenPrivate LexerTokenPrivate;
enum  {
	LEXER_TOKEN_0_PROPERTY,
	LEXER_TOKEN_NUM_PROPERTIES
};
static GParamSpec* lexer_token_properties[LEXER_TOKEN_NUM_PROPERTIES];

#define TYPE_LEXER (lexer_get_type ())
#define LEXER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LEXER, Lexer))
#define LEXER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LEXER, LexerClass))
#define IS_LEXER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LEXER))
#define IS_LEXER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LEXER))
#define LEXER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LEXER, LexerClass))

typedef struct _Lexer Lexer;
typedef struct _LexerClass LexerClass;
typedef struct _LexerPrivate LexerPrivate;

#define TYPE_PARSER (parser_get_type ())
#define PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PARSER, Parser))
#define PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PARSER, ParserClass))
#define IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PARSER))
#define IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PARSER))
#define PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PARSER, ParserClass))

typedef struct _Parser Parser;
typedef struct _ParserClass ParserClass;
enum  {
	LEXER_0_PROPERTY,
	LEXER_NUM_PROPERTIES
};
static GParamSpec* lexer_properties[LEXER_NUM_PROPERTIES];
#define _parser_unref0(var) ((var == NULL) ? NULL : (var = (parser_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;

#define TYPE_ERROR_CODE (error_code_get_type ())

typedef enum  {
	LEXER_TOKEN_TYPE_UNKNOWN,
	LEXER_TOKEN_TYPE_PL_DECIMAL,
	LEXER_TOKEN_TYPE_PL_DIGIT,
	LEXER_TOKEN_TYPE_PL_HEX,
	LEXER_TOKEN_TYPE_PL_SUPER_DIGIT,
	LEXER_TOKEN_TYPE_PL_SUPER_MINUS,
	LEXER_TOKEN_TYPE_PL_SUB_DIGIT,
	LEXER_TOKEN_TYPE_PL_FRACTION,
	LEXER_TOKEN_TYPE_PL_DEGREE,
	LEXER_TOKEN_TYPE_PL_MINUTE,
	LEXER_TOKEN_TYPE_PL_SECOND,
	LEXER_TOKEN_TYPE_PL_LETTER,
	LEXER_TOKEN_TYPE_PL_EOS,
	LEXER_TOKEN_TYPE_PL_SKIP,
	LEXER_TOKEN_TYPE_ADD,
	LEXER_TOKEN_TYPE_SUBTRACT,
	LEXER_TOKEN_TYPE_MULTIPLY,
	LEXER_TOKEN_TYPE_DIVIDE,
	LEXER_TOKEN_TYPE_MOD,
	LEXER_TOKEN_TYPE_L_FLOOR,
	LEXER_TOKEN_TYPE_R_FLOOR,
	LEXER_TOKEN_TYPE_L_CEILING,
	LEXER_TOKEN_TYPE_R_CEILING,
	LEXER_TOKEN_TYPE_ROOT,
	LEXER_TOKEN_TYPE_ROOT_3,
	LEXER_TOKEN_TYPE_ROOT_4,
	LEXER_TOKEN_TYPE_NOT,
	LEXER_TOKEN_TYPE_AND,
	LEXER_TOKEN_TYPE_OR,
	LEXER_TOKEN_TYPE_XOR,
	LEXER_TOKEN_TYPE_IN,
	LEXER_TOKEN_TYPE_NUMBER,
	LEXER_TOKEN_TYPE_SUP_NUMBER,
	LEXER_TOKEN_TYPE_NSUP_NUMBER,
	LEXER_TOKEN_TYPE_SUB_NUMBER,
	LEXER_TOKEN_TYPE_FUNCTION,
	LEXER_TOKEN_TYPE_UNIT,
	LEXER_TOKEN_TYPE_VARIABLE,
	LEXER_TOKEN_TYPE_ASSIGN,
	LEXER_TOKEN_TYPE_L_R_BRACKET,
	LEXER_TOKEN_TYPE_R_R_BRACKET,
	LEXER_TOKEN_TYPE_L_S_BRACKET,
	LEXER_TOKEN_TYPE_R_S_BRACKET,
	LEXER_TOKEN_TYPE_L_C_BRACKET,
	LEXER_TOKEN_TYPE_R_C_BRACKET,
	LEXER_TOKEN_TYPE_ABS,
	LEXER_TOKEN_TYPE_POWER,
	LEXER_TOKEN_TYPE_FACTORIAL,
	LEXER_TOKEN_TYPE_PERCENTAGE,
	LEXER_TOKEN_TYPE_ARGUMENT_SEPARATOR
} LexerTokenType;

struct _PreLexer {
	GObject parent_instance;
	PreLexerPrivate * priv;
	gchar* stream;
	gint index;
	gint mark_index;
};

struct _PreLexerClass {
	GObjectClass parent_class;
};

struct _PreLexerPrivate {
	gboolean eos;
};

struct _LexerToken {
	GObject parent_instance;
	LexerTokenPrivate * priv;
	gchar* text;
	guint start_index;
	guint end_index;
	LexerTokenType type;
};

struct _LexerTokenClass {
	GObjectClass parent_class;
};

struct _Lexer {
	GObject parent_instance;
	LexerPrivate * priv;
	GList* tokens;
};

struct _LexerClass {
	GObjectClass parent_class;
};

struct _LexerPrivate {
	Parser* parser;
	PreLexer* prelexer;
	guint next_token;
	gint number_base;
};

typedef enum  {
	ERROR_CODE_NONE,
	ERROR_CODE_INVALID,
	ERROR_CODE_OVERFLOW,
	ERROR_CODE_UNKNOWN_VARIABLE,
	ERROR_CODE_UNKNOWN_FUNCTION,
	ERROR_CODE_UNKNOWN_CONVERSION,
	ERROR_CODE_MP
} ErrorCode;


static gpointer pre_lexer_parent_class = NULL;
static gpointer lexer_token_parent_class = NULL;
static gpointer lexer_parent_class = NULL;

GType lexer_token_type_get_type (void) G_GNUC_CONST;
GType pre_lexer_get_type (void) G_GNUC_CONST;
#define PRE_LEXER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PRE_LEXER, PreLexerPrivate))
PreLexer* pre_lexer_new (const gchar* input);
PreLexer* pre_lexer_construct (GType object_type,
                               const gchar* input);
void pre_lexer_roll_back (PreLexer* self);
void pre_lexer_set_marker (PreLexer* self);
gchar* pre_lexer_get_marked_substring (PreLexer* self);
LexerTokenType pre_lexer_get_next_token (PreLexer* self);
static void pre_lexer_finalize (GObject * obj);
GType lexer_token_get_type (void) G_GNUC_CONST;
LexerToken* lexer_token_new (void);
LexerToken* lexer_token_construct (GType object_type);
static void lexer_token_finalize (GObject * obj);
GType lexer_get_type (void) G_GNUC_CONST;
gpointer parser_ref (gpointer instance);
void parser_unref (gpointer instance);
GParamSpec* param_spec_parser (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_parser (GValue* value,
                       gpointer v_object);
void value_take_parser (GValue* value,
                        gpointer v_object);
gpointer value_get_parser (const GValue* value);
GType parser_get_type (void) G_GNUC_CONST;
#define LEXER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LEXER, LexerPrivate))
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
Lexer* lexer_new (const gchar* input,
                  Parser* parser,
                  gint number_base);
Lexer* lexer_construct (GType object_type,
                        const gchar* input,
                        Parser* parser,
                        gint number_base);
void lexer_scan (Lexer* self);
static LexerToken* lexer_insert_next_token (Lexer* self);
LexerToken* lexer_get_next_token (Lexer* self);
void lexer_roll_back (Lexer* self);
static gboolean lexer_check_if_function (Lexer* self);
gboolean parser_function_is_defined (Parser* self,
                                     const gchar* name);
static gboolean lexer_check_if_unit (Lexer* self);
gboolean parser_unit_is_defined (Parser* self,
                                 const gchar* name);
static gboolean lexer_check_if_number (Lexer* self);
GType number_get_type (void) G_GNUC_CONST;
Number* mp_set_from_string (const gchar* str,
                            gint default_base);
static LexerToken* lexer_insert_token (Lexer* self,
                                LexerTokenType type);
GType error_code_get_type (void) G_GNUC_CONST;
void parser_set_error (Parser* self,
                       ErrorCode errorno,
                       const gchar* token,
                       guint token_start,
                       guint token_end);
static LexerToken* lexer_insert_digit (Lexer* self);
static LexerToken* lexer_insert_decimal (Lexer* self);
static LexerToken* lexer_insert_hex (Lexer* self);
static LexerToken* lexer_insert_letter (Lexer* self);
static LexerToken* lexer_insert_angle_num_dm (Lexer* self);
static LexerToken* lexer_insert_angle_num_dms (Lexer* self);
static LexerToken* lexer_insert_hex_dec (Lexer* self);
static LexerToken* lexer_insert_decimal_hex (Lexer* self);
static void lexer_finalize (GObject * obj);


GType
lexer_token_type_get_type (void)
{
	static volatile gsize lexer_token_type_type_id__volatile = 0;
	if (g_once_init_enter (&lexer_token_type_type_id__volatile)) {
		static const GEnumValue values[] = {{LEXER_TOKEN_TYPE_UNKNOWN, "LEXER_TOKEN_TYPE_UNKNOWN", "unknown"}, {LEXER_TOKEN_TYPE_PL_DECIMAL, "LEXER_TOKEN_TYPE_PL_DECIMAL", "pl-decimal"}, {LEXER_TOKEN_TYPE_PL_DIGIT, "LEXER_TOKEN_TYPE_PL_DIGIT", "pl-digit"}, {LEXER_TOKEN_TYPE_PL_HEX, "LEXER_TOKEN_TYPE_PL_HEX", "pl-hex"}, {LEXER_TOKEN_TYPE_PL_SUPER_DIGIT, "LEXER_TOKEN_TYPE_PL_SUPER_DIGIT", "pl-super-digit"}, {LEXER_TOKEN_TYPE_PL_SUPER_MINUS, "LEXER_TOKEN_TYPE_PL_SUPER_MINUS", "pl-super-minus"}, {LEXER_TOKEN_TYPE_PL_SUB_DIGIT, "LEXER_TOKEN_TYPE_PL_SUB_DIGIT", "pl-sub-digit"}, {LEXER_TOKEN_TYPE_PL_FRACTION, "LEXER_TOKEN_TYPE_PL_FRACTION", "pl-fraction"}, {LEXER_TOKEN_TYPE_PL_DEGREE, "LEXER_TOKEN_TYPE_PL_DEGREE", "pl-degree"}, {LEXER_TOKEN_TYPE_PL_MINUTE, "LEXER_TOKEN_TYPE_PL_MINUTE", "pl-minute"}, {LEXER_TOKEN_TYPE_PL_SECOND, "LEXER_TOKEN_TYPE_PL_SECOND", "pl-second"}, {LEXER_TOKEN_TYPE_PL_LETTER, "LEXER_TOKEN_TYPE_PL_LETTER", "pl-letter"}, {LEXER_TOKEN_TYPE_PL_EOS, "LEXER_TOKEN_TYPE_PL_EOS", "pl-eos"}, {LEXER_TOKEN_TYPE_PL_SKIP, "LEXER_TOKEN_TYPE_PL_SKIP", "pl-skip"}, {LEXER_TOKEN_TYPE_ADD, "LEXER_TOKEN_TYPE_ADD", "add"}, {LEXER_TOKEN_TYPE_SUBTRACT, "LEXER_TOKEN_TYPE_SUBTRACT", "subtract"}, {LEXER_TOKEN_TYPE_MULTIPLY, "LEXER_TOKEN_TYPE_MULTIPLY", "multiply"}, {LEXER_TOKEN_TYPE_DIVIDE, "LEXER_TOKEN_TYPE_DIVIDE", "divide"}, {LEXER_TOKEN_TYPE_MOD, "LEXER_TOKEN_TYPE_MOD", "mod"}, {LEXER_TOKEN_TYPE_L_FLOOR, "LEXER_TOKEN_TYPE_L_FLOOR", "l-floor"}, {LEXER_TOKEN_TYPE_R_FLOOR, "LEXER_TOKEN_TYPE_R_FLOOR", "r-floor"}, {LEXER_TOKEN_TYPE_L_CEILING, "LEXER_TOKEN_TYPE_L_CEILING", "l-ceiling"}, {LEXER_TOKEN_TYPE_R_CEILING, "LEXER_TOKEN_TYPE_R_CEILING", "r-ceiling"}, {LEXER_TOKEN_TYPE_ROOT, "LEXER_TOKEN_TYPE_ROOT", "root"}, {LEXER_TOKEN_TYPE_ROOT_3, "LEXER_TOKEN_TYPE_ROOT_3", "root-3"}, {LEXER_TOKEN_TYPE_ROOT_4, "LEXER_TOKEN_TYPE_ROOT_4", "root-4"}, {LEXER_TOKEN_TYPE_NOT, "LEXER_TOKEN_TYPE_NOT", "not"}, {LEXER_TOKEN_TYPE_AND, "LEXER_TOKEN_TYPE_AND", "and"}, {LEXER_TOKEN_TYPE_OR, "LEXER_TOKEN_TYPE_OR", "or"}, {LEXER_TOKEN_TYPE_XOR, "LEXER_TOKEN_TYPE_XOR", "xor"}, {LEXER_TOKEN_TYPE_IN, "LEXER_TOKEN_TYPE_IN", "in"}, {LEXER_TOKEN_TYPE_NUMBER, "LEXER_TOKEN_TYPE_NUMBER", "number"}, {LEXER_TOKEN_TYPE_SUP_NUMBER, "LEXER_TOKEN_TYPE_SUP_NUMBER", "sup-number"}, {LEXER_TOKEN_TYPE_NSUP_NUMBER, "LEXER_TOKEN_TYPE_NSUP_NUMBER", "nsup-number"}, {LEXER_TOKEN_TYPE_SUB_NUMBER, "LEXER_TOKEN_TYPE_SUB_NUMBER", "sub-number"}, {LEXER_TOKEN_TYPE_FUNCTION, "LEXER_TOKEN_TYPE_FUNCTION", "function"}, {LEXER_TOKEN_TYPE_UNIT, "LEXER_TOKEN_TYPE_UNIT", "unit"}, {LEXER_TOKEN_TYPE_VARIABLE, "LEXER_TOKEN_TYPE_VARIABLE", "variable"}, {LEXER_TOKEN_TYPE_ASSIGN, "LEXER_TOKEN_TYPE_ASSIGN", "assign"}, {LEXER_TOKEN_TYPE_L_R_BRACKET, "LEXER_TOKEN_TYPE_L_R_BRACKET", "l-r-bracket"}, {LEXER_TOKEN_TYPE_R_R_BRACKET, "LEXER_TOKEN_TYPE_R_R_BRACKET", "r-r-bracket"}, {LEXER_TOKEN_TYPE_L_S_BRACKET, "LEXER_TOKEN_TYPE_L_S_BRACKET", "l-s-bracket"}, {LEXER_TOKEN_TYPE_R_S_BRACKET, "LEXER_TOKEN_TYPE_R_S_BRACKET", "r-s-bracket"}, {LEXER_TOKEN_TYPE_L_C_BRACKET, "LEXER_TOKEN_TYPE_L_C_BRACKET", "l-c-bracket"}, {LEXER_TOKEN_TYPE_R_C_BRACKET, "LEXER_TOKEN_TYPE_R_C_BRACKET", "r-c-bracket"}, {LEXER_TOKEN_TYPE_ABS, "LEXER_TOKEN_TYPE_ABS", "abs"}, {LEXER_TOKEN_TYPE_POWER, "LEXER_TOKEN_TYPE_POWER", "power"}, {LEXER_TOKEN_TYPE_FACTORIAL, "LEXER_TOKEN_TYPE_FACTORIAL", "factorial"}, {LEXER_TOKEN_TYPE_PERCENTAGE, "LEXER_TOKEN_TYPE_PERCENTAGE", "percentage"}, {LEXER_TOKEN_TYPE_ARGUMENT_SEPARATOR, "LEXER_TOKEN_TYPE_ARGUMENT_SEPARATOR", "argument-separator"}, {0, NULL, NULL}};
		GType lexer_token_type_type_id;
		lexer_token_type_type_id = g_enum_register_static ("LexerTokenType", values);
		g_once_init_leave (&lexer_token_type_type_id__volatile, lexer_token_type_type_id);
	}
	return lexer_token_type_type_id__volatile;
}


PreLexer*
pre_lexer_construct (GType object_type,
                     const gchar* input)
{
	PreLexer * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (input != NULL, NULL);
	self = (PreLexer*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (input);
	_g_free0 (self->stream);
	self->stream = _tmp0_;
	self->index = 0;
	self->mark_index = 0;
	return self;
}


PreLexer*
pre_lexer_new (const gchar* input)
{
	return pre_lexer_construct (TYPE_PRE_LEXER, input);
}


static gboolean
string_get_prev_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (0 < (*index)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_prev_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


void
pre_lexer_roll_back (PreLexer* self)
{
	gboolean _tmp0_;
	gunichar c = 0U;
	const gchar* _tmp1_;
	gunichar _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->eos;
	if (_tmp0_) {
		self->priv->eos = FALSE;
		return;
	}
	_tmp1_ = self->stream;
	string_get_prev_char (_tmp1_, &self->index, &_tmp2_);
	c = _tmp2_;
}


void
pre_lexer_set_marker (PreLexer* self)
{
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->index;
	self->mark_index = _tmp0_;
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


gchar*
pre_lexer_get_marked_substring (PreLexer* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->stream;
	_tmp1_ = self->mark_index;
	_tmp2_ = self->index;
	_tmp3_ = self->mark_index;
	_tmp4_ = string_substring (_tmp0_, (glong) _tmp1_, (glong) (_tmp2_ - _tmp3_));
	result = _tmp4_;
	return result;
}


static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	_tmp0_ = _vala_c;
	if (_tmp0_ != ((gunichar) 0)) {
		gchar* _tmp1_;
		_tmp1_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp1_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


LexerTokenType
pre_lexer_get_next_token (PreLexer* self)
{
	LexerTokenType result = 0;
	gunichar c = 0U;
	const gchar* _tmp0_;
	gunichar _tmp1_ = 0U;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	gunichar _tmp4_;
	gunichar _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gunichar _tmp9_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gunichar _tmp23_;
	gunichar _tmp33_;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp42_ = FALSE;
	gunichar _tmp43_;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp57_ = FALSE;
	gboolean _tmp58_ = FALSE;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp65_ = FALSE;
	gboolean _tmp66_ = FALSE;
	gunichar _tmp67_;
	gunichar _tmp82_;
	gunichar _tmp83_;
	gunichar _tmp84_;
	gboolean _tmp85_ = FALSE;
	gunichar _tmp86_;
	gunichar _tmp88_;
	gunichar _tmp89_;
	gboolean _tmp90_ = FALSE;
	gunichar _tmp91_;
	gboolean _tmp93_ = FALSE;
	gunichar _tmp94_;
	gunichar _tmp96_;
	gboolean _tmp97_ = FALSE;
	gboolean _tmp98_ = FALSE;
	gunichar _tmp99_;
	gboolean _tmp102_ = FALSE;
	gunichar _tmp103_;
	gboolean _tmp105_ = FALSE;
	gboolean _tmp106_ = FALSE;
	gunichar _tmp107_;
	gunichar _tmp110_;
	gunichar _tmp111_;
	gunichar _tmp112_;
	gunichar _tmp113_;
	gunichar _tmp114_;
	gunichar _tmp115_;
	gunichar _tmp116_;
	gunichar _tmp117_;
	gunichar _tmp118_;
	gunichar _tmp119_;
	gunichar _tmp120_;
	gunichar _tmp121_;
	gunichar _tmp122_;
	gunichar _tmp123_;
	gunichar _tmp124_;
	gunichar _tmp125_;
	gunichar _tmp126_;
	gunichar _tmp127_;
	gunichar _tmp128_;
	gboolean _tmp129_ = FALSE;
	gboolean _tmp130_ = FALSE;
	gboolean _tmp131_ = FALSE;
	gunichar _tmp132_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->stream;
	_tmp2_ = string_get_next_char (_tmp0_, &self->index, &_tmp1_);
	c = _tmp1_;
	if (!_tmp2_) {
		self->priv->eos = TRUE;
		result = LEXER_TOKEN_TYPE_PL_EOS;
		return result;
	}
	self->priv->eos = FALSE;
	_tmp4_ = c;
	if (_tmp4_ == ((gunichar) ',')) {
		_tmp3_ = TRUE;
	} else {
		gunichar _tmp5_;
		_tmp5_ = c;
		_tmp3_ = _tmp5_ == ((gunichar) '.');
	}
	if (_tmp3_) {
		result = LEXER_TOKEN_TYPE_PL_DECIMAL;
		return result;
	}
	_tmp6_ = c;
	if (g_unichar_isdigit (_tmp6_)) {
		result = LEXER_TOKEN_TYPE_PL_DIGIT;
		return result;
	}
	_tmp9_ = c;
	if (_tmp9_ >= ((gunichar) 'a')) {
		gunichar _tmp10_;
		_tmp10_ = c;
		_tmp8_ = _tmp10_ <= ((gunichar) 'f');
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		gboolean _tmp11_ = FALSE;
		gunichar _tmp12_;
		_tmp12_ = c;
		if (_tmp12_ >= ((gunichar) 'A')) {
			gunichar _tmp13_;
			_tmp13_ = c;
			_tmp11_ = _tmp13_ <= ((gunichar) 'F');
		} else {
			_tmp11_ = FALSE;
		}
		_tmp7_ = _tmp11_;
	}
	if (_tmp7_) {
		result = LEXER_TOKEN_TYPE_PL_HEX;
		return result;
	}
	_tmp23_ = c;
	if (_tmp23_ == 8304U) {
		_tmp22_ = TRUE;
	} else {
		gunichar _tmp24_;
		_tmp24_ = c;
		_tmp22_ = _tmp24_ == 185U;
	}
	if (_tmp22_) {
		_tmp21_ = TRUE;
	} else {
		gunichar _tmp25_;
		_tmp25_ = c;
		_tmp21_ = _tmp25_ == 178U;
	}
	if (_tmp21_) {
		_tmp20_ = TRUE;
	} else {
		gunichar _tmp26_;
		_tmp26_ = c;
		_tmp20_ = _tmp26_ == 179U;
	}
	if (_tmp20_) {
		_tmp19_ = TRUE;
	} else {
		gunichar _tmp27_;
		_tmp27_ = c;
		_tmp19_ = _tmp27_ == 8308U;
	}
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		gunichar _tmp28_;
		_tmp28_ = c;
		_tmp18_ = _tmp28_ == 8309U;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		gunichar _tmp29_;
		_tmp29_ = c;
		_tmp17_ = _tmp29_ == 8310U;
	}
	if (_tmp17_) {
		_tmp16_ = TRUE;
	} else {
		gunichar _tmp30_;
		_tmp30_ = c;
		_tmp16_ = _tmp30_ == 8311U;
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		gunichar _tmp31_;
		_tmp31_ = c;
		_tmp15_ = _tmp31_ == 8312U;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		gunichar _tmp32_;
		_tmp32_ = c;
		_tmp14_ = _tmp32_ == 8313U;
	}
	if (_tmp14_) {
		result = LEXER_TOKEN_TYPE_PL_SUPER_DIGIT;
		return result;
	}
	_tmp33_ = c;
	if (_tmp33_ == 8315U) {
		result = LEXER_TOKEN_TYPE_PL_SUPER_MINUS;
		return result;
	}
	_tmp43_ = c;
	if (_tmp43_ == 8320U) {
		_tmp42_ = TRUE;
	} else {
		gunichar _tmp44_;
		_tmp44_ = c;
		_tmp42_ = _tmp44_ == 8321U;
	}
	if (_tmp42_) {
		_tmp41_ = TRUE;
	} else {
		gunichar _tmp45_;
		_tmp45_ = c;
		_tmp41_ = _tmp45_ == 8322U;
	}
	if (_tmp41_) {
		_tmp40_ = TRUE;
	} else {
		gunichar _tmp46_;
		_tmp46_ = c;
		_tmp40_ = _tmp46_ == 8323U;
	}
	if (_tmp40_) {
		_tmp39_ = TRUE;
	} else {
		gunichar _tmp47_;
		_tmp47_ = c;
		_tmp39_ = _tmp47_ == 8324U;
	}
	if (_tmp39_) {
		_tmp38_ = TRUE;
	} else {
		gunichar _tmp48_;
		_tmp48_ = c;
		_tmp38_ = _tmp48_ == 8325U;
	}
	if (_tmp38_) {
		_tmp37_ = TRUE;
	} else {
		gunichar _tmp49_;
		_tmp49_ = c;
		_tmp37_ = _tmp49_ == 8326U;
	}
	if (_tmp37_) {
		_tmp36_ = TRUE;
	} else {
		gunichar _tmp50_;
		_tmp50_ = c;
		_tmp36_ = _tmp50_ == 8327U;
	}
	if (_tmp36_) {
		_tmp35_ = TRUE;
	} else {
		gunichar _tmp51_;
		_tmp51_ = c;
		_tmp35_ = _tmp51_ == 8328U;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		gunichar _tmp52_;
		_tmp52_ = c;
		_tmp34_ = _tmp52_ == 8329U;
	}
	if (_tmp34_) {
		result = LEXER_TOKEN_TYPE_PL_SUB_DIGIT;
		return result;
	}
	_tmp67_ = c;
	if (_tmp67_ == 189U) {
		_tmp66_ = TRUE;
	} else {
		gunichar _tmp68_;
		_tmp68_ = c;
		_tmp66_ = _tmp68_ == 8531U;
	}
	if (_tmp66_) {
		_tmp65_ = TRUE;
	} else {
		gunichar _tmp69_;
		_tmp69_ = c;
		_tmp65_ = _tmp69_ == 8532U;
	}
	if (_tmp65_) {
		_tmp64_ = TRUE;
	} else {
		gunichar _tmp70_;
		_tmp70_ = c;
		_tmp64_ = _tmp70_ == 188U;
	}
	if (_tmp64_) {
		_tmp63_ = TRUE;
	} else {
		gunichar _tmp71_;
		_tmp71_ = c;
		_tmp63_ = _tmp71_ == 190U;
	}
	if (_tmp63_) {
		_tmp62_ = TRUE;
	} else {
		gunichar _tmp72_;
		_tmp72_ = c;
		_tmp62_ = _tmp72_ == 8533U;
	}
	if (_tmp62_) {
		_tmp61_ = TRUE;
	} else {
		gunichar _tmp73_;
		_tmp73_ = c;
		_tmp61_ = _tmp73_ == 8534U;
	}
	if (_tmp61_) {
		_tmp60_ = TRUE;
	} else {
		gunichar _tmp74_;
		_tmp74_ = c;
		_tmp60_ = _tmp74_ == 8535U;
	}
	if (_tmp60_) {
		_tmp59_ = TRUE;
	} else {
		gunichar _tmp75_;
		_tmp75_ = c;
		_tmp59_ = _tmp75_ == 8536U;
	}
	if (_tmp59_) {
		_tmp58_ = TRUE;
	} else {
		gunichar _tmp76_;
		_tmp76_ = c;
		_tmp58_ = _tmp76_ == 8537U;
	}
	if (_tmp58_) {
		_tmp57_ = TRUE;
	} else {
		gunichar _tmp77_;
		_tmp77_ = c;
		_tmp57_ = _tmp77_ == 8538U;
	}
	if (_tmp57_) {
		_tmp56_ = TRUE;
	} else {
		gunichar _tmp78_;
		_tmp78_ = c;
		_tmp56_ = _tmp78_ == 8539U;
	}
	if (_tmp56_) {
		_tmp55_ = TRUE;
	} else {
		gunichar _tmp79_;
		_tmp79_ = c;
		_tmp55_ = _tmp79_ == 8540U;
	}
	if (_tmp55_) {
		_tmp54_ = TRUE;
	} else {
		gunichar _tmp80_;
		_tmp80_ = c;
		_tmp54_ = _tmp80_ == 8541U;
	}
	if (_tmp54_) {
		_tmp53_ = TRUE;
	} else {
		gunichar _tmp81_;
		_tmp81_ = c;
		_tmp53_ = _tmp81_ == 8542U;
	}
	if (_tmp53_) {
		result = LEXER_TOKEN_TYPE_PL_FRACTION;
		return result;
	}
	_tmp82_ = c;
	if (_tmp82_ == 176U) {
		result = LEXER_TOKEN_TYPE_PL_DEGREE;
		return result;
	}
	_tmp83_ = c;
	if (_tmp83_ == ((gunichar) '\'')) {
		result = LEXER_TOKEN_TYPE_PL_MINUTE;
		return result;
	}
	_tmp84_ = c;
	if (_tmp84_ == ((gunichar) '"')) {
		result = LEXER_TOKEN_TYPE_PL_SECOND;
		return result;
	}
	_tmp86_ = c;
	if (g_unichar_isalpha (_tmp86_)) {
		_tmp85_ = TRUE;
	} else {
		gunichar _tmp87_;
		_tmp87_ = c;
		_tmp85_ = _tmp87_ == ((gunichar) '_');
	}
	if (_tmp85_) {
		result = LEXER_TOKEN_TYPE_PL_LETTER;
		return result;
	}
	_tmp88_ = c;
	if (_tmp88_ == 8743U) {
		result = LEXER_TOKEN_TYPE_AND;
		return result;
	}
	_tmp89_ = c;
	if (_tmp89_ == 8744U) {
		result = LEXER_TOKEN_TYPE_OR;
		return result;
	}
	_tmp91_ = c;
	if (_tmp91_ == 8891U) {
		_tmp90_ = TRUE;
	} else {
		gunichar _tmp92_;
		_tmp92_ = c;
		_tmp90_ = _tmp92_ == 8853U;
	}
	if (_tmp90_) {
		result = LEXER_TOKEN_TYPE_XOR;
		return result;
	}
	_tmp94_ = c;
	if (_tmp94_ == 172U) {
		_tmp93_ = TRUE;
	} else {
		gunichar _tmp95_;
		_tmp95_ = c;
		_tmp93_ = _tmp95_ == ((gunichar) '~');
	}
	if (_tmp93_) {
		result = LEXER_TOKEN_TYPE_NOT;
		return result;
	}
	_tmp96_ = c;
	if (_tmp96_ == ((gunichar) '+')) {
		result = LEXER_TOKEN_TYPE_ADD;
		return result;
	}
	_tmp99_ = c;
	if (_tmp99_ == ((gunichar) '-')) {
		_tmp98_ = TRUE;
	} else {
		gunichar _tmp100_;
		_tmp100_ = c;
		_tmp98_ = _tmp100_ == 8722U;
	}
	if (_tmp98_) {
		_tmp97_ = TRUE;
	} else {
		gunichar _tmp101_;
		_tmp101_ = c;
		_tmp97_ = _tmp101_ == 8211U;
	}
	if (_tmp97_) {
		result = LEXER_TOKEN_TYPE_SUBTRACT;
		return result;
	}
	_tmp103_ = c;
	if (_tmp103_ == ((gunichar) '*')) {
		_tmp102_ = TRUE;
	} else {
		gunichar _tmp104_;
		_tmp104_ = c;
		_tmp102_ = _tmp104_ == 215U;
	}
	if (_tmp102_) {
		result = LEXER_TOKEN_TYPE_MULTIPLY;
		return result;
	}
	_tmp107_ = c;
	if (_tmp107_ == ((gunichar) '/')) {
		_tmp106_ = TRUE;
	} else {
		gunichar _tmp108_;
		_tmp108_ = c;
		_tmp106_ = _tmp108_ == 8725U;
	}
	if (_tmp106_) {
		_tmp105_ = TRUE;
	} else {
		gunichar _tmp109_;
		_tmp109_ = c;
		_tmp105_ = _tmp109_ == 247U;
	}
	if (_tmp105_) {
		result = LEXER_TOKEN_TYPE_DIVIDE;
		return result;
	}
	_tmp110_ = c;
	if (_tmp110_ == 8970U) {
		result = LEXER_TOKEN_TYPE_L_FLOOR;
		return result;
	}
	_tmp111_ = c;
	if (_tmp111_ == 8971U) {
		result = LEXER_TOKEN_TYPE_R_FLOOR;
		return result;
	}
	_tmp112_ = c;
	if (_tmp112_ == 8968U) {
		result = LEXER_TOKEN_TYPE_L_CEILING;
		return result;
	}
	_tmp113_ = c;
	if (_tmp113_ == 8969U) {
		result = LEXER_TOKEN_TYPE_R_CEILING;
		return result;
	}
	_tmp114_ = c;
	if (_tmp114_ == 8730U) {
		result = LEXER_TOKEN_TYPE_ROOT;
		return result;
	}
	_tmp115_ = c;
	if (_tmp115_ == 8731U) {
		result = LEXER_TOKEN_TYPE_ROOT_3;
		return result;
	}
	_tmp116_ = c;
	if (_tmp116_ == 8732U) {
		result = LEXER_TOKEN_TYPE_ROOT_4;
		return result;
	}
	_tmp117_ = c;
	if (_tmp117_ == ((gunichar) '=')) {
		result = LEXER_TOKEN_TYPE_ASSIGN;
		return result;
	}
	_tmp118_ = c;
	if (_tmp118_ == ((gunichar) '(')) {
		result = LEXER_TOKEN_TYPE_L_R_BRACKET;
		return result;
	}
	_tmp119_ = c;
	if (_tmp119_ == ((gunichar) ')')) {
		result = LEXER_TOKEN_TYPE_R_R_BRACKET;
		return result;
	}
	_tmp120_ = c;
	if (_tmp120_ == ((gunichar) '[')) {
		result = LEXER_TOKEN_TYPE_L_S_BRACKET;
		return result;
	}
	_tmp121_ = c;
	if (_tmp121_ == ((gunichar) ']')) {
		result = LEXER_TOKEN_TYPE_R_S_BRACKET;
		return result;
	}
	_tmp122_ = c;
	if (_tmp122_ == ((gunichar) '{')) {
		result = LEXER_TOKEN_TYPE_L_C_BRACKET;
		return result;
	}
	_tmp123_ = c;
	if (_tmp123_ == ((gunichar) '}')) {
		result = LEXER_TOKEN_TYPE_R_C_BRACKET;
		return result;
	}
	_tmp124_ = c;
	if (_tmp124_ == ((gunichar) '|')) {
		result = LEXER_TOKEN_TYPE_ABS;
		return result;
	}
	_tmp125_ = c;
	if (_tmp125_ == ((gunichar) '^')) {
		result = LEXER_TOKEN_TYPE_POWER;
		return result;
	}
	_tmp126_ = c;
	if (_tmp126_ == ((gunichar) '!')) {
		result = LEXER_TOKEN_TYPE_FACTORIAL;
		return result;
	}
	_tmp127_ = c;
	if (_tmp127_ == ((gunichar) '%')) {
		result = LEXER_TOKEN_TYPE_PERCENTAGE;
		return result;
	}
	_tmp128_ = c;
	if (_tmp128_ == ((gunichar) ';')) {
		result = LEXER_TOKEN_TYPE_ARGUMENT_SEPARATOR;
		return result;
	}
	_tmp132_ = c;
	if (_tmp132_ == ((gunichar) ' ')) {
		_tmp131_ = TRUE;
	} else {
		gunichar _tmp133_;
		_tmp133_ = c;
		_tmp131_ = _tmp133_ == ((gunichar) '\r');
	}
	if (_tmp131_) {
		_tmp130_ = TRUE;
	} else {
		gunichar _tmp134_;
		_tmp134_ = c;
		_tmp130_ = _tmp134_ == ((gunichar) '\t');
	}
	if (_tmp130_) {
		_tmp129_ = TRUE;
	} else {
		gunichar _tmp135_;
		_tmp135_ = c;
		_tmp129_ = _tmp135_ == ((gunichar) '\n');
	}
	if (_tmp129_) {
		result = LEXER_TOKEN_TYPE_PL_SKIP;
		return result;
	}
	result = LEXER_TOKEN_TYPE_UNKNOWN;
	return result;
}


static void
pre_lexer_class_init (PreLexerClass * klass)
{
	pre_lexer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PreLexerPrivate));
	G_OBJECT_CLASS (klass)->finalize = pre_lexer_finalize;
}


static void
pre_lexer_instance_init (PreLexer * self)
{
	self->priv = PRE_LEXER_GET_PRIVATE (self);
	self->priv->eos = FALSE;
}


static void
pre_lexer_finalize (GObject * obj)
{
	PreLexer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRE_LEXER, PreLexer);
	_g_free0 (self->stream);
	G_OBJECT_CLASS (pre_lexer_parent_class)->finalize (obj);
}


GType
pre_lexer_get_type (void)
{
	static volatile gsize pre_lexer_type_id__volatile = 0;
	if (g_once_init_enter (&pre_lexer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PreLexerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pre_lexer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreLexer), 0, (GInstanceInitFunc) pre_lexer_instance_init, NULL };
		GType pre_lexer_type_id;
		pre_lexer_type_id = g_type_register_static (G_TYPE_OBJECT, "PreLexer", &g_define_type_info, 0);
		g_once_init_leave (&pre_lexer_type_id__volatile, pre_lexer_type_id);
	}
	return pre_lexer_type_id__volatile;
}


LexerToken*
lexer_token_construct (GType object_type)
{
	LexerToken * self = NULL;
	self = (LexerToken*) g_object_new (object_type, NULL);
	return self;
}


LexerToken*
lexer_token_new (void)
{
	return lexer_token_construct (TYPE_LEXER_TOKEN);
}


static void
lexer_token_class_init (LexerTokenClass * klass)
{
	lexer_token_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = lexer_token_finalize;
}


static void
lexer_token_instance_init (LexerToken * self)
{
}


static void
lexer_token_finalize (GObject * obj)
{
	LexerToken * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LEXER_TOKEN, LexerToken);
	_g_free0 (self->text);
	G_OBJECT_CLASS (lexer_token_parent_class)->finalize (obj);
}


GType
lexer_token_get_type (void)
{
	static volatile gsize lexer_token_type_id__volatile = 0;
	if (g_once_init_enter (&lexer_token_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LexerTokenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lexer_token_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LexerToken), 0, (GInstanceInitFunc) lexer_token_instance_init, NULL };
		GType lexer_token_type_id;
		lexer_token_type_id = g_type_register_static (G_TYPE_OBJECT, "LexerToken", &g_define_type_info, 0);
		g_once_init_leave (&lexer_token_type_id__volatile, lexer_token_type_id);
	}
	return lexer_token_type_id__volatile;
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


static gpointer
_parser_ref0 (gpointer self)
{
	return self ? parser_ref (self) : NULL;
}


Lexer*
lexer_construct (GType object_type,
                 const gchar* input,
                 Parser* parser,
                 gint number_base)
{
	Lexer * self = NULL;
	PreLexer* _tmp0_;
	Parser* _tmp1_;
	g_return_val_if_fail (input != NULL, NULL);
	g_return_val_if_fail (parser != NULL, NULL);
	self = (Lexer*) g_object_new (object_type, NULL);
	_tmp0_ = pre_lexer_new (input);
	_g_object_unref0 (self->priv->prelexer);
	self->priv->prelexer = _tmp0_;
	__g_list_free__g_object_unref0_0 (self->tokens);
	self->tokens = NULL;
	self->priv->next_token = (guint) 0;
	_tmp1_ = _parser_ref0 (parser);
	_parser_unref0 (self->priv->parser);
	self->priv->parser = _tmp1_;
	self->priv->number_base = number_base;
	return self;
}


Lexer*
lexer_new (const gchar* input,
           Parser* parser,
           gint number_base)
{
	return lexer_construct (TYPE_LEXER, input, parser, number_base);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
lexer_scan (Lexer* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		LexerToken* token = NULL;
		LexerToken* _tmp0_;
		LexerToken* _tmp1_;
		LexerToken* _tmp2_;
		LexerToken* _tmp3_;
		LexerTokenType _tmp4_;
		_tmp0_ = lexer_insert_next_token (self);
		token = _tmp0_;
		_tmp1_ = token;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		self->tokens = g_list_append (self->tokens, _tmp2_);
		_tmp3_ = token;
		_tmp4_ = _tmp3_->type;
		if (_tmp4_ == LEXER_TOKEN_TYPE_PL_EOS) {
			_g_object_unref0 (token);
			break;
		}
		_g_object_unref0 (token);
	}
}


LexerToken*
lexer_get_next_token (Lexer* self)
{
	LexerToken* result = NULL;
	guint _tmp0_;
	GList* _tmp1_;
	GList* _tmp6_;
	guint _tmp7_;
	gconstpointer _tmp8_;
	LexerToken* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->next_token;
	_tmp1_ = self->tokens;
	if (_tmp0_ >= g_list_length (_tmp1_)) {
		GList* _tmp2_;
		GList* _tmp3_;
		gconstpointer _tmp4_;
		LexerToken* _tmp5_;
		_tmp2_ = self->tokens;
		_tmp3_ = self->tokens;
		_tmp4_ = g_list_nth_data (_tmp2_, g_list_length (_tmp3_) - 1);
		_tmp5_ = _g_object_ref0 ((LexerToken*) _tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = self->tokens;
	_tmp7_ = self->priv->next_token;
	self->priv->next_token = _tmp7_ + 1;
	_tmp8_ = g_list_nth_data (_tmp6_, _tmp7_);
	_tmp9_ = _g_object_ref0 ((LexerToken*) _tmp8_);
	result = _tmp9_;
	return result;
}


void
lexer_roll_back (Lexer* self)
{
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->next_token;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->next_token;
		self->priv->next_token = _tmp1_ - 1;
	}
}


static gboolean
lexer_check_if_function (Lexer* self)
{
	gboolean result = FALSE;
	gchar* name = NULL;
	PreLexer* _tmp0_;
	gchar* _tmp1_;
	Parser* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_marked_substring (_tmp0_);
	name = _tmp1_;
	_tmp2_ = self->priv->parser;
	result = parser_function_is_defined (_tmp2_, name);
	_g_free0 (name);
	return result;
}


static gboolean
lexer_check_if_unit (Lexer* self)
{
	gboolean result = FALSE;
	gint super_count = 0;
	PreLexer* _tmp2_;
	gchar* name = NULL;
	PreLexer* _tmp3_;
	gchar* _tmp4_;
	Parser* _tmp5_;
	const gchar* _tmp6_;
	PreLexer* _tmp9_;
	gchar* _tmp10_;
	Parser* _tmp11_;
	const gchar* _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	super_count = 0;
	while (TRUE) {
		PreLexer* _tmp0_;
		gint _tmp1_;
		_tmp0_ = self->priv->prelexer;
		if (!(pre_lexer_get_next_token (_tmp0_) == LEXER_TOKEN_TYPE_PL_SUPER_DIGIT)) {
			break;
		}
		_tmp1_ = super_count;
		super_count = _tmp1_ + 1;
	}
	_tmp2_ = self->priv->prelexer;
	pre_lexer_roll_back (_tmp2_);
	_tmp3_ = self->priv->prelexer;
	_tmp4_ = pre_lexer_get_marked_substring (_tmp3_);
	name = _tmp4_;
	_tmp5_ = self->priv->parser;
	_tmp6_ = name;
	if (parser_unit_is_defined (_tmp5_, _tmp6_)) {
		result = TRUE;
		_g_free0 (name);
		return result;
	}
	while (TRUE) {
		gint _tmp7_;
		PreLexer* _tmp8_;
		_tmp7_ = super_count;
		super_count = _tmp7_ - 1;
		if (!(_tmp7_ > 0)) {
			break;
		}
		_tmp8_ = self->priv->prelexer;
		pre_lexer_roll_back (_tmp8_);
	}
	_tmp9_ = self->priv->prelexer;
	_tmp10_ = pre_lexer_get_marked_substring (_tmp9_);
	_g_free0 (name);
	name = _tmp10_;
	_tmp11_ = self->priv->parser;
	_tmp12_ = name;
	result = parser_unit_is_defined (_tmp11_, _tmp12_);
	_g_free0 (name);
	return result;
}


static gboolean
lexer_check_if_number (Lexer* self)
{
	gboolean result = FALSE;
	gint count = 0;
	gchar* text = NULL;
	PreLexer* _tmp0_;
	gchar* _tmp1_;
	Number* tmp = NULL;
	const gchar* _tmp2_;
	gint _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	count = 0;
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_marked_substring (_tmp0_);
	text = _tmp1_;
	_tmp2_ = text;
	_tmp3_ = self->priv->number_base;
	_tmp4_ = mp_set_from_string (_tmp2_, _tmp3_);
	tmp = _tmp4_;
	_tmp5_ = tmp;
	if (_tmp5_ != NULL) {
		result = TRUE;
		_g_object_unref0 (tmp);
		_g_free0 (text);
		return result;
	} else {
		while (TRUE) {
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			gint _tmp8_;
			Number* _tmp9_;
			Number* _tmp10_;
			gint _tmp11_;
			PreLexer* _tmp12_;
			PreLexer* _tmp13_;
			gchar* _tmp14_;
			_tmp6_ = text;
			if (!(g_strcmp0 (_tmp6_, "") != 0)) {
				break;
			}
			_tmp7_ = text;
			_tmp8_ = self->priv->number_base;
			_tmp9_ = mp_set_from_string (_tmp7_, _tmp8_);
			_g_object_unref0 (tmp);
			tmp = _tmp9_;
			_tmp10_ = tmp;
			if (_tmp10_ != NULL) {
				result = TRUE;
				_g_object_unref0 (tmp);
				_g_free0 (text);
				return result;
			}
			_tmp11_ = count;
			count = _tmp11_ + 1;
			_tmp12_ = self->priv->prelexer;
			pre_lexer_roll_back (_tmp12_);
			_tmp13_ = self->priv->prelexer;
			_tmp14_ = pre_lexer_get_marked_substring (_tmp13_);
			_g_free0 (text);
			text = _tmp14_;
		}
		while (TRUE) {
			gint _tmp15_;
			PreLexer* _tmp16_;
			_tmp15_ = count;
			count = _tmp15_ - 1;
			if (!(_tmp15_ > 0)) {
				break;
			}
			_tmp16_ = self->priv->prelexer;
			pre_lexer_get_next_token (_tmp16_);
		}
		result = FALSE;
		_g_object_unref0 (tmp);
		_g_free0 (text);
		return result;
	}
	_g_object_unref0 (tmp);
	_g_free0 (text);
}


static LexerToken*
lexer_insert_token (Lexer* self,
                    LexerTokenType type)
{
	LexerToken* result = NULL;
	LexerToken* token = NULL;
	LexerToken* _tmp0_;
	PreLexer* _tmp1_;
	gchar* _tmp2_;
	PreLexer* _tmp3_;
	gint _tmp4_;
	PreLexer* _tmp5_;
	gint _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = lexer_token_new ();
	token = _tmp0_;
	_tmp1_ = self->priv->prelexer;
	_tmp2_ = pre_lexer_get_marked_substring (_tmp1_);
	_g_free0 (token->text);
	token->text = _tmp2_;
	_tmp3_ = self->priv->prelexer;
	_tmp4_ = _tmp3_->mark_index;
	token->start_index = (guint) _tmp4_;
	_tmp5_ = self->priv->prelexer;
	_tmp6_ = _tmp5_->index;
	token->end_index = (guint) _tmp6_;
	token->type = type;
	result = token;
	return result;
}


static LexerToken*
lexer_insert_next_token (Lexer* self)
{
	LexerToken* result = NULL;
	PreLexer* _tmp0_;
	LexerTokenType type = 0;
	PreLexer* _tmp1_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	LexerTokenType _tmp31_;
	LexerTokenType _tmp60_;
	LexerTokenType _tmp75_;
	LexerTokenType _tmp79_;
	LexerTokenType _tmp83_;
	LexerTokenType _tmp85_;
	LexerTokenType _tmp87_;
	LexerTokenType _tmp89_;
	LexerTokenType _tmp91_;
	LexerTokenType _tmp93_;
	Parser* _tmp95_;
	PreLexer* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	PreLexer* _tmp99_;
	gint _tmp100_;
	PreLexer* _tmp101_;
	gint _tmp102_;
	LexerToken* _tmp103_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	pre_lexer_set_marker (_tmp0_);
	_tmp1_ = self->priv->prelexer;
	type = pre_lexer_get_next_token (_tmp1_);
	while (TRUE) {
		LexerTokenType _tmp2_;
		PreLexer* _tmp3_;
		PreLexer* _tmp4_;
		_tmp2_ = type;
		if (!(_tmp2_ == LEXER_TOKEN_TYPE_PL_SKIP)) {
			break;
		}
		_tmp3_ = self->priv->prelexer;
		pre_lexer_set_marker (_tmp3_);
		_tmp4_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp4_);
	}
	_tmp31_ = type;
	if (_tmp31_ == LEXER_TOKEN_TYPE_AND) {
		_tmp30_ = TRUE;
	} else {
		LexerTokenType _tmp32_;
		_tmp32_ = type;
		_tmp30_ = _tmp32_ == LEXER_TOKEN_TYPE_OR;
	}
	if (_tmp30_) {
		_tmp29_ = TRUE;
	} else {
		LexerTokenType _tmp33_;
		_tmp33_ = type;
		_tmp29_ = _tmp33_ == LEXER_TOKEN_TYPE_XOR;
	}
	if (_tmp29_) {
		_tmp28_ = TRUE;
	} else {
		LexerTokenType _tmp34_;
		_tmp34_ = type;
		_tmp28_ = _tmp34_ == LEXER_TOKEN_TYPE_NOT;
	}
	if (_tmp28_) {
		_tmp27_ = TRUE;
	} else {
		LexerTokenType _tmp35_;
		_tmp35_ = type;
		_tmp27_ = _tmp35_ == LEXER_TOKEN_TYPE_ADD;
	}
	if (_tmp27_) {
		_tmp26_ = TRUE;
	} else {
		LexerTokenType _tmp36_;
		_tmp36_ = type;
		_tmp26_ = _tmp36_ == LEXER_TOKEN_TYPE_SUBTRACT;
	}
	if (_tmp26_) {
		_tmp25_ = TRUE;
	} else {
		LexerTokenType _tmp37_;
		_tmp37_ = type;
		_tmp25_ = _tmp37_ == LEXER_TOKEN_TYPE_MULTIPLY;
	}
	if (_tmp25_) {
		_tmp24_ = TRUE;
	} else {
		LexerTokenType _tmp38_;
		_tmp38_ = type;
		_tmp24_ = _tmp38_ == LEXER_TOKEN_TYPE_DIVIDE;
	}
	if (_tmp24_) {
		_tmp23_ = TRUE;
	} else {
		LexerTokenType _tmp39_;
		_tmp39_ = type;
		_tmp23_ = _tmp39_ == LEXER_TOKEN_TYPE_L_FLOOR;
	}
	if (_tmp23_) {
		_tmp22_ = TRUE;
	} else {
		LexerTokenType _tmp40_;
		_tmp40_ = type;
		_tmp22_ = _tmp40_ == LEXER_TOKEN_TYPE_R_FLOOR;
	}
	if (_tmp22_) {
		_tmp21_ = TRUE;
	} else {
		LexerTokenType _tmp41_;
		_tmp41_ = type;
		_tmp21_ = _tmp41_ == LEXER_TOKEN_TYPE_L_CEILING;
	}
	if (_tmp21_) {
		_tmp20_ = TRUE;
	} else {
		LexerTokenType _tmp42_;
		_tmp42_ = type;
		_tmp20_ = _tmp42_ == LEXER_TOKEN_TYPE_R_CEILING;
	}
	if (_tmp20_) {
		_tmp19_ = TRUE;
	} else {
		LexerTokenType _tmp43_;
		_tmp43_ = type;
		_tmp19_ = _tmp43_ == LEXER_TOKEN_TYPE_ROOT;
	}
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		LexerTokenType _tmp44_;
		_tmp44_ = type;
		_tmp18_ = _tmp44_ == LEXER_TOKEN_TYPE_ROOT_3;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		LexerTokenType _tmp45_;
		_tmp45_ = type;
		_tmp17_ = _tmp45_ == LEXER_TOKEN_TYPE_ROOT_4;
	}
	if (_tmp17_) {
		_tmp16_ = TRUE;
	} else {
		LexerTokenType _tmp46_;
		_tmp46_ = type;
		_tmp16_ = _tmp46_ == LEXER_TOKEN_TYPE_ASSIGN;
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		LexerTokenType _tmp47_;
		_tmp47_ = type;
		_tmp15_ = _tmp47_ == LEXER_TOKEN_TYPE_L_R_BRACKET;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		LexerTokenType _tmp48_;
		_tmp48_ = type;
		_tmp14_ = _tmp48_ == LEXER_TOKEN_TYPE_R_R_BRACKET;
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		LexerTokenType _tmp49_;
		_tmp49_ = type;
		_tmp13_ = _tmp49_ == LEXER_TOKEN_TYPE_L_S_BRACKET;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		LexerTokenType _tmp50_;
		_tmp50_ = type;
		_tmp12_ = _tmp50_ == LEXER_TOKEN_TYPE_R_S_BRACKET;
	}
	if (_tmp12_) {
		_tmp11_ = TRUE;
	} else {
		LexerTokenType _tmp51_;
		_tmp51_ = type;
		_tmp11_ = _tmp51_ == LEXER_TOKEN_TYPE_L_C_BRACKET;
	}
	if (_tmp11_) {
		_tmp10_ = TRUE;
	} else {
		LexerTokenType _tmp52_;
		_tmp52_ = type;
		_tmp10_ = _tmp52_ == LEXER_TOKEN_TYPE_R_C_BRACKET;
	}
	if (_tmp10_) {
		_tmp9_ = TRUE;
	} else {
		LexerTokenType _tmp53_;
		_tmp53_ = type;
		_tmp9_ = _tmp53_ == LEXER_TOKEN_TYPE_ABS;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		LexerTokenType _tmp54_;
		_tmp54_ = type;
		_tmp8_ = _tmp54_ == LEXER_TOKEN_TYPE_POWER;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		LexerTokenType _tmp55_;
		_tmp55_ = type;
		_tmp7_ = _tmp55_ == LEXER_TOKEN_TYPE_FACTORIAL;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		LexerTokenType _tmp56_;
		_tmp56_ = type;
		_tmp6_ = _tmp56_ == LEXER_TOKEN_TYPE_PERCENTAGE;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		LexerTokenType _tmp57_;
		_tmp57_ = type;
		_tmp5_ = _tmp57_ == LEXER_TOKEN_TYPE_ARGUMENT_SEPARATOR;
	}
	if (_tmp5_) {
		LexerTokenType _tmp58_;
		LexerToken* _tmp59_;
		_tmp58_ = type;
		_tmp59_ = lexer_insert_token (self, _tmp58_);
		result = _tmp59_;
		return result;
	}
	_tmp60_ = type;
	if (_tmp60_ == LEXER_TOKEN_TYPE_PL_SUPER_MINUS) {
		PreLexer* _tmp61_;
		LexerTokenType _tmp62_;
		PreLexer* _tmp73_;
		LexerToken* _tmp74_;
		_tmp61_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp61_);
		_tmp62_ = type;
		if (_tmp62_ != LEXER_TOKEN_TYPE_PL_SUPER_DIGIT) {
			Parser* _tmp63_;
			PreLexer* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			PreLexer* _tmp67_;
			gint _tmp68_;
			PreLexer* _tmp69_;
			gint _tmp70_;
			LexerToken* _tmp71_;
			_tmp63_ = self->priv->parser;
			_tmp64_ = self->priv->prelexer;
			_tmp65_ = pre_lexer_get_marked_substring (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = self->priv->prelexer;
			_tmp68_ = _tmp67_->mark_index;
			_tmp69_ = self->priv->prelexer;
			_tmp70_ = _tmp69_->index;
			parser_set_error (_tmp63_, ERROR_CODE_MP, _tmp66_, (guint) _tmp68_, (guint) _tmp70_);
			_g_free0 (_tmp66_);
			_tmp71_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
			result = _tmp71_;
			return result;
		}
		while (TRUE) {
			PreLexer* _tmp72_;
			_tmp72_ = self->priv->prelexer;
			if (!(pre_lexer_get_next_token (_tmp72_) == LEXER_TOKEN_TYPE_PL_SUPER_DIGIT)) {
				break;
			}
		}
		_tmp73_ = self->priv->prelexer;
		pre_lexer_roll_back (_tmp73_);
		_tmp74_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NSUP_NUMBER);
		result = _tmp74_;
		return result;
	}
	_tmp75_ = type;
	if (_tmp75_ == LEXER_TOKEN_TYPE_PL_SUPER_DIGIT) {
		PreLexer* _tmp77_;
		LexerToken* _tmp78_;
		while (TRUE) {
			PreLexer* _tmp76_;
			_tmp76_ = self->priv->prelexer;
			if (!(pre_lexer_get_next_token (_tmp76_) == LEXER_TOKEN_TYPE_PL_SUPER_DIGIT)) {
				break;
			}
		}
		_tmp77_ = self->priv->prelexer;
		pre_lexer_roll_back (_tmp77_);
		_tmp78_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_SUP_NUMBER);
		result = _tmp78_;
		return result;
	}
	_tmp79_ = type;
	if (_tmp79_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT) {
		PreLexer* _tmp81_;
		LexerToken* _tmp82_;
		while (TRUE) {
			PreLexer* _tmp80_;
			_tmp80_ = self->priv->prelexer;
			if (!(pre_lexer_get_next_token (_tmp80_) == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
				break;
			}
		}
		_tmp81_ = self->priv->prelexer;
		pre_lexer_roll_back (_tmp81_);
		_tmp82_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_SUB_NUMBER);
		result = _tmp82_;
		return result;
	}
	_tmp83_ = type;
	if (_tmp83_ == LEXER_TOKEN_TYPE_PL_FRACTION) {
		LexerToken* _tmp84_;
		_tmp84_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
		result = _tmp84_;
		return result;
	}
	_tmp85_ = type;
	if (_tmp85_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
		LexerToken* _tmp86_;
		_tmp86_ = lexer_insert_digit (self);
		result = _tmp86_;
		return result;
	}
	_tmp87_ = type;
	if (_tmp87_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
		LexerToken* _tmp88_;
		_tmp88_ = lexer_insert_decimal (self);
		result = _tmp88_;
		return result;
	}
	_tmp89_ = type;
	if (_tmp89_ == LEXER_TOKEN_TYPE_PL_HEX) {
		LexerToken* _tmp90_;
		_tmp90_ = lexer_insert_hex (self);
		result = _tmp90_;
		return result;
	}
	_tmp91_ = type;
	if (_tmp91_ == LEXER_TOKEN_TYPE_PL_LETTER) {
		LexerToken* _tmp92_;
		_tmp92_ = lexer_insert_letter (self);
		result = _tmp92_;
		return result;
	}
	_tmp93_ = type;
	if (_tmp93_ == LEXER_TOKEN_TYPE_PL_EOS) {
		LexerToken* _tmp94_;
		_tmp94_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_PL_EOS);
		result = _tmp94_;
		return result;
	}
	_tmp95_ = self->priv->parser;
	_tmp96_ = self->priv->prelexer;
	_tmp97_ = pre_lexer_get_marked_substring (_tmp96_);
	_tmp98_ = _tmp97_;
	_tmp99_ = self->priv->prelexer;
	_tmp100_ = _tmp99_->mark_index;
	_tmp101_ = self->priv->prelexer;
	_tmp102_ = _tmp101_->index;
	parser_set_error (_tmp95_, ERROR_CODE_INVALID, _tmp98_, (guint) _tmp100_, (guint) _tmp102_);
	_g_free0 (_tmp98_);
	_tmp103_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
	result = _tmp103_;
	return result;
}


static LexerToken*
lexer_insert_digit (Lexer* self)
{
	LexerToken* result = NULL;
	LexerTokenType type = 0;
	PreLexer* _tmp0_;
	LexerTokenType _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	type = pre_lexer_get_next_token (_tmp0_);
	while (TRUE) {
		LexerTokenType _tmp1_;
		PreLexer* _tmp2_;
		_tmp1_ = type;
		if (!(_tmp1_ == LEXER_TOKEN_TYPE_PL_DIGIT)) {
			break;
		}
		_tmp2_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp2_);
	}
	_tmp3_ = type;
	if (_tmp3_ == LEXER_TOKEN_TYPE_PL_FRACTION) {
		LexerToken* _tmp4_;
		_tmp4_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
		result = _tmp4_;
		return result;
	} else {
		LexerTokenType _tmp5_;
		_tmp5_ = type;
		if (_tmp5_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT) {
			PreLexer* _tmp7_;
			LexerToken* _tmp8_;
			while (TRUE) {
				PreLexer* _tmp6_;
				_tmp6_ = self->priv->prelexer;
				if (!(pre_lexer_get_next_token (_tmp6_) == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
					break;
				}
			}
			_tmp7_ = self->priv->prelexer;
			pre_lexer_roll_back (_tmp7_);
			_tmp8_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
			result = _tmp8_;
			return result;
		} else {
			LexerTokenType _tmp9_;
			_tmp9_ = type;
			if (_tmp9_ == LEXER_TOKEN_TYPE_PL_DEGREE) {
				PreLexer* _tmp10_;
				LexerTokenType _tmp11_;
				_tmp10_ = self->priv->prelexer;
				type = pre_lexer_get_next_token (_tmp10_);
				_tmp11_ = type;
				if (_tmp11_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
					LexerTokenType _tmp14_;
					while (TRUE) {
						PreLexer* _tmp12_;
						LexerTokenType _tmp13_;
						_tmp12_ = self->priv->prelexer;
						type = pre_lexer_get_next_token (_tmp12_);
						_tmp13_ = type;
						if (!(_tmp13_ == LEXER_TOKEN_TYPE_PL_DIGIT)) {
							break;
						}
					}
					_tmp14_ = type;
					if (_tmp14_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
						LexerToken* _tmp15_;
						_tmp15_ = lexer_insert_angle_num_dm (self);
						result = _tmp15_;
						return result;
					} else {
						LexerTokenType _tmp16_;
						_tmp16_ = type;
						if (_tmp16_ == LEXER_TOKEN_TYPE_PL_MINUTE) {
							PreLexer* _tmp17_;
							LexerTokenType _tmp18_;
							_tmp17_ = self->priv->prelexer;
							type = pre_lexer_get_next_token (_tmp17_);
							_tmp18_ = type;
							if (_tmp18_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
								LexerTokenType _tmp21_;
								while (TRUE) {
									PreLexer* _tmp19_;
									LexerTokenType _tmp20_;
									_tmp19_ = self->priv->prelexer;
									type = pre_lexer_get_next_token (_tmp19_);
									_tmp20_ = type;
									if (!(_tmp20_ == LEXER_TOKEN_TYPE_PL_DIGIT)) {
										break;
									}
								}
								_tmp21_ = type;
								if (_tmp21_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
									LexerToken* _tmp22_;
									_tmp22_ = lexer_insert_angle_num_dms (self);
									result = _tmp22_;
									return result;
								} else {
									LexerTokenType _tmp23_;
									_tmp23_ = type;
									if (_tmp23_ == LEXER_TOKEN_TYPE_PL_SECOND) {
										LexerToken* _tmp24_;
										_tmp24_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
										result = _tmp24_;
										return result;
									} else {
										Parser* _tmp25_;
										PreLexer* _tmp26_;
										gchar* _tmp27_;
										gchar* _tmp28_;
										PreLexer* _tmp29_;
										gint _tmp30_;
										PreLexer* _tmp31_;
										gint _tmp32_;
										LexerToken* _tmp33_;
										_tmp25_ = self->priv->parser;
										_tmp26_ = self->priv->prelexer;
										_tmp27_ = pre_lexer_get_marked_substring (_tmp26_);
										_tmp28_ = _tmp27_;
										_tmp29_ = self->priv->prelexer;
										_tmp30_ = _tmp29_->mark_index;
										_tmp31_ = self->priv->prelexer;
										_tmp32_ = _tmp31_->index;
										parser_set_error (_tmp25_, ERROR_CODE_MP, _tmp28_, (guint) _tmp30_, (guint) _tmp32_);
										_g_free0 (_tmp28_);
										_tmp33_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
										result = _tmp33_;
										return result;
									}
								}
							} else {
								LexerTokenType _tmp34_;
								_tmp34_ = type;
								if (_tmp34_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
									LexerToken* _tmp35_;
									_tmp35_ = lexer_insert_angle_num_dms (self);
									result = _tmp35_;
									return result;
								} else {
									PreLexer* _tmp36_;
									LexerToken* _tmp37_;
									_tmp36_ = self->priv->prelexer;
									pre_lexer_roll_back (_tmp36_);
									_tmp37_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
									result = _tmp37_;
									return result;
								}
							}
						} else {
							Parser* _tmp38_;
							PreLexer* _tmp39_;
							gchar* _tmp40_;
							gchar* _tmp41_;
							PreLexer* _tmp42_;
							gint _tmp43_;
							PreLexer* _tmp44_;
							gint _tmp45_;
							LexerToken* _tmp46_;
							_tmp38_ = self->priv->parser;
							_tmp39_ = self->priv->prelexer;
							_tmp40_ = pre_lexer_get_marked_substring (_tmp39_);
							_tmp41_ = _tmp40_;
							_tmp42_ = self->priv->prelexer;
							_tmp43_ = _tmp42_->mark_index;
							_tmp44_ = self->priv->prelexer;
							_tmp45_ = _tmp44_->index;
							parser_set_error (_tmp38_, ERROR_CODE_MP, _tmp41_, (guint) _tmp43_, (guint) _tmp45_);
							_g_free0 (_tmp41_);
							_tmp46_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
							result = _tmp46_;
							return result;
						}
					}
				} else {
					LexerTokenType _tmp47_;
					_tmp47_ = type;
					if (_tmp47_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
						LexerToken* _tmp48_;
						_tmp48_ = lexer_insert_angle_num_dm (self);
						result = _tmp48_;
						return result;
					} else {
						LexerToken* _tmp49_;
						_tmp49_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
						result = _tmp49_;
						return result;
					}
				}
			} else {
				LexerTokenType _tmp50_;
				_tmp50_ = type;
				if (_tmp50_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
					LexerToken* _tmp51_;
					_tmp51_ = lexer_insert_decimal (self);
					result = _tmp51_;
					return result;
				} else {
					LexerTokenType _tmp52_;
					_tmp52_ = type;
					if (_tmp52_ == LEXER_TOKEN_TYPE_PL_HEX) {
						LexerToken* _tmp53_;
						_tmp53_ = lexer_insert_hex_dec (self);
						result = _tmp53_;
						return result;
					} else {
						PreLexer* _tmp54_;
						LexerToken* _tmp55_;
						_tmp54_ = self->priv->prelexer;
						pre_lexer_roll_back (_tmp54_);
						_tmp55_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
						result = _tmp55_;
						return result;
					}
				}
			}
		}
	}
}


static LexerToken*
lexer_insert_angle_num_dm (Lexer* self)
{
	LexerToken* result = NULL;
	LexerTokenType type = 0;
	PreLexer* _tmp0_;
	LexerTokenType _tmp1_;
	PreLexer* _tmp12_;
	LexerTokenType _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	type = pre_lexer_get_next_token (_tmp0_);
	_tmp1_ = type;
	if (_tmp1_ != LEXER_TOKEN_TYPE_PL_DIGIT) {
		Parser* _tmp2_;
		PreLexer* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		PreLexer* _tmp6_;
		gint _tmp7_;
		PreLexer* _tmp8_;
		gint _tmp9_;
		LexerToken* _tmp10_;
		_tmp2_ = self->priv->parser;
		_tmp3_ = self->priv->prelexer;
		_tmp4_ = pre_lexer_get_marked_substring (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->prelexer;
		_tmp7_ = _tmp6_->mark_index;
		_tmp8_ = self->priv->prelexer;
		_tmp9_ = _tmp8_->index;
		parser_set_error (_tmp2_, ERROR_CODE_MP, _tmp5_, (guint) _tmp7_, (guint) _tmp9_);
		_g_free0 (_tmp5_);
		_tmp10_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
		result = _tmp10_;
		return result;
	}
	while (TRUE) {
		LexerTokenType _tmp11_;
		_tmp11_ = type;
		if (!(_tmp11_ == LEXER_TOKEN_TYPE_PL_DIGIT)) {
			break;
		}
	}
	_tmp12_ = self->priv->prelexer;
	type = pre_lexer_get_next_token (_tmp12_);
	_tmp13_ = type;
	if (_tmp13_ == LEXER_TOKEN_TYPE_PL_MINUTE) {
		LexerToken* _tmp14_;
		_tmp14_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
		result = _tmp14_;
		return result;
	} else {
		Parser* _tmp15_;
		PreLexer* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		PreLexer* _tmp19_;
		gint _tmp20_;
		PreLexer* _tmp21_;
		gint _tmp22_;
		LexerToken* _tmp23_;
		_tmp15_ = self->priv->parser;
		_tmp16_ = self->priv->prelexer;
		_tmp17_ = pre_lexer_get_marked_substring (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->prelexer;
		_tmp20_ = _tmp19_->mark_index;
		_tmp21_ = self->priv->prelexer;
		_tmp22_ = _tmp21_->index;
		parser_set_error (_tmp15_, ERROR_CODE_MP, _tmp18_, (guint) _tmp20_, (guint) _tmp22_);
		_g_free0 (_tmp18_);
		_tmp23_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
		result = _tmp23_;
		return result;
	}
}


static LexerToken*
lexer_insert_angle_num_dms (Lexer* self)
{
	LexerToken* result = NULL;
	LexerTokenType type = 0;
	PreLexer* _tmp0_;
	LexerTokenType _tmp1_;
	LexerTokenType _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	type = pre_lexer_get_next_token (_tmp0_);
	_tmp1_ = type;
	if (_tmp1_ != LEXER_TOKEN_TYPE_PL_DIGIT) {
		Parser* _tmp2_;
		PreLexer* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		PreLexer* _tmp6_;
		gint _tmp7_;
		PreLexer* _tmp8_;
		gint _tmp9_;
		LexerToken* _tmp10_;
		_tmp2_ = self->priv->parser;
		_tmp3_ = self->priv->prelexer;
		_tmp4_ = pre_lexer_get_marked_substring (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->prelexer;
		_tmp7_ = _tmp6_->mark_index;
		_tmp8_ = self->priv->prelexer;
		_tmp9_ = _tmp8_->index;
		parser_set_error (_tmp2_, ERROR_CODE_MP, _tmp5_, (guint) _tmp7_, (guint) _tmp9_);
		_g_free0 (_tmp5_);
		_tmp10_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
		result = _tmp10_;
		return result;
	}
	while (TRUE) {
		PreLexer* _tmp11_;
		LexerTokenType _tmp12_;
		_tmp11_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp11_);
		_tmp12_ = type;
		if (!(_tmp12_ == LEXER_TOKEN_TYPE_PL_DIGIT)) {
			break;
		}
	}
	_tmp13_ = type;
	if (_tmp13_ == LEXER_TOKEN_TYPE_PL_SECOND) {
		LexerToken* _tmp14_;
		_tmp14_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
		result = _tmp14_;
		return result;
	} else {
		Parser* _tmp15_;
		PreLexer* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		PreLexer* _tmp19_;
		gint _tmp20_;
		PreLexer* _tmp21_;
		gint _tmp22_;
		LexerToken* _tmp23_;
		_tmp15_ = self->priv->parser;
		_tmp16_ = self->priv->prelexer;
		_tmp17_ = pre_lexer_get_marked_substring (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->prelexer;
		_tmp20_ = _tmp19_->mark_index;
		_tmp21_ = self->priv->prelexer;
		_tmp22_ = _tmp21_->index;
		parser_set_error (_tmp15_, ERROR_CODE_MP, _tmp18_, (guint) _tmp20_, (guint) _tmp22_);
		_g_free0 (_tmp18_);
		_tmp23_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
		result = _tmp23_;
		return result;
	}
}


static LexerToken*
lexer_insert_decimal (Lexer* self)
{
	LexerToken* result = NULL;
	LexerTokenType type = 0;
	PreLexer* _tmp0_;
	LexerTokenType _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	type = pre_lexer_get_next_token (_tmp0_);
	_tmp1_ = type;
	if (_tmp1_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
		LexerTokenType _tmp4_;
		while (TRUE) {
			PreLexer* _tmp2_;
			LexerTokenType _tmp3_;
			_tmp2_ = self->priv->prelexer;
			type = pre_lexer_get_next_token (_tmp2_);
			_tmp3_ = type;
			if (!(_tmp3_ == LEXER_TOKEN_TYPE_PL_DIGIT)) {
				break;
			}
		}
		_tmp4_ = type;
		if (_tmp4_ == LEXER_TOKEN_TYPE_PL_DEGREE) {
			LexerToken* _tmp5_;
			_tmp5_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
			result = _tmp5_;
			return result;
		} else {
			LexerTokenType _tmp6_;
			_tmp6_ = type;
			if (_tmp6_ == LEXER_TOKEN_TYPE_PL_HEX) {
				LexerToken* _tmp7_;
				_tmp7_ = lexer_insert_decimal_hex (self);
				result = _tmp7_;
				return result;
			} else {
				LexerTokenType _tmp8_;
				_tmp8_ = type;
				if (_tmp8_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT) {
					PreLexer* _tmp10_;
					LexerToken* _tmp11_;
					while (TRUE) {
						PreLexer* _tmp9_;
						_tmp9_ = self->priv->prelexer;
						if (!(pre_lexer_get_next_token (_tmp9_) == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
							break;
						}
					}
					_tmp10_ = self->priv->prelexer;
					pre_lexer_roll_back (_tmp10_);
					_tmp11_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
					result = _tmp11_;
					return result;
				} else {
					PreLexer* _tmp12_;
					LexerToken* _tmp13_;
					_tmp12_ = self->priv->prelexer;
					pre_lexer_roll_back (_tmp12_);
					_tmp13_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
					result = _tmp13_;
					return result;
				}
			}
		}
	} else {
		LexerTokenType _tmp14_;
		_tmp14_ = type;
		if (_tmp14_ == LEXER_TOKEN_TYPE_PL_HEX) {
			LexerToken* _tmp15_;
			_tmp15_ = lexer_insert_decimal_hex (self);
			result = _tmp15_;
			return result;
		} else {
			Parser* _tmp16_;
			PreLexer* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			PreLexer* _tmp20_;
			gint _tmp21_;
			PreLexer* _tmp22_;
			gint _tmp23_;
			LexerToken* _tmp24_;
			_tmp16_ = self->priv->parser;
			_tmp17_ = self->priv->prelexer;
			_tmp18_ = pre_lexer_get_marked_substring (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = self->priv->prelexer;
			_tmp21_ = _tmp20_->mark_index;
			_tmp22_ = self->priv->prelexer;
			_tmp23_ = _tmp22_->index;
			parser_set_error (_tmp16_, ERROR_CODE_MP, _tmp19_, (guint) _tmp21_, (guint) _tmp23_);
			_g_free0 (_tmp19_);
			_tmp24_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
			result = _tmp24_;
			return result;
		}
	}
}


static LexerToken*
lexer_insert_hex (Lexer* self)
{
	LexerToken* result = NULL;
	LexerTokenType type = 0;
	PreLexer* _tmp0_;
	LexerTokenType _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	type = pre_lexer_get_next_token (_tmp0_);
	while (TRUE) {
		LexerTokenType _tmp1_;
		PreLexer* _tmp2_;
		_tmp1_ = type;
		if (!(_tmp1_ == LEXER_TOKEN_TYPE_PL_HEX)) {
			break;
		}
		_tmp2_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp2_);
	}
	_tmp3_ = type;
	if (_tmp3_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
		LexerToken* _tmp4_;
		_tmp4_ = lexer_insert_hex_dec (self);
		result = _tmp4_;
		return result;
	} else {
		LexerTokenType _tmp5_;
		_tmp5_ = type;
		if (_tmp5_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
			LexerToken* _tmp6_;
			_tmp6_ = lexer_insert_decimal_hex (self);
			result = _tmp6_;
			return result;
		} else {
			LexerTokenType _tmp7_;
			_tmp7_ = type;
			if (_tmp7_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT) {
				PreLexer* _tmp9_;
				while (TRUE) {
					PreLexer* _tmp8_;
					_tmp8_ = self->priv->prelexer;
					if (!(pre_lexer_get_next_token (_tmp8_) == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
						break;
					}
				}
				_tmp9_ = self->priv->prelexer;
				pre_lexer_roll_back (_tmp9_);
				if (lexer_check_if_number (self)) {
					LexerToken* _tmp10_;
					_tmp10_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
					result = _tmp10_;
					return result;
				} else {
					if (lexer_check_if_function (self)) {
						LexerToken* _tmp11_;
						_tmp11_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_FUNCTION);
						result = _tmp11_;
						return result;
					} else {
						if (lexer_check_if_unit (self)) {
							LexerToken* _tmp12_;
							_tmp12_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNIT);
							result = _tmp12_;
							return result;
						} else {
							LexerToken* _tmp13_;
							_tmp13_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_VARIABLE);
							result = _tmp13_;
							return result;
						}
					}
				}
			} else {
				LexerTokenType _tmp14_;
				_tmp14_ = type;
				if (_tmp14_ == LEXER_TOKEN_TYPE_PL_LETTER) {
					LexerToken* _tmp15_;
					_tmp15_ = lexer_insert_letter (self);
					result = _tmp15_;
					return result;
				} else {
					PreLexer* _tmp16_;
					_tmp16_ = self->priv->prelexer;
					pre_lexer_roll_back (_tmp16_);
					if (lexer_check_if_number (self)) {
						LexerToken* _tmp17_;
						_tmp17_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
						result = _tmp17_;
						return result;
					} else {
						if (lexer_check_if_function (self)) {
							LexerToken* _tmp18_;
							_tmp18_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_FUNCTION);
							result = _tmp18_;
							return result;
						} else {
							if (lexer_check_if_unit (self)) {
								LexerToken* _tmp19_;
								_tmp19_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNIT);
								result = _tmp19_;
								return result;
							} else {
								LexerToken* _tmp20_;
								_tmp20_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_VARIABLE);
								result = _tmp20_;
								return result;
							}
						}
					}
				}
			}
		}
	}
}


static LexerToken*
lexer_insert_hex_dec (Lexer* self)
{
	LexerToken* result = NULL;
	LexerTokenType type = 0;
	PreLexer* _tmp0_;
	LexerTokenType _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	type = pre_lexer_get_next_token (_tmp0_);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		LexerTokenType _tmp2_;
		PreLexer* _tmp4_;
		_tmp2_ = type;
		if (_tmp2_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
			_tmp1_ = TRUE;
		} else {
			LexerTokenType _tmp3_;
			_tmp3_ = type;
			_tmp1_ = _tmp3_ == LEXER_TOKEN_TYPE_PL_HEX;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp4_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp4_);
	}
	_tmp5_ = type;
	if (_tmp5_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
		LexerToken* _tmp6_;
		_tmp6_ = lexer_insert_decimal_hex (self);
		result = _tmp6_;
		return result;
	} else {
		LexerTokenType _tmp7_;
		_tmp7_ = type;
		if (_tmp7_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT) {
			PreLexer* _tmp9_;
			LexerToken* _tmp10_;
			while (TRUE) {
				PreLexer* _tmp8_;
				_tmp8_ = self->priv->prelexer;
				if (!(pre_lexer_get_next_token (_tmp8_) == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
					break;
				}
			}
			_tmp9_ = self->priv->prelexer;
			pre_lexer_roll_back (_tmp9_);
			_tmp10_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
			result = _tmp10_;
			return result;
		} else {
			Parser* _tmp12_;
			PreLexer* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			PreLexer* _tmp16_;
			gint _tmp17_;
			PreLexer* _tmp18_;
			gint _tmp19_;
			LexerToken* _tmp20_;
			if (lexer_check_if_number (self)) {
				LexerToken* _tmp11_;
				_tmp11_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
				result = _tmp11_;
				return result;
			}
			_tmp12_ = self->priv->parser;
			_tmp13_ = self->priv->prelexer;
			_tmp14_ = pre_lexer_get_marked_substring (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = self->priv->prelexer;
			_tmp17_ = _tmp16_->mark_index;
			_tmp18_ = self->priv->prelexer;
			_tmp19_ = _tmp18_->index;
			parser_set_error (_tmp12_, ERROR_CODE_MP, _tmp15_, (guint) _tmp17_, (guint) _tmp19_);
			_g_free0 (_tmp15_);
			_tmp20_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
			result = _tmp20_;
			return result;
		}
	}
}


static LexerToken*
lexer_insert_decimal_hex (Lexer* self)
{
	LexerToken* result = NULL;
	LexerTokenType type = 0;
	PreLexer* _tmp0_;
	PreLexer* _tmp7_;
	LexerToken* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	type = pre_lexer_get_next_token (_tmp0_);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		LexerTokenType _tmp2_;
		PreLexer* _tmp4_;
		_tmp2_ = type;
		if (_tmp2_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
			_tmp1_ = TRUE;
		} else {
			LexerTokenType _tmp3_;
			_tmp3_ = type;
			_tmp1_ = _tmp3_ == LEXER_TOKEN_TYPE_PL_HEX;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp4_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp4_);
	}
	while (TRUE) {
		LexerTokenType _tmp5_;
		PreLexer* _tmp6_;
		_tmp5_ = type;
		if (!(_tmp5_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
			break;
		}
		_tmp6_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp6_);
	}
	_tmp7_ = self->priv->prelexer;
	pre_lexer_roll_back (_tmp7_);
	_tmp8_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
	result = _tmp8_;
	return result;
}


static LexerToken*
lexer_insert_letter (Lexer* self)
{
	LexerToken* result = NULL;
	LexerTokenType type = 0;
	PreLexer* _tmp0_;
	PreLexer* _tmp7_;
	gchar* name = NULL;
	PreLexer* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp15_;
	const gchar* _tmp17_;
	const gchar* _tmp19_;
	const gchar* _tmp21_;
	const gchar* _tmp23_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	type = pre_lexer_get_next_token (_tmp0_);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		LexerTokenType _tmp2_;
		PreLexer* _tmp4_;
		_tmp2_ = type;
		if (_tmp2_ == LEXER_TOKEN_TYPE_PL_LETTER) {
			_tmp1_ = TRUE;
		} else {
			LexerTokenType _tmp3_;
			_tmp3_ = type;
			_tmp1_ = _tmp3_ == LEXER_TOKEN_TYPE_PL_HEX;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp4_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp4_);
	}
	while (TRUE) {
		LexerTokenType _tmp5_;
		PreLexer* _tmp6_;
		_tmp5_ = type;
		if (!(_tmp5_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
			break;
		}
		_tmp6_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp6_);
	}
	_tmp7_ = self->priv->prelexer;
	pre_lexer_roll_back (_tmp7_);
	_tmp8_ = self->priv->prelexer;
	_tmp9_ = pre_lexer_get_marked_substring (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_utf8_strdown (_tmp10_, (gssize) -1);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	name = _tmp12_;
	_tmp13_ = name;
	if (g_strcmp0 (_tmp13_, "mod") == 0) {
		LexerToken* _tmp14_;
		_tmp14_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_MOD);
		result = _tmp14_;
		_g_free0 (name);
		return result;
	}
	_tmp15_ = name;
	if (g_strcmp0 (_tmp15_, "and") == 0) {
		LexerToken* _tmp16_;
		_tmp16_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_AND);
		result = _tmp16_;
		_g_free0 (name);
		return result;
	}
	_tmp17_ = name;
	if (g_strcmp0 (_tmp17_, "or") == 0) {
		LexerToken* _tmp18_;
		_tmp18_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_OR);
		result = _tmp18_;
		_g_free0 (name);
		return result;
	}
	_tmp19_ = name;
	if (g_strcmp0 (_tmp19_, "xor") == 0) {
		LexerToken* _tmp20_;
		_tmp20_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_XOR);
		result = _tmp20_;
		_g_free0 (name);
		return result;
	}
	_tmp21_ = name;
	if (g_strcmp0 (_tmp21_, "not") == 0) {
		LexerToken* _tmp22_;
		_tmp22_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NOT);
		result = _tmp22_;
		_g_free0 (name);
		return result;
	}
	_tmp23_ = name;
	if (g_strcmp0 (_tmp23_, "in") == 0) {
		LexerToken* _tmp24_;
		_tmp24_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_IN);
		result = _tmp24_;
		_g_free0 (name);
		return result;
	}
	if (lexer_check_if_function (self)) {
		LexerToken* _tmp25_;
		_tmp25_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_FUNCTION);
		result = _tmp25_;
		_g_free0 (name);
		return result;
	}
	if (lexer_check_if_unit (self)) {
		LexerToken* _tmp26_;
		_tmp26_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNIT);
		result = _tmp26_;
		_g_free0 (name);
		return result;
	} else {
		LexerToken* _tmp27_;
		_tmp27_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_VARIABLE);
		result = _tmp27_;
		_g_free0 (name);
		return result;
	}
	_g_free0 (name);
}


static void
lexer_class_init (LexerClass * klass)
{
	lexer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LexerPrivate));
	G_OBJECT_CLASS (klass)->finalize = lexer_finalize;
}


static void
lexer_instance_init (Lexer * self)
{
	self->priv = LEXER_GET_PRIVATE (self);
}


static void
lexer_finalize (GObject * obj)
{
	Lexer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LEXER, Lexer);
	_parser_unref0 (self->priv->parser);
	_g_object_unref0 (self->priv->prelexer);
	__g_list_free__g_object_unref0_0 (self->tokens);
	G_OBJECT_CLASS (lexer_parent_class)->finalize (obj);
}


GType
lexer_get_type (void)
{
	static volatile gsize lexer_type_id__volatile = 0;
	if (g_once_init_enter (&lexer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LexerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lexer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Lexer), 0, (GInstanceInitFunc) lexer_instance_init, NULL };
		GType lexer_type_id;
		lexer_type_id = g_type_register_static (G_TYPE_OBJECT, "Lexer", &g_define_type_info, 0);
		g_once_init_leave (&lexer_type_id__volatile, lexer_type_id);
	}
	return lexer_type_id__volatile;
}



